// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dialogflow provides access to the Dialogflow API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dialogflow/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/dialogflow/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/dialogflow/v3beta1"
//   ...
//   ctx := context.Background()
//   dialogflowService, err := dialogflow.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   dialogflowService, err := dialogflow.NewService(ctx, option.WithScopes(dialogflow.DialogflowScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   dialogflowService, err := dialogflow.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   dialogflowService, err := dialogflow.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package dialogflow // import "google.golang.org/api/dialogflow/v3beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "dialogflow:v3beta1"
const apiName = "dialogflow"
const apiVersion = "v3beta1"
const basePath = "https://dialogflow.googleapis.com/"
const mtlsBasePath = "https://dialogflow.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View, manage and query your Dialogflow agents
	DialogflowScope = "https://www.googleapis.com/auth/dialogflow"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/dialogflow",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agents = NewProjectsLocationsAgentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.SecuritySettings = NewProjectsLocationsSecuritySettingsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agents *ProjectsLocationsAgentsService

	Operations *ProjectsLocationsOperationsService

	SecuritySettings *ProjectsLocationsSecuritySettingsService
}

func NewProjectsLocationsAgentsService(s *Service) *ProjectsLocationsAgentsService {
	rs := &ProjectsLocationsAgentsService{s: s}
	rs.Changelogs = NewProjectsLocationsAgentsChangelogsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentsEntityTypesService(s)
	rs.Environments = NewProjectsLocationsAgentsEnvironmentsService(s)
	rs.Flows = NewProjectsLocationsAgentsFlowsService(s)
	rs.Intents = NewProjectsLocationsAgentsIntentsService(s)
	rs.Sessions = NewProjectsLocationsAgentsSessionsService(s)
	rs.TestCases = NewProjectsLocationsAgentsTestCasesService(s)
	rs.Webhooks = NewProjectsLocationsAgentsWebhooksService(s)
	return rs
}

type ProjectsLocationsAgentsService struct {
	s *Service

	Changelogs *ProjectsLocationsAgentsChangelogsService

	EntityTypes *ProjectsLocationsAgentsEntityTypesService

	Environments *ProjectsLocationsAgentsEnvironmentsService

	Flows *ProjectsLocationsAgentsFlowsService

	Intents *ProjectsLocationsAgentsIntentsService

	Sessions *ProjectsLocationsAgentsSessionsService

	TestCases *ProjectsLocationsAgentsTestCasesService

	Webhooks *ProjectsLocationsAgentsWebhooksService
}

func NewProjectsLocationsAgentsChangelogsService(s *Service) *ProjectsLocationsAgentsChangelogsService {
	rs := &ProjectsLocationsAgentsChangelogsService{s: s}
	return rs
}

type ProjectsLocationsAgentsChangelogsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEntityTypesService(s *Service) *ProjectsLocationsAgentsEntityTypesService {
	rs := &ProjectsLocationsAgentsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsService{s: s}
	rs.ContinuousTestResults = NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s)
	rs.Deployments = NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s)
	rs.Experiments = NewProjectsLocationsAgentsEnvironmentsExperimentsService(s)
	rs.Sessions = NewProjectsLocationsAgentsEnvironmentsSessionsService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsService struct {
	s *Service

	ContinuousTestResults *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService

	Deployments *ProjectsLocationsAgentsEnvironmentsDeploymentsService

	Experiments *ProjectsLocationsAgentsEnvironmentsExperimentsService

	Sessions *ProjectsLocationsAgentsEnvironmentsSessionsService
}

func NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s *Service) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService {
	rs := &ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsDeploymentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsExperimentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsExperimentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsExperimentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsExperimentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsSessionsService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsService(s *Service) *ProjectsLocationsAgentsFlowsService {
	rs := &ProjectsLocationsAgentsFlowsService{s: s}
	rs.Pages = NewProjectsLocationsAgentsFlowsPagesService(s)
	rs.TransitionRouteGroups = NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s)
	rs.Versions = NewProjectsLocationsAgentsFlowsVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsFlowsService struct {
	s *Service

	Pages *ProjectsLocationsAgentsFlowsPagesService

	TransitionRouteGroups *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService

	Versions *ProjectsLocationsAgentsFlowsVersionsService
}

func NewProjectsLocationsAgentsFlowsPagesService(s *Service) *ProjectsLocationsAgentsFlowsPagesService {
	rs := &ProjectsLocationsAgentsFlowsPagesService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsPagesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s *Service) *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService {
	rs := &ProjectsLocationsAgentsFlowsTransitionRouteGroupsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsTransitionRouteGroupsService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsVersionsService(s *Service) *ProjectsLocationsAgentsFlowsVersionsService {
	rs := &ProjectsLocationsAgentsFlowsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsIntentsService(s *Service) *ProjectsLocationsAgentsIntentsService {
	rs := &ProjectsLocationsAgentsIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsSessionsService(s *Service) *ProjectsLocationsAgentsSessionsService {
	rs := &ProjectsLocationsAgentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsTestCasesService(s *Service) *ProjectsLocationsAgentsTestCasesService {
	rs := &ProjectsLocationsAgentsTestCasesService{s: s}
	rs.Results = NewProjectsLocationsAgentsTestCasesResultsService(s)
	return rs
}

type ProjectsLocationsAgentsTestCasesService struct {
	s *Service

	Results *ProjectsLocationsAgentsTestCasesResultsService
}

func NewProjectsLocationsAgentsTestCasesResultsService(s *Service) *ProjectsLocationsAgentsTestCasesResultsService {
	rs := &ProjectsLocationsAgentsTestCasesResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsTestCasesResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsWebhooksService(s *Service) *ProjectsLocationsAgentsWebhooksService {
	rs := &ProjectsLocationsAgentsWebhooksService{s: s}
	return rs
}

type ProjectsLocationsAgentsWebhooksService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSecuritySettingsService(s *Service) *ProjectsLocationsSecuritySettingsService {
	rs := &ProjectsLocationsSecuritySettingsService{s: s}
	return rs
}

type ProjectsLocationsSecuritySettingsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleCloudDialogflowCxV3AudioInput: Represents the natural speech
// audio to be processed.
type GoogleCloudDialogflowCxV3AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single
	// request can contain up to 1 minute of speech audio data. The
	// transcribed text cannot contain more than 256 bytes. For
	// non-streaming audio detect intent, both `config` and `audio` must be
	// provided. For streaming audio detect intent, `config` must be
	// provided in the first request and `audio` must be provided in all
	// following requests.
	Audio string `json:"audio,omitempty"`

	// Config: Required. Instructs the speech recognizer how to process the
	// speech audio.
	Config *GoogleCloudDialogflowCxV3InputAudioConfig `json:"config,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AudioInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata: Metadata returned
// for the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesResponse: The response
// message for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are
	// empty in this response.
	Results []*GoogleCloudDialogflowCxV3TestCaseResult `json:"results,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Results") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Results") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ContinuousTestResult: Represents a result
// from running a test case in an agent environment.
type GoogleCloudDialogflowCxV3ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`

	// Result: The result of this continuous test run, i.e. whether all the
	// tests in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never
	// be used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`

	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`

	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ContinuousTestResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurn: One interaction between a
// human and virtual agent. The human provides some input and the
// virtual agent provides a response.
type GoogleCloudDialogflowCxV3ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3ConversationTurnUserInput `json:"userInput,omitempty"`

	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserInput") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnUserInput: The input from
// the human user.
type GoogleCloudDialogflowCxV3ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`

	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`

	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3QueryInput `json:"input,omitempty"`

	// IsWebhookEnabled: If webhooks should be allowed to trigger in
	// response to the user utterance. Often if parameters are injected,
	// webhooks should not be enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableSentimentAnalysis") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnUserInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput: The
// output from the virtual agent.
type GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name
	// and displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3Page `json:"currentPage,omitempty"`

	// DiagnosticInfo: Required. Input only. The diagnostic info output for
	// the turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`

	// Differences: Output only. If this is part of a result conversation
	// turn, the list of differences between the original run and the replay
	// for this output, if any.
	Differences []*GoogleCloudDialogflowCxV3TestRunDifference `json:"differences,omitempty"`

	// SessionParameters: The session parameters available to the bot at
	// this point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`

	// Status: Response error from the agent in the test result. If set,
	// other output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3ResponseMessageText `json:"textResponses,omitempty"`

	// TriggeredIntent: The Intent that triggered the response. Only name
	// and displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3Intent `json:"triggeredIntent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3CreateDocumentOperationMetadata: Metadata
// for CreateDocument operation.
type GoogleCloudDialogflowCxV3CreateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3CreateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3CreateVersionOperationMetadata: Metadata
// associated with the long running operation for
// Versions.CreateVersion.
type GoogleCloudDialogflowCxV3CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateVersionOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeleteDocumentOperationMetadata: Metadata
// for DeleteDocument operation.
type GoogleCloudDialogflowCxV3DeleteDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3DeleteDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeleteDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowMetadata: Metadata returned for
// the Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3TestError `json:"testErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestErrors") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowResponse: The response message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3DeployFlowResponse struct {
	// Deployment: The name of the flow version Deployment. Format:
	// `projects//locations//agents// environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`

	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3Environment `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deployment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DtmfInput: Represents the input for dtmf
// event.
type GoogleCloudDialogflowCxV3DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`

	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Digits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DtmfInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Environment: Represents an environment for
// an agent. You can create multiple versions of your agent and publish
// them to separate environments. When you edit an agent, you are
// editing the draft agent. At any point, you can save the draft agent
// as an agent version, which is an immutable snapshot of your agent.
// When you save the draft agent, it is published to the default
// environment. When you create agent versions, you can publish them to
// custom environments. You can create a variety of custom environments
// for testing, development, production, etc.
type GoogleCloudDialogflowCxV3Environment struct {
	// Description: The human-readable description of the environment. The
	// maximum length is 500 characters. If exceeded, the request is
	// rejected.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the environment
	// (unique in an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`

	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`

	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`

	// VersionConfigs: Required. A list of configurations for flow versions.
	// You should include version configs for all flows that are reachable
	// from `Start Flow` in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3EnvironmentVersionConfig `json:"versionConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Environment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig: The
// configuration for continuous tests.
type GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in
	// TestCasesConfig.test_cases periodically. Default false. If set to
	// ture, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`

	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`

	// TestCases: A list of test case names to run. They should be under the
	// same agent. Format of each test case name: `projects//locations/
	// /agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableContinuousRun") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentVersionConfig: Configuration for
// the version.
type GoogleCloudDialogflowCxV3EnvironmentVersionConfig struct {
	// Version: Required. Format:
	// projects//locations//agents//flows//versions/.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentVersionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventHandler: An event handler specifies an
// event that can be handled during a session. When the specified event
// happens, the following actions are taken in order: * If there is a
// `trigger_fulfillment` associated with the event, it will be called. *
// If there is a `target_page` associated with the event, the session
// will transition into the specified page. * If there is a
// `target_flow` associated with the event, the session will transition
// into the specified flow.
type GoogleCloudDialogflowCxV3EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`

	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// TriggerFulfillment: The fulfillment to call when the event occurs.
	// Handling webhook errors with a fulfillment enabled with webhook could
	// cause infinite loop. It is invalid to specify such fulfillment for a
	// handler handling webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Event") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventHandler
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventInput: Represents the event to trigger.
type GoogleCloudDialogflowCxV3EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Event") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportAgentResponse: The response message
// for Agents.ExportAgent.
type GoogleCloudDialogflowCxV3ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`

	// AgentUri: The URI to a file containing the exported agent. This field
	// is populated only if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportFlowResponse: The response message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`

	// FlowUri: The URI to a file containing the exported flow. This field
	// is populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportTestCasesMetadata: Metadata returned
// for the TestCases.ExportTestCases long running operation. This
// message currently has no fields.
type GoogleCloudDialogflowCxV3ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportTestCasesResponse: The response
// message for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`

	// GcsUri: The URI to a file containing the exported test cases. This
	// field is populated only if `gcs_uri` is specified in
	// ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Form: A form is a data model that groups
// related parameters that can be collected from the user. The process
// in which the agent prompts the user and collects parameter values
// from the user is called form filling. A form can be added to a page.
// When form filling is done, the filled parameters will be written to
// the session.
type GoogleCloudDialogflowCxV3Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3FormParameter `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Form
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameter: Represents a form parameter.
type GoogleCloudDialogflowCxV3FormParameter struct {
	// DefaultValue: The default value of an optional parameter. If the
	// parameter is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`

	// DisplayName: Required. The human-readable name of the parameter,
	// unique within the form.
	DisplayName string `json:"displayName,omitempty"`

	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity
	// types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity
	// types.
	EntityType string `json:"entityType,omitempty"`

	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3FormParameterFillBehavior `json:"fillBehavior,omitempty"`

	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`

	// Redact: Indicates whether the parameter content should be redacted in
	// log. If redaction is enabled, the parameter content will be replaced
	// by parameter name during logging. Note: the parameter content is
	// subject to redaction if either parameter level redaction or entity
	// type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`

	// Required: Indicates whether the parameter is required. Optional
	// parameters will not trigger prompts; however, they are filled if the
	// user specifies them. Required parameters must be filled before form
	// filling concludes.
	Required bool `json:"required,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameterFillBehavior: Configuration for
// how the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the
	// initial prompt that the agent can present to the user in order to
	// fill the parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"initialPromptFulfillment,omitempty"`

	// RepromptEventHandlers: The handlers for parameter-level events, used
	// to provide reprompt for the parameter or transition to a different
	// page/flow. The supported events are: * `sys.no-match-`, where N can
	// be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N
	// can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the
	// parameter. If the user's response does not fill the parameter, a
	// no-match/no-input event will be triggered, and the fulfillment
	// associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
	// defined) will be called to provide a prompt. The
	// `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond
	// to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used
	// to handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case
	// where the parameter values have been `invalidated` by webhook. For
	// example, if the user's response fill the parameter, however the
	// parameter was invalidated by webhook, the fulfillment associated with
	// the `sys.invalid-parameter` handler (if defined) will be called to
	// provide a prompt. If the event handler for the corresponding event
	// can't be found on the parameter, `initial_prompt_fulfillment` will be
	// re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"repromptEventHandlers,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "InitialPromptFulfillment") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameterFillBehavior
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Fulfillment: A fulfillment can do one or
// more of the following actions at the same time: * Generate rich
// message responses. * Set parameter values. * Call the webhook.
// Fulfillments can be called at various stages in the Page or Form
// lifecycle. For example, when a DetectIntentRequest drives a session
// to enter a new page, the page's entry fulfillment can add a static
// response to the QueryResult in the returning DetectIntentResponse,
// call the webhook (for example, to load user data from a database), or
// both.
type GoogleCloudDialogflowCxV3Fulfillment struct {
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"conditionalCases,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`

	// ReturnPartialResponses: Whether Dialogflow should return currently
	// queued fulfillment response messages in streaming APIs. If a webhook
	// is specified, it happens before Dialogflow invokes webhook. Warning:
	// 1) This flag only affects streaming API. Responses are still queued
	// and returned once in non-streaming API. 2) The flag can be enabled in
	// any fulfillment but only the first 3 partial responses will be
	// returned. You may only want to apply it to fulfillments that have
	// slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`

	// SetParameterActions: Set parameter values before executing the
	// webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`

	// Tag: The tag used by the webhook to identify which fulfillment is
	// being called. This field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`

	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConditionalCases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConditionalCases") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Fulfillment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCases: A list of
// cascading if-else conditions. Cases are mutually exclusive. The first
// one with a matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase `json:"cases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCases
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase: Each case
// has a Boolean condition. When it is evaluated to be True, the
// corresponding messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`

	// Condition: The condition to activate and select this case. Empty
	// means the condition is always true. The condition is evaluated
	// against form parameters or session parameters. See the conditions
	// reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent:
// The list of messages or conditional cases to activate for this case.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"additionalCases,omitempty"`

	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3ResponseMessage `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalCases") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentSetParameterAction: Setting a
// parameter value.
type GoogleCloudDialogflowCxV3FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`

	// Value: The new value of the parameter. A null value clears the
	// parameter.
	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentSetParameterAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata: Metadata
// in google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata struct {
	// State: Required. Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportDocumentsOperationMetadata: Metadata
// for ImportDocuments operation.
type GoogleCloudDialogflowCxV3ImportDocumentsOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ImportDocumentsOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportDocumentsOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportDocumentsResponse: Response message
// for Documents.ImportDocuments.
type GoogleCloudDialogflowCxV3ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other
	// warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Warnings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportFlowResponse: The response message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesMetadata: Metadata returned
// for the TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3TestCaseError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesResponse: The response
// message for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3InputAudioConfig: Instructs the speech
// recognizer on how to process the audio content.
type GoogleCloudDialogflowCxV3InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to
	// process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed
	// little-endian samples (Linear PCM).
	//   "AUDIO_ENCODING_FLAC" -
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless
	// Audio Codec) is the recommended encoding because it is lossless
	// (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO`
	// are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio
	// samples using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg
	// container ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is
	// required, `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has
	// a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`. It is a variant of the RTP Speex
	// encoding defined in [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each
	// block starts with a byte containing the length of the block, in
	// bytes, followed by one or more frames of Speex data, padded to an
	// integral number of bytes (octets) as specified in RFC 5574. In other
	// words, each RTP header is replaced with a single byte containing the
	// block length. Only Speex wideband is supported. `sample_rate_hertz`
	// must be 16000.
	AudioEncoding string `json:"audioEncoding,omitempty"`

	// EnableWordInfo: Optional. If `true`, Dialogflow returns
	// SpeechWordInfo in StreamingRecognitionResult with information about
	// the recognized speech words, e.g. start and end time offsets. If
	// false or unspecified, Speech doesn't return any word-level
	// information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`

	// Model: Optional. Which Speech model to select for the given request.
	// Select the model best suited to your domain to get best results. If a
	// model is not explicitly specified, then we auto-select a model based
	// on the parameters in the InputAudioConfig. If enhanced speech model
	// is enabled for the agent and an enhanced version of the specified
	// model for the language does not exist, then the speech is recognized
	// using the standard version of the specified model. Refer to Cloud
	// Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#select-model)
	// for more details.
	Model string `json:"model,omitempty"`

	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In
	// this case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech
	// model that the caller is eligible for. Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for how
	// to make your project eligible for enhanced models.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced
	// model is available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-m
	// odels) for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced
	// variant does not exist for the given model and request language,
	// Dialogflow falls back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-m
	// odels) describes which models have enhanced variants. * If the API
	// caller isn't eligible for enhanced models, Dialogflow returns an
	// error. Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for how
	// to make your project eligible.
	ModelVariant string `json:"modelVariant,omitempty"`

	// PhraseHints: Optional. A list of strings containing words and phrases
	// that the speech recognizer should recognize with higher likelihood.
	// See the Cloud Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	PhraseHints []string `json:"phraseHints,omitempty"`

	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in
	// the query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more
	// details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`

	// SingleUtterance: Optional. If `false` (default), recognition does not
	// cease until the client closes the stream. If `true`, the recognizer
	// will detect a single spoken utterance in input audio. Recognition
	// ceases when it detects the audio's voice has stopped or paused. In
	// this case, once a detected intent is received, the client should
	// close the stream and start a new request with a new stream as needed.
	// Note: This setting is relevant only for streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioEncoding") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InputAudioConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Intent: An intent represents a user's intent
// to interact with a conversational agent. You can provide information
// for the Dialogflow API to use to match user input to an intent by
// adding training phrases (i.e., examples of user input) to your
// intent.
type GoogleCloudDialogflowCxV3Intent struct {
	// Description: Human readable description for better understanding an
	// intent like its scope, content, result etc. Maximum character limit:
	// 140 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the intent, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// IsFallback: Indicates whether this is a fallback intent. Currently
	// only default fallback intent is allowed in the agent, which is added
	// upon agent creation. Adding training phrases to fallback intent is
	// useful in the case of requests that are mistakenly matched, since
	// training phrases assigned to fallback intents act as negative
	// examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`

	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets.
	// Keys must start with a letter. Keys and values can be no longer than
	// 63 characters and no more than 128 bytes. Prefix "sys-" is reserved
	// for Dialogflow defined labels. Currently allowed Dialogflow defined
	// labels include: * sys-head * sys-contextual The above labels do not
	// require value. "sys-head" means the intent is a head intent.
	// "sys.contextual" means the intent is a contextual intent.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`

	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3IntentParameter `json:"parameters,omitempty"`

	// Priority: The priority of this intent. Higher numbers represent
	// higher priorities. - If the supplied value is unspecified or 0, the
	// service translates the value to 500,000, which corresponds to the
	// `Normal` priority in the console. - If the supplied value is
	// negative, the intent is ignored in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`

	// TrainingPhrases: The collection of training phrases the agent is
	// trained on to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Intent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentInput: Represents the intent to
// trigger programmatically rather than as a result of natural language
// processing.
type GoogleCloudDialogflowCxV3IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Intent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentParameter: Represents an intent
// parameter.
type GoogleCloudDialogflowCxV3IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity
	// types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity
	// types.
	EntityType string `json:"entityType,omitempty"`

	// Id: Required. The unique identifier of the parameter. This field is
	// used by training phrases to annotate their parts.
	Id string `json:"id,omitempty"`

	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`

	// Redact: Indicates whether the parameter content should be redacted in
	// log. If redaction is enabled, the parameter content will be replaced
	// by parameter name during logging. Note: the parameter content is
	// subject to redaction if either parameter level redaction or entity
	// type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrase: Represents an example
// that the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`

	// Parts: Required. The ordered list of training phrase parts. The parts
	// are concatenated in order to form the training phrase. Note: The API
	// does not automatically annotate training phrases like the Dialogflow
	// Console does. Note: Do not forget to include whitespace at part
	// boundaries, so the training phrase is well formatted when the parts
	// are concatenated. If the training phrase does not need to be
	// annotated with parameters, you just need a single part with only the
	// Part.text field set. If you want to annotate the training phrase, you
	// must create multiple parts, where the fields of each part are
	// populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the
	// phrase that you want to annotate, and the `parameter_id` field is
	// set.
	Parts []*GoogleCloudDialogflowCxV3IntentTrainingPhrasePart `json:"parts,omitempty"`

	// RepeatCount: Indicates how many times this example was added to the
	// intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrasePart: Represents a part
// of a training phrase.
type GoogleCloudDialogflowCxV3IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training
	// phrase.
	ParameterId string `json:"parameterId,omitempty"`

	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParameterId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrasePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Page: A Dialogflow CX conversation (session)
// can be described and visualized as a state machine. The states of a
// CX session are represented by pages. For each flow, you define many
// pages, where your combined pages can handle a complete conversation
// on the topics the flow is designed for. At any given moment, exactly
// one page is the current page, the current page is considered active,
// and the flow associated with that page is considered active. Every
// flow has a special start page. When a flow initially becomes active,
// the start page page becomes the current page. For each conversational
// turn, the current page will either stay the same or transition to
// another page. You configure each page to collect information from the
// end-user that is relevant for the conversational state represented by
// the page. For more information, see the Page guide
// (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3Page struct {
	// DisplayName: Required. The human-readable name of the page, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// EntryFulfillment: The fulfillment to call when the session is
	// entering the page.
	EntryFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"entryFulfillment,omitempty"`

	// EventHandlers: Handlers associated with the page to handle events
	// such as webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"eventHandlers,omitempty"`

	// Form: The form associated with the page, used for collecting
	// parameters relevant to the page.
	Form *GoogleCloudDialogflowCxV3Form `json:"form,omitempty"`

	// Name: The unique identifier of the page. Required for the
	// Pages.UpdatePage method. Pages.CreatePage populates the name
	// automatically. Format: `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`

	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups`
	// associated with the page. Transition route groups must be unique
	// within a page. * If multiple transition routes within a page scope
	// refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's
	// transition routes. * If multiple transition route groups within a
	// page contain the same intent, then the first group in the ordered
	// list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/`.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`

	// TransitionRoutes: A list of transitions for the transition rules of
	// this page. They route the conversation to another page in the same
	// flow, or another flow. When we are in a certain page, the
	// TransitionRoutes are evalauted in the following order: *
	// TransitionRoutes defined in the page with intent specified. *
	// TransitionRoutes defined in the transition route groups with intent
	// specified. * TransitionRoutes defined in flow with intent specified.
	// * TransitionRoutes defined in the transition route groups with intent
	// specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups
	// with only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3TransitionRoute `json:"transitionRoutes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Page
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfo: Represents page information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for
	// WebhookResponse. The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`

	// FormInfo: Optional for both WebhookRequest and WebhookResponse.
	// Information about the form.
	FormInfo *GoogleCloudDialogflowCxV3PageInfoFormInfo `json:"formInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfo: Represents form
// information.
type GoogleCloudDialogflowCxV3PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse.
	// The parameters contained in the form. Note that the webhook cannot
	// add or remove any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParameterInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo: Represents
// parameter information.
type GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique
	// within the form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`

	// JustCollected: Optional for WebhookRequest. Ignored for
	// WebhookResponse. Indicates if the parameter value was just collected
	// on the last conversation turn.
	JustCollected bool `json:"justCollected,omitempty"`

	// Required: Optional for both WebhookRequest and WebhookResponse.
	// Indicates whether the parameter is required. Optional parameters will
	// not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling
	// concludes.
	Required bool `json:"required,omitempty"`

	// State: Always present for WebhookRequest. Required for
	// WebhookResponse. The state of the parameter. This field can be set to
	// INVALID by the webhook to invalidate the parameter; other values set
	// by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be
	// never used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This
	// field can be used by the webhook to invalidate the parameter and ask
	// the server to collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`

	// Value: Optional for both WebhookRequest and WebhookResponse. The
	// value of the parameter. This field can be set by the webhook to
	// change the parameter value.
	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3QueryInput: Represents the query input. It
// can contain one of: 1. A conversational query in the form of text. 2.
// An intent query that specifies which intent to trigger. 3. Natural
// language speech audio to be processed. 4. An event to be triggered.
type GoogleCloudDialogflowCxV3QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3AudioInput `json:"audio,omitempty"`

	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3DtmfInput `json:"dtmf,omitempty"`

	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3EventInput `json:"event,omitempty"`

	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3IntentInput `json:"intent,omitempty"`

	// LanguageCode: Required. The language of the input. See Language
	// Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for
	// a list of the currently supported language codes. Note that queries
	// in the same session do not necessarily need to specify the same
	// language.
	LanguageCode string `json:"languageCode,omitempty"`

	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3TextInput `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ReloadDocumentOperationMetadata: Metadata
// for ReloadDocument operation.
type GoogleCloudDialogflowCxV3ReloadDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ReloadDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ReloadDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessage: Represents a response
// message that can be returned by a conversational agent. Response
// messages are also used for output audio synthesis. The approach is as
// follows: * If at least one OutputAudioText response is present, then
// all OutputAudioText responses are linearly concatenated, and the
// result is used for output audio synthesis. * If the OutputAudioText
// responses are a mixture of text and SSML, then the concatenated
// result is treated as SSML; otherwise, the result is treated as either
// text or SSML as appropriate. The agent designer should ideally use
// either text or SSML consistently throughout the bot design. *
// Otherwise, all Text responses are linearly concatenated, and the
// result is used for output audio synthesis. This approach allows for
// more sophisticated user experience scenarios, where the text
// displayed to the user may differ from what is heard.
type GoogleCloudDialogflowCxV3ResponseMessage struct {
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`

	// EndInteraction: Output only. A signal that indicates the interaction
	// with the Dialogflow agent has ended. This message is generated by
	// Dialogflow only when the conversation reaches `END_SESSION` page. It
	// is not supposed to be defined by the user. It's guaranteed that there
	// is at most one such message in each response.
	EndInteraction *GoogleCloudDialogflowCxV3ResponseMessageEndInteraction `json:"endInteraction,omitempty"`

	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`

	// MixedAudio: Output only. An audio response message composed of both
	// the synthesized Dialogflow agent responses and responses defined via
	// play_audio. This message is generated by Dialogflow only and not
	// supposed to be defined by the user.
	MixedAudio *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`

	// OutputAudioText: A text or ssml response that is preferentially used
	// for TTS output audio synthesis, as described in the comment on the
	// ResponseMessage message.
	OutputAudioText *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`

	// Payload: Returns a response containing a custom, platform-specific
	// payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// PlayAudio: Signal that the client should play an audio clip hosted at
	// a client-specific URI. Dialogflow uses this to construct mixed_audio.
	// However, Dialogflow itself does not try to read or process the URI in
	// any way.
	PlayAudio *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio `json:"playAudio,omitempty"`

	// TelephonyTransferCall: A signal that the client should transfer the
	// phone call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`

	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3ResponseMessageText `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConversationSuccess")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationSuccess") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess:
// Indicates that the conversation succeeded, i.e., the bot handled the
// issue that the customer talked to it about. Dialogflow only uses this
// to determine which conversations should be counted as successful and
// doesn't process the metadata in this message in any way. Note that
// Dialogflow also considers conversations that get to the conversation
// end page as successful even if they don't return ConversationSuccess.
// You may set this, for example: * In the entry_fulfillment of a Page
// if entering the page indicates that the conversation succeeded. * In
// a webhook response when you determine that you handled the customer
// issue.
type GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on
	// this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageEndInteraction: Indicates
// that interaction with the Dialogflow agent has ended. This message is
// generated by Dialogflow only and not supposed to be defined by the
// user.
type GoogleCloudDialogflowCxV3ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff: Indicates
// that the conversation should be handed off to a live agent.
// Dialogflow only uses this to determine which conversations were
// handed off to a human agent for measurement purposes. What else to do
// with this signal is up to you and your handoff procedures. You may
// set this, for example: * In the entry_fulfillment of a Page if
// entering the page indicates something went extremely wrong in the
// conversation. * In a webhook response when you determine that the
// customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow
	// doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudio: Represents an
// audio message that is composed of both segments synthesized from the
// Dialogflow agent prompts and ones hosted externally at the specified
// URIs. The external URIs are specified via play_audio. This message is
// generated by Dialogflow only and not supposed to be defined by the
// user.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment `json:"segments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Segments") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment: Represents
// one segment of audio.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// segment can be interrupted by the end user's speech and the client
	// should then start the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Audio: Raw audio synthesized from the Dialogflow agent's response
	// using the output config specified in the request.
	Audio string `json:"audio,omitempty"`

	// Uri: Client-specific URI that points to an audio clip accessible to
	// the client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText: A text or
// ssml response that is preferentially used for TTS output audio
// synthesis, as described in the comment on the ResponseMessage
// message.
type GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`

	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessagePlayAudio: Specifies an audio
// clip to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose
	// any validation on this value. It is specific to the client that reads
	// it.
	AudioUri string `json:"audioUri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessagePlayAudio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall:
// Represents the signal that telles the client to transfer the phone
// call connected to the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageText: The text response
// message.
type GoogleCloudDialogflowCxV3ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Text: Required. A collection of text responses.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestMetadata: Metadata returned
// for the Environments.RunContinuousTest long running operation.
type GoogleCloudDialogflowCxV3RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestResponse: The response
// message for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResult,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ContinuousTestResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContinuousTestResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunTestCaseMetadata: Metadata returned for
// the TestCases.RunTestCase long running operation. This message
// currently has no fields.
type GoogleCloudDialogflowCxV3RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3RunTestCaseResponse: The response message
// for TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3TestCaseResult `json:"result,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Result") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3SessionInfo: Represents session information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for
	// WebhookResponse. All parameters collected from forms and intents
	// during the session. Parameters can be created, updated, or removed by
	// the webhook. To remove a parameter from the session, the webhook
	// should explicitly set the parameter value to null in WebhookResponse.
	// The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// Session: Always present for WebhookRequest. Ignored for
	// WebhookResponse. The unique identifier of the session. This field can
	// be used by the webhook to identify a session. Format:
	// `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment
	// is specified.
	Session string `json:"session,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`

	// DisplayName: Required. The human-readable name of the test case,
	// unique within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`

	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3TestCaseResult `json:"lastTestResult,omitempty"`

	// Name: The unique identifier of the test case.
	// TestCases.CreateTestCase will populate the name automatically.
	// Otherwise use format: `projects//locations//agents/ /testCases/`.
	Name string `json:"name,omitempty"`

	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`

	// Tags: Tags are short descriptions that users may apply to test cases
	// for organizational and filtering purposes. Each tag should start with
	// "#" and has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`

	// TestCaseConversationTurns: The conversation turns uttered when the
	// test case was created, in chronological order. These include the
	// canonical set of agent utterances that should occur when the agent is
	// working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"testCaseConversationTurns,omitempty"`

	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3TestConfig `json:"testConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseError: Error info for importing a
// test.
type GoogleCloudDialogflowCxV3TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3TestCase `json:"testCase,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test
	// case replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"conversationTurns,omitempty"`

	// Environment: Environment where the test was run. If not set, it
	// indicates the draft environment.
	Environment string `json:"environment,omitempty"`

	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases/ /results/`.
	Name string `json:"name,omitempty"`

	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`

	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConversationTurns")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationTurns") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestConfig: Represents configurations for a
// test case.
type GoogleCloudDialogflowCxV3TestConfig struct {
	// Flow: Flow name. If not set, default start flow is assumed. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`

	// TrackingParameters: Session parameters to be compared when
	// calculating differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestError: Error info for running a test.
type GoogleCloudDialogflowCxV3TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`

	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestRunDifference: The description of
// differences between original and replayed agent output.
type GoogleCloudDialogflowCxV3TestRunDifference struct {
	// Description: A description of the diff, showing the actual output vs
	// expected output.
	Description string `json:"description,omitempty"`

	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestRunDifference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TextInput: Represents the natural language
// text to be processed.
type GoogleCloudDialogflowCxV3TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be
	// processed. Text length must not exceed 256 characters.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TransitionRoute: A transition route
// specifies a intent that can be matched and/or a data condition that
// can be evaluated during a session. When a specified transition is
// matched, the following actions are taken in order: * If there is a
// `trigger_fulfillment` associated with the transition, it will be
// called. * If there is a `target_page` associated with the transition,
// the session will transition into the specified page. * If there is a
// `target_flow` associated with the transition, the session will
// transition into the specified flow.
type GoogleCloudDialogflowCxV3TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or
	// session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At
	// least one of `intent` or `condition` must be specified. When both
	// `intent` and `condition` are specified, the transition can only
	// happen when both are fulfilled.
	Condition string `json:"condition,omitempty"`

	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the
	// transition can only happen when the given intent is matched. At least
	// one of `intent` or `condition` must be specified. When both `intent`
	// and `condition` are specified, the transition can only happen when
	// both are fulfilled.
	Intent string `json:"intent,omitempty"`

	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// TriggerFulfillment: The fulfillment to call when the condition is
	// satisfied. At least one of `trigger_fulfillment` and `target` must be
	// specified. When both are defined, `trigger_fulfillment` is executed
	// first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3UpdateDocumentOperationMetadata: Metadata
// for UpdateDocument operation.
type GoogleCloudDialogflowCxV3UpdateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3UpdateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3UpdateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequest: The request message for a
// webhook call. The request is sent as a JSON object and the field
// names will be presented in camel cases.
type GoogleCloudDialogflowCxV3WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`

	// FulfillmentInfo: Always present. Information about the fulfillment
	// that triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`

	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo `json:"intentInfo,omitempty"`

	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	// Webhook can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`

	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`

	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SentimentAnalysisResult: The sentiment analysis result of the current
	// user request. The field is filled when sentiment analysis is
	// configured to be enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`

	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`

	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`

	// Transcript: If natural language speech audio was provided as input,
	// this field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`

	// TriggerEvent: If an event was provided as input, this field will
	// contain the name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`

	// TriggerIntent: If an intent was provided as input, this field will
	// contain a copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DetectIntentResponseId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectIntentResponseId")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo: Represents
// fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The tag used to identify which fulfillment is
	// being called.
	Tag string `json:"tag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Tag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Tag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfo: Represents intent
// information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from
	// 0.0 (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// DisplayName: Always present. The display name of the last matched
	// intent.
	DisplayName string `json:"displayName,omitempty"`

	// LastMatchedIntent: Always present. The unique identifier of the last
	// matched intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`

	// Parameters: Parameters identified as a result of intent matching.
	// This is a map of the name of the identified parameter to the value of
	// the parameter identified from the user's utterance. All parameters
	// defined in the matched intent that are identified will be surfaced
	// here.
	Parameters map[string]GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue:
//  Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from
	// user utterance.
	OriginalValue string `json:"originalValue,omitempty"`

	// ResolvedValue: Always present. Structured value for the parameter
	// extracted from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OriginalValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult:
// Represents the result of sentiment analysis.
type GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which
	// represents the absolute magnitude of sentiment, regardless of score
	// (positive or negative).
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookResponse: The response message for a
// webhook call.
type GoogleCloudDialogflowCxV3WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user.
	// This field can be omitted by the webhook if it does not intend to
	// send any response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`

	// PageInfo: Information about page status. This field can be omitted by
	// the webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`

	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SessionInfo: Information about session status. This field can be
	// omitted by the webhook if it does not intend to modify session
	// status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FulfillmentResponse") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse:
// Represents a fulfillment response to the user.
type GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be
	// used.
	//   "APPEND" - `messages` will be appended to the list of messages
	// waiting to be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to
	// be sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MergeBehavior") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettings: Hierarchical advanced
// settings for agent/flow/page/fulfillment/parameter. Settings exposed
// at lower level overrides the settings exposed at higher level.
// Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
type GoogleCloudDialogflowCxV3beta1AdvancedSettings struct {
	// LoggingSettings: Settings for logging. Settings for Dialogflow
	// History, Contact Center messages, StackDriver logs, and speech
	// logging. Exposed at the following levels: - Agent level.
	LoggingSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LoggingSettings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoggingSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings: Define
// behaviors on logging.
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings struct {
	// EnableInteractionLogging: If true, DF Interaction logging is
	// currently enabled.
	EnableInteractionLogging bool `json:"enableInteractionLogging,omitempty"`

	// EnableStackdriverLogging: If true, StackDriver logging is currently
	// enabled.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableInteractionLogging") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableInteractionLogging")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Agent: Agents are best described as
// Natural Language Understanding (NLU) modules that transform user
// requests into actionable data. You can include agents in your app,
// product, or service to determine user intent and respond to the user
// in a natural way. After you create an agent, you can add Intents,
// Entity Types, Flows, Fulfillments, Webhooks, and so on to manage the
// conversation flows..
type GoogleCloudDialogflowCxV3beta1Agent struct {
	// AdvancedSettings: Hierarchical advanced settings for this agent. The
	// settings exposed at the lower level overrides the settings exposed at
	// the higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`

	// AvatarUri: The URI of the agent's avatar. Avatars are used throughout
	// the Dialogflow console and in the self-hosted Web Demo
	// (https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `json:"avatarUri,omitempty"`

	// DefaultLanguageCode: Required. Immutable. The default language of the
	// agent as a language tag. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for
	// a list of the currently supported language codes. This field cannot
	// be set by the Agents.UpdateAgent method.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`

	// Description: The description of the agent. The maximum length is 500
	// characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the agent, unique
	// within the location.
	DisplayName string `json:"displayName,omitempty"`

	// EnableSpellCorrection: Indicates if automatic spell correction is
	// enabled in detect intent requests.
	EnableSpellCorrection bool `json:"enableSpellCorrection,omitempty"`

	// EnableStackdriverLogging: Indicates if stackdriver logging is enabled
	// for the agent. Please use agent.advanced_settings instead.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`

	// Name: The unique identifier of the agent. Required for the
	// Agents.UpdateAgent method. Agents.CreateAgent populates the name
	// automatically. Format: `projects//locations//agents/`.
	Name string `json:"name,omitempty"`

	// SecuritySettings: Name of the SecuritySettings reference for the
	// agent. Format: `projects//locations//securitySettings/`.
	SecuritySettings string `json:"securitySettings,omitempty"`

	// SpeechToTextSettings: Speech recognition related settings.
	SpeechToTextSettings *GoogleCloudDialogflowCxV3beta1SpeechToTextSettings `json:"speechToTextSettings,omitempty"`

	// StartFlow: Immutable. Name of the start flow in this agent. A start
	// flow will be automatically created when the agent is created, and can
	// only be deleted by deleting the agent. Format:
	// `projects//locations//agents//flows/`.
	StartFlow string `json:"startFlow,omitempty"`

	// SupportedLanguageCodes: The list of all languages supported by the
	// agent (except for the `default_language_code`).
	SupportedLanguageCodes []string `json:"supportedLanguageCodes,omitempty"`

	// TimeZone: Required. The time zone of the agent from the time zone
	// database (https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Agent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Agent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentValidationResult: The response
// message for Agents.GetAgentValidationResult.
type GoogleCloudDialogflowCxV3beta1AgentValidationResult struct {
	// FlowValidationResults: Contains all flow validation results.
	FlowValidationResults []*GoogleCloudDialogflowCxV3beta1FlowValidationResult `json:"flowValidationResults,omitempty"`

	// Name: The unique identifier of the agent validation result. Format:
	// `projects//locations//agents//validationResult`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "FlowValidationResults") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowValidationResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1AgentValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentValidationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AudioInput: Represents the natural
// speech audio to be processed.
type GoogleCloudDialogflowCxV3beta1AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single
	// request can contain up to 1 minute of speech audio data. The
	// transcribed text cannot contain more than 256 bytes. For
	// non-streaming audio detect intent, both `config` and `audio` must be
	// provided. For streaming audio detect intent, `config` must be
	// provided in the first request and `audio` must be provided in all
	// following requests.
	Audio string `json:"audio,omitempty"`

	// Config: Required. Instructs the speech recognizer how to process the
	// speech audio.
	Config *GoogleCloudDialogflowCxV3beta1InputAudioConfig `json:"config,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AudioInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest: The
// request message for TestCases.BatchDeleteTestCases.
type GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest struct {
	// Names: Required. Format of test case names: `projects//locations/
	// /agents//testCases/`.
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata: Metadata
// returned for the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest: The request
// message for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest struct {
	// Environment: Optional. If not set, draft environment is assumed.
	// Format: `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`

	// TestCases: Required. Format:
	// `projects//locations//agents//testCases/`.
	TestCases []string `json:"testCases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environment") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse: The response
// message for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are
	// empty in this response.
	Results []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"results,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Results") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Results") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse: The response
// message for TestCases.CalculateCoverage.
type GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse struct {
	// Agent: The agent to calculate coverage for. Format:
	// `projects//locations//agents/`.
	Agent string `json:"agent,omitempty"`

	// IntentCoverage: Intent coverage.
	IntentCoverage *GoogleCloudDialogflowCxV3beta1IntentCoverage `json:"intentCoverage,omitempty"`

	// RouteGroupCoverage: Transition route group coverage.
	RouteGroupCoverage *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage `json:"routeGroupCoverage,omitempty"`

	// TransitionCoverage: Transition (excluding transition route groups)
	// coverage.
	TransitionCoverage *GoogleCloudDialogflowCxV3beta1TransitionCoverage `json:"transitionCoverage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Agent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Changelog: Changelogs represents a
// change made to a given agent.
type GoogleCloudDialogflowCxV3beta1Changelog struct {
	// Action: The action of the change.
	Action string `json:"action,omitempty"`

	// CreateTime: The timestamp of the change.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: The affected resource display name of the change.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The unique identifier of the changelog. Format:
	// `projects//locations//agents//changelogs/`.
	Name string `json:"name,omitempty"`

	// Resource: The affected resource name of the change.
	Resource string `json:"resource,omitempty"`

	// Type: The affected resource type.
	Type string `json:"type,omitempty"`

	// UserEmail: Email address of the authenticated user.
	UserEmail string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Changelog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Changelog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CompareVersionsRequest: The request
// message for Versions.CompareVersions.
type GoogleCloudDialogflowCxV3beta1CompareVersionsRequest struct {
	// LanguageCode: The language to compare the flow versions for. If not
	// specified, the agent's default language is used. Many languages
	// (https://cloud.google.com/dialogflow/docs/reference/language) are
	// supported. Note: languages must be enabled in the agent before they
	// can be used.
	LanguageCode string `json:"languageCode,omitempty"`

	// TargetVersion: Required. Name of the target flow version to compare
	// with the base version. Use version ID `0` to indicate the draft
	// version of the specified flow. Format:
	// `projects//locations//agents//flows//versions/`.
	TargetVersion string `json:"targetVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1CompareVersionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CompareVersionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CompareVersionsResponse: The response
// message for Versions.CompareVersions.
type GoogleCloudDialogflowCxV3beta1CompareVersionsResponse struct {
	// BaseVersionContentJson: JSON representation of the base version
	// content.
	BaseVersionContentJson string `json:"baseVersionContentJson,omitempty"`

	// CompareTime: The timestamp when the two version compares.
	CompareTime string `json:"compareTime,omitempty"`

	// TargetVersionContentJson: JSON representation of the target version
	// content.
	TargetVersionContentJson string `json:"targetVersionContentJson,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "BaseVersionContentJson") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseVersionContentJson")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1CompareVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CompareVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ContinuousTestResult: Represents a
// result from running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`

	// Result: The result of this continuous test run, i.e. whether all the
	// tests in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never
	// be used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`

	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`

	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ContinuousTestResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurn: One interaction
// between a human and virtual agent. The human provides some input and
// the virtual agent provides a response.
type GoogleCloudDialogflowCxV3beta1ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput `json:"userInput,omitempty"`

	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserInput") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput: The input
// from the human user.
type GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`

	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`

	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3beta1QueryInput `json:"input,omitempty"`

	// IsWebhookEnabled: If webhooks should be allowed to trigger in
	// response to the user utterance. Often if parameters are injected,
	// webhooks should not be enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableSentimentAnalysis") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput: The
// output from the virtual agent.
type GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name
	// and displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`

	// DiagnosticInfo: Required. Input only. The diagnostic info output for
	// the turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`

	// Differences: Output only. If this is part of a result conversation
	// turn, the list of differences between the original run and the replay
	// for this output, if any.
	Differences []*GoogleCloudDialogflowCxV3beta1TestRunDifference `json:"differences,omitempty"`

	// SessionParameters: The session parameters available to the bot at
	// this point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`

	// Status: Response error from the agent in the test result. If set,
	// other output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"textResponses,omitempty"`

	// TriggeredIntent: The Intent that triggered the response. Only name
	// and displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3beta1Intent `json:"triggeredIntent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CreateDocumentOperationMetadata:
// Metadata for CreateDocument operation.
type GoogleCloudDialogflowCxV3beta1CreateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1CreateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata:
// Metadata associated with the long running operation for
// Versions.CreateVersion.
type GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeleteDocumentOperationMetadata:
// Metadata for DeleteDocument operation.
type GoogleCloudDialogflowCxV3beta1DeleteDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DeleteDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeleteDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowMetadata: Metadata returned
// for the Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3beta1DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3beta1TestError `json:"testErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TestErrors") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowRequest: The request message
// for Environments.DeployFlow.
type GoogleCloudDialogflowCxV3beta1DeployFlowRequest struct {
	// FlowVersion: Required. The flow version to deploy. Format:
	// `projects//locations//agents// flows//versions/`.
	FlowVersion string `json:"flowVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FlowVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DeployFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowResponse: The response
// message for Environments.DeployFlow.
type GoogleCloudDialogflowCxV3beta1DeployFlowResponse struct {
	// Deployment: The name of the flow version deployment. Format:
	// `projects//locations//agents// environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`

	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deployment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Deployment: Represents an deployment in
// an environment. A deployment happens when a flow version configured
// to be active in the environment. You can configure running
// pre-deployment steps, e.g. running validation test cases, experiment
// auto-rollout, etc.
type GoogleCloudDialogflowCxV3beta1Deployment struct {
	// EndTime: End time of this deployment.
	EndTime string `json:"endTime,omitempty"`

	// FlowVersion: The name of the flow version for this deployment.
	// Format: projects//locations//agents//flows//versions/.
	FlowVersion string `json:"flowVersion,omitempty"`

	// Name: The name of the deployment. Format:
	// projects//locations//agents//environments//deployments/.
	Name string `json:"name,omitempty"`

	// Result: Result of the deployment.
	Result *GoogleCloudDialogflowCxV3beta1DeploymentResult `json:"result,omitempty"`

	// StartTime: Start time of this deployment.
	StartTime string `json:"startTime,omitempty"`

	// State: The current state of the deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "RUNNING" - The deployment is running.
	//   "SUCCEEDED" - The deployment succeeded.
	//   "FAILED" - The deployment failed.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Deployment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeploymentResult: Result of the
// deployment.
type GoogleCloudDialogflowCxV3beta1DeploymentResult struct {
	// DeploymentTestResults: Results of test cases running before the
	// deployment. Format:
	// `projects//locations//agents//testCases//results/`.
	DeploymentTestResults []string `json:"deploymentTestResults,omitempty"`

	// Experiment: The name of the experiment triggered by this deployment.
	// Format: projects//locations//agents//environments//experiments/.
	Experiment string `json:"experiment,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeploymentTestResults") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeploymentTestResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DeploymentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeploymentResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DetectIntentRequest: The request to
// detect user's intent.
type GoogleCloudDialogflowCxV3beta1DetectIntentRequest struct {
	// OutputAudioConfig: Instructs the speech synthesizer how to generate
	// the output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`

	// QueryInput: Required. The input specification.
	QueryInput *GoogleCloudDialogflowCxV3beta1QueryInput `json:"queryInput,omitempty"`

	// QueryParams: The parameters of this query.
	QueryParams *GoogleCloudDialogflowCxV3beta1QueryParameters `json:"queryParams,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OutputAudioConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputAudioConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DetectIntentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DetectIntentResponse: The message
// returned from the DetectIntent method.
type GoogleCloudDialogflowCxV3beta1DetectIntentResponse struct {
	// AllowCancellation: Indicates whether the partial response can be
	// cancelled when a later response arrives. e.g. if the agent specified
	// some music as partial response, it can be cancelled.
	AllowCancellation bool `json:"allowCancellation,omitempty"`

	// OutputAudio: The audio data bytes encoded as specified in the
	// request. Note: The output audio is generated based on the values of
	// default platform text responses found in the
	// `query_result.response_messages` field. If multiple default text
	// responses exist, they will be concatenated when generating audio. If
	// no default platform text responses exist, the generated audio content
	// will be empty. In some scenarios, multiple output audio fields may be
	// present in the response structure. In these cases, only the
	// top-most-level audio output has content.
	OutputAudio string `json:"outputAudio,omitempty"`

	// OutputAudioConfig: The config used by the speech synthesizer to
	// generate the output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`

	// QueryResult: The result of the conversational query.
	QueryResult *GoogleCloudDialogflowCxV3beta1QueryResult `json:"queryResult,omitempty"`

	// ResponseId: Output only. The unique identifier of the response. It
	// can be used to locate a response in the training example set or for
	// reporting issues.
	ResponseId string `json:"responseId,omitempty"`

	// ResponseType: Response type.
	//
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED" - Not specified. This should never
	// happen.
	//   "PARTIAL" - Partial response. e.g. Aggregated responses in a
	// Fulfillment that enables `return_partial_response` can be returned as
	// partial response. WARNING: partial response is not eligible for
	// barge-in.
	//   "FINAL" - Final response.
	ResponseType string `json:"responseType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AllowCancellation")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowCancellation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DetectIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DetectIntentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DtmfInput: Represents the input for
// dtmf event.
type GoogleCloudDialogflowCxV3beta1DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`

	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Digits") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DtmfInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityType: Entities are extracted from
// user input and represent parameters that are meaningful to your
// application. For example, a date range, a proper name such as a
// geographic location or landmark, and so on. Entities represent
// actionable data for your application. When you define an entity, you
// can also include synonyms that all map to that entity. For example,
// "soft drink", "soda", "pop", and so on. There are three types of
// entities: * **System** - entities that are defined by the Dialogflow
// API for common data types such as date, time, currency, and so on. A
// system entity is represented by the `EntityType` type. * **Custom** -
// entities that are defined by you that represent actionable data that
// is meaningful to your application. For example, you could define a
// `pizza.sauce` entity for red or white pizza sauce, a `pizza.cheese`
// entity for the different types of cheese on a pizza, a
// `pizza.topping` entity for different toppings, and so on. A custom
// entity is represented by the `EntityType` type. * **User** - entities
// that are built for an individual user such as favorites, preferences,
// playlists, and so on. A user entity is represented by the
// SessionEntityType type. For more information about entity types, see
// the Dialogflow documentation
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowCxV3beta1EntityType struct {
	// AutoExpansionMode: Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values
	// that have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`

	// DisplayName: Required. The human-readable name of the entity type,
	// unique within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// EnableFuzzyExtraction: Enables fuzzy entity extraction during
	// classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`

	// Entities: The collection of entity entries associated with the entity
	// type.
	Entities []*GoogleCloudDialogflowCxV3beta1EntityTypeEntity `json:"entities,omitempty"`

	// ExcludedPhrases: Collection of exceptional words and phrases that
	// shouldn't be matched. For example, if you have a size entity type
	// with entry `giant`(an adjective), you might consider adding
	// `giants`(a noun) as an exclusion. If the kind of entity type is
	// `KIND_MAP`, then the phrases specified by entities and excluded
	// phrases should be mutually exclusive.
	ExcludedPhrases []*GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase `json:"excludedPhrases,omitempty"`

	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms
	// to a canonical value.
	//   "KIND_LIST" - List entity types contain a set of entries that do
	// not map to canonical values. However, list entity types can contain
	// references to other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular
	// expressions in entries values.
	Kind string `json:"kind,omitempty"`

	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType. Format:
	// `projects//locations//agents//entityTypes/`.
	Name string `json:"name,omitempty"`

	// Redact: Indicates whether parameters of the entity type should be
	// redacted in log. If redaction is enabled, page parameters and intent
	// parameters referring to the entity type will be replaced by parameter
	// name during logging.
	Redact bool `json:"redact,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoExpansionMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityTypeEntity: An **entity entry**
// for an associated entity type.
type GoogleCloudDialogflowCxV3beta1EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if
	// the entity type is *vegetable*, and `value` is *scallions*, a synonym
	// could be *green onions*. For `KIND_LIST` entity types: * This
	// collection must contain exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`

	// Value: Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*. For `KIND_MAP` entity types: * A canonical value to be
	// used in place of synonyms. For `KIND_LIST` entity types: * A string
	// that can contain references to other entity types (with or without
	// aliases).
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Synonyms") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityTypeEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase: An excluded
// entity phrase that should not be matched.
type GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase struct {
	// Value: Required. The word or phrase to be excluded.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Environment: Represents an environment
// for an agent. You can create multiple versions of your agent and
// publish them to separate environments. When you edit an agent, you
// are editing the draft agent. At any point, you can save the draft
// agent as an agent version, which is an immutable snapshot of your
// agent. When you save the draft agent, it is published to the default
// environment. When you create agent versions, you can publish them to
// custom environments. You can create a variety of custom environments
// for testing, development, production, etc.
type GoogleCloudDialogflowCxV3beta1Environment struct {
	// Description: The human-readable description of the environment. The
	// maximum length is 500 characters. If exceeded, the request is
	// rejected.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the environment
	// (unique in an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`

	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`

	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`

	// VersionConfigs: Required. A list of configurations for flow versions.
	// You should include version configs for all flows that are reachable
	// from `Start Flow` in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig `json:"versionConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Environment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig: The
// configuration for continuous tests.
type GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in
	// TestCasesConfig.test_cases periodically. Default false. If set to
	// true, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`

	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`

	// TestCases: A list of test case names to run. They should be under the
	// same agent. Format of each test case name: `projects//locations/
	// /agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableContinuousRun") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig: Configuration
// for the version.
type GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig struct {
	// Version: Required. Format:
	// projects//locations//agents//flows//versions/.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventHandler: An event handler
// specifies an event that can be handled during a session. When the
// specified event happens, the following actions are taken in order: *
// If there is a `trigger_fulfillment` associated with the event, it
// will be called. * If there is a `target_page` associated with the
// event, the session will transition into the specified page. * If
// there is a `target_flow` associated with the event, the session will
// transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`

	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// TriggerFulfillment: The fulfillment to call when the event occurs.
	// Handling webhook errors with a fulfillment enabled with webhook could
	// cause infinite loop. It is invalid to specify such fulfillment for a
	// handler handling webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Event") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventHandler
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventInput: Represents the event to
// trigger.
type GoogleCloudDialogflowCxV3beta1EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Event") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Experiment: Represents an experiment in
// an environment.
type GoogleCloudDialogflowCxV3beta1Experiment struct {
	// CreateTime: Creation time of this experiment.
	CreateTime string `json:"createTime,omitempty"`

	// Definition: The definition of the experiment.
	Definition *GoogleCloudDialogflowCxV3beta1ExperimentDefinition `json:"definition,omitempty"`

	// Description: The human-readable description of the experiment.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the experiment
	// (unique in an environment). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`

	// EndTime: End time of this experiment.
	EndTime string `json:"endTime,omitempty"`

	// ExperimentLength: Maximum number of days to run the experiment. If
	// auto-rollout is not enabled, default value and maximum will be 30
	// days. If auto-rollout is enabled, default value and maximum will be 6
	// days.
	ExperimentLength string `json:"experimentLength,omitempty"`

	// LastUpdateTime: Last update time of this experiment.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// Name: The name of the experiment. Format:
	// projects//locations//agents//environments//experiments/..
	Name string `json:"name,omitempty"`

	// Result: Inference result of the experiment.
	Result *GoogleCloudDialogflowCxV3beta1ExperimentResult `json:"result,omitempty"`

	// RolloutConfig: The configuration for auto rollout. If set, there
	// should be exactly two variants in the experiment (control variant
	// being the default version of the flow), the traffic allocation for
	// the non-control variant will gradually increase to 100% when
	// conditions are met, and eventually replace the control variant to
	// become the default version of the flow.
	RolloutConfig *GoogleCloudDialogflowCxV3beta1RolloutConfig `json:"rolloutConfig,omitempty"`

	// RolloutFailureReason: The reason why rollout has failed. Should only
	// be set when state is ROLLOUT_FAILED.
	RolloutFailureReason string `json:"rolloutFailureReason,omitempty"`

	// RolloutState: State of the auto rollout process.
	RolloutState *GoogleCloudDialogflowCxV3beta1RolloutState `json:"rolloutState,omitempty"`

	// StartTime: Start time of this experiment.
	StartTime string `json:"startTime,omitempty"`

	// State: The current state of the experiment. Transition triggered by
	// Experiments.StartExperiment: DRAFT->RUNNING. Transition triggered by
	// Experiments.CancelExperiment: DRAFT->DONE or RUNNING->DONE.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "DRAFT" - The experiment is created but not started yet.
	//   "RUNNING" - The experiment is running.
	//   "DONE" - The experiment is done.
	//   "ROLLOUT_FAILED" - The experiment with auto-rollout enabled has
	// failed.
	State string `json:"state,omitempty"`

	// VariantsHistory: The history of updates to the experiment variants.
	VariantsHistory []*GoogleCloudDialogflowCxV3beta1VariantsHistory `json:"variantsHistory,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Experiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Experiment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentDefinition: Definition of the
// experiment.
type GoogleCloudDialogflowCxV3beta1ExperimentDefinition struct {
	// Condition: The condition defines which subset of sessions are
	// selected for this experiment. If not specified, all sessions are
	// eligible. E.g. "query_input.language_code=en" See the conditions
	// reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`

	// VersionVariants: The flow versions as the variants of this
	// experiment.
	VersionVariants *GoogleCloudDialogflowCxV3beta1VersionVariants `json:"versionVariants,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentDefinition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentResult: The inference result
// which includes an objective metric to optimize and the confidence
// interval.
type GoogleCloudDialogflowCxV3beta1ExperimentResult struct {
	// LastUpdateTime: The last time the experiment's stats data was
	// updated. Will have default value if stats have never been computed
	// for this experiment.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// VersionMetrics: Version variants and metrics.
	VersionMetrics []*GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics `json:"versionMetrics,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastUpdateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastUpdateTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval: A
// confidence interval is a range of possible values for the experiment
// objective you are trying to measure.
type GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval struct {
	// ConfidenceLevel: The confidence level used to construct the interval,
	// i.e. there is X% chance that the true value is within this interval.
	ConfidenceLevel float64 `json:"confidenceLevel,omitempty"`

	// LowerBound: Lower bound of the interval.
	LowerBound float64 `json:"lowerBound,omitempty"`

	// Ratio: The percent change between an experiment metric's value and
	// the value for its control.
	Ratio float64 `json:"ratio,omitempty"`

	// UpperBound: Upper bound of the interval.
	UpperBound float64 `json:"upperBound,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceLevel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceLevel") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval
	var s1 struct {
		ConfidenceLevel gensupport.JSONFloat64 `json:"confidenceLevel"`
		LowerBound      gensupport.JSONFloat64 `json:"lowerBound"`
		Ratio           gensupport.JSONFloat64 `json:"ratio"`
		UpperBound      gensupport.JSONFloat64 `json:"upperBound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceLevel = float64(s1.ConfidenceLevel)
	s.LowerBound = float64(s1.LowerBound)
	s.Ratio = float64(s1.Ratio)
	s.UpperBound = float64(s1.UpperBound)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultMetric: Metric and
// corresponding confidence intervals.
type GoogleCloudDialogflowCxV3beta1ExperimentResultMetric struct {
	// ConfidenceInterval: The probability that the treatment is better than
	// all other treatments in the experiment
	ConfidenceInterval *GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval `json:"confidenceInterval,omitempty"`

	// Count: Count value of a metric.
	Count float64 `json:"count,omitempty"`

	// CountType: Count-based metric type. Only one of type or count_type is
	// specified in each Metric.
	//
	// Possible values:
	//   "COUNT_TYPE_UNSPECIFIED" - Count type unspecified.
	//   "TOTAL_NO_MATCH_COUNT" - Total number of occurrences of a
	// 'NO_MATCH'.
	//   "TOTAL_TURN_COUNT" - Total number of turn counts.
	//   "AVERAGE_TURN_COUNT" - Average turn count in a session.
	CountType string `json:"countType,omitempty"`

	// Ratio: Ratio value of a metric.
	Ratio float64 `json:"ratio,omitempty"`

	// Type: Ratio-based metric type. Only one of type or count_type is
	// specified in each Metric.
	//
	// Possible values:
	//   "METRIC_UNSPECIFIED" - Metric unspecified.
	//   "CONTAINED_SESSION_NO_CALLBACK_RATE" - Percentage of contained
	// sessions without user calling back in 24 hours.
	//   "LIVE_AGENT_HANDOFF_RATE" - Percentage of sessions that were handed
	// to a human agent.
	//   "CALLBACK_SESSION_RATE" - Percentage of sessions with the same user
	// calling back.
	//   "ABANDONED_SESSION_RATE" - Percentage of sessions where user hung
	// up.
	//   "SESSION_END_RATE" - Percentage of sessions reached Dialogflow
	// 'END_PAGE' or 'END_SESSION'.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfidenceInterval")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfidenceInterval") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultMetric) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultMetric
	var s1 struct {
		Count gensupport.JSONFloat64 `json:"count"`
		Ratio gensupport.JSONFloat64 `json:"ratio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Count = float64(s1.Count)
	s.Ratio = float64(s1.Ratio)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics: Version
// variant and associated metrics.
type GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics struct {
	// Metrics: The metrics and corresponding confidence intervals in the
	// inference result.
	Metrics []*GoogleCloudDialogflowCxV3beta1ExperimentResultMetric `json:"metrics,omitempty"`

	// SessionCount: Number of sessions that were allocated to this version.
	SessionCount int64 `json:"sessionCount,omitempty"`

	// Version: The name of the flow Version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metrics") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentRequest: The request message
// for Agents.ExportAgent.
type GoogleCloudDialogflowCxV3beta1ExportAgentRequest struct {
	// AgentUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the agent to.
	// The format of this URI must be `gs:///`. If left unspecified, the
	// serialized agent is returned inline.
	AgentUri string `json:"agentUri,omitempty"`

	// Environment: Optional. Environment name. If not set, draft
	// environment is assumed. Format:
	// `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentResponse: The response
// message for Agents.ExportAgent.
type GoogleCloudDialogflowCxV3beta1ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`

	// AgentUri: The URI to a file containing the exported agent. This field
	// is populated only if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportFlowRequest: The request message
// for Flows.ExportFlow.
type GoogleCloudDialogflowCxV3beta1ExportFlowRequest struct {
	// FlowUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the flow to.
	// The format of this URI must be `gs:///`. If left unspecified, the
	// serialized flow is returned inline.
	FlowUri string `json:"flowUri,omitempty"`

	// IncludeReferencedFlows: Optional. Whether to export flows referenced
	// by the specified flow.
	IncludeReferencedFlows bool `json:"includeReferencedFlows,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FlowUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportFlowResponse: The response
// message for Flows.ExportFlow.
type GoogleCloudDialogflowCxV3beta1ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`

	// FlowUri: The URI to a file containing the exported flow. This field
	// is populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata: Metadata
// returned for the TestCases.ExportTestCases long running operation.
// This message currently has no fields.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest: The request
// message for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest struct {
	// DataFormat: The data format of the exported test cases. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format.
	//   "BLOB" - Raw bytes.
	//   "JSON" - JSON format.
	DataFormat string `json:"dataFormat,omitempty"`

	// Filter: The filter expression used to filter exported test cases, see
	// API Filtering (https://aip.dev/160). The expression is case
	// insensitive and supports the following syntax: name = [OR name = ]
	// ... For example: * "name = t1 OR name = t2" matches the test case
	// with the exact resource name "t1" or "t2".
	Filter string `json:"filter,omitempty"`

	// GcsUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the test cases
	// to. The format of this URI must be `gs:///`. If unspecified, the
	// serialized test cases is returned inline.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataFormat") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse: The response
// message for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`

	// GcsUri: The URI to a file containing the exported test cases. This
	// field is populated only if `gcs_uri` is specified in
	// ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Flow: Flows represents the conversation
// flows when you build your chatbot agent. A flow consists of many
// pages connected by the transition routes. Conversations always start
// with the built-in Start Flow (with an all-0 ID). Transition routes
// can direct the conversation session from the current flow (parent
// flow) to another flow (sub flow). When the sub flow is finished,
// Dialogflow will bring the session back to the parent flow, where the
// sub flow is started. Usually, when a transition route is followed by
// a matched intent, the intent will be "consumed". This means the
// intent won't activate more transition routes. However, when the
// followed transition route moves the conversation session into a
// different flow, the matched intent can be carried over and to be
// consumed in the target flow.
type GoogleCloudDialogflowCxV3beta1Flow struct {
	// Description: The description of the flow. The maximum length is 500
	// characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the flow.
	DisplayName string `json:"displayName,omitempty"`

	// EventHandlers: A flow's event handlers serve two purposes: * They are
	// responsible for handling events (e.g. no match, webhook errors) in
	// the flow. * They are inherited by every page's event handlers, which
	// can be used to handle common events regardless of the current page.
	// Event handlers defined in the page have higher priority than those
	// defined in the flow. Unlike transition_routes, these handlers are
	// evaluated on a first-match basis. The first one that matches the
	// event get executed, with the rest being ignored.
	EventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandlers,omitempty"`

	// Name: The unique identifier of the flow. Format:
	// `projects//locations//agents//flows/`.
	Name string `json:"name,omitempty"`

	// NluSettings: NLU related settings of the flow.
	NluSettings *GoogleCloudDialogflowCxV3beta1NluSettings `json:"nluSettings,omitempty"`

	// TransitionRouteGroups: A flow's transition route group serve two
	// purposes: * They are responsible for matching the user's first
	// utterances in the flow. * They are inherited by every page's
	// transition route groups. Transition route groups defined in the page
	// have higher priority than those defined in the flow.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/`.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`

	// TransitionRoutes: A flow's transition routes serve two purposes: *
	// They are responsible for matching the user's first utterances in the
	// flow. * They are inherited by every page's transition routes and can
	// support use cases such as the user saying "help" or "can I talk to a
	// human?", which can be handled in a common way regardless of the
	// current page. Transition routes defined in the page have higher
	// priority than those defined in the flow. TransitionRoutes are
	// evalauted in the following order: * TransitionRoutes with intent
	// specified.. * TransitionRoutes with only condition specified.
	// TransitionRoutes with intent specified are inherited by pages in the
	// flow.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Flow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Flow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowValidationResult: The response
// message for Flows.GetFlowValidationResult.
type GoogleCloudDialogflowCxV3beta1FlowValidationResult struct {
	// Name: The unique identifier of the flow validation result. Format:
	// `projects//locations//agents//flows//validationResult`.
	Name string `json:"name,omitempty"`

	// UpdateTime: Last time the flow was validated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValidationMessages: Contains all validation messages.
	ValidationMessages []*GoogleCloudDialogflowCxV3beta1ValidationMessage `json:"validationMessages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FlowValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowValidationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Form: A form is a data model that
// groups related parameters that can be collected from the user. The
// process in which the agent prompts the user and collects parameter
// values from the user is called form filling. A form can be added to a
// page. When form filling is done, the filled parameters will be
// written to the session.
type GoogleCloudDialogflowCxV3beta1Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3beta1FormParameter `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Form
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameter: Represents a form
// parameter.
type GoogleCloudDialogflowCxV3beta1FormParameter struct {
	// DefaultValue: The default value of an optional parameter. If the
	// parameter is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`

	// DisplayName: Required. The human-readable name of the parameter,
	// unique within the form.
	DisplayName string `json:"displayName,omitempty"`

	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity
	// types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity
	// types.
	EntityType string `json:"entityType,omitempty"`

	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior `json:"fillBehavior,omitempty"`

	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`

	// Redact: Indicates whether the parameter content should be redacted in
	// log. If redaction is enabled, the parameter content will be replaced
	// by parameter name during logging. Note: the parameter content is
	// subject to redaction if either parameter level redaction or entity
	// type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`

	// Required: Indicates whether the parameter is required. Optional
	// parameters will not trigger prompts; however, they are filled if the
	// user specifies them. Required parameters must be filled before form
	// filling concludes.
	Required bool `json:"required,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior:
// Configuration for how the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the
	// initial prompt that the agent can present to the user in order to
	// fill the parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"initialPromptFulfillment,omitempty"`

	// RepromptEventHandlers: The handlers for parameter-level events, used
	// to provide reprompt for the parameter or transition to a different
	// page/flow. The supported events are: * `sys.no-match-`, where N can
	// be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N
	// can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the
	// parameter. If the user's response does not fill the parameter, a
	// no-match/no-input event will be triggered, and the fulfillment
	// associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
	// defined) will be called to provide a prompt. The
	// `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond
	// to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used
	// to handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case
	// where the parameter values have been `invalidated` by webhook. For
	// example, if the user's response fill the parameter, however the
	// parameter was invalidated by webhook, the fulfillment associated with
	// the `sys.invalid-parameter` handler (if defined) will be called to
	// provide a prompt. If the event handler for the corresponding event
	// can't be found on the parameter, `initial_prompt_fulfillment` will be
	// re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"repromptEventHandlers,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "InitialPromptFulfillment") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillIntentRequest: Request of
// FulfillIntent
type GoogleCloudDialogflowCxV3beta1FulfillIntentRequest struct {
	// Match: The matched intent/event to fulfill.
	Match *GoogleCloudDialogflowCxV3beta1Match `json:"match,omitempty"`

	// MatchIntentRequest: Must be same as the corresponding MatchIntent
	// request, otherwise the behavior is undefined.
	MatchIntentRequest *GoogleCloudDialogflowCxV3beta1MatchIntentRequest `json:"matchIntentRequest,omitempty"`

	// OutputAudioConfig: Instructs the speech synthesizer how to generate
	// output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Match") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Match") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillIntentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillIntentResponse: Response of
// FulfillIntent
type GoogleCloudDialogflowCxV3beta1FulfillIntentResponse struct {
	// OutputAudio: The audio data bytes encoded as specified in the
	// request. Note: The output audio is generated based on the values of
	// default platform text responses found in the
	// `query_result.response_messages` field. If multiple default text
	// responses exist, they will be concatenated when generating audio. If
	// no default platform text responses exist, the generated audio content
	// will be empty. In some scenarios, multiple output audio fields may be
	// present in the response structure. In these cases, only the
	// top-most-level audio output has content.
	OutputAudio string `json:"outputAudio,omitempty"`

	// OutputAudioConfig: The config used by the speech synthesizer to
	// generate the output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`

	// QueryResult: The result of the conversational query.
	QueryResult *GoogleCloudDialogflowCxV3beta1QueryResult `json:"queryResult,omitempty"`

	// ResponseId: Output only. The unique identifier of the response. It
	// can be used to locate a response in the training example set or for
	// reporting issues.
	ResponseId string `json:"responseId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "OutputAudio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OutputAudio") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillIntentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Fulfillment: A fulfillment can do one
// or more of the following actions at the same time: * Generate rich
// message responses. * Set parameter values. * Call the webhook.
// Fulfillments can be called at various stages in the Page or Form
// lifecycle. For example, when a DetectIntentRequest drives a session
// to enter a new page, the page's entry fulfillment can add a static
// response to the QueryResult in the returning DetectIntentResponse,
// call the webhook (for example, to load user data from a database), or
// both.
type GoogleCloudDialogflowCxV3beta1Fulfillment struct {
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"conditionalCases,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`

	// ReturnPartialResponses: Whether Dialogflow should return currently
	// queued fulfillment response messages in streaming APIs. If a webhook
	// is specified, it happens before Dialogflow invokes webhook. Warning:
	// 1) This flag only affects streaming API. Responses are still queued
	// and returned once in non-streaming API. 2) The flag can be enabled in
	// any fulfillment but only the first 3 partial responses will be
	// returned. You may only want to apply it to fulfillments that have
	// slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`

	// SetParameterActions: Set parameter values before executing the
	// webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`

	// Tag: The tag used by the webhook to identify which fulfillment is
	// being called. This field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`

	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConditionalCases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConditionalCases") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Fulfillment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases: A list of
// cascading if-else conditions. Cases are mutually exclusive. The first
// one with a matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase `json:"cases,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase: Each
// case has a Boolean condition. When it is evaluated to be True, the
// corresponding messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`

	// Condition: The condition to activate and select this case. Empty
	// means the condition is always true. The condition is evaluated
	// against form parameters or session parameters. See the conditions
	// reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseConte
// nt: The list of messages or conditional cases to activate for this
// case.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"additionalCases,omitempty"`

	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalCases") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction: Setting
// a parameter value.
type GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`

	// Value: The new value of the parameter. A null value clears the
	// parameter.
	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata:
// Metadata in google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata struct {
	// State: Required. Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportDocumentsOperationMetadata:
// Metadata for ImportDocuments operation.
type GoogleCloudDialogflowCxV3beta1ImportDocumentsOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportDocumentsOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportDocumentsOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportDocumentsResponse: Response
// message for Documents.ImportDocuments.
type GoogleCloudDialogflowCxV3beta1ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other
	// warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Warnings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportFlowRequest: The request message
// for Flows.ImportFlow.
type GoogleCloudDialogflowCxV3beta1ImportFlowRequest struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`

	// FlowUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to import flow from. The
	// format of this URI must be `gs:///`.
	FlowUri string `json:"flowUri,omitempty"`

	// ImportOption: Flow import mode. If not specified, `KEEP` is assumed.
	//
	// Possible values:
	//   "IMPORT_OPTION_UNSPECIFIED" - Unspecified. Treated as `KEEP`.
	//   "KEEP" - Always respect settings in exported flow content. It may
	// cause a import failure if some settings (e.g. custom NLU) are not
	// supported in the agent to import into.
	//   "FALLBACK" - Fallback to default settings if some settings are not
	// supported in the agent to import into. E.g. Standard NLU will be used
	// if custom NLU is not available.
	ImportOption string `json:"importOption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FlowContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportFlowResponse: The response
// message for Flows.ImportFlow.
type GoogleCloudDialogflowCxV3beta1ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata: Metadata
// returned for the TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3beta1TestCaseError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest: The request
// message for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`

	// GcsUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to import test cases
	// from. The format of this URI must be `gs:///`.
	GcsUri string `json:"gcsUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse: The response
// message for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InputAudioConfig: Instructs the speech
// recognizer on how to process the audio content.
type GoogleCloudDialogflowCxV3beta1InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to
	// process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed
	// little-endian samples (Linear PCM).
	//   "AUDIO_ENCODING_FLAC" -
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless
	// Audio Codec) is the recommended encoding because it is lossless
	// (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO`
	// are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio
	// samples using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg
	// container ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is
	// required, `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has
	// a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`. It is a variant of the RTP Speex
	// encoding defined in [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each
	// block starts with a byte containing the length of the block, in
	// bytes, followed by one or more frames of Speex data, padded to an
	// integral number of bytes (octets) as specified in RFC 5574. In other
	// words, each RTP header is replaced with a single byte containing the
	// block length. Only Speex wideband is supported. `sample_rate_hertz`
	// must be 16000.
	AudioEncoding string `json:"audioEncoding,omitempty"`

	// EnableWordInfo: Optional. If `true`, Dialogflow returns
	// SpeechWordInfo in StreamingRecognitionResult with information about
	// the recognized speech words, e.g. start and end time offsets. If
	// false or unspecified, Speech doesn't return any word-level
	// information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`

	// Model: Optional. Which Speech model to select for the given request.
	// Select the model best suited to your domain to get best results. If a
	// model is not explicitly specified, then we auto-select a model based
	// on the parameters in the InputAudioConfig. If enhanced speech model
	// is enabled for the agent and an enhanced version of the specified
	// model for the language does not exist, then the speech is recognized
	// using the standard version of the specified model. Refer to Cloud
	// Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#select-model)
	// for more details.
	Model string `json:"model,omitempty"`

	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In
	// this case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech
	// model that the caller is eligible for. Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for how
	// to make your project eligible for enhanced models.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced
	// model is available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-m
	// odels) for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced
	// variant does not exist for the given model and request language,
	// Dialogflow falls back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-m
	// odels) describes which models have enhanced variants. * If the API
	// caller isn't eligible for enhanced models, Dialogflow returns an
	// error. Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for how
	// to make your project eligible.
	ModelVariant string `json:"modelVariant,omitempty"`

	// PhraseHints: Optional. A list of strings containing words and phrases
	// that the speech recognizer should recognize with higher likelihood.
	// See the Cloud Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	PhraseHints []string `json:"phraseHints,omitempty"`

	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in
	// the query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more
	// details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`

	// SingleUtterance: Optional. If `false` (default), recognition does not
	// cease until the client closes the stream. If `true`, the recognizer
	// will detect a single spoken utterance in input audio. Recognition
	// ceases when it detects the audio's voice has stopped or paused. In
	// this case, once a detected intent is received, the client should
	// close the stream and start a new request with a new stream as needed.
	// Note: This setting is relevant only for streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioEncoding") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InputAudioConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Intent: An intent represents a user's
// intent to interact with a conversational agent. You can provide
// information for the Dialogflow API to use to match user input to an
// intent by adding training phrases (i.e., examples of user input) to
// your intent.
type GoogleCloudDialogflowCxV3beta1Intent struct {
	// Description: Human readable description for better understanding an
	// intent like its scope, content, result etc. Maximum character limit:
	// 140 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the intent, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// IsFallback: Indicates whether this is a fallback intent. Currently
	// only default fallback intent is allowed in the agent, which is added
	// upon agent creation. Adding training phrases to fallback intent is
	// useful in the case of requests that are mistakenly matched, since
	// training phrases assigned to fallback intents act as negative
	// examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`

	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets.
	// Keys must start with a letter. Keys and values can be no longer than
	// 63 characters and no more than 128 bytes. Prefix "sys-" is reserved
	// for Dialogflow defined labels. Currently allowed Dialogflow defined
	// labels include: * sys-head * sys-contextual The above labels do not
	// require value. "sys-head" means the intent is a head intent.
	// "sys-contextual" means the intent is a contextual intent.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`

	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3beta1IntentParameter `json:"parameters,omitempty"`

	// Priority: The priority of this intent. Higher numbers represent
	// higher priorities. - If the supplied value is unspecified or 0, the
	// service translates the value to 500,000, which corresponds to the
	// `Normal` priority in the console. - If the supplied value is
	// negative, the intent is ignored in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`

	// TrainingPhrases: The collection of training phrases the agent is
	// trained on to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Intent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentCoverage: Intent coverage
// represents the percentage of all possible intents in the agent that
// are triggered in any of a parent's test cases.
type GoogleCloudDialogflowCxV3beta1IntentCoverage struct {
	// CoverageScore: The percent of intents in the agent that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`

	// Intents: The list of Intents present in the agent
	Intents []*GoogleCloudDialogflowCxV3beta1IntentCoverageIntent `json:"intents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoverageScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1IntentCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1IntentCoverageIntent: The agent's
// intent.
type GoogleCloudDialogflowCxV3beta1IntentCoverageIntent struct {
	// Covered: Whether or not the intent is covered by at least one of the
	// agent's test cases.
	Covered bool `json:"covered,omitempty"`

	// Intent: The intent full resource name
	Intent string `json:"intent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Covered") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Covered") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentCoverageIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverageIntent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentInput: Represents the intent to
// trigger programmatically rather than as a result of natural language
// processing.
type GoogleCloudDialogflowCxV3beta1IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Intent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentParameter: Represents an intent
// parameter.
type GoogleCloudDialogflowCxV3beta1IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity
	// types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity
	// types.
	EntityType string `json:"entityType,omitempty"`

	// Id: Required. The unique identifier of the parameter. This field is
	// used by training phrases to annotate their parts.
	Id string `json:"id,omitempty"`

	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`

	// Redact: Indicates whether the parameter content should be redacted in
	// log. If redaction is enabled, the parameter content will be replaced
	// by parameter name during logging. Note: the parameter content is
	// subject to redaction if either parameter level redaction or entity
	// type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase: Represents an
// example that the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`

	// Parts: Required. The ordered list of training phrase parts. The parts
	// are concatenated in order to form the training phrase. Note: The API
	// does not automatically annotate training phrases like the Dialogflow
	// Console does. Note: Do not forget to include whitespace at part
	// boundaries, so the training phrase is well formatted when the parts
	// are concatenated. If the training phrase does not need to be
	// annotated with parameters, you just need a single part with only the
	// Part.text field set. If you want to annotate the training phrase, you
	// must create multiple parts, where the fields of each part are
	// populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the
	// phrase that you want to annotate, and the `parameter_id` field is
	// set.
	Parts []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart `json:"parts,omitempty"`

	// RepeatCount: Indicates how many times this example was added to the
	// intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart: Represents a
// part of a training phrase.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training
	// phrase.
	ParameterId string `json:"parameterId,omitempty"`

	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParameterId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListAgentsResponse: The response
// message for Agents.ListAgents.
type GoogleCloudDialogflowCxV3beta1ListAgentsResponse struct {
	// Agents: The list of agents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Agents []*GoogleCloudDialogflowCxV3beta1Agent `json:"agents,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Agents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListAgentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListAgentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListChangelogsResponse: The response
// message for Changelogs.ListChangelogs.
type GoogleCloudDialogflowCxV3beta1ListChangelogsResponse struct {
	// Changelogs: The list of changelogs. There will be a maximum number of
	// items returned based on the page_size field in the request. The
	// changelogs will be ordered by timestamp.
	Changelogs []*GoogleCloudDialogflowCxV3beta1Changelog `json:"changelogs,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Changelogs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Changelogs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListChangelogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListChangelogsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse: The
// response message for Environments.ListTestCaseResults.
type GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse struct {
	// ContinuousTestResults: The list of continuous test results.
	ContinuousTestResults []*GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResults,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ContinuousTestResults") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContinuousTestResults") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse: The response
// message for Deployments.ListDeployments.
type GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse struct {
	// Deployments: The list of deployments. There will be a maximum number
	// of items returned based on the page_size field in the request. The
	// list may in some cases be empty or contain fewer entries than
	// page_size even if this isn't the last page.
	Deployments []*GoogleCloudDialogflowCxV3beta1Deployment `json:"deployments,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deployments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse: The response
// message for EntityTypes.ListEntityTypes.
type GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse struct {
	// EntityTypes: The list of entity types. There will be a maximum number
	// of items returned based on the page_size field in the request.
	EntityTypes []*GoogleCloudDialogflowCxV3beta1EntityType `json:"entityTypes,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse: The response
// message for Environments.ListEnvironments.
type GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse struct {
	// Environments: The list of environments. There will be a maximum
	// number of items returned based on the page_size field in the request.
	// The list may in some cases be empty or contain fewer entries than
	// page_size even if this isn't the last page.
	Environments []*GoogleCloudDialogflowCxV3beta1Environment `json:"environments,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListExperimentsResponse: The response
// message for Experiments.ListExperiments.
type GoogleCloudDialogflowCxV3beta1ListExperimentsResponse struct {
	// Experiments: The list of experiments. There will be a maximum number
	// of items returned based on the page_size field in the request. The
	// list may in some cases be empty or contain fewer entries than
	// page_size even if this isn't the last page.
	Experiments []*GoogleCloudDialogflowCxV3beta1Experiment `json:"experiments,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Experiments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Experiments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListExperimentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListExperimentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListFlowsResponse: The response message
// for Flows.ListFlows.
type GoogleCloudDialogflowCxV3beta1ListFlowsResponse struct {
	// Flows: The list of flows. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Flows []*GoogleCloudDialogflowCxV3beta1Flow `json:"flows,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Flows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flows") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListFlowsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListFlowsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListIntentsResponse: The response
// message for Intents.ListIntents.
type GoogleCloudDialogflowCxV3beta1ListIntentsResponse struct {
	// Intents: The list of intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*GoogleCloudDialogflowCxV3beta1Intent `json:"intents,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Intents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Intents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListIntentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListPagesResponse: The response message
// for Pages.ListPages.
type GoogleCloudDialogflowCxV3beta1ListPagesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Pages: The list of pages. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Pages []*GoogleCloudDialogflowCxV3beta1Page `json:"pages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListPagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListPagesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse: The
// response message for SecuritySettings.ListSecuritySettings.
type GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecuritySettings: The list of security settings.
	SecuritySettings []*GoogleCloudDialogflowCxV3beta1SecuritySettings `json:"securitySettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse: The
// response message for SessionEntityTypes.ListSessionEntityTypes.
type GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SessionEntityTypes: The list of session entity types. There will be a
	// maximum number of items returned based on the page_size field in the
	// request.
	SessionEntityTypes []*GoogleCloudDialogflowCxV3beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse: The
// response message for TestCases.ListTestCaseResults.
type GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TestCaseResults: The list of test case results.
	TestCaseResults []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"testCaseResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTestCasesResponse: The response
// message for TestCases.ListTestCases.
type GoogleCloudDialogflowCxV3beta1ListTestCasesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TestCases: The list of test cases. There will be a maximum number of
	// items returned based on the page_size field in the request.
	TestCases []*GoogleCloudDialogflowCxV3beta1TestCase `json:"testCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTestCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse: The
// response message for TransitionRouteGroups.ListTransitionRouteGroups.
type GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TransitionRouteGroups: The list of transition route groups. There
	// will be a maximum number of items returned based on the page_size
	// field in the request. The list may in some cases be empty or contain
	// fewer entries than page_size even if this isn't the last page.
	TransitionRouteGroups []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroup `json:"transitionRouteGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListVersionsResponse: The response
// message for Versions.ListVersions.
type GoogleCloudDialogflowCxV3beta1ListVersionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Versions: A list of versions. There will be a maximum number of items
	// returned based on the page_size field in the request. The list may in
	// some cases be empty or contain fewer entries than page_size even if
	// this isn't the last page.
	Versions []*GoogleCloudDialogflowCxV3beta1Version `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListWebhooksResponse: The response
// message for Webhooks.ListWebhooks.
type GoogleCloudDialogflowCxV3beta1ListWebhooksResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Webhooks: The list of webhooks. There will be a maximum number of
	// items returned based on the page_size field in the request.
	Webhooks []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhooks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ListWebhooksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListWebhooksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LoadVersionRequest: The request message
// for Versions.LoadVersion.
type GoogleCloudDialogflowCxV3beta1LoadVersionRequest struct {
	// AllowOverrideAgentResources: This field is used to prevent accidental
	// overwrite of other agent resources, which can potentially impact
	// other flow's behavior. If `allow_override_agent_resources` is false,
	// conflicted agent-level resources will not be overridden (i.e.
	// intents, entities, webhooks).
	AllowOverrideAgentResources bool `json:"allowOverrideAgentResources,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowOverrideAgentResources") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowOverrideAgentResources") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1LoadVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LoadVersionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse: The
// response message for Environments.LookupEnvironmentHistory.
type GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse struct {
	// Environments: Represents a list of snapshots for an environment. Time
	// of the snapshots is stored in `update_time`.
	Environments []*GoogleCloudDialogflowCxV3beta1Environment `json:"environments,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Match: Represents one match result of
// MatchIntent.
type GoogleCloudDialogflowCxV3beta1Match struct {
	// Confidence: The confidence of this match. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain). This value is for
	// informational purpose only and is only used to help match the best
	// intent within the classification threshold. This value may change for
	// the same end-user expression at any time due to a model retraining or
	// change in implementation.
	Confidence float64 `json:"confidence,omitempty"`

	// Event: The event that matched the query. Only filled for `EVENT`
	// match type.
	Event string `json:"event,omitempty"`

	// Intent: The Intent that matched the query. Some, not all fields are
	// filled in this message, including but not limited to: `name` and
	// `display_name`. Only filled for `INTENT` match type.
	Intent *GoogleCloudDialogflowCxV3beta1Intent `json:"intent,omitempty"`

	// MatchType: Type of this Match.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Not specified. Should never be used.
	//   "INTENT" - The query was matched to an intent.
	//   "DIRECT_INTENT" - The query directly triggered an intent.
	//   "PARAMETER_FILLING" - The query was used for parameter filling.
	//   "NO_MATCH" - No match was found for the query.
	//   "NO_INPUT" - Indicates an empty query.
	//   "EVENT" - The query directly triggered an event.
	MatchType string `json:"matchType,omitempty"`

	// Parameters: The collection of parameters extracted from the query.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed
	// of a collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ResolvedInput: Final text input which was matched during MatchIntent.
	// This value can be different from original input sent in request
	// because of spelling correction or other processing.
	ResolvedInput string `json:"resolvedInput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Match) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Match
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1Match) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1Match
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1MatchIntentRequest: Request of
// MatchIntent.
type GoogleCloudDialogflowCxV3beta1MatchIntentRequest struct {
	// QueryInput: Required. The input specification.
	QueryInput *GoogleCloudDialogflowCxV3beta1QueryInput `json:"queryInput,omitempty"`

	// QueryParams: The parameters of this query.
	QueryParams *GoogleCloudDialogflowCxV3beta1QueryParameters `json:"queryParams,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QueryInput") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QueryInput") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1MatchIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1MatchIntentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1MatchIntentResponse: Response of
// MatchIntent.
type GoogleCloudDialogflowCxV3beta1MatchIntentResponse struct {
	// CurrentPage: The current Page. Some, not all fields are filled in
	// this message, including but not limited to `name` and `display_name`.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`

	// Matches: Match results, if more than one, ordered descendingly by the
	// confidence we have that the particular intent matches the query.
	Matches []*GoogleCloudDialogflowCxV3beta1Match `json:"matches,omitempty"`

	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`

	// Transcript: If natural language speech audio was provided as input,
	// this field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`

	// TriggerEvent: If an event was provided as input, this field will
	// contain a copy of the event name.
	TriggerEvent string `json:"triggerEvent,omitempty"`

	// TriggerIntent: If an intent was provided as input, this field will
	// contain a copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1MatchIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1MatchIntentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1NluSettings: Settings related to NLU.
type GoogleCloudDialogflowCxV3beta1NluSettings struct {
	// ClassificationThreshold: To filter out false positive results and
	// still get variety in matched natural language inputs for your agent,
	// you can tune the machine learning classification threshold. If the
	// returned score value is less than the threshold value, then a
	// no-match event will be triggered. The score values range from 0.0
	// (completely uncertain) to 1.0 (completely certain). If set to 0.0,
	// the default of 0.3 is used.
	ClassificationThreshold float64 `json:"classificationThreshold,omitempty"`

	// ModelTrainingMode: Indicates NLU model training mode.
	//
	// Possible values:
	//   "MODEL_TRAINING_MODE_UNSPECIFIED" - Not specified.
	// `MODEL_TRAINING_MODE_AUTOMATIC` will be used.
	//   "MODEL_TRAINING_MODE_AUTOMATIC" - NLU model training is
	// automatically triggered when a flow gets modified. User can also
	// manually trigger model training in this mode.
	//   "MODEL_TRAINING_MODE_MANUAL" - User needs to manually trigger NLU
	// model training. Best for large flows whose models take long time to
	// train.
	ModelTrainingMode string `json:"modelTrainingMode,omitempty"`

	// ModelType: Indicates the type of NLU model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Not specified. `MODEL_TYPE_STANDARD`
	// will be used.
	//   "MODEL_TYPE_STANDARD" - Use standard NLU model.
	//   "MODEL_TYPE_ADVANCED" - Use advanced NLU model.
	ModelType string `json:"modelType,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClassificationThreshold") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClassificationThreshold")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1NluSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1NluSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1NluSettings) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1NluSettings
	var s1 struct {
		ClassificationThreshold gensupport.JSONFloat64 `json:"classificationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClassificationThreshold = float64(s1.ClassificationThreshold)
	return nil
}

// GoogleCloudDialogflowCxV3beta1OutputAudioConfig: Instructs the speech
// synthesizer how to generate the output audio content.
type GoogleCloudDialogflowCxV3beta1OutputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the synthesized audio
	// content.
	//
	// Possible values:
	//   "OUTPUT_AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "OUTPUT_AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed
	// little-endian samples (Linear PCM). Audio content returned as
	// LINEAR16 also contains a WAV header.
	//   "OUTPUT_AUDIO_ENCODING_MP3" - MP3 audio at 32kbps.
	//   "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS" - MP3 audio at 64kbps.
	//   "OUTPUT_AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio wrapped in an
	// ogg container. The result will be a file which can be played natively
	// on Android, and in browsers (at least Chrome and Firefox). The
	// quality of the encoding is considerably higher than MP3 while using
	// approximately the same bitrate.
	//   "OUTPUT_AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit
	// audio samples using G.711 PCMU/mu-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`

	// SampleRateHertz: Optional. The synthesis sample rate (in hertz) for
	// this audio. If not provided, then the synthesizer will use the
	// default sample rate based on the audio encoding. If this is different
	// from the voice's natural sample rate, then the synthesizer will honor
	// this request by converting to the desired sample rate (which might
	// result in worse audio quality).
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`

	// SynthesizeSpeechConfig: Optional. Configuration of how speech should
	// be synthesized.
	SynthesizeSpeechConfig *GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig `json:"synthesizeSpeechConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioEncoding") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1OutputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1OutputAudioConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Page: A Dialogflow CX conversation
// (session) can be described and visualized as a state machine. The
// states of a CX session are represented by pages. For each flow, you
// define many pages, where your combined pages can handle a complete
// conversation on the topics the flow is designed for. At any given
// moment, exactly one page is the current page, the current page is
// considered active, and the flow associated with that page is
// considered active. Every flow has a special start page. When a flow
// initially becomes active, the start page page becomes the current
// page. For each conversational turn, the current page will either stay
// the same or transition to another page. You configure each page to
// collect information from the end-user that is relevant for the
// conversational state represented by the page. For more information,
// see the Page guide
// (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3beta1Page struct {
	// DisplayName: Required. The human-readable name of the page, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// EntryFulfillment: The fulfillment to call when the session is
	// entering the page.
	EntryFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"entryFulfillment,omitempty"`

	// EventHandlers: Handlers associated with the page to handle events
	// such as webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandlers,omitempty"`

	// Form: The form associated with the page, used for collecting
	// parameters relevant to the page.
	Form *GoogleCloudDialogflowCxV3beta1Form `json:"form,omitempty"`

	// Name: The unique identifier of the page. Required for the
	// Pages.UpdatePage method. Pages.CreatePage populates the name
	// automatically. Format: `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`

	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups`
	// associated with the page. Transition route groups must be unique
	// within a page. * If multiple transition routes within a page scope
	// refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's
	// transition routes. * If multiple transition route groups within a
	// page contain the same intent, then the first group in the ordered
	// list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/`.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`

	// TransitionRoutes: A list of transitions for the transition rules of
	// this page. They route the conversation to another page in the same
	// flow, or another flow. When we are in a certain page, the
	// TransitionRoutes are evalauted in the following order: *
	// TransitionRoutes defined in the page with intent specified. *
	// TransitionRoutes defined in the transition route groups with intent
	// specified. * TransitionRoutes defined in flow with intent specified.
	// * TransitionRoutes defined in the transition route groups with intent
	// specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups
	// with only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Page
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfo: Represents page information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for
	// WebhookResponse. The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`

	// FormInfo: Optional for both WebhookRequest and WebhookResponse.
	// Information about the form.
	FormInfo *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo `json:"formInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfo: Represents form
// information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse.
	// The parameters contained in the form. Note that the webhook cannot
	// add or remove any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParameterInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo:
// Represents parameter information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique
	// within the form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`

	// JustCollected: Optional for WebhookRequest. Ignored for
	// WebhookResponse. Indicates if the parameter value was just collected
	// on the last conversation turn.
	JustCollected bool `json:"justCollected,omitempty"`

	// Required: Optional for both WebhookRequest and WebhookResponse.
	// Indicates whether the parameter is required. Optional parameters will
	// not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling
	// concludes.
	Required bool `json:"required,omitempty"`

	// State: Always present for WebhookRequest. Required for
	// WebhookResponse. The state of the parameter. This field can be set to
	// INVALID by the webhook to invalidate the parameter; other values set
	// by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be
	// never used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This
	// field can be used by the webhook to invalidate the parameter and ask
	// the server to collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`

	// Value: Optional for both WebhookRequest and WebhookResponse. The
	// value of the parameter. This field can be set by the webhook to
	// change the parameter value.
	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryInput: Represents the query input.
// It can contain one of: 1. A conversational query in the form of text.
// 2. An intent query that specifies which intent to trigger. 3. Natural
// language speech audio to be processed. 4. An event to be triggered.
type GoogleCloudDialogflowCxV3beta1QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3beta1AudioInput `json:"audio,omitempty"`

	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3beta1DtmfInput `json:"dtmf,omitempty"`

	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3beta1EventInput `json:"event,omitempty"`

	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3beta1IntentInput `json:"intent,omitempty"`

	// LanguageCode: Required. The language of the input. See Language
	// Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for
	// a list of the currently supported language codes. Note that queries
	// in the same session do not necessarily need to specify the same
	// language.
	LanguageCode string `json:"languageCode,omitempty"`

	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3beta1TextInput `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryParameters: Represents the
// parameters of a conversational query.
type GoogleCloudDialogflowCxV3beta1QueryParameters struct {
	// AnalyzeQueryTextSentiment: Configures whether sentiment analysis
	// should be performed. If not provided, sentiment analysis is not
	// performed.
	AnalyzeQueryTextSentiment bool `json:"analyzeQueryTextSentiment,omitempty"`

	// CurrentPage: The unique identifier of the page to override the
	// current page in the session. Format:
	// `projects//locations//agents//flows//pages/`. If `current_page` is
	// specified, the previous state of the session will be ignored by
	// Dialogflow, including the previous page and the previous session
	// parameters. In most cases, current_page and parameters should be
	// configured together to direct a session to a specific state.
	CurrentPage string `json:"currentPage,omitempty"`

	// DisableWebhook: Whether to disable webhook calls for this request.
	DisableWebhook bool `json:"disableWebhook,omitempty"`

	// FlowVersions: A list of flow versions to override for the request.
	// Format: `projects//locations//agents//flows//versions/`. If version 1
	// of flow X is included in this list, the traffic of flow X will go
	// through version 1 regardless of the version configuration in the
	// environment. Each flow can have at most one version specified in this
	// list.
	FlowVersions []string `json:"flowVersions,omitempty"`

	// GeoLocation: The geo location of this conversational query.
	GeoLocation *GoogleTypeLatLng `json:"geoLocation,omitempty"`

	// Parameters: Additional parameters to be put into session parameters.
	// To remove a parameter from the session, clients should explicitly set
	// the parameter value to null. You can reference the session parameters
	// in the agent with the following format: $session.params.parameter-id.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed
	// of a collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// Payload: This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported. Some
	// integrations that query a Dialogflow agent may provide additional
	// information in the payload. In particular, for the Dialogflow Phone
	// Gateway integration, this field has the form: ``` { "telephony": {
	// "caller_id": "+18558363987" } } ```
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SessionEntityTypes: Additional session entity types to replace or
	// extend developer entity types with. The entity synonyms apply to all
	// languages and persist for the session of this query.
	SessionEntityTypes []*GoogleCloudDialogflowCxV3beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// TimeZone: The time zone of this conversational query from the time
	// zone database (https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone
	// specified in the agent is used.
	TimeZone string `json:"timeZone,omitempty"`

	// WebhookHeaders: This field can be used to pass HTTP headers for a
	// webhook call. These headers will be sent to webhook along with the
	// headers that have been configured through Dialogflow web console. The
	// headers defined within this field will overwrite the headers
	// configured through Dialogflow console if there is a conflict. Header
	// names are case-insensitive. Google's specified headers are not
	// allowed. Including: "Host", "Content-Length", "Connection", "From",
	// "User-Agent", "Accept-Encoding", "If-Modified-Since",
	// "If-None-Match", "X-Forwarded-For", etc.
	WebhookHeaders map[string]string `json:"webhookHeaders,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnalyzeQueryTextSentiment") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnalyzeQueryTextSentiment") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1QueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryResult: Represents the result of a
// conversational query.
type GoogleCloudDialogflowCxV3beta1QueryResult struct {
	// CurrentPage: The current Page. Some, not all fields are filled in
	// this message, including but not limited to `name` and `display_name`.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`

	// DiagnosticInfo: The free-form diagnostic info. For example, this
	// field could contain webhook call latency. The string keys of the
	// Struct's fields map can change without notice.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`

	// Dtmf: If a DTMF was provided as input, this field will contain a copy
	// of the DTMFInput.
	Dtmf *GoogleCloudDialogflowCxV3beta1DtmfInput `json:"dtmf,omitempty"`

	// Intent: The Intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name` and `display_name`. This field is deprecated, please use
	// QueryResult.match instead.
	Intent *GoogleCloudDialogflowCxV3beta1Intent `json:"intent,omitempty"`

	// IntentDetectionConfidence: The intent detection confidence. Values
	// range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help
	// match the best intent within the classification threshold. This value
	// may change for the same end-user expression at any time due to a
	// model retraining or change in implementation. This field is
	// deprecated, please use QueryResult.match instead.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`

	// LanguageCode: The language that was triggered during intent
	// detection. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for
	// a list of the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`

	// Match: Intent match result, could be an intent or an event.
	Match *GoogleCloudDialogflowCxV3beta1Match `json:"match,omitempty"`

	// Parameters: The collected session parameters. Depending on your
	// protocol or client library language, this is a map, associative
	// array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ResponseMessages: The list of rich messages returned to the client.
	// Responses vary from simple text messages to more sophisticated,
	// structured payloads used to drive complex logic.
	ResponseMessages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"responseMessages,omitempty"`

	// SentimentAnalysisResult: The sentiment analyss result, which depends
	// on `analyze_query_text_sentiment`, specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`

	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`

	// Transcript: If natural language speech audio was provided as input,
	// this field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`

	// TriggerEvent: If an event was provided as input, this field will
	// contain the name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`

	// TriggerIntent: If an intent was provided as input, this field will
	// contain a copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`

	// WebhookPayloads: The list of webhook payload in
	// WebhookResponse.payload, in the order of call sequence. If some
	// webhook call fails or doesn't return any payload, an empty `Struct`
	// would be used instead.
	WebhookPayloads []googleapi.RawMessage `json:"webhookPayloads,omitempty"`

	// WebhookStatuses: The list of webhook call status in the order of call
	// sequence.
	WebhookStatuses []*GoogleRpcStatus `json:"webhookStatuses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentPage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryResult
	var s1 struct {
		IntentDetectionConfidence gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ReloadDocumentOperationMetadata:
// Metadata for ReloadDocument operation.
type GoogleCloudDialogflowCxV3beta1ReloadDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ReloadDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ReloadDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResourceName: Resource name and display
// name.
type GoogleCloudDialogflowCxV3beta1ResourceName struct {
	// DisplayName: Display name.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Name.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResourceName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResourceName
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessage: Represents a response
// message that can be returned by a conversational agent. Response
// messages are also used for output audio synthesis. The approach is as
// follows: * If at least one OutputAudioText response is present, then
// all OutputAudioText responses are linearly concatenated, and the
// result is used for output audio synthesis. * If the OutputAudioText
// responses are a mixture of text and SSML, then the concatenated
// result is treated as SSML; otherwise, the result is treated as either
// text or SSML as appropriate. The agent designer should ideally use
// either text or SSML consistently throughout the bot design. *
// Otherwise, all Text responses are linearly concatenated, and the
// result is used for output audio synthesis. This approach allows for
// more sophisticated user experience scenarios, where the text
// displayed to the user may differ from what is heard.
type GoogleCloudDialogflowCxV3beta1ResponseMessage struct {
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`

	// EndInteraction: Output only. A signal that indicates the interaction
	// with the Dialogflow agent has ended. This message is generated by
	// Dialogflow only when the conversation reaches `END_SESSION` page. It
	// is not supposed to be defined by the user. It's guaranteed that there
	// is at most one such message in each response.
	EndInteraction *GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction `json:"endInteraction,omitempty"`

	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`

	// MixedAudio: Output only. An audio response message composed of both
	// the synthesized Dialogflow agent responses and responses defined via
	// play_audio. This message is generated by Dialogflow only and not
	// supposed to be defined by the user.
	MixedAudio *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`

	// OutputAudioText: A text or ssml response that is preferentially used
	// for TTS output audio synthesis, as described in the comment on the
	// ResponseMessage message.
	OutputAudioText *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`

	// Payload: Returns a response containing a custom, platform-specific
	// payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// PlayAudio: Signal that the client should play an audio clip hosted at
	// a client-specific URI. Dialogflow uses this to construct mixed_audio.
	// However, Dialogflow itself does not try to read or process the URI in
	// any way.
	PlayAudio *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio `json:"playAudio,omitempty"`

	// TelephonyTransferCall: A signal that the client should transfer the
	// phone call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`

	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConversationSuccess")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationSuccess") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess:
// Indicates that the conversation succeeded, i.e., the bot handled the
// issue that the customer talked to it about. Dialogflow only uses this
// to determine which conversations should be counted as successful and
// doesn't process the metadata in this message in any way. Note that
// Dialogflow also considers conversations that get to the conversation
// end page as successful even if they don't return ConversationSuccess.
// You may set this, for example: * In the entry_fulfillment of a Page
// if entering the page indicates that the conversation succeeded. * In
// a webhook response when you determine that you handled the customer
// issue.
type GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on
	// this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction:
// Indicates that interaction with the Dialogflow agent has ended. This
// message is generated by Dialogflow only and not supposed to be
// defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff:
// Indicates that the conversation should be handed off to a live agent.
// Dialogflow only uses this to determine which conversations were
// handed off to a human agent for measurement purposes. What else to do
// with this signal is up to you and your handoff procedures. You may
// set this, for example: * In the entry_fulfillment of a Page if
// entering the page indicates something went extremely wrong in the
// conversation. * In a webhook response when you determine that the
// customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow
	// doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio: Represents
// an audio message that is composed of both segments synthesized from
// the Dialogflow agent prompts and ones hosted externally at the
// specified URIs. The external URIs are specified via play_audio. This
// message is generated by Dialogflow only and not supposed to be
// defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Segments") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment:
// Represents one segment of audio.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// segment can be interrupted by the end user's speech and the client
	// should then start the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Audio: Raw audio synthesized from the Dialogflow agent's response
	// using the output config specified in the request.
	Audio string `json:"audio,omitempty"`

	// Uri: Client-specific URI that points to an audio clip accessible to
	// the client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText: A text
// or ssml response that is preferentially used for TTS output audio
// synthesis, as described in the comment on the ResponseMessage
// message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`

	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio: Specifies an
// audio clip to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose
	// any validation on this value. It is specific to the client that reads
	// it.
	AudioUri string `json:"audioUri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall:
// Represents the signal that telles the client to transfer the phone
// call connected to the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageText: The text response
// message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this
	// message can be interrupted by the end user's speech and the client
	// can then starts the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`

	// Text: Required. A collection of text responses.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowPlaybackInterruption") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RestoreAgentRequest: The request
// message for Agents.RestoreAgent.
type GoogleCloudDialogflowCxV3beta1RestoreAgentRequest struct {
	// AgentContent: Uncompressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`

	// AgentUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to restore agent from.
	// The format of this URI must be `gs:///`.
	AgentUri string `json:"agentUri,omitempty"`

	// RestoreOption: Agent restore mode. If not specified, `KEEP` is
	// assumed.
	//
	// Possible values:
	//   "RESTORE_OPTION_UNSPECIFIED" - Unspecified. Treated as KEEP.
	//   "KEEP" - Always respect the settings from the exported agent file.
	// It may cause a restoration failure if some settings (e.g. model type)
	// are not supported in the target agent.
	//   "FALLBACK" - Fallback to default settings if some settings are not
	// supported in the target agent.
	RestoreOption string `json:"restoreOption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RestoreAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RestoreAgentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutConfig: The configuration for
// auto rollout.
type GoogleCloudDialogflowCxV3beta1RolloutConfig struct {
	// FailureCondition: The conditions that are used to evaluate the
	// failure of a rollout step. If not specified, no rollout steps will
	// fail. E.g. "containment_rate < 10% OR average_turn_count < 3". See
	// the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	FailureCondition string `json:"failureCondition,omitempty"`

	// RolloutCondition: The conditions that are used to evaluate the
	// success of a rollout step. If not specified, all rollout steps will
	// proceed to the next one unless failure conditions are met. E.g.
	// "containment_rate > 60% AND callback_rate < 20%". See the conditions
	// reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	RolloutCondition string `json:"rolloutCondition,omitempty"`

	// RolloutSteps: Steps to roll out a flow version. Steps should be
	// sorted by percentage in ascending order.
	RolloutSteps []*GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep `json:"rolloutSteps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FailureCondition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailureCondition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RolloutConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep: A single
// rollout step with specified traffic allocation.
type GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep struct {
	// DisplayName: The name of the rollout step;
	DisplayName string `json:"displayName,omitempty"`

	// MinDuration: The minimum time that this step should last. Should be
	// longer than 1 hour. If not set, the default minimum duration for each
	// step will be 1 hour.
	MinDuration string `json:"minDuration,omitempty"`

	// TrafficPercent: The percentage of traffic allocated to the flow
	// version of this rollout step. (0%, 100%].
	TrafficPercent int64 `json:"trafficPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutState: State of the auto-rollout
// process.
type GoogleCloudDialogflowCxV3beta1RolloutState struct {
	// StartTime: Start time of the current step.
	StartTime string `json:"startTime,omitempty"`

	// Step: Display name of the current auto rollout step.
	Step string `json:"step,omitempty"`

	// StepIndex: Index of the current step in the auto rollout steps list.
	StepIndex int64 `json:"stepIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StartTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RolloutState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata: Metadata
// returned for the Environments.RunContinuousTest long running
// operation.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestRequest: The request
// message for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestRequest struct {
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse: The response
// message for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResult,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ContinuousTestResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContinuousTestResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata: Metadata returned
// for the TestCases.RunTestCase long running operation. This message
// currently has no fields.
type GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseRequest: The request message
// for TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3beta1RunTestCaseRequest struct {
	// Environment: Optional. Environment name. If not set, draft
	// environment is assumed. Format:
	// `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environment") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RunTestCaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseResponse: The response
// message for TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3beta1RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"result,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Result") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SecuritySettings: Represents the
// settings related to security issues, such as data redaction and data
// retention. It may take hours for updates on the settings to propagate
// to all the related components and take effect.
type GoogleCloudDialogflowCxV3beta1SecuritySettings struct {
	// DeidentifyTemplate: DLP (https://cloud.google.com/dlp/docs)
	// deidentify template name. Use this template to define
	// de-identification configuration for the content. The `DLP De-identify
	// Templates Reader` role is needed on the Dialogflow service identity
	// service account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`)
	// for your agent's project. If empty, Dialogflow replaces sensitive
	// info with `[redacted]` text. The template name will have one of the
	// following formats: `projects//locations//deidentifyTemplates/` OR
	// `organizations//locations//deidentifyTemplates/` Note:
	// `deidentify_template` must be located in the same region as the
	// `SecuritySettings`.
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`

	// DisplayName: Required. The human-readable name of the security
	// settings, unique within the location.
	DisplayName string `json:"displayName,omitempty"`

	// InsightsExportSettings: Controls conversation exporting settings to
	// Insights after conversation is completed. If retention_strategy is
	// set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no
	// matter what you configure here.
	InsightsExportSettings *GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings `json:"insightsExportSettings,omitempty"`

	// InspectTemplate: DLP (https://cloud.google.com/dlp/docs) inspect
	// template name. Use this template to define inspect base settings. The
	// `DLP Inspect Templates Reader` role is needed on the Dialogflow
	// service identity service account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`)
	// for your agent's project. If empty, we use the default DLP inspect
	// config. The template name will have one of the following formats:
	// `projects//locations//inspectTemplates/` OR
	// `organizations//locations//inspectTemplates/` Note:
	// `inspect_template` must be located in the same region as the
	// `SecuritySettings`.
	InspectTemplate string `json:"inspectTemplate,omitempty"`

	// Name: Resource name of the settings. Required for the
	// SecuritySettingsService.UpdateSecuritySettings method.
	// SecuritySettingsService.CreateSecuritySettings populates the name
	// automatically. Format: `projects//locations//securitySettings/`.
	Name string `json:"name,omitempty"`

	// PurgeDataTypes: List of types of data to remove when retention
	// settings triggers purge.
	//
	// Possible values:
	//   "PURGE_DATA_TYPE_UNSPECIFIED" - Unspecified. Do not use.
	//   "DIALOGFLOW_HISTORY" - Dialogflow history. This does not include
	// Cloud logging, which is owned by the user - not Dialogflow.
	PurgeDataTypes []string `json:"purgeDataTypes,omitempty"`

	// RedactionScope: Defines the data for which Dialogflow applies
	// redaction. Dialogflow does not redact data that it does not have
	// access to – for example, Cloud logging.
	//
	// Possible values:
	//   "REDACTION_SCOPE_UNSPECIFIED" - Don't redact any kind of data.
	//   "REDACT_DISK_STORAGE" - On data to be written to disk or similar
	// devices that are capable of holding data even if power is
	// disconnected. This includes data that are temporarily saved on disk.
	RedactionScope string `json:"redactionScope,omitempty"`

	// RedactionStrategy: Strategy that defines how we do redaction.
	//
	// Possible values:
	//   "REDACTION_STRATEGY_UNSPECIFIED" - Do not redact.
	//   "REDACT_WITH_SERVICE" - Call redaction service to clean up the data
	// to be persisted.
	RedactionStrategy string `json:"redactionStrategy,omitempty"`

	// RetentionWindowDays: Retains data in interaction logging for the
	// specified number of days. This does not apply to Cloud logging, which
	// is owned by the user - not Dialogflow. User must set a value lower
	// than Dialogflow's default 365d TTL. Setting a value higher than that
	// has no effect. A missing value or setting to 0 also means we use
	// Dialogflow's default TTL. Note: Interaction logging is a limited
	// access feature. Talk to your Google representative to check
	// availability for you.
	RetentionWindowDays int64 `json:"retentionWindowDays,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SecuritySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings:
// Settings for exporting conversations to Insights
// (https://cloud.google.com/dialogflow/priv/docs/insights).
type GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings struct {
	// EnableInsightsExport: If enabled, we will automatically exports
	// conversations to Insights and Insights runs its analyzers.
	EnableInsightsExport bool `json:"enableInsightsExport,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableInsightsExport") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableInsightsExport") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult: The result of
// sentiment analysis. Sentiment analysis inspects user input and
// identifies the prevailing subjective opinion, especially to determine
// a user's attitude as positive, negative, or neutral.
type GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which
	// represents the absolute magnitude of sentiment, regardless of score
	// (positive or negative).
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1SessionEntityType: Session entity types
// are referred to as **User** entity types and are entities that are
// built for an individual user such as favorites, preferences,
// playlists, and so on. You can redefine a session entity type at the
// session level to extend or replace a custom entity type at the user
// session level (we refer to the entity types defined at the agent
// level as "custom entity types"). Note: session entity types apply to
// all queries, regardless of the language. For more information about
// entity types, see the Dialogflow documentation
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowCxV3beta1SessionEntityType struct {
	// Entities: Required. The collection of entities to override or
	// supplement the custom entity type.
	Entities []*GoogleCloudDialogflowCxV3beta1EntityTypeEntity `json:"entities,omitempty"`

	// EntityOverrideMode: Required. Indicates whether the additional data
	// should override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value
	// should be never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session
	// entities overrides the collection of entities in the corresponding
	// custom entity type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session
	// entities extends the collection of entities in the corresponding
	// custom entity type. Note: Even in this override mode calls to
	// `ListSessionEntityTypes`, `GetSessionEntityType`,
	// `CreateSessionEntityType` and `UpdateSessionEntityType` only return
	// the additional entities added in this session entity type. If you
	// want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`

	// Name: Required. The unique identifier of the session entity type.
	// Format: `projects//locations//agents//sessions//entityTypes/` or
	// `projects//locations//agents//environments//sessions//entityTypes/`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionEntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SessionInfo: Represents session
// information communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for
	// WebhookResponse. All parameters collected from forms and intents
	// during the session. Parameters can be created, updated, or removed by
	// the webhook. To remove a parameter from the session, the webhook
	// should explicitly set the parameter value to null in WebhookResponse.
	// The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// Session: Always present for WebhookRequest. Ignored for
	// WebhookResponse. The unique identifier of the session. This field can
	// be used by the webhook to identify a session. Format:
	// `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment
	// is specified.
	Session string `json:"session,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SpeechToTextSettings: Settings related
// to speech recognition.
type GoogleCloudDialogflowCxV3beta1SpeechToTextSettings struct {
	// EnableSpeechAdaptation: Whether to use speech adaptation for speech
	// recognition.
	EnableSpeechAdaptation bool `json:"enableSpeechAdaptation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableSpeechAdaptation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableSpeechAdaptation")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SpeechToTextSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SpeechToTextSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1StartExperimentRequest: The request
// message for Experiments.StartExperiment.
type GoogleCloudDialogflowCxV3beta1StartExperimentRequest struct {
}

// GoogleCloudDialogflowCxV3beta1StopExperimentRequest: The request
// message for Experiments.StopExperiment.
type GoogleCloudDialogflowCxV3beta1StopExperimentRequest struct {
}

// GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig: Configuration
// of how speech should be synthesized.
type GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig struct {
	// EffectsProfileId: Optional. An identifier which selects 'audio
	// effects' profiles that are applied on (post synthesized) text to
	// speech. Effects are applied on top of each other in the order they
	// are given.
	EffectsProfileId []string `json:"effectsProfileId,omitempty"`

	// Pitch: Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means
	// increase 20 semitones from the original pitch. -20 means decrease 20
	// semitones from the original pitch.
	Pitch float64 `json:"pitch,omitempty"`

	// SpeakingRate: Optional. Speaking rate/speed, in the range [0.25,
	// 4.0]. 1.0 is the normal native speed supported by the specific voice.
	// 2.0 is twice as fast, and 0.5 is half as fast. If unset(0.0),
	// defaults to the native 1.0 speed. Any other values < 0.25 or > 4.0
	// will return an error.
	SpeakingRate float64 `json:"speakingRate,omitempty"`

	// Voice: Optional. The desired voice of the synthesized audio.
	Voice *GoogleCloudDialogflowCxV3beta1VoiceSelectionParams `json:"voice,omitempty"`

	// VolumeGainDb: Optional. Volume gain (in dB) of the normal native
	// volume supported by the specific voice, in the range [-96.0, 16.0].
	// If unset, or set to a value of 0.0 (dB), will play at normal native
	// signal amplitude. A value of -6.0 (dB) will play at approximately
	// half the amplitude of the normal native signal amplitude. A value of
	// +6.0 (dB) will play at approximately twice the amplitude of the
	// normal native signal amplitude. We strongly recommend not to exceed
	// +10 (dB) as there's usually no effective increase in loudness for any
	// value greater than that.
	VolumeGainDb float64 `json:"volumeGainDb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EffectsProfileId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EffectsProfileId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig
	var s1 struct {
		Pitch        gensupport.JSONFloat64 `json:"pitch"`
		SpeakingRate gensupport.JSONFloat64 `json:"speakingRate"`
		VolumeGainDb gensupport.JSONFloat64 `json:"volumeGainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Pitch = float64(s1.Pitch)
	s.SpeakingRate = float64(s1.SpeakingRate)
	s.VolumeGainDb = float64(s1.VolumeGainDb)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3beta1TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`

	// DisplayName: Required. The human-readable name of the test case,
	// unique within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`

	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"lastTestResult,omitempty"`

	// Name: The unique identifier of the test case.
	// TestCases.CreateTestCase will populate the name automatically.
	// Otherwise use format: `projects//locations//agents/ /testCases/`.
	Name string `json:"name,omitempty"`

	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`

	// Tags: Tags are short descriptions that users may apply to test cases
	// for organizational and filtering purposes. Each tag should start with
	// "#" and has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`

	// TestCaseConversationTurns: The conversation turns uttered when the
	// test case was created, in chronological order. These include the
	// canonical set of agent utterances that should occur when the agent is
	// working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"testCaseConversationTurns,omitempty"`

	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3beta1TestConfig `json:"testConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseError: Error info for importing
// a test.
type GoogleCloudDialogflowCxV3beta1TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3beta1TestCase `json:"testCase,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseResult: Represents a result
// from running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test
	// case replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"conversationTurns,omitempty"`

	// Environment: Environment where the test was run. If not set, it
	// indicates the draft environment.
	Environment string `json:"environment,omitempty"`

	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases/ /results/`.
	Name string `json:"name,omitempty"`

	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`

	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConversationTurns")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationTurns") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestConfig: Represents configurations
// for a test case.
type GoogleCloudDialogflowCxV3beta1TestConfig struct {
	// Flow: Flow name. If not set, default start flow is assumed. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`

	// TrackingParameters: Session parameters to be compared when
	// calculating differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestError: Error info for running a
// test.
type GoogleCloudDialogflowCxV3beta1TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`

	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestRunDifference: The description of
// differences between original and replayed agent output.
type GoogleCloudDialogflowCxV3beta1TestRunDifference struct {
	// Description: A description of the diff, showing the actual output vs
	// expected output.
	Description string `json:"description,omitempty"`

	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestRunDifference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TextInput: Represents the natural
// language text to be processed.
type GoogleCloudDialogflowCxV3beta1TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be
	// processed. Text length must not exceed 256 characters.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TrainFlowRequest: The request message
// for Flows.TrainFlow.
type GoogleCloudDialogflowCxV3beta1TrainFlowRequest struct {
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverage: Transition coverage
// represents the percentage of all possible page transitions
// (page-level transition routes and event handlers, excluding
// transition route groups) present within any of a parent's test cases.
type GoogleCloudDialogflowCxV3beta1TransitionCoverage struct {
	// CoverageScore: The percent of transitions in the agent that are
	// covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`

	// Transitions: The list of Transitions present in the agent.
	Transitions []*GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition `json:"transitions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoverageScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition: A
// transition in a page.
type GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition struct {
	// Covered: Whether or not the transition is covered by at least one of
	// the agent's test cases.
	Covered bool `json:"covered,omitempty"`

	// EventHandler: Event handler.
	EventHandler *GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandler,omitempty"`

	// Index: The index of a transition in the transition list. Starting
	// from 0.
	Index int64 `json:"index,omitempty"`

	// Source: The start node of a transition.
	Source *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode `json:"source,omitempty"`

	// Target: The end node of a transition.
	Target *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode `json:"target,omitempty"`

	// TransitionRoute: Intent route or condition route.
	TransitionRoute *GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Covered") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Covered") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode: The
// source or target of a transition.
type GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode struct {
	// Flow: Indicates a transition to a Flow. Only some fields such as name
	// and displayname will be set.
	Flow *GoogleCloudDialogflowCxV3beta1Flow `json:"flow,omitempty"`

	// Page: Indicates a transition to a Page. Only some fields such as name
	// and displayname will be set.
	Page *GoogleCloudDialogflowCxV3beta1Page `json:"page,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Flow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Flow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRoute: A transition route
// specifies a intent that can be matched and/or a data condition that
// can be evaluated during a session. When a specified transition is
// matched, the following actions are taken in order: * If there is a
// `trigger_fulfillment` associated with the transition, it will be
// called. * If there is a `target_page` associated with the transition,
// the session will transition into the specified page. * If there is a
// `target_flow` associated with the transition, the session will
// transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or
	// session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At
	// least one of `intent` or `condition` must be specified. When both
	// `intent` and `condition` are specified, the transition can only
	// happen when both are fulfilled.
	Condition string `json:"condition,omitempty"`

	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the
	// transition can only happen when the given intent is matched. At least
	// one of `intent` or `condition` must be specified. When both `intent`
	// and `condition` are specified, the transition can only happen when
	// both are fulfilled.
	Intent string `json:"intent,omitempty"`

	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// TriggerFulfillment: The fulfillment to call when the condition is
	// satisfied. At least one of `trigger_fulfillment` and `target` must be
	// specified. When both are defined, `trigger_fulfillment` is executed
	// first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroup: An
// TransitionRouteGroup represents a group of `TransitionRoutes` to be
// used by a Page.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroup struct {
	// DisplayName: Required. The human-readable name of the transition
	// route group, unique within the Agent. The display name can be no
	// longer than 30 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The unique identifier of the transition route group.
	// TransitionRouteGroups.CreateTransitionRouteGroup populates the name
	// automatically. Format:
	// `projects//locations//agents//flows//transitionRouteGroups/`.
	Name string `json:"name,omitempty"`

	// TransitionRoutes: Transition routes associated with the
	// TransitionRouteGroup.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage:
// Transition route group coverage represents the percentage of all
// possible transition routes present within any of a parent's test
// cases. The results are grouped by the transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage struct {
	// CoverageScore: The percent of transition routes in all the transition
	// route groups that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`

	// Coverages: Transition route group coverages.
	Coverages []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage `json:"coverages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoverageScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage:
// Coverage result message for one transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage struct {
	// CoverageScore: The percent of transition routes in the transition
	// route group that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`

	// RouteGroup: Transition route group metadata. Only name and
	// displayName will be set.
	RouteGroup *GoogleCloudDialogflowCxV3beta1TransitionRouteGroup `json:"routeGroup,omitempty"`

	// Transitions: The list of transition routes and coverage in the
	// transition route group.
	Transitions []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition `json:"transitions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoverageScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTran
// sition: A transition coverage in a transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition struct {
	// Covered: Whether or not the transition route is covered by at least
	// one of the agent's test cases.
	Covered bool `json:"covered,omitempty"`

	// TransitionRoute: Intent route or condition route.
	TransitionRoute *GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoute,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Covered") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Covered") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1UpdateDocumentOperationMetadata:
// Metadata for UpdateDocument operation.
type GoogleCloudDialogflowCxV3beta1UpdateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowCxV3beta1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1UpdateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1UpdateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidateAgentRequest: The request
// message for Agents.ValidateAgent.
type GoogleCloudDialogflowCxV3beta1ValidateAgentRequest struct {
	// LanguageCode: If not specified, the agent's default language is used.
	LanguageCode string `json:"languageCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ValidateAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidateAgentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidateFlowRequest: The request
// message for Flows.ValidateFlow.
type GoogleCloudDialogflowCxV3beta1ValidateFlowRequest struct {
	// LanguageCode: If not specified, the agent's default language is used.
	LanguageCode string `json:"languageCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ValidateFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidateFlowRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidationMessage: Agent/flow
// validation message.
type GoogleCloudDialogflowCxV3beta1ValidationMessage struct {
	// Detail: The message detail.
	Detail string `json:"detail,omitempty"`

	// ResourceNames: The resource names of the resources where the message
	// is found.
	ResourceNames []*GoogleCloudDialogflowCxV3beta1ResourceName `json:"resourceNames,omitempty"`

	// ResourceType: The type of the resources where the message is found.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unspecified.
	//   "AGENT" - Agent.
	//   "INTENT" - Intent.
	//   "INTENT_TRAINING_PHRASE" - Intent training phrase.
	//   "INTENT_PARAMETER" - Intent parameter.
	//   "INTENTS" - Multiple intents.
	//   "INTENT_TRAINING_PHRASES" - Multiple training phrases.
	//   "ENTITY_TYPE" - Entity type.
	//   "ENTITY_TYPES" - Multiple entity types.
	//   "WEBHOOK" - Webhook.
	//   "FLOW" - Flow.
	//   "PAGE" - Page.
	//   "PAGES" - Multiple pages.
	//   "TRANSITION_ROUTE_GROUP" - Transition route group.
	ResourceType string `json:"resourceType,omitempty"`

	// Resources: The names of the resources where the message is found.
	Resources []string `json:"resources,omitempty"`

	// Severity: Indicates the severity of the message.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified.
	//   "INFO" - The agent doesn't follow Dialogflow best practices.
	//   "WARNING" - The agent may not behave as expected.
	//   "ERROR" - The agent may experience failures.
	Severity string `json:"severity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Detail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1ValidationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VariantsHistory: The history of
// variants update.
type GoogleCloudDialogflowCxV3beta1VariantsHistory struct {
	// UpdateTime: Update time of the variants.
	UpdateTime string `json:"updateTime,omitempty"`

	// VersionVariants: The flow versions as the variants.
	VersionVariants *GoogleCloudDialogflowCxV3beta1VersionVariants `json:"versionVariants,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UpdateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UpdateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1VariantsHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VariantsHistory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Version: Represents a version of a
// flow.
type GoogleCloudDialogflowCxV3beta1Version struct {
	// CreateTime: Output only. Create time of the version.
	CreateTime string `json:"createTime,omitempty"`

	// Description: The description of the version. The maximum length is
	// 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The human-readable name of the version. Limit
	// of 64 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Format: projects//locations//agents//flows//versions/. Version
	// ID is a self-increasing number generated by Dialogflow upon version
	// creation.
	Name string `json:"name,omitempty"`

	// NluSettings: Output only. The NLU settings of the flow at version
	// creation.
	NluSettings *GoogleCloudDialogflowCxV3beta1NluSettings `json:"nluSettings,omitempty"`

	// State: Output only. The state of this version. This field is
	// read-only and cannot be set by create and update methods.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not specified. This value is not used.
	//   "RUNNING" - Version is not ready to serve (e.g. training is
	// running).
	//   "SUCCEEDED" - Training has succeeded and this version is ready to
	// serve.
	//   "FAILED" - Version training failed.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Version) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Version
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VersionVariants: A list of flow version
// variants.
type GoogleCloudDialogflowCxV3beta1VersionVariants struct {
	// Variants: A list of flow version variants.
	Variants []*GoogleCloudDialogflowCxV3beta1VersionVariantsVariant `json:"variants,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Variants") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Variants") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1VersionVariants) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariants
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VersionVariantsVariant: A single flow
// version with specified traffic allocation.
type GoogleCloudDialogflowCxV3beta1VersionVariantsVariant struct {
	// IsControlGroup: Whether the variant is for the control group.
	IsControlGroup bool `json:"isControlGroup,omitempty"`

	// TrafficAllocation: Percentage of the traffic which should be routed
	// to this version of flow. Traffic allocation for a single flow must
	// sum up to 1.0.
	TrafficAllocation float64 `json:"trafficAllocation,omitempty"`

	// Version: The name of the flow version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsControlGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsControlGroup") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1VersionVariantsVariant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariantsVariant
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1VersionVariantsVariant) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariantsVariant
	var s1 struct {
		TrafficAllocation gensupport.JSONFloat64 `json:"trafficAllocation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TrafficAllocation = float64(s1.TrafficAllocation)
	return nil
}

// GoogleCloudDialogflowCxV3beta1VoiceSelectionParams: Description of
// which voice to use for speech synthesis.
type GoogleCloudDialogflowCxV3beta1VoiceSelectionParams struct {
	// Name: Optional. The name of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code
	// and ssml_gender. For the list of available voices, please refer to
	// Supported voices and languages
	// (https://cloud.google.com/text-to-speech/docs/voices).
	Name string `json:"name,omitempty"`

	// SsmlGender: Optional. The preferred gender of the voice. If not set,
	// the service will choose a voice based on the other parameters such as
	// language_code and name. Note that this is only a preference, not
	// requirement. If a voice of the appropriate gender is not available,
	// the synthesizer should substitute a voice with a different gender
	// rather than failing the request.
	//
	// Possible values:
	//   "SSML_VOICE_GENDER_UNSPECIFIED" - An unspecified gender, which
	// means that the client doesn't care which gender the selected voice
	// will have.
	//   "SSML_VOICE_GENDER_MALE" - A male voice.
	//   "SSML_VOICE_GENDER_FEMALE" - A female voice.
	//   "SSML_VOICE_GENDER_NEUTRAL" - A gender-neutral voice.
	SsmlGender string `json:"ssmlGender,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1VoiceSelectionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VoiceSelectionParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Webhook: Webhooks host the developer's
// business logic. During a session, webhooks allow the developer to use
// the data extracted by Dialogflow's natural language processing to
// generate dynamic responses, validate collected data, or trigger
// actions on the backend.
type GoogleCloudDialogflowCxV3beta1Webhook struct {
	// Disabled: Indicates whether the webhook is disabled.
	Disabled bool `json:"disabled,omitempty"`

	// DisplayName: Required. The human-readable name of the webhook, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`

	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`

	// Name: The unique identifier of the webhook. Required for the
	// Webhooks.UpdateWebhook method. Webhooks.CreateWebhook populates the
	// name automatically. Format: `projects//locations//agents//webhooks/`.
	Name string `json:"name,omitempty"`

	// ServiceDirectory: Configuration for a Service Directory
	// (https://cloud.google.com/service-directory) service.
	ServiceDirectory *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`

	// Timeout: Webhook execution timeout. Execution is considered failed if
	// Dialogflow doesn't receive a response from webhook at the end of the
	// timeout period. Defaults to 5 seconds, maximum allowed timeout is 30
	// seconds.
	Timeout string `json:"timeout,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Webhook
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebService: Represents
// configuration for a generic web service.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebService struct {
	// AllowedCaCerts: Optional. Specifies a list of allowed custom CA
	// certificates (in DER format) for HTTPS verification. This overrides
	// the default SSL trust store. If this is empty or unspecified,
	// Dialogflow will use Google's default trust store to verify
	// certificates. N.B. Make sure the HTTPS server certificates are signed
	// with "subject alt name". For instance a certificate can be
	// self-signed using the following command, openssl x509 -req -days 200
	// -in example.com.csr \ -signkey example.com.key \ -out example.com.crt
	// \ -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`

	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`

	// RequestHeaders: The HTTP request headers to send together with
	// webhook requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`

	// Uri: Required. The webhook URI for receiving POST requests. It must
	// use https protocol.
	Uri string `json:"uri,omitempty"`

	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowedCaCerts") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequest: The request message for
// a webhook call. The request is sent as a JSON object and the field
// names will be presented in camel cases.
type GoogleCloudDialogflowCxV3beta1WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`

	// FulfillmentInfo: Always present. Information about the fulfillment
	// that triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`

	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo `json:"intentInfo,omitempty"`

	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	// Webhook can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`

	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`

	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SentimentAnalysisResult: The sentiment analysis result of the current
	// user request. The field is filled when sentiment analysis is
	// configured to be enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`

	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`

	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`

	// Transcript: If natural language speech audio was provided as input,
	// this field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`

	// TriggerEvent: If an event was provided as input, this field will
	// contain the name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`

	// TriggerIntent: If an intent was provided as input, this field will
	// contain a copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DetectIntentResponseId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectIntentResponseId")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo:
// Represents fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The tag used to identify which fulfillment is
	// being called.
	Tag string `json:"tag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Tag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Tag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo: Represents
// intent information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from
	// 0.0 (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// DisplayName: Always present. The display name of the last matched
	// intent.
	DisplayName string `json:"displayName,omitempty"`

	// LastMatchedIntent: Always present. The unique identifier of the last
	// matched intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`

	// Parameters: Parameters identified as a result of intent matching.
	// This is a map of the name of the identified parameter to the value of
	// the parameter identified from the user's utterance. All parameters
	// defined in the matched intent that are identified will be surfaced
	// here.
	Parameters map[string]GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confidence") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterV
// alue: Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from
	// user utterance.
	OriginalValue string `json:"originalValue,omitempty"`

	// ResolvedValue: Always present. Structured value for the parameter
	// extracted from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OriginalValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult:
// Represents the result of sentiment analysis.
type GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which
	// represents the absolute magnitude of sentiment, regardless of score
	// (positive or negative).
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookResponse: The response message
// for a webhook call.
type GoogleCloudDialogflowCxV3beta1WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user.
	// This field can be omitted by the webhook if it does not intend to
	// send any response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`

	// PageInfo: Information about page status. This field can be omitted by
	// the webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`

	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SessionInfo: Information about session status. This field can be
	// omitted by the webhook if it does not intend to modify session
	// status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`

	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`

	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FulfillmentResponse") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse:
// Represents a fulfillment response to the user.
type GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be
	// used.
	//   "APPEND" - `messages` will be appended to the list of messages
	// waiting to be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to
	// be sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`

	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MergeBehavior") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig:
// Represents configuration for a Service Directory
// (https://cloud.google.com/service-directory) service.
type GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig struct {
	// GenericWebService: Generic Service configuration of this webhook.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`

	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `Location ID` of the
	// service directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericWebService")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericWebService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AnnotatedMessagePart: Represents a part of a
// message possibly annotated with an entity. The part can be an entity
// or purely a part of the message between two entities or message
// start/end.
type GoogleCloudDialogflowV2AnnotatedMessagePart struct {
	// EntityType: The Dialogflow system entity type
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. If this is empty, Dialogflow could not annotate
	// the phrase part with a system entity.
	EntityType string `json:"entityType,omitempty"`

	// FormattedValue: The Dialogflow system entity formatted value
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. For example for a system entity of type
	// `@sys.unit-currency`, this may contain: { "amount": 5, "currency":
	// "USD" }
	FormattedValue interface{} `json:"formattedValue,omitempty"`

	// Text: A part of a message possibly annotated with an entity.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnnotatedMessagePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ArticleAnswer: Represents article answer.
type GoogleCloudDialogflowV2ArticleAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`

	// Confidence: Article match confidence. The system's confidence score
	// that this article is a good match for this conversation, as a value
	// from 0.0 (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// Metadata: A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// Snippets: Article snippets.
	Snippets []string `json:"snippets,omitempty"`

	// Title: The article title.
	Title string `json:"title,omitempty"`

	// Uri: The article URI.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnswerRecord") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse: The response
// message for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse struct {
	// EntityTypes: The collection of updated or created entity types.
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2BatchUpdateIntentsResponse: The response
// message for Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2BatchUpdateIntentsResponse struct {
	// Intents: The collection of updated or created intents.
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Intents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Intents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Context: Dialogflow contexts are similar to
// natural language context. If a person says to you "they are orange",
// you need context in order to understand what "they" is referring to.
// Similarly, for Dialogflow to handle an end-user expression like that,
// it needs to be provided with context in order to correctly match an
// intent. Using contexts, you can control the flow of a conversation.
// You can configure contexts for an intent by setting input and output
// contexts, which are identified by string names. When an intent is
// matched, any configured output contexts for that intent become
// active. While any contexts are active, Dialogflow is more likely to
// match intents that are configured with input contexts that correspond
// to the currently active contexts. For more information about context,
// see the Contexts guide
// (https://cloud.google.com/dialogflow/docs/contexts-overview).
type GoogleCloudDialogflowV2Context struct {
	// LifespanCount: Optional. The number of conversational query requests
	// after which the context expires. The default is `0`. If set to `0`,
	// the context expires immediately. Contexts expire automatically after
	// 20 minutes if there are no matching queries.
	LifespanCount int64 `json:"lifespanCount,omitempty"`

	// Name: Required. The unique identifier of the context. Format:
	// `projects//agent/sessions//contexts/`, or
	// `projects//agent/environments//users//sessions//contexts/`. The
	// `Context ID` is always converted to lowercase, may only contain
	// characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If
	// `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-'
	// user. The following context names are reserved for internal use by
	// Dialogflow. You should not use these contexts or create contexts with
	// these names: * `__system_counters__` * `*_id_dialog_context` *
	// `*_dialog_params_size`
	Name string `json:"name,omitempty"`

	// Parameters: Optional. The collection of parameters associated with
	// this context. Depending on your protocol or client library language,
	// this is a map, associative array, symbol table, dictionary, or JSON
	// object composed of a collection of (MapKey, MapValue) pairs: - MapKey
	// type: string - MapKey value: parameter name - MapValue type: - If
	// parameter's entity type is a composite entity: map - Else: depending
	// on parameter value type, could be one of string, number, boolean,
	// null, list or map - MapValue value: - If parameter's entity type is a
	// composite entity: map from composite entity property names to
	// property values - Else: parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LifespanCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Context
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ConversationEvent: Represents a notification
// sent to Pub/Sub subscribers for conversation lifecycle events.
type GoogleCloudDialogflowV2ConversationEvent struct {
	// Conversation: The unique identifier of the conversation this
	// notification refers to. Format: `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`

	// ErrorStatus: More detailed information about an error. Only set for
	// type UNRECOVERABLE_ERROR_IN_PHONE_CALL.
	ErrorStatus *GoogleRpcStatus `json:"errorStatus,omitempty"`

	// NewMessagePayload: Payload of NEW_MESSAGE event.
	NewMessagePayload *GoogleCloudDialogflowV2Message `json:"newMessagePayload,omitempty"`

	// Type: The type of the event that this notification refers to.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not set.
	//   "CONVERSATION_STARTED" - A new conversation has been opened. This
	// is fired when a telephone call is answered, or a conversation is
	// created via the API.
	//   "CONVERSATION_FINISHED" - An existing conversation has closed. This
	// is fired when a telephone call is terminated, or a conversation is
	// closed via the API.
	//   "HUMAN_INTERVENTION_NEEDED" - An existing conversation has received
	// notification from Dialogflow that human intervention is required.
	//   "NEW_MESSAGE" - An existing conversation has received a new
	// message, either from API or telephony. It is configured in
	// ConversationProfile.new_message_event_notification_config
	//   "UNRECOVERABLE_ERROR" - Unrecoverable error during a telephone
	// call. In general non-recoverable errors only occur if something was
	// misconfigured in the ConversationProfile corresponding to the call.
	// After a non-recoverable error, Dialogflow may stop responding. We
	// don't fire this event: * in an API call because we can directly
	// return the error, or, * when we can recover from an error.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityType: Each intent parameter has a type,
// called the entity type, which dictates exactly how data from an
// end-user expression is extracted. Dialogflow provides predefined
// system entities that can match many common types of data. For
// example, there are system entities for matching dates, times, colors,
// email addresses, and so on. You can also create your own custom
// entities for matching custom data. For example, you could define a
// vegetable entity that can match the types of vegetables available for
// purchase with a grocery store agent. For more information, see the
// Entity guide
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowV2EntityType struct {
	// AutoExpansionMode: Optional. Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values
	// that have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`

	// DisplayName: Required. The name of the entity type.
	DisplayName string `json:"displayName,omitempty"`

	// EnableFuzzyExtraction: Optional. Enables fuzzy entity extraction
	// during classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`

	// Entities: Optional. The collection of entity entries associated with
	// the entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`

	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms
	// to a reference value.
	//   "KIND_LIST" - List entity types contain a set of entries that do
	// not map to reference values. However, list entity types can contain
	// references to other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular
	// expressions in entries values.
	Kind string `json:"kind,omitempty"`

	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes
	// methods. Format: `projects//agent/entityTypes/`.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoExpansionMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityTypeEntity: An **entity entry** for an
// associated entity type.
type GoogleCloudDialogflowV2EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if
	// the entity type is *vegetable*, and `value` is *scallions*, a synonym
	// could be *green onions*. For `KIND_LIST` entity types: * This
	// collection must contain exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`

	// Value: Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*. For `KIND_MAP` entity types: * A reference value to be
	// used in place of synonyms. For `KIND_LIST` entity types: * A string
	// that can contain references to other entity types (with or without
	// aliases).
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Synonyms") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EventInput: Events allow for matching intents
// by event name instead of the natural language input. For instance,
// input `` can trigger a personalized welcome response. The parameter
// `name` may be used by the agent in the response: "Hello
// #welcome_event.name! What can I do for you today?".
type GoogleCloudDialogflowV2EventInput struct {
	// LanguageCode: Required. The language of this query. See Language
	// Support (https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that
	// queries in the same session do not necessarily need to specify the
	// same language.
	LanguageCode string `json:"languageCode,omitempty"`

	// Name: Required. The unique identifier of the event.
	Name string `json:"name,omitempty"`

	// Parameters: The collection of parameters associated with the event.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed
	// of a collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EventInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowV2ExportAgentResponse struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`

	// AgentUri: The URI to a file containing the exported agent. This field
	// is populated only if `agent_uri` is specified in
	// `ExportAgentRequest`.
	AgentUri string `json:"agentUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2FaqAnswer: Represents answer from "frequently
// asked questions".
type GoogleCloudDialogflowV2FaqAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`

	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`

	// Confidence: The system's confidence score that this Knowledge answer
	// is a good match for this conversational query, range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// Metadata: A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`

	// Source: Indicates which Knowledge Document this answer was extracted
	// from. Format:
	// `projects//locations//agent/knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Answer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2HumanAgentAssistantEvent: Represents a
// notification sent to Cloud Pub/Sub subscribers for human agent
// assistant events in a specific conversation.
type GoogleCloudDialogflowV2HumanAgentAssistantEvent struct {
	// Conversation: The conversation this notification refers to. Format:
	// `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`

	// Participant: The participant that the suggestion is compiled for.
	// Format: `projects//conversations//participants/`. It will not be set
	// in legacy workflow.
	Participant string `json:"participant,omitempty"`

	// SuggestionResults: The suggestion results payload that this
	// notification refers to.
	SuggestionResults []*GoogleCloudDialogflowV2SuggestionResult `json:"suggestionResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Intent: An intent categorizes an end-user's
// intention for one conversation turn. For each agent, you define many
// intents, where your combined intents can handle a complete
// conversation. When an end-user writes or says something, referred to
// as an end-user expression or end-user input, Dialogflow matches the
// end-user input to the best intent in your agent. Matching an intent
// is also known as intent classification. For more information, see the
// intent guide
// (https://cloud.google.com/dialogflow/docs/intents-overview).
type GoogleCloudDialogflowV2Intent struct {
	// Action: Optional. The name of the action associated with the intent.
	// Note: The action name must not contain whitespaces.
	Action string `json:"action,omitempty"`

	// DefaultResponsePlatforms: Optional. The list of platforms for which
	// the first responses will be copied from the messages in
	// PLATFORM_UNSPECIFIED (i.e. default platform).
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dia
	// logflow-webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	DefaultResponsePlatforms []string `json:"defaultResponsePlatforms,omitempty"`

	// DisplayName: Required. The name of this intent.
	DisplayName string `json:"displayName,omitempty"`

	// EndInteraction: Optional. Indicates that this intent ends an
	// interaction. Some integrations (e.g., Actions on Google or Dialogflow
	// phone gateway) use this information to close interaction with an end
	// user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`

	// Events: Optional. The collection of event names that trigger the
	// intent. If the collection of input contexts is not empty, all of the
	// contexts must be present in the active user session for an event to
	// trigger this intent. Event names are limited to 150 characters.
	Events []string `json:"events,omitempty"`

	// FollowupIntentInfo: Output only. Read-only. Information about all
	// followup intents that have this intent as a direct or indirect
	// parent. We populate this field only in the output.
	FollowupIntentInfo []*GoogleCloudDialogflowV2IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`

	// InputContextNames: Optional. The list of context names required for
	// this intent to be triggered. Format:
	// `projects//agent/sessions/-/contexts/`.
	InputContextNames []string `json:"inputContextNames,omitempty"`

	// IsFallback: Optional. Indicates whether this is a fallback intent.
	IsFallback bool `json:"isFallback,omitempty"`

	// LiveAgentHandoff: Optional. Indicates that a live agent should be
	// brought in to handle the interaction with the user. In most cases,
	// when you set this flag to true, you would also want to set
	// end_interaction to true as well. Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`

	// Messages: Optional. The collection of rich messages corresponding to
	// the `Response` field in the Dialogflow console.
	Messages []*GoogleCloudDialogflowV2IntentMessage `json:"messages,omitempty"`

	// MlDisabled: Optional. Indicates whether Machine Learning is disabled
	// for the intent. Note: If `ml_disabled` setting is set to true, then
	// this intent is not taken into account during inference in `ML ONLY`
	// match mode. Also, auto-markup in the UI is turned off.
	MlDisabled bool `json:"mlDisabled,omitempty"`

	// Name: Optional. The unique identifier of this intent. Required for
	// Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
	// `projects//agent/intents/`.
	Name string `json:"name,omitempty"`

	// OutputContexts: Optional. The collection of contexts that are
	// activated when the intent is matched. Context messages in this
	// collection should not set the parameters field. Setting the
	// `lifespan_count` to 0 will reset the context when the intent is
	// matched. Format: `projects//agent/sessions/-/contexts/`.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`

	// Parameters: Optional. The collection of parameters associated with
	// the intent.
	Parameters []*GoogleCloudDialogflowV2IntentParameter `json:"parameters,omitempty"`

	// ParentFollowupIntentName: Read-only after creation. The unique
	// identifier of the parent intent in the chain of followup intents. You
	// can set this field when creating an intent, for example with
	// CreateIntent or BatchUpdateIntents, in order to make this intent a
	// followup intent. It identifies the parent followup intent. Format:
	// `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`

	// Priority: Optional. The priority of this intent. Higher numbers
	// represent higher priorities. - If the supplied value is unspecified
	// or 0, the service translates the value to 500,000, which corresponds
	// to the `Normal` priority in the console. - If the supplied value is
	// negative, the intent is ignored in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`

	// ResetContexts: Optional. Indicates whether to delete all contexts in
	// the current session when this intent is matched.
	ResetContexts bool `json:"resetContexts,omitempty"`

	// RootFollowupIntentName: Output only. Read-only. The unique identifier
	// of the root intent in the chain of followup intents. It identifies
	// the correct followup intents chain for this intent. We populate this
	// field only in the output. Format: `projects//agent/intents/`.
	RootFollowupIntentName string `json:"rootFollowupIntentName,omitempty"`

	// TrainingPhrases: Optional. The collection of examples that the agent
	// is trained on.
	TrainingPhrases []*GoogleCloudDialogflowV2IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// WebhookState: Optional. Indicates whether webhooks are enabled for
	// the intent.
	//
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED" - Webhook is disabled in the agent and
	// in the intent.
	//   "WEBHOOK_STATE_ENABLED" - Webhook is enabled in the agent and in
	// the intent.
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING" - Webhook is enabled in
	// the agent and in the intent. Also, each slot filling prompt is
	// forwarded to the webhook.
	WebhookState string `json:"webhookState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Intent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentFollowupIntentInfo: Represents a single
// followup intent in the chain.
type GoogleCloudDialogflowV2IntentFollowupIntentInfo struct {
	// FollowupIntentName: The unique identifier of the followup intent.
	// Format: `projects//agent/intents/`.
	FollowupIntentName string `json:"followupIntentName,omitempty"`

	// ParentFollowupIntentName: The unique identifier of the followup
	// intent's parent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FollowupIntentName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FollowupIntentName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentFollowupIntentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessage: A rich response message.
// Corresponds to the intent `Response` field in the Dialogflow console.
// For more information, see Rich response messages
// (https://cloud.google.com/dialogflow/docs/intents-rich-messages).
type GoogleCloudDialogflowV2IntentMessage struct {
	// BasicCard: The basic card response for Actions on Google.
	BasicCard *GoogleCloudDialogflowV2IntentMessageBasicCard `json:"basicCard,omitempty"`

	// BrowseCarouselCard: Browse carousel card for Actions on Google.
	BrowseCarouselCard *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`

	// Card: The card response.
	Card *GoogleCloudDialogflowV2IntentMessageCard `json:"card,omitempty"`

	// CarouselSelect: The carousel card response for Actions on Google.
	CarouselSelect *GoogleCloudDialogflowV2IntentMessageCarouselSelect `json:"carouselSelect,omitempty"`

	// Image: The image response.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// LinkOutSuggestion: The link out suggestion chip for Actions on
	// Google.
	LinkOutSuggestion *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion `json:"linkOutSuggestion,omitempty"`

	// ListSelect: The list card response for Actions on Google.
	ListSelect *GoogleCloudDialogflowV2IntentMessageListSelect `json:"listSelect,omitempty"`

	// MediaContent: The media content card for Actions on Google.
	MediaContent *GoogleCloudDialogflowV2IntentMessageMediaContent `json:"mediaContent,omitempty"`

	// Payload: A custom platform-specific response.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// Platform: Optional. The platform that this message is intended for.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dia
	// logflow-webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	Platform string `json:"platform,omitempty"`

	// QuickReplies: The quick replies response.
	QuickReplies *GoogleCloudDialogflowV2IntentMessageQuickReplies `json:"quickReplies,omitempty"`

	// SimpleResponses: The voice and text-only responses for Actions on
	// Google.
	SimpleResponses *GoogleCloudDialogflowV2IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`

	// Suggestions: The suggestion chips for Actions on Google.
	Suggestions *GoogleCloudDialogflowV2IntentMessageSuggestions `json:"suggestions,omitempty"`

	// TableCard: Table card for Actions on Google.
	TableCard *GoogleCloudDialogflowV2IntentMessageTableCard `json:"tableCard,omitempty"`

	// Text: The text response.
	Text *GoogleCloudDialogflowV2IntentMessageText `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasicCard") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCard: The basic card
// message. Useful for displaying information.
type GoogleCloudDialogflowV2IntentMessageBasicCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`

	// FormattedText: Required, unless image is present. The body text of
	// the card.
	FormattedText string `json:"formattedText,omitempty"`

	// Image: Optional. The image for the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButton: The button
// object that appears at the bottom of a card.
type GoogleCloudDialogflowV2IntentMessageBasicCardButton struct {
	// OpenUriAction: Required. Action to take when a user taps on the
	// button.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`

	// Title: Required. The title of the button.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OpenUriAction") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction:
// Opens the given URI.
type GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction struct {
	// Uri: Required. The HTTP or HTTPS scheme URI.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard: Browse
// Carousel Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard struct {
	// ImageDisplayOptions: Optional. Settings for displaying the image.
	// Applies to every image in items.
	//
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED" - Fill the gaps between the
	// image and the image container with gray bars.
	//   "GRAY" - Fill the gaps between the image and the image container
	// with gray bars.
	//   "WHITE" - Fill the gaps between the image and the image container
	// with white bars.
	//   "CROPPED" - Image is scaled such that the image width and height
	// match or exceed the container dimensions. This may crop the top and
	// bottom of the image if the scaled image height is greater than the
	// container height, or crop the left and right of the image if the
	// scaled image width is greater than the container width. This is
	// similar to "Zoom Mode" on a widescreen TV when playing a 4:3 video.
	//   "BLURRED_BACKGROUND" - Pad the gaps between image and image frame
	// with a blurred copy of the same image.
	ImageDisplayOptions string `json:"imageDisplayOptions,omitempty"`

	// Items: Required. List of items in the Browse Carousel Card. Minimum
	// of two items, maximum of ten.
	Items []*GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCa
// rdItem: Browsing carousel tile
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	// Description: Optional. Description of the carousel item. Maximum of
	// four lines of text.
	Description string `json:"description,omitempty"`

	// Footer: Optional. Text that appears at the bottom of the Browse
	// Carousel Card. Maximum of one line of text.
	Footer string `json:"footer,omitempty"`

	// Image: Optional. Hero image for the carousel item.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// OpenUriAction: Required. Action to present to the user.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`

	// Title: Required. Title of the carousel item. Maximum of two lines of
	// text.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCa
// rdItemOpenUrlAction: Actions on Google action to open a given url.
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	// Url: Required. URL
	Url string `json:"url,omitempty"`

	// UrlTypeHint: Optional. Specifies the type of viewer that is used when
	// opening the URL. Defaults to opening via web browser.
	//
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED" - Unspecified
	//   "AMP_ACTION" - Url would be an amp action
	//   "AMP_CONTENT" - URL that points directly to AMP content, or to a
	// canonical URL which refers to AMP content via .
	UrlTypeHint string `json:"urlTypeHint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Url") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Url") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCard: The card response message.
type GoogleCloudDialogflowV2IntentMessageCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageCardButton `json:"buttons,omitempty"`

	// ImageUri: Optional. The public URI to an image file for the card.
	ImageUri string `json:"imageUri,omitempty"`

	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCardButton: Contains information
// about a button.
type GoogleCloudDialogflowV2IntentMessageCardButton struct {
	// Postback: Optional. The text to send back to the Dialogflow API or a
	// URI to open.
	Postback string `json:"postback,omitempty"`

	// Text: Optional. The text to show on the button.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Postback") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCardButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelect: The card for
// presenting a carousel of options to select from.
type GoogleCloudDialogflowV2IntentMessageCarouselSelect struct {
	// Items: Required. Carousel items.
	Items []*GoogleCloudDialogflowV2IntentMessageCarouselSelectItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelectItem: An item in
// the carousel.
type GoogleCloudDialogflowV2IntentMessageCarouselSelectItem struct {
	// Description: Optional. The body text of the card.
	Description string `json:"description,omitempty"`

	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// Info: Required. Additional info about the option item.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`

	// Title: Required. Title of the carousel item.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelectItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageColumnProperties: Column
// properties for TableCard.
type GoogleCloudDialogflowV2IntentMessageColumnProperties struct {
	// Header: Required. Column heading.
	Header string `json:"header,omitempty"`

	// HorizontalAlignment: Optional. Defines text alignment for all cells
	// in this column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Text is aligned to the leading
	// edge of the column.
	//   "LEADING" - Text is aligned to the leading edge of the column.
	//   "CENTER" - Text is centered in the column.
	//   "TRAILING" - Text is aligned to the trailing edge of the column.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Header") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageColumnProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageImage: The image response
// message.
type GoogleCloudDialogflowV2IntentMessageImage struct {
	// AccessibilityText: Optional. A text description of the image to be
	// used for accessibility, e.g., screen readers.
	AccessibilityText string `json:"accessibilityText,omitempty"`

	// ImageUri: Optional. The public URI to an image file.
	ImageUri string `json:"imageUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessibilityText")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessibilityText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion: The suggestion
// chip message that allows the user to jump out to the app or website
// associated with this agent.
type GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion struct {
	// DestinationName: Required. The name of the app or site this chip is
	// linking to.
	DestinationName string `json:"destinationName,omitempty"`

	// Uri: Required. The URI of the app or site to open when the user taps
	// the suggestion chip.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelect: The card for
// presenting a list of options to select from.
type GoogleCloudDialogflowV2IntentMessageListSelect struct {
	// Items: Required. List items.
	Items []*GoogleCloudDialogflowV2IntentMessageListSelectItem `json:"items,omitempty"`

	// Subtitle: Optional. Subtitle of the list.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The overall title of the list.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelectItem: An item in the
// list.
type GoogleCloudDialogflowV2IntentMessageListSelectItem struct {
	// Description: Optional. The main text describing the item.
	Description string `json:"description,omitempty"`

	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// Info: Required. Additional information about this option.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`

	// Title: Required. The title of the list item.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelectItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContent: The media content
// card for Actions on Google.
type GoogleCloudDialogflowV2IntentMessageMediaContent struct {
	// MediaObjects: Required. List of media objects.
	MediaObjects []*GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`

	// MediaType: Optional. What type of media is the content (ie "audio").
	//
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED" - Unspecified.
	//   "AUDIO" - Response media type is audio.
	MediaType string `json:"mediaType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediaObjects") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject:
// Response media object for media content card.
type GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject struct {
	// ContentUrl: Required. Url where the media is stored.
	ContentUrl string `json:"contentUrl,omitempty"`

	// Description: Optional. Description of media card.
	Description string `json:"description,omitempty"`

	// Icon: Optional. Icon to display above media content.
	Icon *GoogleCloudDialogflowV2IntentMessageImage `json:"icon,omitempty"`

	// LargeImage: Optional. Image to display above media content.
	LargeImage *GoogleCloudDialogflowV2IntentMessageImage `json:"largeImage,omitempty"`

	// Name: Required. Name of media card.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageQuickReplies: The quick replies
// response message.
type GoogleCloudDialogflowV2IntentMessageQuickReplies struct {
	// QuickReplies: Optional. The collection of quick replies.
	QuickReplies []string `json:"quickReplies,omitempty"`

	// Title: Optional. The title of the collection of quick replies.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QuickReplies") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageQuickReplies
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSelectItemInfo: Additional info
// about the select item for when it is triggered in a dialog.
type GoogleCloudDialogflowV2IntentMessageSelectItemInfo struct {
	// Key: Required. A unique key that will be sent back to the agent if
	// this response is given.
	Key string `json:"key,omitempty"`

	// Synonyms: Optional. A list of synonyms that can also be used to
	// trigger this item in dialog.
	Synonyms []string `json:"synonyms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSelectItemInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponse: The simple
// response message containing speech or text.
type GoogleCloudDialogflowV2IntentMessageSimpleResponse struct {
	// DisplayText: Optional. The text to display.
	DisplayText string `json:"displayText,omitempty"`

	// Ssml: One of text_to_speech or ssml must be provided. Structured
	// spoken response to the user in the SSML format. Mutually exclusive
	// with text_to_speech.
	Ssml string `json:"ssml,omitempty"`

	// TextToSpeech: One of text_to_speech or ssml must be provided. The
	// plain text of the speech output. Mutually exclusive with ssml.
	TextToSpeech string `json:"textToSpeech,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponses: The collection
// of simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type GoogleCloudDialogflowV2IntentMessageSimpleResponses struct {
	// SimpleResponses: Required. The list of simple responses.
	SimpleResponses []*GoogleCloudDialogflowV2IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SimpleResponses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponses
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestion: The suggestion chip
// message that the user can tap to quickly post a reply to the
// conversation.
type GoogleCloudDialogflowV2IntentMessageSuggestion struct {
	// Title: Required. The text shown the in the suggestion chip.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Title") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestions: The collection of
// suggestions.
type GoogleCloudDialogflowV2IntentMessageSuggestions struct {
	// Suggestions: Required. The list of suggested replies.
	Suggestions []*GoogleCloudDialogflowV2IntentMessageSuggestion `json:"suggestions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Suggestions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCard: Table card for Actions
// on Google.
type GoogleCloudDialogflowV2IntentMessageTableCard struct {
	// Buttons: Optional. List of buttons for the card.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`

	// ColumnProperties: Optional. Display properties for the columns in
	// this table.
	ColumnProperties []*GoogleCloudDialogflowV2IntentMessageColumnProperties `json:"columnProperties,omitempty"`

	// Image: Optional. Image which should be displayed on the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`

	// Rows: Optional. Rows in this table of data.
	Rows []*GoogleCloudDialogflowV2IntentMessageTableCardRow `json:"rows,omitempty"`

	// Subtitle: Optional. Subtitle to the title.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Required. Title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardCell: Cell of
// TableCardRow.
type GoogleCloudDialogflowV2IntentMessageTableCardCell struct {
	// Text: Required. Text in this cell.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardCell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardRow: Row of TableCard.
type GoogleCloudDialogflowV2IntentMessageTableCardRow struct {
	// Cells: Optional. List of cells that make up this row.
	Cells []*GoogleCloudDialogflowV2IntentMessageTableCardCell `json:"cells,omitempty"`

	// DividerAfter: Optional. Whether to add a visual divider after this
	// row.
	DividerAfter bool `json:"dividerAfter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageText: The text response message.
type GoogleCloudDialogflowV2IntentMessageText struct {
	// Text: Optional. The collection of the agent's responses.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentParameter: Represents intent parameters.
type GoogleCloudDialogflowV2IntentParameter struct {
	// DefaultValue: Optional. The default value to use when the `value`
	// yields an empty result. Default values can be extracted from contexts
	// by using the following syntax: `#context_name.parameter_name`.
	DefaultValue string `json:"defaultValue,omitempty"`

	// DisplayName: Required. The name of the parameter.
	DisplayName string `json:"displayName,omitempty"`

	// EntityTypeDisplayName: Optional. The name of the entity type,
	// prefixed with `@`, that describes values of the parameter. If the
	// parameter is required, this must be provided.
	EntityTypeDisplayName string `json:"entityTypeDisplayName,omitempty"`

	// IsList: Optional. Indicates whether the parameter represents a list
	// of values.
	IsList bool `json:"isList,omitempty"`

	// Mandatory: Optional. Indicates whether the parameter is required.
	// That is, whether the intent cannot be completed without collecting
	// the parameter value.
	Mandatory bool `json:"mandatory,omitempty"`

	// Name: The unique identifier of this parameter.
	Name string `json:"name,omitempty"`

	// Prompts: Optional. The collection of prompts that the agent can
	// present to the user in order to collect a value for the parameter.
	Prompts []string `json:"prompts,omitempty"`

	// Value: Optional. The definition of the parameter value. It can be: -
	// a constant string, - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	// `#context_name.parameter_name`.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrase: Represents an example
// that the agent is trained on.
type GoogleCloudDialogflowV2IntentTrainingPhrase struct {
	// Name: Output only. The unique identifier of this training phrase.
	Name string `json:"name,omitempty"`

	// Parts: Required. The ordered list of training phrase parts. The parts
	// are concatenated in order to form the training phrase. Note: The API
	// does not automatically annotate training phrases like the Dialogflow
	// Console does. Note: Do not forget to include whitespace at part
	// boundaries, so the training phrase is well formatted when the parts
	// are concatenated. If the training phrase does not need to be
	// annotated with parameters, you just need a single part with only the
	// Part.text field set. If you want to annotate the training phrase, you
	// must create multiple parts, where the fields of each part are
	// populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the
	// phrase that you want to annotate, and the `entity_type`, `alias`, and
	// `user_defined` fields are all set.
	Parts []*GoogleCloudDialogflowV2IntentTrainingPhrasePart `json:"parts,omitempty"`

	// TimesAddedCount: Optional. Indicates how many times this example was
	// added to the intent. Each time a developer adds an existing sample by
	// editing an intent or training, this counter is increased.
	TimesAddedCount int64 `json:"timesAddedCount,omitempty"`

	// Type: Required. The type of the training phrase.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be
	// used.
	//   "EXAMPLE" - Examples do not contain @-prefixed entity type names,
	// but example parts can be annotated with entity types.
	//   "TEMPLATE" - Templates are not annotated with entity types, but
	// they can contain @-prefixed entity type names as substrings. Template
	// mode has been deprecated. Example mode is the only supported way to
	// create new training phrases. If you have existing training phrases
	// that you've created in template mode, those will continue to work.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrasePart: Represents a part of
// a training phrase.
type GoogleCloudDialogflowV2IntentTrainingPhrasePart struct {
	// Alias: Optional. The parameter name for the value extracted from the
	// annotated part of the example. This field is required for annotated
	// parts of the training phrase.
	Alias string `json:"alias,omitempty"`

	// EntityType: Optional. The entity type name prefixed with `@`. This
	// field is required for annotated parts of the training phrase.
	EntityType string `json:"entityType,omitempty"`

	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`

	// UserDefined: Optional. Indicates whether the text was manually
	// annotated. This field is set to true when the Dialogflow Console is
	// used to manually annotate the part. When creating an annotated part
	// with the API, you must set this to true.
	UserDefined bool `json:"userDefined,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrasePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeOperationMetadata: Metadata in
// google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV2KnowledgeOperationMetadata struct {
	// State: Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Message: Represents a message posted into a
// conversation.
type GoogleCloudDialogflowV2Message struct {
	// Content: Required. The message content.
	Content string `json:"content,omitempty"`

	// CreateTime: Output only. The time when the message was created.
	CreateTime string `json:"createTime,omitempty"`

	// LanguageCode: Optional. The message language. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`

	// MessageAnnotation: Output only. The annotation for the message.
	MessageAnnotation *GoogleCloudDialogflowV2MessageAnnotation `json:"messageAnnotation,omitempty"`

	// Name: The unique identifier of the message. Format:
	// `projects//locations//conversations//messages/`.
	Name string `json:"name,omitempty"`

	// Participant: Output only. The participant that sends this message.
	Participant string `json:"participant,omitempty"`

	// ParticipantRole: Output only. The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted
	// with Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Message
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2MessageAnnotation: Represents the result of
// annotation for the message.
type GoogleCloudDialogflowV2MessageAnnotation struct {
	// ContainEntities: Indicates whether the text message contains
	// entities.
	ContainEntities bool `json:"containEntities,omitempty"`

	// Parts: The collection of annotated message parts ordered by their
	// position in the message. You can recover the annotated message by
	// concatenating [AnnotatedMessagePart.text].
	Parts []*GoogleCloudDialogflowV2AnnotatedMessagePart `json:"parts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainEntities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2OriginalDetectIntentRequest: Represents the
// contents of the original request that was passed to the
// `[Streaming]DetectIntent` call.
type GoogleCloudDialogflowV2OriginalDetectIntentRequest struct {
	// Payload: Optional. This field is set to the value of the
	// `QueryParameters.payload` field passed in the request. Some
	// integrations that query a Dialogflow agent may provide additional
	// information in the payload. In particular, for the Dialogflow Phone
	// Gateway integration, this field has the form: { "telephony": {
	// "caller_id": "+18558363987" } } Note: The caller ID field
	// (`caller_id`) will be redacted for Trial Edition agents and populated
	// with the caller ID in E.164 format
	// (https://en.wikipedia.org/wiki/E.164) for Essentials Edition agents.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// Source: The source of this request, e.g., `google`, `facebook`,
	// `slack`. It is set by Dialogflow-owned servers.
	Source string `json:"source,omitempty"`

	// Version: Optional. The version of the protocol used for this request.
	// This field is AoG-specific.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Payload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Payload") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OriginalDetectIntentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2QueryResult: Represents the result of
// conversational query or event processing.
type GoogleCloudDialogflowV2QueryResult struct {
	// Action: The action name from the matched intent.
	Action string `json:"action,omitempty"`

	// AllRequiredParamsPresent: This field is set to: - `false` if the
	// matched intent has required parameters and not all of the required
	// parameter values have been collected. - `true` if all required
	// parameter values have been collected, or if the matched intent
	// doesn't contain any required parameters.
	AllRequiredParamsPresent bool `json:"allRequiredParamsPresent,omitempty"`

	// CancelsSlotFilling: Indicates whether the conversational query
	// triggers a cancellation for slot filling.
	CancelsSlotFilling bool `json:"cancelsSlotFilling,omitempty"`

	// DiagnosticInfo: Free-form diagnostic information for the associated
	// detect intent request. The fields of this data can change without
	// notice, so you should not write code that depends on its structure.
	// The data may contain: - webhook call latency - webhook errors
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`

	// FulfillmentMessages: The collection of rich messages to present to
	// the user.
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage `json:"fulfillmentMessages,omitempty"`

	// FulfillmentText: The text to be pronounced to the user or shown on
	// the screen. Note: This is a legacy field, `fulfillment_messages`
	// should be preferred.
	FulfillmentText string `json:"fulfillmentText,omitempty"`

	// Intent: The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name`, `end_interaction` and `is_fallback`.
	Intent *GoogleCloudDialogflowV2Intent `json:"intent,omitempty"`

	// IntentDetectionConfidence: The intent detection confidence. Values
	// range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help
	// match the best intent within the classification threshold. This value
	// may change for the same end-user expression at any time due to a
	// model retraining or change in implementation. If there are `multiple
	// knowledge_answers` messages, this value is set to the greatest
	// `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`

	// LanguageCode: The language that was triggered during intent
	// detection. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a
	// list of the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`

	// OutputContexts: The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name `.original`
	// containing the original parameter values before the query.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`

	// Parameters: The collection of extracted parameters. Depending on your
	// protocol or client library language, this is a map, associative
	// array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// QueryText: The original conversational query text: - If natural
	// language text was provided as input, `query_text` contains a copy of
	// the input. - If natural language speech audio was provided as input,
	// `query_text` contains the speech recognition result. If speech
	// recognizer produced multiple alternatives, a particular one is
	// picked. - If automatic spell correction is enabled, `query_text` will
	// contain the corrected user input.
	QueryText string `json:"queryText,omitempty"`

	// SentimentAnalysisResult: The sentiment analysis result, which depends
	// on the `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`

	// SpeechRecognitionConfidence: The Speech recognition confidence
	// between 0.0 and 1.0. A higher number indicates an estimated greater
	// likelihood that the recognized words are correct. The default of 0.0
	// is a sentinel value indicating that confidence was not set. This
	// field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming
	// endpoint has separate confidence estimates per portion of the audio
	// in StreamingRecognitionResult.
	SpeechRecognitionConfidence float64 `json:"speechRecognitionConfidence,omitempty"`

	// WebhookPayload: If the query was fulfilled by a webhook call, this
	// field is set to the value of the `payload` field returned in the
	// webhook response.
	WebhookPayload googleapi.RawMessage `json:"webhookPayload,omitempty"`

	// WebhookSource: If the query was fulfilled by a webhook call, this
	// field is set to the value of the `source` field returned in the
	// webhook response.
	WebhookSource string `json:"webhookSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

// GoogleCloudDialogflowV2Sentiment: The sentiment, such as
// positive/negative feeling or association, for a unit of analysis,
// such as the query text.
type GoogleCloudDialogflowV2Sentiment struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which
	// represents the absolute magnitude of sentiment, regardless of score
	// (positive or negative).
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowV2SentimentAnalysisResult: The result of
// sentiment analysis. Sentiment analysis inspects user input and
// identifies the prevailing subjective opinion, especially to determine
// a user's attitude as positive, negative, or neutral. For
// Participants.DetectIntent, it needs to be configured in
// DetectIntentRequest.query_params. For
// Participants.StreamingDetectIntent, it needs to be configured in
// StreamingDetectIntentRequest.query_params. And for
// Participants.AnalyzeContent and Participants.StreamingAnalyzeContent,
// it needs to be configured in
// ConversationProfile.human_agent_assistant_config
type GoogleCloudDialogflowV2SentimentAnalysisResult struct {
	// QueryTextSentiment: The sentiment analysis result for `query_text`.
	QueryTextSentiment *GoogleCloudDialogflowV2Sentiment `json:"queryTextSentiment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QueryTextSentiment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SessionEntityType: A session represents a
// conversation between a Dialogflow agent and an end-user. You can
// create special entities, called session entities, during a session.
// Session entities can extend or replace custom entity types and only
// exist during the session that they were created for. All session
// data, including session entities, is stored by Dialogflow for 20
// minutes. For more information, see the session entity guide
// (https://cloud.google.com/dialogflow/docs/entities-session).
type GoogleCloudDialogflowV2SessionEntityType struct {
	// Entities: Required. The collection of entities associated with this
	// session entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`

	// EntityOverrideMode: Required. Indicates whether the additional data
	// should override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value
	// should be never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session
	// entities overrides the collection of entities in the corresponding
	// custom entity type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session
	// entities extends the collection of entities in the corresponding
	// custom entity type. Note: Even in this override mode calls to
	// `ListSessionEntityTypes`, `GetSessionEntityType`,
	// `CreateSessionEntityType` and `UpdateSessionEntityType` only return
	// the additional entities added in this session entity type. If you
	// want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`

	// Name: Required. The unique identifier of this session entity type.
	// Format: `projects//agent/sessions//entityTypes/`, or
	// `projects//agent/environments//users//sessions//entityTypes/`. If
	// `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-'
	// user. `` must be the display name of an existing entity type in the
	// same agent that will be overridden or supplemented.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SessionEntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestArticlesResponse: The response message
// for Participants.SuggestArticles.
type GoogleCloudDialogflowV2SuggestArticlesResponse struct {
	// ArticleAnswers: Articles ordered by score in descending order.
	ArticleAnswers []*GoogleCloudDialogflowV2ArticleAnswer `json:"articleAnswers,omitempty"`

	// ContextSize: Number of messages prior to and including latest_message
	// to compile the suggestion. It may be smaller than the
	// SuggestArticlesRequest.context_size field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`

	// LatestMessage: The name of the latest conversation message used to
	// compile suggestion for. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArticleAnswers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestFaqAnswersResponse: The request message
// for Participants.SuggestFaqAnswers.
type GoogleCloudDialogflowV2SuggestFaqAnswersResponse struct {
	// ContextSize: Number of messages prior to and including latest_message
	// to compile the suggestion. It may be smaller than the
	// SuggestFaqAnswersRequest.context_size field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`

	// FaqAnswers: Answers extracted from FAQ documents.
	FaqAnswers []*GoogleCloudDialogflowV2FaqAnswer `json:"faqAnswers,omitempty"`

	// LatestMessage: The name of the latest conversation message used to
	// compile suggestion for. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContextSize") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestionResult: One response of different
// type of suggestion response which is used in the response of
// Participants.AnalyzeContent and Participants.AnalyzeContent, as well
// as HumanAgentAssistantEvent.
type GoogleCloudDialogflowV2SuggestionResult struct {
	// Error: Error status if the request failed.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// SuggestArticlesResponse: SuggestArticlesResponse if request is for
	// ARTICLE_SUGGESTION.
	SuggestArticlesResponse *GoogleCloudDialogflowV2SuggestArticlesResponse `json:"suggestArticlesResponse,omitempty"`

	// SuggestFaqAnswersResponse: SuggestFaqAnswersResponse if request is
	// for FAQ_ANSWER.
	SuggestFaqAnswersResponse *GoogleCloudDialogflowV2SuggestFaqAnswersResponse `json:"suggestFaqAnswersResponse,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2WebhookRequest: The request message for a
// webhook call.
type GoogleCloudDialogflowV2WebhookRequest struct {
	// OriginalDetectIntentRequest: Optional. The contents of the original
	// request that was passed to `[Streaming]DetectIntent` call.
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`

	// QueryResult: The result of the conversational query or event
	// processing. Contains the same value as
	// `[Streaming]DetectIntentResponse.query_result`.
	QueryResult *GoogleCloudDialogflowV2QueryResult `json:"queryResult,omitempty"`

	// ResponseId: The unique identifier of the response. Contains the same
	// value as `[Streaming]DetectIntentResponse.response_id`.
	ResponseId string `json:"responseId,omitempty"`

	// Session: The unique identifier of detectIntent request session. Can
	// be used to identify end-user inside webhook implementation. Format:
	// `projects//agent/sessions/`, or
	// `projects//agent/environments//users//sessions/`.
	Session string `json:"session,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "OriginalDetectIntentRequest") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "OriginalDetectIntentRequest") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2WebhookResponse: The response message for a
// webhook call. This response is validated by the Dialogflow server. If
// validation fails, an error will be returned in the
// QueryResult.diagnostic_info field. Setting JSON fields to an empty
// value with the wrong type is a common error. To avoid this error: -
// Use "" for empty strings - Use `{}` or `null` for empty objects -
// Use `[]` or `null` for empty arrays For more information, see the
// Protocol Buffers Language Guide
// (https://developers.google.com/protocol-buffers/docs/proto3#json).
type GoogleCloudDialogflowV2WebhookResponse struct {
	// FollowupEventInput: Optional. Invokes the supplied events. When this
	// field is set, Dialogflow ignores the `fulfillment_text`,
	// `fulfillment_messages`, and `payload` fields.
	FollowupEventInput *GoogleCloudDialogflowV2EventInput `json:"followupEventInput,omitempty"`

	// FulfillmentMessages: Optional. The rich response messages intended
	// for the end-user. When provided, Dialogflow uses this field to
	// populate QueryResult.fulfillment_messages sent to the integration or
	// API caller.
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage `json:"fulfillmentMessages,omitempty"`

	// FulfillmentText: Optional. The text response message intended for the
	// end-user. It is recommended to use
	// `fulfillment_messages.text.text[0]` instead. When provided,
	// Dialogflow uses this field to populate QueryResult.fulfillment_text
	// sent to the integration or API caller.
	FulfillmentText string `json:"fulfillmentText,omitempty"`

	// OutputContexts: Optional. The collection of output contexts that will
	// overwrite currently active contexts for the session and reset their
	// lifespans. When provided, Dialogflow uses this field to populate
	// QueryResult.output_contexts sent to the integration or API caller.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`

	// Payload: Optional. This field can be used to pass custom data from
	// your webhook to the integration or API caller. Arbitrary JSON objects
	// are supported. When provided, Dialogflow uses this field to populate
	// QueryResult.webhook_payload sent to the integration or API caller.
	// This field is also used by the Google Assistant integration
	// (https://cloud.google.com/dialogflow/docs/integrations/aog) for rich
	// response messages. See the format definition at Google Assistant
	// Dialogflow webhook format
	// (https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SessionEntityTypes: Optional. Additional session entity types to
	// replace or extend developer entity types with. The entity synonyms
	// apply to all languages and persist for the session. Setting this data
	// from a webhook overwrites the session entity types that have been set
	// using `detectIntent`, `streamingDetectIntent` or SessionEntityType
	// management methods.
	SessionEntityTypes []*GoogleCloudDialogflowV2SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// Source: Optional. A custom field used to identify the webhook source.
	// Arbitrary strings are supported. When provided, Dialogflow uses this
	// field to populate QueryResult.webhook_source sent to the integration
	// or API caller.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FollowupEventInput")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FollowupEventInput") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnnotatedMessagePart: Represents a part
// of a message possibly annotated with an entity. The part can be an
// entity or purely a part of the message between two entities or
// message start/end.
type GoogleCloudDialogflowV2beta1AnnotatedMessagePart struct {
	// EntityType: Optional. The Dialogflow system entity type
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. If this is empty, Dialogflow could not annotate
	// the phrase part with a system entity.
	EntityType string `json:"entityType,omitempty"`

	// FormattedValue: Optional. The Dialogflow system entity formatted
	// value
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. For example for a system entity of type
	// `@sys.unit-currency`, this may contain: { "amount": 5, "currency":
	// "USD" }
	FormattedValue interface{} `json:"formattedValue,omitempty"`

	// Text: Required. A part of a message possibly annotated with an
	// entity.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnnotatedMessagePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ArticleAnswer: Represents article answer.
type GoogleCloudDialogflowV2beta1ArticleAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`

	// Metadata: A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// Snippets: Output only. Article snippets.
	Snippets []string `json:"snippets,omitempty"`

	// Title: The article title.
	Title string `json:"title,omitempty"`

	// Uri: The article URI.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnswerRecord") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ArticleAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse: The
// response message for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse struct {
	// EntityTypes: The collection of updated or created entity types.
	EntityTypes []*GoogleCloudDialogflowV2beta1EntityType `json:"entityTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntityTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse: The response
// message for Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse struct {
	// Intents: The collection of updated or created intents.
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Intents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Intents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Context: Dialogflow contexts are similar
// to natural language context. If a person says to you "they are
// orange", you need context in order to understand what "they" is
// referring to. Similarly, for Dialogflow to handle an end-user
// expression like that, it needs to be provided with context in order
// to correctly match an intent. Using contexts, you can control the
// flow of a conversation. You can configure contexts for an intent by
// setting input and output contexts, which are identified by string
// names. When an intent is matched, any configured output contexts for
// that intent become active. While any contexts are active, Dialogflow
// is more likely to match intents that are configured with input
// contexts that correspond to the currently active contexts. For more
// information about context, see the Contexts guide
// (https://cloud.google.com/dialogflow/docs/contexts-overview).
type GoogleCloudDialogflowV2beta1Context struct {
	// LifespanCount: Optional. The number of conversational query requests
	// after which the context expires. The default is `0`. If set to `0`,
	// the context expires immediately. Contexts expire automatically after
	// 20 minutes if there are no matching queries.
	LifespanCount int64 `json:"lifespanCount,omitempty"`

	// Name: Required. The unique identifier of the context. Supported
	// formats: - `projects//agent/sessions//contexts/`, -
	// `projects//locations//agent/sessions//contexts/`, -
	// `projects//agent/environments//users//sessions//contexts/`, -
	// `projects//locations//agent/environments//users//sessions//contexts/`,
	//  The `Context ID` is always converted to lowercase, may only contain
	// characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If
	// `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-'
	// user. The following context names are reserved for internal use by
	// Dialogflow. You should not use these contexts or create contexts with
	// these names: * `__system_counters__` * `*_id_dialog_context` *
	// `*_dialog_params_size`
	Name string `json:"name,omitempty"`

	// Parameters: Optional. The collection of parameters associated with
	// this context. Depending on your protocol or client library language,
	// this is a map, associative array, symbol table, dictionary, or JSON
	// object composed of a collection of (MapKey, MapValue) pairs: - MapKey
	// type: string - MapKey value: parameter name - MapValue type: - If
	// parameter's entity type is a composite entity: map - Else: depending
	// on parameter value type, could be one of string, number, boolean,
	// null, list or map - MapValue value: - If parameter's entity type is a
	// composite entity: map from composite entity property names to
	// property values - Else: parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LifespanCount") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Context
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationEvent: Represents a
// notification sent to Pub/Sub subscribers for conversation lifecycle
// events.
type GoogleCloudDialogflowV2beta1ConversationEvent struct {
	// Conversation: Required. The unique identifier of the conversation
	// this notification refers to. Format: `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`

	// ErrorStatus: Optional. More detailed information about an error. Only
	// set for type UNRECOVERABLE_ERROR_IN_PHONE_CALL.
	ErrorStatus *GoogleRpcStatus `json:"errorStatus,omitempty"`

	// NewMessagePayload: Payload of NEW_MESSAGE event.
	NewMessagePayload *GoogleCloudDialogflowV2beta1Message `json:"newMessagePayload,omitempty"`

	// Type: Required. The type of the event that this notification refers
	// to.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not set.
	//   "CONVERSATION_STARTED" - A new conversation has been opened. This
	// is fired when a telephone call is answered, or a conversation is
	// created via the API.
	//   "CONVERSATION_FINISHED" - An existing conversation has closed. This
	// is fired when a telephone call is terminated, or a conversation is
	// closed via the API.
	//   "NEW_MESSAGE" - An existing conversation has received a new
	// message, either from API or telephony. It is configured in
	// ConversationProfile.new_message_event_notification_config
	//   "UNRECOVERABLE_ERROR" - Unrecoverable error during a telephone
	// call. In general non-recoverable errors only occur if something was
	// misconfigured in the ConversationProfile corresponding to the call.
	// After a non-recoverable error, Dialogflow may stop responding. We
	// don't fire this event: * in an API call because we can directly
	// return the error, or, * when we can recover from an error.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EntityType: Each intent parameter has a
// type, called the entity type, which dictates exactly how data from an
// end-user expression is extracted. Dialogflow provides predefined
// system entities that can match many common types of data. For
// example, there are system entities for matching dates, times, colors,
// email addresses, and so on. You can also create your own custom
// entities for matching custom data. For example, you could define a
// vegetable entity that can match the types of vegetables available for
// purchase with a grocery store agent. For more information, see the
// Entity guide
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowV2beta1EntityType struct {
	// AutoExpansionMode: Optional. Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values
	// that have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`

	// DisplayName: Required. The name of the entity type.
	DisplayName string `json:"displayName,omitempty"`

	// EnableFuzzyExtraction: Optional. Enables fuzzy entity extraction
	// during classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`

	// Entities: Optional. The collection of entity entries associated with
	// the entity type.
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`

	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms
	// to a reference value.
	//   "KIND_LIST" - List entity types contain a set of entries that do
	// not map to reference values. However, list entity types can contain
	// references to other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular
	// expressions in entries values.
	Kind string `json:"kind,omitempty"`

	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes
	// methods. Supported formats: - `projects//agent/entityTypes/` -
	// `projects//locations//agent/entityTypes/`
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoExpansionMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EntityTypeEntity: An **entity entry** for
// an associated entity type.
type GoogleCloudDialogflowV2beta1EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if
	// the entity type is *vegetable*, and `value` is *scallions*, a synonym
	// could be *green onions*. For `KIND_LIST` entity types: * This
	// collection must contain exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`

	// Value: Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*. For `KIND_MAP` entity types: * A reference value to be
	// used in place of synonyms. For `KIND_LIST` entity types: * A string
	// that can contain references to other entity types (with or without
	// aliases).
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Synonyms") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityTypeEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EventInput: Events allow for matching
// intents by event name instead of the natural language input. For
// instance, input `` can trigger a personalized welcome response. The
// parameter `name` may be used by the agent in the response: "Hello
// #welcome_event.name! What can I do for you today?".
type GoogleCloudDialogflowV2beta1EventInput struct {
	// LanguageCode: Required. The language of this query. See Language
	// Support (https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that
	// queries in the same session do not necessarily need to specify the
	// same language.
	LanguageCode string `json:"languageCode,omitempty"`

	// Name: Required. The unique identifier of the event.
	Name string `json:"name,omitempty"`

	// Parameters: The collection of parameters associated with the event.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed
	// of a collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LanguageCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EventInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ExportAgentResponse: The response message
// for Agents.ExportAgent.
type GoogleCloudDialogflowV2beta1ExportAgentResponse struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`

	// AgentUri: The URI to a file containing the exported agent. This field
	// is populated only if `agent_uri` is specified in
	// `ExportAgentRequest`.
	AgentUri string `json:"agentUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportAgentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FaqAnswer: Represents answer from
// "frequently asked questions".
type GoogleCloudDialogflowV2beta1FaqAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`

	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`

	// Confidence: The system's confidence score that this Knowledge answer
	// is a good match for this conversational query, range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// Metadata: A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`

	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`

	// Source: Indicates which Knowledge Document this answer was extracted
	// from. Format:
	// `projects//locations//agent/knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Answer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent: Output only.
// Represents a notification sent to Pub/Sub subscribers for agent
// assistant events in a specific conversation.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent struct {
	// Conversation: The conversation this notification refers to. Format:
	// `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`

	// Participant: The participant that the suggestion is compiled for. And
	// This field is used to call Participants.ListSuggestions API. Format:
	// `projects//conversations//participants/`. It will not be set in
	// legacy workflow. HumanAgentAssistantConfig.name for more information.
	Participant string `json:"participant,omitempty"`

	// SuggestionResults: The suggestion results payload that this
	// notification refers to. It will only be set when
	// HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses
	// sets to true.
	SuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"suggestionResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ImportDocumentsResponse: Response message
// for Documents.ImportDocuments.
type GoogleCloudDialogflowV2beta1ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other
	// warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Warnings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Intent: An intent categorizes an
// end-user's intention for one conversation turn. For each agent, you
// define many intents, where your combined intents can handle a
// complete conversation. When an end-user writes or says something,
// referred to as an end-user expression or end-user input, Dialogflow
// matches the end-user input to the best intent in your agent. Matching
// an intent is also known as intent classification. For more
// information, see the intent guide
// (https://cloud.google.com/dialogflow/docs/intents-overview).
type GoogleCloudDialogflowV2beta1Intent struct {
	// Action: Optional. The name of the action associated with the intent.
	// Note: The action name must not contain whitespaces.
	Action string `json:"action,omitempty"`

	// DefaultResponsePlatforms: Optional. The list of platforms for which
	// the first responses will be copied from the messages in
	// PLATFORM_UNSPECIFIED (i.e. default platform).
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Not specified.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dia
	// logflow-webhook-json)
	//   "TELEPHONY" - Telephony Gateway.
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	DefaultResponsePlatforms []string `json:"defaultResponsePlatforms,omitempty"`

	// DisplayName: Required. The name of this intent.
	DisplayName string `json:"displayName,omitempty"`

	// EndInteraction: Optional. Indicates that this intent ends an
	// interaction. Some integrations (e.g., Actions on Google or Dialogflow
	// phone gateway) use this information to close interaction with an end
	// user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`

	// Events: Optional. The collection of event names that trigger the
	// intent. If the collection of input contexts is not empty, all of the
	// contexts must be present in the active user session for an event to
	// trigger this intent. Event names are limited to 150 characters.
	Events []string `json:"events,omitempty"`

	// FollowupIntentInfo: Output only. Information about all followup
	// intents that have this intent as a direct or indirect parent. We
	// populate this field only in the output.
	FollowupIntentInfo []*GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`

	// InputContextNames: Optional. The list of context names required for
	// this intent to be triggered. Formats: -
	// `projects//agent/sessions/-/contexts/` -
	// `projects//locations//agent/sessions/-/contexts/`
	InputContextNames []string `json:"inputContextNames,omitempty"`

	// IsFallback: Optional. Indicates whether this is a fallback intent.
	IsFallback bool `json:"isFallback,omitempty"`

	// LiveAgentHandoff: Optional. Indicates that a live agent should be
	// brought in to handle the interaction with the user. In most cases,
	// when you set this flag to true, you would also want to set
	// end_interaction to true as well. Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`

	// Messages: Optional. The collection of rich messages corresponding to
	// the `Response` field in the Dialogflow console.
	Messages []*GoogleCloudDialogflowV2beta1IntentMessage `json:"messages,omitempty"`

	// MlDisabled: Optional. Indicates whether Machine Learning is disabled
	// for the intent. Note: If `ml_disabled` setting is set to true, then
	// this intent is not taken into account during inference in `ML ONLY`
	// match mode. Also, auto-markup in the UI is turned off.
	MlDisabled bool `json:"mlDisabled,omitempty"`

	// MlEnabled: Optional. Indicates whether Machine Learning is enabled
	// for the intent. Note: If `ml_enabled` setting is set to false, then
	// this intent is not taken into account during inference in `ML ONLY`
	// match mode. Also, auto-markup in the UI is turned off. DEPRECATED!
	// Please use `ml_disabled` field instead. NOTE: If both `ml_enabled`
	// and `ml_disabled` are either not set or false, then the default value
	// is determined as follows: - Before April 15th, 2018 the default is:
	// ml_enabled = false / ml_disabled = true. - After April 15th, 2018 the
	// default is: ml_enabled = true / ml_disabled = false.
	MlEnabled bool `json:"mlEnabled,omitempty"`

	// Name: Optional. The unique identifier of this intent. Required for
	// Intents.UpdateIntent and Intents.BatchUpdateIntents methods.
	// Supported formats: - `projects//agent/intents/` -
	// `projects//locations//agent/intents/`
	Name string `json:"name,omitempty"`

	// OutputContexts: Optional. The collection of contexts that are
	// activated when the intent is matched. Context messages in this
	// collection should not set the parameters field. Setting the
	// `lifespan_count` to 0 will reset the context when the intent is
	// matched. Format: `projects//agent/sessions/-/contexts/`.
	OutputContexts []*GoogleCloudDialogflowV2beta1Context `json:"outputContexts,omitempty"`

	// Parameters: Optional. The collection of parameters associated with
	// the intent.
	Parameters []*GoogleCloudDialogflowV2beta1IntentParameter `json:"parameters,omitempty"`

	// ParentFollowupIntentName: Optional. The unique identifier of the
	// parent intent in the chain of followup intents. You can set this
	// field when creating an intent, for example with CreateIntent or
	// BatchUpdateIntents, in order to make this intent a followup intent.
	// It identifies the parent followup intent. Format:
	// `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`

	// Priority: Optional. The priority of this intent. Higher numbers
	// represent higher priorities. - If the supplied value is unspecified
	// or 0, the service translates the value to 500,000, which corresponds
	// to the `Normal` priority in the console. - If the supplied value is
	// negative, the intent is ignored in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`

	// ResetContexts: Optional. Indicates whether to delete all contexts in
	// the current session when this intent is matched.
	ResetContexts bool `json:"resetContexts,omitempty"`

	// RootFollowupIntentName: Output only. The unique identifier of the
	// root intent in the chain of followup intents. It identifies the
	// correct followup intents chain for this intent. Format:
	// `projects//agent/intents/`.
	RootFollowupIntentName string `json:"rootFollowupIntentName,omitempty"`

	// TrainingPhrases: Optional. The collection of examples that the agent
	// is trained on.
	TrainingPhrases []*GoogleCloudDialogflowV2beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// WebhookState: Optional. Indicates whether webhooks are enabled for
	// the intent.
	//
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED" - Webhook is disabled in the agent and
	// in the intent.
	//   "WEBHOOK_STATE_ENABLED" - Webhook is enabled in the agent and in
	// the intent.
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING" - Webhook is enabled in
	// the agent and in the intent. Also, each slot filling prompt is
	// forwarded to the webhook.
	WebhookState string `json:"webhookState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Intent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo: Represents a
// single followup intent in the chain.
type GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo struct {
	// FollowupIntentName: The unique identifier of the followup intent.
	// Format: `projects//agent/intents/`.
	FollowupIntentName string `json:"followupIntentName,omitempty"`

	// ParentFollowupIntentName: The unique identifier of the followup
	// intent's parent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FollowupIntentName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FollowupIntentName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessage: Corresponds to the
// `Response` field in the Dialogflow console.
type GoogleCloudDialogflowV2beta1IntentMessage struct {
	// BasicCard: Displays a basic card for Actions on Google.
	BasicCard *GoogleCloudDialogflowV2beta1IntentMessageBasicCard `json:"basicCard,omitempty"`

	// BrowseCarouselCard: Browse carousel card for Actions on Google.
	BrowseCarouselCard *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`

	// Card: Displays a card.
	Card *GoogleCloudDialogflowV2beta1IntentMessageCard `json:"card,omitempty"`

	// CarouselSelect: Displays a carousel card for Actions on Google.
	CarouselSelect *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect `json:"carouselSelect,omitempty"`

	// Image: Displays an image.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// LinkOutSuggestion: Displays a link out suggestion chip for Actions on
	// Google.
	LinkOutSuggestion *GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion `json:"linkOutSuggestion,omitempty"`

	// ListSelect: Displays a list card for Actions on Google.
	ListSelect *GoogleCloudDialogflowV2beta1IntentMessageListSelect `json:"listSelect,omitempty"`

	// MediaContent: The media content card for Actions on Google.
	MediaContent *GoogleCloudDialogflowV2beta1IntentMessageMediaContent `json:"mediaContent,omitempty"`

	// Payload: A custom platform-specific response.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// Platform: Optional. The platform that this message is intended for.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Not specified.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dia
	// logflow-webhook-json)
	//   "TELEPHONY" - Telephony Gateway.
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	Platform string `json:"platform,omitempty"`

	// QuickReplies: Displays quick replies.
	QuickReplies *GoogleCloudDialogflowV2beta1IntentMessageQuickReplies `json:"quickReplies,omitempty"`

	// RbmCarouselRichCard: Rich Business Messaging (RBM) carousel rich card
	// response.
	RbmCarouselRichCard *GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard `json:"rbmCarouselRichCard,omitempty"`

	// RbmStandaloneRichCard: Standalone Rich Business Messaging (RBM) rich
	// card response.
	RbmStandaloneRichCard *GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard `json:"rbmStandaloneRichCard,omitempty"`

	// RbmText: Rich Business Messaging (RBM) text response. RBM allows
	// businesses to send enriched and branded versions of SMS. See
	// https://jibe.google.com/business-messaging.
	RbmText *GoogleCloudDialogflowV2beta1IntentMessageRbmText `json:"rbmText,omitempty"`

	// SimpleResponses: Returns a voice or text-only response for Actions on
	// Google.
	SimpleResponses *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`

	// Suggestions: Displays suggestion chips for Actions on Google.
	Suggestions *GoogleCloudDialogflowV2beta1IntentMessageSuggestions `json:"suggestions,omitempty"`

	// TableCard: Table card for Actions on Google.
	TableCard *GoogleCloudDialogflowV2beta1IntentMessageTableCard `json:"tableCard,omitempty"`

	// TelephonyPlayAudio: Plays audio from a file in Telephony Gateway.
	TelephonyPlayAudio *GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio `json:"telephonyPlayAudio,omitempty"`

	// TelephonySynthesizeSpeech: Synthesizes speech in Telephony Gateway.
	TelephonySynthesizeSpeech *GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech `json:"telephonySynthesizeSpeech,omitempty"`

	// TelephonyTransferCall: Transfers the call in Telephony Gateway.
	TelephonyTransferCall *GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`

	// Text: Returns a text response.
	Text *GoogleCloudDialogflowV2beta1IntentMessageText `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasicCard") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCard: The basic card
// message. Useful for displaying information.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`

	// FormattedText: Required, unless image is present. The body text of
	// the card.
	FormattedText string `json:"formattedText,omitempty"`

	// Image: Optional. The image for the card.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton: The button
// object that appears at the bottom of a card.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton struct {
	// OpenUriAction: Required. Action to take when a user taps on the
	// button.
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`

	// Title: Required. The title of the button.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OpenUriAction") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction:
//  Opens the given URI.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction struct {
	// Uri: Required. The HTTP or HTTPS scheme URI.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard: Browse
// Carousel Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard struct {
	// ImageDisplayOptions: Optional. Settings for displaying the image.
	// Applies to every image in items.
	//
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED" - Fill the gaps between the
	// image and the image container with gray bars.
	//   "GRAY" - Fill the gaps between the image and the image container
	// with gray bars.
	//   "WHITE" - Fill the gaps between the image and the image container
	// with white bars.
	//   "CROPPED" - Image is scaled such that the image width and height
	// match or exceed the container dimensions. This may crop the top and
	// bottom of the image if the scaled image height is greater than the
	// container height, or crop the left and right of the image if the
	// scaled image width is greater than the container width. This is
	// similar to "Zoom Mode" on a widescreen TV when playing a 4:3 video.
	//   "BLURRED_BACKGROUND" - Pad the gaps between image and image frame
	// with a blurred copy of the same image.
	ImageDisplayOptions string `json:"imageDisplayOptions,omitempty"`

	// Items: Required. List of items in the Browse Carousel Card. Minimum
	// of two items, maximum of ten.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarou
// selCardItem: Browsing carousel tile
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	// Description: Optional. Description of the carousel item. Maximum of
	// four lines of text.
	Description string `json:"description,omitempty"`

	// Footer: Optional. Text that appears at the bottom of the Browse
	// Carousel Card. Maximum of one line of text.
	Footer string `json:"footer,omitempty"`

	// Image: Optional. Hero image for the carousel item.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// OpenUriAction: Required. Action to present to the user.
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`

	// Title: Required. Title of the carousel item. Maximum of two lines of
	// text.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarou
// selCardItemOpenUrlAction: Actions on Google action to open a given
// url.
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	// Url: Required. URL
	Url string `json:"url,omitempty"`

	// UrlTypeHint: Optional. Specifies the type of viewer that is used when
	// opening the URL. Defaults to opening via web browser.
	//
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED" - Unspecified
	//   "AMP_ACTION" - Url would be an amp action
	//   "AMP_CONTENT" - URL that points directly to AMP content, or to a
	// canonical URL which refers to AMP content via .
	UrlTypeHint string `json:"urlTypeHint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Url") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Url") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCard: The card response
// message.
type GoogleCloudDialogflowV2beta1IntentMessageCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageCardButton `json:"buttons,omitempty"`

	// ImageUri: Optional. The public URI to an image file for the card.
	ImageUri string `json:"imageUri,omitempty"`

	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCardButton: Optional.
// Contains information about a button.
type GoogleCloudDialogflowV2beta1IntentMessageCardButton struct {
	// Postback: Optional. The text to send back to the Dialogflow API or a
	// URI to open.
	Postback string `json:"postback,omitempty"`

	// Text: Optional. The text to show on the button.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Postback") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCardButton
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect: The card for
// presenting a carousel of options to select from.
type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect struct {
	// Items: Required. Carousel items.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem: An item
// in the carousel.
type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem struct {
	// Description: Optional. The body text of the card.
	Description string `json:"description,omitempty"`

	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// Info: Required. Additional info about the option item.
	Info *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`

	// Title: Required. Title of the carousel item.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageColumnProperties: Column
// properties for TableCard.
type GoogleCloudDialogflowV2beta1IntentMessageColumnProperties struct {
	// Header: Required. Column heading.
	Header string `json:"header,omitempty"`

	// HorizontalAlignment: Optional. Defines text alignment for all cells
	// in this column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Text is aligned to the leading
	// edge of the column.
	//   "LEADING" - Text is aligned to the leading edge of the column.
	//   "CENTER" - Text is centered in the column.
	//   "TRAILING" - Text is aligned to the trailing edge of the column.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Header") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageColumnProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageImage: The image response
// message.
type GoogleCloudDialogflowV2beta1IntentMessageImage struct {
	// AccessibilityText: A text description of the image to be used for
	// accessibility, e.g., screen readers. Required if image_uri is set for
	// CarouselSelect.
	AccessibilityText string `json:"accessibilityText,omitempty"`

	// ImageUri: Optional. The public URI to an image file.
	ImageUri string `json:"imageUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessibilityText")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessibilityText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion: The
// suggestion chip message that allows the user to jump out to the app
// or website associated with this agent.
type GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion struct {
	// DestinationName: Required. The name of the app or site this chip is
	// linking to.
	DestinationName string `json:"destinationName,omitempty"`

	// Uri: Required. The URI of the app or site to open when the user taps
	// the suggestion chip.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageListSelect: The card for
// presenting a list of options to select from.
type GoogleCloudDialogflowV2beta1IntentMessageListSelect struct {
	// Items: Required. List items.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageListSelectItem `json:"items,omitempty"`

	// Subtitle: Optional. Subtitle of the list.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Optional. The overall title of the list.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageListSelectItem: An item in
// the list.
type GoogleCloudDialogflowV2beta1IntentMessageListSelectItem struct {
	// Description: Optional. The main text describing the item.
	Description string `json:"description,omitempty"`

	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// Info: Required. Additional information about this option.
	Info *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`

	// Title: Required. The title of the list item.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelectItem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageMediaContent: The media
// content card for Actions on Google.
type GoogleCloudDialogflowV2beta1IntentMessageMediaContent struct {
	// MediaObjects: Required. List of media objects.
	MediaObjects []*GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`

	// MediaType: Optional. What type of media is the content (ie "audio").
	//
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED" - Unspecified.
	//   "AUDIO" - Response media type is audio.
	MediaType string `json:"mediaType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediaObjects") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObje
// ct: Response media object for media content card.
type GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject struct {
	// ContentUrl: Required. Url where the media is stored.
	ContentUrl string `json:"contentUrl,omitempty"`

	// Description: Optional. Description of media card.
	Description string `json:"description,omitempty"`

	// Icon: Optional. Icon to display above media content.
	Icon *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"icon,omitempty"`

	// LargeImage: Optional. Image to display above media content.
	LargeImage *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"largeImage,omitempty"`

	// Name: Required. Name of media card.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageQuickReplies: The quick
// replies response message.
type GoogleCloudDialogflowV2beta1IntentMessageQuickReplies struct {
	// QuickReplies: Optional. The collection of quick replies.
	QuickReplies []string `json:"quickReplies,omitempty"`

	// Title: Optional. The title of the collection of quick replies.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QuickReplies") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageQuickReplies
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent: Rich
// Business Messaging (RBM) Card content
type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent struct {
	// Description: Optional. Description of the card (at most 2000 bytes).
	// At least one of the title, description or media must be set.
	Description string `json:"description,omitempty"`

	// Media: Optional. However at least one of the title, description or
	// media must be set. Media (image, GIF or a video) to include in the
	// card.
	Media *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia `json:"media,omitempty"`

	// Suggestions: Optional. List of suggestions to include in the card.
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"suggestions,omitempty"`

	// Title: Optional. Title of the card (at most 200 bytes). At least one
	// of the title, description or media must be set.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia: Rich
// Business Messaging (RBM) Media displayed in Cards The following
// media-types are currently supported: Image Types * image/jpeg *
// image/jpg' * image/gif * image/png Video Types * video/h263 *
// video/m4v * video/mp4 * video/mpeg * video/mpeg4 * video/webm
type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia struct {
	// FileUri: Required. Publicly reachable URI of the file. The RBM
	// platform determines the MIME type of the file from the content-type
	// field in the HTTP headers when the platform fetches the file. The
	// content-type field must be present and accurate in the HTTP response
	// from the URL.
	FileUri string `json:"fileUri,omitempty"`

	// Height: Required for cards with vertical orientation. The height of
	// the media within a rich card with a vertical layout. For a standalone
	// card with horizontal layout, height is not customizable, and this
	// field is ignored.
	//
	// Possible values:
	//   "HEIGHT_UNSPECIFIED" - Not specified.
	//   "SHORT" - 112 DP.
	//   "MEDIUM" - 168 DP.
	//   "TALL" - 264 DP. Not available for rich card carousels when the
	// card width is set to small.
	Height string `json:"height,omitempty"`

	// ThumbnailUri: Optional. Publicly reachable URI of the thumbnail.If
	// you don't provide a thumbnail URI, the RBM platform displays a blank
	// placeholder thumbnail until the user's device downloads the file.
	// Depending on the user's setting, the file may not download
	// automatically and may require the user to tap a download button.
	ThumbnailUri string `json:"thumbnailUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard: Carousel
// Rich Business Messaging (RBM) rich card. Rich cards allow you to
// respond to users with more vivid content, e.g. with media and
// suggestions. If you want to show a single card with more control over
// the layout, please use RbmStandaloneCard instead.
type GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard struct {
	// CardContents: Required. The cards in the carousel. A carousel must
	// have at least 2 cards and at most 10.
	CardContents []*GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContents,omitempty"`

	// CardWidth: Required. The width of the cards in the carousel.
	//
	// Possible values:
	//   "CARD_WIDTH_UNSPECIFIED" - Not specified.
	//   "SMALL" - 120 DP. Note that tall media cannot be used.
	//   "MEDIUM" - 232 DP.
	CardWidth string `json:"cardWidth,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardContents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardContents") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard:
// Standalone Rich Business Messaging (RBM) rich card. Rich cards allow
// you to respond to users with more vivid content, e.g. with media and
// suggestions. You can group multiple rich cards into one using
// RbmCarouselCard but carousel cards will give you less control over
// the card layout.
type GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard struct {
	// CardContent: Required. Card content.
	CardContent *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContent,omitempty"`

	// CardOrientation: Required. Orientation of the card.
	//
	// Possible values:
	//   "CARD_ORIENTATION_UNSPECIFIED" - Not specified.
	//   "HORIZONTAL" - Horizontal layout.
	//   "VERTICAL" - Vertical layout.
	CardOrientation string `json:"cardOrientation,omitempty"`

	// ThumbnailImageAlignment: Required if orientation is horizontal. Image
	// preview alignment for standalone cards with horizontal layout.
	//
	// Possible values:
	//   "THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED" - Not specified.
	//   "LEFT" - Thumbnail preview is left-aligned.
	//   "RIGHT" - Thumbnail preview is right-aligned.
	ThumbnailImageAlignment string `json:"thumbnailImageAlignment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardContent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardContent") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction: Rich
// Business Messaging (RBM) suggested client-side action that the user
// can choose from the card.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction struct {
	// Dial: Suggested client side action: Dial a phone number
	Dial *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial `json:"dial,omitempty"`

	// OpenUrl: Suggested client side action: Open a URI on device
	OpenUrl *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri `json:"openUrl,omitempty"`

	// PostbackData: Opaque payload that the Dialogflow receives in a user
	// event when the user taps the suggested action. This data will be also
	// forwarded to webhook to allow performing custom business logic.
	PostbackData string `json:"postbackData,omitempty"`

	// ShareLocation: Suggested client side action: Share user location
	ShareLocation *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation `json:"shareLocation,omitempty"`

	// Text: Text to display alongside the action.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dial") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dial") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggeste
// dActionDial: Opens the user's default dialer app with the specified
// phone number but does not dial automatically.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial struct {
	// PhoneNumber: Required. The phone number to fill in the default dialer
	// app. This field should be in E.164
	// (https://en.wikipedia.org/wiki/E.164) format. An example of a
	// correctly formatted phone number: +15556767888.
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggeste
// dActionOpenUri: Opens the user's default web browser app to the
// specified uri If the user has an app installed that is registered as
// the default handler for the URL, then this app will be opened
// instead, and its icon will be used in the suggested action UI.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri struct {
	// Uri: Required. The uri to open on the user device
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggeste
// dActionShareLocation: Opens the device's location chooser so the user
// can pick a location to send back to the agent.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation struct {
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply: Rich
// Business Messaging (RBM) suggested reply that the user can click
// instead of typing in their own response.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply struct {
	// PostbackData: Opaque payload that the Dialogflow receives in a user
	// event when the user taps the suggested reply. This data will be also
	// forwarded to webhook to allow performing custom business logic.
	PostbackData string `json:"postbackData,omitempty"`

	// Text: Suggested reply text.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostbackData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostbackData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion: Rich Business
// Messaging (RBM) suggestion. Suggestions allow user to easily
// select/click a predefined response or perform an action (like opening
// a web uri).
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion struct {
	// Action: Predefined client side actions that user can choose
	Action *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction `json:"action,omitempty"`

	// Reply: Predefined replies for user to select instead of typing
	Reply *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply `json:"reply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmText: Rich Business
// Messaging (RBM) text response with suggestions.
type GoogleCloudDialogflowV2beta1IntentMessageRbmText struct {
	// RbmSuggestion: Optional. One or more suggestions to show to the user.
	RbmSuggestion []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"rbmSuggestion,omitempty"`

	// Text: Required. Text sent and displayed to the user.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RbmSuggestion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RbmSuggestion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageRbmText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo: Additional
// info about the select item for when it is triggered in a dialog.
type GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo struct {
	// Key: Required. A unique key that will be sent back to the agent if
	// this response is given.
	Key string `json:"key,omitempty"`

	// Synonyms: Optional. A list of synonyms that can also be used to
	// trigger this item in dialog.
	Synonyms []string `json:"synonyms,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse: The simple
// response message containing speech or text.
type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse struct {
	// DisplayText: Optional. The text to display.
	DisplayText string `json:"displayText,omitempty"`

	// Ssml: One of text_to_speech or ssml must be provided. Structured
	// spoken response to the user in the SSML format. Mutually exclusive
	// with text_to_speech.
	Ssml string `json:"ssml,omitempty"`

	// TextToSpeech: One of text_to_speech or ssml must be provided. The
	// plain text of the speech output. Mutually exclusive with ssml.
	TextToSpeech string `json:"textToSpeech,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayText") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses: The
// collection of simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses struct {
	// SimpleResponses: Required. The list of simple responses.
	SimpleResponses []*GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SimpleResponses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSuggestion: The suggestion
// chip message that the user can tap to quickly post a reply to the
// conversation.
type GoogleCloudDialogflowV2beta1IntentMessageSuggestion struct {
	// Title: Required. The text shown the in the suggestion chip.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Title") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSuggestions: The collection
// of suggestions.
type GoogleCloudDialogflowV2beta1IntentMessageSuggestions struct {
	// Suggestions: Required. The list of suggested replies.
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageSuggestion `json:"suggestions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Suggestions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCard: Table card for
// Actions on Google.
type GoogleCloudDialogflowV2beta1IntentMessageTableCard struct {
	// Buttons: Optional. List of buttons for the card.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`

	// ColumnProperties: Optional. Display properties for the columns in
	// this table.
	ColumnProperties []*GoogleCloudDialogflowV2beta1IntentMessageColumnProperties `json:"columnProperties,omitempty"`

	// Image: Optional. Image which should be displayed on the card.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`

	// Rows: Optional. Rows in this table of data.
	Rows []*GoogleCloudDialogflowV2beta1IntentMessageTableCardRow `json:"rows,omitempty"`

	// Subtitle: Optional. Subtitle to the title.
	Subtitle string `json:"subtitle,omitempty"`

	// Title: Required. Title of the card.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Buttons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Buttons") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCard
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCardCell: Cell of
// TableCardRow.
type GoogleCloudDialogflowV2beta1IntentMessageTableCardCell struct {
	// Text: Required. Text in this cell.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardCell
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCardRow: Row of
// TableCard.
type GoogleCloudDialogflowV2beta1IntentMessageTableCardRow struct {
	// Cells: Optional. List of cells that make up this row.
	Cells []*GoogleCloudDialogflowV2beta1IntentMessageTableCardCell `json:"cells,omitempty"`

	// DividerAfter: Optional. Whether to add a visual divider after this
	// row.
	DividerAfter bool `json:"dividerAfter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cells") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio: Plays
// audio from a file in Telephony Gateway.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio struct {
	// AudioUri: Required. URI to a Google Cloud Storage object containing
	// the audio to play, e.g., "gs://bucket/object". The object must
	// contain a single channel (mono) of linear PCM audio (2 bytes /
	// sample) at 8kHz. This object must be readable by the
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` service account
	// where is the number of the Telephony Gateway project (usually the
	// same as the Dialogflow agent project). If the Google Cloud Storage
	// bucket is in the Telephony Gateway project, this permission is added
	// by default when enabling the Dialogflow V2 API. For audio from other
	// sources, consider using the `TelephonySynthesizeSpeech` message with
	// SSML.
	AudioUri string `json:"audioUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AudioUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech:
// Synthesizes speech and plays back the synthesized audio to the caller
// in Telephony Gateway. Telephony Gateway takes the synthesizer
// settings from `DetectIntentResponse.output_audio_config` which can
// either be set at request-level or can come from the agent-level
// synthesizer config.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech struct {
	// Ssml: The SSML to be synthesized. For more information, see SSML
	// (https://developers.google.com/actions/reference/ssml).
	Ssml string `json:"ssml,omitempty"`

	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ssml") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ssml") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall:
// Transfers the call in Telephony Gateway.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall struct {
	// PhoneNumber: Required. The phone number to transfer the call to in
	// E.164 format (https://en.wikipedia.org/wiki/E.164). We currently only
	// allow transferring to US numbers (+1xxxyyyzzzz).
	PhoneNumber string `json:"phoneNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageText: The text response
// message.
type GoogleCloudDialogflowV2beta1IntentMessageText struct {
	// Text: Optional. The collection of the agent's responses.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Text") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Text") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentParameter: Represents intent
// parameters.
type GoogleCloudDialogflowV2beta1IntentParameter struct {
	// DefaultValue: Optional. The default value to use when the `value`
	// yields an empty result. Default values can be extracted from contexts
	// by using the following syntax: `#context_name.parameter_name`.
	DefaultValue string `json:"defaultValue,omitempty"`

	// DisplayName: Required. The name of the parameter.
	DisplayName string `json:"displayName,omitempty"`

	// EntityTypeDisplayName: Optional. The name of the entity type,
	// prefixed with `@`, that describes values of the parameter. If the
	// parameter is required, this must be provided.
	EntityTypeDisplayName string `json:"entityTypeDisplayName,omitempty"`

	// IsList: Optional. Indicates whether the parameter represents a list
	// of values.
	IsList bool `json:"isList,omitempty"`

	// Mandatory: Optional. Indicates whether the parameter is required.
	// That is, whether the intent cannot be completed without collecting
	// the parameter value.
	Mandatory bool `json:"mandatory,omitempty"`

	// Name: The unique identifier of this parameter.
	Name string `json:"name,omitempty"`

	// Prompts: Optional. The collection of prompts that the agent can
	// present to the user in order to collect a value for the parameter.
	Prompts []string `json:"prompts,omitempty"`

	// Value: Optional. The definition of the parameter value. It can be: -
	// a constant string, - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	// `#context_name.parameter_name`.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentTrainingPhrase: Represents an
// example that the agent is trained on.
type GoogleCloudDialogflowV2beta1IntentTrainingPhrase struct {
	// Name: Output only. The unique identifier of this training phrase.
	Name string `json:"name,omitempty"`

	// Parts: Required. The ordered list of training phrase parts. The parts
	// are concatenated in order to form the training phrase. Note: The API
	// does not automatically annotate training phrases like the Dialogflow
	// Console does. Note: Do not forget to include whitespace at part
	// boundaries, so the training phrase is well formatted when the parts
	// are concatenated. If the training phrase does not need to be
	// annotated with parameters, you just need a single part with only the
	// Part.text field set. If you want to annotate the training phrase, you
	// must create multiple parts, where the fields of each part are
	// populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the
	// phrase that you want to annotate, and the `entity_type`, `alias`, and
	// `user_defined` fields are all set.
	Parts []*GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart `json:"parts,omitempty"`

	// TimesAddedCount: Optional. Indicates how many times this example was
	// added to the intent. Each time a developer adds an existing sample by
	// editing an intent or training, this counter is increased.
	TimesAddedCount int64 `json:"timesAddedCount,omitempty"`

	// Type: Required. The type of the training phrase.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be
	// used.
	//   "EXAMPLE" - Examples do not contain @-prefixed entity type names,
	// but example parts can be annotated with entity types.
	//   "TEMPLATE" - Templates are not annotated with entity types, but
	// they can contain @-prefixed entity type names as substrings. Template
	// mode has been deprecated. Example mode is the only supported way to
	// create new training phrases. If you have existing training phrases
	// that you've created in template mode, those will continue to work.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrase
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart: Represents a
// part of a training phrase.
type GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart struct {
	// Alias: Optional. The parameter name for the value extracted from the
	// annotated part of the example. This field is required for annotated
	// parts of the training phrase.
	Alias string `json:"alias,omitempty"`

	// EntityType: Optional. The entity type name prefixed with `@`. This
	// field is required for annotated parts of the training phrase.
	EntityType string `json:"entityType,omitempty"`

	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`

	// UserDefined: Optional. Indicates whether the text was manually
	// annotated. This field is set to true when the Dialogflow Console is
	// used to manually annotate the part. When creating an annotated part
	// with the API, you must set this to true.
	UserDefined bool `json:"userDefined,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAnswers: Represents the result
// of querying a Knowledge base.
type GoogleCloudDialogflowV2beta1KnowledgeAnswers struct {
	// Answers: A list of answers from Knowledge Connector.
	Answers []*GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer `json:"answers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Answers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Answers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer: An answer from
// Knowledge Connector.
type GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document
	// that answers this conversational query.
	Answer string `json:"answer,omitempty"`

	// FaqQuestion: The corresponding FAQ question if the answer was
	// extracted from a FAQ Document, empty otherwise.
	FaqQuestion string `json:"faqQuestion,omitempty"`

	// MatchConfidence: The system's confidence score that this Knowledge
	// answer is a good match for this conversational query. The range is
	// from 0.0 (completely uncertain) to 1.0 (completely certain). Note:
	// The confidence score is likely to vary somewhat (possibly even for
	// identical requests), as the underlying model is under constant
	// improvement. It may be deprecated in the future. We recommend using
	// `match_confidence_level` which should be generally more stable.
	MatchConfidence float64 `json:"matchConfidence,omitempty"`

	// MatchConfidenceLevel: The system's confidence level that this
	// knowledge answer is a good match for this conversational query. NOTE:
	// The confidence level for a given `` pair may change without notice,
	// as it depends on models that are constantly being improved. However,
	// it will change less frequently than the confidence score below, and
	// should be preferred for referencing the quality of an answer.
	//
	// Possible values:
	//   "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED" - Not specified.
	//   "LOW" - Indicates that the confidence is low.
	//   "MEDIUM" - Indicates our confidence is medium.
	//   "HIGH" - Indicates our confidence is high.
	MatchConfidenceLevel string `json:"matchConfidenceLevel,omitempty"`

	// Source: Indicates which Knowledge Document this answer was extracted
	// from. Format: `projects//knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Answer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	var s1 struct {
		MatchConfidence gensupport.JSONFloat64 `json:"matchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchConfidence = float64(s1.MatchConfidence)
	return nil
}

// GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata: Metadata in
// google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata struct {
	// KnowledgeBase: The name of the knowledge base interacted with during
	// the operation.
	KnowledgeBase string `json:"knowledgeBase,omitempty"`

	// State: Required. Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KnowledgeBase") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KnowledgeBase") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Message: Represents a message posted into
// a conversation.
type GoogleCloudDialogflowV2beta1Message struct {
	// Content: Required. The message content.
	Content string `json:"content,omitempty"`

	// CreateTime: Output only. The time when the message was created in
	// Contact Center AI.
	CreateTime string `json:"createTime,omitempty"`

	// LanguageCode: Optional. The message language. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`

	// MessageAnnotation: Output only. The annotation for the message.
	MessageAnnotation *GoogleCloudDialogflowV2beta1MessageAnnotation `json:"messageAnnotation,omitempty"`

	// Name: Optional. The unique identifier of the message. Format:
	// `projects//locations//conversations//messages/`.
	Name string `json:"name,omitempty"`

	// Participant: Output only. The participant that sends this message.
	Participant string `json:"participant,omitempty"`

	// ParticipantRole: Output only. The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted
	// with Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`

	// SendTime: Optional. The time when the message was sent.
	SendTime string `json:"sendTime,omitempty"`

	// SentimentAnalysis: Output only. The sentiment analysis result for the
	// message.
	SentimentAnalysis *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Message
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1MessageAnnotation: Represents the result
// of annotation for the message.
type GoogleCloudDialogflowV2beta1MessageAnnotation struct {
	// ContainEntities: Required. Indicates whether the text message
	// contains entities.
	ContainEntities bool `json:"containEntities,omitempty"`

	// Parts: Optional. The collection of annotated message parts ordered by
	// their position in the message. You can recover the annotated message
	// by concatenating [AnnotatedMessagePart.text].
	Parts []*GoogleCloudDialogflowV2beta1AnnotatedMessagePart `json:"parts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainEntities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1MessageAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest: Represents
// the contents of the original request that was passed to the
// `[Streaming]DetectIntent` call.
type GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest struct {
	// Payload: Optional. This field is set to the value of the
	// `QueryParameters.payload` field passed in the request. Some
	// integrations that query a Dialogflow agent may provide additional
	// information in the payload. In particular, for the Dialogflow Phone
	// Gateway integration, this field has the form: { "telephony": {
	// "caller_id": "+18558363987" } } Note: The caller ID field
	// (`caller_id`) will be redacted for Trial Edition agents and populated
	// with the caller ID in E.164 format
	// (https://en.wikipedia.org/wiki/E.164) for Essentials Edition agents.
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// Source: The source of this request, e.g., `google`, `facebook`,
	// `slack`. It is set by Dialogflow-owned servers.
	Source string `json:"source,omitempty"`

	// Version: Optional. The version of the protocol used for this request.
	// This field is AoG-specific.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Payload") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Payload") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1QueryResult: Represents the result of
// conversational query or event processing.
type GoogleCloudDialogflowV2beta1QueryResult struct {
	// Action: The action name from the matched intent.
	Action string `json:"action,omitempty"`

	// AllRequiredParamsPresent: This field is set to: - `false` if the
	// matched intent has required parameters and not all of the required
	// parameter values have been collected. - `true` if all required
	// parameter values have been collected, or if the matched intent
	// doesn't contain any required parameters.
	AllRequiredParamsPresent bool `json:"allRequiredParamsPresent,omitempty"`

	// CancelsSlotFilling: Indicates whether the conversational query
	// triggers a cancellation for slot filling.
	CancelsSlotFilling bool `json:"cancelsSlotFilling,omitempty"`

	// DiagnosticInfo: Free-form diagnostic information for the associated
	// detect intent request. The fields of this data can change without
	// notice, so you should not write code that depends on its structure.
	// The data may contain: - webhook call latency - webhook errors
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`

	// FulfillmentMessages: The collection of rich messages to present to
	// the user.
	FulfillmentMessages []*GoogleCloudDialogflowV2beta1IntentMessage `json:"fulfillmentMessages,omitempty"`

	// FulfillmentText: The text to be pronounced to the user or shown on
	// the screen. Note: This is a legacy field, `fulfillment_messages`
	// should be preferred.
	FulfillmentText string `json:"fulfillmentText,omitempty"`

	// Intent: The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name`, `end_interaction` and `is_fallback`.
	Intent *GoogleCloudDialogflowV2beta1Intent `json:"intent,omitempty"`

	// IntentDetectionConfidence: The intent detection confidence. Values
	// range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help
	// match the best intent within the classification threshold. This value
	// may change for the same end-user expression at any time due to a
	// model retraining or change in implementation. If there are `multiple
	// knowledge_answers` messages, this value is set to the greatest
	// `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`

	// KnowledgeAnswers: The result from Knowledge Connector (if any),
	// ordered by decreasing `KnowledgeAnswers.match_confidence`.
	KnowledgeAnswers *GoogleCloudDialogflowV2beta1KnowledgeAnswers `json:"knowledgeAnswers,omitempty"`

	// LanguageCode: The language that was triggered during intent
	// detection. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a
	// list of the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`

	// OutputContexts: The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name `.original`
	// containing the original parameter values before the query.
	OutputContexts []*GoogleCloudDialogflowV2beta1Context `json:"outputContexts,omitempty"`

	// Parameters: The collection of extracted parameters. Depending on your
	// protocol or client library language, this is a map, associative
	// array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: - MapKey type: string -
	// MapKey value: parameter name - MapValue type: - If parameter's entity
	// type is a composite entity: map - Else: depending on parameter value
	// type, could be one of string, number, boolean, null, list or map -
	// MapValue value: - If parameter's entity type is a composite entity:
	// map from composite entity property names to property values - Else:
	// parameter value
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// QueryText: The original conversational query text: - If natural
	// language text was provided as input, `query_text` contains a copy of
	// the input. - If natural language speech audio was provided as input,
	// `query_text` contains the speech recognition result. If speech
	// recognizer produced multiple alternatives, a particular one is
	// picked. - If automatic spell correction is enabled, `query_text` will
	// contain the corrected user input.
	QueryText string `json:"queryText,omitempty"`

	// SentimentAnalysisResult: The sentiment analysis result, which depends
	// on the `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`

	// SpeechRecognitionConfidence: The Speech recognition confidence
	// between 0.0 and 1.0. A higher number indicates an estimated greater
	// likelihood that the recognized words are correct. The default of 0.0
	// is a sentinel value indicating that confidence was not set. This
	// field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming
	// endpoint has separate confidence estimates per portion of the audio
	// in StreamingRecognitionResult.
	SpeechRecognitionConfidence float64 `json:"speechRecognitionConfidence,omitempty"`

	// WebhookPayload: If the query was fulfilled by a webhook call, this
	// field is set to the value of the `payload` field returned in the
	// webhook response.
	WebhookPayload googleapi.RawMessage `json:"webhookPayload,omitempty"`

	// WebhookSource: If the query was fulfilled by a webhook call, this
	// field is set to the value of the `source` field returned in the
	// webhook response.
	WebhookSource string `json:"webhookSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

// GoogleCloudDialogflowV2beta1Sentiment: The sentiment, such as
// positive/negative feeling or association, for a unit of analysis,
// such as the query text.
type GoogleCloudDialogflowV2beta1Sentiment struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which
	// represents the absolute magnitude of sentiment, regardless of score
	// (positive or negative).
	Magnitude float64 `json:"magnitude,omitempty"`

	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Magnitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowV2beta1SentimentAnalysisResult: The result of
// sentiment analysis. Sentiment analysis inspects user input and
// identifies the prevailing subjective opinion, especially to determine
// a user's attitude as positive, negative, or neutral. For
// Participants.DetectIntent, it needs to be configured in
// DetectIntentRequest.query_params. For
// Participants.StreamingDetectIntent, it needs to be configured in
// StreamingDetectIntentRequest.query_params. And for
// Participants.AnalyzeContent and Participants.StreamingAnalyzeContent,
// it needs to be configured in
// ConversationProfile.human_agent_assistant_config
type GoogleCloudDialogflowV2beta1SentimentAnalysisResult struct {
	// QueryTextSentiment: The sentiment analysis result for `query_text`.
	QueryTextSentiment *GoogleCloudDialogflowV2beta1Sentiment `json:"queryTextSentiment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QueryTextSentiment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SentimentAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1SessionEntityType: A session represents a
// conversation between a Dialogflow agent and an end-user. You can
// create special entities, called session entities, during a session.
// Session entities can extend or replace custom entity types and only
// exist during the session that they were created for. All session
// data, including session entities, is stored by Dialogflow for 20
// minutes. For more information, see the session entity guide
// (https://cloud.google.com/dialogflow/docs/entities-session).
type GoogleCloudDialogflowV2beta1SessionEntityType struct {
	// Entities: Required. The collection of entities associated with this
	// session entity type.
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`

	// EntityOverrideMode: Required. Indicates whether the additional data
	// should override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value
	// should be never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session
	// entities overrides the collection of entities in the corresponding
	// custom entity type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session
	// entities extends the collection of entities in the corresponding
	// custom entity type. Note: Even in this override mode calls to
	// `ListSessionEntityTypes`, `GetSessionEntityType`,
	// `CreateSessionEntityType` and `UpdateSessionEntityType` only return
	// the additional entities added in this session entity type. If you
	// want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`

	// Name: Required. The unique identifier of this session entity type.
	// Supported formats: - `projects//agent/sessions//entityTypes/` -
	// `projects//locations//agent/sessions//entityTypes/` -
	// `projects//agent/environments//users//sessions//entityTypes/` -
	// `projects//locations//agent/environments/
	// /users//sessions//entityTypes/` If `Location ID` is not specified we
	// assume default 'us' location. If `Environment ID` is not specified,
	// we assume default 'draft' environment. If `User ID` is not specified,
	// we assume default '-' user. `` must be the display name of an
	// existing entity type in the same agent that will be overridden or
	// supplemented.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SessionEntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1SmartReplyAnswer: Represents a smart
// reply answer.
type GoogleCloudDialogflowV2beta1SmartReplyAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`

	// Confidence: Smart reply confidence. The system's confidence score
	// that this reply is a good match for this conversation, as a value
	// from 0.0 (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`

	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnswerRecord") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2beta1SuggestArticlesResponse: The response
// message for Participants.SuggestArticles.
type GoogleCloudDialogflowV2beta1SuggestArticlesResponse struct {
	// ArticleAnswers: Output only. Articles ordered by score in descending
	// order.
	ArticleAnswers []*GoogleCloudDialogflowV2beta1ArticleAnswer `json:"articleAnswers,omitempty"`

	// ContextSize: Number of messages prior to and including latest_message
	// to compile the suggestion. It may be smaller than the
	// SuggestArticlesResponse.context_size field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`

	// LatestMessage: The name of the latest conversation message used to
	// compile suggestion for. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArticleAnswers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestArticlesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse: The request
// message for Participants.SuggestFaqAnswers.
type GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse struct {
	// ContextSize: Number of messages prior to and including latest_message
	// to compile the suggestion. It may be smaller than the
	// SuggestFaqAnswersRequest.context_size field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`

	// FaqAnswers: Output only. Answers extracted from FAQ documents.
	FaqAnswers []*GoogleCloudDialogflowV2beta1FaqAnswer `json:"faqAnswers,omitempty"`

	// LatestMessage: The name of the latest conversation message used to
	// compile suggestion for. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContextSize") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse: The response
// message for Participants.SuggestSmartReplies.
type GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse struct {
	// ContextSize: Number of messages prior to and including latest_message
	// to compile the suggestion. It may be smaller than the
	// SuggestSmartRepliesRequest.context_size field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`

	// LatestMessage: The name of the latest conversation message used to
	// compile suggestion for. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// SmartReplyAnswers: Output only. Multiple reply options provided by
	// smart reply service. The order is based on the rank of the model
	// prediction. The maximum number of the returned replies is set in
	// SmartReplyConfig.
	SmartReplyAnswers []*GoogleCloudDialogflowV2beta1SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContextSize") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1SuggestionResult: One response of
// different type of suggestion response which is used in the response
// of Participants.AnalyzeContent and Participants.AnalyzeContent, as
// well as HumanAgentAssistantEvent.
type GoogleCloudDialogflowV2beta1SuggestionResult struct {
	// Error: Error status if the request failed.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// SuggestArticlesResponse: SuggestArticlesResponse if request is for
	// ARTICLE_SUGGESTION.
	SuggestArticlesResponse *GoogleCloudDialogflowV2beta1SuggestArticlesResponse `json:"suggestArticlesResponse,omitempty"`

	// SuggestFaqAnswersResponse: SuggestFaqAnswersResponse if request is
	// for FAQ_ANSWER.
	SuggestFaqAnswersResponse *GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse `json:"suggestFaqAnswersResponse,omitempty"`

	// SuggestSmartRepliesResponse: SuggestSmartRepliesResponse if request
	// is for SMART_REPLY.
	SuggestSmartRepliesResponse *GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse `json:"suggestSmartRepliesResponse,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1WebhookRequest: The request message for a
// webhook call.
type GoogleCloudDialogflowV2beta1WebhookRequest struct {
	// AlternativeQueryResults: Alternative query results from
	// KnowledgeService.
	AlternativeQueryResults []*GoogleCloudDialogflowV2beta1QueryResult `json:"alternativeQueryResults,omitempty"`

	// OriginalDetectIntentRequest: Optional. The contents of the original
	// request that was passed to `[Streaming]DetectIntent` call.
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`

	// QueryResult: The result of the conversational query or event
	// processing. Contains the same value as
	// `[Streaming]DetectIntentResponse.query_result`.
	QueryResult *GoogleCloudDialogflowV2beta1QueryResult `json:"queryResult,omitempty"`

	// ResponseId: The unique identifier of the response. Contains the same
	// value as `[Streaming]DetectIntentResponse.response_id`.
	ResponseId string `json:"responseId,omitempty"`

	// Session: The unique identifier of detectIntent request session. Can
	// be used to identify end-user inside webhook implementation. Supported
	// formats: - `projects//agent/sessions/, -
	// `projects//locations//agent/sessions/`, -
	// `projects//agent/environments//users//sessions/`, -
	// `projects//locations//agent/environments//users//sessions/`,
	Session string `json:"session,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AlternativeQueryResults") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlternativeQueryResults")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1WebhookResponse: The response message for
// a webhook call. This response is validated by the Dialogflow server.
// If validation fails, an error will be returned in the
// QueryResult.diagnostic_info field. Setting JSON fields to an empty
// value with the wrong type is a common error. To avoid this error: -
// Use "" for empty strings - Use `{}` or `null` for empty objects -
// Use `[]` or `null` for empty arrays For more information, see the
// Protocol Buffers Language Guide
// (https://developers.google.com/protocol-buffers/docs/proto3#json).
type GoogleCloudDialogflowV2beta1WebhookResponse struct {
	// EndInteraction: Optional. Indicates that this intent ends an
	// interaction. Some integrations (e.g., Actions on Google or Dialogflow
	// phone gateway) use this information to close interaction with an end
	// user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`

	// FollowupEventInput: Optional. Invokes the supplied events. When this
	// field is set, Dialogflow ignores the `fulfillment_text`,
	// `fulfillment_messages`, and `payload` fields.
	FollowupEventInput *GoogleCloudDialogflowV2beta1EventInput `json:"followupEventInput,omitempty"`

	// FulfillmentMessages: Optional. The rich response messages intended
	// for the end-user. When provided, Dialogflow uses this field to
	// populate QueryResult.fulfillment_messages sent to the integration or
	// API caller.
	FulfillmentMessages []*GoogleCloudDialogflowV2beta1IntentMessage `json:"fulfillmentMessages,omitempty"`

	// FulfillmentText: Optional. The text response message intended for the
	// end-user. It is recommended to use
	// `fulfillment_messages.text.text[0]` instead. When provided,
	// Dialogflow uses this field to populate QueryResult.fulfillment_text
	// sent to the integration or API caller.
	FulfillmentText string `json:"fulfillmentText,omitempty"`

	// LiveAgentHandoff: Indicates that a live agent should be brought in to
	// handle the interaction with the user. In most cases, when you set
	// this flag to true, you would also want to set end_interaction to true
	// as well. Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`

	// OutputContexts: Optional. The collection of output contexts that will
	// overwrite currently active contexts for the session and reset their
	// lifespans. When provided, Dialogflow uses this field to populate
	// QueryResult.output_contexts sent to the integration or API caller.
	OutputContexts []*GoogleCloudDialogflowV2beta1Context `json:"outputContexts,omitempty"`

	// Payload: Optional. This field can be used to pass custom data from
	// your webhook to the integration or API caller. Arbitrary JSON objects
	// are supported. When provided, Dialogflow uses this field to populate
	// QueryResult.webhook_payload sent to the integration or API caller.
	// This field is also used by the Google Assistant integration
	// (https://cloud.google.com/dialogflow/docs/integrations/aog) for rich
	// response messages. See the format definition at Google Assistant
	// Dialogflow webhook format
	// (https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
	Payload googleapi.RawMessage `json:"payload,omitempty"`

	// SessionEntityTypes: Optional. Additional session entity types to
	// replace or extend developer entity types with. The entity synonyms
	// apply to all languages and persist for the session. Setting this data
	// from a webhook overwrites the session entity types that have been set
	// using `detectIntent`, `streamingDetectIntent` or SessionEntityType
	// management methods.
	SessionEntityTypes []*GoogleCloudDialogflowV2beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// Source: Optional. A custom field used to identify the webhook source.
	// Arbitrary strings are supported. When provided, Dialogflow uses this
	// field to populate QueryResult.webhook_source sent to the integration
	// or API caller.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndInteraction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndInteraction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV2beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1CreateDocumentOperationMetadata:
// Metadata for CreateDocument operation.
type GoogleCloudDialogflowV3alpha1CreateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1CreateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1CreateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1DeleteDocumentOperationMetadata:
// Metadata for DeleteDocument operation.
type GoogleCloudDialogflowV3alpha1DeleteDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1DeleteDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1DeleteDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata:
// Metadata in google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata struct {
	// State: Required. Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1ImportDocumentsOperationMetadata:
// Metadata for ImportDocuments operation.
type GoogleCloudDialogflowV3alpha1ImportDocumentsOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1ImportDocumentsOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1ImportDocumentsOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1ImportDocumentsResponse: Response
// message for Documents.ImportDocuments.
type GoogleCloudDialogflowV3alpha1ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other
	// warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Warnings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1ReloadDocumentOperationMetadata:
// Metadata for ReloadDocument operation.
type GoogleCloudDialogflowV3alpha1ReloadDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1ReloadDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1ReloadDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV3alpha1UpdateDocumentOperationMetadata:
// Metadata for UpdateDocument operation.
type GoogleCloudDialogflowV3alpha1UpdateDocumentOperationMetadata struct {
	// GenericMetadata: The generic information of the operation.
	GenericMetadata *GoogleCloudDialogflowV3alpha1GenericKnowledgeOperationMetadata `json:"genericMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenericMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDialogflowV3alpha1UpdateDocumentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1UpdateDocumentOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationListLocationsResponse: The response message for
// Locations.ListLocations.
type GoogleCloudLocationListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents Google Cloud
// Platform location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeLatLng: An object that represents a latitude/longitude
// pair. This is expressed as a pair of doubles to represent degrees
// latitude and degrees longitude. Unless specified otherwise, this
// object must conform to the WGS84 standard. Values must be within
// normalized ranges.
type GoogleTypeLatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0,
	// +90.0].
	Latitude float64 `json:"latitude,omitempty"`

	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Latitude") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLatLng
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeLatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// method id "dialogflow.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.get" call.
// Exactly one of *GoogleCloudLocationLocation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudLocationLocation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
//
// - name: The resource that owns the locations collection, if
//   applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down
// results to a preferred subset. The filtering language accepts strings
// like "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// received from the `next_page_token` field in the response. Send that
// page token to receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.list" call.
// Exactly one of *GoogleCloudLocationListLocationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to narrow down results to a preferred subset. The filtering language accepts strings like \"displayName=tokyo\", and is documented in more detail in [AIP-160](https://google.aip.dev/160).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return. If not set, the service selects a default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}/locations",
	//   "response": {
	//     "$ref": "GoogleCloudLocationListLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dialogflow.projects.locations.agents.create":

type ProjectsLocationsAgentsCreateCall struct {
	s                                   *Service
	parent                              string
	googleclouddialogflowcxv3beta1agent *GoogleCloudDialogflowCxV3beta1Agent
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates an agent in the specified location. Note: You should
// always train a flow prior to sending it queries. See the training
// documentation
// (https://cloud.google.com/dialogflow/cx/docs/concept/training).
//
// - parent: The location to create a agent for. Format:
//   `projects//locations/`.
func (r *ProjectsLocationsAgentsService) Create(parent string, googleclouddialogflowcxv3beta1agent *GoogleCloudDialogflowCxV3beta1Agent) *ProjectsLocationsAgentsCreateCall {
	c := &ProjectsLocationsAgentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3beta1agent = googleclouddialogflowcxv3beta1agent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1agent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.create" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1Agent or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDialogflowCxV3beta1Agent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an agent in the specified location. Note: You should always train a flow prior to sending it queries. See the [training documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The location to create a agent for. Format: `projects//locations/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/agents",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Agent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Agent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.delete":

type ProjectsLocationsAgentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified agent.
//
// - name: The name of the agent to delete. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Delete(name string) *ProjectsLocationsAgentsDeleteCall {
	c := &ProjectsLocationsAgentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified agent.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}",
	//   "httpMethod": "DELETE",
	//   "id": "dialogflow.projects.locations.agents.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the agent to delete. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.export":

type ProjectsLocationsAgentsExportCall struct {
	s                                                *Service
	name                                             string
	googleclouddialogflowcxv3beta1exportagentrequest *GoogleCloudDialogflowCxV3beta1ExportAgentRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Export: Exports the specified agent to a binary file. This method is
// a long-running operation
// (https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
// The returned `Operation` type has the following method-specific
// fields: - `metadata`: An empty Struct message
// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
// - `response`: ExportAgentResponse
//
// - name: The name of the agent to export. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Export(name string, googleclouddialogflowcxv3beta1exportagentrequest *GoogleCloudDialogflowCxV3beta1ExportAgentRequest) *ProjectsLocationsAgentsExportCall {
	c := &ProjectsLocationsAgentsExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3beta1exportagentrequest = googleclouddialogflowcxv3beta1exportagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsExportCall) Context(ctx context.Context) *ProjectsLocationsAgentsExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1exportagentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.export" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Exports the specified agent to a binary file. This method is a [long-running operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation). The returned `Operation` type has the following method-specific fields: - `metadata`: An empty [Struct message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct) - `response`: ExportAgentResponse",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}:export",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.export",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the agent to export. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}:export",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1ExportAgentRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.get":

type ProjectsLocationsAgentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified agent.
//
// - name: The name of the agent. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Get(name string) *ProjectsLocationsAgentsGetCall {
	c := &ProjectsLocationsAgentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.get" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1Agent or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDialogflowCxV3beta1Agent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the specified agent.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the agent. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Agent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.getValidationResult":

type ProjectsLocationsAgentsGetValidationResultCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetValidationResult: Gets the latest agent validation result. Agent
// validation is performed when ValidateAgent is called.
//
// - name: The agent name. Format:
//   `projects//locations//agents//validationResult`.
func (r *ProjectsLocationsAgentsService) GetValidationResult(name string) *ProjectsLocationsAgentsGetValidationResultCall {
	c := &ProjectsLocationsAgentsGetValidationResultCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode": If not
// specified, the agent's default language is used.
func (c *ProjectsLocationsAgentsGetValidationResultCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsGetValidationResultCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsGetValidationResultCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsGetValidationResultCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsGetValidationResultCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Context(ctx context.Context) *ProjectsLocationsAgentsGetValidationResultCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsGetValidationResultCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.getValidationResult" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1AgentValidationResult
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDialogflowCxV3beta1AgentValidationResult.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1AgentValidationResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1AgentValidationResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest agent validation result. Agent validation is performed when ValidateAgent is called.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/validationResult",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.getValidationResult",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "If not specified, the agent's default language is used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The agent name. Format: `projects//locations//agents//validationResult`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+/validationResult$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1AgentValidationResult"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.list":

type ProjectsLocationsAgentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of all agents in the specified location.
//
// - parent: The location to list all agents for. Format:
//   `projects//locations/`.
func (r *ProjectsLocationsAgentsService) List(parent string) *ProjectsLocationsAgentsListCall {
	c := &ProjectsLocationsAgentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of items to return in a single page. By default 100 and at most 1000.
func (c *ProjectsLocationsAgentsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous list request.
func (c *ProjectsLocationsAgentsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.list" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1ListAgentsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDialogflowCxV3beta1ListAgentsResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1ListAgentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1ListAgentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of all agents in the specified location.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of items to return in a single page. By default 100 and at most 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous list request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The location to list all agents for. Format: `projects//locations/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/agents",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1ListAgentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3beta1ListAgentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dialogflow.projects.locations.agents.patch":

type ProjectsLocationsAgentsPatchCall struct {
	s                                   *Service
	nameid                              string
	googleclouddialogflowcxv3beta1agent *GoogleCloudDialogflowCxV3beta1Agent
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates the specified agent. Note: You should always train a
// flow prior to sending it queries. See the training documentation
// (https://cloud.google.com/dialogflow/cx/docs/concept/training).
//
// - name: The unique identifier of the agent. Required for the
//   Agents.UpdateAgent method. Agents.CreateAgent populates the name
//   automatically. Format: `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Patch(nameid string, googleclouddialogflowcxv3beta1agent *GoogleCloudDialogflowCxV3beta1Agent) *ProjectsLocationsAgentsPatchCall {
	c := &ProjectsLocationsAgentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googleclouddialogflowcxv3beta1agent = googleclouddialogflowcxv3beta1agent
	return c
}

// UpdateMask sets the optional parameter "updateMask": The mask to
// control which fields get updated. If the mask is not present, all
// fields will be updated.
func (c *ProjectsLocationsAgentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsPatchCall) Context(ctx context.Context) *ProjectsLocationsAgentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1agent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.patch" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1Agent or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDialogflowCxV3beta1Agent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified agent. Note: You should always train a flow prior to sending it queries. See the [training documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}",
	//   "httpMethod": "PATCH",
	//   "id": "dialogflow.projects.locations.agents.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The unique identifier of the agent. Required for the Agents.UpdateAgent method. Agents.CreateAgent populates the name automatically. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The mask to control which fields get updated. If the mask is not present, all fields will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Agent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Agent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.restore":

type ProjectsLocationsAgentsRestoreCall struct {
	s                                                 *Service
	name                                              string
	googleclouddialogflowcxv3beta1restoreagentrequest *GoogleCloudDialogflowCxV3beta1RestoreAgentRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Restore: Restores the specified agent from a binary file. Replaces
// the current agent with a new one. Note that all existing resources in
// agent (e.g. intents, entity types, flows) will be removed. This
// method is a long-running operation
// (https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
// The returned `Operation` type has the following method-specific
// fields: - `metadata`: An empty Struct message
// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
// - `response`: An Empty message
// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
// Note: You should always train a flow prior to sending it queries. See
// the training documentation
// (https://cloud.google.com/dialogflow/cx/docs/concept/training).
//
// - name: The name of the agent to restore into. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Restore(name string, googleclouddialogflowcxv3beta1restoreagentrequest *GoogleCloudDialogflowCxV3beta1RestoreAgentRequest) *ProjectsLocationsAgentsRestoreCall {
	c := &ProjectsLocationsAgentsRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3beta1restoreagentrequest = googleclouddialogflowcxv3beta1restoreagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsRestoreCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsRestoreCall) Context(ctx context.Context) *ProjectsLocationsAgentsRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1restoreagentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.restore" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsRestoreCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Restores the specified agent from a binary file. Replaces the current agent with a new one. Note that all existing resources in agent (e.g. intents, entity types, flows) will be removed. This method is a [long-running operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation). The returned `Operation` type has the following method-specific fields: - `metadata`: An empty [Struct message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct) - `response`: An [Empty message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty) Note: You should always train a flow prior to sending it queries. See the [training documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}:restore",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.restore",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the agent to restore into. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}:restore",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1RestoreAgentRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.validate":

type ProjectsLocationsAgentsValidateCall struct {
	s                                                  *Service
	name                                               string
	googleclouddialogflowcxv3beta1validateagentrequest *GoogleCloudDialogflowCxV3beta1ValidateAgentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Validate: Validates the specified agent and creates or updates
// validation results. The agent in draft version is validated. Please
// call this API after the training is completed to get the complete
// validation results.
//
// - name: The agent to validate. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsService) Validate(name string, googleclouddialogflowcxv3beta1validateagentrequest *GoogleCloudDialogflowCxV3beta1ValidateAgentRequest) *ProjectsLocationsAgentsValidateCall {
	c := &ProjectsLocationsAgentsValidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3beta1validateagentrequest = googleclouddialogflowcxv3beta1validateagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsValidateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsValidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsValidateCall) Context(ctx context.Context) *ProjectsLocationsAgentsValidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsValidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsValidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1validateagentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}:validate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.validate" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1AgentValidationResult
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDialogflowCxV3beta1AgentValidationResult.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsValidateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1AgentValidationResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1AgentValidationResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates the specified agent and creates or updates validation results. The agent in draft version is validated. Please call this API after the training is completed to get the complete validation results.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}:validate",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.validate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The agent to validate. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}:validate",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1ValidateAgentRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1AgentValidationResult"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.changelogs.get":

type ProjectsLocationsAgentsChangelogsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified Changelog.
//
// - name: The name of the changelog to get. Format:
//   `projects//locations//agents//changelogs/`.
func (r *ProjectsLocationsAgentsChangelogsService) Get(name string) *ProjectsLocationsAgentsChangelogsGetCall {
	c := &ProjectsLocationsAgentsChangelogsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsChangelogsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsChangelogsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsChangelogsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsChangelogsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsChangelogsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.changelogs.get" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1Changelog or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDialogflowCxV3beta1Changelog.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1Changelog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1Changelog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the specified Changelog.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/changelogs/{changelogsId}",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.changelogs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the changelog to get. Format: `projects//locations//agents//changelogs/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+/changelogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Changelog"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.changelogs.list":

type ProjectsLocationsAgentsChangelogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of Changelogs.
//
// - parent: The agent containing the changelogs. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsChangelogsService) List(parent string) *ProjectsLocationsAgentsChangelogsListCall {
	c := &ProjectsLocationsAgentsChangelogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter string.
// Supports filter by user_email, resource, type and create_time. Some
// examples: 1. By user email: user_email = "someone@google.com" 2. By
// resource name: resource =
// "projects/123/locations/global/agents/456/flows/789" 3. By resource
// display name: display_name = "my agent" 4. By action: action =
// "Create" 5. By type: type = "flows" 6. By create time. Currently
// predicates on `create_time` and `create_time_epoch_seconds` are
// supported: create_time_epoch_seconds > 1551790877 AND create_time <=
// 2017-01-15T01:30:15.01Z 7. Combination of above filters: resource =
// "projects/123/locations/global/agents/456/flows/789" AND user_email =
// "someone@google.com" AND create_time <= 2017-01-15T01:30:15.01Z
func (c *ProjectsLocationsAgentsChangelogsListCall) Filter(filter string) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of items to return in a single page. By default 100 and at most 1000.
func (c *ProjectsLocationsAgentsChangelogsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous list request.
func (c *ProjectsLocationsAgentsChangelogsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsChangelogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsChangelogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsChangelogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsChangelogsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsChangelogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsChangelogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsChangelogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/changelogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.changelogs.list" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1ListChangelogsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDialogflowCxV3beta1ListChangelogsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsChangelogsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1ListChangelogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1ListChangelogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of Changelogs.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/changelogs",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.changelogs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The filter string. Supports filter by user_email, resource, type and create_time. Some examples: 1. By user email: user_email = \"someone@google.com\" 2. By resource name: resource = \"projects/123/locations/global/agents/456/flows/789\" 3. By resource display name: display_name = \"my agent\" 4. By action: action = \"Create\" 5. By type: type = \"flows\" 6. By create time. Currently predicates on `create_time` and `create_time_epoch_seconds` are supported: create_time_epoch_seconds \u003e 1551790877 AND create_time \u003c= 2017-01-15T01:30:15.01Z 7. Combination of above filters: resource = \"projects/123/locations/global/agents/456/flows/789\" AND user_email = \"someone@google.com\" AND create_time \u003c= 2017-01-15T01:30:15.01Z",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of items to return in a single page. By default 100 and at most 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous list request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The agent containing the changelogs. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/changelogs",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1ListChangelogsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsChangelogsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3beta1ListChangelogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dialogflow.projects.locations.agents.entityTypes.create":

type ProjectsLocationsAgentsEntityTypesCreateCall struct {
	s                                        *Service
	parent                                   string
	googleclouddialogflowcxv3beta1entitytype *GoogleCloudDialogflowCxV3beta1EntityType
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates an entity type in the specified agent.
//
// - parent: The agent to create a entity type for. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsEntityTypesService) Create(parent string, googleclouddialogflowcxv3beta1entitytype *GoogleCloudDialogflowCxV3beta1EntityType) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c := &ProjectsLocationsAgentsEntityTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3beta1entitytype = googleclouddialogflowcxv3beta1entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// of the following fields in `entity_type`: *
// `EntityType.entities.value` * `EntityType.entities.synonyms` *
// `EntityType.excluded_phrases.value` If not specified, the agent's
// default language is used. Many languages
// (https://cloud.google.com/dialogflow/cx/docs/reference/language) are
// supported. Note: languages must be enabled in the agent before they
// can be used.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1entitytype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.create" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1EntityType or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDialogflowCxV3beta1EntityType.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an entity type in the specified agent.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/entityTypes",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.entityTypes.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The language of the following fields in `entity_type`: * `EntityType.entities.value` * `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value` If not specified, the agent's default language is used. [Many languages](https://cloud.google.com/dialogflow/cx/docs/reference/language) are supported. Note: languages must be enabled in the agent before they can be used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The agent to create a entity type for. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/entityTypes",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1EntityType"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1EntityType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.entityTypes.delete":

type ProjectsLocationsAgentsEntityTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified entity type. Note: You should always
// train a flow prior to sending it queries. See the training
// documentation
// (https://cloud.google.com/dialogflow/cx/docs/concept/training).
//
// - name: The name of the entity type to delete. Format:
//   `projects//locations//agents//entityTypes/`.
func (r *ProjectsLocationsAgentsEntityTypesService) Delete(name string) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c := &ProjectsLocationsAgentsEntityTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": This field has no effect
// for entity type not being used. For entity types that are used by
// intents or pages: * If `force` is set to false, an error will be
// returned with message indicating the referencing resources. * If
// `force` is set to true, Dialogflow will remove the entity type, as
// well as any references to the entity type (i.e. Page parameter of the
// entity type will be changed to '@sys.any' and intent parameter of the
// entity type will be removed).
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Force(force bool) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified entity type. Note: You should always train a flow prior to sending it queries. See the [training documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/entityTypes/{entityTypesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dialogflow.projects.locations.agents.entityTypes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "force": {
	//       "description": "This field has no effect for entity type not being used. For entity types that are used by intents or pages: * If `force` is set to false, an error will be returned with message indicating the referencing resources. * If `force` is set to true, Dialogflow will remove the entity type, as well as any references to the entity type (i.e. Page parameter of the entity type will be changed to '@sys.any' and intent parameter of the entity type will be removed).",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the entity type to delete. Format: `projects//locations//agents//entityTypes/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.entityTypes.get":

type ProjectsLocationsAgentsEntityTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified entity type.
//
// - name: The name of the entity type. Format:
//   `projects//locations//agents//entityTypes/`.
func (r *ProjectsLocationsAgentsEntityTypesService) Get(name string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c := &ProjectsLocationsAgentsEntityTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to retrieve the entity type for. The following fields are language
// dependent: * `EntityType.entities.value` *
// `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value`
// If not specified, the agent's default language is used. Many
// languages
// (https://cloud.google.com/dialogflow/cx/docs/reference/language) are
// supported. Note: languages must be enabled in the agent before they
// can be used.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.get" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1EntityType or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDialogflowCxV3beta1EntityType.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the specified entity type.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/entityTypes/{entityTypesId}",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.entityTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The language to retrieve the entity type for. The following fields are language dependent: * `EntityType.entities.value` * `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value` If not specified, the agent's default language is used. [Many languages](https://cloud.google.com/dialogflow/cx/docs/reference/language) are supported. Note: languages must be enabled in the agent before they can be used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The name of the entity type. Format: `projects//locations//agents//entityTypes/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1EntityType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.entityTypes.list":

type ProjectsLocationsAgentsEntityTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of all entity types in the specified agent.
//
// - parent: The agent to list all entity types for. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsEntityTypesService) List(parent string) *ProjectsLocationsAgentsEntityTypesListCall {
	c := &ProjectsLocationsAgentsEntityTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// to list entity types for. The following fields are language
// dependent: * `EntityType.entities.value` *
// `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value`
// If not specified, the agent's default language is used. Many
// languages
// (https://cloud.google.com/dialogflow/cx/docs/reference/language) are
// supported. Note: languages must be enabled in the agent before they
// can be used.
func (c *ProjectsLocationsAgentsEntityTypesListCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of items to return in a single page. By default 100 and at most 1000.
func (c *ProjectsLocationsAgentsEntityTypesListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous list request.
func (c *ProjectsLocationsAgentsEntityTypesListCall) PageToken(pageToken string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAgentsEntityTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.list" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of all entity types in the specified agent.",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/entityTypes",
	//   "httpMethod": "GET",
	//   "id": "dialogflow.projects.locations.agents.entityTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The language to list entity types for. The following fields are language dependent: * `EntityType.entities.value` * `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value` If not specified, the agent's default language is used. [Many languages](https://cloud.google.com/dialogflow/cx/docs/reference/language) are supported. Note: languages must be enabled in the agent before they can be used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of items to return in a single page. By default 100 and at most 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous list request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The agent to list all entity types for. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/entityTypes",
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dialogflow.projects.locations.agents.entityTypes.patch":

type ProjectsLocationsAgentsEntityTypesPatchCall struct {
	s                                        *Service
	nameid                                   string
	googleclouddialogflowcxv3beta1entitytype *GoogleCloudDialogflowCxV3beta1EntityType
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates the specified entity type. Note: You should always
// train a flow prior to sending it queries. See the training
// documentation
// (https://cloud.google.com/dialogflow/cx/docs/concept/training).
//
// - name: The unique identifier of the entity type. Required for
//   EntityTypes.UpdateEntityType. Format:
//   `projects//locations//agents//entityTypes/`.
func (r *ProjectsLocationsAgentsEntityTypesService) Patch(nameid string, googleclouddialogflowcxv3beta1entitytype *GoogleCloudDialogflowCxV3beta1EntityType) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c := &ProjectsLocationsAgentsEntityTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googleclouddialogflowcxv3beta1entitytype = googleclouddialogflowcxv3beta1entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode": The language
// of the following fields in `entity_type`: *
// `EntityType.entities.value` * `EntityType.entities.synonyms` *
// `EntityType.excluded_phrases.value` If not specified, the agent's
// default language is used. Many languages
// (https://cloud.google.com/dialogflow/cx/docs/reference/language) are
// supported. Note: languages must be enabled in the agent before they
// can be used.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The mask to
// control which fields get updated.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1entitytype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.patch" call.
// Exactly one of *GoogleCloudDialogflowCxV3beta1EntityType or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDialogflowCxV3beta1EntityType.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3beta1EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudDialogflowCxV3beta1EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified entity type. Note: You should always train a flow prior to sending it queries. See the [training documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/entityTypes/{entityTypesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dialogflow.projects.locations.agents.entityTypes.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The language of the following fields in `entity_type`: * `EntityType.entities.value` * `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value` If not specified, the agent's default language is used. [Many languages](https://cloud.google.com/dialogflow/cx/docs/reference/language) are supported. Note: languages must be enabled in the agent before they can be used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The unique identifier of the entity type. Required for EntityTypes.UpdateEntityType. Format: `projects//locations//agents//entityTypes/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The mask to control which fields get updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1EntityType"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1EntityType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.environments.create":

type ProjectsLocationsAgentsEnvironmentsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleclouddialogflowcxv3beta1environment *GoogleCloudDialogflowCxV3beta1Environment
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates an Environment in the specified Agent. This method is
// a long-running operation
// (https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
// The returned `Operation` type has the following method-specific
// fields: - `metadata`: An empty Struct message
// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
// - `response`: Environment
//
// - parent: The Agent to create an Environment for. Format:
//   `projects//locations//agents/`.
func (r *ProjectsLocationsAgentsEnvironmentsService) Create(parent string, googleclouddialogflowcxv3beta1environment *GoogleCloudDialogflowCxV3beta1Environment) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c := &ProjectsLocationsAgentsEnvironmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3beta1environment = googleclouddialogflowcxv3beta1environment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddialogflowcxv3beta1environment)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta1/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Environment in the specified Agent. This method is a [long-running operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation). The returned `Operation` type has the following method-specific fields: - `metadata`: An empty [Struct message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct) - `response`: Environment",
	//   "flatPath": "v3beta1/projects/{projectsId}/locations/{locationsId}/agents/{agentsId}/environments",
	//   "httpMethod": "POST",
	//   "id": "dialogflow.projects.locations.agents.environments.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The Agent to create an Environment for. Format: `projects//locations//agents/`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/agents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v3beta1/{+parent}/environments",
	//   "request": {
	//     "$ref": "GoogleCloudDialogflowCxV3beta1Environment"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/dialogflow"
	//   ]
	// }

}

// method id "dialogflow.projects.locations.agents.environments.delete":

type ProjectsLocationsAgentsEnvironmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Environment.
//
// - name: The name of the Environment to delete. Format:
//   `projects//locations//agents//environments/`.
func (r *ProjectsLocationsAgentsEnvironmentsService) Delete(name string) *ProjectsLocationsAgentsEnvironmentsDeleteCall {
	c := &ProjectsLocationsAgentsEnvironmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provide