// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package securitycenter provides access to the Security Command Center API.
//
// For product documentation, see: https://cloud.google.com/security-command-center
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/securitycenter/v1beta2"
//   ...
//   ctx := context.Background()
//   securitycenterService, err := securitycenter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   securitycenterService, err := securitycenter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   securitycenterService, err := securitycenter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package securitycenter // import "google.golang.org/api/securitycenter/v1beta2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "securitycenter:v1beta2"
const apiName = "securitycenter"
const apiVersion = "v1beta2"
const basePath = "https://securitycenter.googleapis.com/"
const mtlsBasePath = "https://securitycenter.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.ContainerThreatDetectionSettings = NewFoldersContainerThreatDetectionSettingsService(s)
	rs.EventThreatDetectionSettings = NewFoldersEventThreatDetectionSettingsService(s)
	rs.SecurityHealthAnalyticsSettings = NewFoldersSecurityHealthAnalyticsSettingsService(s)
	rs.VirtualMachineThreatDetectionSettings = NewFoldersVirtualMachineThreatDetectionSettingsService(s)
	rs.WebSecurityScannerSettings = NewFoldersWebSecurityScannerSettingsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	ContainerThreatDetectionSettings *FoldersContainerThreatDetectionSettingsService

	EventThreatDetectionSettings *FoldersEventThreatDetectionSettingsService

	SecurityHealthAnalyticsSettings *FoldersSecurityHealthAnalyticsSettingsService

	VirtualMachineThreatDetectionSettings *FoldersVirtualMachineThreatDetectionSettingsService

	WebSecurityScannerSettings *FoldersWebSecurityScannerSettingsService
}

func NewFoldersContainerThreatDetectionSettingsService(s *Service) *FoldersContainerThreatDetectionSettingsService {
	rs := &FoldersContainerThreatDetectionSettingsService{s: s}
	return rs
}

type FoldersContainerThreatDetectionSettingsService struct {
	s *Service
}

func NewFoldersEventThreatDetectionSettingsService(s *Service) *FoldersEventThreatDetectionSettingsService {
	rs := &FoldersEventThreatDetectionSettingsService{s: s}
	return rs
}

type FoldersEventThreatDetectionSettingsService struct {
	s *Service
}

func NewFoldersSecurityHealthAnalyticsSettingsService(s *Service) *FoldersSecurityHealthAnalyticsSettingsService {
	rs := &FoldersSecurityHealthAnalyticsSettingsService{s: s}
	return rs
}

type FoldersSecurityHealthAnalyticsSettingsService struct {
	s *Service
}

func NewFoldersVirtualMachineThreatDetectionSettingsService(s *Service) *FoldersVirtualMachineThreatDetectionSettingsService {
	rs := &FoldersVirtualMachineThreatDetectionSettingsService{s: s}
	return rs
}

type FoldersVirtualMachineThreatDetectionSettingsService struct {
	s *Service
}

func NewFoldersWebSecurityScannerSettingsService(s *Service) *FoldersWebSecurityScannerSettingsService {
	rs := &FoldersWebSecurityScannerSettingsService{s: s}
	return rs
}

type FoldersWebSecurityScannerSettingsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.ContainerThreatDetectionSettings = NewOrganizationsContainerThreatDetectionSettingsService(s)
	rs.EventThreatDetectionSettings = NewOrganizationsEventThreatDetectionSettingsService(s)
	rs.SecurityHealthAnalyticsSettings = NewOrganizationsSecurityHealthAnalyticsSettingsService(s)
	rs.VirtualMachineThreatDetectionSettings = NewOrganizationsVirtualMachineThreatDetectionSettingsService(s)
	rs.WebSecurityScannerSettings = NewOrganizationsWebSecurityScannerSettingsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	ContainerThreatDetectionSettings *OrganizationsContainerThreatDetectionSettingsService

	EventThreatDetectionSettings *OrganizationsEventThreatDetectionSettingsService

	SecurityHealthAnalyticsSettings *OrganizationsSecurityHealthAnalyticsSettingsService

	VirtualMachineThreatDetectionSettings *OrganizationsVirtualMachineThreatDetectionSettingsService

	WebSecurityScannerSettings *OrganizationsWebSecurityScannerSettingsService
}

func NewOrganizationsContainerThreatDetectionSettingsService(s *Service) *OrganizationsContainerThreatDetectionSettingsService {
	rs := &OrganizationsContainerThreatDetectionSettingsService{s: s}
	return rs
}

type OrganizationsContainerThreatDetectionSettingsService struct {
	s *Service
}

func NewOrganizationsEventThreatDetectionSettingsService(s *Service) *OrganizationsEventThreatDetectionSettingsService {
	rs := &OrganizationsEventThreatDetectionSettingsService{s: s}
	return rs
}

type OrganizationsEventThreatDetectionSettingsService struct {
	s *Service
}

func NewOrganizationsSecurityHealthAnalyticsSettingsService(s *Service) *OrganizationsSecurityHealthAnalyticsSettingsService {
	rs := &OrganizationsSecurityHealthAnalyticsSettingsService{s: s}
	return rs
}

type OrganizationsSecurityHealthAnalyticsSettingsService struct {
	s *Service
}

func NewOrganizationsVirtualMachineThreatDetectionSettingsService(s *Service) *OrganizationsVirtualMachineThreatDetectionSettingsService {
	rs := &OrganizationsVirtualMachineThreatDetectionSettingsService{s: s}
	return rs
}

type OrganizationsVirtualMachineThreatDetectionSettingsService struct {
	s *Service
}

func NewOrganizationsWebSecurityScannerSettingsService(s *Service) *OrganizationsWebSecurityScannerSettingsService {
	rs := &OrganizationsWebSecurityScannerSettingsService{s: s}
	return rs
}

type OrganizationsWebSecurityScannerSettingsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.ContainerThreatDetectionSettings = NewProjectsContainerThreatDetectionSettingsService(s)
	rs.EventThreatDetectionSettings = NewProjectsEventThreatDetectionSettingsService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.SecurityHealthAnalyticsSettings = NewProjectsSecurityHealthAnalyticsSettingsService(s)
	rs.VirtualMachineThreatDetectionSettings = NewProjectsVirtualMachineThreatDetectionSettingsService(s)
	rs.WebSecurityScannerSettings = NewProjectsWebSecurityScannerSettingsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	ContainerThreatDetectionSettings *ProjectsContainerThreatDetectionSettingsService

	EventThreatDetectionSettings *ProjectsEventThreatDetectionSettingsService

	Locations *ProjectsLocationsService

	SecurityHealthAnalyticsSettings *ProjectsSecurityHealthAnalyticsSettingsService

	VirtualMachineThreatDetectionSettings *ProjectsVirtualMachineThreatDetectionSettingsService

	WebSecurityScannerSettings *ProjectsWebSecurityScannerSettingsService
}

func NewProjectsContainerThreatDetectionSettingsService(s *Service) *ProjectsContainerThreatDetectionSettingsService {
	rs := &ProjectsContainerThreatDetectionSettingsService{s: s}
	return rs
}

type ProjectsContainerThreatDetectionSettingsService struct {
	s *Service
}

func NewProjectsEventThreatDetectionSettingsService(s *Service) *ProjectsEventThreatDetectionSettingsService {
	rs := &ProjectsEventThreatDetectionSettingsService{s: s}
	return rs
}

type ProjectsEventThreatDetectionSettingsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Clusters = NewProjectsLocationsClustersService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Clusters *ProjectsLocationsClustersService
}

func NewProjectsLocationsClustersService(s *Service) *ProjectsLocationsClustersService {
	rs := &ProjectsLocationsClustersService{s: s}
	rs.ContainerThreatDetectionSettings = NewProjectsLocationsClustersContainerThreatDetectionSettingsService(s)
	return rs
}

type ProjectsLocationsClustersService struct {
	s *Service

	ContainerThreatDetectionSettings *ProjectsLocationsClustersContainerThreatDetectionSettingsService
}

func NewProjectsLocationsClustersContainerThreatDetectionSettingsService(s *Service) *ProjectsLocationsClustersContainerThreatDetectionSettingsService {
	rs := &ProjectsLocationsClustersContainerThreatDetectionSettingsService{s: s}
	return rs
}

type ProjectsLocationsClustersContainerThreatDetectionSettingsService struct {
	s *Service
}

func NewProjectsSecurityHealthAnalyticsSettingsService(s *Service) *ProjectsSecurityHealthAnalyticsSettingsService {
	rs := &ProjectsSecurityHealthAnalyticsSettingsService{s: s}
	return rs
}

type ProjectsSecurityHealthAnalyticsSettingsService struct {
	s *Service
}

func NewProjectsVirtualMachineThreatDetectionSettingsService(s *Service) *ProjectsVirtualMachineThreatDetectionSettingsService {
	rs := &ProjectsVirtualMachineThreatDetectionSettingsService{s: s}
	return rs
}

type ProjectsVirtualMachineThreatDetectionSettingsService struct {
	s *Service
}

func NewProjectsWebSecurityScannerSettingsService(s *Service) *ProjectsWebSecurityScannerSettingsService {
	rs := &ProjectsWebSecurityScannerSettingsService{s: s}
	return rs
}

type ProjectsWebSecurityScannerSettingsService struct {
	s *Service
}

// Access: Represents an access event.
type Access struct {
	// CallerIp: Caller's IP address, such as "1.1.1.1".
	CallerIp string `json:"callerIp,omitempty"`

	// CallerIpGeo: The caller IP's geolocation, which identifies where the
	// call came from.
	CallerIpGeo *Geolocation `json:"callerIpGeo,omitempty"`

	// MethodName: The method that the service account called, e.g.
	// "SetIamPolicy".
	MethodName string `json:"methodName,omitempty"`

	// PrincipalEmail: Associated email, such as "foo@google.com".
	PrincipalEmail string `json:"principalEmail,omitempty"`

	// ServiceName: This is the API service that the service account made a
	// call to, e.g. "iam.googleapis.com"
	ServiceName string `json:"serviceName,omitempty"`

	// UserAgentFamily: What kind of user agent is associated, e.g.
	// operating system shells, embedded or stand-alone applications, etc.
	UserAgentFamily string `json:"userAgentFamily,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallerIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallerIp") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Access) MarshalJSON() ([]byte, error) {
	type NoMethod Access
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Config: Configuration of a module.
type Config struct {
	// ModuleEnablementState: The state of enablement for the module at its
	// level of the resource hierarchy.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ModuleEnablementState string `json:"moduleEnablementState,omitempty"`

	// Value: The configuration value for the module. The absence of this
	// field implies its inheritance from the parent.
	Value googleapi.RawMessage `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ModuleEnablementState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ModuleEnablementState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Config) MarshalJSON() ([]byte, error) {
	type NoMethod Config
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContainerThreatDetectionSettings: Resource capturing the settings for
// the Container Threat Detection service.
type ContainerThreatDetectionSettings struct {
	// Modules: The configurations including the state of enablement for the
	// service's different modules. The absence of a module in the map
	// implies its configuration is inherited from its parent's.
	Modules map[string]Config `json:"modules,omitempty"`

	// Name: The resource name of the ContainerThreatDetectionSettings.
	// Formats: *
	// organizations/{organization}/containerThreatDetectionSettings *
	// folders/{folder}/containerThreatDetectionSettings *
	// projects/{project}/containerThreatDetectionSettings *
	// projects/{project}/locations/{location}/clusters/{cluster}/containerTh
	// reatDetectionSettings
	Name string `json:"name,omitempty"`

	// ServiceAccount: Output only. The service account used by Container
	// Threat Detection for scanning. Service accounts are scoped at the
	// project level meaning this field will be empty at any level above a
	// project.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ServiceEnablementState: The state of enablement for the service at
	// its level of the resource hierarchy. A DISABLED state will override
	// all module enablement_states to DISABLED.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ServiceEnablementState string `json:"serviceEnablementState,omitempty"`

	// UpdateTime: Output only. The time the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Modules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Modules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContainerThreatDetectionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerThreatDetectionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cve: CVE stands for Common Vulnerabilities and Exposures. More
// information: https://cve.mitre.org
type Cve struct {
	// Cvssv3: Describe Common Vulnerability Scoring System specified at
	// https://www.first.org/cvss/v3.1/specification-document
	Cvssv3 *Cvssv3 `json:"cvssv3,omitempty"`

	// Id: The unique identifier for the vulnerability. e.g. CVE-2021-34527
	Id string `json:"id,omitempty"`

	// References: Additional information about the CVE. e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
	References []*Reference `json:"references,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cvssv3") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cvssv3") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Cve) MarshalJSON() ([]byte, error) {
	type NoMethod Cve
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cvssv3: Common Vulnerability Scoring System version 3.
type Cvssv3 struct {
	// AttackComplexity: This metric describes the conditions beyond the
	// attacker's control that must exist in order to exploit the
	// vulnerability.
	//
	// Possible values:
	//   "ATTACK_COMPLEXITY_UNSPECIFIED" - Invalid value.
	//   "ATTACK_COMPLEXITY_LOW" - Specialized access conditions or
	// extenuating circumstances do not exist. An attacker can expect
	// repeatable success when attacking the vulnerable component.
	//   "ATTACK_COMPLEXITY_HIGH" - A successful attack depends on
	// conditions beyond the attacker's control. That is, a successful
	// attack cannot be accomplished at will, but requires the attacker to
	// invest in some measurable amount of effort in preparation or
	// execution against the vulnerable component before a successful attack
	// can be expected.
	AttackComplexity string `json:"attackComplexity,omitempty"`

	// AttackVector: Base Metrics Represents the intrinsic characteristics
	// of a vulnerability that are constant over time and across user
	// environments. This metric reflects the context by which vulnerability
	// exploitation is possible.
	//
	// Possible values:
	//   "ATTACK_VECTOR_UNSPECIFIED" - Invalid value.
	//   "ATTACK_VECTOR_NETWORK" - The vulnerable component is bound to the
	// network stack and the set of possible attackers extends beyond the
	// other options listed below, up to and including the entire Internet.
	//   "ATTACK_VECTOR_ADJACENT" - The vulnerable component is bound to the
	// network stack, but the attack is limited at the protocol level to a
	// logically adjacent topology.
	//   "ATTACK_VECTOR_LOCAL" - The vulnerable component is not bound to
	// the network stack and the attacker's path is via read/write/execute
	// capabilities.
	//   "ATTACK_VECTOR_PHYSICAL" - The attack requires the attacker to
	// physically touch or manipulate the vulnerable component.
	AttackVector string `json:"attackVector,omitempty"`

	// AvailabilityImpact: This metric measures the impact to the
	// availability of the impacted component resulting from a successfully
	// exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	AvailabilityImpact string `json:"availabilityImpact,omitempty"`

	// BaseScore: The base score is a function of the base metric scores.
	BaseScore float64 `json:"baseScore,omitempty"`

	// ConfidentialityImpact: This metric measures the impact to the
	// confidentiality of the information resources managed by a software
	// component due to a successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	ConfidentialityImpact string `json:"confidentialityImpact,omitempty"`

	// IntegrityImpact: This metric measures the impact to integrity of a
	// successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	IntegrityImpact string `json:"integrityImpact,omitempty"`

	// PrivilegesRequired: This metric describes the level of privileges an
	// attacker must possess before successfully exploiting the
	// vulnerability.
	//
	// Possible values:
	//   "PRIVILEGES_REQUIRED_UNSPECIFIED" - Invalid value.
	//   "PRIVILEGES_REQUIRED_NONE" - The attacker is unauthorized prior to
	// attack, and therefore does not require any access to settings or
	// files of the vulnerable system to carry out an attack.
	//   "PRIVILEGES_REQUIRED_LOW" - The attacker requires privileges that
	// provide basic user capabilities that could normally affect only
	// settings and files owned by a user. Alternatively, an attacker with
	// Low privileges has the ability to access only non-sensitive
	// resources.
	//   "PRIVILEGES_REQUIRED_HIGH" - The attacker requires privileges that
	// provide significant (e.g., administrative) control over the
	// vulnerable component allowing access to component-wide settings and
	// files.
	PrivilegesRequired string `json:"privilegesRequired,omitempty"`

	// Scope: The Scope metric captures whether a vulnerability in one
	// vulnerable component impacts resources in components beyond its
	// security scope.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Invalid value.
	//   "SCOPE_UNCHANGED" - An exploited vulnerability can only affect
	// resources managed by the same security authority.
	//   "SCOPE_CHANGED" - An exploited vulnerability can affect resources
	// beyond the security scope managed by the security authority of the
	// vulnerable component.
	Scope string `json:"scope,omitempty"`

	// UserInteraction: This metric captures the requirement for a human
	// user, other than the attacker, to participate in the successful
	// compromise of the vulnerable component.
	//
	// Possible values:
	//   "USER_INTERACTION_UNSPECIFIED" - Invalid value.
	//   "USER_INTERACTION_NONE" - The vulnerable system can be exploited
	// without interaction from any user.
	//   "USER_INTERACTION_REQUIRED" - Successful exploitation of this
	// vulnerability requires a user to take some action before the
	// vulnerability can be exploited.
	UserInteraction string `json:"userInteraction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttackComplexity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttackComplexity") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Cvssv3) MarshalJSON() ([]byte, error) {
	type NoMethod Cvssv3
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Cvssv3) UnmarshalJSON(data []byte) error {
	type NoMethod Cvssv3
	var s1 struct {
		BaseScore gensupport.JSONFloat64 `json:"baseScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BaseScore = float64(s1.BaseScore)
	return nil
}

// Details: Details of a subscription.
type Details struct {
	// EndTime: The time the subscription has or will end.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: The time the subscription has or will start.
	StartTime string `json:"startTime,omitempty"`

	// Type: The type of subscription
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - The standard subscription.
	//   "TRIAL" - The trial subscription.
	//   "ALPHA" - The alpha subscription.
	//   "DEMO" - The demo subscription for channel partners.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Details) MarshalJSON() ([]byte, error) {
	type NoMethod Details
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EventThreatDetectionSettings: Resource capturing the settings for the
// Event Threat Detection service.
type EventThreatDetectionSettings struct {
	// Modules: The configurations including the state of enablement for the
	// service's different modules. The absence of a module in the map
	// implies its configuration is inherited from its parent's.
	Modules map[string]Config `json:"modules,omitempty"`

	// Name: The resource name of the EventThreatDetectionSettings. Formats:
	// * organizations/{organization}/eventThreatDetectionSettings *
	// folders/{folder}/eventThreatDetectionSettings *
	// projects/{project}/eventThreatDetectionSettings
	Name string `json:"name,omitempty"`

	// ServiceEnablementState: The state of enablement for the service at
	// its level of the resource hierarchy. A DISABLED state will override
	// all module enablement_states to DISABLED.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ServiceEnablementState string `json:"serviceEnablementState,omitempty"`

	// UpdateTime: Output only. The time the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Modules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Modules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EventThreatDetectionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod EventThreatDetectionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Finding: Security Command Center finding. A finding is a record of
// assessment data like security, risk, health, or privacy, that is
// ingested into Security Command Center for presentation, notification,
// analysis, policy testing, and enforcement. For example, a cross-site
// scripting (XSS) vulnerability in an App Engine application is a
// finding.
type Finding struct {
	// Access: Access details associated to the Finding, such as more
	// information on the caller, which method was accessed, from where,
	// etc.
	Access *Access `json:"access,omitempty"`

	// CanonicalName: The canonical name of the finding. It's either
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
	//  depending on the closest CRM ancestor of the resource associated
	// with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Category: The additional taxonomy group within findings from a given
	// source. This field is immutable after creation time. Example:
	// "XSS_FLASH_INJECTION"
	Category string `json:"category,omitempty"`

	// CreateTime: The time at which the finding was created in Security
	// Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// EventTime: The time at which the event took place, or when an update
	// to the finding occurred. For example, if the finding represents an
	// open firewall it would capture the time the detector believes the
	// firewall became open. The accuracy is determined by the detector. If
	// the finding were to be resolved afterward, this time would reflect
	// when the finding was resolved. Must not be set to a value greater
	// than the current timestamp.
	EventTime string `json:"eventTime,omitempty"`

	// ExternalSystems: Output only. Third party SIEM/SOAR fields within
	// SCC, contains external system information and external system finding
	// fields.
	ExternalSystems map[string]GoogleCloudSecuritycenterV1ExternalSystem `json:"externalSystems,omitempty"`

	// ExternalUri: The URI that, if available, points to a web page outside
	// of Security Command Center where additional information about the
	// finding can be found. This field is guaranteed to be either empty or
	// a well formed URL.
	ExternalUri string `json:"externalUri,omitempty"`

	// FindingClass: The class of the finding.
	//
	// Possible values:
	//   "FINDING_CLASS_UNSPECIFIED" - Unspecified finding class.
	//   "THREAT" - Describes unwanted or malicious activity.
	//   "VULNERABILITY" - Describes a potential weakness in software that
	// increases risk to Confidentiality & Integrity & Availability.
	//   "MISCONFIGURATION" - Describes a potential weakness in cloud
	// resource/asset configuration that increases risk.
	//   "OBSERVATION" - Describes a security observation that is for
	// informational purposes.
	//   "SCC_ERROR" - Describes an error that prevents some SCC
	// functionality.
	FindingClass string `json:"findingClass,omitempty"`

	// Indicator: Represents what's commonly known as an Indicator of
	// compromise (IoC) in computer forensics. This is an artifact observed
	// on a network or in an operating system that, with high confidence,
	// indicates a computer intrusion. Reference:
	// https://en.wikipedia.org/wiki/Indicator_of_compromise
	Indicator *Indicator `json:"indicator,omitempty"`

	// MitreAttack: MITRE ATT&CK tactics and techniques related to this
	// finding. See: https://attack.mitre.org
	MitreAttack *MitreAttack `json:"mitreAttack,omitempty"`

	// Mute: Indicates the mute state of a finding (either unspecified,
	// muted, unmuted or undefined).
	//
	// Possible values:
	//   "MUTE_UNSPECIFIED" - Unspecified.
	//   "MUTED" - Finding has been muted.
	//   "UNMUTED" - Finding has been unmuted.
	//   "UNDEFINED" - Finding has never been muted/unmuted.
	Mute string `json:"mute,omitempty"`

	// MuteInitiator: First known as mute_annotation. Records additional
	// information about the mute operation e.g. mute config that muted the
	// finding, user who muted the finding, etc.
	MuteInitiator string `json:"muteInitiator,omitempty"`

	// MuteUpdateTime: Output only. The most recent time this finding was
	// muted or unmuted.
	MuteUpdateTime string `json:"muteUpdateTime,omitempty"`

	// Name: The relative resource name of this finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}"
	Name string `json:"name,omitempty"`

	// Parent: The relative resource name of the source the finding belongs
	// to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `json:"parent,omitempty"`

	// ResourceName: For findings on Google Cloud resources, the full
	// resource name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName
	// can be a customer or partner defined string. This field is immutable
	// after creation time.
	ResourceName string `json:"resourceName,omitempty"`

	// SecurityMarks: Output only. User specified security marks. These
	// marks are entirely managed by the user and come from the
	// SecurityMarks resource that belongs to the finding.
	SecurityMarks *SecurityMarks `json:"securityMarks,omitempty"`

	// Severity: The severity of the finding. This field is managed by the
	// source that writes the finding.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - This value is used for findings when a
	// source doesn't write a severity value.
	//   "CRITICAL" - Vulnerability: A critical vulnerability is easily
	// discoverable by an external actor, exploitable, and results in the
	// direct ability to execute arbitrary code, exfiltrate data, and
	// otherwise gain additional access and privileges to cloud resources
	// and workloads. Examples include publicly accessible unprotected user
	// data, public SSH access with weak or no passwords, etc. Threat:
	// Indicates a threat that is able to access, modify, or delete data or
	// execute unauthorized code within existing resources.
	//   "HIGH" - Vulnerability: A high risk vulnerability can be easily
	// discovered and exploited in combination with other vulnerabilities in
	// order to gain direct access and the ability to execute arbitrary
	// code, exfiltrate data, and otherwise gain additional access and
	// privileges to cloud resources and workloads. An example is a database
	// with weak or no passwords that is only accessible internally. This
	// database could easily be compromised by an actor that had access to
	// the internal network. Threat: Indicates a threat that is able to
	// create new computational resources in an environment but not able to
	// access data or execute code in existing resources.
	//   "MEDIUM" - Vulnerability: A medium risk vulnerability could be used
	// by an actor to gain access to resources or privileges that enable
	// them to eventually (through multiple steps or a complex exploit) gain
	// access and the ability to execute arbitrary code or exfiltrate data.
	// An example is a service account with access to more projects than it
	// should have. If an actor gains access to the service account, they
	// could potentially use that access to manipulate a project the service
	// account was not intended to. Threat: Indicates a threat that is able
	// to cause operational impact but may not access data or execute
	// unauthorized code.
	//   "LOW" - Vulnerability: A low risk vulnerability hampers a security
	// organization’s ability to detect vulnerabilities or active threats
	// in their deployment, or prevents the root cause investigation of
	// security issues. An example is monitoring and logs being disabled for
	// resource configurations and access. Threat: Indicates a threat that
	// has obtained minimal access to an environment but is not able to
	// access data, execute code, or create resources.
	Severity string `json:"severity,omitempty"`

	// SourceProperties: Source specific properties. These properties are
	// managed by the source that writes the finding. The key names in the
	// source_properties map must be between 1 and 255 characters, and must
	// start with a letter and contain alphanumeric characters or
	// underscores only.
	SourceProperties googleapi.RawMessage `json:"sourceProperties,omitempty"`

	// State: The state of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// Vulnerability: Represents vulnerability specific fields like cve,
	// cvss scores etc. CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Vulnerability *Vulnerability `json:"vulnerability,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Finding) MarshalJSON() ([]byte, error) {
	type NoMethod Finding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Folder: Message that contains the resource name and display name of a
// folder resource.
type Folder struct {
	// ResourceFolder: Full resource name of this folder. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceFolder string `json:"resourceFolder,omitempty"`

	// ResourceFolderDisplayName: The user defined display name for this
	// folder.
	ResourceFolderDisplayName string `json:"resourceFolderDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceFolder") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFolder") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Folder) MarshalJSON() ([]byte, error) {
	type NoMethod Folder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Geolocation: Represents a geographical location for a given access.
type Geolocation struct {
	// RegionCode: A CLDR.
	RegionCode string `json:"regionCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegionCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Geolocation) MarshalJSON() ([]byte, error) {
	type NoMethod Geolocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1BulkMuteFindingsResponse: The response to
// a BulkMute request. Contains the LRO information.
type GoogleCloudSecuritycenterV1BulkMuteFindingsResponse struct {
}

// GoogleCloudSecuritycenterV1ExternalSystem: Representation of third
// party SIEM/SOAR fields within SCC.
type GoogleCloudSecuritycenterV1ExternalSystem struct {
	// Assignees: References primary/secondary etc assignees in the external
	// system.
	Assignees []string `json:"assignees,omitempty"`

	// ExternalSystemUpdateTime: The most recent time when the corresponding
	// finding's ticket/tracker was updated in the external system.
	ExternalSystemUpdateTime string `json:"externalSystemUpdateTime,omitempty"`

	// ExternalUid: Identifier that's used to track the given finding in the
	// external system.
	ExternalUid string `json:"externalUid,omitempty"`

	// Name: External System Name e.g. jira, demisto, etc. e.g.:
	// organizations/1234/sources/5678/findings/123456/externalSystems/jira
	// folders/1234/sources/5678/findings/123456/externalSystems/jira
	// projects/1234/sources/5678/findings/123456/externalSystems/jira
	Name string `json:"name,omitempty"`

	// Status: Most recent status of the corresponding finding's
	// ticket/tracker in the external system.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignees") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignees") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1ExternalSystem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1ExternalSystem
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1MuteConfig: A mute config is a Cloud SCC
// resource that contains the configuration to mute create/update events
// of findings.
type GoogleCloudSecuritycenterV1MuteConfig struct {
	// CreateTime: Output only. The time at which the mute config was
	// created. This field is set by the server and will be ignored if
	// provided on config creation.
	CreateTime string `json:"createTime,omitempty"`

	// Description: A description of the mute config.
	Description string `json:"description,omitempty"`

	// DisplayName: The human readable name to be displayed for the mute
	// config.
	DisplayName string `json:"displayName,omitempty"`

	// Filter: Required. An expression that defines the filter to apply
	// across create/update events of findings. While creating a filter
	// string, be mindful of the scope in which the mute configuration is
	// being created. E.g., If a filter contains project = X but is created
	// under the project = Y scope, it might not match any findings. The
	// following field and operator combinations are supported: * severity:
	// `=`, `:` * category: `=`, `:` * resource.name: `=`, `:` *
	// resource.project_name: `=`, `:` * resource.project_display_name: `=`,
	// `:` * resource.folders.resource_folder: `=`, `:` *
	// resource.parent_name: `=`, `:` * resource.parent_display_name: `=`,
	// `:` * resource.type: `=`, `:` * finding_class: `=`, `:` *
	// indicator.ip_addresses: `=`, `:` * indicator.domains: `=`, `:`
	Filter string `json:"filter,omitempty"`

	// MostRecentEditor: Output only. Email address of the user who last
	// edited the mute config. This field is set by the server and will be
	// ignored if provided on config creation or update.
	MostRecentEditor string `json:"mostRecentEditor,omitempty"`

	// Name: This field will be ignored if provided on config creation.
	// Format "organizations/{organization}/muteConfigs/{mute_config}"
	// "folders/{folder}/muteConfigs/{mute_config}"
	// "projects/{project}/muteConfigs/{mute_config}"
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The most recent time at which the mute
	// config was updated. This field is set by the server and will be
	// ignored if provided on config creation or update.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1MuteConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1MuteConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1NotificationMessage: Cloud SCC's
// Notification
type GoogleCloudSecuritycenterV1NotificationMessage struct {
	// Finding: If it's a Finding based notification config, this field will
	// be populated.
	Finding *Finding `json:"finding,omitempty"`

	// NotificationConfigName: Name of the notification config that
	// generated current notification.
	NotificationConfigName string `json:"notificationConfigName,omitempty"`

	// Resource: The Cloud resource tied to this notification's Finding.
	Resource *GoogleCloudSecuritycenterV1Resource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1NotificationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1NotificationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1Resource: Information related to the
// Google Cloud resource.
type GoogleCloudSecuritycenterV1Resource struct {
	// DisplayName: The human readable name of the resource.
	DisplayName string `json:"displayName,omitempty"`

	// Folders: Output only. Contains a Folder message for each folder in
	// the assets ancestry. The first folder is the deepest nested folder,
	// and the last folder is the folder directly under the Organization.
	Folders []*Folder `json:"folders,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// Parent: The full resource name of resource's parent.
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: The human readable name of resource's parent.
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Project: The full resource name of project that the resource belongs
	// to.
	Project string `json:"project,omitempty"`

	// ProjectDisplayName: The human readable name of project that the
	// resource belongs to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// Type: The full resource type of the resource.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse: Response of
// asset discovery run
type GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse: Response
// of asset discovery run
type GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Finding: Security Command Center
// finding. A finding is a record of assessment data (security, risk,
// health or privacy) ingested into Security Command Center for
// presentation, notification, analysis, policy testing, and
// enforcement. For example, an XSS vulnerability in an App Engine
// application is a finding.
type GoogleCloudSecuritycenterV1p1beta1Finding struct {
	// CanonicalName: The canonical name of the finding. It's either
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
	//  depending on the closest CRM ancestor of the resource associated
	// with the finding.
	CanonicalName string `json:"canonicalName,omitempty"`

	// Category: The additional taxonomy group within findings from a given
	// source. This field is immutable after creation time. Example:
	// "XSS_FLASH_INJECTION"
	Category string `json:"category,omitempty"`

	// CreateTime: The time at which the finding was created in Security
	// Command Center.
	CreateTime string `json:"createTime,omitempty"`

	// EventTime: The time at which the event took place, or when an update
	// to the finding occurred. For example, if the finding represents an
	// open firewall it would capture the time the detector believes the
	// firewall became open. The accuracy is determined by the detector. If
	// the finding were to be resolved afterward, this time would reflect
	// when the finding was resolved. Must not be set to a value greater
	// than the current timestamp.
	EventTime string `json:"eventTime,omitempty"`

	// ExternalUri: The URI that, if available, points to a web page outside
	// of Security Command Center where additional information about the
	// finding can be found. This field is guaranteed to be either empty or
	// a well formed URL.
	ExternalUri string `json:"externalUri,omitempty"`

	// Name: The relative resource name of this finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}"
	Name string `json:"name,omitempty"`

	// Parent: The relative resource name of the source the finding belongs
	// to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time. For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `json:"parent,omitempty"`

	// ResourceName: For findings on Google Cloud resources, the full
	// resource name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName
	// can be a customer or partner defined string. This field is immutable
	// after creation time.
	ResourceName string `json:"resourceName,omitempty"`

	// SecurityMarks: Output only. User specified security marks. These
	// marks are entirely managed by the user and come from the
	// SecurityMarks resource that belongs to the finding.
	SecurityMarks *GoogleCloudSecuritycenterV1p1beta1SecurityMarks `json:"securityMarks,omitempty"`

	// Severity: The severity of the finding. This field is managed by the
	// source that writes the finding.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - No severity specified. The default value.
	//   "CRITICAL" - Critical severity.
	//   "HIGH" - High severity.
	//   "MEDIUM" - Medium severity.
	//   "LOW" - Low severity.
	Severity string `json:"severity,omitempty"`

	// SourceProperties: Source specific properties. These properties are
	// managed by the source that writes the finding. The key names in the
	// source_properties map must be between 1 and 255 characters, and must
	// start with a letter and contain alphanumeric characters or
	// underscores only.
	SourceProperties googleapi.RawMessage `json:"sourceProperties,omitempty"`

	// State: The state of the finding.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - The finding requires attention and has not been
	// addressed yet.
	//   "INACTIVE" - The finding has been fixed, triaged as a non-issue or
	// otherwise addressed and is no longer active.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Finding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Finding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Folder: Message that contains the
// resource name and display name of a folder resource.
type GoogleCloudSecuritycenterV1p1beta1Folder struct {
	// ResourceFolder: Full resource name of this folder. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceFolder string `json:"resourceFolder,omitempty"`

	// ResourceFolderDisplayName: The user defined display name for this
	// folder.
	ResourceFolderDisplayName string `json:"resourceFolderDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceFolder") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFolder") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Folder) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Folder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1NotificationMessage: Security
// Command Center's Notification
type GoogleCloudSecuritycenterV1p1beta1NotificationMessage struct {
	// Finding: If it's a Finding based notification config, this field will
	// be populated.
	Finding *GoogleCloudSecuritycenterV1p1beta1Finding `json:"finding,omitempty"`

	// NotificationConfigName: Name of the notification config that
	// generated current notification.
	NotificationConfigName string `json:"notificationConfigName,omitempty"`

	// Resource: The Cloud resource tied to the notification.
	Resource *GoogleCloudSecuritycenterV1p1beta1Resource `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Finding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Finding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1NotificationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1NotificationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1Resource: Information related to
// the Google Cloud resource.
type GoogleCloudSecuritycenterV1p1beta1Resource struct {
	// Folders: Output only. Contains a Folder message for each folder in
	// the assets ancestry. The first folder is the deepest nested folder,
	// and the last folder is the folder directly under the Organization.
	Folders []*GoogleCloudSecuritycenterV1p1beta1Folder `json:"folders,omitempty"`

	// Name: The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `json:"name,omitempty"`

	// Parent: The full resource name of resource's parent.
	Parent string `json:"parent,omitempty"`

	// ParentDisplayName: The human readable name of resource's parent.
	ParentDisplayName string `json:"parentDisplayName,omitempty"`

	// Project: The full resource name of project that the resource belongs
	// to.
	Project string `json:"project,omitempty"`

	// ProjectDisplayName: The human readable name of project that the
	// resource belongs to.
	ProjectDisplayName string `json:"projectDisplayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Folders") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Folders") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse: Response
// of asset discovery run
type GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse struct {
	// Duration: The duration between asset discovery run start and end
	Duration string `json:"duration,omitempty"`

	// State: The state of an asset discovery run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Asset discovery run state was unspecified.
	//   "COMPLETED" - Asset discovery run completed successfully.
	//   "SUPERSEDED" - Asset discovery run was cancelled with tasks still
	// pending, as another run for the same organization was started with a
	// higher priority.
	//   "TERMINATED" - Asset discovery run was killed and terminated.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Duration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudSecuritycenterV1p1beta1SecurityMarks: User specified
// security marks that are attached to the parent Security Command
// Center resource. Security marks are scoped within a Security Command
// Center organization -- they can be modified and viewed by all users
// who have proper permissions on the organization.
type GoogleCloudSecuritycenterV1p1beta1SecurityMarks struct {
	// CanonicalName: The canonical name of the marks. Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "folders/{folder_id}/assets/{asset_id}/securityMarks"
	// "projects/{project_number}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks"
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/securit
	// yMarks"
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}/s
	// ecurityMarks"
	CanonicalName string `json:"canonicalName,omitempty"`

	// Marks: Mutable user specified security marks belonging to the parent
	// resource. Constraints are as follows: * Keys and values are treated
	// as case insensitive * Keys must be between 1 - 256 characters
	// (inclusive) * Keys must be letters, numbers, underscores, or dashes *
	// Values have leading and trailing whitespace trimmed, remaining
	// characters must be between 1 - 4096 characters (inclusive)
	Marks map[string]string `json:"marks,omitempty"`

	// Name: The relative resource name of the SecurityMarks. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks".
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudSecuritycenterV1p1beta1SecurityMarks) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudSecuritycenterV1p1beta1SecurityMarks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Indicator: Represents what's commonly known as an Indicator of
// compromise (IoC) in computer forensics. This is an artifact observed
// on a network or in an operating system that, with high confidence,
// indicates a computer intrusion. Reference:
// https://en.wikipedia.org/wiki/Indicator_of_compromise
type Indicator struct {
	// Domains: List of domains associated to the Finding.
	Domains []string `json:"domains,omitempty"`

	// IpAddresses: List of ip addresses associated to the Finding.
	IpAddresses []string `json:"ipAddresses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Domains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Domains") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Indicator) MarshalJSON() ([]byte, error) {
	type NoMethod Indicator
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MitreAttack: MITRE ATT&CK tactics and techniques related to this
// finding. See: https://attack.mitre.org
type MitreAttack struct {
	// AdditionalTactics: Additional MITRE ATT&CK tactics related to this
	// finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	AdditionalTactics []string `json:"additionalTactics,omitempty"`

	// AdditionalTechniques: Additional MITRE ATT&CK techniques related to
	// this finding, if any, along with any of their respective parent
	// techniques.
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "SHARED_MODULES" - T1129
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "RESOURCE_HIJACKING" - T1496
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "VALID_ACCOUNTS" - T1078
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	AdditionalTechniques []string `json:"additionalTechniques,omitempty"`

	// PrimaryTactic: The MITRE ATT&CK tactic most closely represented by
	// this finding, if any.
	//
	// Possible values:
	//   "TACTIC_UNSPECIFIED" - Unspecified value.
	//   "RECONNAISSANCE" - TA0043
	//   "RESOURCE_DEVELOPMENT" - TA0042
	//   "INITIAL_ACCESS" - TA0001
	//   "EXECUTION" - TA0002
	//   "PERSISTENCE" - TA0003
	//   "PRIVILEGE_ESCALATION" - TA0004
	//   "DEFENSE_EVASION" - TA0005
	//   "CREDENTIAL_ACCESS" - TA0006
	//   "DISCOVERY" - TA0007
	//   "LATERAL_MOVEMENT" - TA0008
	//   "COLLECTION" - TA0009
	//   "COMMAND_AND_CONTROL" - TA0011
	//   "EXFILTRATION" - TA0010
	//   "IMPACT" - TA0040
	PrimaryTactic string `json:"primaryTactic,omitempty"`

	// PrimaryTechniques: The MITRE ATT&CK technique most closely
	// represented by this finding, if any. primary_techniques is a repeated
	// field because there are multiple levels of MITRE ATT&CK techniques.
	// If the technique most closely represented by this finding is a
	// sub-technique (e.g. SCANNING_IP_BLOCKS), both the sub-technique and
	// its parent technique(s) will be listed (e.g. SCANNING_IP_BLOCKS,
	// ACTIVE_SCANNING).
	//
	// Possible values:
	//   "TECHNIQUE_UNSPECIFIED" - Unspecified value.
	//   "ACTIVE_SCANNING" - T1595
	//   "SCANNING_IP_BLOCKS" - T1595.001
	//   "INGRESS_TOOL_TRANSFER" - T1105
	//   "NATIVE_API" - T1106
	//   "SHARED_MODULES" - T1129
	//   "COMMAND_AND_SCRIPTING_INTERPRETER" - T1059
	//   "UNIX_SHELL" - T1059.004
	//   "RESOURCE_HIJACKING" - T1496
	//   "PROXY" - T1090
	//   "EXTERNAL_PROXY" - T1090.002
	//   "MULTI_HOP_PROXY" - T1090.003
	//   "DYNAMIC_RESOLUTION" - T1568
	//   "UNSECURED_CREDENTIALS" - T1552
	//   "VALID_ACCOUNTS" - T1078
	//   "LOCAL_ACCOUNTS" - T1078.003
	//   "CLOUD_ACCOUNTS" - T1078.004
	//   "NETWORK_DENIAL_OF_SERVICE" - T1498
	//   "PERMISSION_GROUPS_DISCOVERY" - T1069
	//   "CLOUD_GROUPS" - T1069.003
	//   "EXFILTRATION_OVER_WEB_SERVICE" - T1567
	//   "EXFILTRATION_TO_CLOUD_STORAGE" - T1567.002
	//   "ACCOUNT_MANIPULATION" - T1098
	//   "SSH_AUTHORIZED_KEYS" - T1098.004
	//   "CREATE_OR_MODIFY_SYSTEM_PROCESS" - T1543
	//   "STEAL_WEB_SESSION_COOKIE" - T1539
	//   "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE" - T1578
	//   "EXPLOIT_PUBLIC_FACING_APPLICATION" - T1190
	PrimaryTechniques []string `json:"primaryTechniques,omitempty"`

	// Version: The MITRE ATT&CK version referenced by the above fields.
	// E.g. "8".
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalTactics")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalTactics") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *MitreAttack) MarshalJSON() ([]byte, error) {
	type NoMethod MitreAttack
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Reference: Additional Links
type Reference struct {
	// Source: Source of the reference e.g. NVD
	Source string `json:"source,omitempty"`

	// Uri: Uri for the mentioned source e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Source") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Source") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Reference) MarshalJSON() ([]byte, error) {
	type NoMethod Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityCenterSettings: Resource capturing the settings for Security
// Center.
type SecurityCenterSettings struct {
	// LogSinkProject: The resource name of the project to send logs to.
	// This project must be part of the organization this resource resides
	// in. The format is `projects/{project_id}`. An empty value disables
	// logging. This value is only referenced by services that support log
	// sink. Please refer to the documentation for an updated list of
	// compatible services.
	LogSinkProject string `json:"logSinkProject,omitempty"`

	// Name: The resource name of the SecurityCenterSettings. Format:
	// organizations/{organization}/securityCenterSettings
	Name string `json:"name,omitempty"`

	// OrgServiceAccount: The organization level service account to be used
	// for security center components.
	OrgServiceAccount string `json:"orgServiceAccount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "LogSinkProject") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LogSinkProject") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SecurityCenterSettings) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityCenterSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityHealthAnalyticsSettings: Resource capturing the settings for
// the Security Health Analytics service.
type SecurityHealthAnalyticsSettings struct {
	// Modules: The configurations including the state of enablement for the
	// service's different modules. The absence of a module in the map
	// implies its configuration is inherited from its parent's.
	Modules map[string]Config `json:"modules,omitempty"`

	// Name: The resource name of the SecurityHealthAnalyticsSettings.
	// Formats: *
	// organizations/{organization}/securityHealthAnalyticsSettings *
	// folders/{folder}/securityHealthAnalyticsSettings *
	// projects/{project}/securityHealthAnalyticsSettings
	Name string `json:"name,omitempty"`

	// ServiceAccount: Output only. The service account used by Security
	// Health Analytics detectors.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ServiceEnablementState: The state of enablement for the service at
	// its level of the resource hierarchy. A DISABLED state will override
	// all module enablement_states to DISABLED.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ServiceEnablementState string `json:"serviceEnablementState,omitempty"`

	// UpdateTime: Output only. The time the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Modules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Modules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityHealthAnalyticsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityHealthAnalyticsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityMarks: User specified security marks that are attached to the
// parent Security Command Center resource. Security marks are scoped
// within a Security Command Center organization -- they can be modified
// and viewed by all users who have proper permissions on the
// organization.
type SecurityMarks struct {
	// CanonicalName: The canonical name of the marks. Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "folders/{folder_id}/assets/{asset_id}/securityMarks"
	// "projects/{project_number}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks"
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/securit
	// yMarks"
	// "projects/{project_number}/sources/{source_id}/findings/{finding_id}/s
	// ecurityMarks"
	CanonicalName string `json:"canonicalName,omitempty"`

	// Marks: Mutable user specified security marks belonging to the parent
	// resource. Constraints are as follows: * Keys and values are treated
	// as case insensitive * Keys must be between 1 - 256 characters
	// (inclusive) * Keys must be letters, numbers, underscores, or dashes *
	// Values have leading and trailing whitespace trimmed, remaining
	// characters must be between 1 - 4096 characters (inclusive)
	Marks map[string]string `json:"marks,omitempty"`

	// Name: The relative resource name of the SecurityMarks. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Examples:
	// "organizations/{organization_id}/assets/{asset_id}/securityMarks"
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding
	// _id}/securityMarks".
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecurityMarks) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityMarks
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Subscription: Resource capturing the state of an organization's
// subscription.
type Subscription struct {
	// Details: The details of the most recent active subscription. If there
	// has never been a subscription this will be empty.
	Details *Details `json:"details,omitempty"`

	// Name: The resource name of the subscription. Format:
	// organizations/{organization}/subscription
	Name string `json:"name,omitempty"`

	// Tier: The tier of SCC features this organization currently has access
	// to.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - The standard tier.
	//   "PREMIUM" - The premium tier.
	Tier string `json:"tier,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Details") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Details") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod Subscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VirtualMachineThreatDetectionSettings: Resource capturing the
// settings for the Virtual Machine Threat Detection service.
type VirtualMachineThreatDetectionSettings struct {
	// Modules: The configurations including the state of enablement for the
	// service's different modules. The absence of a module in the map
	// implies its configuration is inherited from its parent's.
	Modules map[string]Config `json:"modules,omitempty"`

	// Name: The resource name of the VirtualMachineThreatDetectionSettings.
	// Formats: *
	// organizations/{organization}/virtualMachineThreatDetectionSettings *
	// folders/{folder}/virtualMachineThreatDetectionSettings *
	// projects/{project}/virtualMachineThreatDetectionSettings
	Name string `json:"name,omitempty"`

	// ServiceAccount: Output only. The service account used by Virtual
	// Machine Threat Detection detectors.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ServiceEnablementState: The state of enablement for the service at
	// its level of the resource hierarchy. A DISABLED state will override
	// all module enablement_states to DISABLED.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ServiceEnablementState string `json:"serviceEnablementState,omitempty"`

	// UpdateTime: Output only. The time the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Modules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Modules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VirtualMachineThreatDetectionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualMachineThreatDetectionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Vulnerability: Refers to common vulnerability fields e.g. cve, cvss,
// cwe etc.
type Vulnerability struct {
	// Cve: CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Cve *Cve `json:"cve,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cve") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cve") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Vulnerability) MarshalJSON() ([]byte, error) {
	type NoMethod Vulnerability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebSecurityScannerSettings: Resource capturing the settings for the
// Web Security Scanner service.
type WebSecurityScannerSettings struct {
	// Modules: The configurations including the state of enablement for the
	// service's different modules. The absence of a module in the map
	// implies its configuration is inherited from its parent's.
	Modules map[string]Config `json:"modules,omitempty"`

	// Name: The resource name of the WebSecurityScannerSettings. Formats: *
	// organizations/{organization}/webSecurityScannerSettings *
	// folders/{folder}/webSecurityScannerSettings *
	// projects/{project}/webSecurityScannerSettings
	Name string `json:"name,omitempty"`

	// ServiceEnablementState: The state of enablement for the service at
	// its level of the resource hierarchy. A DISABLED state will override
	// all module enablement_states to DISABLED.
	//
	// Possible values:
	//   "ENABLEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "INHERITED" - State is inherited from the parent resource.
	//   "ENABLED" - State is enabled.
	//   "DISABLED" - State is disabled.
	ServiceEnablementState string `json:"serviceEnablementState,omitempty"`

	// UpdateTime: Output only. The time the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Modules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Modules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WebSecurityScannerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod WebSecurityScannerSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "securitycenter.folders.getContainerThreatDetectionSettings":

type FoldersGetContainerThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContainerThreatDetectionSettings: Get the
// ContainerThreatDetectionSettings resource.
//
// - name: The name of the ContainerThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *FoldersService) GetContainerThreatDetectionSettings(name string) *FoldersGetContainerThreatDetectionSettingsCall {
	c := &FoldersGetContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersGetContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersGetContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersGetContainerThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *FoldersGetContainerThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersGetContainerThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersGetContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersGetContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.getContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersGetContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/containerThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.getContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.getEventThreatDetectionSettings":

type FoldersGetEventThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEventThreatDetectionSettings: Get the EventThreatDetectionSettings
// resource.
//
// - name: The name of the EventThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *FoldersService) GetEventThreatDetectionSettings(name string) *FoldersGetEventThreatDetectionSettingsCall {
	c := &FoldersGetEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersGetEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersGetEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersGetEventThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *FoldersGetEventThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersGetEventThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersGetEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersGetEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.getEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersGetEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/eventThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.getEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.getSecurityHealthAnalyticsSettings":

type FoldersGetSecurityHealthAnalyticsSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecurityHealthAnalyticsSettings: Get the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The name of the SecurityHealthAnalyticsSettings to retrieve.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *FoldersService) GetSecurityHealthAnalyticsSettings(name string) *FoldersGetSecurityHealthAnalyticsSettingsCall {
	c := &FoldersGetSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *FoldersGetSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) IfNoneMatch(entityTag string) *FoldersGetSecurityHealthAnalyticsSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *FoldersGetSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.getSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersGetSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.getSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to retrieve. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.getVirtualMachineThreatDetectionSettings":

type FoldersGetVirtualMachineThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetVirtualMachineThreatDetectionSettings: Get the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   retrieve. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *FoldersService) GetVirtualMachineThreatDetectionSettings(name string) *FoldersGetVirtualMachineThreatDetectionSettingsCall {
	c := &FoldersGetVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersGetVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *FoldersGetVirtualMachineThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersGetVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.getVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersGetVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.getVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.getWebSecurityScannerSettings":

type FoldersGetWebSecurityScannerSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetWebSecurityScannerSettings: Get the WebSecurityScannerSettings
// resource.
//
// - name: The name of the WebSecurityScannerSettings to retrieve.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *FoldersService) GetWebSecurityScannerSettings(name string) *FoldersGetWebSecurityScannerSettingsCall {
	c := &FoldersGetWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersGetWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *FoldersGetWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersGetWebSecurityScannerSettingsCall) IfNoneMatch(entityTag string) *FoldersGetWebSecurityScannerSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersGetWebSecurityScannerSettingsCall) Context(ctx context.Context) *FoldersGetWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersGetWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.getWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersGetWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/webSecurityScannerSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.getWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to retrieve. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.updateContainerThreatDetectionSettings":

type FoldersUpdateContainerThreatDetectionSettingsCall struct {
	s                                *Service
	name                             string
	containerthreatdetectionsettings *ContainerThreatDetectionSettings
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// UpdateContainerThreatDetectionSettings: Update the
// ContainerThreatDetectionSettings resource.
//
// - name: The resource name of the ContainerThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *FoldersService) UpdateContainerThreatDetectionSettings(name string, containerthreatdetectionsettings *ContainerThreatDetectionSettings) *FoldersUpdateContainerThreatDetectionSettingsCall {
	c := &FoldersUpdateContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.containerthreatdetectionsettings = containerthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *FoldersUpdateContainerThreatDetectionSettingsCall) UpdateMask(updateMask string) *FoldersUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersUpdateContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersUpdateContainerThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersUpdateContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersUpdateContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.containerthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.updateContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersUpdateContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/containerThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.updateContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the ContainerThreatDetectionSettings. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.updateEventThreatDetectionSettings":

type FoldersUpdateEventThreatDetectionSettingsCall struct {
	s                            *Service
	name                         string
	eventthreatdetectionsettings *EventThreatDetectionSettings
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// UpdateEventThreatDetectionSettings: Update the
// EventThreatDetectionSettings resource.
//
// - name: The resource name of the EventThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *FoldersService) UpdateEventThreatDetectionSettings(name string, eventthreatdetectionsettings *EventThreatDetectionSettings) *FoldersUpdateEventThreatDetectionSettingsCall {
	c := &FoldersUpdateEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.eventthreatdetectionsettings = eventthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *FoldersUpdateEventThreatDetectionSettingsCall) UpdateMask(updateMask string) *FoldersUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersUpdateEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersUpdateEventThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersUpdateEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersUpdateEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.updateEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersUpdateEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/eventThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.updateEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the EventThreatDetectionSettings. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.updateSecurityHealthAnalyticsSettings":

type FoldersUpdateSecurityHealthAnalyticsSettingsCall struct {
	s                               *Service
	name                            string
	securityhealthanalyticssettings *SecurityHealthAnalyticsSettings
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// UpdateSecurityHealthAnalyticsSettings: Update the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The resource name of the SecurityHealthAnalyticsSettings.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *FoldersService) UpdateSecurityHealthAnalyticsSettings(name string, securityhealthanalyticssettings *SecurityHealthAnalyticsSettings) *FoldersUpdateSecurityHealthAnalyticsSettingsCall {
	c := &FoldersUpdateSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securityhealthanalyticssettings = securityhealthanalyticssettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) UpdateMask(updateMask string) *FoldersUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *FoldersUpdateSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securityhealthanalyticssettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.updateSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersUpdateSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.updateSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the SecurityHealthAnalyticsSettings. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.updateVirtualMachineThreatDetectionSettings":

type FoldersUpdateVirtualMachineThreatDetectionSettingsCall struct {
	s                                     *Service
	name                                  string
	virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// UpdateVirtualMachineThreatDetectionSettings: Update the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The resource name of the
//   VirtualMachineThreatDetectionSettings. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *FoldersService) UpdateVirtualMachineThreatDetectionSettings(name string, virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings) *FoldersUpdateVirtualMachineThreatDetectionSettingsCall {
	c := &FoldersUpdateVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.virtualmachinethreatdetectionsettings = virtualmachinethreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) UpdateMask(updateMask string) *FoldersUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *FoldersUpdateVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.virtualmachinethreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.updateVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersUpdateVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.updateVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the VirtualMachineThreatDetectionSettings. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.updateWebSecurityScannerSettings":

type FoldersUpdateWebSecurityScannerSettingsCall struct {
	s                          *Service
	name                       string
	websecurityscannersettings *WebSecurityScannerSettings
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// UpdateWebSecurityScannerSettings: Update the
// WebSecurityScannerSettings resource.
//
// - name: The resource name of the WebSecurityScannerSettings. Formats:
//   * organizations/{organization}/webSecurityScannerSettings *
//   folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *FoldersService) UpdateWebSecurityScannerSettings(name string, websecurityscannersettings *WebSecurityScannerSettings) *FoldersUpdateWebSecurityScannerSettingsCall {
	c := &FoldersUpdateWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.websecurityscannersettings = websecurityscannersettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *FoldersUpdateWebSecurityScannerSettingsCall) UpdateMask(updateMask string) *FoldersUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersUpdateWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersUpdateWebSecurityScannerSettingsCall) Context(ctx context.Context) *FoldersUpdateWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersUpdateWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.websecurityscannersettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.updateWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersUpdateWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/folders/{foldersId}/webSecurityScannerSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.folders.updateWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the WebSecurityScannerSettings. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.containerThreatDetectionSettings.calculate":

type FoldersContainerThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective ContainerThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the ContainerThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *FoldersContainerThreatDetectionSettingsService) Calculate(name string) *FoldersContainerThreatDetectionSettingsCalculateCall {
	c := &FoldersContainerThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContainerThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *FoldersContainerThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersContainerThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *FoldersContainerThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContainerThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *FoldersContainerThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContainerThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContainerThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.containerThreatDetectionSettings.calculate" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContainerThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective ContainerThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/folders/{foldersId}/containerThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.containerThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to calculate. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.eventThreatDetectionSettings.calculate":

type FoldersEventThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective EventThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the EventThreatDetectionSettings to calculate.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *FoldersEventThreatDetectionSettingsService) Calculate(name string) *FoldersEventThreatDetectionSettingsCalculateCall {
	c := &FoldersEventThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersEventThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *FoldersEventThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersEventThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *FoldersEventThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersEventThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *FoldersEventThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersEventThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersEventThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.eventThreatDetectionSettings.calculate" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersEventThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective EventThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/folders/{foldersId}/eventThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.eventThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to calculate. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.securityHealthAnalyticsSettings.calculate":

type FoldersSecurityHealthAnalyticsSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective SecurityHealthAnalyticsSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the SecurityHealthAnalyticsSettings to calculate.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *FoldersSecurityHealthAnalyticsSettingsService) Calculate(name string) *FoldersSecurityHealthAnalyticsSettingsCalculateCall {
	c := &FoldersSecurityHealthAnalyticsSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) Fields(s ...googleapi.Field) *FoldersSecurityHealthAnalyticsSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) IfNoneMatch(entityTag string) *FoldersSecurityHealthAnalyticsSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) Context(ctx context.Context) *FoldersSecurityHealthAnalyticsSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.securityHealthAnalyticsSettings.calculate" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersSecurityHealthAnalyticsSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective SecurityHealthAnalyticsSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/folders/{foldersId}/securityHealthAnalyticsSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.securityHealthAnalyticsSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to calculate. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.virtualMachineThreatDetectionSettings.calculate":

type FoldersVirtualMachineThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective
// VirtualMachineThreatDetectionSettings based on its level in the
// resource hierarchy and its settings.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *FoldersVirtualMachineThreatDetectionSettingsService) Calculate(name string) *FoldersVirtualMachineThreatDetectionSettingsCalculateCall {
	c := &FoldersVirtualMachineThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *FoldersVirtualMachineThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *FoldersVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *FoldersVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.virtualMachineThreatDetectionSettings.calculate" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersVirtualMachineThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective VirtualMachineThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/folders/{foldersId}/virtualMachineThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.virtualMachineThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to calculate. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.folders.webSecurityScannerSettings.calculate":

type FoldersWebSecurityScannerSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective WebSecurityScannerSettings based
// on its level in the resource hierarchy and its settings.
//
// - name: The name of the WebSecurityScannerSettings to calculate.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *FoldersWebSecurityScannerSettingsService) Calculate(name string) *FoldersWebSecurityScannerSettingsCalculateCall {
	c := &FoldersWebSecurityScannerSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersWebSecurityScannerSettingsCalculateCall) Fields(s ...googleapi.Field) *FoldersWebSecurityScannerSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersWebSecurityScannerSettingsCalculateCall) IfNoneMatch(entityTag string) *FoldersWebSecurityScannerSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersWebSecurityScannerSettingsCalculateCall) Context(ctx context.Context) *FoldersWebSecurityScannerSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersWebSecurityScannerSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersWebSecurityScannerSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.folders.webSecurityScannerSettings.calculate" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersWebSecurityScannerSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective WebSecurityScannerSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/folders/{foldersId}/webSecurityScannerSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.folders.webSecurityScannerSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to calculate. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getContainerThreatDetectionSettings":

type OrganizationsGetContainerThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContainerThreatDetectionSettings: Get the
// ContainerThreatDetectionSettings resource.
//
// - name: The name of the ContainerThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *OrganizationsService) GetContainerThreatDetectionSettings(name string) *OrganizationsGetContainerThreatDetectionSettingsCall {
	c := &OrganizationsGetContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetContainerThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetContainerThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetContainerThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsGetContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/containerThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getEventThreatDetectionSettings":

type OrganizationsGetEventThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEventThreatDetectionSettings: Get the EventThreatDetectionSettings
// resource.
//
// - name: The name of the EventThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *OrganizationsService) GetEventThreatDetectionSettings(name string) *OrganizationsGetEventThreatDetectionSettingsCall {
	c := &OrganizationsGetEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetEventThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetEventThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetEventThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsGetEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/eventThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getSecurityCenterSettings":

type OrganizationsGetSecurityCenterSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecurityCenterSettings: Get the SecurityCenterSettings resource.
//
// - name: The name of the SecurityCenterSettings to retrieve. Format:
//   organizations/{organization}/securityCenterSettings.
func (r *OrganizationsService) GetSecurityCenterSettings(name string) *OrganizationsGetSecurityCenterSettingsCall {
	c := &OrganizationsGetSecurityCenterSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetSecurityCenterSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetSecurityCenterSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetSecurityCenterSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetSecurityCenterSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetSecurityCenterSettingsCall) Context(ctx context.Context) *OrganizationsGetSecurityCenterSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetSecurityCenterSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSecurityCenterSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getSecurityCenterSettings" call.
// Exactly one of *SecurityCenterSettings or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SecurityCenterSettings.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetSecurityCenterSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityCenterSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityCenterSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the SecurityCenterSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/securityCenterSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getSecurityCenterSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityCenterSettings to retrieve. Format: organizations/{organization}/securityCenterSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securityCenterSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "SecurityCenterSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getSecurityHealthAnalyticsSettings":

type OrganizationsGetSecurityHealthAnalyticsSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecurityHealthAnalyticsSettings: Get the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The name of the SecurityHealthAnalyticsSettings to retrieve.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *OrganizationsService) GetSecurityHealthAnalyticsSettings(name string) *OrganizationsGetSecurityHealthAnalyticsSettingsCall {
	c := &OrganizationsGetSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetSecurityHealthAnalyticsSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *OrganizationsGetSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to retrieve. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getSubscription":

type OrganizationsGetSubscriptionCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSubscription: Get the Subscription resource.
//
// - name: The name of the subscription to retrieve. Format:
//   organizations/{organization}/subscription.
func (r *OrganizationsService) GetSubscription(name string) *OrganizationsGetSubscriptionCall {
	c := &OrganizationsGetSubscriptionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetSubscriptionCall) Fields(s ...googleapi.Field) *OrganizationsGetSubscriptionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetSubscriptionCall) IfNoneMatch(entityTag string) *OrganizationsGetSubscriptionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetSubscriptionCall) Context(ctx context.Context) *OrganizationsGetSubscriptionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetSubscriptionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSubscriptionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getSubscription" call.
// Exactly one of *Subscription or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Subscription.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsGetSubscriptionCall) Do(opts ...googleapi.CallOption) (*Subscription, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Subscription{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the Subscription resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/subscription",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getSubscription",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the subscription to retrieve. Format: organizations/{organization}/subscription",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/subscription$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "Subscription"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getVirtualMachineThreatDetectionSettings":

type OrganizationsGetVirtualMachineThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetVirtualMachineThreatDetectionSettings: Get the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   retrieve. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *OrganizationsService) GetVirtualMachineThreatDetectionSettings(name string) *OrganizationsGetVirtualMachineThreatDetectionSettingsCall {
	c := &OrganizationsGetVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetVirtualMachineThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsGetVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.getWebSecurityScannerSettings":

type OrganizationsGetWebSecurityScannerSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetWebSecurityScannerSettings: Get the WebSecurityScannerSettings
// resource.
//
// - name: The name of the WebSecurityScannerSettings to retrieve.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *OrganizationsService) GetWebSecurityScannerSettings(name string) *OrganizationsGetWebSecurityScannerSettingsCall {
	c := &OrganizationsGetWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetWebSecurityScannerSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetWebSecurityScannerSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetWebSecurityScannerSettingsCall) Context(ctx context.Context) *OrganizationsGetWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.getWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/webSecurityScannerSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.getWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to retrieve. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateContainerThreatDetectionSettings":

type OrganizationsUpdateContainerThreatDetectionSettingsCall struct {
	s                                *Service
	name                             string
	containerthreatdetectionsettings *ContainerThreatDetectionSettings
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// UpdateContainerThreatDetectionSettings: Update the
// ContainerThreatDetectionSettings resource.
//
// - name: The resource name of the ContainerThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *OrganizationsService) UpdateContainerThreatDetectionSettings(name string, containerthreatdetectionsettings *ContainerThreatDetectionSettings) *OrganizationsUpdateContainerThreatDetectionSettingsCall {
	c := &OrganizationsUpdateContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.containerthreatdetectionsettings = containerthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsUpdateContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.containerthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/containerThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the ContainerThreatDetectionSettings. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateEventThreatDetectionSettings":

type OrganizationsUpdateEventThreatDetectionSettingsCall struct {
	s                            *Service
	name                         string
	eventthreatdetectionsettings *EventThreatDetectionSettings
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// UpdateEventThreatDetectionSettings: Update the
// EventThreatDetectionSettings resource.
//
// - name: The resource name of the EventThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *OrganizationsService) UpdateEventThreatDetectionSettings(name string, eventthreatdetectionsettings *EventThreatDetectionSettings) *OrganizationsUpdateEventThreatDetectionSettingsCall {
	c := &OrganizationsUpdateEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.eventthreatdetectionsettings = eventthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsUpdateEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/eventThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the EventThreatDetectionSettings. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateSecurityHealthAnalyticsSettings":

type OrganizationsUpdateSecurityHealthAnalyticsSettingsCall struct {
	s                               *Service
	name                            string
	securityhealthanalyticssettings *SecurityHealthAnalyticsSettings
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// UpdateSecurityHealthAnalyticsSettings: Update the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The resource name of the SecurityHealthAnalyticsSettings.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *OrganizationsService) UpdateSecurityHealthAnalyticsSettings(name string, securityhealthanalyticssettings *SecurityHealthAnalyticsSettings) *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall {
	c := &OrganizationsUpdateSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securityhealthanalyticssettings = securityhealthanalyticssettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securityhealthanalyticssettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the SecurityHealthAnalyticsSettings. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateVirtualMachineThreatDetectionSettings":

type OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall struct {
	s                                     *Service
	name                                  string
	virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// UpdateVirtualMachineThreatDetectionSettings: Update the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The resource name of the
//   VirtualMachineThreatDetectionSettings. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *OrganizationsService) UpdateVirtualMachineThreatDetectionSettings(name string, virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings) *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall {
	c := &OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.virtualmachinethreatdetectionsettings = virtualmachinethreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.virtualmachinethreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the VirtualMachineThreatDetectionSettings. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.updateWebSecurityScannerSettings":

type OrganizationsUpdateWebSecurityScannerSettingsCall struct {
	s                          *Service
	name                       string
	websecurityscannersettings *WebSecurityScannerSettings
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// UpdateWebSecurityScannerSettings: Update the
// WebSecurityScannerSettings resource.
//
// - name: The resource name of the WebSecurityScannerSettings. Formats:
//   * organizations/{organization}/webSecurityScannerSettings *
//   folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *OrganizationsService) UpdateWebSecurityScannerSettings(name string, websecurityscannersettings *WebSecurityScannerSettings) *OrganizationsUpdateWebSecurityScannerSettingsCall {
	c := &OrganizationsUpdateWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.websecurityscannersettings = websecurityscannersettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) Context(ctx context.Context) *OrganizationsUpdateWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.websecurityscannersettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.updateWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/webSecurityScannerSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.organizations.updateWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the WebSecurityScannerSettings. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.containerThreatDetectionSettings.calculate":

type OrganizationsContainerThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective ContainerThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the ContainerThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *OrganizationsContainerThreatDetectionSettingsService) Calculate(name string) *OrganizationsContainerThreatDetectionSettingsCalculateCall {
	c := &OrganizationsContainerThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *OrganizationsContainerThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *OrganizationsContainerThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *OrganizationsContainerThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.containerThreatDetectionSettings.calculate" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContainerThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective ContainerThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/containerThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.containerThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to calculate. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.eventThreatDetectionSettings.calculate":

type OrganizationsEventThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective EventThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the EventThreatDetectionSettings to calculate.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *OrganizationsEventThreatDetectionSettingsService) Calculate(name string) *OrganizationsEventThreatDetectionSettingsCalculateCall {
	c := &OrganizationsEventThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *OrganizationsEventThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *OrganizationsEventThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *OrganizationsEventThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.eventThreatDetectionSettings.calculate" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsEventThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective EventThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/eventThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.eventThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to calculate. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.securityHealthAnalyticsSettings.calculate":

type OrganizationsSecurityHealthAnalyticsSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective SecurityHealthAnalyticsSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the SecurityHealthAnalyticsSettings to calculate.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *OrganizationsSecurityHealthAnalyticsSettingsService) Calculate(name string) *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall {
	c := &OrganizationsSecurityHealthAnalyticsSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) Fields(s ...googleapi.Field) *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) IfNoneMatch(entityTag string) *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) Context(ctx context.Context) *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.securityHealthAnalyticsSettings.calculate" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsSecurityHealthAnalyticsSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective SecurityHealthAnalyticsSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/securityHealthAnalyticsSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.securityHealthAnalyticsSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to calculate. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.virtualMachineThreatDetectionSettings.calculate":

type OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective
// VirtualMachineThreatDetectionSettings based on its level in the
// resource hierarchy and its settings.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *OrganizationsVirtualMachineThreatDetectionSettingsService) Calculate(name string) *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall {
	c := &OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.virtualMachineThreatDetectionSettings.calculate" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsVirtualMachineThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective VirtualMachineThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/virtualMachineThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.virtualMachineThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to calculate. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.organizations.webSecurityScannerSettings.calculate":

type OrganizationsWebSecurityScannerSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective WebSecurityScannerSettings based
// on its level in the resource hierarchy and its settings.
//
// - name: The name of the WebSecurityScannerSettings to calculate.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *OrganizationsWebSecurityScannerSettingsService) Calculate(name string) *OrganizationsWebSecurityScannerSettingsCalculateCall {
	c := &OrganizationsWebSecurityScannerSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) Fields(s ...googleapi.Field) *OrganizationsWebSecurityScannerSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) IfNoneMatch(entityTag string) *OrganizationsWebSecurityScannerSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) Context(ctx context.Context) *OrganizationsWebSecurityScannerSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.organizations.webSecurityScannerSettings.calculate" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsWebSecurityScannerSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective WebSecurityScannerSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/organizations/{organizationsId}/webSecurityScannerSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.organizations.webSecurityScannerSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to calculate. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.getContainerThreatDetectionSettings":

type ProjectsGetContainerThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContainerThreatDetectionSettings: Get the
// ContainerThreatDetectionSettings resource.
//
// - name: The name of the ContainerThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsService) GetContainerThreatDetectionSettings(name string) *ProjectsGetContainerThreatDetectionSettingsCall {
	c := &ProjectsGetContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsGetContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetContainerThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *ProjectsGetContainerThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetContainerThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsGetContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.getContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/containerThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.getContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.getEventThreatDetectionSettings":

type ProjectsGetEventThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEventThreatDetectionSettings: Get the EventThreatDetectionSettings
// resource.
//
// - name: The name of the EventThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *ProjectsService) GetEventThreatDetectionSettings(name string) *ProjectsGetEventThreatDetectionSettingsCall {
	c := &ProjectsGetEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsGetEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetEventThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *ProjectsGetEventThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetEventThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsGetEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.getEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/eventThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.getEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.getSecurityHealthAnalyticsSettings":

type ProjectsGetSecurityHealthAnalyticsSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecurityHealthAnalyticsSettings: Get the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The name of the SecurityHealthAnalyticsSettings to retrieve.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *ProjectsService) GetSecurityHealthAnalyticsSettings(name string) *ProjectsGetSecurityHealthAnalyticsSettingsCall {
	c := &ProjectsGetSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *ProjectsGetSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) IfNoneMatch(entityTag string) *ProjectsGetSecurityHealthAnalyticsSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *ProjectsGetSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.getSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.getSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to retrieve. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.getVirtualMachineThreatDetectionSettings":

type ProjectsGetVirtualMachineThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetVirtualMachineThreatDetectionSettings: Get the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   retrieve. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *ProjectsService) GetVirtualMachineThreatDetectionSettings(name string) *ProjectsGetVirtualMachineThreatDetectionSettingsCall {
	c := &ProjectsGetVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsGetVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *ProjectsGetVirtualMachineThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsGetVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.getVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.getVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.getWebSecurityScannerSettings":

type ProjectsGetWebSecurityScannerSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetWebSecurityScannerSettings: Get the WebSecurityScannerSettings
// resource.
//
// - name: The name of the WebSecurityScannerSettings to retrieve.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *ProjectsService) GetWebSecurityScannerSettings(name string) *ProjectsGetWebSecurityScannerSettingsCall {
	c := &ProjectsGetWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *ProjectsGetWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetWebSecurityScannerSettingsCall) IfNoneMatch(entityTag string) *ProjectsGetWebSecurityScannerSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetWebSecurityScannerSettingsCall) Context(ctx context.Context) *ProjectsGetWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.getWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/webSecurityScannerSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.getWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to retrieve. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.updateContainerThreatDetectionSettings":

type ProjectsUpdateContainerThreatDetectionSettingsCall struct {
	s                                *Service
	name                             string
	containerthreatdetectionsettings *ContainerThreatDetectionSettings
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// UpdateContainerThreatDetectionSettings: Update the
// ContainerThreatDetectionSettings resource.
//
// - name: The resource name of the ContainerThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsService) UpdateContainerThreatDetectionSettings(name string, containerthreatdetectionsettings *ContainerThreatDetectionSettings) *ProjectsUpdateContainerThreatDetectionSettingsCall {
	c := &ProjectsUpdateContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.containerthreatdetectionsettings = containerthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) UpdateMask(updateMask string) *ProjectsUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsUpdateContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.containerthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.updateContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsUpdateContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/containerThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.updateContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the ContainerThreatDetectionSettings. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.updateEventThreatDetectionSettings":

type ProjectsUpdateEventThreatDetectionSettingsCall struct {
	s                            *Service
	name                         string
	eventthreatdetectionsettings *EventThreatDetectionSettings
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// UpdateEventThreatDetectionSettings: Update the
// EventThreatDetectionSettings resource.
//
// - name: The resource name of the EventThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *ProjectsService) UpdateEventThreatDetectionSettings(name string, eventthreatdetectionsettings *EventThreatDetectionSettings) *ProjectsUpdateEventThreatDetectionSettingsCall {
	c := &ProjectsUpdateEventThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.eventthreatdetectionsettings = eventthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsUpdateEventThreatDetectionSettingsCall) UpdateMask(updateMask string) *ProjectsUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsUpdateEventThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsUpdateEventThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsUpdateEventThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsUpdateEventThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsUpdateEventThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateEventThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.updateEventThreatDetectionSettings" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsUpdateEventThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the EventThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/eventThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.updateEventThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the EventThreatDetectionSettings. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.updateSecurityHealthAnalyticsSettings":

type ProjectsUpdateSecurityHealthAnalyticsSettingsCall struct {
	s                               *Service
	name                            string
	securityhealthanalyticssettings *SecurityHealthAnalyticsSettings
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// UpdateSecurityHealthAnalyticsSettings: Update the
// SecurityHealthAnalyticsSettings resource.
//
// - name: The resource name of the SecurityHealthAnalyticsSettings.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *ProjectsService) UpdateSecurityHealthAnalyticsSettings(name string, securityhealthanalyticssettings *SecurityHealthAnalyticsSettings) *ProjectsUpdateSecurityHealthAnalyticsSettingsCall {
	c := &ProjectsUpdateSecurityHealthAnalyticsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securityhealthanalyticssettings = securityhealthanalyticssettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) UpdateMask(updateMask string) *ProjectsUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) Fields(s ...googleapi.Field) *ProjectsUpdateSecurityHealthAnalyticsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) Context(ctx context.Context) *ProjectsUpdateSecurityHealthAnalyticsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securityhealthanalyticssettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.updateSecurityHealthAnalyticsSettings" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsUpdateSecurityHealthAnalyticsSettingsCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the SecurityHealthAnalyticsSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/securityHealthAnalyticsSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.updateSecurityHealthAnalyticsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the SecurityHealthAnalyticsSettings. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.updateVirtualMachineThreatDetectionSettings":

type ProjectsUpdateVirtualMachineThreatDetectionSettingsCall struct {
	s                                     *Service
	name                                  string
	virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// UpdateVirtualMachineThreatDetectionSettings: Update the
// VirtualMachineThreatDetectionSettings resource.
//
// - name: The resource name of the
//   VirtualMachineThreatDetectionSettings. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *ProjectsService) UpdateVirtualMachineThreatDetectionSettings(name string, virtualmachinethreatdetectionsettings *VirtualMachineThreatDetectionSettings) *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall {
	c := &ProjectsUpdateVirtualMachineThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.virtualmachinethreatdetectionsettings = virtualmachinethreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) UpdateMask(updateMask string) *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.virtualmachinethreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.updateVirtualMachineThreatDetectionSettings" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsUpdateVirtualMachineThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the VirtualMachineThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/virtualMachineThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.updateVirtualMachineThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the VirtualMachineThreatDetectionSettings. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.updateWebSecurityScannerSettings":

type ProjectsUpdateWebSecurityScannerSettingsCall struct {
	s                          *Service
	name                       string
	websecurityscannersettings *WebSecurityScannerSettings
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// UpdateWebSecurityScannerSettings: Update the
// WebSecurityScannerSettings resource.
//
// - name: The resource name of the WebSecurityScannerSettings. Formats:
//   * organizations/{organization}/webSecurityScannerSettings *
//   folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *ProjectsService) UpdateWebSecurityScannerSettings(name string, websecurityscannersettings *WebSecurityScannerSettings) *ProjectsUpdateWebSecurityScannerSettingsCall {
	c := &ProjectsUpdateWebSecurityScannerSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.websecurityscannersettings = websecurityscannersettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsUpdateWebSecurityScannerSettingsCall) UpdateMask(updateMask string) *ProjectsUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsUpdateWebSecurityScannerSettingsCall) Fields(s ...googleapi.Field) *ProjectsUpdateWebSecurityScannerSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsUpdateWebSecurityScannerSettingsCall) Context(ctx context.Context) *ProjectsUpdateWebSecurityScannerSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsUpdateWebSecurityScannerSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdateWebSecurityScannerSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.websecurityscannersettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.updateWebSecurityScannerSettings" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsUpdateWebSecurityScannerSettingsCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the WebSecurityScannerSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/webSecurityScannerSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.updateWebSecurityScannerSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the WebSecurityScannerSettings. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.containerThreatDetectionSettings.calculate":

type ProjectsContainerThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective ContainerThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the ContainerThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsContainerThreatDetectionSettingsService) Calculate(name string) *ProjectsContainerThreatDetectionSettingsCalculateCall {
	c := &ProjectsContainerThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsContainerThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsContainerThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *ProjectsContainerThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.containerThreatDetectionSettings.calculate" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContainerThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective ContainerThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/containerThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.containerThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to calculate. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.eventThreatDetectionSettings.calculate":

type ProjectsEventThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective EventThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the EventThreatDetectionSettings to calculate.
//   Formats: *
//   organizations/{organization}/eventThreatDetectionSettings *
//   folders/{folder}/eventThreatDetectionSettings *
//   projects/{project}/eventThreatDetectionSettings.
func (r *ProjectsEventThreatDetectionSettingsService) Calculate(name string) *ProjectsEventThreatDetectionSettingsCalculateCall {
	c := &ProjectsEventThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsEventThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsEventThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsEventThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsEventThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsEventThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *ProjectsEventThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsEventThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEventThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.eventThreatDetectionSettings.calculate" call.
// Exactly one of *EventThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *EventThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsEventThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*EventThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &EventThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective EventThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/eventThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.eventThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the EventThreatDetectionSettings to calculate. Formats: * organizations/{organization}/eventThreatDetectionSettings * folders/{folder}/eventThreatDetectionSettings * projects/{project}/eventThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/eventThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "EventThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.locations.clusters.getContainerThreatDetectionSettings":

type ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContainerThreatDetectionSettings: Get the
// ContainerThreatDetectionSettings resource.
//
// - name: The name of the ContainerThreatDetectionSettings to retrieve.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsLocationsClustersService) GetContainerThreatDetectionSettings(name string) *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall {
	c := &ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.locations.clusters.getContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersGetContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/containerThreatDetectionSettings",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.locations.clusters.getContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to retrieve. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.locations.clusters.updateContainerThreatDetectionSettings":

type ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall struct {
	s                                *Service
	name                             string
	containerthreatdetectionsettings *ContainerThreatDetectionSettings
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// UpdateContainerThreatDetectionSettings: Update the
// ContainerThreatDetectionSettings resource.
//
// - name: The resource name of the ContainerThreatDetectionSettings.
//   Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsLocationsClustersService) UpdateContainerThreatDetectionSettings(name string, containerthreatdetectionsettings *ContainerThreatDetectionSettings) *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall {
	c := &ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.containerthreatdetectionsettings = containerthreatdetectionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated.
func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) Context(ctx context.Context) *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.containerthreatdetectionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.locations.clusters.updateContainerThreatDetectionSettings" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersUpdateContainerThreatDetectionSettingsCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the ContainerThreatDetectionSettings resource.",
	//   "flatPath": "v1beta2/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/containerThreatDetectionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "securitycenter.projects.locations.clusters.updateContainerThreatDetectionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the ContainerThreatDetectionSettings. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}",
	//   "request": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.locations.clusters.containerThreatDetectionSettings.calculate":

type ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective ContainerThreatDetectionSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the ContainerThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/containerThreatDetectionSettings *
//   folders/{folder}/containerThreatDetectionSettings *
//   projects/{project}/containerThreatDetectionSettings *
//   projects/{project}/locations/{location}/clusters/{cluster}/container
//   ThreatDetectionSettings.
func (r *ProjectsLocationsClustersContainerThreatDetectionSettingsService) Calculate(name string) *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall {
	c := &ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.locations.clusters.containerThreatDetectionSettings.calculate" call.
// Exactly one of *ContainerThreatDetectionSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ContainerThreatDetectionSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsClustersContainerThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*ContainerThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ContainerThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective ContainerThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/containerThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.locations.clusters.containerThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ContainerThreatDetectionSettings to calculate. Formats: * organizations/{organization}/containerThreatDetectionSettings * folders/{folder}/containerThreatDetectionSettings * projects/{project}/containerThreatDetectionSettings * projects/{project}/locations/{location}/clusters/{cluster}/containerThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/containerThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "ContainerThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.securityHealthAnalyticsSettings.calculate":

type ProjectsSecurityHealthAnalyticsSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective SecurityHealthAnalyticsSettings
// based on its level in the resource hierarchy and its settings.
//
// - name: The name of the SecurityHealthAnalyticsSettings to calculate.
//   Formats: *
//   organizations/{organization}/securityHealthAnalyticsSettings *
//   folders/{folder}/securityHealthAnalyticsSettings *
//   projects/{project}/securityHealthAnalyticsSettings.
func (r *ProjectsSecurityHealthAnalyticsSettingsService) Calculate(name string) *ProjectsSecurityHealthAnalyticsSettingsCalculateCall {
	c := &ProjectsSecurityHealthAnalyticsSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsSecurityHealthAnalyticsSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsSecurityHealthAnalyticsSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) Context(ctx context.Context) *ProjectsSecurityHealthAnalyticsSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.securityHealthAnalyticsSettings.calculate" call.
// Exactly one of *SecurityHealthAnalyticsSettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SecurityHealthAnalyticsSettings.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsSecurityHealthAnalyticsSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*SecurityHealthAnalyticsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecurityHealthAnalyticsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective SecurityHealthAnalyticsSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/securityHealthAnalyticsSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.securityHealthAnalyticsSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecurityHealthAnalyticsSettings to calculate. Formats: * organizations/{organization}/securityHealthAnalyticsSettings * folders/{folder}/securityHealthAnalyticsSettings * projects/{project}/securityHealthAnalyticsSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/securityHealthAnalyticsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "SecurityHealthAnalyticsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.virtualMachineThreatDetectionSettings.calculate":

type ProjectsVirtualMachineThreatDetectionSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective
// VirtualMachineThreatDetectionSettings based on its level in the
// resource hierarchy and its settings.
//
// - name: The name of the VirtualMachineThreatDetectionSettings to
//   calculate. Formats: *
//   organizations/{organization}/virtualMachineThreatDetectionSettings
//   * folders/{folder}/virtualMachineThreatDetectionSettings *
//   projects/{project}/virtualMachineThreatDetectionSettings.
func (r *ProjectsVirtualMachineThreatDetectionSettingsService) Calculate(name string) *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall {
	c := &ProjectsVirtualMachineThreatDetectionSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) Context(ctx context.Context) *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.virtualMachineThreatDetectionSettings.calculate" call.
// Exactly one of *VirtualMachineThreatDetectionSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *VirtualMachineThreatDetectionSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsVirtualMachineThreatDetectionSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*VirtualMachineThreatDetectionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &VirtualMachineThreatDetectionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective VirtualMachineThreatDetectionSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/virtualMachineThreatDetectionSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.virtualMachineThreatDetectionSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the VirtualMachineThreatDetectionSettings to calculate. Formats: * organizations/{organization}/virtualMachineThreatDetectionSettings * folders/{folder}/virtualMachineThreatDetectionSettings * projects/{project}/virtualMachineThreatDetectionSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/virtualMachineThreatDetectionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "VirtualMachineThreatDetectionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "securitycenter.projects.webSecurityScannerSettings.calculate":

type ProjectsWebSecurityScannerSettingsCalculateCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Calculate: Calculates the effective WebSecurityScannerSettings based
// on its level in the resource hierarchy and its settings.
//
// - name: The name of the WebSecurityScannerSettings to calculate.
//   Formats: * organizations/{organization}/webSecurityScannerSettings
//   * folders/{folder}/webSecurityScannerSettings *
//   projects/{project}/webSecurityScannerSettings.
func (r *ProjectsWebSecurityScannerSettingsService) Calculate(name string) *ProjectsWebSecurityScannerSettingsCalculateCall {
	c := &ProjectsWebSecurityScannerSettingsCalculateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebSecurityScannerSettingsCalculateCall) Fields(s ...googleapi.Field) *ProjectsWebSecurityScannerSettingsCalculateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsWebSecurityScannerSettingsCalculateCall) IfNoneMatch(entityTag string) *ProjectsWebSecurityScannerSettingsCalculateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebSecurityScannerSettingsCalculateCall) Context(ctx context.Context) *ProjectsWebSecurityScannerSettingsCalculateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebSecurityScannerSettingsCalculateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebSecurityScannerSettingsCalculateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20220104")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta2/{+name}:calculate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "securitycenter.projects.webSecurityScannerSettings.calculate" call.
// Exactly one of *WebSecurityScannerSettings or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *WebSecurityScannerSettings.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsWebSecurityScannerSettingsCalculateCall) Do(opts ...googleapi.CallOption) (*WebSecurityScannerSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebSecurityScannerSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Calculates the effective WebSecurityScannerSettings based on its level in the resource hierarchy and its settings.",
	//   "flatPath": "v1beta2/projects/{projectsId}/webSecurityScannerSettings:calculate",
	//   "httpMethod": "GET",
	//   "id": "securitycenter.projects.webSecurityScannerSettings.calculate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the WebSecurityScannerSettings to calculate. Formats: * organizations/{organization}/webSecurityScannerSettings * folders/{folder}/webSecurityScannerSettings * projects/{project}/webSecurityScannerSettings",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webSecurityScannerSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta2/{+name}:calculate",
	//   "response": {
	//     "$ref": "WebSecurityScannerSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
