package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMetric invokes the baas.QueryMetric API synchronously
// api document: https://help.aliyun.com/api/baas/querymetric.html
func (client *Client) QueryMetric(request *QueryMetricRequest) (response *QueryMetricResponse, err error) {
	response = CreateQueryMetricResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMetricWithChan invokes the baas.QueryMetric API asynchronously
// api document: https://help.aliyun.com/api/baas/querymetric.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricWithChan(request *QueryMetricRequest) (<-chan *QueryMetricResponse, <-chan error) {
	responseChan := make(chan *QueryMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMetricWithCallback invokes the baas.QueryMetric API asynchronously
// api document: https://help.aliyun.com/api/baas/querymetric.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricWithCallback(request *QueryMetricRequest, callback func(response *QueryMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMetricResponse
		var err error
		defer close(result)
		response, err = client.QueryMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMetricRequest is the request struct for api QueryMetric
type QueryMetricRequest struct {
	*requests.RpcRequest
	Period   string `position:"Body" name:"Period"`
	Metric   string `position:"Body" name:"Metric"`
	Port     string `position:"Body" name:"Port"`
	Bizid    string `position:"Query" name:"Bizid"`
	TimeArea string `position:"Body" name:"TimeArea"`
	InnerIp  string `position:"Body" name:"InnerIp"`
}

// QueryMetricResponse is the response struct for api QueryMetric
type QueryMetricResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateQueryMetricRequest creates a request to invoke QueryMetric API
func CreateQueryMetricRequest() (request *QueryMetricRequest) {
	request = &QueryMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "QueryMetric", "", "")
	return
}

// CreateQueryMetricResponse creates a response to parse from QueryMetric response
func CreateQueryMetricResponse() (response *QueryMetricResponse) {
	response = &QueryMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
