package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAppEnv invokes the webplus.UpdateAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/updateappenv.html
func (client *Client) UpdateAppEnv(request *UpdateAppEnvRequest) (response *UpdateAppEnvResponse, err error) {
	response = CreateUpdateAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAppEnvWithChan invokes the webplus.UpdateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/updateappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAppEnvWithChan(request *UpdateAppEnvRequest) (<-chan *UpdateAppEnvResponse, <-chan error) {
	responseChan := make(chan *UpdateAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAppEnvWithCallback invokes the webplus.UpdateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/updateappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAppEnvWithCallback(request *UpdateAppEnvRequest, callback func(response *UpdateAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAppEnvResponse
		var err error
		defer close(result)
		response, err = client.UpdateAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAppEnvRequest is the request struct for api UpdateAppEnv
type UpdateAppEnvRequest struct {
	*requests.RoaRequest
	OptionSettings string           `position:"Body" name:"OptionSettings"`
	DryRun         requests.Boolean `position:"Body" name:"DryRun"`
	StackId        string           `position:"Body" name:"StackId"`
	EnvDescription string           `position:"Body" name:"EnvDescription"`
	EnvId          string           `position:"Body" name:"EnvId"`
	PkgVersionId   string           `position:"Body" name:"PkgVersionId"`
}

// UpdateAppEnvResponse is the response struct for api UpdateAppEnv
type UpdateAppEnvResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Code            string          `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	EnvChangeDetail EnvChangeDetail `json:"EnvChangeDetail" xml:"EnvChangeDetail"`
}

// CreateUpdateAppEnvRequest creates a request to invoke UpdateAppEnv API
func CreateUpdateAppEnvRequest() (request *UpdateAppEnvRequest) {
	request = &UpdateAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "UpdateAppEnv", "/pop/v1/wam/appEnv", "webx", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateAppEnvResponse creates a response to parse from UpdateAppEnv response
func CreateUpdateAppEnvResponse() (response *UpdateAppEnvResponse) {
	response = &UpdateAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
