package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateETLJob invokes the emr.CreateETLJob API synchronously
// api document: https://help.aliyun.com/api/emr/createetljob.html
func (client *Client) CreateETLJob(request *CreateETLJobRequest) (response *CreateETLJobResponse, err error) {
	response = CreateCreateETLJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateETLJobWithChan invokes the emr.CreateETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/createetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateETLJobWithChan(request *CreateETLJobRequest) (<-chan *CreateETLJobResponse, <-chan error) {
	responseChan := make(chan *CreateETLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateETLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateETLJobWithCallback invokes the emr.CreateETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/createetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateETLJobWithCallback(request *CreateETLJobRequest, callback func(response *CreateETLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateETLJobResponse
		var err error
		defer close(result)
		response, err = client.CreateETLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateETLJobRequest is the request struct for api CreateETLJob
type CreateETLJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NavParentId     string           `position:"Query" name:"NavParentId"`
	Name            string           `position:"Query" name:"Name"`
	Description     string           `position:"Query" name:"Description"`
	Type            string           `position:"Query" name:"Type"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
}

// CreateETLJobResponse is the response struct for api CreateETLJob
type CreateETLJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateETLJobRequest creates a request to invoke CreateETLJob API
func CreateCreateETLJobRequest() (request *CreateETLJobRequest) {
	request = &CreateETLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateETLJob", "emr", "openAPI")
	return
}

// CreateCreateETLJobResponse creates a response to parse from CreateETLJob response
func CreateCreateETLJobResponse() (response *CreateETLJobResponse) {
	response = &CreateETLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
