package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFlowJob invokes the emr.CreateFlowJob API synchronously
// api document: https://help.aliyun.com/api/emr/createflowjob.html
func (client *Client) CreateFlowJob(request *CreateFlowJobRequest) (response *CreateFlowJobResponse, err error) {
	response = CreateCreateFlowJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFlowJobWithChan invokes the emr.CreateFlowJob API asynchronously
// api document: https://help.aliyun.com/api/emr/createflowjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFlowJobWithChan(request *CreateFlowJobRequest) (<-chan *CreateFlowJobResponse, <-chan error) {
	responseChan := make(chan *CreateFlowJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFlowJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFlowJobWithCallback invokes the emr.CreateFlowJob API asynchronously
// api document: https://help.aliyun.com/api/emr/createflowjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFlowJobWithCallback(request *CreateFlowJobRequest, callback func(response *CreateFlowJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFlowJobResponse
		var err error
		defer close(result)
		response, err = client.CreateFlowJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFlowJobRequest is the request struct for api CreateFlowJob
type CreateFlowJobRequest struct {
	*requests.RpcRequest
	RunConf        string                       `position:"Query" name:"RunConf"`
	EnvConf        string                       `position:"Query" name:"EnvConf"`
	Description    string                       `position:"Query" name:"Description"`
	ClusterId      string                       `position:"Query" name:"ClusterId"`
	Type           string                       `position:"Query" name:"Type"`
	Params         string                       `position:"Query" name:"Params"`
	ParamConf      string                       `position:"Query" name:"ParamConf"`
	ResourceList   *[]CreateFlowJobResourceList `position:"Query" name:"ResourceList"  type:"Repeated"`
	FailAct        string                       `position:"Query" name:"FailAct"`
	Mode           string                       `position:"Query" name:"Mode"`
	RetryInterval  requests.Integer             `position:"Query" name:"RetryInterval"`
	MonitorConf    string                       `position:"Query" name:"MonitorConf"`
	Name           string                       `position:"Query" name:"Name"`
	MaxRetry       requests.Integer             `position:"Query" name:"MaxRetry"`
	Adhoc          requests.Boolean             `position:"Query" name:"Adhoc"`
	AlertConf      string                       `position:"Query" name:"AlertConf"`
	ProjectId      string                       `position:"Query" name:"ProjectId"`
	ParentCategory string                       `position:"Query" name:"ParentCategory"`
}

// CreateFlowJobResourceList is a repeated param struct in CreateFlowJobRequest
type CreateFlowJobResourceList struct {
	Path  string `name:"Path"`
	Alias string `name:"Alias"`
}

// CreateFlowJobResponse is the response struct for api CreateFlowJob
type CreateFlowJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateFlowJobRequest creates a request to invoke CreateFlowJob API
func CreateCreateFlowJobRequest() (request *CreateFlowJobRequest) {
	request = &CreateFlowJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateFlowJob", "emr", "openAPI")
	return
}

// CreateCreateFlowJobResponse creates a response to parse from CreateFlowJob response
func CreateCreateFlowJobResponse() (response *CreateFlowJobResponse) {
	response = &CreateFlowJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
