package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteParagraph invokes the emr.DeleteParagraph API synchronously
// api document: https://help.aliyun.com/api/emr/deleteparagraph.html
func (client *Client) DeleteParagraph(request *DeleteParagraphRequest) (response *DeleteParagraphResponse, err error) {
	response = CreateDeleteParagraphResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteParagraphWithChan invokes the emr.DeleteParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteParagraphWithChan(request *DeleteParagraphRequest) (<-chan *DeleteParagraphResponse, <-chan error) {
	responseChan := make(chan *DeleteParagraphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteParagraph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteParagraphWithCallback invokes the emr.DeleteParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteParagraphWithCallback(request *DeleteParagraphRequest, callback func(response *DeleteParagraphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteParagraphResponse
		var err error
		defer close(result)
		response, err = client.DeleteParagraph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteParagraphRequest is the request struct for api DeleteParagraph
type DeleteParagraphRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NoteId          string           `position:"Query" name:"NoteId"`
	Id              string           `position:"Query" name:"Id"`
}

// DeleteParagraphResponse is the response struct for api DeleteParagraph
type DeleteParagraphResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteParagraphRequest creates a request to invoke DeleteParagraph API
func CreateDeleteParagraphRequest() (request *DeleteParagraphRequest) {
	request = &DeleteParagraphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteParagraph", "emr", "openAPI")
	return
}

// CreateDeleteParagraphResponse creates a response to parse from DeleteParagraph response
func CreateDeleteParagraphResponse() (response *DeleteParagraphResponse) {
	response = &DeleteParagraphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
