package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourcePool invokes the emr.DeleteResourcePool API synchronously
// api document: https://help.aliyun.com/api/emr/deleteresourcepool.html
func (client *Client) DeleteResourcePool(request *DeleteResourcePoolRequest) (response *DeleteResourcePoolResponse, err error) {
	response = CreateDeleteResourcePoolResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourcePoolWithChan invokes the emr.DeleteResourcePool API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteresourcepool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourcePoolWithChan(request *DeleteResourcePoolRequest) (<-chan *DeleteResourcePoolResponse, <-chan error) {
	responseChan := make(chan *DeleteResourcePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourcePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourcePoolWithCallback invokes the emr.DeleteResourcePool API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteresourcepool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourcePoolWithCallback(request *DeleteResourcePoolRequest, callback func(response *DeleteResourcePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourcePoolResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourcePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourcePoolRequest is the request struct for api DeleteResourcePool
type DeleteResourcePoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourcePoolId  string           `position:"Query" name:"ResourcePoolId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DeleteResourcePoolResponse is the response struct for api DeleteResourcePool
type DeleteResourcePoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourcePoolRequest creates a request to invoke DeleteResourcePool API
func CreateDeleteResourcePoolRequest() (request *DeleteResourcePoolRequest) {
	request = &DeleteResourcePoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteResourcePool", "emr", "openAPI")
	return
}

// CreateDeleteResourcePoolResponse creates a response to parse from DeleteResourcePool response
func CreateDeleteResourcePoolResponse() (response *DeleteResourcePoolResponse) {
	response = &DeleteResourcePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
