package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlowProjectClusterSetting invokes the emr.ModifyFlowProjectClusterSetting API synchronously
// api document: https://help.aliyun.com/api/emr/modifyflowprojectclustersetting.html
func (client *Client) ModifyFlowProjectClusterSetting(request *ModifyFlowProjectClusterSettingRequest) (response *ModifyFlowProjectClusterSettingResponse, err error) {
	response = CreateModifyFlowProjectClusterSettingResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowProjectClusterSettingWithChan invokes the emr.ModifyFlowProjectClusterSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowprojectclustersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowProjectClusterSettingWithChan(request *ModifyFlowProjectClusterSettingRequest) (<-chan *ModifyFlowProjectClusterSettingResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowProjectClusterSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlowProjectClusterSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowProjectClusterSettingWithCallback invokes the emr.ModifyFlowProjectClusterSetting API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowprojectclustersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowProjectClusterSettingWithCallback(request *ModifyFlowProjectClusterSettingRequest, callback func(response *ModifyFlowProjectClusterSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowProjectClusterSettingResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlowProjectClusterSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowProjectClusterSettingRequest is the request struct for api ModifyFlowProjectClusterSetting
type ModifyFlowProjectClusterSettingRequest struct {
	*requests.RpcRequest
	UserList     *[]string `position:"Query" name:"UserList"  type:"Repeated"`
	QueueList    *[]string `position:"Query" name:"QueueList"  type:"Repeated"`
	HostList     *[]string `position:"Query" name:"HostList"  type:"Repeated"`
	ClusterId    string    `position:"Query" name:"ClusterId"`
	DefaultQueue string    `position:"Query" name:"DefaultQueue"`
	ProjectId    string    `position:"Query" name:"ProjectId"`
	DefaultUser  string    `position:"Query" name:"DefaultUser"`
}

// ModifyFlowProjectClusterSettingResponse is the response struct for api ModifyFlowProjectClusterSetting
type ModifyFlowProjectClusterSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateModifyFlowProjectClusterSettingRequest creates a request to invoke ModifyFlowProjectClusterSetting API
func CreateModifyFlowProjectClusterSettingRequest() (request *ModifyFlowProjectClusterSettingRequest) {
	request = &ModifyFlowProjectClusterSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyFlowProjectClusterSetting", "emr", "openAPI")
	return
}

// CreateModifyFlowProjectClusterSettingResponse creates a response to parse from ModifyFlowProjectClusterSetting response
func CreateModifyFlowProjectClusterSettingResponse() (response *ModifyFlowProjectClusterSettingResponse) {
	response = &ModifyFlowProjectClusterSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
