package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSimilarityImage invokes the green.AddSimilarityImage API synchronously
// api document: https://help.aliyun.com/api/green/addsimilarityimage.html
func (client *Client) AddSimilarityImage(request *AddSimilarityImageRequest) (response *AddSimilarityImageResponse, err error) {
	response = CreateAddSimilarityImageResponse()
	err = client.DoAction(request, response)
	return
}

// AddSimilarityImageWithChan invokes the green.AddSimilarityImage API asynchronously
// api document: https://help.aliyun.com/api/green/addsimilarityimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddSimilarityImageWithChan(request *AddSimilarityImageRequest) (<-chan *AddSimilarityImageResponse, <-chan error) {
	responseChan := make(chan *AddSimilarityImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSimilarityImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSimilarityImageWithCallback invokes the green.AddSimilarityImage API asynchronously
// api document: https://help.aliyun.com/api/green/addsimilarityimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddSimilarityImageWithCallback(request *AddSimilarityImageRequest, callback func(response *AddSimilarityImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSimilarityImageResponse
		var err error
		defer close(result)
		response, err = client.AddSimilarityImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSimilarityImageRequest is the request struct for api AddSimilarityImage
type AddSimilarityImageRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// AddSimilarityImageResponse is the response struct for api AddSimilarityImage
type AddSimilarityImageResponse struct {
	*responses.BaseResponse
}

// CreateAddSimilarityImageRequest creates a request to invoke AddSimilarityImage API
func CreateAddSimilarityImageRequest() (request *AddSimilarityImageRequest) {
	request = &AddSimilarityImageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "AddSimilarityImage", "/green/similarity/image/add", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddSimilarityImageResponse creates a response to parse from AddSimilarityImage response
func CreateAddSimilarityImageResponse() (response *AddSimilarityImageResponse) {
	response = &AddSimilarityImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
