package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenAttachedChildInstanceAttribute invokes the cbn.DescribeCenAttachedChildInstanceAttribute API synchronously
// api document: https://help.aliyun.com/api/cbn/describecenattachedchildinstanceattribute.html
func (client *Client) DescribeCenAttachedChildInstanceAttribute(request *DescribeCenAttachedChildInstanceAttributeRequest) (response *DescribeCenAttachedChildInstanceAttributeResponse, err error) {
	response = CreateDescribeCenAttachedChildInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenAttachedChildInstanceAttributeWithChan invokes the cbn.DescribeCenAttachedChildInstanceAttribute API asynchronously
// api document: https://help.aliyun.com/api/cbn/describecenattachedchildinstanceattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCenAttachedChildInstanceAttributeWithChan(request *DescribeCenAttachedChildInstanceAttributeRequest) (<-chan *DescribeCenAttachedChildInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeCenAttachedChildInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenAttachedChildInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenAttachedChildInstanceAttributeWithCallback invokes the cbn.DescribeCenAttachedChildInstanceAttribute API asynchronously
// api document: https://help.aliyun.com/api/cbn/describecenattachedchildinstanceattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCenAttachedChildInstanceAttributeWithCallback(request *DescribeCenAttachedChildInstanceAttributeRequest, callback func(response *DescribeCenAttachedChildInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenAttachedChildInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenAttachedChildInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenAttachedChildInstanceAttributeRequest is the request struct for api DescribeCenAttachedChildInstanceAttribute
type DescribeCenAttachedChildInstanceAttributeRequest struct {
	*requests.RpcRequest
	ChildInstanceId       string           `position:"Query" name:"ChildInstanceId"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	CenId                 string           `position:"Query" name:"CenId"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	ChildInstanceType     string           `position:"Query" name:"ChildInstanceType"`
	ChildInstanceRegionId string           `position:"Query" name:"ChildInstanceRegionId"`
}

// DescribeCenAttachedChildInstanceAttributeResponse is the response struct for api DescribeCenAttachedChildInstanceAttribute
type DescribeCenAttachedChildInstanceAttributeResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	CenId                   string `json:"CenId" xml:"CenId"`
	ChildInstanceId         string `json:"ChildInstanceId" xml:"ChildInstanceId"`
	ChildInstanceType       string `json:"ChildInstanceType" xml:"ChildInstanceType"`
	ChildInstanceRegionId   string `json:"ChildInstanceRegionId" xml:"ChildInstanceRegionId"`
	ChildInstanceOwnerId    int    `json:"ChildInstanceOwnerId" xml:"ChildInstanceOwnerId"`
	Status                  string `json:"Status" xml:"Status"`
	ChildInstanceName       string `json:"ChildInstanceName" xml:"ChildInstanceName"`
	ChildInstanceAttachTime string `json:"ChildInstanceAttachTime" xml:"ChildInstanceAttachTime"`
}

// CreateDescribeCenAttachedChildInstanceAttributeRequest creates a request to invoke DescribeCenAttachedChildInstanceAttribute API
func CreateDescribeCenAttachedChildInstanceAttributeRequest() (request *DescribeCenAttachedChildInstanceAttributeRequest) {
	request = &DescribeCenAttachedChildInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenAttachedChildInstanceAttribute", "cbn", "openAPI")
	return
}

// CreateDescribeCenAttachedChildInstanceAttributeResponse creates a response to parse from DescribeCenAttachedChildInstanceAttribute response
func CreateDescribeCenAttachedChildInstanceAttributeResponse() (response *DescribeCenAttachedChildInstanceAttributeResponse) {
	response = &DescribeCenAttachedChildInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
