package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUser invokes the ess.DescribeUser API synchronously
// api document: https://help.aliyun.com/api/ess/describeuser.html
func (client *Client) DescribeUser(request *DescribeUserRequest) (response *DescribeUserResponse, err error) {
	response = CreateDescribeUserResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserWithChan invokes the ess.DescribeUser API asynchronously
// api document: https://help.aliyun.com/api/ess/describeuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserWithChan(request *DescribeUserRequest) (<-chan *DescribeUserResponse, <-chan error) {
	responseChan := make(chan *DescribeUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserWithCallback invokes the ess.DescribeUser API asynchronously
// api document: https://help.aliyun.com/api/ess/describeuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserWithCallback(request *DescribeUserRequest, callback func(response *DescribeUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserResponse
		var err error
		defer close(result)
		response, err = client.DescribeUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserRequest is the request struct for api DescribeUser
type DescribeUserRequest struct {
	*requests.RpcRequest
	UserId               requests.Integer `position:"Query" name:"UserId"`
	ForceDelete          requests.Boolean `position:"Query" name:"ForceDelete"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeUserResponse is the response struct for api DescribeUser
type DescribeUserResponse struct {
	*responses.BaseResponse
	UserId                           string `json:"UserId" xml:"UserId"`
	GrantPermission                  bool   `json:"GrantPermission" xml:"GrantPermission"`
	RealNameAuthentication           bool   `json:"RealNameAuthentication" xml:"RealNameAuthentication"`
	Deleted                          bool   `json:"Deleted" xml:"Deleted"`
	Bid                              string `json:"Bid" xml:"Bid"`
	MaxNumberOfScalingGroup          int    `json:"MaxNumberOfScalingGroup" xml:"MaxNumberOfScalingGroup"`
	MaxNumberOfScalingConf           int    `json:"MaxNumberOfScalingConf" xml:"MaxNumberOfScalingConf"`
	MaxNumberOfScalingRule           int    `json:"MaxNumberOfScalingRule" xml:"MaxNumberOfScalingRule"`
	MaxNumberOfScalingTask           int    `json:"MaxNumberOfScalingTask" xml:"MaxNumberOfScalingTask"`
	MaxNumberOfMinSizeInScalingGroup int    `json:"MaxNumberOfMinSizeInScalingGroup" xml:"MaxNumberOfMinSizeInScalingGroup"`
	MaxNumberOfMaxSizeInScalingGroup int    `json:"MaxNumberOfMaxSizeInScalingGroup" xml:"MaxNumberOfMaxSizeInScalingGroup"`
	MaxNumberOfDBInstance            int    `json:"MaxNumberOfDBInstance" xml:"MaxNumberOfDBInstance"`
	MaxNumberOfLoadBalancer          int    `json:"MaxNumberOfLoadBalancer" xml:"MaxNumberOfLoadBalancer"`
	MaxNumberOfEcsInstance           int    `json:"MaxNumberOfEcsInstance" xml:"MaxNumberOfEcsInstance"`
	EcsStartExpirationTime           int    `json:"EcsStartExpirationTime" xml:"EcsStartExpirationTime"`
	EcsStopExpirationTime            int    `json:"EcsStopExpirationTime" xml:"EcsStopExpirationTime"`
}

// CreateDescribeUserRequest creates a request to invoke DescribeUser API
func CreateDescribeUserRequest() (request *DescribeUserRequest) {
	request = &DescribeUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribeUser", "ess", "openAPI")
	return
}

// CreateDescribeUserResponse creates a response to parse from DescribeUser response
func CreateDescribeUserResponse() (response *DescribeUserResponse) {
	response = &DescribeUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
