package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIndustryInfoChildrenList invokes the industry_brain.GetIndustryInfoChildrenList API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfochildrenlist.html
func (client *Client) GetIndustryInfoChildrenList(request *GetIndustryInfoChildrenListRequest) (response *GetIndustryInfoChildrenListResponse, err error) {
	response = CreateGetIndustryInfoChildrenListResponse()
	err = client.DoAction(request, response)
	return
}

// GetIndustryInfoChildrenListWithChan invokes the industry_brain.GetIndustryInfoChildrenList API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfochildrenlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIndustryInfoChildrenListWithChan(request *GetIndustryInfoChildrenListRequest) (<-chan *GetIndustryInfoChildrenListResponse, <-chan error) {
	responseChan := make(chan *GetIndustryInfoChildrenListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIndustryInfoChildrenList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIndustryInfoChildrenListWithCallback invokes the industry_brain.GetIndustryInfoChildrenList API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfochildrenlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIndustryInfoChildrenListWithCallback(request *GetIndustryInfoChildrenListRequest, callback func(response *GetIndustryInfoChildrenListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIndustryInfoChildrenListResponse
		var err error
		defer close(result)
		response, err = client.GetIndustryInfoChildrenList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIndustryInfoChildrenListRequest is the request struct for api GetIndustryInfoChildrenList
type GetIndustryInfoChildrenListRequest struct {
	*requests.RpcRequest
	IndustryCode string `position:"Query" name:"IndustryCode"`
}

// GetIndustryInfoChildrenListResponse is the response struct for api GetIndustryInfoChildrenList
type GetIndustryInfoChildrenListResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	IndustryInfoList []IndustryInfoListItem `json:"IndustryInfoList" xml:"IndustryInfoList"`
}

// CreateGetIndustryInfoChildrenListRequest creates a request to invoke GetIndustryInfoChildrenList API
func CreateGetIndustryInfoChildrenListRequest() (request *GetIndustryInfoChildrenListRequest) {
	request = &GetIndustryInfoChildrenListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetIndustryInfoChildrenList", "", "")
	return
}

// CreateGetIndustryInfoChildrenListResponse creates a response to parse from GetIndustryInfoChildrenList response
func CreateGetIndustryInfoChildrenListResponse() (response *GetIndustryInfoChildrenListResponse) {
	response = &GetIndustryInfoChildrenListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
