package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAnalysisJobList invokes the mts.QueryAnalysisJobList API synchronously
// api document: https://help.aliyun.com/api/mts/queryanalysisjoblist.html
func (client *Client) QueryAnalysisJobList(request *QueryAnalysisJobListRequest) (response *QueryAnalysisJobListResponse, err error) {
	response = CreateQueryAnalysisJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAnalysisJobListWithChan invokes the mts.QueryAnalysisJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryanalysisjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAnalysisJobListWithChan(request *QueryAnalysisJobListRequest) (<-chan *QueryAnalysisJobListResponse, <-chan error) {
	responseChan := make(chan *QueryAnalysisJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAnalysisJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAnalysisJobListWithCallback invokes the mts.QueryAnalysisJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryanalysisjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAnalysisJobListWithCallback(request *QueryAnalysisJobListRequest, callback func(response *QueryAnalysisJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAnalysisJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryAnalysisJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAnalysisJobListRequest is the request struct for api QueryAnalysisJobList
type QueryAnalysisJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AnalysisJobIds       string           `position:"Query" name:"AnalysisJobIds"`
}

// QueryAnalysisJobListResponse is the response struct for api QueryAnalysisJobList
type QueryAnalysisJobListResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	NonExistAnalysisJobIds NonExistAnalysisJobIds `json:"NonExistAnalysisJobIds" xml:"NonExistAnalysisJobIds"`
	AnalysisJobList        AnalysisJobList        `json:"AnalysisJobList" xml:"AnalysisJobList"`
}

// CreateQueryAnalysisJobListRequest creates a request to invoke QueryAnalysisJobList API
func CreateQueryAnalysisJobListRequest() (request *QueryAnalysisJobListRequest) {
	request = &QueryAnalysisJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryAnalysisJobList", "mts", "openAPI")
	return
}

// CreateQueryAnalysisJobListResponse creates a response to parse from QueryAnalysisJobList response
func CreateQueryAnalysisJobListResponse() (response *QueryAnalysisJobListResponse) {
	response = &QueryAnalysisJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
