package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRestoreTask invokes the dbs.CreateRestoreTask API synchronously
// api document: https://help.aliyun.com/api/dbs/createrestoretask.html
func (client *Client) CreateRestoreTask(request *CreateRestoreTaskRequest) (response *CreateRestoreTaskResponse, err error) {
	response = CreateCreateRestoreTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRestoreTaskWithChan invokes the dbs.CreateRestoreTask API asynchronously
// api document: https://help.aliyun.com/api/dbs/createrestoretask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRestoreTaskWithChan(request *CreateRestoreTaskRequest) (<-chan *CreateRestoreTaskResponse, <-chan error) {
	responseChan := make(chan *CreateRestoreTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRestoreTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRestoreTaskWithCallback invokes the dbs.CreateRestoreTask API asynchronously
// api document: https://help.aliyun.com/api/dbs/createrestoretask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRestoreTaskWithCallback(request *CreateRestoreTaskRequest, callback func(response *CreateRestoreTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRestoreTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateRestoreTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRestoreTaskRequest is the request struct for api CreateRestoreTask
type CreateRestoreTaskRequest struct {
	*requests.RpcRequest
	BackupGatewayId                 requests.Integer `position:"Query" name:"BackupGatewayId"`
	DestinationEndpointOracleSID    string           `position:"Query" name:"DestinationEndpointOracleSID"`
	RestoreTime                     requests.Integer `position:"Query" name:"RestoreTime"`
	DestinationEndpointInstanceType string           `position:"Query" name:"DestinationEndpointInstanceType"`
	ClientToken                     string           `position:"Query" name:"ClientToken"`
	DestinationEndpointInstanceID   string           `position:"Query" name:"DestinationEndpointInstanceID"`
	DestinationEndpointPort         requests.Integer `position:"Query" name:"DestinationEndpointPort"`
	BackupPlanId                    string           `position:"Query" name:"BackupPlanId"`
	BackupSetId                     string           `position:"Query" name:"BackupSetId"`
	OwnerId                         string           `position:"Query" name:"OwnerId"`
	DestinationEndpointRegion       string           `position:"Query" name:"DestinationEndpointRegion"`
	RestoreDir                      string           `position:"Query" name:"RestoreDir"`
	DestinationEndpointIP           string           `position:"Query" name:"DestinationEndpointIP"`
	DestinationEndpointDatabaseName string           `position:"Query" name:"DestinationEndpointDatabaseName"`
	DestinationEndpointUserName     string           `position:"Query" name:"DestinationEndpointUserName"`
	RestoreObjects                  string           `position:"Query" name:"RestoreObjects"`
	RestoreTaskName                 string           `position:"Query" name:"RestoreTaskName"`
	DuplicateConflict               string           `position:"Query" name:"DuplicateConflict"`
	DestinationEndpointPassword     string           `position:"Query" name:"DestinationEndpointPassword"`
}

// CreateRestoreTaskResponse is the response struct for api CreateRestoreTask
type CreateRestoreTaskResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	RestoreTaskId  string `json:"RestoreTaskId" xml:"RestoreTaskId"`
}

// CreateCreateRestoreTaskRequest creates a request to invoke CreateRestoreTask API
func CreateCreateRestoreTaskRequest() (request *CreateRestoreTaskRequest) {
	request = &CreateRestoreTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "CreateRestoreTask", "cbs", "openAPI")
	return
}

// CreateCreateRestoreTaskResponse creates a response to parse from CreateRestoreTask response
func CreateCreateRestoreTaskResponse() (response *CreateRestoreTaskResponse) {
	response = &CreateRestoreTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
