package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecordDemand invokes the domain.RecordDemand API synchronously
// api document: https://help.aliyun.com/api/domain/recorddemand.html
func (client *Client) RecordDemand(request *RecordDemandRequest) (response *RecordDemandResponse, err error) {
	response = CreateRecordDemandResponse()
	err = client.DoAction(request, response)
	return
}

// RecordDemandWithChan invokes the domain.RecordDemand API asynchronously
// api document: https://help.aliyun.com/api/domain/recorddemand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecordDemandWithChan(request *RecordDemandRequest) (<-chan *RecordDemandResponse, <-chan error) {
	responseChan := make(chan *RecordDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecordDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecordDemandWithCallback invokes the domain.RecordDemand API asynchronously
// api document: https://help.aliyun.com/api/domain/recorddemand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecordDemandWithCallback(request *RecordDemandRequest, callback func(response *RecordDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecordDemandResponse
		var err error
		defer close(result)
		response, err = client.RecordDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecordDemandRequest is the request struct for api RecordDemand
type RecordDemandRequest struct {
	*requests.RpcRequest
	BizId   string `position:"Query" name:"BizId"`
	Message string `position:"Query" name:"Message"`
}

// RecordDemandResponse is the response struct for api RecordDemand
type RecordDemandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRecordDemandRequest creates a request to invoke RecordDemand API
func CreateRecordDemandRequest() (request *RecordDemandRequest) {
	request = &RecordDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "RecordDemand", "", "")
	return
}

// CreateRecordDemandResponse creates a response to parse from RecordDemand response
func CreateRecordDemandResponse() (response *RecordDemandResponse) {
	response = &RecordDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
