package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateReadOnlyAccount invokes the drds.CreateReadOnlyAccount API synchronously
// api document: https://help.aliyun.com/api/drds/createreadonlyaccount.html
func (client *Client) CreateReadOnlyAccount(request *CreateReadOnlyAccountRequest) (response *CreateReadOnlyAccountResponse, err error) {
	response = CreateCreateReadOnlyAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CreateReadOnlyAccountWithChan invokes the drds.CreateReadOnlyAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createreadonlyaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateReadOnlyAccountWithChan(request *CreateReadOnlyAccountRequest) (<-chan *CreateReadOnlyAccountResponse, <-chan error) {
	responseChan := make(chan *CreateReadOnlyAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateReadOnlyAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateReadOnlyAccountWithCallback invokes the drds.CreateReadOnlyAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createreadonlyaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateReadOnlyAccountWithCallback(request *CreateReadOnlyAccountRequest, callback func(response *CreateReadOnlyAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateReadOnlyAccountResponse
		var err error
		defer close(result)
		response, err = client.CreateReadOnlyAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateReadOnlyAccountRequest is the request struct for api CreateReadOnlyAccount
type CreateReadOnlyAccountRequest struct {
	*requests.RpcRequest
	Password       string `position:"Query" name:"password"`
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// CreateReadOnlyAccountResponse is the response struct for api CreateReadOnlyAccount
type CreateReadOnlyAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateReadOnlyAccountRequest creates a request to invoke CreateReadOnlyAccount API
func CreateCreateReadOnlyAccountRequest() (request *CreateReadOnlyAccountRequest) {
	request = &CreateReadOnlyAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "CreateReadOnlyAccount", "", "")
	return
}

// CreateCreateReadOnlyAccountResponse creates a response to parse from CreateReadOnlyAccount response
func CreateCreateReadOnlyAccountResponse() (response *CreateReadOnlyAccountResponse) {
	response = &CreateReadOnlyAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
