package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchDocIndex invokes the imm.SearchDocIndex API synchronously
// api document: https://help.aliyun.com/api/imm/searchdocindex.html
func (client *Client) SearchDocIndex(request *SearchDocIndexRequest) (response *SearchDocIndexResponse, err error) {
	response = CreateSearchDocIndexResponse()
	err = client.DoAction(request, response)
	return
}

// SearchDocIndexWithChan invokes the imm.SearchDocIndex API asynchronously
// api document: https://help.aliyun.com/api/imm/searchdocindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchDocIndexWithChan(request *SearchDocIndexRequest) (<-chan *SearchDocIndexResponse, <-chan error) {
	responseChan := make(chan *SearchDocIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchDocIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchDocIndexWithCallback invokes the imm.SearchDocIndex API asynchronously
// api document: https://help.aliyun.com/api/imm/searchdocindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchDocIndexWithCallback(request *SearchDocIndexRequest, callback func(response *SearchDocIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchDocIndexResponse
		var err error
		defer close(result)
		response, err = client.SearchDocIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchDocIndexRequest is the request struct for api SearchDocIndex
type SearchDocIndexRequest struct {
	*requests.RpcRequest
	ModifiedTimeEnd   requests.Integer `position:"Query" name:"ModifiedTimeEnd"`
	CustomKey1        string           `position:"Query" name:"CustomKey1"`
	Set               string           `position:"Query" name:"Set"`
	SizeLimitEnd      requests.Integer `position:"Query" name:"SizeLimitEnd"`
	CustomKey5        string           `position:"Query" name:"CustomKey5"`
	Offset            requests.Integer `position:"Query" name:"Offset"`
	CustomKey4        string           `position:"Query" name:"CustomKey4"`
	CustomKey3        string           `position:"Query" name:"CustomKey3"`
	CustomKey2        string           `position:"Query" name:"CustomKey2"`
	Project           string           `position:"Query" name:"Project"`
	ModifiedTimeStart requests.Integer `position:"Query" name:"ModifiedTimeStart"`
	PageNumLimitStart requests.Integer `position:"Query" name:"PageNumLimitStart"`
	CustomKey6        string           `position:"Query" name:"CustomKey6"`
	Content           string           `position:"Query" name:"Content"`
	PageNumLimitEnd   requests.Integer `position:"Query" name:"PageNumLimitEnd"`
	ContentType       string           `position:"Query" name:"ContentType"`
	SizeLimitStart    requests.Integer `position:"Query" name:"SizeLimitStart"`
	Name              string           `position:"Query" name:"Name"`
	Limit             requests.Integer `position:"Query" name:"Limit"`
}

// SearchDocIndexResponse is the response struct for api SearchDocIndex
type SearchDocIndexResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	DocInfos  []DocInfosItem `json:"DocInfos" xml:"DocInfos"`
}

// CreateSearchDocIndexRequest creates a request to invoke SearchDocIndex API
func CreateSearchDocIndexRequest() (request *SearchDocIndexRequest) {
	request = &SearchDocIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "SearchDocIndex", "imm", "openAPI")
	return
}

// CreateSearchDocIndexResponse creates a response to parse from SearchDocIndex response
func CreateSearchDocIndexResponse() (response *SearchDocIndexResponse) {
	response = &SearchDocIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
