package linkface

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAuthentication invokes the linkface.QueryAuthentication API synchronously
// api document: https://help.aliyun.com/api/linkface/queryauthentication.html
func (client *Client) QueryAuthentication(request *QueryAuthenticationRequest) (response *QueryAuthenticationResponse, err error) {
	response = CreateQueryAuthenticationResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAuthenticationWithChan invokes the linkface.QueryAuthentication API asynchronously
// api document: https://help.aliyun.com/api/linkface/queryauthentication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAuthenticationWithChan(request *QueryAuthenticationRequest) (<-chan *QueryAuthenticationResponse, <-chan error) {
	responseChan := make(chan *QueryAuthenticationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAuthentication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAuthenticationWithCallback invokes the linkface.QueryAuthentication API asynchronously
// api document: https://help.aliyun.com/api/linkface/queryauthentication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAuthenticationWithCallback(request *QueryAuthenticationRequest, callback func(response *QueryAuthenticationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAuthenticationResponse
		var err error
		defer close(result)
		response, err = client.QueryAuthentication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAuthenticationRequest is the request struct for api QueryAuthentication
type QueryAuthenticationRequest struct {
	*requests.RpcRequest
	LicenseType requests.Integer `position:"Body" name:"LicenseType"`
	IotId       string           `position:"Body" name:"IotId"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	DeviceName  string           `position:"Body" name:"DeviceName"`
	ProductKey  string           `position:"Body" name:"ProductKey"`
}

// QueryAuthenticationResponse is the response struct for api QueryAuthentication
type QueryAuthenticationResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	PageCount int        `json:"PageCount" xml:"PageCount"`
	PageSize  int        `json:"PageSize" xml:"PageSize"`
	Page      int        `json:"Page" xml:"Page"`
	Total     int        `json:"Total" xml:"Total"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryAuthenticationRequest creates a request to invoke QueryAuthentication API
func CreateQueryAuthenticationRequest() (request *QueryAuthenticationRequest) {
	request = &QueryAuthenticationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkFace", "2018-07-20", "QueryAuthentication", "", "")
	return
}

// CreateQueryAuthenticationResponse creates a response to parse from QueryAuthentication response
func CreateQueryAuthenticationResponse() (response *QueryAuthenticationResponse) {
	response = &QueryAuthenticationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
