package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActions invokes the oos.ListActions API synchronously
// api document: https://help.aliyun.com/api/oos/listactions.html
func (client *Client) ListActions(request *ListActionsRequest) (response *ListActionsResponse, err error) {
	response = CreateListActionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListActionsWithChan invokes the oos.ListActions API asynchronously
// api document: https://help.aliyun.com/api/oos/listactions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActionsWithChan(request *ListActionsRequest) (<-chan *ListActionsResponse, <-chan error) {
	responseChan := make(chan *ListActionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActionsWithCallback invokes the oos.ListActions API asynchronously
// api document: https://help.aliyun.com/api/oos/listactions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActionsWithCallback(request *ListActionsRequest, callback func(response *ListActionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActionsResponse
		var err error
		defer close(result)
		response, err = client.ListActions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActionsRequest is the request struct for api ListActions
type ListActionsRequest struct {
	*requests.RpcRequest
	NextToken     string           `position:"Query" name:"NextToken"`
	MaxResults    requests.Integer `position:"Query" name:"MaxResults"`
	OOSActionName string           `position:"Query" name:"OOSActionName"`
}

// ListActionsResponse is the response struct for api ListActions
type ListActionsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	MaxResults int      `json:"MaxResults" xml:"MaxResults"`
	NextToken  string   `json:"NextToken" xml:"NextToken"`
	Actions    []Action `json:"Actions" xml:"Actions"`
}

// CreateListActionsRequest creates a request to invoke ListActions API
func CreateListActionsRequest() (request *ListActionsRequest) {
	request = &ListActionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListActions", "oos", "openAPI")
	return
}

// CreateListActionsResponse creates a response to parse from ListActions response
func CreateListActionsResponse() (response *ListActionsResponse) {
	response = &ListActionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
