package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAnalysisSlsIndex invokes the aegis.DescribeAnalysisSlsIndex API synchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisslsindex.html
func (client *Client) DescribeAnalysisSlsIndex(request *DescribeAnalysisSlsIndexRequest) (response *DescribeAnalysisSlsIndexResponse, err error) {
	response = CreateDescribeAnalysisSlsIndexResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAnalysisSlsIndexWithChan invokes the aegis.DescribeAnalysisSlsIndex API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisslsindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAnalysisSlsIndexWithChan(request *DescribeAnalysisSlsIndexRequest) (<-chan *DescribeAnalysisSlsIndexResponse, <-chan error) {
	responseChan := make(chan *DescribeAnalysisSlsIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAnalysisSlsIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAnalysisSlsIndexWithCallback invokes the aegis.DescribeAnalysisSlsIndex API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeanalysisslsindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAnalysisSlsIndexWithCallback(request *DescribeAnalysisSlsIndexRequest, callback func(response *DescribeAnalysisSlsIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAnalysisSlsIndexResponse
		var err error
		defer close(result)
		response, err = client.DescribeAnalysisSlsIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAnalysisSlsIndexRequest is the request struct for api DescribeAnalysisSlsIndex
type DescribeAnalysisSlsIndexRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeAnalysisSlsIndexResponse is the response struct for api DescribeAnalysisSlsIndex
type DescribeAnalysisSlsIndexResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	SlsIndex  SlsIndex `json:"SlsIndex" xml:"SlsIndex"`
}

// CreateDescribeAnalysisSlsIndexRequest creates a request to invoke DescribeAnalysisSlsIndex API
func CreateDescribeAnalysisSlsIndexRequest() (request *DescribeAnalysisSlsIndexRequest) {
	request = &DescribeAnalysisSlsIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeAnalysisSlsIndex", "vipaegis", "openAPI")
	return
}

// CreateDescribeAnalysisSlsIndexResponse creates a response to parse from DescribeAnalysisSlsIndex response
func CreateDescribeAnalysisSlsIndexResponse() (response *DescribeAnalysisSlsIndexResponse) {
	response = &DescribeAnalysisSlsIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
