package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadLog invokes the aegis.DownloadLog API synchronously
// api document: https://help.aliyun.com/api/aegis/downloadlog.html
func (client *Client) DownloadLog(request *DownloadLogRequest) (response *DownloadLogResponse, err error) {
	response = CreateDownloadLogResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadLogWithChan invokes the aegis.DownloadLog API asynchronously
// api document: https://help.aliyun.com/api/aegis/downloadlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadLogWithChan(request *DownloadLogRequest) (<-chan *DownloadLogResponse, <-chan error) {
	responseChan := make(chan *DownloadLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadLogWithCallback invokes the aegis.DownloadLog API asynchronously
// api document: https://help.aliyun.com/api/aegis/downloadlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadLogWithCallback(request *DownloadLogRequest, callback func(response *DownloadLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadLogResponse
		var err error
		defer close(result)
		response, err = client.DownloadLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadLogRequest is the request struct for api DownloadLog
type DownloadLogRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	Query     string `position:"Query" name:"Query"`
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
}

// DownloadLogResponse is the response struct for api DownloadLog
type DownloadLogResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	Suppressed []string         `json:"Suppressed" xml:"Suppressed"`
	StackTrace []StackTraceItem `json:"StackTrace" xml:"StackTrace"`
}

// CreateDownloadLogRequest creates a request to invoke DownloadLog API
func CreateDownloadLogRequest() (request *DownloadLogRequest) {
	request = &DownloadLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DownloadLog", "vipaegis", "openAPI")
	return
}

// CreateDownloadLogResponse creates a response to parse from DownloadLog response
func CreateDownloadLogResponse() (response *DownloadLogResponse) {
	response = &DownloadLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
