package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HeadquartersToolsCoincide invokes the cloudwf.HeadquartersToolsCoincide API synchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolscoincide.html
func (client *Client) HeadquartersToolsCoincide(request *HeadquartersToolsCoincideRequest) (response *HeadquartersToolsCoincideResponse, err error) {
	response = CreateHeadquartersToolsCoincideResponse()
	err = client.DoAction(request, response)
	return
}

// HeadquartersToolsCoincideWithChan invokes the cloudwf.HeadquartersToolsCoincide API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolscoincide.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersToolsCoincideWithChan(request *HeadquartersToolsCoincideRequest) (<-chan *HeadquartersToolsCoincideResponse, <-chan error) {
	responseChan := make(chan *HeadquartersToolsCoincideResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HeadquartersToolsCoincide(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HeadquartersToolsCoincideWithCallback invokes the cloudwf.HeadquartersToolsCoincide API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstoolscoincide.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersToolsCoincideWithCallback(request *HeadquartersToolsCoincideRequest, callback func(response *HeadquartersToolsCoincideResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HeadquartersToolsCoincideResponse
		var err error
		defer close(result)
		response, err = client.HeadquartersToolsCoincide(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HeadquartersToolsCoincideRequest is the request struct for api HeadquartersToolsCoincide
type HeadquartersToolsCoincideRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// HeadquartersToolsCoincideResponse is the response struct for api HeadquartersToolsCoincide
type HeadquartersToolsCoincideResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateHeadquartersToolsCoincideRequest creates a request to invoke HeadquartersToolsCoincide API
func CreateHeadquartersToolsCoincideRequest() (request *HeadquartersToolsCoincideRequest) {
	request = &HeadquartersToolsCoincideRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "HeadquartersToolsCoincide", "cloudwf", "openAPI")
	return
}

// CreateHeadquartersToolsCoincideResponse creates a response to parse from HeadquartersToolsCoincide response
func CreateHeadquartersToolsCoincideResponse() (response *HeadquartersToolsCoincideResponse) {
	response = &HeadquartersToolsCoincideResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
