package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunETLJob invokes the emr.RunETLJob API synchronously
// api document: https://help.aliyun.com/api/emr/runetljob.html
func (client *Client) RunETLJob(request *RunETLJobRequest) (response *RunETLJobResponse, err error) {
	response = CreateRunETLJobResponse()
	err = client.DoAction(request, response)
	return
}

// RunETLJobWithChan invokes the emr.RunETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/runetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunETLJobWithChan(request *RunETLJobRequest) (<-chan *RunETLJobResponse, <-chan error) {
	responseChan := make(chan *RunETLJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunETLJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunETLJobWithCallback invokes the emr.RunETLJob API asynchronously
// api document: https://help.aliyun.com/api/emr/runetljob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RunETLJobWithCallback(request *RunETLJobRequest, callback func(response *RunETLJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunETLJobResponse
		var err error
		defer close(result)
		response, err = client.RunETLJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunETLJobRequest is the request struct for api RunETLJob
type RunETLJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId  requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	InstanceRunParam *[]RunETLJobInstanceRunParam `position:"Query" name:"InstanceRunParam"  type:"Repeated"`
	IsDebug          requests.Boolean             `position:"Query" name:"IsDebug"`
	Id               string                       `position:"Query" name:"Id"`
}

// RunETLJobInstanceRunParam is a repeated param struct in RunETLJobRequest
type RunETLJobInstanceRunParam struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// RunETLJobResponse is the response struct for api RunETLJob
type RunETLJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
}

// CreateRunETLJobRequest creates a request to invoke RunETLJob API
func CreateRunETLJobRequest() (request *RunETLJobRequest) {
	request = &RunETLJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RunETLJob", "emr", "openAPI")
	return
}

// CreateRunETLJobResponse creates a response to parse from RunETLJob response
func CreateRunETLJobResponse() (response *RunETLJobResponse) {
	response = &RunETLJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
