package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLiveStreamDelayConfig invokes the live.SetLiveStreamDelayConfig API synchronously
// api document: https://help.aliyun.com/api/live/setlivestreamdelayconfig.html
func (client *Client) SetLiveStreamDelayConfig(request *SetLiveStreamDelayConfigRequest) (response *SetLiveStreamDelayConfigResponse, err error) {
	response = CreateSetLiveStreamDelayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetLiveStreamDelayConfigWithChan invokes the live.SetLiveStreamDelayConfig API asynchronously
// api document: https://help.aliyun.com/api/live/setlivestreamdelayconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLiveStreamDelayConfigWithChan(request *SetLiveStreamDelayConfigRequest) (<-chan *SetLiveStreamDelayConfigResponse, <-chan error) {
	responseChan := make(chan *SetLiveStreamDelayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLiveStreamDelayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLiveStreamDelayConfigWithCallback invokes the live.SetLiveStreamDelayConfig API asynchronously
// api document: https://help.aliyun.com/api/live/setlivestreamdelayconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLiveStreamDelayConfigWithCallback(request *SetLiveStreamDelayConfigRequest, callback func(response *SetLiveStreamDelayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLiveStreamDelayConfigResponse
		var err error
		defer close(result)
		response, err = client.SetLiveStreamDelayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLiveStreamDelayConfigRequest is the request struct for api SetLiveStreamDelayConfig
type SetLiveStreamDelayConfigRequest struct {
	*requests.RpcRequest
	FlvLevel   string           `position:"Query" name:"FlvLevel"`
	HlsLevel   string           `position:"Query" name:"HlsLevel"`
	RtmpDelay  requests.Integer `position:"Query" name:"RtmpDelay"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	FlvDelay   requests.Integer `position:"Query" name:"FlvDelay"`
	RtmpLevel  string           `position:"Query" name:"RtmpLevel"`
	HlsDelay   requests.Integer `position:"Query" name:"HlsDelay"`
}

// SetLiveStreamDelayConfigResponse is the response struct for api SetLiveStreamDelayConfig
type SetLiveStreamDelayConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLiveStreamDelayConfigRequest creates a request to invoke SetLiveStreamDelayConfig API
func CreateSetLiveStreamDelayConfigRequest() (request *SetLiveStreamDelayConfigRequest) {
	request = &SetLiveStreamDelayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetLiveStreamDelayConfig", "live", "openAPI")
	return
}

// CreateSetLiveStreamDelayConfigResponse creates a response to parse from SetLiveStreamDelayConfig response
func CreateSetLiveStreamDelayConfigResponse() (response *SetLiveStreamDelayConfigResponse) {
	response = &SetLiveStreamDelayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
