package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMediaInfoJobList invokes the mts.QueryMediaInfoJobList API synchronously
// api document: https://help.aliyun.com/api/mts/querymediainfojoblist.html
func (client *Client) QueryMediaInfoJobList(request *QueryMediaInfoJobListRequest) (response *QueryMediaInfoJobListResponse, err error) {
	response = CreateQueryMediaInfoJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMediaInfoJobListWithChan invokes the mts.QueryMediaInfoJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/querymediainfojoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMediaInfoJobListWithChan(request *QueryMediaInfoJobListRequest) (<-chan *QueryMediaInfoJobListResponse, <-chan error) {
	responseChan := make(chan *QueryMediaInfoJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMediaInfoJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMediaInfoJobListWithCallback invokes the mts.QueryMediaInfoJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/querymediainfojoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMediaInfoJobListWithCallback(request *QueryMediaInfoJobListRequest, callback func(response *QueryMediaInfoJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMediaInfoJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryMediaInfoJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMediaInfoJobListRequest is the request struct for api QueryMediaInfoJobList
type QueryMediaInfoJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MediaInfoJobIds      string           `position:"Query" name:"MediaInfoJobIds"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryMediaInfoJobListResponse is the response struct for api QueryMediaInfoJobList
type QueryMediaInfoJobListResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	NonExistMediaInfoJobIds NonExistMediaInfoJobIds `json:"NonExistMediaInfoJobIds" xml:"NonExistMediaInfoJobIds"`
	MediaInfoJobList        MediaInfoJobList        `json:"MediaInfoJobList" xml:"MediaInfoJobList"`
}

// CreateQueryMediaInfoJobListRequest creates a request to invoke QueryMediaInfoJobList API
func CreateQueryMediaInfoJobListRequest() (request *QueryMediaInfoJobListRequest) {
	request = &QueryMediaInfoJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryMediaInfoJobList", "mts", "openAPI")
	return
}

// CreateQueryMediaInfoJobListResponse creates a response to parse from QueryMediaInfoJobList response
func CreateQueryMediaInfoJobListResponse() (response *QueryMediaInfoJobListResponse) {
	response = &QueryMediaInfoJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
