package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsInstanceCreate invokes the ons.OnsInstanceCreate API synchronously
// api document: https://help.aliyun.com/api/ons/onsinstancecreate.html
func (client *Client) OnsInstanceCreate(request *OnsInstanceCreateRequest) (response *OnsInstanceCreateResponse, err error) {
	response = CreateOnsInstanceCreateResponse()
	err = client.DoAction(request, response)
	return
}

// OnsInstanceCreateWithChan invokes the ons.OnsInstanceCreate API asynchronously
// api document: https://help.aliyun.com/api/ons/onsinstancecreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsInstanceCreateWithChan(request *OnsInstanceCreateRequest) (<-chan *OnsInstanceCreateResponse, <-chan error) {
	responseChan := make(chan *OnsInstanceCreateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsInstanceCreate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsInstanceCreateWithCallback invokes the ons.OnsInstanceCreate API asynchronously
// api document: https://help.aliyun.com/api/ons/onsinstancecreate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsInstanceCreateWithCallback(request *OnsInstanceCreateRequest, callback func(response *OnsInstanceCreateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsInstanceCreateResponse
		var err error
		defer close(result)
		response, err = client.OnsInstanceCreate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsInstanceCreateRequest is the request struct for api OnsInstanceCreate
type OnsInstanceCreateRequest struct {
	*requests.RpcRequest
	PreventCache requests.Integer `position:"Query" name:"PreventCache"`
	InstanceName string           `position:"Query" name:"InstanceName"`
	Remark       string           `position:"Query" name:"Remark"`
}

// OnsInstanceCreateResponse is the response struct for api OnsInstanceCreate
type OnsInstanceCreateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateOnsInstanceCreateRequest creates a request to invoke OnsInstanceCreate API
func CreateOnsInstanceCreateRequest() (request *OnsInstanceCreateRequest) {
	request = &OnsInstanceCreateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsInstanceCreate", "ons", "openAPI")
	return
}

// CreateOnsInstanceCreateResponse creates a response to parse from OnsInstanceCreate response
func CreateOnsInstanceCreateResponse() (response *OnsInstanceCreateResponse) {
	response = &OnsInstanceCreateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
