package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInviter invokes the baas.DescribeInviter API synchronously
// api document: https://help.aliyun.com/api/baas/describeinviter.html
func (client *Client) DescribeInviter(request *DescribeInviterRequest) (response *DescribeInviterResponse, err error) {
	response = CreateDescribeInviterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInviterWithChan invokes the baas.DescribeInviter API asynchronously
// api document: https://help.aliyun.com/api/baas/describeinviter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInviterWithChan(request *DescribeInviterRequest) (<-chan *DescribeInviterResponse, <-chan error) {
	responseChan := make(chan *DescribeInviterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInviter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInviterWithCallback invokes the baas.DescribeInviter API asynchronously
// api document: https://help.aliyun.com/api/baas/describeinviter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInviterWithCallback(request *DescribeInviterRequest, callback func(response *DescribeInviterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInviterResponse
		var err error
		defer close(result)
		response, err = client.DescribeInviter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInviterRequest is the request struct for api DescribeInviter
type DescribeInviterRequest struct {
	*requests.RpcRequest
	Code string `position:"Body" name:"Code"`
}

// DescribeInviterResponse is the response struct for api DescribeInviter
type DescribeInviterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeInviterRequest creates a request to invoke DescribeInviter API
func CreateDescribeInviterRequest() (request *DescribeInviterRequest) {
	request = &DescribeInviterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeInviter", "", "")
	return
}

// CreateDescribeInviterResponse creates a response to parse from DescribeInviter response
func CreateDescribeInviterResponse() (response *DescribeInviterResponse) {
	response = &DescribeInviterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
