package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TrainProject invokes the ivision.TrainProject API synchronously
// api document: https://help.aliyun.com/api/ivision/trainproject.html
func (client *Client) TrainProject(request *TrainProjectRequest) (response *TrainProjectResponse, err error) {
	response = CreateTrainProjectResponse()
	err = client.DoAction(request, response)
	return
}

// TrainProjectWithChan invokes the ivision.TrainProject API asynchronously
// api document: https://help.aliyun.com/api/ivision/trainproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TrainProjectWithChan(request *TrainProjectRequest) (<-chan *TrainProjectResponse, <-chan error) {
	responseChan := make(chan *TrainProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TrainProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TrainProjectWithCallback invokes the ivision.TrainProject API asynchronously
// api document: https://help.aliyun.com/api/ivision/trainproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TrainProjectWithCallback(request *TrainProjectRequest, callback func(response *TrainProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TrainProjectResponse
		var err error
		defer close(result)
		response, err = client.TrainProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TrainProjectRequest is the request struct for api TrainProject
type TrainProjectRequest struct {
	*requests.RpcRequest
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// TrainProjectResponse is the response struct for api TrainProject
type TrainProjectResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	IterationId string `json:"IterationId" xml:"IterationId"`
}

// CreateTrainProjectRequest creates a request to invoke TrainProject API
func CreateTrainProjectRequest() (request *TrainProjectRequest) {
	request = &TrainProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "TrainProject", "ivision", "openAPI")
	return
}

// CreateTrainProjectResponse creates a response to parse from TrainProject response
func CreateTrainProjectResponse() (response *TrainProjectResponse) {
	response = &TrainProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
