package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePredictDatas invokes the ivision.DescribePredictDatas API synchronously
// api document: https://help.aliyun.com/api/ivision/describepredictdatas.html
func (client *Client) DescribePredictDatas(request *DescribePredictDatasRequest) (response *DescribePredictDatasResponse, err error) {
	response = CreateDescribePredictDatasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePredictDatasWithChan invokes the ivision.DescribePredictDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/describepredictdatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePredictDatasWithChan(request *DescribePredictDatasRequest) (<-chan *DescribePredictDatasResponse, <-chan error) {
	responseChan := make(chan *DescribePredictDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePredictDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePredictDatasWithCallback invokes the ivision.DescribePredictDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/describepredictdatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePredictDatasWithCallback(request *DescribePredictDatasRequest, callback func(response *DescribePredictDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePredictDatasResponse
		var err error
		defer close(result)
		response, err = client.DescribePredictDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePredictDatasRequest is the request struct for api DescribePredictDatas
type DescribePredictDatasRequest struct {
	*requests.RpcRequest
	NextPageToken        string           `position:"Query" name:"NextPageToken"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ProbabilityThreshold string           `position:"Query" name:"ProbabilityThreshold"`
	OverlapThreshold     string           `position:"Query" name:"OverlapThreshold"`
	ProjectId            string           `position:"Query" name:"ProjectId"`
	ShowLog              string           `position:"Query" name:"ShowLog"`
	ModelId              string           `position:"Query" name:"ModelId"`
	TagId                string           `position:"Query" name:"TagId"`
	CurrentPage          requests.Integer `position:"Query" name:"CurrentPage"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IterationId          string           `position:"Query" name:"IterationId"`
}

// DescribePredictDatasResponse is the response struct for api DescribePredictDatas
type DescribePredictDatasResponse struct {
	*responses.BaseResponse
	RequestId     string                             `json:"RequestId" xml:"RequestId"`
	TotalNum      int                                `json:"TotalNum" xml:"TotalNum"`
	CurrentPage   int                                `json:"CurrentPage" xml:"CurrentPage"`
	PageSize      int                                `json:"PageSize" xml:"PageSize"`
	NextPageToken string                             `json:"NextPageToken" xml:"NextPageToken"`
	PredictDatas  PredictDatasInDescribePredictDatas `json:"PredictDatas" xml:"PredictDatas"`
}

// CreateDescribePredictDatasRequest creates a request to invoke DescribePredictDatas API
func CreateDescribePredictDatasRequest() (request *DescribePredictDatasRequest) {
	request = &DescribePredictDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribePredictDatas", "ivision", "openAPI")
	return
}

// CreateDescribePredictDatasResponse creates a response to parse from DescribePredictDatas response
func CreateDescribePredictDatasResponse() (response *DescribePredictDatasResponse) {
	response = &DescribePredictDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
