package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutionLogs invokes the oos.ListExecutionLogs API synchronously
// api document: https://help.aliyun.com/api/oos/listexecutionlogs.html
func (client *Client) ListExecutionLogs(request *ListExecutionLogsRequest) (response *ListExecutionLogsResponse, err error) {
	response = CreateListExecutionLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutionLogsWithChan invokes the oos.ListExecutionLogs API asynchronously
// api document: https://help.aliyun.com/api/oos/listexecutionlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionLogsWithChan(request *ListExecutionLogsRequest) (<-chan *ListExecutionLogsResponse, <-chan error) {
	responseChan := make(chan *ListExecutionLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutionLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutionLogsWithCallback invokes the oos.ListExecutionLogs API asynchronously
// api document: https://help.aliyun.com/api/oos/listexecutionlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionLogsWithCallback(request *ListExecutionLogsRequest, callback func(response *ListExecutionLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutionLogsResponse
		var err error
		defer close(result)
		response, err = client.ListExecutionLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutionLogsRequest is the request struct for api ListExecutionLogs
type ListExecutionLogsRequest struct {
	*requests.RpcRequest
	ExecutionId string           `position:"Query" name:"ExecutionId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// ListExecutionLogsResponse is the response struct for api ListExecutionLogs
type ListExecutionLogsResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	MaxResults    int            `json:"MaxResults" xml:"MaxResults"`
	NextToken     string         `json:"NextToken" xml:"NextToken"`
	ExecutionLogs []ExecutionLog `json:"ExecutionLogs" xml:"ExecutionLogs"`
}

// CreateListExecutionLogsRequest creates a request to invoke ListExecutionLogs API
func CreateListExecutionLogsRequest() (request *ListExecutionLogsRequest) {
	request = &ListExecutionLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListExecutionLogs", "oos", "openAPI")
	return
}

// CreateListExecutionLogsResponse creates a response to parse from ListExecutionLogs response
func CreateListExecutionLogsResponse() (response *ListExecutionLogsResponse) {
	response = &ListExecutionLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
