package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddNumberToSkillGroup invokes the ccc.AddNumberToSkillGroup API synchronously
// api document: https://help.aliyun.com/api/ccc/addnumbertoskillgroup.html
func (client *Client) AddNumberToSkillGroup(request *AddNumberToSkillGroupRequest) (response *AddNumberToSkillGroupResponse, err error) {
	response = CreateAddNumberToSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddNumberToSkillGroupWithChan invokes the ccc.AddNumberToSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/addnumbertoskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNumberToSkillGroupWithChan(request *AddNumberToSkillGroupRequest) (<-chan *AddNumberToSkillGroupResponse, <-chan error) {
	responseChan := make(chan *AddNumberToSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddNumberToSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddNumberToSkillGroupWithCallback invokes the ccc.AddNumberToSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/addnumbertoskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNumberToSkillGroupWithCallback(request *AddNumberToSkillGroupRequest, callback func(response *AddNumberToSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddNumberToSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.AddNumberToSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddNumberToSkillGroupRequest is the request struct for api AddNumberToSkillGroup
type AddNumberToSkillGroupRequest struct {
	*requests.RpcRequest
	Number       string `position:"Query" name:"Number"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
}

// AddNumberToSkillGroupResponse is the response struct for api AddNumberToSkillGroup
type AddNumberToSkillGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAddNumberToSkillGroupRequest creates a request to invoke AddNumberToSkillGroup API
func CreateAddNumberToSkillGroupRequest() (request *AddNumberToSkillGroupRequest) {
	request = &AddNumberToSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "AddNumberToSkillGroup", "", "")
	return
}

// CreateAddNumberToSkillGroupResponse creates a response to parse from AddNumberToSkillGroup response
func CreateAddNumberToSkillGroupResponse() (response *AddNumberToSkillGroupResponse) {
	response = &AddNumberToSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
