package synapse

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/synapse/mgmt/2019-06-01-preview/synapse"

// ActualState enumerates the values for actual state.
type ActualState string

const (
	// Disabled ...
	Disabled ActualState = "Disabled"
	// Disabling ...
	Disabling ActualState = "Disabling"
	// Enabled ...
	Enabled ActualState = "Enabled"
	// Enabling ...
	Enabling ActualState = "Enabling"
	// Unknown ...
	Unknown ActualState = "Unknown"
)

// PossibleActualStateValues returns an array of possible values for the ActualState const type.
func PossibleActualStateValues() []ActualState {
	return []ActualState{Disabled, Disabling, Enabled, Enabling, Unknown}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// ColumnDataType enumerates the values for column data type.
type ColumnDataType string

const (
	// Bigint ...
	Bigint ColumnDataType = "bigint"
	// Binary ...
	Binary ColumnDataType = "binary"
	// Bit ...
	Bit ColumnDataType = "bit"
	// Char ...
	Char ColumnDataType = "char"
	// Date ...
	Date ColumnDataType = "date"
	// Datetime ...
	Datetime ColumnDataType = "datetime"
	// Datetime2 ...
	Datetime2 ColumnDataType = "datetime2"
	// Datetimeoffset ...
	Datetimeoffset ColumnDataType = "datetimeoffset"
	// Decimal ...
	Decimal ColumnDataType = "decimal"
	// Float ...
	Float ColumnDataType = "float"
	// Geography ...
	Geography ColumnDataType = "geography"
	// Geometry ...
	Geometry ColumnDataType = "geometry"
	// Hierarchyid ...
	Hierarchyid ColumnDataType = "hierarchyid"
	// Image ...
	Image ColumnDataType = "image"
	// Int ...
	Int ColumnDataType = "int"
	// Money ...
	Money ColumnDataType = "money"
	// Nchar ...
	Nchar ColumnDataType = "nchar"
	// Ntext ...
	Ntext ColumnDataType = "ntext"
	// Numeric ...
	Numeric ColumnDataType = "numeric"
	// Nvarchar ...
	Nvarchar ColumnDataType = "nvarchar"
	// Real ...
	Real ColumnDataType = "real"
	// Smalldatetime ...
	Smalldatetime ColumnDataType = "smalldatetime"
	// Smallint ...
	Smallint ColumnDataType = "smallint"
	// Smallmoney ...
	Smallmoney ColumnDataType = "smallmoney"
	// SQLVariant ...
	SQLVariant ColumnDataType = "sql_variant"
	// Sysname ...
	Sysname ColumnDataType = "sysname"
	// Text ...
	Text ColumnDataType = "text"
	// Time ...
	Time ColumnDataType = "time"
	// Timestamp ...
	Timestamp ColumnDataType = "timestamp"
	// Tinyint ...
	Tinyint ColumnDataType = "tinyint"
	// Uniqueidentifier ...
	Uniqueidentifier ColumnDataType = "uniqueidentifier"
	// Varbinary ...
	Varbinary ColumnDataType = "varbinary"
	// Varchar ...
	Varchar ColumnDataType = "varchar"
	// XML ...
	XML ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns an array of possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{Bigint, Binary, Bit, Char, Date, Datetime, Datetime2, Datetimeoffset, Decimal, Float, Geography, Geometry, Hierarchyid, Image, Int, Money, Nchar, Ntext, Numeric, Nvarchar, Real, Smalldatetime, Smallint, Smallmoney, SQLVariant, Sysname, Text, Time, Timestamp, Tinyint, Uniqueidentifier, Varbinary, Varchar, XML}
}

// DesiredState enumerates the values for desired state.
type DesiredState string

const (
	// DesiredStateDisabled ...
	DesiredStateDisabled DesiredState = "Disabled"
	// DesiredStateEnabled ...
	DesiredStateEnabled DesiredState = "Enabled"
)

// PossibleDesiredStateValues returns an array of possible values for the DesiredState const type.
func PossibleDesiredStateValues() []DesiredState {
	return []DesiredState{DesiredStateDisabled, DesiredStateEnabled}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// CancelInProgress ...
	CancelInProgress ManagementOperationState = "CancelInProgress"
	// Cancelled ...
	Cancelled ManagementOperationState = "Cancelled"
	// Failed ...
	Failed ManagementOperationState = "Failed"
	// InProgress ...
	InProgress ManagementOperationState = "InProgress"
	// Pending ...
	Pending ManagementOperationState = "Pending"
	// Succeeded ...
	Succeeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{CancelInProgress, Cancelled, Failed, InProgress, Pending, Succeeded}
}

// NodeSize enumerates the values for node size.
type NodeSize string

const (
	// Large ...
	Large NodeSize = "Large"
	// Medium ...
	Medium NodeSize = "Medium"
	// None ...
	None NodeSize = "None"
	// Small ...
	Small NodeSize = "Small"
)

// PossibleNodeSizeValues returns an array of possible values for the NodeSize const type.
func PossibleNodeSizeValues() []NodeSize {
	return []NodeSize{Large, Medium, None, Small}
}

// NodeSizeFamily enumerates the values for node size family.
type NodeSizeFamily string

const (
	// NodeSizeFamilyMemoryOptimized ...
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = "MemoryOptimized"
	// NodeSizeFamilyNone ...
	NodeSizeFamilyNone NodeSizeFamily = "None"
)

// PossibleNodeSizeFamilyValues returns an array of possible values for the NodeSizeFamily const type.
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return []NodeSizeFamily{NodeSizeFamilyMemoryOptimized, NodeSizeFamilyNone}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCanceled ...
	OperationStatusCanceled OperationStatus = "Canceled"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCanceled, OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleteError ...
	ProvisioningStateDeleteError ProvisioningState = "DeleteError"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleteError, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// QueryAggregationFunction enumerates the values for query aggregation function.
type QueryAggregationFunction string

const (
	// Avg ...
	Avg QueryAggregationFunction = "avg"
	// Max ...
	Max QueryAggregationFunction = "max"
	// Min ...
	Min QueryAggregationFunction = "min"
	// Sum ...
	Sum QueryAggregationFunction = "sum"
)

// PossibleQueryAggregationFunctionValues returns an array of possible values for the QueryAggregationFunction const type.
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return []QueryAggregationFunction{Avg, Max, Min, Sum}
}

// QueryExecutionType enumerates the values for query execution type.
type QueryExecutionType string

const (
	// Aborted ...
	Aborted QueryExecutionType = "aborted"
	// Any ...
	Any QueryExecutionType = "any"
	// Exception ...
	Exception QueryExecutionType = "exception"
	// Irregular ...
	Irregular QueryExecutionType = "irregular"
	// Regular ...
	Regular QueryExecutionType = "regular"
)

// PossibleQueryExecutionTypeValues returns an array of possible values for the QueryExecutionType const type.
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return []QueryExecutionType{Aborted, Any, Exception, Irregular, Regular}
}

// QueryMetricUnit enumerates the values for query metric unit.
type QueryMetricUnit string

const (
	// KB ...
	KB QueryMetricUnit = "KB"
	// Microseconds ...
	Microseconds QueryMetricUnit = "microseconds"
	// Percentage ...
	Percentage QueryMetricUnit = "percentage"
)

// PossibleQueryMetricUnitValues returns an array of possible values for the QueryMetricUnit const type.
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return []QueryMetricUnit{KB, Microseconds, Percentage}
}

// QueryObservedMetricType enumerates the values for query observed metric type.
type QueryObservedMetricType string

const (
	// CPU ...
	CPU QueryObservedMetricType = "cpu"
	// Duration ...
	Duration QueryObservedMetricType = "duration"
	// ExecutionCount ...
	ExecutionCount QueryObservedMetricType = "executionCount"
	// Io ...
	Io QueryObservedMetricType = "io"
	// Logio ...
	Logio QueryObservedMetricType = "logio"
)

// PossibleQueryObservedMetricTypeValues returns an array of possible values for the QueryObservedMetricType const type.
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return []QueryObservedMetricType{CPU, Duration, ExecutionCount, Io, Logio}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// Copy ...
	Copy ReplicationRole = "Copy"
	// NonReadableSecondary ...
	NonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// Primary ...
	Primary ReplicationRole = "Primary"
	// Secondary ...
	Secondary ReplicationRole = "Secondary"
	// Source ...
	Source ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{Copy, NonReadableSecondary, Primary, Secondary, Source}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// Default ...
	Default VulnerabilityAssessmentPolicyBaselineName = "default"
	// Master ...
	Master VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{Default, Master}
}

// VulnerabilityAssessmentScanState enumerates the values for vulnerability assessment scan state.
type VulnerabilityAssessmentScanState string

const (
	// VulnerabilityAssessmentScanStateFailed ...
	VulnerabilityAssessmentScanStateFailed VulnerabilityAssessmentScanState = "Failed"
	// VulnerabilityAssessmentScanStateFailedToRun ...
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	// VulnerabilityAssessmentScanStateInProgress ...
	VulnerabilityAssessmentScanStateInProgress VulnerabilityAssessmentScanState = "InProgress"
	// VulnerabilityAssessmentScanStatePassed ...
	VulnerabilityAssessmentScanStatePassed VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns an array of possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{VulnerabilityAssessmentScanStateFailed, VulnerabilityAssessmentScanStateFailedToRun, VulnerabilityAssessmentScanStateInProgress, VulnerabilityAssessmentScanStatePassed}
}

// VulnerabilityAssessmentScanTriggerType enumerates the values for vulnerability assessment scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	// OnDemand ...
	OnDemand VulnerabilityAssessmentScanTriggerType = "OnDemand"
	// Recurring ...
	Recurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns an array of possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{OnDemand, Recurring}
}

// AadAdminProperties workspace active directory administrator properties
type AadAdminProperties struct {
	// TenantID - Tenant ID of the workspace active directory administrator
	TenantID *string `json:"tenantId,omitempty"`
	// Login - Login of the workspace active directory administrator
	Login *string `json:"login,omitempty"`
	// AdministratorType - Workspace active directory administrator type
	AdministratorType *string `json:"administratorType,omitempty"`
	// Sid - Object ID of the workspace active directory administrator
	Sid *string `json:"sid,omitempty"`
}

// AutoPauseProperties auto-pausing properties of a Big Data pool powered by Apache Spark
type AutoPauseProperties struct {
	// DelayInMinutes - Number of minutes of idle time before the Big Data pool is automatically paused.
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`
	// Enabled - Whether auto-pausing is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`
}

// AutoScaleProperties auto-scaling properties of a Big Data pool powered by Apache Spark
type AutoScaleProperties struct {
	// MinNodeCount - The minimum number of nodes the Big Data pool can support.
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// Enabled - Whether automatic scaling is enabled for the Big Data pool.
	Enabled *bool `json:"enabled,omitempty"`
	// MaxNodeCount - The maximum number of nodes the Big Data pool can support.
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
}

// AvailableRpOperation an operation that is available in this resource provider
type AvailableRpOperation struct {
	// Display - Display properties of the operation
	Display *AvailableRpOperationDisplayInfo `json:"display,omitempty"`
	// IsDataAction - Whether this operation is a data action
	IsDataAction *string `json:"isDataAction,omitempty"`
	// Name - Operation name
	Name *string `json:"name,omitempty"`
	// OperationMetaPropertyInfo - Operation properties
	*OperationMetaPropertyInfo `json:"properties,omitempty"`
	// Origin - Operation origin
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableRpOperation.
func (aro AvailableRpOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aro.Display != nil {
		objectMap["display"] = aro.Display
	}
	if aro.IsDataAction != nil {
		objectMap["isDataAction"] = aro.IsDataAction
	}
	if aro.Name != nil {
		objectMap["name"] = aro.Name
	}
	if aro.OperationMetaPropertyInfo != nil {
		objectMap["properties"] = aro.OperationMetaPropertyInfo
	}
	if aro.Origin != nil {
		objectMap["origin"] = aro.Origin
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableRpOperation struct.
func (aro *AvailableRpOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "display":
			if v != nil {
				var display AvailableRpOperationDisplayInfo
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				aro.Display = &display
			}
		case "isDataAction":
			if v != nil {
				var isDataAction string
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				aro.IsDataAction = &isDataAction
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aro.Name = &name
			}
		case "properties":
			if v != nil {
				var operationMetaPropertyInfo OperationMetaPropertyInfo
				err = json.Unmarshal(*v, &operationMetaPropertyInfo)
				if err != nil {
					return err
				}
				aro.OperationMetaPropertyInfo = &operationMetaPropertyInfo
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				aro.Origin = &origin
			}
		}
	}

	return nil
}

// AvailableRpOperationDisplayInfo description of an available operation
type AvailableRpOperationDisplayInfo struct {
	// Description - Operation description
	Description *string `json:"description,omitempty"`
	// Resource - Resource type
	Resource *string `json:"resource,omitempty"`
	// Provider - Resource provider name
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
}

// AzureEntityResource the resource model definition for a Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// BigDataPoolPatchInfo properties patch for a Big Data pool
type BigDataPoolPatchInfo struct {
	// Tags - Updated tags for the Big Data pool
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BigDataPoolPatchInfo.
func (bdppi BigDataPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bdppi.Tags != nil {
		objectMap["tags"] = bdppi.Tags
	}
	return json.Marshal(objectMap)
}

// BigDataPoolResourceInfo a Big Data pool
type BigDataPoolResourceInfo struct {
	autorest.Response `json:"-"`
	// BigDataPoolResourceProperties - Big Data pool properties
	*BigDataPoolResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BigDataPoolResourceInfo.
func (bdpri BigDataPoolResourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bdpri.BigDataPoolResourceProperties != nil {
		objectMap["properties"] = bdpri.BigDataPoolResourceProperties
	}
	if bdpri.Tags != nil {
		objectMap["tags"] = bdpri.Tags
	}
	if bdpri.Location != nil {
		objectMap["location"] = bdpri.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BigDataPoolResourceInfo struct.
func (bdpri *BigDataPoolResourceInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bigDataPoolResourceProperties BigDataPoolResourceProperties
				err = json.Unmarshal(*v, &bigDataPoolResourceProperties)
				if err != nil {
					return err
				}
				bdpri.BigDataPoolResourceProperties = &bigDataPoolResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bdpri.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bdpri.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bdpri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bdpri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bdpri.Type = &typeVar
			}
		}
	}

	return nil
}

// BigDataPoolResourceInfoListResult collection of Big Data pool information
type BigDataPoolResourceInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of Big Data pools
	Value *[]BigDataPoolResourceInfo `json:"value,omitempty"`
}

// BigDataPoolResourceInfoListResultIterator provides access to a complete listing of
// BigDataPoolResourceInfo values.
type BigDataPoolResourceInfoListResultIterator struct {
	i    int
	page BigDataPoolResourceInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BigDataPoolResourceInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BigDataPoolResourceInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BigDataPoolResourceInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BigDataPoolResourceInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BigDataPoolResourceInfoListResultIterator) Response() BigDataPoolResourceInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BigDataPoolResourceInfoListResultIterator) Value() BigDataPoolResourceInfo {
	if !iter.page.NotDone() {
		return BigDataPoolResourceInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BigDataPoolResourceInfoListResultIterator type.
func NewBigDataPoolResourceInfoListResultIterator(page BigDataPoolResourceInfoListResultPage) BigDataPoolResourceInfoListResultIterator {
	return BigDataPoolResourceInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bdprilr BigDataPoolResourceInfoListResult) IsEmpty() bool {
	return bdprilr.Value == nil || len(*bdprilr.Value) == 0
}

// bigDataPoolResourceInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bdprilr BigDataPoolResourceInfoListResult) bigDataPoolResourceInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if bdprilr.NextLink == nil || len(to.String(bdprilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bdprilr.NextLink)))
}

// BigDataPoolResourceInfoListResultPage contains a page of BigDataPoolResourceInfo values.
type BigDataPoolResourceInfoListResultPage struct {
	fn      func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)
	bdprilr BigDataPoolResourceInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BigDataPoolResourceInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BigDataPoolResourceInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bdprilr)
	if err != nil {
		return err
	}
	page.bdprilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BigDataPoolResourceInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BigDataPoolResourceInfoListResultPage) NotDone() bool {
	return !page.bdprilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BigDataPoolResourceInfoListResultPage) Response() BigDataPoolResourceInfoListResult {
	return page.bdprilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BigDataPoolResourceInfoListResultPage) Values() []BigDataPoolResourceInfo {
	if page.bdprilr.IsEmpty() {
		return nil
	}
	return *page.bdprilr.Value
}

// Creates a new instance of the BigDataPoolResourceInfoListResultPage type.
func NewBigDataPoolResourceInfoListResultPage(getNextPage func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)) BigDataPoolResourceInfoListResultPage {
	return BigDataPoolResourceInfoListResultPage{fn: getNextPage}
}

// BigDataPoolResourceProperties properties of a Big Data pool powered by Apache Spark
type BigDataPoolResourceProperties struct {
	// ProvisioningState - The state of the Big Data pool.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// AutoScale - Auto-scaling properties
	AutoScale *AutoScaleProperties `json:"autoScale,omitempty"`
	// CreationDate - The time when the Big Data pool was created.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// AutoPause - Auto-pausing properties
	AutoPause *AutoPauseProperties `json:"autoPause,omitempty"`
	// SparkEventsFolder - The Spark events folder
	SparkEventsFolder *string `json:"sparkEventsFolder,omitempty"`
	// NodeCount - The number of nodes in the Big Data pool.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// LibraryRequirements - Library version requirements
	LibraryRequirements *LibraryRequirements `json:"libraryRequirements,omitempty"`
	// SparkVersion - The Apache Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`
	// DefaultSparkLogFolder - The default folder where Spark logs will be written.
	DefaultSparkLogFolder *string `json:"defaultSparkLogFolder,omitempty"`
	// NodeSize - The level of compute power that each node in the Big Data pool has. Possible values include: 'None', 'Small', 'Medium', 'Large'
	NodeSize NodeSize `json:"nodeSize,omitempty"`
	// NodeSizeFamily - The kind of nodes that the Big Data pool provides. Possible values include: 'NodeSizeFamilyNone', 'NodeSizeFamilyMemoryOptimized'
	NodeSizeFamily NodeSizeFamily `json:"nodeSizeFamily,omitempty"`
}

// BigDataPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BigDataPoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BigDataPoolsCreateOrUpdateFuture) Result(client BigDataPoolsClient) (bdpri BigDataPoolResourceInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.BigDataPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.BigDataPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bdpri.Response.Response, err = future.GetResult(sender); err == nil && bdpri.Response.Response.StatusCode != http.StatusNoContent {
		bdpri, err = client.CreateOrUpdateResponder(bdpri.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.BigDataPoolsCreateOrUpdateFuture", "Result", bdpri.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BigDataPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BigDataPoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BigDataPoolsDeleteFuture) Result(client BigDataPoolsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.BigDataPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.BigDataPoolsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.BigDataPoolsDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CheckNameAvailabilityRequest a request about whether a workspace name is available
type CheckNameAvailabilityRequest struct {
	// Name - Workspace name
	Name *string `json:"name,omitempty"`
	// Type - Type: workspace
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse a response saying whether the workspace name is available
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Message - Validation message
	Message *string `json:"message,omitempty"`
	// Available - Whether the workspace name is available
	Available *bool `json:"available,omitempty"`
	// Reason - Reason the workspace name is or is not available
	Reason *string `json:"reason,omitempty"`
	// Name - Workspace name
	Name *string `json:"name,omitempty"`
}

// CreateSQLPoolRestorePointDefinition contains the information necessary to perform a create Sql pool
// restore point operation.
type CreateSQLPoolRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// DataLakeStorageAccountDetails details of the data lake storage account associated with the workspace
type DataLakeStorageAccountDetails struct {
	// AccountURL - Account URL
	AccountURL *string `json:"accountUrl,omitempty"`
	// Filesystem - Filesystem name
	Filesystem *string `json:"filesystem,omitempty"`
}

// DataWarehouseUserActivities user activities of a data warehouse
type DataWarehouseUserActivities struct {
	autorest.Response `json:"-"`
	// DataWarehouseUserActivitiesProperties - Resource properties.
	*DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivities.
func (dwua DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwua.DataWarehouseUserActivitiesProperties != nil {
		objectMap["properties"] = dwua.DataWarehouseUserActivitiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataWarehouseUserActivities struct.
func (dwua *DataWarehouseUserActivities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataWarehouseUserActivitiesProperties DataWarehouseUserActivitiesProperties
				err = json.Unmarshal(*v, &dataWarehouseUserActivitiesProperties)
				if err != nil {
					return err
				}
				dwua.DataWarehouseUserActivitiesProperties = &dataWarehouseUserActivitiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dwua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dwua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dwua.Type = &typeVar
			}
		}
	}

	return nil
}

// DataWarehouseUserActivitiesProperties user activities of a data warehouse. This currently includes the
// count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests
// dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// ActiveQueriesCount - READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorContract contains details when the response code indicates an error.
type ErrorContract struct {
	// Error - The error details.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorDetail error details
type ErrorDetail struct {
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Target - Error target
	Target *string `json:"target,omitempty"`
}

// ErrorResponse the resource management error response.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// IPFirewallRuleInfo IP firewall rule
type IPFirewallRuleInfo struct {
	autorest.Response `json:"-"`
	// IPFirewallRuleProperties - IP firewall rule properties
	*IPFirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IPFirewallRuleInfo.
func (ifri IPFirewallRuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifri.IPFirewallRuleProperties != nil {
		objectMap["properties"] = ifri.IPFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPFirewallRuleInfo struct.
func (ifri *IPFirewallRuleInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPFirewallRuleProperties IPFirewallRuleProperties
				err = json.Unmarshal(*v, &IPFirewallRuleProperties)
				if err != nil {
					return err
				}
				ifri.IPFirewallRuleProperties = &IPFirewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifri.Type = &typeVar
			}
		}
	}

	return nil
}

// IPFirewallRuleInfoListResult list of IP firewall rules
type IPFirewallRuleInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of IP firewall rules
	Value *[]IPFirewallRuleInfo `json:"value,omitempty"`
}

// IPFirewallRuleInfoListResultIterator provides access to a complete listing of IPFirewallRuleInfo values.
type IPFirewallRuleInfoListResultIterator struct {
	i    int
	page IPFirewallRuleInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPFirewallRuleInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFirewallRuleInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IPFirewallRuleInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPFirewallRuleInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPFirewallRuleInfoListResultIterator) Response() IPFirewallRuleInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPFirewallRuleInfoListResultIterator) Value() IPFirewallRuleInfo {
	if !iter.page.NotDone() {
		return IPFirewallRuleInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IPFirewallRuleInfoListResultIterator type.
func NewIPFirewallRuleInfoListResultIterator(page IPFirewallRuleInfoListResultPage) IPFirewallRuleInfoListResultIterator {
	return IPFirewallRuleInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifrilr IPFirewallRuleInfoListResult) IsEmpty() bool {
	return ifrilr.Value == nil || len(*ifrilr.Value) == 0
}

// iPFirewallRuleInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifrilr IPFirewallRuleInfoListResult) iPFirewallRuleInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ifrilr.NextLink == nil || len(to.String(ifrilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifrilr.NextLink)))
}

// IPFirewallRuleInfoListResultPage contains a page of IPFirewallRuleInfo values.
type IPFirewallRuleInfoListResultPage struct {
	fn     func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)
	ifrilr IPFirewallRuleInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPFirewallRuleInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPFirewallRuleInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ifrilr)
	if err != nil {
		return err
	}
	page.ifrilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IPFirewallRuleInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPFirewallRuleInfoListResultPage) NotDone() bool {
	return !page.ifrilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPFirewallRuleInfoListResultPage) Response() IPFirewallRuleInfoListResult {
	return page.ifrilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPFirewallRuleInfoListResultPage) Values() []IPFirewallRuleInfo {
	if page.ifrilr.IsEmpty() {
		return nil
	}
	return *page.ifrilr.Value
}

// Creates a new instance of the IPFirewallRuleInfoListResultPage type.
func NewIPFirewallRuleInfoListResultPage(getNextPage func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)) IPFirewallRuleInfoListResultPage {
	return IPFirewallRuleInfoListResultPage{fn: getNextPage}
}

// IPFirewallRuleProperties IP firewall rule properties
type IPFirewallRuleProperties struct {
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
	EndIPAddress *string `json:"endIpAddress,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state. Possible values include: 'ProvisioningStateProvisioning', 'ProvisioningStateSucceeded', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateDeleteError'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// IPFirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IPFirewallRulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IPFirewallRulesCreateOrUpdateFuture) Result(client IPFirewallRulesClient) (ifri IPFirewallRuleInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.IPFirewallRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifri.Response.Response, err = future.GetResult(sender); err == nil && ifri.Response.Response.StatusCode != http.StatusNoContent {
		ifri, err = client.CreateOrUpdateResponder(ifri.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesCreateOrUpdateFuture", "Result", ifri.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IPFirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IPFirewallRulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IPFirewallRulesDeleteFuture) Result(client IPFirewallRulesClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.IPFirewallRulesDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IPFirewallRulesReplaceAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IPFirewallRulesReplaceAllFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IPFirewallRulesReplaceAllFuture) Result(client IPFirewallRulesClient) (rafror ReplaceAllFirewallRulesOperationResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesReplaceAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.IPFirewallRulesReplaceAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rafror.Response.Response, err = future.GetResult(sender); err == nil && rafror.Response.Response.StatusCode != http.StatusNoContent {
		rafror, err = client.ReplaceAllResponder(rafror.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.IPFirewallRulesReplaceAllFuture", "Result", rafror.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LibraryRequirements library requirements for a Big Data pool powered by Apache Spark
type LibraryRequirements struct {
	// Time - READ-ONLY; The last update time of the library requirements file.
	Time *date.Time `json:"time,omitempty"`
	// Content - The library requirements.
	Content *string `json:"content,omitempty"`
	// Filename - The filename of the library requirements file.
	Filename *string `json:"filename,omitempty"`
}

// ListAvailableRpOperation ...
type ListAvailableRpOperation struct {
	autorest.Response `json:"-"`
	Value             *[]AvailableRpOperation `json:"value,omitempty"`
}

// ManagedIdentity the workspace managed identity
type ManagedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the workspace managed identity
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the workspace managed identity
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of managed identity for the workspace. Possible values include: 'ResourceIdentityTypeNone', 'ResourceIdentityTypeSystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// ManagedIdentitySQLControlSettingsModel sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModel struct {
	autorest.Response `json:"-"`
	// ManagedIdentitySQLControlSettingsModelProperties - Sql Control Settings for workspace managed identity
	*ManagedIdentitySQLControlSettingsModelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIdentitySQLControlSettingsModel.
func (miscsm ManagedIdentitySQLControlSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miscsm.ManagedIdentitySQLControlSettingsModelProperties != nil {
		objectMap["properties"] = miscsm.ManagedIdentitySQLControlSettingsModelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedIdentitySQLControlSettingsModel struct.
func (miscsm *ManagedIdentitySQLControlSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedIdentitySQLControlSettingsModelProperties ManagedIdentitySQLControlSettingsModelProperties
				err = json.Unmarshal(*v, &managedIdentitySQLControlSettingsModelProperties)
				if err != nil {
					return err
				}
				miscsm.ManagedIdentitySQLControlSettingsModelProperties = &managedIdentitySQLControlSettingsModelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miscsm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miscsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miscsm.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedIdentitySQLControlSettingsModelProperties sql Control Settings for workspace managed identity
type ManagedIdentitySQLControlSettingsModelProperties struct {
	// GrantSQLControlToManagedIdentity - Grant sql control to managed identity
	GrantSQLControlToManagedIdentity *ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity `json:"grantSqlControlToManagedIdentity,omitempty"`
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity grant sql control to
// managed identity
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity struct {
	// DesiredState - Desired state. Possible values include: 'DesiredStateEnabled', 'DesiredStateDisabled'
	DesiredState DesiredState `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Actual state. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Unknown'
	ActualState ActualState `json:"actualState,omitempty"`
}

// MetadataSyncConfig configuration for metadata sync
type MetadataSyncConfig struct {
	autorest.Response `json:"-"`
	// MetadataSyncConfigProperties - Metadata Sync Config properties
	*MetadataSyncConfigProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MetadataSyncConfig.
func (msc MetadataSyncConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msc.MetadataSyncConfigProperties != nil {
		objectMap["properties"] = msc.MetadataSyncConfigProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetadataSyncConfig struct.
func (msc *MetadataSyncConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var metadataSyncConfigProperties MetadataSyncConfigProperties
				err = json.Unmarshal(*v, &metadataSyncConfigProperties)
				if err != nil {
					return err
				}
				msc.MetadataSyncConfigProperties = &metadataSyncConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msc.Type = &typeVar
			}
		}
	}

	return nil
}

// MetadataSyncConfigProperties metadata Sync Config properties
type MetadataSyncConfigProperties struct {
	// Enabled - Indicates whether the metadata sync is enabled or disabled
	Enabled *bool `json:"enabled,omitempty"`
}

// OperationMetaLogSpecification what is this?
type OperationMetaLogSpecification struct {
	// DisplayName - Log display name
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Time range the log covers
	BlobDuration *string `json:"blobDuration,omitempty"`
	// Name - Log unique name
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricDimensionSpecification what is this?
type OperationMetaMetricDimensionSpecification struct {
	// DisplayName - Dimension display name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Dimension unique name
	Name *string `json:"name,omitempty"`
	// ToBeExportedForShoebox - Whether this metric should be exported for Shoebox
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// OperationMetaMetricSpecification what is this?
type OperationMetaMetricSpecification struct {
	// SourceMdmNamespace - The source MDM namespace
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
	// DisplayName - Metric display name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Metric unique name
	Name *string `json:"name,omitempty"`
	// AggregationType - Metric aggregation type
	AggregationType *string `json:"aggregationType,omitempty"`
	// DisplayDescription - Metric description
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// SourceMdmAccount - The source MDM account
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// EnableRegionalMdmAccount - Whether the regional MDM account is enabled
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`
	// Unit - Metric units
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Metric dimensions
	Dimensions *[]OperationMetaMetricDimensionSpecification `json:"dimensions,omitempty"`
	// SupportsInstanceLevelAggregation - Whether the metric supports instance-level aggregation
	SupportsInstanceLevelAggregation *bool `json:"supportsInstanceLevelAggregation,omitempty"`
	// MetricFilterPattern - Metric filter
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`
}

// OperationMetaPropertyInfo what is this?
type OperationMetaPropertyInfo struct {
	// ServiceSpecification - Operation service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationMetaServiceSpecification what is this?
type OperationMetaServiceSpecification struct {
	// MetricSpecifications - Service metric specifications
	MetricSpecifications *[]OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
	// LogSpecifications - Service log specifications
	LogSpecifications *[]OperationMetaLogSpecification `json:"logSpecifications,omitempty"`
}

// OperationResource an operation
type OperationResource struct {
	// ID - Operation ID
	ID *string `json:"id,omitempty"`
	// Name - Operation name
	Name *string `json:"name,omitempty"`
	// Status - Operation status. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed', 'OperationStatusCanceled'
	Status OperationStatus `json:"status,omitempty"`
	// Properties - Operation properties
	Properties interface{} `json:"properties,omitempty"`
	// Error - Errors from the operation
	Error *ErrorDetail `json:"error,omitempty"`
	// StartTime - Operation start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Operation start time
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - Completion percentage of the operation
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// QueryInterval a database query.
type QueryInterval struct {
	// IntervalStartTime - READ-ONLY; The start time of the measurement interval (ISO8601 format).
	IntervalStartTime *date.Time `json:"intervalStartTime,omitempty"`
	// ExecutionCount - READ-ONLY; The number of times the query was executed during this interval.
	ExecutionCount *float64 `json:"executionCount,omitempty"`
	// Metrics - READ-ONLY; The list of query metrics during this interval.
	Metrics *[]QueryMetric `json:"metrics,omitempty"`
}

// QueryMetric a database query.
type QueryMetric struct {
	// Name - READ-ONLY; The name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The name of the metric for display in user interface
	DisplayName *string `json:"displayName,omitempty"`
	// Unit - READ-ONLY; The unit of measurement. Possible values include: 'Percentage', 'KB', 'Microseconds'
	Unit QueryMetricUnit `json:"unit,omitempty"`
	// Value - READ-ONLY; The measured value
	Value *float64 `json:"value,omitempty"`
}

// QueryStatistic a database query.
type QueryStatistic struct {
	// QueryID - READ-ONLY; The id of the query
	QueryID *string `json:"queryId,omitempty"`
	// Intervals - READ-ONLY; The list of query intervals.
	Intervals *[]QueryInterval `json:"intervals,omitempty"`
}

// ReplaceAllFirewallRulesOperationResponse an existing operation for replacing the firewall rules
type ReplaceAllFirewallRulesOperationResponse struct {
	autorest.Response `json:"-"`
	// OperationID - The operation ID
	OperationID *string `json:"operationId,omitempty"`
}

// ReplaceAllIPFirewallRulesRequest replace all IP firewall rules request
type ReplaceAllIPFirewallRulesRequest struct {
	// IPFirewallRules - IP firewall rule properties
	IPFirewallRules map[string]*IPFirewallRuleProperties `json:"ipFirewallRules"`
}

// MarshalJSON is the custom marshaler for ReplaceAllIPFirewallRulesRequest.
func (raifrr ReplaceAllIPFirewallRulesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if raifrr.IPFirewallRules != nil {
		objectMap["ipFirewallRules"] = raifrr.IPFirewallRules
	}
	return json.Marshal(objectMap)
}

// ReplicationLink represents a Sql pool replication link.
type ReplicationLink struct {
	// Location - READ-ONLY; Location of the workspace that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List Sql pool replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Sql pool replication links housed in the Sql pool.
	Value *[]ReplicationLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationLinkListResultIterator provides access to a complete listing of ReplicationLink values.
type ReplicationLinkListResultIterator struct {
	i    int
	page ReplicationLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationLinkListResultIterator) Response() ReplicationLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationLinkListResultIterator) Value() ReplicationLink {
	if !iter.page.NotDone() {
		return ReplicationLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationLinkListResultIterator type.
func NewReplicationLinkListResultIterator(page ReplicationLinkListResultPage) ReplicationLinkListResultIterator {
	return ReplicationLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rllr ReplicationLinkListResult) IsEmpty() bool {
	return rllr.Value == nil || len(*rllr.Value) == 0
}

// replicationLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rllr ReplicationLinkListResult) replicationLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rllr.NextLink == nil || len(to.String(rllr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rllr.NextLink)))
}

// ReplicationLinkListResultPage contains a page of ReplicationLink values.
type ReplicationLinkListResultPage struct {
	fn   func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)
	rllr ReplicationLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rllr)
	if err != nil {
		return err
	}
	page.rllr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationLinkListResultPage) NotDone() bool {
	return !page.rllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationLinkListResultPage) Response() ReplicationLinkListResult {
	return page.rllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationLinkListResultPage) Values() []ReplicationLink {
	if page.rllr.IsEmpty() {
		return nil
	}
	return *page.rllr.Value
}

// Creates a new instance of the ReplicationLinkListResultPage type.
func NewReplicationLinkListResultPage(getNextPage func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)) ReplicationLinkListResultPage {
	return ReplicationLinkListResultPage{fn: getNextPage}
}

// ReplicationLinkProperties represents the properties of a Sql pool replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - READ-ONLY; Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - READ-ONLY; The name of the workspace hosting the partner Sql pool.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - READ-ONLY; The name of the partner Sql pool.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - READ-ONLY; The Azure Region of the partner Sql pool.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - READ-ONLY; The role of the Sql pool in the replication link. Possible values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source', 'Copy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - READ-ONLY; The role of the partner Sql pool in the replication link. Possible values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source', 'Copy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - READ-ONLY; The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - READ-ONLY; The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// ResourceMoveDefinition contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// ID - The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// RestorePoint database restore points.
type RestorePoint struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// RestorePointProperties - Resource properties.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult a list of long term retention backups.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorePoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointListResultIterator provides access to a complete listing of RestorePoint values.
type RestorePointListResultIterator struct {
	i    int
	page RestorePointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorePointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorePointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorePointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorePointListResultIterator) Response() RestorePointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorePointListResultIterator) Value() RestorePoint {
	if !iter.page.NotDone() {
		return RestorePoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorePointListResultIterator type.
func NewRestorePointListResultIterator(page RestorePointListResultPage) RestorePointListResultIterator {
	return RestorePointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rplr RestorePointListResult) IsEmpty() bool {
	return rplr.Value == nil || len(*rplr.Value) == 0
}

// restorePointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rplr RestorePointListResult) restorePointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rplr.NextLink == nil || len(to.String(rplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rplr.NextLink)))
}

// RestorePointListResultPage contains a page of RestorePoint values.
type RestorePointListResultPage struct {
	fn   func(context.Context, RestorePointListResult) (RestorePointListResult, error)
	rplr RestorePointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorePointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorePointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rplr)
	if err != nil {
		return err
	}
	page.rplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorePointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorePointListResultPage) NotDone() bool {
	return !page.rplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorePointListResultPage) Response() RestorePointListResult {
	return page.rplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorePointListResultPage) Values() []RestorePoint {
	if page.rplr.IsEmpty() {
		return nil
	}
	return *page.rplr.Value
}

// Creates a new instance of the RestorePointListResultPage type.
func NewRestorePointListResultPage(getNextPage func(context.Context, RestorePointListResult) (RestorePointListResult, error)) RestorePointListResultPage {
	return RestorePointListResultPage{fn: getNextPage}
}

// RestorePointProperties properties of a database restore point
type RestorePointProperties struct {
	// RestorePointType - READ-ONLY; The type of restore point. Possible values include: 'CONTINUOUS', 'DISCRETE'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// RestorePointCreationDate - READ-ONLY; The time the backup was taken
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// RestorePointLabel - READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific Sql pool. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// SensitivityLabel a sensitivity label.
type SensitivityLabel struct {
	autorest.Response `json:"-"`
	// SensitivityLabelProperties - Resource properties.
	*SensitivityLabelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabel.
func (sl SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.SensitivityLabelProperties != nil {
		objectMap["properties"] = sl.SensitivityLabelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SensitivityLabel struct.
func (sl *SensitivityLabel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sensitivityLabelProperties SensitivityLabelProperties
				err = json.Unmarshal(*v, &sensitivityLabelProperties)
				if err != nil {
					return err
				}
				sl.SensitivityLabelProperties = &sensitivityLabelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// SensitivityLabelListResult a list of sensitivity labels.
type SensitivityLabelListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SensitivityLabel `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SensitivityLabelListResultIterator provides access to a complete listing of SensitivityLabel values.
type SensitivityLabelListResultIterator struct {
	i    int
	page SensitivityLabelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SensitivityLabelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SensitivityLabelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SensitivityLabelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SensitivityLabelListResultIterator) Response() SensitivityLabelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SensitivityLabelListResultIterator) Value() SensitivityLabel {
	if !iter.page.NotDone() {
		return SensitivityLabel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SensitivityLabelListResultIterator type.
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return SensitivityLabelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr SensitivityLabelListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// sensitivityLabelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr SensitivityLabelListResult) sensitivityLabelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sllr.NextLink == nil || len(to.String(sllr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// SensitivityLabelListResultPage contains a page of SensitivityLabel values.
type SensitivityLabelListResultPage struct {
	fn   func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)
	sllr SensitivityLabelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SensitivityLabelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sllr)
	if err != nil {
		return err
	}
	page.sllr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SensitivityLabelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SensitivityLabelListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SensitivityLabelListResultPage) Response() SensitivityLabelListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SensitivityLabelListResultPage) Values() []SensitivityLabel {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the SensitivityLabelListResultPage type.
func NewSensitivityLabelListResultPage(getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return SensitivityLabelListResultPage{fn: getNextPage}
}

// SensitivityLabelProperties properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// LabelName - The label name.
	LabelName *string `json:"labelName,omitempty"`
	// LabelID - The label ID.
	LabelID *string `json:"labelId,omitempty"`
	// InformationType - The information type.
	InformationType *string `json:"informationType,omitempty"`
	// InformationTypeID - The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`
	// IsDisabled - READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Sku SQL pool SKU
type Sku struct {
	// Tier - The service tier
	Tier *string `json:"tier,omitempty"`
	// Name - The SKU name
	Name *string `json:"name,omitempty"`
}

// SQLPool a SQL Analytics pool
type SQLPool struct {
	autorest.Response `json:"-"`
	// Sku - SQL pool SKU
	Sku *Sku `json:"sku,omitempty"`
	// SQLPoolResourceProperties - SQL pool properties
	*SQLPoolResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPool.
func (sp SQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Sku != nil {
		objectMap["sku"] = sp.Sku
	}
	if sp.SQLPoolResourceProperties != nil {
		objectMap["properties"] = sp.SQLPoolResourceProperties
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	if sp.Location != nil {
		objectMap["location"] = sp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPool struct.
func (sp *SQLPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sp.Sku = &sku
			}
		case "properties":
			if v != nil {
				var SQLPoolResourceProperties SQLPoolResourceProperties
				err = json.Unmarshal(*v, &SQLPoolResourceProperties)
				if err != nil {
					return err
				}
				sp.SQLPoolResourceProperties = &SQLPoolResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolBlobAuditingPolicy a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// SQLPoolBlobAuditingPolicyProperties - Resource properties.
	*SQLPoolBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolBlobAuditingPolicy.
func (spbap SQLPoolBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spbap.SQLPoolBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = spbap.SQLPoolBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolBlobAuditingPolicy struct.
func (spbap *SQLPoolBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var SQLPoolBlobAuditingPolicyProperties SQLPoolBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &SQLPoolBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				spbap.SQLPoolBlobAuditingPolicyProperties = &SQLPoolBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spbap.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolBlobAuditingPolicyProperties properties of a Sql pool blob auditing policy.
type SQLPoolBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResult the response to a list Sql pool operations request
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator provides access to a complete listing of
// SQLPoolOperation values.
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator struct {
	i    int
	page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Response() SQLPoolBlobAuditingPolicySQLPoolOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator) Value() SQLPoolOperation {
	if !iter.page.NotDone() {
		return SQLPoolOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator type.
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator {
	return SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult) IsEmpty() bool {
	return spbapspolr.Value == nil || len(*spbapspolr.Value) == 0
}

// sQLPoolBlobAuditingPolicySQLPoolOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult) sQLPoolBlobAuditingPolicySQLPoolOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spbapspolr.NextLink == nil || len(to.String(spbapspolr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spbapspolr.NextLink)))
}

// SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage contains a page of SQLPoolOperation values.
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage struct {
	fn         func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)
	spbapspolr SQLPoolBlobAuditingPolicySQLPoolOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spbapspolr)
	if err != nil {
		return err
	}
	page.spbapspolr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) NotDone() bool {
	return !page.spbapspolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Response() SQLPoolBlobAuditingPolicySQLPoolOperationListResult {
	return page.spbapspolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) Values() []SQLPoolOperation {
	if page.spbapspolr.IsEmpty() {
		return nil
	}
	return *page.spbapspolr.Value
}

// Creates a new instance of the SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage type.
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(getNextPage func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)) SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage {
	return SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage{fn: getNextPage}
}

// SQLPoolColumn a Sql pool column resource.
type SQLPoolColumn struct {
	// SQLPoolColumnProperties - Resource properties.
	*SQLPoolColumnProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolColumn.
func (spc SQLPoolColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spc.SQLPoolColumnProperties != nil {
		objectMap["properties"] = spc.SQLPoolColumnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolColumn struct.
func (spc *SQLPoolColumn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolColumnProperties SQLPoolColumnProperties
				err = json.Unmarshal(*v, &SQLPoolColumnProperties)
				if err != nil {
					return err
				}
				spc.SQLPoolColumnProperties = &SQLPoolColumnProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spc.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolColumnListResult a list of Sql pool columns.
type SQLPoolColumnListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolColumn `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolColumnListResultIterator provides access to a complete listing of SQLPoolColumn values.
type SQLPoolColumnListResultIterator struct {
	i    int
	page SQLPoolColumnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolColumnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolColumnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolColumnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolColumnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolColumnListResultIterator) Response() SQLPoolColumnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolColumnListResultIterator) Value() SQLPoolColumn {
	if !iter.page.NotDone() {
		return SQLPoolColumn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolColumnListResultIterator type.
func NewSQLPoolColumnListResultIterator(page SQLPoolColumnListResultPage) SQLPoolColumnListResultIterator {
	return SQLPoolColumnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spclr SQLPoolColumnListResult) IsEmpty() bool {
	return spclr.Value == nil || len(*spclr.Value) == 0
}

// sQLPoolColumnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spclr SQLPoolColumnListResult) sQLPoolColumnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spclr.NextLink == nil || len(to.String(spclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spclr.NextLink)))
}

// SQLPoolColumnListResultPage contains a page of SQLPoolColumn values.
type SQLPoolColumnListResultPage struct {
	fn    func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)
	spclr SQLPoolColumnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolColumnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolColumnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spclr)
	if err != nil {
		return err
	}
	page.spclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolColumnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolColumnListResultPage) NotDone() bool {
	return !page.spclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolColumnListResultPage) Response() SQLPoolColumnListResult {
	return page.spclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolColumnListResultPage) Values() []SQLPoolColumn {
	if page.spclr.IsEmpty() {
		return nil
	}
	return *page.spclr.Value
}

// Creates a new instance of the SQLPoolColumnListResultPage type.
func NewSQLPoolColumnListResultPage(getNextPage func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)) SQLPoolColumnListResultPage {
	return SQLPoolColumnListResultPage{fn: getNextPage}
}

// SQLPoolColumnProperties sql pool column properties.
type SQLPoolColumnProperties struct {
	// ColumnType - The column data type. Possible values include: 'Image', 'Text', 'Uniqueidentifier', 'Date', 'Time', 'Datetime2', 'Datetimeoffset', 'Tinyint', 'Smallint', 'Int', 'Smalldatetime', 'Real', 'Money', 'Datetime', 'Float', 'SQLVariant', 'Ntext', 'Bit', 'Decimal', 'Numeric', 'Smallmoney', 'Bigint', 'Hierarchyid', 'Geometry', 'Geography', 'Varbinary', 'Varchar', 'Binary', 'Char', 'Timestamp', 'Nvarchar', 'Nchar', 'XML', 'Sysname'
	ColumnType ColumnDataType `json:"columnType,omitempty"`
}

// SQLPoolConnectionPolicy a Sql pool connection policy.
type SQLPoolConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// SQLPoolConnectionPolicyProperties - Resource properties.
	*SQLPoolConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolConnectionPolicy.
func (spcp SQLPoolConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spcp.SQLPoolConnectionPolicyProperties != nil {
		objectMap["properties"] = spcp.SQLPoolConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolConnectionPolicy struct.
func (spcp *SQLPoolConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spcp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				spcp.Location = &location
			}
		case "properties":
			if v != nil {
				var SQLPoolConnectionPolicyProperties SQLPoolConnectionPolicyProperties
				err = json.Unmarshal(*v, &SQLPoolConnectionPolicyProperties)
				if err != nil {
					return err
				}
				spcp.SQLPoolConnectionPolicyProperties = &SQLPoolConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spcp.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolConnectionPolicyProperties properties of a Sql pool connection policy.
type SQLPoolConnectionPolicyProperties struct {
	// SecurityEnabledAccess - The state of security access.
	SecurityEnabledAccess *string `json:"securityEnabledAccess,omitempty"`
	// ProxyDNSName - The fully qualified host name of the auditing proxy.
	ProxyDNSName *string `json:"proxyDnsName,omitempty"`
	// ProxyPort - The port number of the auditing proxy.
	ProxyPort *string `json:"proxyPort,omitempty"`
	// Visibility - The visibility of the auditing proxy.
	Visibility *string `json:"visibility,omitempty"`
	// UseServerDefault - Whether server default is enabled or disabled.
	UseServerDefault *string `json:"useServerDefault,omitempty"`
	// RedirectionState - The state of proxy redirection.
	RedirectionState *string `json:"redirectionState,omitempty"`
	// State - The connection policy state.
	State *string `json:"state,omitempty"`
}

// SQLPoolInfoListResult list of SQL pools
type SQLPoolInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of SQL pools
	Value *[]SQLPool `json:"value,omitempty"`
}

// SQLPoolInfoListResultIterator provides access to a complete listing of SQLPool values.
type SQLPoolInfoListResultIterator struct {
	i    int
	page SQLPoolInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolInfoListResultIterator) Response() SQLPoolInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolInfoListResultIterator) Value() SQLPool {
	if !iter.page.NotDone() {
		return SQLPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolInfoListResultIterator type.
func NewSQLPoolInfoListResultIterator(page SQLPoolInfoListResultPage) SQLPoolInfoListResultIterator {
	return SQLPoolInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spilr SQLPoolInfoListResult) IsEmpty() bool {
	return spilr.Value == nil || len(*spilr.Value) == 0
}

// sQLPoolInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spilr SQLPoolInfoListResult) sQLPoolInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spilr.NextLink == nil || len(to.String(spilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spilr.NextLink)))
}

// SQLPoolInfoListResultPage contains a page of SQLPool values.
type SQLPoolInfoListResultPage struct {
	fn    func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)
	spilr SQLPoolInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spilr)
	if err != nil {
		return err
	}
	page.spilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolInfoListResultPage) NotDone() bool {
	return !page.spilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolInfoListResultPage) Response() SQLPoolInfoListResult {
	return page.spilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolInfoListResultPage) Values() []SQLPool {
	if page.spilr.IsEmpty() {
		return nil
	}
	return *page.spilr.Value
}

// Creates a new instance of the SQLPoolInfoListResultPage type.
func NewSQLPoolInfoListResultPage(getNextPage func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)) SQLPoolInfoListResultPage {
	return SQLPoolInfoListResultPage{fn: getNextPage}
}

// SQLPoolOperation a Sql pool operation.
type SQLPoolOperation struct {
	// SQLPoolOperationProperties - Resource properties.
	*SQLPoolOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolOperation.
func (spo SQLPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spo.SQLPoolOperationProperties != nil {
		objectMap["properties"] = spo.SQLPoolOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolOperation struct.
func (spo *SQLPoolOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolOperationProperties SQLPoolOperationProperties
				err = json.Unmarshal(*v, &SQLPoolOperationProperties)
				if err != nil {
					return err
				}
				spo.SQLPoolOperationProperties = &SQLPoolOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spo.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolOperationProperties the properties of a Sql pool operation.
type SQLPoolOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the Sql pool the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'Pending', 'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// SQLPoolPatchInfo a SQL Analytics pool patch info
type SQLPoolPatchInfo struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Sku - SQL pool SKU
	Sku *Sku `json:"sku,omitempty"`
	// SQLPoolResourceProperties - SQL pool properties
	*SQLPoolResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolPatchInfo.
func (sppi SQLPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sppi.Tags != nil {
		objectMap["tags"] = sppi.Tags
	}
	if sppi.Location != nil {
		objectMap["location"] = sppi.Location
	}
	if sppi.Sku != nil {
		objectMap["sku"] = sppi.Sku
	}
	if sppi.SQLPoolResourceProperties != nil {
		objectMap["properties"] = sppi.SQLPoolResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolPatchInfo struct.
func (sppi *SQLPoolPatchInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sppi.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sppi.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sppi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var SQLPoolResourceProperties SQLPoolResourceProperties
				err = json.Unmarshal(*v, &SQLPoolResourceProperties)
				if err != nil {
					return err
				}
				sppi.SQLPoolResourceProperties = &SQLPoolResourceProperties
			}
		}
	}

	return nil
}

// SQLPoolResourceProperties properties of a SQL Analytics pool
type SQLPoolResourceProperties struct {
	// MaxSizeBytes - Maximum size in bytes
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// Collation - Collation mode
	Collation *string `json:"collation,omitempty"`
	// SourceDatabaseID - Source database to create from
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RecoverableDatabaseID - Backup database to restore from
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// ProvisioningState - Resource state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Status - Resource status
	Status *string `json:"status,omitempty"`
	// RestorePointInTime - Snapshot time to restore
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// CreateMode - What is this?
	CreateMode *string `json:"createMode,omitempty"`
	// CreationDate - Date the SQL pool was created
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// SQLPoolRestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLPoolRestorePointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolRestorePointsCreateFuture) Result(client SQLPoolRestorePointsClient) (rp RestorePoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolRestorePointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolRestorePointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.CreateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolRestorePointsCreateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLPoolSchema a Sql pool schema resource.
type SQLPoolSchema struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// SQLPoolSchemaListResult a list of Sql pool schemas.
type SQLPoolSchemaListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolSchema `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolSchemaListResultIterator provides access to a complete listing of SQLPoolSchema values.
type SQLPoolSchemaListResultIterator struct {
	i    int
	page SQLPoolSchemaListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolSchemaListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolSchemaListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolSchemaListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolSchemaListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolSchemaListResultIterator) Response() SQLPoolSchemaListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolSchemaListResultIterator) Value() SQLPoolSchema {
	if !iter.page.NotDone() {
		return SQLPoolSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolSchemaListResultIterator type.
func NewSQLPoolSchemaListResultIterator(page SQLPoolSchemaListResultPage) SQLPoolSchemaListResultIterator {
	return SQLPoolSchemaListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spslr SQLPoolSchemaListResult) IsEmpty() bool {
	return spslr.Value == nil || len(*spslr.Value) == 0
}

// sQLPoolSchemaListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spslr SQLPoolSchemaListResult) sQLPoolSchemaListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spslr.NextLink == nil || len(to.String(spslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spslr.NextLink)))
}

// SQLPoolSchemaListResultPage contains a page of SQLPoolSchema values.
type SQLPoolSchemaListResultPage struct {
	fn    func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)
	spslr SQLPoolSchemaListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolSchemaListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolSchemaListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spslr)
	if err != nil {
		return err
	}
	page.spslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolSchemaListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolSchemaListResultPage) NotDone() bool {
	return !page.spslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolSchemaListResultPage) Response() SQLPoolSchemaListResult {
	return page.spslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolSchemaListResultPage) Values() []SQLPoolSchema {
	if page.spslr.IsEmpty() {
		return nil
	}
	return *page.spslr.Value
}

// Creates a new instance of the SQLPoolSchemaListResultPage type.
func NewSQLPoolSchemaListResultPage(getNextPage func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)) SQLPoolSchemaListResultPage {
	return SQLPoolSchemaListResultPage{fn: getNextPage}
}

// SQLPoolsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolsCreateFuture) Result(client SQLPoolsClient) (sp SQLPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sp.Response.Response, err = future.GetResult(sender); err == nil && sp.Response.Response.StatusCode != http.StatusNoContent {
		sp, err = client.CreateResponder(sp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolsCreateFuture", "Result", sp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolsDeleteFuture) Result(client SQLPoolsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolsDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLPoolSecurityAlertPolicy a Sql pool security alert policy.
type SQLPoolSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolSecurityAlertPolicy.
func (spsap SQLPoolSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spsap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = spsap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolSecurityAlertPolicy struct.
func (spsap *SQLPoolSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				spsap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spsap.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolsPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsPauseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolsPauseFuture) Result(client SQLPoolsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolsPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolsPauseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.PauseResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolsPauseFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLPoolsResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SQLPoolsResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolsResumeFuture) Result(client SQLPoolsClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolsResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolsResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.ResumeResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.SQLPoolsResumeFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLPoolTable a Sql pool table resource.
type SQLPoolTable struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// SQLPoolTableListResult a list of Sql pool tables.
type SQLPoolTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolTable `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolTableListResultIterator provides access to a complete listing of SQLPoolTable values.
type SQLPoolTableListResultIterator struct {
	i    int
	page SQLPoolTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolTableListResultIterator) Response() SQLPoolTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolTableListResultIterator) Value() SQLPoolTable {
	if !iter.page.NotDone() {
		return SQLPoolTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolTableListResultIterator type.
func NewSQLPoolTableListResultIterator(page SQLPoolTableListResultPage) SQLPoolTableListResultIterator {
	return SQLPoolTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sptlr SQLPoolTableListResult) IsEmpty() bool {
	return sptlr.Value == nil || len(*sptlr.Value) == 0
}

// sQLPoolTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sptlr SQLPoolTableListResult) sQLPoolTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sptlr.NextLink == nil || len(to.String(sptlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sptlr.NextLink)))
}

// SQLPoolTableListResultPage contains a page of SQLPoolTable values.
type SQLPoolTableListResultPage struct {
	fn    func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)
	sptlr SQLPoolTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sptlr)
	if err != nil {
		return err
	}
	page.sptlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolTableListResultPage) NotDone() bool {
	return !page.sptlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolTableListResultPage) Response() SQLPoolTableListResult {
	return page.sptlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolTableListResultPage) Values() []SQLPoolTable {
	if page.sptlr.IsEmpty() {
		return nil
	}
	return *page.sptlr.Value
}

// Creates a new instance of the SQLPoolTableListResultPage type.
func NewSQLPoolTableListResultPage(getNextPage func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)) SQLPoolTableListResultPage {
	return SQLPoolTableListResultPage{fn: getNextPage}
}

// SQLPoolUsage the Sql pool usages.
type SQLPoolUsage struct {
	// Name - READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// SQLPoolUsageListResult the response to a list Sql pool usages request.
type SQLPoolUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages for the Sql pool.
	Value *[]SQLPoolUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolUsageListResultIterator provides access to a complete listing of SQLPoolUsage values.
type SQLPoolUsageListResultIterator struct {
	i    int
	page SQLPoolUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolUsageListResultIterator) Response() SQLPoolUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolUsageListResultIterator) Value() SQLPoolUsage {
	if !iter.page.NotDone() {
		return SQLPoolUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolUsageListResultIterator type.
func NewSQLPoolUsageListResultIterator(page SQLPoolUsageListResultPage) SQLPoolUsageListResultIterator {
	return SQLPoolUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spulr SQLPoolUsageListResult) IsEmpty() bool {
	return spulr.Value == nil || len(*spulr.Value) == 0
}

// sQLPoolUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spulr SQLPoolUsageListResult) sQLPoolUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spulr.NextLink == nil || len(to.String(spulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spulr.NextLink)))
}

// SQLPoolUsageListResultPage contains a page of SQLPoolUsage values.
type SQLPoolUsageListResultPage struct {
	fn    func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)
	spulr SQLPoolUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spulr)
	if err != nil {
		return err
	}
	page.spulr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolUsageListResultPage) NotDone() bool {
	return !page.spulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolUsageListResultPage) Response() SQLPoolUsageListResult {
	return page.spulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolUsageListResultPage) Values() []SQLPoolUsage {
	if page.spulr.IsEmpty() {
		return nil
	}
	return *page.spulr.Value
}

// Creates a new instance of the SQLPoolUsageListResultPage type.
func NewSQLPoolUsageListResultPage(getNextPage func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)) SQLPoolUsageListResultPage {
	return SQLPoolUsageListResultPage{fn: getNextPage}
}

// SQLPoolVulnerabilityAssessment a Sql pool vulnerability assessment.
type SQLPoolVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessment.
func (spva SQLPoolVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spva.SQLPoolVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = spva.SQLPoolVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessment struct.
func (spva *SQLPoolVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentProperties SQLPoolVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				spva.SQLPoolVulnerabilityAssessmentProperties = &SQLPoolVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spva.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentListResult a list of the Sql pool's vulnerability assessments.
type SQLPoolVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SQLPoolVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SQLPoolVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// SQLPoolVulnerabilityAssessment values.
type SQLPoolVulnerabilityAssessmentListResultIterator struct {
	i    int
	page SQLPoolVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SQLPoolVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SQLPoolVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) Response() SQLPoolVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SQLPoolVulnerabilityAssessmentListResultIterator) Value() SQLPoolVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return SQLPoolVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SQLPoolVulnerabilityAssessmentListResultIterator type.
func NewSQLPoolVulnerabilityAssessmentListResultIterator(page SQLPoolVulnerabilityAssessmentListResultPage) SQLPoolVulnerabilityAssessmentListResultIterator {
	return SQLPoolVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spvalr SQLPoolVulnerabilityAssessmentListResult) IsEmpty() bool {
	return spvalr.Value == nil || len(*spvalr.Value) == 0
}

// sQLPoolVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spvalr SQLPoolVulnerabilityAssessmentListResult) sQLPoolVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if spvalr.NextLink == nil || len(to.String(spvalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spvalr.NextLink)))
}

// SQLPoolVulnerabilityAssessmentListResultPage contains a page of SQLPoolVulnerabilityAssessment values.
type SQLPoolVulnerabilityAssessmentListResultPage struct {
	fn     func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)
	spvalr SQLPoolVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SQLPoolVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLPoolVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.spvalr)
	if err != nil {
		return err
	}
	page.spvalr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SQLPoolVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SQLPoolVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.spvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SQLPoolVulnerabilityAssessmentListResultPage) Response() SQLPoolVulnerabilityAssessmentListResult {
	return page.spvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SQLPoolVulnerabilityAssessmentListResultPage) Values() []SQLPoolVulnerabilityAssessment {
	if page.spvalr.IsEmpty() {
		return nil
	}
	return *page.spvalr.Value
}

// Creates a new instance of the SQLPoolVulnerabilityAssessmentListResultPage type.
func NewSQLPoolVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)) SQLPoolVulnerabilityAssessmentListResultPage {
	return SQLPoolVulnerabilityAssessmentListResultPage{fn: getNextPage}
}

// SQLPoolVulnerabilityAssessmentProperties properties of a Sql pool Vulnerability Assessment.
type SQLPoolVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaseline a Sql pool vulnerability assessment rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessmentRuleBaseline.
func (spvarb SQLPoolVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessmentRuleBaseline struct.
func (spvarb *SQLPoolVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentRuleBaselineProperties SQLPoolVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				spvarb.SQLPoolVulnerabilityAssessmentRuleBaselineProperties = &SQLPoolVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentRuleBaselineItem properties for an Sql pool vulnerability assessment rule
// baseline's result.
type SQLPoolVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// SQLPoolVulnerabilityAssessmentRuleBaselineProperties properties of a Sql pool vulnerability assessment
// rule baseline.
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]SQLPoolVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// SQLPoolVulnerabilityAssessmentScanExportProperties properties of the export operation's result.
type SQLPoolVulnerabilityAssessmentScanExportProperties struct {
	// ExportedReportLocation - READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty"`
}

// SQLPoolVulnerabilityAssessmentScansExport a Sql pool Vulnerability Assessment scan export resource.
type SQLPoolVulnerabilityAssessmentScansExport struct {
	autorest.Response `json:"-"`
	// SQLPoolVulnerabilityAssessmentScanExportProperties - Resource properties.
	*SQLPoolVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLPoolVulnerabilityAssessmentScansExport.
func (spvase SQLPoolVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spvase.SQLPoolVulnerabilityAssessmentScanExportProperties != nil {
		objectMap["properties"] = spvase.SQLPoolVulnerabilityAssessmentScanExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLPoolVulnerabilityAssessmentScansExport struct.
func (spvase *SQLPoolVulnerabilityAssessmentScansExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLPoolVulnerabilityAssessmentScanExportProperties SQLPoolVulnerabilityAssessmentScanExportProperties
				err = json.Unmarshal(*v, &SQLPoolVulnerabilityAssessmentScanExportProperties)
				if err != nil {
					return err
				}
				spvase.SQLPoolVulnerabilityAssessmentScanExportProperties = &SQLPoolVulnerabilityAssessmentScanExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spvase.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spvase.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spvase.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLPoolVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLPoolVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SQLPoolVulnerabilityAssessmentScansInitiateScanFuture) Result(client SQLPoolVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TopQueries a database query.
type TopQueries struct {
	// AggregationFunction - READ-ONLY; The function that is used to aggregate each query's metrics. Possible values include: 'Min', 'Max', 'Avg', 'Sum'
	AggregationFunction QueryAggregationFunction `json:"aggregationFunction,omitempty"`
	// ExecutionType - READ-ONLY; The execution type that is used to filter the query instances that are returned. Possible values include: 'Any', 'Regular', 'Irregular', 'Aborted', 'Exception'
	ExecutionType QueryExecutionType `json:"executionType,omitempty"`
	// IntervalType - READ-ONLY; The duration of the interval (ISO8601 duration format).
	IntervalType *string `json:"intervalType,omitempty"`
	// NumberOfTopQueries - READ-ONLY; The number of requested queries.
	NumberOfTopQueries *float64 `json:"numberOfTopQueries,omitempty"`
	// ObservationStartTime - READ-ONLY; The start time for queries that are returned (ISO8601 format)
	ObservationStartTime *date.Time `json:"observationStartTime,omitempty"`
	// ObservationEndTime - READ-ONLY; The end time for queries that are returned (ISO8601 format)
	ObservationEndTime *date.Time `json:"observationEndTime,omitempty"`
	// ObservedMetric - READ-ONLY; The type of metric to use for ordering the top metrics. Possible values include: 'CPU', 'Io', 'Logio', 'Duration', 'ExecutionCount'
	ObservedMetric QueryObservedMetricType `json:"observedMetric,omitempty"`
	// Queries - READ-ONLY; The list of queries.
	Queries *[]QueryStatistic `json:"queries,omitempty"`
}

// TopQueriesListResult represents the response to a get top queries request.
type TopQueriesListResult struct {
	// Value - The list of top queries.
	Value *[]TopQueries `json:"value,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a Sql pool transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// VirtualNetworkProfile virtual Network Profile
type VirtualNetworkProfile struct {
	// ComputeSubnetID - Subnet ID used for computes in workspace
	ComputeSubnetID *string `json:"computeSubnetId,omitempty"`
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring
// scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}

// VulnerabilityAssessmentScanError properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// VulnerabilityAssessmentScanRecord a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	// VulnerabilityAssessmentScanRecordProperties - Resource properties.
	*VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VulnerabilityAssessmentScanRecord.
func (vasr VulnerabilityAssessmentScanRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vasr.VulnerabilityAssessmentScanRecordProperties != nil {
		objectMap["properties"] = vasr.VulnerabilityAssessmentScanRecordProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VulnerabilityAssessmentScanRecord struct.
func (vasr *VulnerabilityAssessmentScanRecord) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vulnerabilityAssessmentScanRecordProperties VulnerabilityAssessmentScanRecordProperties
				err = json.Unmarshal(*v, &vulnerabilityAssessmentScanRecordProperties)
				if err != nil {
					return err
				}
				vasr.VulnerabilityAssessmentScanRecordProperties = &vulnerabilityAssessmentScanRecordProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vasr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vasr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vasr.Type = &typeVar
			}
		}
	}

	return nil
}

// VulnerabilityAssessmentScanRecordListResult a list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VulnerabilityAssessmentScanRecord `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VulnerabilityAssessmentScanRecordListResultIterator provides access to a complete listing of
// VulnerabilityAssessmentScanRecord values.
type VulnerabilityAssessmentScanRecordListResultIterator struct {
	i    int
	page VulnerabilityAssessmentScanRecordListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VulnerabilityAssessmentScanRecordListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Response() VulnerabilityAssessmentScanRecordListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VulnerabilityAssessmentScanRecordListResultIterator) Value() VulnerabilityAssessmentScanRecord {
	if !iter.page.NotDone() {
		return VulnerabilityAssessmentScanRecord{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultIterator type.
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return VulnerabilityAssessmentScanRecordListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) IsEmpty() bool {
	return vasrlr.Value == nil || len(*vasrlr.Value) == 0
}

// vulnerabilityAssessmentScanRecordListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vasrlr VulnerabilityAssessmentScanRecordListResult) vulnerabilityAssessmentScanRecordListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vasrlr.NextLink == nil || len(to.String(vasrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vasrlr.NextLink)))
}

// VulnerabilityAssessmentScanRecordListResultPage contains a page of VulnerabilityAssessmentScanRecord
// values.
type VulnerabilityAssessmentScanRecordListResultPage struct {
	fn     func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)
	vasrlr VulnerabilityAssessmentScanRecordListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VulnerabilityAssessmentScanRecordListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanRecordListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vasrlr)
	if err != nil {
		return err
	}
	page.vasrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VulnerabilityAssessmentScanRecordListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VulnerabilityAssessmentScanRecordListResultPage) NotDone() bool {
	return !page.vasrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VulnerabilityAssessmentScanRecordListResultPage) Response() VulnerabilityAssessmentScanRecordListResult {
	return page.vasrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VulnerabilityAssessmentScanRecordListResultPage) Values() []VulnerabilityAssessmentScanRecord {
	if page.vasrlr.IsEmpty() {
		return nil
	}
	return *page.vasrlr.Value
}

// Creates a new instance of the VulnerabilityAssessmentScanRecordListResultPage type.
func NewVulnerabilityAssessmentScanRecordListResultPage(getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return VulnerabilityAssessmentScanRecordListResultPage{fn: getNextPage}
}

// VulnerabilityAssessmentScanRecordProperties properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// ScanID - READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty"`
	// TriggerType - READ-ONLY; The scan trigger type. Possible values include: 'OnDemand', 'Recurring'
	TriggerType VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty"`
	// State - READ-ONLY; The scan status. Possible values include: 'VulnerabilityAssessmentScanStatePassed', 'VulnerabilityAssessmentScanStateFailed', 'VulnerabilityAssessmentScanStateFailedToRun', 'VulnerabilityAssessmentScanStateInProgress'
	State VulnerabilityAssessmentScanState `json:"state,omitempty"`
	// StartTime - READ-ONLY; The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The scan end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// Errors - READ-ONLY; The scan errors.
	Errors *[]VulnerabilityAssessmentScanError `json:"errors,omitempty"`
	// StorageContainerPath - READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// NumberOfFailedSecurityChecks - READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty"`
}

// Workspace a workspace
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Workspace resource properties
	*WorkspaceProperties `json:"properties,omitempty"`
	// Identity - Identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceAadAdminInfo workspace active directory administrator
type WorkspaceAadAdminInfo struct {
	autorest.Response `json:"-"`
	// AadAdminProperties - Workspace active directory administrator properties
	*AadAdminProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceAadAdminInfo.
func (waai WorkspaceAadAdminInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if waai.AadAdminProperties != nil {
		objectMap["properties"] = waai.AadAdminProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceAadAdminInfo struct.
func (waai *WorkspaceAadAdminInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aadAdminProperties AadAdminProperties
				err = json.Unmarshal(*v, &aadAdminProperties)
				if err != nil {
					return err
				}
				waai.AadAdminProperties = &aadAdminProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				waai.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				waai.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				waai.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceAadAdminsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceAadAdminsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspaceAadAdminsCreateOrUpdateFuture) Result(client WorkspaceAadAdminsClient) (waai WorkspaceAadAdminInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.WorkspaceAadAdminsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.WorkspaceAadAdminsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if waai.Response.Response, err = future.GetResult(sender); err == nil && waai.Response.Response.StatusCode != http.StatusNoContent {
		waai, err = client.CreateOrUpdateResponder(waai.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.WorkspaceAadAdminsCreateOrUpdateFuture", "Result", waai.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspaceAadAdminsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspaceAadAdminsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspaceAadAdminsDeleteFuture) Result(client WorkspaceAadAdminsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.WorkspaceAadAdminsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.WorkspaceAadAdminsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceInfoListResult list of workspaces
type WorkspaceInfoListResult struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next page of results
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of workspaces
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceInfoListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceInfoListResultIterator struct {
	i    int
	page WorkspaceInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceInfoListResultIterator) Response() WorkspaceInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceInfoListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceInfoListResultIterator type.
func NewWorkspaceInfoListResultIterator(page WorkspaceInfoListResultPage) WorkspaceInfoListResultIterator {
	return WorkspaceInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wilr WorkspaceInfoListResult) IsEmpty() bool {
	return wilr.Value == nil || len(*wilr.Value) == 0
}

// workspaceInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wilr WorkspaceInfoListResult) workspaceInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if wilr.NextLink == nil || len(to.String(wilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wilr.NextLink)))
}

// WorkspaceInfoListResultPage contains a page of Workspace values.
type WorkspaceInfoListResultPage struct {
	fn   func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)
	wilr WorkspaceInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wilr)
	if err != nil {
		return err
	}
	page.wilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceInfoListResultPage) NotDone() bool {
	return !page.wilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceInfoListResultPage) Response() WorkspaceInfoListResult {
	return page.wilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceInfoListResultPage) Values() []Workspace {
	if page.wilr.IsEmpty() {
		return nil
	}
	return *page.wilr.Value
}

// Creates a new instance of the WorkspaceInfoListResultPage type.
func NewWorkspaceInfoListResultPage(getNextPage func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)) WorkspaceInfoListResultPage {
	return WorkspaceInfoListResultPage{fn: getNextPage}
}

// WorkspacePatchInfo workspace patch details
type WorkspacePatchInfo struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the workspace
	Identity *ManagedIdentity `json:"identity,omitempty"`
	// WorkspacePatchProperties - Workspace patch properties
	*WorkspacePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatchInfo.
func (wpi WorkspacePatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpi.Tags != nil {
		objectMap["tags"] = wpi.Tags
	}
	if wpi.Identity != nil {
		objectMap["identity"] = wpi.Identity
	}
	if wpi.WorkspacePatchProperties != nil {
		objectMap["properties"] = wpi.WorkspacePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatchInfo struct.
func (wpi *WorkspacePatchInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wpi.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				wpi.Identity = &identity
			}
		case "properties":
			if v != nil {
				var workspacePatchProperties WorkspacePatchProperties
				err = json.Unmarshal(*v, &workspacePatchProperties)
				if err != nil {
					return err
				}
				wpi.WorkspacePatchProperties = &workspacePatchProperties
			}
		}
	}

	return nil
}

// WorkspacePatchProperties workspace patch properties
type WorkspacePatchProperties struct {
	// SQLAdministratorLoginPassword - SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// WorkspaceProperties workspace properties
type WorkspaceProperties struct {
	// DefaultDataLakeStorage - Workspace default data lake storage account details
	DefaultDataLakeStorage *DataLakeStorageAccountDetails `json:"defaultDataLakeStorage,omitempty"`
	// SQLAdministratorLoginPassword - SQL administrator login password
	SQLAdministratorLoginPassword *string `json:"sqlAdministratorLoginPassword,omitempty"`
	// ManagedResourceGroupName - READ-ONLY; Workspace managed resource group
	ManagedResourceGroupName *string `json:"managedResourceGroupName,omitempty"`
	// ProvisioningState - READ-ONLY; Resource provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SQLAdministratorLogin - Login for workspace SQL active directory administrator
	SQLAdministratorLogin *string `json:"sqlAdministratorLogin,omitempty"`
	// VirtualNetworkProfile - Virtual Network profile
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
	// ConnectivityEndpoints - Connectivity endpoints
	ConnectivityEndpoints map[string]*string `json:"connectivityEndpoints"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.DefaultDataLakeStorage != nil {
		objectMap["defaultDataLakeStorage"] = wp.DefaultDataLakeStorage
	}
	if wp.SQLAdministratorLoginPassword != nil {
		objectMap["sqlAdministratorLoginPassword"] = wp.SQLAdministratorLoginPassword
	}
	if wp.SQLAdministratorLogin != nil {
		objectMap["sqlAdministratorLogin"] = wp.SQLAdministratorLogin
	}
	if wp.VirtualNetworkProfile != nil {
		objectMap["virtualNetworkProfile"] = wp.VirtualNetworkProfile
	}
	if wp.ConnectivityEndpoints != nil {
		objectMap["connectivityEndpoints"] = wp.ConnectivityEndpoints
	}
	return json.Marshal(objectMap)
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesCreateOrUpdateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesDeleteFuture) Result(client WorkspacesClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.WorkspacesDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.WorkspacesDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesUpdateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.WorkspacesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("synapse.WorkspacesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "synapse.WorkspacesUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}
