package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAvailableFileSystemTypes invokes the ehpc.ListAvailableFileSystemTypes API synchronously
// api document: https://help.aliyun.com/api/ehpc/listavailablefilesystemtypes.html
func (client *Client) ListAvailableFileSystemTypes(request *ListAvailableFileSystemTypesRequest) (response *ListAvailableFileSystemTypesResponse, err error) {
	response = CreateListAvailableFileSystemTypesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAvailableFileSystemTypesWithChan invokes the ehpc.ListAvailableFileSystemTypes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/listavailablefilesystemtypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAvailableFileSystemTypesWithChan(request *ListAvailableFileSystemTypesRequest) (<-chan *ListAvailableFileSystemTypesResponse, <-chan error) {
	responseChan := make(chan *ListAvailableFileSystemTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAvailableFileSystemTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAvailableFileSystemTypesWithCallback invokes the ehpc.ListAvailableFileSystemTypes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/listavailablefilesystemtypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAvailableFileSystemTypesWithCallback(request *ListAvailableFileSystemTypesRequest, callback func(response *ListAvailableFileSystemTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAvailableFileSystemTypesResponse
		var err error
		defer close(result)
		response, err = client.ListAvailableFileSystemTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAvailableFileSystemTypesRequest is the request struct for api ListAvailableFileSystemTypes
type ListAvailableFileSystemTypesRequest struct {
	*requests.RpcRequest
}

// ListAvailableFileSystemTypesResponse is the response struct for api ListAvailableFileSystemTypes
type ListAvailableFileSystemTypesResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	FileSystemTypeList FileSystemTypeList `json:"FileSystemTypeList" xml:"FileSystemTypeList"`
}

// CreateListAvailableFileSystemTypesRequest creates a request to invoke ListAvailableFileSystemTypes API
func CreateListAvailableFileSystemTypesRequest() (request *ListAvailableFileSystemTypesRequest) {
	request = &ListAvailableFileSystemTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListAvailableFileSystemTypes", "ehs", "openAPI")
	return
}

// CreateListAvailableFileSystemTypesResponse creates a response to parse from ListAvailableFileSystemTypes response
func CreateListAvailableFileSystemTypesResponse() (response *ListAvailableFileSystemTypesResponse) {
	response = &ListAvailableFileSystemTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
