package fnf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExecutionHistory invokes the fnf.GetExecutionHistory API synchronously
// api document: https://help.aliyun.com/api/fnf/getexecutionhistory.html
func (client *Client) GetExecutionHistory(request *GetExecutionHistoryRequest) (response *GetExecutionHistoryResponse, err error) {
	response = CreateGetExecutionHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// GetExecutionHistoryWithChan invokes the fnf.GetExecutionHistory API asynchronously
// api document: https://help.aliyun.com/api/fnf/getexecutionhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetExecutionHistoryWithChan(request *GetExecutionHistoryRequest) (<-chan *GetExecutionHistoryResponse, <-chan error) {
	responseChan := make(chan *GetExecutionHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExecutionHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExecutionHistoryWithCallback invokes the fnf.GetExecutionHistory API asynchronously
// api document: https://help.aliyun.com/api/fnf/getexecutionhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetExecutionHistoryWithCallback(request *GetExecutionHistoryRequest, callback func(response *GetExecutionHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExecutionHistoryResponse
		var err error
		defer close(result)
		response, err = client.GetExecutionHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExecutionHistoryRequest is the request struct for api GetExecutionHistory
type GetExecutionHistoryRequest struct {
	*requests.RpcRequest
	ExecutionName string           `position:"Query" name:"ExecutionName"`
	NextToken     string           `position:"Query" name:"NextToken"`
	RequestId     string           `position:"Query" name:"RequestId"`
	Limit         requests.Integer `position:"Query" name:"Limit"`
	FlowName      string           `position:"Query" name:"FlowName"`
}

// GetExecutionHistoryResponse is the response struct for api GetExecutionHistory
type GetExecutionHistoryResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	NextToken string       `json:"NextToken" xml:"NextToken"`
	Events    []EventsItem `json:"Events" xml:"Events"`
}

// CreateGetExecutionHistoryRequest creates a request to invoke GetExecutionHistory API
func CreateGetExecutionHistoryRequest() (request *GetExecutionHistoryRequest) {
	request = &GetExecutionHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("fnf", "2019-03-15", "GetExecutionHistory", "fnf", "openAPI")
	return
}

// CreateGetExecutionHistoryResponse creates a response to parse from GetExecutionHistory response
func CreateGetExecutionHistoryResponse() (response *GetExecutionHistoryResponse) {
	response = &GetExecutionHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
