package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// NotifyAddThingTopo invokes the iot.NotifyAddThingTopo API synchronously
// api document: https://help.aliyun.com/api/iot/notifyaddthingtopo.html
func (client *Client) NotifyAddThingTopo(request *NotifyAddThingTopoRequest) (response *NotifyAddThingTopoResponse, err error) {
	response = CreateNotifyAddThingTopoResponse()
	err = client.DoAction(request, response)
	return
}

// NotifyAddThingTopoWithChan invokes the iot.NotifyAddThingTopo API asynchronously
// api document: https://help.aliyun.com/api/iot/notifyaddthingtopo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyAddThingTopoWithChan(request *NotifyAddThingTopoRequest) (<-chan *NotifyAddThingTopoResponse, <-chan error) {
	responseChan := make(chan *NotifyAddThingTopoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.NotifyAddThingTopo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// NotifyAddThingTopoWithCallback invokes the iot.NotifyAddThingTopo API asynchronously
// api document: https://help.aliyun.com/api/iot/notifyaddthingtopo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyAddThingTopoWithCallback(request *NotifyAddThingTopoRequest, callback func(response *NotifyAddThingTopoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *NotifyAddThingTopoResponse
		var err error
		defer close(result)
		response, err = client.NotifyAddThingTopo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// NotifyAddThingTopoRequest is the request struct for api NotifyAddThingTopo
type NotifyAddThingTopoRequest struct {
	*requests.RpcRequest
	GwProductKey  string `position:"Query" name:"GwProductKey"`
	GwDeviceName  string `position:"Query" name:"GwDeviceName"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	GwIotId       string `position:"Query" name:"GwIotId"`
	DeviceListStr string `position:"Query" name:"DeviceListStr"`
}

// NotifyAddThingTopoResponse is the response struct for api NotifyAddThingTopo
type NotifyAddThingTopoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateNotifyAddThingTopoRequest creates a request to invoke NotifyAddThingTopo API
func CreateNotifyAddThingTopoRequest() (request *NotifyAddThingTopoRequest) {
	request = &NotifyAddThingTopoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "NotifyAddThingTopo", "iot", "openAPI")
	return
}

// CreateNotifyAddThingTopoResponse creates a response to parse from NotifyAddThingTopo response
func CreateNotifyAddThingTopoResponse() (response *NotifyAddThingTopoResponse) {
	response = &NotifyAddThingTopoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
