package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainRealTimeBpsData invokes the live.DescribeLiveDomainRealTimeBpsData API synchronously
// api document: https://help.aliyun.com/api/live/describelivedomainrealtimebpsdata.html
func (client *Client) DescribeLiveDomainRealTimeBpsData(request *DescribeLiveDomainRealTimeBpsDataRequest) (response *DescribeLiveDomainRealTimeBpsDataResponse, err error) {
	response = CreateDescribeLiveDomainRealTimeBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainRealTimeBpsDataWithChan invokes the live.DescribeLiveDomainRealTimeBpsData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomainrealtimebpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainRealTimeBpsDataWithChan(request *DescribeLiveDomainRealTimeBpsDataRequest) (<-chan *DescribeLiveDomainRealTimeBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainRealTimeBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainRealTimeBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainRealTimeBpsDataWithCallback invokes the live.DescribeLiveDomainRealTimeBpsData API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomainrealtimebpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainRealTimeBpsDataWithCallback(request *DescribeLiveDomainRealTimeBpsDataRequest, callback func(response *DescribeLiveDomainRealTimeBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainRealTimeBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainRealTimeBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainRealTimeBpsDataRequest is the request struct for api DescribeLiveDomainRealTimeBpsData
type DescribeLiveDomainRealTimeBpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainRealTimeBpsDataResponse is the response struct for api DescribeLiveDomainRealTimeBpsData
type DescribeLiveDomainRealTimeBpsDataResponse struct {
	*responses.BaseResponse
	RequestId                  string                     `json:"RequestId" xml:"RequestId"`
	DomainName                 string                     `json:"DomainName" xml:"DomainName"`
	StartTime                  string                     `json:"StartTime" xml:"StartTime"`
	EndTime                    string                     `json:"EndTime" xml:"EndTime"`
	DataInterval               string                     `json:"DataInterval" xml:"DataInterval"`
	RealTimeBpsDataPerInterval RealTimeBpsDataPerInterval `json:"RealTimeBpsDataPerInterval" xml:"RealTimeBpsDataPerInterval"`
}

// CreateDescribeLiveDomainRealTimeBpsDataRequest creates a request to invoke DescribeLiveDomainRealTimeBpsData API
func CreateDescribeLiveDomainRealTimeBpsDataRequest() (request *DescribeLiveDomainRealTimeBpsDataRequest) {
	request = &DescribeLiveDomainRealTimeBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainRealTimeBpsData", "live", "openAPI")
	return
}

// CreateDescribeLiveDomainRealTimeBpsDataResponse creates a response to parse from DescribeLiveDomainRealTimeBpsData response
func CreateDescribeLiveDomainRealTimeBpsDataResponse() (response *DescribeLiveDomainRealTimeBpsDataResponse) {
	response = &DescribeLiveDomainRealTimeBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
