package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamCount invokes the live.DescribeLiveStreamCount API synchronously
// api document: https://help.aliyun.com/api/live/describelivestreamcount.html
func (client *Client) DescribeLiveStreamCount(request *DescribeLiveStreamCountRequest) (response *DescribeLiveStreamCountResponse, err error) {
	response = CreateDescribeLiveStreamCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamCountWithChan invokes the live.DescribeLiveStreamCount API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamCountWithChan(request *DescribeLiveStreamCountRequest) (<-chan *DescribeLiveStreamCountResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamCountWithCallback invokes the live.DescribeLiveStreamCount API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamCountWithCallback(request *DescribeLiveStreamCountRequest, callback func(response *DescribeLiveStreamCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamCountRequest is the request struct for api DescribeLiveStreamCount
type DescribeLiveStreamCountRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamCountResponse is the response struct for api DescribeLiveStreamCount
type DescribeLiveStreamCountResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	StreamCountInfos StreamCountInfos `json:"StreamCountInfos" xml:"StreamCountInfos"`
}

// CreateDescribeLiveStreamCountRequest creates a request to invoke DescribeLiveStreamCount API
func CreateDescribeLiveStreamCountRequest() (request *DescribeLiveStreamCountRequest) {
	request = &DescribeLiveStreamCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamCount", "live", "openAPI")
	return
}

// CreateDescribeLiveStreamCountResponse creates a response to parse from DescribeLiveStreamCount response
func CreateDescribeLiveStreamCountResponse() (response *DescribeLiveStreamCountResponse) {
	response = &DescribeLiveStreamCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
