package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetStackPolicy invokes the ros.SetStackPolicy API synchronously
// api document: https://help.aliyun.com/api/ros/setstackpolicy.html
func (client *Client) SetStackPolicy(request *SetStackPolicyRequest) (response *SetStackPolicyResponse, err error) {
	response = CreateSetStackPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// SetStackPolicyWithChan invokes the ros.SetStackPolicy API asynchronously
// api document: https://help.aliyun.com/api/ros/setstackpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetStackPolicyWithChan(request *SetStackPolicyRequest) (<-chan *SetStackPolicyResponse, <-chan error) {
	responseChan := make(chan *SetStackPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetStackPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetStackPolicyWithCallback invokes the ros.SetStackPolicy API asynchronously
// api document: https://help.aliyun.com/api/ros/setstackpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetStackPolicyWithCallback(request *SetStackPolicyRequest, callback func(response *SetStackPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetStackPolicyResponse
		var err error
		defer close(result)
		response, err = client.SetStackPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetStackPolicyRequest is the request struct for api SetStackPolicy
type SetStackPolicyRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// SetStackPolicyResponse is the response struct for api SetStackPolicy
type SetStackPolicyResponse struct {
	*responses.BaseResponse
}

// CreateSetStackPolicyRequest creates a request to invoke SetStackPolicy API
func CreateSetStackPolicyRequest() (request *SetStackPolicyRequest) {
	request = &SetStackPolicyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "SetStackPolicy", "/stacks/[StackName]/[StackId]/policy", "", "")
	request.Method = requests.POST
	return
}

// CreateSetStackPolicyResponse creates a response to parse from SetStackPolicy response
func CreateSetStackPolicyResponse() (response *SetStackPolicyResponse) {
	response = &SetStackPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
