// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package maps

import original "github.com/Azure/azure-sdk-for-go/services/maps/mgmt/2018-05-01/maps"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type KeyType = original.KeyType

const (
	Primary   KeyType = original.Primary
	Secondary KeyType = original.Secondary
)

type Account = original.Account
type AccountCreateParameters = original.AccountCreateParameters
type AccountKeys = original.AccountKeys
type AccountProperties = original.AccountProperties
type AccountUpdateParameters = original.AccountUpdateParameters
type Accounts = original.Accounts
type AccountsClient = original.AccountsClient
type AccountsMoveRequest = original.AccountsMoveRequest
type BaseClient = original.BaseClient
type Error = original.Error
type ErrorDetailsItem = original.ErrorDetailsItem
type KeySpecification = original.KeySpecification
type Operations = original.Operations
type OperationsValueItem = original.OperationsValueItem
type OperationsValueItemDisplay = original.OperationsValueItemDisplay
type Resource = original.Resource
type Sku = original.Sku

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountsClient(subscriptionID string) AccountsClient {
	return original.NewAccountsClient(subscriptionID)
}
func NewAccountsClientWithBaseURI(baseURI string, subscriptionID string) AccountsClient {
	return original.NewAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
