package healthbot

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/healthbot/mgmt/2020-12-08/healthbot"

// AvailableOperations available operations of the service
type AvailableOperations struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]OperationDetail `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableOperationsIterator provides access to a complete listing of OperationDetail values.
type AvailableOperationsIterator struct {
	i    int
	page AvailableOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableOperationsIterator) Response() AvailableOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableOperationsIterator) Value() OperationDetail {
	if !iter.page.NotDone() {
		return OperationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableOperationsIterator type.
func NewAvailableOperationsIterator(page AvailableOperationsPage) AvailableOperationsIterator {
	return AvailableOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ao AvailableOperations) IsEmpty() bool {
	return ao.Value == nil || len(*ao.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ao AvailableOperations) hasNextLink() bool {
	return ao.NextLink != nil && len(*ao.NextLink) != 0
}

// availableOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ao AvailableOperations) availableOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if !ao.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ao.NextLink)))
}

// AvailableOperationsPage contains a page of OperationDetail values.
type AvailableOperationsPage struct {
	fn func(context.Context, AvailableOperations) (AvailableOperations, error)
	ao AvailableOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ao)
		if err != nil {
			return err
		}
		page.ao = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableOperationsPage) NotDone() bool {
	return !page.ao.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableOperationsPage) Response() AvailableOperations {
	return page.ao
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableOperationsPage) Values() []OperationDetail {
	if page.ao.IsEmpty() {
		return nil
	}
	return *page.ao.Value
}

// Creates a new instance of the AvailableOperationsPage type.
func NewAvailableOperationsPage(cur AvailableOperations, getNextPage func(context.Context, AvailableOperations) (AvailableOperations, error)) AvailableOperationsPage {
	return AvailableOperationsPage{
		fn: getNextPage,
		ao: cur,
	}
}

// BotResponseList the list of Healthbot operation response.
type BotResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of Healthbot results and their properties.
	Value *[]HealthBot `json:"value,omitempty"`
}

// BotResponseListIterator provides access to a complete listing of HealthBot values.
type BotResponseListIterator struct {
	i    int
	page BotResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BotResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BotResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BotResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BotResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BotResponseListIterator) Response() BotResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BotResponseListIterator) Value() HealthBot {
	if !iter.page.NotDone() {
		return HealthBot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BotResponseListIterator type.
func NewBotResponseListIterator(page BotResponseListPage) BotResponseListIterator {
	return BotResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brl BotResponseList) IsEmpty() bool {
	return brl.Value == nil || len(*brl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brl BotResponseList) hasNextLink() bool {
	return brl.NextLink != nil && len(*brl.NextLink) != 0
}

// botResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brl BotResponseList) botResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !brl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brl.NextLink)))
}

// BotResponseListPage contains a page of HealthBot values.
type BotResponseListPage struct {
	fn  func(context.Context, BotResponseList) (BotResponseList, error)
	brl BotResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BotResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BotResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brl)
		if err != nil {
			return err
		}
		page.brl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BotResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BotResponseListPage) NotDone() bool {
	return !page.brl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BotResponseListPage) Response() BotResponseList {
	return page.brl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BotResponseListPage) Values() []HealthBot {
	if page.brl.IsEmpty() {
		return nil
	}
	return *page.brl.Value
}

// Creates a new instance of the BotResponseListPage type.
func NewBotResponseListPage(cur BotResponseList, getNextPage func(context.Context, BotResponseList) (BotResponseList, error)) BotResponseListPage {
	return BotResponseListPage{
		fn:  getNextPage,
		brl: cur,
	}
}

// BotsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BotsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BotsClient) (HealthBot, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BotsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BotsCreateFuture.Result.
func (future *BotsCreateFuture) result(client BotsClient) (hb HealthBot, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthbot.BotsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		hb.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthbot.BotsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if hb.Response.Response, err = future.GetResult(sender); err == nil && hb.Response.Response.StatusCode != http.StatusNoContent {
		hb, err = client.CreateResponder(hb.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "healthbot.BotsCreateFuture", "Result", hb.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BotsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type BotsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BotsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BotsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BotsDeleteFuture.Result.
func (future *BotsDeleteFuture) result(client BotsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "healthbot.BotsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("healthbot.BotsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Error the resource management error response.
type Error struct {
	// Error - The error object.
	Error *ErrorError `json:"error,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorError the error object.
type ErrorError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]Error `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// HealthBot healthBot resource definition
type HealthBot struct {
	autorest.Response `json:"-"`
	// Sku - SKU of the HealthBot.
	Sku *Sku `json:"sku,omitempty"`
	// Properties - The set of properties specific to Healthbot resource.
	Properties *Properties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthBot.
func (hb HealthBot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hb.Sku != nil {
		objectMap["sku"] = hb.Sku
	}
	if hb.Properties != nil {
		objectMap["properties"] = hb.Properties
	}
	if hb.Tags != nil {
		objectMap["tags"] = hb.Tags
	}
	if hb.Location != nil {
		objectMap["location"] = hb.Location
	}
	return json.Marshal(objectMap)
}

// OperationDetail operation detail payload
type OperationDetail struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay operation display payload
type OperationDisplay struct {
	// Provider - Resource provider of the operation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource of the operation
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// Properties the properties of a HealthBot. The Health Bot Service is a cloud platform that empowers
// developers in Healthcare organizations to build and deploy their compliant, AI-powered virtual health
// assistants and health bots, that help them improve processes and reduce costs.
type Properties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the Healthbot resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// BotManagementPortalLink - READ-ONLY; The link.
	BotManagementPortalLink *string `json:"botManagementPortalLink,omitempty"`
}

// Resource the resource model definition for a ARM tracked top level resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the HealthBot SKU. Possible values include: 'F0', 'S1', 'C0'
	Name SkuName `json:"name,omitempty"`
}

// SystemData read only system data
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC)
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateParameters parameters for updating a HealthBot.
type UpdateParameters struct {
	// Tags - Tags for a HealthBot.
	Tags map[string]*string `json:"tags"`
	// Sku - SKU of the HealthBot.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateParameters.
func (up UpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Tags != nil {
		objectMap["tags"] = up.Tags
	}
	if up.Sku != nil {
		objectMap["sku"] = up.Sku
	}
	return json.Marshal(objectMap)
}

// ValidationResult the response returned from validation process
type ValidationResult struct {
	// Status - The status code of the response validation.
	Status *string `json:"status,omitempty"`
}
