package automation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/automation/mgmt/2017-05-15-preview/automation"

// Account definition of the automation account type.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - Gets or sets the automation account properties.
	*AccountProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountCreateOrUpdateParameters the parameters supplied to the create or update automation account
// operation.
type AccountCreateOrUpdateParameters struct {
	// AccountCreateOrUpdateProperties - Gets or sets account create or update properties.
	*AccountCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountCreateOrUpdateParameters.
func (acoup AccountCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acoup.AccountCreateOrUpdateProperties != nil {
		objectMap["properties"] = acoup.AccountCreateOrUpdateProperties
	}
	if acoup.Name != nil {
		objectMap["name"] = acoup.Name
	}
	if acoup.Location != nil {
		objectMap["location"] = acoup.Location
	}
	if acoup.Tags != nil {
		objectMap["tags"] = acoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateOrUpdateParameters struct.
func (acoup *AccountCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountCreateOrUpdateProperties AccountCreateOrUpdateProperties
				err = json.Unmarshal(*v, &accountCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				acoup.AccountCreateOrUpdateProperties = &accountCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acoup.Tags = tags
			}
		}
	}

	return nil
}

// AccountCreateOrUpdateProperties the parameters supplied to the create or update account properties.
type AccountCreateOrUpdateProperties struct {
	// Sku - Gets or sets account SKU.
	Sku *Sku `json:"sku,omitempty"`
}

// AccountListResult the response model for the list account operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets list of accounts.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountProperties definition of the account property.
type AccountProperties struct {
	// Sku - Gets or sets the SKU of account.
	Sku *Sku `json:"sku,omitempty"`
	// LastModifiedBy - Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// State - READ-ONLY; Gets status of account. Possible values include: 'Ok', 'Unavailable', 'Suspended'
	State AccountState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Sku != nil {
		objectMap["sku"] = ap.Sku
	}
	if ap.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = ap.LastModifiedBy
	}
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	return json.Marshal(objectMap)
}

// AccountUpdateParameters the parameters supplied to the update automation account operation.
type AccountUpdateParameters struct {
	// AccountUpdateProperties - Gets or sets account update properties.
	*AccountUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.AccountUpdateProperties != nil {
		objectMap["properties"] = aup.AccountUpdateProperties
	}
	if aup.Name != nil {
		objectMap["name"] = aup.Name
	}
	if aup.Location != nil {
		objectMap["location"] = aup.Location
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountUpdateProperties AccountUpdateProperties
				err = json.Unmarshal(*v, &accountUpdateProperties)
				if err != nil {
					return err
				}
				aup.AccountUpdateProperties = &accountUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		}
	}

	return nil
}

// AccountUpdateProperties the parameters supplied to the update account properties.
type AccountUpdateProperties struct {
	// Sku - Gets or sets account SKU.
	Sku *Sku `json:"sku,omitempty"`
}

// Activity definition of the activity.
type Activity struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the name of the activity.
	Name *string `json:"name,omitempty"`
	// ActivityProperties - Gets or sets the properties of the activity.
	*ActivityProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.ActivityProperties != nil {
		objectMap["properties"] = a.ActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "properties":
			if v != nil {
				var activityProperties ActivityProperties
				err = json.Unmarshal(*v, &activityProperties)
				if err != nil {
					return err
				}
				a.ActivityProperties = &activityProperties
			}
		}
	}

	return nil
}

// ActivityListResult the response model for the list activity operation.
type ActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of activities.
	Value *[]Activity `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActivityListResultIterator provides access to a complete listing of Activity values.
type ActivityListResultIterator struct {
	i    int
	page ActivityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActivityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActivityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActivityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActivityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActivityListResultIterator) Response() ActivityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActivityListResultIterator) Value() Activity {
	if !iter.page.NotDone() {
		return Activity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActivityListResultIterator type.
func NewActivityListResultIterator(page ActivityListResultPage) ActivityListResultIterator {
	return ActivityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ActivityListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ActivityListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// activityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ActivityListResult) activityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ActivityListResultPage contains a page of Activity values.
type ActivityListResultPage struct {
	fn  func(context.Context, ActivityListResult) (ActivityListResult, error)
	alr ActivityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActivityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActivityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActivityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActivityListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActivityListResultPage) Response() ActivityListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActivityListResultPage) Values() []Activity {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ActivityListResultPage type.
func NewActivityListResultPage(cur ActivityListResult, getNextPage func(context.Context, ActivityListResult) (ActivityListResult, error)) ActivityListResultPage {
	return ActivityListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// ActivityOutputType definition of the activity output type.
type ActivityOutputType struct {
	// Name - Gets or sets the name of the activity output type.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the activity output type.
	Type *string `json:"type,omitempty"`
}

// ActivityParameter definition of the activity parameter.
type ActivityParameter struct {
	// Name - Gets or sets the name of the activity parameter.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the activity parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value that indicates true if the parameter is required. If the value is false, the parameter is optional.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// IsDynamic - Gets or sets a Boolean value that indicates true if the parameter is dynamic.
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// Position - Gets or sets the position of the activity parameter.
	Position *int64 `json:"position,omitempty"`
	// ValueFromPipeline - Gets or sets a Boolean value that indicates true if the parameter can take values from the incoming pipeline objects. This setting is used if the cmdlet must access the complete input object. false indicates that the parameter cannot take values from the complete input object.
	ValueFromPipeline *bool `json:"valueFromPipeline,omitempty"`
	// ValueFromPipelineByPropertyName - Gets or sets a Boolean value that indicates true if the parameter can be filled from a property of the incoming pipeline object that has the same name as this parameter. false indicates that the parameter cannot be filled from the incoming pipeline object property with the same name.
	ValueFromPipelineByPropertyName *bool `json:"valueFromPipelineByPropertyName,omitempty"`
	// ValueFromRemainingArguments - Gets or sets a Boolean value that indicates true if the cmdlet parameter accepts all the remaining command-line arguments that are associated with this parameter in the form of an array. false if the cmdlet parameter does not accept all the remaining argument values.
	ValueFromRemainingArguments *bool `json:"valueFromRemainingArguments,omitempty"`
	// Description - Gets or sets the description of the activity parameter.
	Description *string `json:"description,omitempty"`
	// ValidationSet - Gets or sets the validation set of activity parameter.
	ValidationSet *[]ActivityParameterValidationSet `json:"validationSet,omitempty"`
}

// ActivityParameterSet definition of the activity parameter set.
type ActivityParameterSet struct {
	// Name - Gets or sets the name of the activity parameter set.
	Name *string `json:"name,omitempty"`
	// Parameters - Gets or sets the parameters of the activity parameter set.
	Parameters *[]ActivityParameter `json:"parameters,omitempty"`
}

// ActivityParameterValidationSet definition of the activity parameter validation set.
type ActivityParameterValidationSet struct {
	// MemberValue - Gets or sets the name of the activity parameter validation set member.
	MemberValue *string `json:"memberValue,omitempty"`
}

// ActivityProperties properties of the activity.
type ActivityProperties struct {
	// Definition - Gets or sets the user name of the activity.
	Definition *string `json:"definition,omitempty"`
	// ParameterSets - Gets or sets the parameter sets of the activity.
	ParameterSets *[]ActivityParameterSet `json:"parameterSets,omitempty"`
	// OutputTypes - Gets or sets the output types of the activity.
	OutputTypes *[]ActivityOutputType `json:"outputTypes,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// AdvancedSchedule the properties of the create Advanced Schedule.
type AdvancedSchedule struct {
	// WeekDays - Days of the week that the job should execute on.
	WeekDays *[]string `json:"weekDays,omitempty"`
	// MonthDays - Days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays *[]int32 `json:"monthDays,omitempty"`
	// MonthlyOccurrences - Occurrences of days within a month.
	MonthlyOccurrences *[]AdvancedScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`
}

// AdvancedScheduleMonthlyOccurrence the properties of the create advanced schedule monthly occurrence.
type AdvancedScheduleMonthlyOccurrence struct {
	// Occurrence - Occurrence of the week within the month. Must be between 1 and 5
	Occurrence *int32 `json:"occurrence,omitempty"`
	// Day - Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'
	Day ScheduleDay `json:"day,omitempty"`
}

// AgentRegistration definition of the agent registration information type.
type AgentRegistration struct {
	autorest.Response `json:"-"`
	// DscMetaConfiguration - Gets or sets the dsc meta configuration.
	DscMetaConfiguration *string `json:"dscMetaConfiguration,omitempty"`
	// Endpoint - Gets or sets the dsc server endpoint.
	Endpoint *string `json:"endpoint,omitempty"`
	// Keys - Gets or sets the agent registration keys.
	Keys *AgentRegistrationKeys `json:"keys,omitempty"`
	// ID - Gets or sets the id.
	ID *string `json:"id,omitempty"`
}

// AgentRegistrationKeys definition of the agent registration keys.
type AgentRegistrationKeys struct {
	// Primary - Gets or sets the primary key.
	Primary *string `json:"primary,omitempty"`
	// Secondary - Gets or sets the secondary key.
	Secondary *string `json:"secondary,omitempty"`
}

// AgentRegistrationRegenerateKeyParameter the parameters supplied to the regenerate keys operation.
type AgentRegistrationRegenerateKeyParameter struct {
	// KeyName - Gets or sets the agent registration key name - primary or secondary. Possible values include: 'Primary', 'Secondary'
	KeyName AgentRegistrationKeyName `json:"keyName,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AgentRegistrationRegenerateKeyParameter.
func (arrkp AgentRegistrationRegenerateKeyParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arrkp.KeyName != "" {
		objectMap["keyName"] = arrkp.KeyName
	}
	if arrkp.Name != nil {
		objectMap["name"] = arrkp.Name
	}
	if arrkp.Location != nil {
		objectMap["location"] = arrkp.Location
	}
	if arrkp.Tags != nil {
		objectMap["tags"] = arrkp.Tags
	}
	return json.Marshal(objectMap)
}

// AzureQueryProperties azure query for the update configuration.
type AzureQueryProperties struct {
	// Scope - List of Subscription or Resource Group ARM Ids.
	Scope *[]string `json:"scope,omitempty"`
	// Locations - List of locations to scope the query to.
	Locations *[]string `json:"locations,omitempty"`
	// TagSettings - Tag settings for the VM.
	TagSettings *TagSettingsProperties `json:"tagSettings,omitempty"`
}

// Certificate definition of the certificate.
type Certificate struct {
	autorest.Response `json:"-"`
	// CertificateProperties - Gets or sets the properties of the certificate.
	*CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateParameters the parameters supplied to the create or update or replace
// certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`
	// CertificateCreateOrUpdateProperties - Gets or sets the properties of the certificate.
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateCreateOrUpdateParameters.
func (ccoup CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.Name != nil {
		objectMap["name"] = ccoup.Name
	}
	if ccoup.CertificateCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.CertificateCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateCreateOrUpdateParameters struct.
func (ccoup *CertificateCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var certificateCreateOrUpdateProperties CertificateCreateOrUpdateProperties
				err = json.Unmarshal(*v, &certificateCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CertificateCreateOrUpdateProperties = &certificateCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateProperties the properties of the create certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// Base64Value - Gets or sets the base64 encoded value of the certificate.
	Base64Value *string `json:"base64Value,omitempty"`
	// Description - Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`
	// Thumbprint - Gets or sets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsExportable - Gets or sets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty"`
}

// CertificateListResult the response model for the list certificate operation.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of certificates.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of Certificate values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateListResultIterator type.
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return CertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CertificateListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CertificateListResultPage contains a page of Certificate values.
type CertificateListResultPage struct {
	fn  func(context.Context, CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []Certificate {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CertificateListResultPage type.
func NewCertificateListResultPage(cur CertificateListResult, getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return CertificateListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CertificateProperties properties of the certificate.
type CertificateProperties struct {
	// Thumbprint - READ-ONLY; Gets the thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpiryTime - READ-ONLY; Gets the expiry time of the certificate.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// IsExportable - READ-ONLY; Gets the is exportable flag of the certificate.
	IsExportable *bool `json:"isExportable,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Description != nil {
		objectMap["description"] = cp.Description
	}
	return json.Marshal(objectMap)
}

// CertificateUpdateParameters the parameters supplied to the update certificate operation.
type CertificateUpdateParameters struct {
	// Name - Gets or sets the name of the certificate.
	Name *string `json:"name,omitempty"`
	// CertificateUpdateProperties - Gets or sets the properties of the certificate.
	*CertificateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateUpdateParameters.
func (cup CertificateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Name != nil {
		objectMap["name"] = cup.Name
	}
	if cup.CertificateUpdateProperties != nil {
		objectMap["properties"] = cup.CertificateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateUpdateParameters struct.
func (cup *CertificateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var certificateUpdateProperties CertificateUpdateProperties
				err = json.Unmarshal(*v, &certificateUpdateProperties)
				if err != nil {
					return err
				}
				cup.CertificateUpdateProperties = &certificateUpdateProperties
			}
		}
	}

	return nil
}

// CertificateUpdateProperties the properties of the update certificate operation
type CertificateUpdateProperties struct {
	// Description - Gets or sets the description of the certificate.
	Description *string `json:"description,omitempty"`
}

// CollectionItemUpdateConfiguration object returned when requesting a collection of software update
// configuration
type CollectionItemUpdateConfiguration struct {
	// AzureVirtualMachines - List of azure resource Ids for azure virtual machines targeted by the software update configuration.
	AzureVirtualMachines *[]string `json:"azureVirtualMachines,omitempty"`
	// Duration - Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
	Duration *string `json:"duration,omitempty"`
}

// Connection definition of the connection.
type Connection struct {
	autorest.Response `json:"-"`
	// ConnectionProperties - Gets or sets the properties of the connection.
	*ConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Connection.
func (c Connection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConnectionProperties != nil {
		objectMap["properties"] = c.ConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Connection struct.
func (c *Connection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectionProperties ConnectionProperties
				err = json.Unmarshal(*v, &connectionProperties)
				if err != nil {
					return err
				}
				c.ConnectionProperties = &connectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ConnectionCreateOrUpdateParameters the parameters supplied to the create or update connection operation.
type ConnectionCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`
	// ConnectionCreateOrUpdateProperties - Gets or sets the properties of the connection.
	*ConnectionCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionCreateOrUpdateParameters.
func (ccoup ConnectionCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.Name != nil {
		objectMap["name"] = ccoup.Name
	}
	if ccoup.ConnectionCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.ConnectionCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionCreateOrUpdateParameters struct.
func (ccoup *ConnectionCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionCreateOrUpdateProperties ConnectionCreateOrUpdateProperties
				err = json.Unmarshal(*v, &connectionCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.ConnectionCreateOrUpdateProperties = &connectionCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionCreateOrUpdateProperties the properties of the create connection properties
type ConnectionCreateOrUpdateProperties struct {
	// Description - Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`
	// ConnectionType - Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	// FieldDefinitionValues - Gets or sets the field definition properties of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
}

// MarshalJSON is the custom marshaler for ConnectionCreateOrUpdateProperties.
func (ccoup ConnectionCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.Description != nil {
		objectMap["description"] = ccoup.Description
	}
	if ccoup.ConnectionType != nil {
		objectMap["connectionType"] = ccoup.ConnectionType
	}
	if ccoup.FieldDefinitionValues != nil {
		objectMap["fieldDefinitionValues"] = ccoup.FieldDefinitionValues
	}
	return json.Marshal(objectMap)
}

// ConnectionListResult the response model for the list connection operation.
type ConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of connection.
	Value *[]Connection `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionListResultIterator provides access to a complete listing of Connection values.
type ConnectionListResultIterator struct {
	i    int
	page ConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionListResultIterator) Response() ConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionListResultIterator) Value() Connection {
	if !iter.page.NotDone() {
		return Connection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectionListResultIterator type.
func NewConnectionListResultIterator(page ConnectionListResultPage) ConnectionListResultIterator {
	return ConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ConnectionListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ConnectionListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// connectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ConnectionListResult) connectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ConnectionListResultPage contains a page of Connection values.
type ConnectionListResultPage struct {
	fn  func(context.Context, ConnectionListResult) (ConnectionListResult, error)
	clr ConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionListResultPage) Response() ConnectionListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionListResultPage) Values() []Connection {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ConnectionListResultPage type.
func NewConnectionListResultPage(cur ConnectionListResult, getNextPage func(context.Context, ConnectionListResult) (ConnectionListResult, error)) ConnectionListResultPage {
	return ConnectionListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ConnectionProperties definition of the connection properties.
type ConnectionProperties struct {
	// ConnectionType - Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	// FieldDefinitionValues - READ-ONLY; Gets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
	// CreationTime - READ-ONLY; Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionProperties.
func (cp ConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ConnectionType != nil {
		objectMap["connectionType"] = cp.ConnectionType
	}
	if cp.Description != nil {
		objectMap["description"] = cp.Description
	}
	return json.Marshal(objectMap)
}

// ConnectionType definition of the connection type.
type ConnectionType struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the name of the connection type.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// ConnectionTypeProperties - Gets or sets the properties of the connection type.
	*ConnectionTypeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionType.
func (ct ConnectionType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ct.ConnectionTypeProperties != nil {
		objectMap["properties"] = ct.ConnectionTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionType struct.
func (ct *ConnectionType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ct.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ct.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ct.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var connectionTypeProperties ConnectionTypeProperties
				err = json.Unmarshal(*v, &connectionTypeProperties)
				if err != nil {
					return err
				}
				ct.ConnectionTypeProperties = &connectionTypeProperties
			}
		}
	}

	return nil
}

// ConnectionTypeAssociationProperty the connection type property associated with the entity.
type ConnectionTypeAssociationProperty struct {
	// Name - Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`
}

// ConnectionTypeCreateOrUpdateParameters the parameters supplied to the create or update connection type
// operation.
type ConnectionTypeCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the connection type.
	Name *string `json:"name,omitempty"`
	// ConnectionTypeCreateOrUpdateProperties - Gets or sets the value of the connection type.
	*ConnectionTypeCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionTypeCreateOrUpdateParameters.
func (ctcoup ConnectionTypeCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcoup.Name != nil {
		objectMap["name"] = ctcoup.Name
	}
	if ctcoup.ConnectionTypeCreateOrUpdateProperties != nil {
		objectMap["properties"] = ctcoup.ConnectionTypeCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionTypeCreateOrUpdateParameters struct.
func (ctcoup *ConnectionTypeCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionTypeCreateOrUpdateProperties ConnectionTypeCreateOrUpdateProperties
				err = json.Unmarshal(*v, &connectionTypeCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ctcoup.ConnectionTypeCreateOrUpdateProperties = &connectionTypeCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionTypeCreateOrUpdateProperties the properties of the create connection type.
type ConnectionTypeCreateOrUpdateProperties struct {
	// IsGlobal - Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// FieldDefinitions - Gets or sets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions"`
}

// MarshalJSON is the custom marshaler for ConnectionTypeCreateOrUpdateProperties.
func (ctcoup ConnectionTypeCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcoup.IsGlobal != nil {
		objectMap["isGlobal"] = ctcoup.IsGlobal
	}
	if ctcoup.FieldDefinitions != nil {
		objectMap["fieldDefinitions"] = ctcoup.FieldDefinitions
	}
	return json.Marshal(objectMap)
}

// ConnectionTypeListResult the response model for the list connection type operation.
type ConnectionTypeListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of connection types.
	Value *[]ConnectionType `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionTypeListResultIterator provides access to a complete listing of ConnectionType values.
type ConnectionTypeListResultIterator struct {
	i    int
	page ConnectionTypeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionTypeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionTypeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectionTypeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionTypeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionTypeListResultIterator) Response() ConnectionTypeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionTypeListResultIterator) Value() ConnectionType {
	if !iter.page.NotDone() {
		return ConnectionType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectionTypeListResultIterator type.
func NewConnectionTypeListResultIterator(page ConnectionTypeListResultPage) ConnectionTypeListResultIterator {
	return ConnectionTypeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr ConnectionTypeListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ctlr ConnectionTypeListResult) hasNextLink() bool {
	return ctlr.NextLink != nil && len(*ctlr.NextLink) != 0
}

// connectionTypeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr ConnectionTypeListResult) connectionTypeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ctlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.NextLink)))
}

// ConnectionTypeListResultPage contains a page of ConnectionType values.
type ConnectionTypeListResultPage struct {
	fn   func(context.Context, ConnectionTypeListResult) (ConnectionTypeListResult, error)
	ctlr ConnectionTypeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionTypeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectionTypeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ctlr)
		if err != nil {
			return err
		}
		page.ctlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectionTypeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionTypeListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionTypeListResultPage) Response() ConnectionTypeListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionTypeListResultPage) Values() []ConnectionType {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// Creates a new instance of the ConnectionTypeListResultPage type.
func NewConnectionTypeListResultPage(cur ConnectionTypeListResult, getNextPage func(context.Context, ConnectionTypeListResult) (ConnectionTypeListResult, error)) ConnectionTypeListResultPage {
	return ConnectionTypeListResultPage{
		fn:   getNextPage,
		ctlr: cur,
	}
}

// ConnectionTypeProperties properties of the connection type.
type ConnectionTypeProperties struct {
	// IsGlobal - Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// FieldDefinitions - READ-ONLY; Gets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition `json:"fieldDefinitions"`
	// CreationTime - READ-ONLY; Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionTypeProperties.
func (ctp ConnectionTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctp.IsGlobal != nil {
		objectMap["isGlobal"] = ctp.IsGlobal
	}
	if ctp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = ctp.LastModifiedTime
	}
	if ctp.Description != nil {
		objectMap["description"] = ctp.Description
	}
	return json.Marshal(objectMap)
}

// ConnectionUpdateParameters the parameters supplied to the update connection operation.
type ConnectionUpdateParameters struct {
	// Name - Gets or sets the name of the connection.
	Name *string `json:"name,omitempty"`
	// ConnectionUpdateProperties - Gets or sets the properties of the connection.
	*ConnectionUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionUpdateParameters.
func (cup ConnectionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Name != nil {
		objectMap["name"] = cup.Name
	}
	if cup.ConnectionUpdateProperties != nil {
		objectMap["properties"] = cup.ConnectionUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionUpdateParameters struct.
func (cup *ConnectionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var connectionUpdateProperties ConnectionUpdateProperties
				err = json.Unmarshal(*v, &connectionUpdateProperties)
				if err != nil {
					return err
				}
				cup.ConnectionUpdateProperties = &connectionUpdateProperties
			}
		}
	}

	return nil
}

// ConnectionUpdateProperties the properties of the update connection operation.
type ConnectionUpdateProperties struct {
	// Description - Gets or sets the description of the connection.
	Description *string `json:"description,omitempty"`
	// FieldDefinitionValues - Gets or sets the field definition values of the connection.
	FieldDefinitionValues map[string]*string `json:"fieldDefinitionValues"`
}

// MarshalJSON is the custom marshaler for ConnectionUpdateProperties.
func (cup ConnectionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Description != nil {
		objectMap["description"] = cup.Description
	}
	if cup.FieldDefinitionValues != nil {
		objectMap["fieldDefinitionValues"] = cup.FieldDefinitionValues
	}
	return json.Marshal(objectMap)
}

// ContentHash definition of the runbook property type.
type ContentHash struct {
	// Algorithm - Gets or sets the content hash algorithm used to hash the content.
	Algorithm *string `json:"algorithm,omitempty"`
	// Value - Gets or sets expected hash value of the content.
	Value *string `json:"value,omitempty"`
}

// ContentLink definition of the content link.
type ContentLink struct {
	// URI - Gets or sets the uri of the runbook content.
	URI *string `json:"uri,omitempty"`
	// ContentHash - Gets or sets the hash.
	ContentHash *ContentHash `json:"contentHash,omitempty"`
	// Version - Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// ContentSource definition of the content source.
type ContentSource struct {
	// Hash - Gets or sets the hash.
	Hash *ContentHash `json:"hash,omitempty"`
	// Type - Gets or sets the content source type. Possible values include: 'EmbeddedContent', 'URI'
	Type ContentSourceType `json:"type,omitempty"`
	// Value - Gets or sets the value of the content. This is based on the content source type.
	Value *string `json:"value,omitempty"`
	// Version - Gets or sets the version of the content.
	Version *string `json:"version,omitempty"`
}

// Credential definition of the credential.
type Credential struct {
	autorest.Response `json:"-"`
	// CredentialProperties - Gets or sets the properties of the credential.
	*CredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Credential.
func (c Credential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CredentialProperties != nil {
		objectMap["properties"] = c.CredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Credential struct.
func (c *Credential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var credentialProperties CredentialProperties
				err = json.Unmarshal(*v, &credentialProperties)
				if err != nil {
					return err
				}
				c.CredentialProperties = &credentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// CredentialCreateOrUpdateParameters the parameters supplied to the create or update credential operation.
type CredentialCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
	// CredentialCreateOrUpdateProperties - Gets or sets the properties of the credential.
	*CredentialCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CredentialCreateOrUpdateParameters.
func (ccoup CredentialCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.Name != nil {
		objectMap["name"] = ccoup.Name
	}
	if ccoup.CredentialCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.CredentialCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CredentialCreateOrUpdateParameters struct.
func (ccoup *CredentialCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "properties":
			if v != nil {
				var credentialCreateOrUpdateProperties CredentialCreateOrUpdateProperties
				err = json.Unmarshal(*v, &credentialCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CredentialCreateOrUpdateProperties = &credentialCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// CredentialCreateOrUpdateProperties the properties of the create credential operation.
type CredentialCreateOrUpdateProperties struct {
	// UserName - Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// Password - Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`
	// Description - Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`
}

// CredentialListResult the response model for the list credential operation.
type CredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of credentials.
	Value *[]Credential `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// CredentialListResultIterator provides access to a complete listing of Credential values.
type CredentialListResultIterator struct {
	i    int
	page CredentialListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CredentialListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CredentialListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CredentialListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CredentialListResultIterator) Response() CredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CredentialListResultIterator) Value() Credential {
	if !iter.page.NotDone() {
		return Credential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CredentialListResultIterator type.
func NewCredentialListResultIterator(page CredentialListResultPage) CredentialListResultIterator {
	return CredentialListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CredentialListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CredentialListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// credentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CredentialListResult) credentialListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CredentialListResultPage contains a page of Credential values.
type CredentialListResultPage struct {
	fn  func(context.Context, CredentialListResult) (CredentialListResult, error)
	clr CredentialListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CredentialListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CredentialListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CredentialListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CredentialListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CredentialListResultPage) Response() CredentialListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CredentialListResultPage) Values() []Credential {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CredentialListResultPage type.
func NewCredentialListResultPage(cur CredentialListResult, getNextPage func(context.Context, CredentialListResult) (CredentialListResult, error)) CredentialListResultPage {
	return CredentialListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CredentialProperties definition of the credential properties
type CredentialProperties struct {
	// UserName - READ-ONLY; Gets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for CredentialProperties.
func (cp CredentialProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Description != nil {
		objectMap["description"] = cp.Description
	}
	return json.Marshal(objectMap)
}

// CredentialUpdateParameters the parameters supplied to the Update credential operation.
type CredentialUpdateParameters struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
	// CredentialUpdateProperties - Gets or sets the properties of the variable.
	*CredentialUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CredentialUpdateParameters.
func (cup CredentialUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Name != nil {
		objectMap["name"] = cup.Name
	}
	if cup.CredentialUpdateProperties != nil {
		objectMap["properties"] = cup.CredentialUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CredentialUpdateParameters struct.
func (cup *CredentialUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cup.Name = &name
			}
		case "properties":
			if v != nil {
				var credentialUpdateProperties CredentialUpdateProperties
				err = json.Unmarshal(*v, &credentialUpdateProperties)
				if err != nil {
					return err
				}
				cup.CredentialUpdateProperties = &credentialUpdateProperties
			}
		}
	}

	return nil
}

// CredentialUpdateProperties the properties of the Update credential
type CredentialUpdateProperties struct {
	// UserName - Gets or sets the user name of the credential.
	UserName *string `json:"userName,omitempty"`
	// Password - Gets or sets the password of the credential.
	Password *string `json:"password,omitempty"`
	// Description - Gets or sets the description of the credential.
	Description *string `json:"description,omitempty"`
}

// DscCompilationJob definition of the Dsc Compilation job.
type DscCompilationJob struct {
	autorest.Response `json:"-"`
	// DscCompilationJobProperties - Gets or sets the properties of the Dsc Compilation job.
	*DscCompilationJobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DscCompilationJob.
func (dcj DscCompilationJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcj.DscCompilationJobProperties != nil {
		objectMap["properties"] = dcj.DscCompilationJobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscCompilationJob struct.
func (dcj *DscCompilationJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscCompilationJobProperties DscCompilationJobProperties
				err = json.Unmarshal(*v, &dscCompilationJobProperties)
				if err != nil {
					return err
				}
				dcj.DscCompilationJobProperties = &dscCompilationJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcj.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcj.Type = &typeVar
			}
		}
	}

	return nil
}

// DscCompilationJobCreateParameters the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateParameters struct {
	// DscCompilationJobCreateProperties - Gets or sets the list of compilation job properties.
	*DscCompilationJobCreateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobCreateParameters.
func (dcjcp DscCompilationJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjcp.DscCompilationJobCreateProperties != nil {
		objectMap["properties"] = dcjcp.DscCompilationJobCreateProperties
	}
	if dcjcp.Name != nil {
		objectMap["name"] = dcjcp.Name
	}
	if dcjcp.Location != nil {
		objectMap["location"] = dcjcp.Location
	}
	if dcjcp.Tags != nil {
		objectMap["tags"] = dcjcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscCompilationJobCreateParameters struct.
func (dcjcp *DscCompilationJobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscCompilationJobCreateProperties DscCompilationJobCreateProperties
				err = json.Unmarshal(*v, &dscCompilationJobCreateProperties)
				if err != nil {
					return err
				}
				dcjcp.DscCompilationJobCreateProperties = &dscCompilationJobCreateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcjcp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcjcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcjcp.Tags = tags
			}
		}
	}

	return nil
}

// DscCompilationJobCreateProperties the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateProperties struct {
	// Configuration - Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// IncrementNodeConfigurationBuild - If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool `json:"incrementNodeConfigurationBuild,omitempty"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobCreateProperties.
func (dcjcp DscCompilationJobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjcp.Configuration != nil {
		objectMap["configuration"] = dcjcp.Configuration
	}
	if dcjcp.Parameters != nil {
		objectMap["parameters"] = dcjcp.Parameters
	}
	if dcjcp.IncrementNodeConfigurationBuild != nil {
		objectMap["incrementNodeConfigurationBuild"] = dcjcp.IncrementNodeConfigurationBuild
	}
	return json.Marshal(objectMap)
}

// DscCompilationJobListResult the response model for the list job operation.
type DscCompilationJobListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of Dsc Compilation jobs.
	Value *[]DscCompilationJob `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscCompilationJobListResultIterator provides access to a complete listing of DscCompilationJob values.
type DscCompilationJobListResultIterator struct {
	i    int
	page DscCompilationJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscCompilationJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscCompilationJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscCompilationJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscCompilationJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscCompilationJobListResultIterator) Response() DscCompilationJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscCompilationJobListResultIterator) Value() DscCompilationJob {
	if !iter.page.NotDone() {
		return DscCompilationJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscCompilationJobListResultIterator type.
func NewDscCompilationJobListResultIterator(page DscCompilationJobListResultPage) DscCompilationJobListResultIterator {
	return DscCompilationJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcjlr DscCompilationJobListResult) IsEmpty() bool {
	return dcjlr.Value == nil || len(*dcjlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcjlr DscCompilationJobListResult) hasNextLink() bool {
	return dcjlr.NextLink != nil && len(*dcjlr.NextLink) != 0
}

// dscCompilationJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcjlr DscCompilationJobListResult) dscCompilationJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dcjlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcjlr.NextLink)))
}

// DscCompilationJobListResultPage contains a page of DscCompilationJob values.
type DscCompilationJobListResultPage struct {
	fn    func(context.Context, DscCompilationJobListResult) (DscCompilationJobListResult, error)
	dcjlr DscCompilationJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscCompilationJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscCompilationJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcjlr)
		if err != nil {
			return err
		}
		page.dcjlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscCompilationJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscCompilationJobListResultPage) NotDone() bool {
	return !page.dcjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscCompilationJobListResultPage) Response() DscCompilationJobListResult {
	return page.dcjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscCompilationJobListResultPage) Values() []DscCompilationJob {
	if page.dcjlr.IsEmpty() {
		return nil
	}
	return *page.dcjlr.Value
}

// Creates a new instance of the DscCompilationJobListResultPage type.
func NewDscCompilationJobListResultPage(cur DscCompilationJobListResult, getNextPage func(context.Context, DscCompilationJobListResult) (DscCompilationJobListResult, error)) DscCompilationJobListResultPage {
	return DscCompilationJobListResultPage{
		fn:    getNextPage,
		dcjlr: cur,
	}
}

// DscCompilationJobProperties definition of Dsc Compilation job properties.
type DscCompilationJobProperties struct {
	// Configuration - Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// StartedBy - READ-ONLY; Gets the compilation job started by.
	StartedBy *string `json:"startedBy,omitempty"`
	// JobID - READ-ONLY; Gets the id of the job.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The current provisioning state of the job. Possible values include: 'JobProvisioningStateFailed', 'JobProvisioningStateSucceeded', 'JobProvisioningStateSuspended', 'JobProvisioningStateProcessing'
	ProvisioningState JobProvisioningState `json:"provisioningState,omitempty"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
	// Status - Gets or sets the status of the job. Possible values include: 'JobStatusNew', 'JobStatusActivating', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusStopped', 'JobStatusBlocked', 'JobStatusSuspended', 'JobStatusDisconnected', 'JobStatusSuspending', 'JobStatusStopping', 'JobStatusResuming', 'JobStatusRemoving'
	Status JobStatus `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// StartTime - READ-ONLY; Gets the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - READ-ONLY; Gets the exception of the job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modified time of the job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - READ-ONLY; Gets the last status modified time of the job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for DscCompilationJobProperties.
func (dcjp DscCompilationJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcjp.Configuration != nil {
		objectMap["configuration"] = dcjp.Configuration
	}
	if dcjp.ProvisioningState != "" {
		objectMap["provisioningState"] = dcjp.ProvisioningState
	}
	if dcjp.RunOn != nil {
		objectMap["runOn"] = dcjp.RunOn
	}
	if dcjp.Status != "" {
		objectMap["status"] = dcjp.Status
	}
	if dcjp.StatusDetails != nil {
		objectMap["statusDetails"] = dcjp.StatusDetails
	}
	if dcjp.Parameters != nil {
		objectMap["parameters"] = dcjp.Parameters
	}
	return json.Marshal(objectMap)
}

// DscConfiguration definition of the configuration type.
type DscConfiguration struct {
	autorest.Response `json:"-"`
	// DscConfigurationProperties - Gets or sets the configuration properties.
	*DscConfigurationProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DscConfiguration.
func (dc DscConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DscConfigurationProperties != nil {
		objectMap["properties"] = dc.DscConfigurationProperties
	}
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	if dc.Tags != nil {
		objectMap["tags"] = dc.Tags
	}
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscConfiguration struct.
func (dc *DscConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscConfigurationProperties DscConfigurationProperties
				err = json.Unmarshal(*v, &dscConfigurationProperties)
				if err != nil {
					return err
				}
				dc.DscConfigurationProperties = &dscConfigurationProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dc.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dc.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dc.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		}
	}

	return nil
}

// DscConfigurationAssociationProperty the Dsc configuration property associated with the entity.
type DscConfigurationAssociationProperty struct {
	// Name - Gets or sets the name of the Dsc configuration.
	Name *string `json:"name,omitempty"`
}

// DscConfigurationCreateOrUpdateParameters the parameters supplied to the create or update configuration
// operation.
type DscConfigurationCreateOrUpdateParameters struct {
	// DscConfigurationCreateOrUpdateProperties - Gets or sets configuration create or update properties.
	*DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscConfigurationCreateOrUpdateParameters.
func (dccoup DscConfigurationCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dccoup.DscConfigurationCreateOrUpdateProperties != nil {
		objectMap["properties"] = dccoup.DscConfigurationCreateOrUpdateProperties
	}
	if dccoup.Name != nil {
		objectMap["name"] = dccoup.Name
	}
	if dccoup.Location != nil {
		objectMap["location"] = dccoup.Location
	}
	if dccoup.Tags != nil {
		objectMap["tags"] = dccoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscConfigurationCreateOrUpdateParameters struct.
func (dccoup *DscConfigurationCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscConfigurationCreateOrUpdateProperties DscConfigurationCreateOrUpdateProperties
				err = json.Unmarshal(*v, &dscConfigurationCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				dccoup.DscConfigurationCreateOrUpdateProperties = &dscConfigurationCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dccoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dccoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dccoup.Tags = tags
			}
		}
	}

	return nil
}

// DscConfigurationCreateOrUpdateProperties the properties to create or update configuration.
type DscConfigurationCreateOrUpdateProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// Parameters - Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters"`
	// Description - Gets or sets the description of the configuration.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for DscConfigurationCreateOrUpdateProperties.
func (dccoup DscConfigurationCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dccoup.LogVerbose != nil {
		objectMap["logVerbose"] = dccoup.LogVerbose
	}
	if dccoup.LogProgress != nil {
		objectMap["logProgress"] = dccoup.LogProgress
	}
	if dccoup.Source != nil {
		objectMap["source"] = dccoup.Source
	}
	if dccoup.Parameters != nil {
		objectMap["parameters"] = dccoup.Parameters
	}
	if dccoup.Description != nil {
		objectMap["description"] = dccoup.Description
	}
	return json.Marshal(objectMap)
}

// DscConfigurationListResult the response model for the list configuration operation.
type DscConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of configurations.
	Value *[]DscConfiguration `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
	// TotalCount - Gets the total number of configurations matching filter criteria.
	TotalCount *int32 `json:"totalCount,omitempty"`
}

// DscConfigurationListResultIterator provides access to a complete listing of DscConfiguration values.
type DscConfigurationListResultIterator struct {
	i    int
	page DscConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscConfigurationListResultIterator) Response() DscConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscConfigurationListResultIterator) Value() DscConfiguration {
	if !iter.page.NotDone() {
		return DscConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscConfigurationListResultIterator type.
func NewDscConfigurationListResultIterator(page DscConfigurationListResultPage) DscConfigurationListResultIterator {
	return DscConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DscConfigurationListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dclr DscConfigurationListResult) hasNextLink() bool {
	return dclr.NextLink != nil && len(*dclr.NextLink) != 0
}

// dscConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DscConfigurationListResult) dscConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DscConfigurationListResultPage contains a page of DscConfiguration values.
type DscConfigurationListResultPage struct {
	fn   func(context.Context, DscConfigurationListResult) (DscConfigurationListResult, error)
	dclr DscConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dclr)
		if err != nil {
			return err
		}
		page.dclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscConfigurationListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscConfigurationListResultPage) Response() DscConfigurationListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscConfigurationListResultPage) Values() []DscConfiguration {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// Creates a new instance of the DscConfigurationListResultPage type.
func NewDscConfigurationListResultPage(cur DscConfigurationListResult, getNextPage func(context.Context, DscConfigurationListResult) (DscConfigurationListResult, error)) DscConfigurationListResultPage {
	return DscConfigurationListResultPage{
		fn:   getNextPage,
		dclr: cur,
	}
}

// DscConfigurationParameter definition of the configuration parameter type.
type DscConfigurationParameter struct {
	// Type - Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// Position - Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`
	// DefaultValue - Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// DscConfigurationProperties definition of the configuration property type.
type DscConfigurationProperties struct {
	// ProvisioningState - Gets or sets the provisioning state of the configuration. Possible values include: 'Succeeded'
	ProvisioningState DscConfigurationProvisioningState `json:"provisioningState,omitempty"`
	// JobCount - Gets or sets the job count of the configuration.
	JobCount *int32 `json:"jobCount,omitempty"`
	// Parameters - Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter `json:"parameters"`
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// State - Gets or sets the state of the configuration. Possible values include: 'DscConfigurationStateNew', 'DscConfigurationStateEdit', 'DscConfigurationStatePublished'
	State DscConfigurationState `json:"state,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// NodeConfigurationCount - Gets the number of compiled node configurations.
	NodeConfigurationCount *int32 `json:"nodeConfigurationCount,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for DscConfigurationProperties.
func (dcp DscConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcp.ProvisioningState != "" {
		objectMap["provisioningState"] = dcp.ProvisioningState
	}
	if dcp.JobCount != nil {
		objectMap["jobCount"] = dcp.JobCount
	}
	if dcp.Parameters != nil {
		objectMap["parameters"] = dcp.Parameters
	}
	if dcp.Source != nil {
		objectMap["source"] = dcp.Source
	}
	if dcp.State != "" {
		objectMap["state"] = dcp.State
	}
	if dcp.LogVerbose != nil {
		objectMap["logVerbose"] = dcp.LogVerbose
	}
	if dcp.CreationTime != nil {
		objectMap["creationTime"] = dcp.CreationTime
	}
	if dcp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = dcp.LastModifiedTime
	}
	if dcp.NodeConfigurationCount != nil {
		objectMap["nodeConfigurationCount"] = dcp.NodeConfigurationCount
	}
	if dcp.Description != nil {
		objectMap["description"] = dcp.Description
	}
	return json.Marshal(objectMap)
}

// DscConfigurationUpdateParameters the parameters supplied to the create or update configuration
// operation.
type DscConfigurationUpdateParameters struct {
	// DscConfigurationCreateOrUpdateProperties - Gets or sets configuration create or update properties.
	*DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscConfigurationUpdateParameters.
func (dcup DscConfigurationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcup.DscConfigurationCreateOrUpdateProperties != nil {
		objectMap["properties"] = dcup.DscConfigurationCreateOrUpdateProperties
	}
	if dcup.Name != nil {
		objectMap["name"] = dcup.Name
	}
	if dcup.Tags != nil {
		objectMap["tags"] = dcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscConfigurationUpdateParameters struct.
func (dcup *DscConfigurationUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscConfigurationCreateOrUpdateProperties DscConfigurationCreateOrUpdateProperties
				err = json.Unmarshal(*v, &dscConfigurationCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				dcup.DscConfigurationCreateOrUpdateProperties = &dscConfigurationCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcup.Name = &name
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcup.Tags = tags
			}
		}
	}

	return nil
}

// DscMetaConfiguration definition of the DSC Meta Configuration.
type DscMetaConfiguration struct {
	// ConfigurationModeFrequencyMins - Gets or sets the ConfigurationModeFrequencyMins value of the meta configuration.
	ConfigurationModeFrequencyMins *int32 `json:"configurationModeFrequencyMins,omitempty"`
	// RebootNodeIfNeeded - Gets or sets the RebootNodeIfNeeded value of the meta configuration.
	RebootNodeIfNeeded *bool `json:"rebootNodeIfNeeded,omitempty"`
	// ConfigurationMode - Gets or sets the ConfigurationMode value of the meta configuration.
	ConfigurationMode *string `json:"configurationMode,omitempty"`
	// ActionAfterReboot - Gets or sets the ActionAfterReboot value of the meta configuration.
	ActionAfterReboot *string `json:"actionAfterReboot,omitempty"`
	// CertificateID - Gets or sets the CertificateId value of the meta configuration.
	CertificateID *string `json:"certificateId,omitempty"`
	// RefreshFrequencyMins - Gets or sets the RefreshFrequencyMins value of the meta configuration.
	RefreshFrequencyMins *int32 `json:"refreshFrequencyMins,omitempty"`
	// AllowModuleOverwrite - Gets or sets the AllowModuleOverwrite value of the meta configuration.
	AllowModuleOverwrite *bool `json:"allowModuleOverwrite,omitempty"`
}

// DscNode definition of the dsc node type.
type DscNode struct {
	autorest.Response `json:"-"`
	// LastSeen - Gets or sets the last seen time of the node.
	LastSeen *date.Time `json:"lastSeen,omitempty"`
	// RegistrationTime - Gets or sets the registration time of the node.
	RegistrationTime *date.Time `json:"registrationTime,omitempty"`
	// IP - Gets or sets the ip of the node.
	IP *string `json:"ip,omitempty"`
	// AccountID - Gets or sets the account id of the node.
	AccountID *string `json:"accountId,omitempty"`
	// NodeConfiguration - Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
	// Status - Gets or sets the status of the node.
	Status *string `json:"status,omitempty"`
	// NodeID - Gets or sets the node id.
	NodeID *string `json:"nodeId,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ExtensionHandler - Gets or sets the list of extensionHandler properties for a Node.
	ExtensionHandler *[]DscNodeExtensionHandlerAssociationProperty `json:"extensionHandler,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DscNode.
func (dn DscNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dn.LastSeen != nil {
		objectMap["lastSeen"] = dn.LastSeen
	}
	if dn.RegistrationTime != nil {
		objectMap["registrationTime"] = dn.RegistrationTime
	}
	if dn.IP != nil {
		objectMap["ip"] = dn.IP
	}
	if dn.AccountID != nil {
		objectMap["accountId"] = dn.AccountID
	}
	if dn.NodeConfiguration != nil {
		objectMap["nodeConfiguration"] = dn.NodeConfiguration
	}
	if dn.Status != nil {
		objectMap["status"] = dn.Status
	}
	if dn.NodeID != nil {
		objectMap["nodeId"] = dn.NodeID
	}
	if dn.Etag != nil {
		objectMap["etag"] = dn.Etag
	}
	if dn.ExtensionHandler != nil {
		objectMap["extensionHandler"] = dn.ExtensionHandler
	}
	return json.Marshal(objectMap)
}

// DscNodeConfiguration definition of the dsc node configuration.
type DscNodeConfiguration struct {
	autorest.Response `json:"-"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// CreationTime - Gets or sets creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Configuration - Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DscNodeConfiguration.
func (dnc DscNodeConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dnc.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = dnc.LastModifiedTime
	}
	if dnc.CreationTime != nil {
		objectMap["creationTime"] = dnc.CreationTime
	}
	if dnc.Configuration != nil {
		objectMap["configuration"] = dnc.Configuration
	}
	return json.Marshal(objectMap)
}

// DscNodeConfigurationAssociationProperty the dsc node configuration property associated with the entity.
type DscNodeConfigurationAssociationProperty struct {
	// Name - Gets or sets the name of the dsc node configuration.
	Name *string `json:"name,omitempty"`
}

// DscNodeConfigurationCreateOrUpdateParameters the parameters supplied to the create or update node
// configuration operation.
type DscNodeConfigurationCreateOrUpdateParameters struct {
	// Source - Gets or sets the source.
	Source *ContentSource `json:"source,omitempty"`
	// Name - Name of the node configuration.
	Name *string `json:"name,omitempty"`
	// Configuration - Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	// IncrementNodeConfigurationBuild - If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool `json:"incrementNodeConfigurationBuild,omitempty"`
}

// DscNodeConfigurationListResult the response model for the list job operation.
type DscNodeConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of Dsc node configurations.
	Value *[]DscNodeConfiguration `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeConfigurationListResultIterator provides access to a complete listing of DscNodeConfiguration
// values.
type DscNodeConfigurationListResultIterator struct {
	i    int
	page DscNodeConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscNodeConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeConfigurationListResultIterator) Response() DscNodeConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeConfigurationListResultIterator) Value() DscNodeConfiguration {
	if !iter.page.NotDone() {
		return DscNodeConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscNodeConfigurationListResultIterator type.
func NewDscNodeConfigurationListResultIterator(page DscNodeConfigurationListResultPage) DscNodeConfigurationListResultIterator {
	return DscNodeConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dnclr DscNodeConfigurationListResult) IsEmpty() bool {
	return dnclr.Value == nil || len(*dnclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dnclr DscNodeConfigurationListResult) hasNextLink() bool {
	return dnclr.NextLink != nil && len(*dnclr.NextLink) != 0
}

// dscNodeConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnclr DscNodeConfigurationListResult) dscNodeConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dnclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnclr.NextLink)))
}

// DscNodeConfigurationListResultPage contains a page of DscNodeConfiguration values.
type DscNodeConfigurationListResultPage struct {
	fn    func(context.Context, DscNodeConfigurationListResult) (DscNodeConfigurationListResult, error)
	dnclr DscNodeConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dnclr)
		if err != nil {
			return err
		}
		page.dnclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscNodeConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeConfigurationListResultPage) NotDone() bool {
	return !page.dnclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeConfigurationListResultPage) Response() DscNodeConfigurationListResult {
	return page.dnclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeConfigurationListResultPage) Values() []DscNodeConfiguration {
	if page.dnclr.IsEmpty() {
		return nil
	}
	return *page.dnclr.Value
}

// Creates a new instance of the DscNodeConfigurationListResultPage type.
func NewDscNodeConfigurationListResultPage(cur DscNodeConfigurationListResult, getNextPage func(context.Context, DscNodeConfigurationListResult) (DscNodeConfigurationListResult, error)) DscNodeConfigurationListResultPage {
	return DscNodeConfigurationListResultPage{
		fn:    getNextPage,
		dnclr: cur,
	}
}

// DscNodeExtensionHandlerAssociationProperty the dsc extensionHandler property associated with the node
type DscNodeExtensionHandlerAssociationProperty struct {
	// Name - Gets or sets the name of the extension handler.
	Name *string `json:"name,omitempty"`
	// Version - Gets or sets the version of the extension handler.
	Version *string `json:"version,omitempty"`
}

// DscNodeListResult the response model for the list dsc nodes operation.
type DscNodeListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of dsc nodes.
	Value *[]DscNode `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeListResultIterator provides access to a complete listing of DscNode values.
type DscNodeListResultIterator struct {
	i    int
	page DscNodeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscNodeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeListResultIterator) Response() DscNodeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeListResultIterator) Value() DscNode {
	if !iter.page.NotDone() {
		return DscNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscNodeListResultIterator type.
func NewDscNodeListResultIterator(page DscNodeListResultPage) DscNodeListResultIterator {
	return DscNodeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dnlr DscNodeListResult) IsEmpty() bool {
	return dnlr.Value == nil || len(*dnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dnlr DscNodeListResult) hasNextLink() bool {
	return dnlr.NextLink != nil && len(*dnlr.NextLink) != 0
}

// dscNodeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnlr DscNodeListResult) dscNodeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnlr.NextLink)))
}

// DscNodeListResultPage contains a page of DscNode values.
type DscNodeListResultPage struct {
	fn   func(context.Context, DscNodeListResult) (DscNodeListResult, error)
	dnlr DscNodeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dnlr)
		if err != nil {
			return err
		}
		page.dnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscNodeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeListResultPage) NotDone() bool {
	return !page.dnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeListResultPage) Response() DscNodeListResult {
	return page.dnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeListResultPage) Values() []DscNode {
	if page.dnlr.IsEmpty() {
		return nil
	}
	return *page.dnlr.Value
}

// Creates a new instance of the DscNodeListResultPage type.
func NewDscNodeListResultPage(cur DscNodeListResult, getNextPage func(context.Context, DscNodeListResult) (DscNodeListResult, error)) DscNodeListResultPage {
	return DscNodeListResultPage{
		fn:   getNextPage,
		dnlr: cur,
	}
}

// DscNodeReport definition of the dsc node report type.
type DscNodeReport struct {
	autorest.Response `json:"-"`
	// EndTime - Gets or sets the end time of the node report.
	EndTime *date.Time `json:"endTime,omitempty"`
	// LastModifiedTime - Gets or sets the lastModifiedTime of the node report.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// StartTime - Gets or sets the start time of the node report.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Type - Gets or sets the type of the node report.
	Type *string `json:"type,omitempty"`
	// ReportID - Gets or sets the id of the node report.
	ReportID *string `json:"reportId,omitempty"`
	// Status - Gets or sets the status of the node report.
	Status *string `json:"status,omitempty"`
	// RefreshMode - Gets or sets the refreshMode of the node report.
	RefreshMode *string `json:"refreshMode,omitempty"`
	// RebootRequested - Gets or sets the rebootRequested of the node report.
	RebootRequested *string `json:"rebootRequested,omitempty"`
	// ReportFormatVersion - Gets or sets the reportFormatVersion of the node report.
	ReportFormatVersion *string `json:"reportFormatVersion,omitempty"`
	// ConfigurationVersion - Gets or sets the configurationVersion of the node report.
	ConfigurationVersion *string `json:"configurationVersion,omitempty"`
	// ID - Gets or sets the id.
	ID *string `json:"id,omitempty"`
	// Errors - Gets or sets the errors for the node report.
	Errors *[]DscReportError `json:"errors,omitempty"`
	// Resources - Gets or sets the resource for the node report.
	Resources *[]DscReportResource `json:"resources,omitempty"`
	// MetaConfiguration - Gets or sets the metaConfiguration of the node at the time of the report.
	MetaConfiguration *DscMetaConfiguration `json:"metaConfiguration,omitempty"`
	// HostName - Gets or sets the hostname of the node that sent the report.
	HostName *string `json:"hostName,omitempty"`
	// IPV4Addresses - Gets or sets the IPv4 address of the node that sent the report.
	IPV4Addresses *[]string `json:"iPV4Addresses,omitempty"`
	// IPV6Addresses - Gets or sets the IPv6 address of the node that sent the report.
	IPV6Addresses *[]string `json:"iPV6Addresses,omitempty"`
	// NumberOfResources - Gets or sets the number of resource in the node report.
	NumberOfResources *int32 `json:"numberOfResources,omitempty"`
	// RawErrors - Gets or sets the unparsed errors for the node report.
	RawErrors *string `json:"rawErrors,omitempty"`
}

// DscNodeReportListResult the response model for the list dsc nodes operation.
type DscNodeReportListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of dsc node reports.
	Value *[]DscNodeReport `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// DscNodeReportListResultIterator provides access to a complete listing of DscNodeReport values.
type DscNodeReportListResultIterator struct {
	i    int
	page DscNodeReportListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscNodeReportListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeReportListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscNodeReportListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscNodeReportListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscNodeReportListResultIterator) Response() DscNodeReportListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscNodeReportListResultIterator) Value() DscNodeReport {
	if !iter.page.NotDone() {
		return DscNodeReport{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscNodeReportListResultIterator type.
func NewDscNodeReportListResultIterator(page DscNodeReportListResultPage) DscNodeReportListResultIterator {
	return DscNodeReportListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dnrlr DscNodeReportListResult) IsEmpty() bool {
	return dnrlr.Value == nil || len(*dnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dnrlr DscNodeReportListResult) hasNextLink() bool {
	return dnrlr.NextLink != nil && len(*dnrlr.NextLink) != 0
}

// dscNodeReportListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dnrlr DscNodeReportListResult) dscNodeReportListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dnrlr.NextLink)))
}

// DscNodeReportListResultPage contains a page of DscNodeReport values.
type DscNodeReportListResultPage struct {
	fn    func(context.Context, DscNodeReportListResult) (DscNodeReportListResult, error)
	dnrlr DscNodeReportListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscNodeReportListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscNodeReportListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dnrlr)
		if err != nil {
			return err
		}
		page.dnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscNodeReportListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscNodeReportListResultPage) NotDone() bool {
	return !page.dnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscNodeReportListResultPage) Response() DscNodeReportListResult {
	return page.dnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscNodeReportListResultPage) Values() []DscNodeReport {
	if page.dnrlr.IsEmpty() {
		return nil
	}
	return *page.dnrlr.Value
}

// Creates a new instance of the DscNodeReportListResultPage type.
func NewDscNodeReportListResultPage(cur DscNodeReportListResult, getNextPage func(context.Context, DscNodeReportListResult) (DscNodeReportListResult, error)) DscNodeReportListResultPage {
	return DscNodeReportListResultPage{
		fn:    getNextPage,
		dnrlr: cur,
	}
}

// DscNodeUpdateParameters the parameters supplied to the update dsc node operation.
type DscNodeUpdateParameters struct {
	// NodeID - Gets or sets the id of the dsc node.
	NodeID *string `json:"nodeId,omitempty"`
	// NodeConfiguration - Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
}

// DscReportError definition of the dsc node report error type.
type DscReportError struct {
	// ErrorSource - Gets or sets the source of the error.
	ErrorSource *string `json:"errorSource,omitempty"`
	// ResourceID - Gets or sets the resource ID which generated the error.
	ResourceID *string `json:"resourceId,omitempty"`
	// ErrorCode - Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Locale - Gets or sets the locale of the error.
	Locale *string `json:"locale,omitempty"`
	// ErrorDetails - Gets or sets the error details.
	ErrorDetails *string `json:"errorDetails,omitempty"`
}

// DscReportResource definition of the DSC Report Resource.
type DscReportResource struct {
	// ResourceID - Gets or sets the ID of the resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// SourceInfo - Gets or sets the source info of the resource.
	SourceInfo *string `json:"sourceInfo,omitempty"`
	// DependsOn - Gets or sets the Resource Navigation values for resources the resource depends on.
	DependsOn *[]DscReportResourceNavigation `json:"dependsOn,omitempty"`
	// ModuleName - Gets or sets the module name of the resource.
	ModuleName *string `json:"moduleName,omitempty"`
	// ModuleVersion - Gets or sets the module version of the resource.
	ModuleVersion *string `json:"moduleVersion,omitempty"`
	// ResourceName - Gets or sets the name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// Error - Gets or sets the error of the resource.
	Error *string `json:"error,omitempty"`
	// Status - Gets or sets the status of the resource.
	Status *string `json:"status,omitempty"`
	// DurationInSeconds - Gets or sets the duration in seconds for the resource.
	DurationInSeconds *float64 `json:"durationInSeconds,omitempty"`
	// StartDate - Gets or sets the start date of the resource.
	StartDate *date.Time `json:"startDate,omitempty"`
}

// DscReportResourceNavigation navigation for DSC Report Resource.
type DscReportResourceNavigation struct {
	// ResourceID - Gets or sets the ID of the resource to navigate to.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ErrorResponse error response of an operation failure
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FieldDefinition definition of the connection fields.
type FieldDefinition struct {
	// IsEncrypted - Gets or sets the isEncrypted flag of the connection field definition.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
	// IsOptional - Gets or sets the isOptional flag of the connection field definition.
	IsOptional *bool `json:"isOptional,omitempty"`
	// Type - Gets or sets the type of the connection field definition.
	Type *string `json:"type,omitempty"`
}

// HybridRunbookWorker definition of hybrid runbook worker.
type HybridRunbookWorker struct {
	// Name - Gets or sets the worker machine name.
	Name *string `json:"name,omitempty"`
	// IP - Gets or sets the assigned machine IP address.
	IP *string `json:"ip,omitempty"`
	// RegistrationTime - Gets or sets the registration time of the worker machine.
	RegistrationTime *date.Time `json:"registrationTime,omitempty"`
	// LastSeenDateTime - Last Heartbeat from the Worker
	LastSeenDateTime *date.Time `json:"lastSeenDateTime,omitempty"`
}

// HybridRunbookWorkerGroup definition of hybrid runbook worker group.
type HybridRunbookWorkerGroup struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of the group.
	Name *string `json:"name,omitempty"`
	// HybridRunbookWorkers - Gets or sets the list of hybrid runbook workers.
	HybridRunbookWorkers *[]HybridRunbookWorker `json:"hybridRunbookWorkers,omitempty"`
	// Credential - Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
	// GroupType - Type of the HybridWorkerGroup. Possible values include: 'User', 'System'
	GroupType GroupTypeEnum `json:"groupType,omitempty"`
}

// HybridRunbookWorkerGroupsListResult the response model for the list hybrid runbook worker groups.
type HybridRunbookWorkerGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of hybrid runbook worker groups.
	Value *[]HybridRunbookWorkerGroup `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridRunbookWorkerGroupsListResultIterator provides access to a complete listing of
// HybridRunbookWorkerGroup values.
type HybridRunbookWorkerGroupsListResultIterator struct {
	i    int
	page HybridRunbookWorkerGroupsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HybridRunbookWorkerGroupsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridRunbookWorkerGroupsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HybridRunbookWorkerGroupsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HybridRunbookWorkerGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HybridRunbookWorkerGroupsListResultIterator) Response() HybridRunbookWorkerGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HybridRunbookWorkerGroupsListResultIterator) Value() HybridRunbookWorkerGroup {
	if !iter.page.NotDone() {
		return HybridRunbookWorkerGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HybridRunbookWorkerGroupsListResultIterator type.
func NewHybridRunbookWorkerGroupsListResultIterator(page HybridRunbookWorkerGroupsListResultPage) HybridRunbookWorkerGroupsListResultIterator {
	return HybridRunbookWorkerGroupsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hrwglr HybridRunbookWorkerGroupsListResult) IsEmpty() bool {
	return hrwglr.Value == nil || len(*hrwglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hrwglr HybridRunbookWorkerGroupsListResult) hasNextLink() bool {
	return hrwglr.NextLink != nil && len(*hrwglr.NextLink) != 0
}

// hybridRunbookWorkerGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hrwglr HybridRunbookWorkerGroupsListResult) hybridRunbookWorkerGroupsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !hrwglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hrwglr.NextLink)))
}

// HybridRunbookWorkerGroupsListResultPage contains a page of HybridRunbookWorkerGroup values.
type HybridRunbookWorkerGroupsListResultPage struct {
	fn     func(context.Context, HybridRunbookWorkerGroupsListResult) (HybridRunbookWorkerGroupsListResult, error)
	hrwglr HybridRunbookWorkerGroupsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HybridRunbookWorkerGroupsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridRunbookWorkerGroupsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hrwglr)
		if err != nil {
			return err
		}
		page.hrwglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HybridRunbookWorkerGroupsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HybridRunbookWorkerGroupsListResultPage) NotDone() bool {
	return !page.hrwglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HybridRunbookWorkerGroupsListResultPage) Response() HybridRunbookWorkerGroupsListResult {
	return page.hrwglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HybridRunbookWorkerGroupsListResultPage) Values() []HybridRunbookWorkerGroup {
	if page.hrwglr.IsEmpty() {
		return nil
	}
	return *page.hrwglr.Value
}

// Creates a new instance of the HybridRunbookWorkerGroupsListResultPage type.
func NewHybridRunbookWorkerGroupsListResultPage(cur HybridRunbookWorkerGroupsListResult, getNextPage func(context.Context, HybridRunbookWorkerGroupsListResult) (HybridRunbookWorkerGroupsListResult, error)) HybridRunbookWorkerGroupsListResultPage {
	return HybridRunbookWorkerGroupsListResultPage{
		fn:     getNextPage,
		hrwglr: cur,
	}
}

// HybridRunbookWorkerGroupUpdateParameters parameters supplied to the update operation.
type HybridRunbookWorkerGroupUpdateParameters struct {
	// Credential - Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// Job definition of the job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - The properties of the job.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCollectionItem job collection item properties.
type JobCollectionItem struct {
	// JobCollectionItemProperties - Job properties.
	*JobCollectionItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCollectionItem.
func (jci JobCollectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jci.JobCollectionItemProperties != nil {
		objectMap["properties"] = jci.JobCollectionItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCollectionItem struct.
func (jci *JobCollectionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCollectionItemProperties JobCollectionItemProperties
				err = json.Unmarshal(*v, &jobCollectionItemProperties)
				if err != nil {
					return err
				}
				jci.JobCollectionItemProperties = &jobCollectionItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jci.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCollectionItemProperties job collection item properties.
type JobCollectionItemProperties struct {
	// Runbook - READ-ONLY; The runbook association.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// JobID - READ-ONLY; The id of the job.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - READ-ONLY; The status of the job. Possible values include: 'JobStatusNew', 'JobStatusActivating', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusStopped', 'JobStatusBlocked', 'JobStatusSuspended', 'JobStatusDisconnected', 'JobStatusSuspending', 'JobStatusStopping', 'JobStatusResuming', 'JobStatusRemoving'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - READ-ONLY; The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// LastModifiedTime - READ-ONLY; The last modified time of the job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of a resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RunOn - Specifies the runOn group name where the job was executed.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCollectionItemProperties.
func (jcip JobCollectionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcip.RunOn != nil {
		objectMap["runOn"] = jcip.RunOn
	}
	return json.Marshal(objectMap)
}

// JobCreateParameters the parameters supplied to the create job operation.
type JobCreateParameters struct {
	// JobCreateProperties - Gets or sets the list of job properties.
	*JobCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCreateParameters.
func (jcp JobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.JobCreateProperties != nil {
		objectMap["properties"] = jcp.JobCreateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCreateParameters struct.
func (jcp *JobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCreateProperties JobCreateProperties
				err = json.Unmarshal(*v, &jobCreateProperties)
				if err != nil {
					return err
				}
				jcp.JobCreateProperties = &jobCreateProperties
			}
		}
	}

	return nil
}

// JobCreateProperties ...
type JobCreateProperties struct {
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCreateProperties.
func (jcp JobCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.Runbook != nil {
		objectMap["runbook"] = jcp.Runbook
	}
	if jcp.Parameters != nil {
		objectMap["parameters"] = jcp.Parameters
	}
	if jcp.RunOn != nil {
		objectMap["runOn"] = jcp.RunOn
	}
	return json.Marshal(objectMap)
}

// JobListResultV2 the response model for the list job operation.
type JobListResultV2 struct {
	autorest.Response `json:"-"`
	// Value - List of jobs.
	Value *[]JobCollectionItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The  link to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobListResultV2.
func (jlrv JobListResultV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jlrv.Value != nil {
		objectMap["value"] = jlrv.Value
	}
	return json.Marshal(objectMap)
}

// JobListResultV2Iterator provides access to a complete listing of JobCollectionItem values.
type JobListResultV2Iterator struct {
	i    int
	page JobListResultV2Page
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultV2Iterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultV2Iterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultV2Iterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultV2Iterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultV2Iterator) Response() JobListResultV2 {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultV2Iterator) Value() JobCollectionItem {
	if !iter.page.NotDone() {
		return JobCollectionItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultV2Iterator type.
func NewJobListResultV2Iterator(page JobListResultV2Page) JobListResultV2Iterator {
	return JobListResultV2Iterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlrv JobListResultV2) IsEmpty() bool {
	return jlrv.Value == nil || len(*jlrv.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jlrv JobListResultV2) hasNextLink() bool {
	return jlrv.NextLink != nil && len(*jlrv.NextLink) != 0
}

// jobListResultV2Preparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlrv JobListResultV2) jobListResultV2Preparer(ctx context.Context) (*http.Request, error) {
	if !jlrv.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlrv.NextLink)))
}

// JobListResultV2Page contains a page of JobCollectionItem values.
type JobListResultV2Page struct {
	fn   func(context.Context, JobListResultV2) (JobListResultV2, error)
	jlrv JobListResultV2
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultV2Page) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultV2Page.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jlrv)
		if err != nil {
			return err
		}
		page.jlrv = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultV2Page) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultV2Page) NotDone() bool {
	return !page.jlrv.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultV2Page) Response() JobListResultV2 {
	return page.jlrv
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultV2Page) Values() []JobCollectionItem {
	if page.jlrv.IsEmpty() {
		return nil
	}
	return *page.jlrv.Value
}

// Creates a new instance of the JobListResultV2Page type.
func NewJobListResultV2Page(cur JobListResultV2, getNextPage func(context.Context, JobListResultV2) (JobListResultV2, error)) JobListResultV2Page {
	return JobListResultV2Page{
		fn:   getNextPage,
		jlrv: cur,
	}
}

// JobNavigation software update configuration machine run job navigation properties.
type JobNavigation struct {
	// ID - READ-ONLY; Id of the job associated with the software update configuration run
	ID *string `json:"id,omitempty"`
}

// JobProperties definition of job properties.
type JobProperties struct {
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// StartedBy - Gets or sets the job started by.
	StartedBy *string `json:"startedBy,omitempty"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
	// JobID - Gets or sets the id of the job.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// CreationTime - Gets or sets the creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - Gets or sets the status of the job. Possible values include: 'JobStatusNew', 'JobStatusActivating', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusStopped', 'JobStatusBlocked', 'JobStatusSuspended', 'JobStatusDisconnected', 'JobStatusSuspending', 'JobStatusStopping', 'JobStatusResuming', 'JobStatusRemoving'
	Status JobStatus `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// StartTime - Gets or sets the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets or sets the end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - Gets or sets the exception of the job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - Gets or sets the last status modified time of the job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// ProvisioningState - The current provisioning state of the job. Possible values include: 'JobProvisioningStateFailed', 'JobProvisioningStateSucceeded', 'JobProvisioningStateSuspended', 'JobProvisioningStateProcessing'
	ProvisioningState JobProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Runbook != nil {
		objectMap["runbook"] = jp.Runbook
	}
	if jp.StartedBy != nil {
		objectMap["startedBy"] = jp.StartedBy
	}
	if jp.RunOn != nil {
		objectMap["runOn"] = jp.RunOn
	}
	if jp.JobID != nil {
		objectMap["jobId"] = jp.JobID
	}
	if jp.CreationTime != nil {
		objectMap["creationTime"] = jp.CreationTime
	}
	if jp.Status != "" {
		objectMap["status"] = jp.Status
	}
	if jp.StatusDetails != nil {
		objectMap["statusDetails"] = jp.StatusDetails
	}
	if jp.StartTime != nil {
		objectMap["startTime"] = jp.StartTime
	}
	if jp.EndTime != nil {
		objectMap["endTime"] = jp.EndTime
	}
	if jp.Exception != nil {
		objectMap["exception"] = jp.Exception
	}
	if jp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = jp.LastModifiedTime
	}
	if jp.LastStatusModifiedTime != nil {
		objectMap["lastStatusModifiedTime"] = jp.LastStatusModifiedTime
	}
	if jp.Parameters != nil {
		objectMap["parameters"] = jp.Parameters
	}
	if jp.ProvisioningState != "" {
		objectMap["provisioningState"] = jp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// JobSchedule definition of the job schedule.
type JobSchedule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the name of the variable.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// JobScheduleProperties - Gets or sets the properties of the job schedule.
	*JobScheduleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobSchedule.
func (js JobSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobScheduleProperties != nil {
		objectMap["properties"] = js.JobScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobSchedule struct.
func (js *JobSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var jobScheduleProperties JobScheduleProperties
				err = json.Unmarshal(*v, &jobScheduleProperties)
				if err != nil {
					return err
				}
				js.JobScheduleProperties = &jobScheduleProperties
			}
		}
	}

	return nil
}

// JobScheduleCreateParameters the parameters supplied to the create job schedule operation.
type JobScheduleCreateParameters struct {
	// JobScheduleCreateProperties - Gets or sets the list of job schedule properties.
	*JobScheduleCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobScheduleCreateParameters.
func (jscp JobScheduleCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jscp.JobScheduleCreateProperties != nil {
		objectMap["properties"] = jscp.JobScheduleCreateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobScheduleCreateParameters struct.
func (jscp *JobScheduleCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobScheduleCreateProperties JobScheduleCreateProperties
				err = json.Unmarshal(*v, &jobScheduleCreateProperties)
				if err != nil {
					return err
				}
				jscp.JobScheduleCreateProperties = &jobScheduleCreateProperties
			}
		}
	}

	return nil
}

// JobScheduleCreateProperties the parameters supplied to the create job schedule operation.
type JobScheduleCreateProperties struct {
	// Schedule - Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets a list of job properties.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for JobScheduleCreateProperties.
func (jscp JobScheduleCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jscp.Schedule != nil {
		objectMap["schedule"] = jscp.Schedule
	}
	if jscp.Runbook != nil {
		objectMap["runbook"] = jscp.Runbook
	}
	if jscp.RunOn != nil {
		objectMap["runOn"] = jscp.RunOn
	}
	if jscp.Parameters != nil {
		objectMap["parameters"] = jscp.Parameters
	}
	return json.Marshal(objectMap)
}

// JobScheduleListResult the response model for the list job schedule operation.
type JobScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of job schedules.
	Value *[]JobSchedule `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobScheduleListResultIterator provides access to a complete listing of JobSchedule values.
type JobScheduleListResultIterator struct {
	i    int
	page JobScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobScheduleListResultIterator) Response() JobScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobScheduleListResultIterator) Value() JobSchedule {
	if !iter.page.NotDone() {
		return JobSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobScheduleListResultIterator type.
func NewJobScheduleListResultIterator(page JobScheduleListResultPage) JobScheduleListResultIterator {
	return JobScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobScheduleListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jslr JobScheduleListResult) hasNextLink() bool {
	return jslr.NextLink != nil && len(*jslr.NextLink) != 0
}

// jobScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobScheduleListResult) jobScheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobScheduleListResultPage contains a page of JobSchedule values.
type JobScheduleListResultPage struct {
	fn   func(context.Context, JobScheduleListResult) (JobScheduleListResult, error)
	jslr JobScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jslr)
		if err != nil {
			return err
		}
		page.jslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobScheduleListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobScheduleListResultPage) Response() JobScheduleListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobScheduleListResultPage) Values() []JobSchedule {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobScheduleListResultPage type.
func NewJobScheduleListResultPage(cur JobScheduleListResult, getNextPage func(context.Context, JobScheduleListResult) (JobScheduleListResult, error)) JobScheduleListResultPage {
	return JobScheduleListResultPage{
		fn:   getNextPage,
		jslr: cur,
	}
}

// JobScheduleProperties definition of job schedule parameters.
type JobScheduleProperties struct {
	// JobScheduleID - Gets or sets the id of job schedule.
	JobScheduleID *string `json:"jobScheduleId,omitempty"`
	// Schedule - Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty `json:"schedule,omitempty"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets the parameters of the job schedule.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for JobScheduleProperties.
func (jsp JobScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jsp.JobScheduleID != nil {
		objectMap["jobScheduleId"] = jsp.JobScheduleID
	}
	if jsp.Schedule != nil {
		objectMap["schedule"] = jsp.Schedule
	}
	if jsp.Runbook != nil {
		objectMap["runbook"] = jsp.Runbook
	}
	if jsp.RunOn != nil {
		objectMap["runOn"] = jsp.RunOn
	}
	if jsp.Parameters != nil {
		objectMap["parameters"] = jsp.Parameters
	}
	return json.Marshal(objectMap)
}

// JobStream definition of the job stream.
type JobStream struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// JobStreamProperties - Gets or sets the id of the job stream.
	*JobStreamProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStream.
func (js JobStream) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.ID != nil {
		objectMap["id"] = js.ID
	}
	if js.JobStreamProperties != nil {
		objectMap["properties"] = js.JobStreamProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobStream struct.
func (js *JobStream) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "properties":
			if v != nil {
				var jobStreamProperties JobStreamProperties
				err = json.Unmarshal(*v, &jobStreamProperties)
				if err != nil {
					return err
				}
				js.JobStreamProperties = &jobStreamProperties
			}
		}
	}

	return nil
}

// JobStreamListResult the response model for the list job stream operation.
type JobStreamListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of job streams.
	Value *[]JobStream `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobStreamListResultIterator provides access to a complete listing of JobStream values.
type JobStreamListResultIterator struct {
	i    int
	page JobStreamListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStreamListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStreamListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobStreamListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStreamListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStreamListResultIterator) Response() JobStreamListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStreamListResultIterator) Value() JobStream {
	if !iter.page.NotDone() {
		return JobStream{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobStreamListResultIterator type.
func NewJobStreamListResultIterator(page JobStreamListResultPage) JobStreamListResultIterator {
	return JobStreamListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStreamListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jslr JobStreamListResult) hasNextLink() bool {
	return jslr.NextLink != nil && len(*jslr.NextLink) != 0
}

// jobStreamListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStreamListResult) jobStreamListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStreamListResultPage contains a page of JobStream values.
type JobStreamListResultPage struct {
	fn   func(context.Context, JobStreamListResult) (JobStreamListResult, error)
	jslr JobStreamListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStreamListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStreamListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jslr)
		if err != nil {
			return err
		}
		page.jslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobStreamListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStreamListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStreamListResultPage) Response() JobStreamListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStreamListResultPage) Values() []JobStream {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobStreamListResultPage type.
func NewJobStreamListResultPage(cur JobStreamListResult, getNextPage func(context.Context, JobStreamListResult) (JobStreamListResult, error)) JobStreamListResultPage {
	return JobStreamListResultPage{
		fn:   getNextPage,
		jslr: cur,
	}
}

// JobStreamProperties definition of the job stream.
type JobStreamProperties struct {
	// JobStreamID - Gets or sets the id of the job stream.
	JobStreamID *string `json:"jobStreamId,omitempty"`
	// Time - Gets or sets the creation time of the job.
	Time *date.Time `json:"time,omitempty"`
	// StreamType - Gets or sets the stream type. Possible values include: 'Progress', 'Output', 'Warning', 'Error', 'Debug', 'Verbose', 'Any'
	StreamType JobStreamType `json:"streamType,omitempty"`
	// StreamText - Gets or sets the stream text.
	StreamText *string `json:"streamText,omitempty"`
	// Summary - Gets or sets the summary.
	Summary *string `json:"summary,omitempty"`
	// Value - Gets or sets the values of the job stream.
	Value map[string]interface{} `json:"value"`
}

// MarshalJSON is the custom marshaler for JobStreamProperties.
func (jsp JobStreamProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jsp.JobStreamID != nil {
		objectMap["jobStreamId"] = jsp.JobStreamID
	}
	if jsp.Time != nil {
		objectMap["time"] = jsp.Time
	}
	if jsp.StreamType != "" {
		objectMap["streamType"] = jsp.StreamType
	}
	if jsp.StreamText != nil {
		objectMap["streamText"] = jsp.StreamText
	}
	if jsp.Summary != nil {
		objectMap["summary"] = jsp.Summary
	}
	if jsp.Value != nil {
		objectMap["value"] = jsp.Value
	}
	return json.Marshal(objectMap)
}

// Key automation key which is used to register a DSC Node
type Key struct {
	// KeyName - READ-ONLY; Automation key name. Possible values include: 'KeyNamePrimary', 'KeyNameSecondary'
	KeyName KeyName `json:"KeyName,omitempty"`
	// Permissions - READ-ONLY; Automation key permissions. Possible values include: 'Read', 'Full'
	Permissions KeyPermissions `json:"Permissions,omitempty"`
	// Value - READ-ONLY; Value of the Automation Key used for registration.
	Value *string `json:"Value,omitempty"`
}

// KeyListResult ...
type KeyListResult struct {
	autorest.Response `json:"-"`
	// Keys - Lists the automation keys.
	Keys *[]Key `json:"keys,omitempty"`
}

// LinkedWorkspace definition of the linked workspace.
type LinkedWorkspace struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the id of the linked workspace.
	ID *string `json:"id,omitempty"`
}

// LinuxProperties linux specific update configuration.
type LinuxProperties struct {
	// IncludedPackageClassifications - Update classifications included in the software update configuration. Possible values include: 'Unclassified', 'Critical', 'Security', 'Other'
	IncludedPackageClassifications LinuxUpdateClasses `json:"includedPackageClassifications,omitempty"`
	// ExcludedPackageNameMasks - packages excluded from the software update configuration.
	ExcludedPackageNameMasks *[]string `json:"excludedPackageNameMasks,omitempty"`
	// IncludedPackageNameMasks - packages included from the software update configuration.
	IncludedPackageNameMasks *[]string `json:"includedPackageNameMasks,omitempty"`
	// RebootSetting - Reboot setting for the software update configuration.
	RebootSetting *string `json:"rebootSetting,omitempty"`
}

// Module definition of the module type.
type Module struct {
	autorest.Response `json:"-"`
	// ModuleProperties - Gets or sets the module properties.
	*ModuleProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Module.
func (mVar Module) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ModuleProperties != nil {
		objectMap["properties"] = mVar.ModuleProperties
	}
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Module struct.
func (mVar *Module) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleProperties ModuleProperties
				err = json.Unmarshal(*v, &moduleProperties)
				if err != nil {
					return err
				}
				mVar.ModuleProperties = &moduleProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// ModuleCreateOrUpdateParameters the parameters supplied to the create or update module operation.
type ModuleCreateOrUpdateParameters struct {
	// ModuleCreateOrUpdateProperties - Gets or sets the module create properties.
	*ModuleCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModuleCreateOrUpdateParameters.
func (mcoup ModuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcoup.ModuleCreateOrUpdateProperties != nil {
		objectMap["properties"] = mcoup.ModuleCreateOrUpdateProperties
	}
	if mcoup.Name != nil {
		objectMap["name"] = mcoup.Name
	}
	if mcoup.Location != nil {
		objectMap["location"] = mcoup.Location
	}
	if mcoup.Tags != nil {
		objectMap["tags"] = mcoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ModuleCreateOrUpdateParameters struct.
func (mcoup *ModuleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleCreateOrUpdateProperties ModuleCreateOrUpdateProperties
				err = json.Unmarshal(*v, &moduleCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				mcoup.ModuleCreateOrUpdateProperties = &moduleCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mcoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcoup.Tags = tags
			}
		}
	}

	return nil
}

// ModuleCreateOrUpdateProperties the parameters supplied to the create or update module properties.
type ModuleCreateOrUpdateProperties struct {
	// ContentLink - Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// ModuleErrorInfo definition of the module error info type.
type ModuleErrorInfo struct {
	// Code - Gets or sets the error code.
	Code *string `json:"code,omitempty"`
	// Message - Gets or sets the error message.
	Message *string `json:"message,omitempty"`
}

// ModuleListResult the response model for the list module operation.
type ModuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of modules.
	Value *[]Module `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ModuleListResultIterator provides access to a complete listing of Module values.
type ModuleListResultIterator struct {
	i    int
	page ModuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ModuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ModuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ModuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ModuleListResultIterator) Response() ModuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ModuleListResultIterator) Value() Module {
	if !iter.page.NotDone() {
		return Module{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ModuleListResultIterator type.
func NewModuleListResultIterator(page ModuleListResultPage) ModuleListResultIterator {
	return ModuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mlr ModuleListResult) IsEmpty() bool {
	return mlr.Value == nil || len(*mlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mlr ModuleListResult) hasNextLink() bool {
	return mlr.NextLink != nil && len(*mlr.NextLink) != 0
}

// moduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mlr ModuleListResult) moduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mlr.NextLink)))
}

// ModuleListResultPage contains a page of Module values.
type ModuleListResultPage struct {
	fn  func(context.Context, ModuleListResult) (ModuleListResult, error)
	mlr ModuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ModuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mlr)
		if err != nil {
			return err
		}
		page.mlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ModuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ModuleListResultPage) NotDone() bool {
	return !page.mlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ModuleListResultPage) Response() ModuleListResult {
	return page.mlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ModuleListResultPage) Values() []Module {
	if page.mlr.IsEmpty() {
		return nil
	}
	return *page.mlr.Value
}

// Creates a new instance of the ModuleListResultPage type.
func NewModuleListResultPage(cur ModuleListResult, getNextPage func(context.Context, ModuleListResult) (ModuleListResult, error)) ModuleListResultPage {
	return ModuleListResultPage{
		fn:  getNextPage,
		mlr: cur,
	}
}

// ModuleProperties definition of the module property type.
type ModuleProperties struct {
	// IsGlobal - Gets or sets the isGlobal flag of the module.
	IsGlobal *bool `json:"isGlobal,omitempty"`
	// Version - Gets or sets the version of the module.
	Version *string `json:"version,omitempty"`
	// SizeInBytes - Gets or sets the size in bytes of the module.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// ActivityCount - Gets or sets the activity count of the module.
	ActivityCount *int32 `json:"activityCount,omitempty"`
	// ProvisioningState - Gets or sets the provisioning state of the module. Possible values include: 'ModuleProvisioningStateCreated', 'ModuleProvisioningStateCreating', 'ModuleProvisioningStateStartingImportModuleRunbook', 'ModuleProvisioningStateRunningImportModuleRunbook', 'ModuleProvisioningStateContentRetrieved', 'ModuleProvisioningStateContentDownloaded', 'ModuleProvisioningStateContentValidated', 'ModuleProvisioningStateConnectionTypeImported', 'ModuleProvisioningStateContentStored', 'ModuleProvisioningStateModuleDataStored', 'ModuleProvisioningStateActivitiesStored', 'ModuleProvisioningStateModuleImportRunbookComplete', 'ModuleProvisioningStateSucceeded', 'ModuleProvisioningStateFailed', 'ModuleProvisioningStateCancelled', 'ModuleProvisioningStateUpdating'
	ProvisioningState ModuleProvisioningState `json:"provisioningState,omitempty"`
	// ContentLink - Gets or sets the contentLink of the module.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
	// Error - Gets or sets the error info of the module.
	Error *ModuleErrorInfo `json:"error,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
	// IsComposite - Gets or sets type of module, if its composite or not.
	IsComposite *bool `json:"isComposite,omitempty"`
}

// ModuleUpdateParameters the parameters supplied to the update module operation.
type ModuleUpdateParameters struct {
	// ModuleUpdateProperties - Gets or sets the module update properties.
	*ModuleUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModuleUpdateParameters.
func (mup ModuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mup.ModuleUpdateProperties != nil {
		objectMap["properties"] = mup.ModuleUpdateProperties
	}
	if mup.Name != nil {
		objectMap["name"] = mup.Name
	}
	if mup.Location != nil {
		objectMap["location"] = mup.Location
	}
	if mup.Tags != nil {
		objectMap["tags"] = mup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ModuleUpdateParameters struct.
func (mup *ModuleUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var moduleUpdateProperties ModuleUpdateProperties
				err = json.Unmarshal(*v, &moduleUpdateProperties)
				if err != nil {
					return err
				}
				mup.ModuleUpdateProperties = &moduleUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mup.Tags = tags
			}
		}
	}

	return nil
}

// ModuleUpdateProperties the parameters supplied to the update properties.
type ModuleUpdateProperties struct {
	// ContentLink - Gets or sets the module content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// NonAzureQueryProperties non Azure query for the update configuration.
type NonAzureQueryProperties struct {
	// FunctionAlias - Log Analytics Saved Search name.
	FunctionAlias *string `json:"functionAlias,omitempty"`
	// WorkspaceID - Workspace Id for Log Analytics in which the saved Search is resided.
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// Operation automation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Provider, Resource and Operation values
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay provider, Resource and Operation values
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Automation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Runbooks, Jobs etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult the response model for the list of Automation operations
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Automation operations supported by the Automation resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// RunAsCredentialAssociationProperty definition of RunAs credential to use for hybrid worker.
type RunAsCredentialAssociationProperty struct {
	// Name - Gets or sets the name of the credential.
	Name *string `json:"name,omitempty"`
}

// Runbook definition of the runbook type.
type Runbook struct {
	autorest.Response `json:"-"`
	// RunbookProperties - Gets or sets the runbook properties.
	*RunbookProperties `json:"properties,omitempty"`
	// Etag - Gets or sets the etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Runbook.
func (r Runbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RunbookProperties != nil {
		objectMap["properties"] = r.RunbookProperties
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Runbook struct.
func (r *Runbook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookProperties RunbookProperties
				err = json.Unmarshal(*v, &runbookProperties)
				if err != nil {
					return err
				}
				r.RunbookProperties = &runbookProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		}
	}

	return nil
}

// RunbookAssociationProperty the runbook property associated with the entity.
type RunbookAssociationProperty struct {
	// Name - Gets or sets the name of the runbook.
	Name *string `json:"name,omitempty"`
}

// RunbookCreateOrUpdateDraftParameters the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateDraftParameters struct {
	// RunbookContent - Content of the Runbook.
	RunbookContent *string `json:"runbookContent,omitempty"`
}

// RunbookCreateOrUpdateDraftProperties the parameters supplied to the create or update draft runbook
// properties.
type RunbookCreateOrUpdateDraftProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// RunbookCreateOrUpdateParameters the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateParameters struct {
	// RunbookCreateOrUpdateProperties - Gets or sets runbook create or update properties.
	*RunbookCreateOrUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RunbookCreateOrUpdateParameters.
func (rcoup RunbookCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcoup.RunbookCreateOrUpdateProperties != nil {
		objectMap["properties"] = rcoup.RunbookCreateOrUpdateProperties
	}
	if rcoup.Name != nil {
		objectMap["name"] = rcoup.Name
	}
	if rcoup.Location != nil {
		objectMap["location"] = rcoup.Location
	}
	if rcoup.Tags != nil {
		objectMap["tags"] = rcoup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunbookCreateOrUpdateParameters struct.
func (rcoup *RunbookCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookCreateOrUpdateProperties RunbookCreateOrUpdateProperties
				err = json.Unmarshal(*v, &runbookCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				rcoup.RunbookCreateOrUpdateProperties = &runbookCreateOrUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rcoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rcoup.Tags = tags
			}
		}
	}

	return nil
}

// RunbookCreateOrUpdateProperties the parameters supplied to the create or update runbook properties.
type RunbookCreateOrUpdateProperties struct {
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// PublishContentLink - Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// RunbookDraft ...
type RunbookDraft struct {
	autorest.Response `json:"-"`
	// InEdit - Gets or sets whether runbook is in edit mode.
	InEdit *bool `json:"inEdit,omitempty"`
	// DraftContentLink - Gets or sets the draft runbook content link.
	DraftContentLink *ContentLink `json:"draftContentLink,omitempty"`
	// CreationTime - Gets or sets the creation time of the runbook draft.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the runbook draft.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Parameters - Gets or sets the runbook draft parameters.
	Parameters map[string]*RunbookParameter `json:"parameters"`
	// OutputTypes - Gets or sets the runbook output types.
	OutputTypes *[]string `json:"outputTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for RunbookDraft.
func (rd RunbookDraft) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.InEdit != nil {
		objectMap["inEdit"] = rd.InEdit
	}
	if rd.DraftContentLink != nil {
		objectMap["draftContentLink"] = rd.DraftContentLink
	}
	if rd.CreationTime != nil {
		objectMap["creationTime"] = rd.CreationTime
	}
	if rd.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = rd.LastModifiedTime
	}
	if rd.Parameters != nil {
		objectMap["parameters"] = rd.Parameters
	}
	if rd.OutputTypes != nil {
		objectMap["outputTypes"] = rd.OutputTypes
	}
	return json.Marshal(objectMap)
}

// RunbookDraftPublishFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RunbookDraftPublishFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RunbookDraftClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RunbookDraftPublishFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RunbookDraftPublishFuture.Result.
func (future *RunbookDraftPublishFuture) result(client RunbookDraftClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftPublishFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("automation.RunbookDraftPublishFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RunbookDraftReplaceContentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RunbookDraftReplaceContentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RunbookDraftClient) (ReadCloser, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RunbookDraftReplaceContentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RunbookDraftReplaceContentFuture.Result.
func (future *RunbookDraftReplaceContentFuture) result(client RunbookDraftClient) (rc ReadCloser, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automation.RunbookDraftReplaceContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("automation.RunbookDraftReplaceContentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rc.Response.Response, err = future.GetResult(sender); err == nil && rc.Response.Response.StatusCode != http.StatusNoContent {
		rc, err = client.ReplaceContentResponder(rc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "automation.RunbookDraftReplaceContentFuture", "Result", rc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RunbookDraftUndoEditResult the response model for the undo edit runbook operation.
type RunbookDraftUndoEditResult struct {
	autorest.Response `json:"-"`
	// StatusCode - Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID  *string        `json:"requestId,omitempty"`
}

// RunbookListResult the response model for the list runbook operation.
type RunbookListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of runbooks.
	Value *[]Runbook `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunbookListResultIterator provides access to a complete listing of Runbook values.
type RunbookListResultIterator struct {
	i    int
	page RunbookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunbookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunbookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RunbookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunbookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunbookListResultIterator) Response() RunbookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunbookListResultIterator) Value() Runbook {
	if !iter.page.NotDone() {
		return Runbook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RunbookListResultIterator type.
func NewRunbookListResultIterator(page RunbookListResultPage) RunbookListResultIterator {
	return RunbookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RunbookListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RunbookListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// runbookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RunbookListResult) runbookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RunbookListResultPage contains a page of Runbook values.
type RunbookListResultPage struct {
	fn  func(context.Context, RunbookListResult) (RunbookListResult, error)
	rlr RunbookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunbookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunbookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RunbookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunbookListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunbookListResultPage) Response() RunbookListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunbookListResultPage) Values() []Runbook {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RunbookListResultPage type.
func NewRunbookListResultPage(cur RunbookListResult, getNextPage func(context.Context, RunbookListResult) (RunbookListResult, error)) RunbookListResultPage {
	return RunbookListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RunbookParameter definition of the runbook parameter type.
type RunbookParameter struct {
	// Type - Gets or sets the type of the parameter.
	Type *string `json:"type,omitempty"`
	// IsMandatory - Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool `json:"isMandatory,omitempty"`
	// Position - Get or sets the position of the parameter.
	Position *int32 `json:"position,omitempty"`
	// DefaultValue - Gets or sets the default value of parameter.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// RunbookProperties definition of the runbook property type.
type RunbookProperties struct {
	// RunbookType - Gets or sets the type of the runbook. Possible values include: 'Script', 'Graph', 'PowerShellWorkflow', 'PowerShell', 'GraphPowerShellWorkflow', 'GraphPowerShell'
	RunbookType RunbookTypeEnum `json:"runbookType,omitempty"`
	// PublishContentLink - Gets or sets the published runbook content link.
	PublishContentLink *ContentLink `json:"publishContentLink,omitempty"`
	// State - Gets or sets the state of the runbook. Possible values include: 'RunbookStateNew', 'RunbookStateEdit', 'RunbookStatePublished'
	State RunbookState `json:"state,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// LogActivityTrace - Gets or sets the option to log activity trace of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
	// JobCount - Gets or sets the job count of the runbook.
	JobCount *int32 `json:"jobCount,omitempty"`
	// Parameters - Gets or sets the runbook parameters.
	Parameters map[string]*RunbookParameter `json:"parameters"`
	// OutputTypes - Gets or sets the runbook output types.
	OutputTypes *[]string `json:"outputTypes,omitempty"`
	// Draft - Gets or sets the draft runbook properties.
	Draft *RunbookDraft `json:"draft,omitempty"`
	// ProvisioningState - Gets or sets the provisioning state of the runbook. Possible values include: 'RunbookProvisioningStateSucceeded'
	ProvisioningState RunbookProvisioningState `json:"provisioningState,omitempty"`
	// LastModifiedBy - Gets or sets the last modified by.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for RunbookProperties.
func (rp RunbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RunbookType != "" {
		objectMap["runbookType"] = rp.RunbookType
	}
	if rp.PublishContentLink != nil {
		objectMap["publishContentLink"] = rp.PublishContentLink
	}
	if rp.State != "" {
		objectMap["state"] = rp.State
	}
	if rp.LogVerbose != nil {
		objectMap["logVerbose"] = rp.LogVerbose
	}
	if rp.LogProgress != nil {
		objectMap["logProgress"] = rp.LogProgress
	}
	if rp.LogActivityTrace != nil {
		objectMap["logActivityTrace"] = rp.LogActivityTrace
	}
	if rp.JobCount != nil {
		objectMap["jobCount"] = rp.JobCount
	}
	if rp.Parameters != nil {
		objectMap["parameters"] = rp.Parameters
	}
	if rp.OutputTypes != nil {
		objectMap["outputTypes"] = rp.OutputTypes
	}
	if rp.Draft != nil {
		objectMap["draft"] = rp.Draft
	}
	if rp.ProvisioningState != "" {
		objectMap["provisioningState"] = rp.ProvisioningState
	}
	if rp.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = rp.LastModifiedBy
	}
	if rp.CreationTime != nil {
		objectMap["creationTime"] = rp.CreationTime
	}
	if rp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = rp.LastModifiedTime
	}
	if rp.Description != nil {
		objectMap["description"] = rp.Description
	}
	return json.Marshal(objectMap)
}

// RunbookUpdateParameters the parameters supplied to the update runbook operation.
type RunbookUpdateParameters struct {
	// RunbookUpdateProperties - Gets or sets the runbook update properties.
	*RunbookUpdateProperties `json:"properties,omitempty"`
	// Name - Gets or sets the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags attached to the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RunbookUpdateParameters.
func (rup RunbookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.RunbookUpdateProperties != nil {
		objectMap["properties"] = rup.RunbookUpdateProperties
	}
	if rup.Name != nil {
		objectMap["name"] = rup.Name
	}
	if rup.Location != nil {
		objectMap["location"] = rup.Location
	}
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunbookUpdateParameters struct.
func (rup *RunbookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runbookUpdateProperties RunbookUpdateProperties
				err = json.Unmarshal(*v, &runbookUpdateProperties)
				if err != nil {
					return err
				}
				rup.RunbookUpdateProperties = &runbookUpdateProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		}
	}

	return nil
}

// RunbookUpdateProperties the parameters supplied to the update runbook properties.
type RunbookUpdateProperties struct {
	// Description - Gets or sets the description of the runbook.
	Description *string `json:"description,omitempty"`
	// LogVerbose - Gets or sets verbose log option.
	LogVerbose *bool `json:"logVerbose,omitempty"`
	// LogProgress - Gets or sets progress log option.
	LogProgress *bool `json:"logProgress,omitempty"`
	// LogActivityTrace - Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// Schedule definition of the schedule.
type Schedule struct {
	autorest.Response `json:"-"`
	// ScheduleProperties - Gets or sets the properties of the schedule.
	*ScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScheduleProperties != nil {
		objectMap["properties"] = s.ScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ScheduleAssociationProperty the schedule property associated with the entity.
type ScheduleAssociationProperty struct {
	// Name - Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`
}

// ScheduleCreateOrUpdateParameters the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`
	// ScheduleCreateOrUpdateProperties - Gets or sets the list of schedule properties.
	*ScheduleCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleCreateOrUpdateParameters.
func (scoup ScheduleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scoup.Name != nil {
		objectMap["name"] = scoup.Name
	}
	if scoup.ScheduleCreateOrUpdateProperties != nil {
		objectMap["properties"] = scoup.ScheduleCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleCreateOrUpdateParameters struct.
func (scoup *ScheduleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scoup.Name = &name
			}
		case "properties":
			if v != nil {
				var scheduleCreateOrUpdateProperties ScheduleCreateOrUpdateProperties
				err = json.Unmarshal(*v, &scheduleCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				scoup.ScheduleCreateOrUpdateProperties = &scheduleCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// ScheduleCreateOrUpdateProperties the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateProperties struct {
	// Description - Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`
	// StartTime - Gets or sets the start time of the schedule.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExpiryTime - Gets or sets the end time of the schedule.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Interval - Gets or sets the interval of the schedule.
	Interval interface{} `json:"interval,omitempty"`
	// Frequency - Gets or sets the frequency of the schedule. Possible values include: 'OneTime', 'Day', 'Hour', 'Week', 'Month', 'Minute'
	Frequency ScheduleFrequency `json:"frequency,omitempty"`
	// TimeZone - Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`
	// AdvancedSchedule - Gets or sets the AdvancedSchedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`
}

// ScheduleListResult the response model for the list schedule operation.
type ScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of schedules.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScheduleListResultIterator provides access to a complete listing of Schedule values.
type ScheduleListResultIterator struct {
	i    int
	page ScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScheduleListResultIterator) Response() ScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScheduleListResultIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScheduleListResultIterator type.
func NewScheduleListResultIterator(page ScheduleListResultPage) ScheduleListResultIterator {
	return ScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ScheduleListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ScheduleListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// scheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ScheduleListResult) scheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ScheduleListResultPage contains a page of Schedule values.
type ScheduleListResultPage struct {
	fn  func(context.Context, ScheduleListResult) (ScheduleListResult, error)
	slr ScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScheduleListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScheduleListResultPage) Response() ScheduleListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScheduleListResultPage) Values() []Schedule {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ScheduleListResultPage type.
func NewScheduleListResultPage(cur ScheduleListResult, getNextPage func(context.Context, ScheduleListResult) (ScheduleListResult, error)) ScheduleListResultPage {
	return ScheduleListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ScheduleProperties definition of schedule parameters.
type ScheduleProperties struct {
	// StartTime - Gets or sets the start time of the schedule.
	StartTime *date.Time `json:"startTime,omitempty"`
	// StartTimeOffsetMinutes - READ-ONLY; Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64 `json:"startTimeOffsetMinutes,omitempty"`
	// ExpiryTime - Gets or sets the end time of the schedule.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// ExpiryTimeOffsetMinutes - Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64 `json:"expiryTimeOffsetMinutes,omitempty"`
	// IsEnabled - Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// NextRun - Gets or sets the next run time of the schedule.
	NextRun *date.Time `json:"nextRun,omitempty"`
	// NextRunOffsetMinutes - Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64 `json:"nextRunOffsetMinutes,omitempty"`
	// Interval - Gets or sets the interval of the schedule.
	Interval *int32 `json:"interval,omitempty"`
	// Frequency - Gets or sets the frequency of the schedule. Possible values include: 'OneTime', 'Day', 'Hour', 'Week', 'Month', 'Minute'
	Frequency ScheduleFrequency `json:"frequency,omitempty"`
	// TimeZone - Gets or sets the time zone of the schedule.
	TimeZone *string `json:"timeZone,omitempty"`
	// AdvancedSchedule - Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule `json:"advancedSchedule,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleProperties.
func (sp ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.StartTime != nil {
		objectMap["startTime"] = sp.StartTime
	}
	if sp.ExpiryTime != nil {
		objectMap["expiryTime"] = sp.ExpiryTime
	}
	if sp.ExpiryTimeOffsetMinutes != nil {
		objectMap["expiryTimeOffsetMinutes"] = sp.ExpiryTimeOffsetMinutes
	}
	if sp.IsEnabled != nil {
		objectMap["isEnabled"] = sp.IsEnabled
	}
	if sp.NextRun != nil {
		objectMap["nextRun"] = sp.NextRun
	}
	if sp.NextRunOffsetMinutes != nil {
		objectMap["nextRunOffsetMinutes"] = sp.NextRunOffsetMinutes
	}
	if sp.Interval != nil {
		objectMap["interval"] = sp.Interval
	}
	if sp.Frequency != "" {
		objectMap["frequency"] = sp.Frequency
	}
	if sp.TimeZone != nil {
		objectMap["timeZone"] = sp.TimeZone
	}
	if sp.AdvancedSchedule != nil {
		objectMap["advancedSchedule"] = sp.AdvancedSchedule
	}
	if sp.CreationTime != nil {
		objectMap["creationTime"] = sp.CreationTime
	}
	if sp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = sp.LastModifiedTime
	}
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	return json.Marshal(objectMap)
}

// ScheduleUpdateParameters the parameters supplied to the update schedule operation.
type ScheduleUpdateParameters struct {
	// Name - Gets or sets the name of the Schedule.
	Name *string `json:"name,omitempty"`
	// ScheduleUpdateProperties - Gets or sets the list of schedule properties.
	*ScheduleUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleUpdateParameters.
func (sup ScheduleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.Name != nil {
		objectMap["name"] = sup.Name
	}
	if sup.ScheduleUpdateProperties != nil {
		objectMap["properties"] = sup.ScheduleUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleUpdateParameters struct.
func (sup *ScheduleUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sup.Name = &name
			}
		case "properties":
			if v != nil {
				var scheduleUpdateProperties ScheduleUpdateProperties
				err = json.Unmarshal(*v, &scheduleUpdateProperties)
				if err != nil {
					return err
				}
				sup.ScheduleUpdateProperties = &scheduleUpdateProperties
			}
		}
	}

	return nil
}

// ScheduleUpdateProperties the parameters supplied to the update schedule operation.
type ScheduleUpdateProperties struct {
	// Description - Gets or sets the description of the schedule.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Sku the account SKU.
type Sku struct {
	// Name - Gets or sets the SKU name of the account. Possible values include: 'Free', 'Basic'
	Name SkuNameEnum `json:"name,omitempty"`
	// Family - Gets or sets the SKU family.
	Family *string `json:"family,omitempty"`
	// Capacity - Gets or sets the SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SoftareUpdateConfigurationRunTaskProperties task properties of the software update configuration.
type SoftareUpdateConfigurationRunTaskProperties struct {
	// Status - The status of the task.
	Status *string `json:"status,omitempty"`
	// Source - The name of the source of the task.
	Source *string `json:"source,omitempty"`
	// JobID - The job id of the task.
	JobID *string `json:"jobId,omitempty"`
}

// SoftareUpdateConfigurationRunTasks software update configuration run tasks model.
type SoftareUpdateConfigurationRunTasks struct {
	// PreTask - Pre task properties.
	PreTask *SoftareUpdateConfigurationRunTaskProperties `json:"preTask,omitempty"`
	// PostTask - Post task properties.
	PostTask *SoftareUpdateConfigurationRunTaskProperties `json:"postTask,omitempty"`
}

// SoftwareUpdateConfiguration software update configuration properties.
type SoftwareUpdateConfiguration struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SoftwareUpdateConfigurationProperties - Software update configuration properties.
	*SoftwareUpdateConfigurationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfiguration.
func (suc SoftwareUpdateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if suc.SoftwareUpdateConfigurationProperties != nil {
		objectMap["properties"] = suc.SoftwareUpdateConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SoftwareUpdateConfiguration struct.
func (suc *SoftwareUpdateConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				suc.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				suc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				suc.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var softwareUpdateConfigurationProperties SoftwareUpdateConfigurationProperties
				err = json.Unmarshal(*v, &softwareUpdateConfigurationProperties)
				if err != nil {
					return err
				}
				suc.SoftwareUpdateConfigurationProperties = &softwareUpdateConfigurationProperties
			}
		}
	}

	return nil
}

// SoftwareUpdateConfigurationCollectionItem software update configuration collection item properties.
type SoftwareUpdateConfigurationCollectionItem struct {
	// Name - READ-ONLY; Name of the software update configuration.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Resource Id of the software update configuration
	ID *string `json:"id,omitempty"`
	// SoftwareUpdateConfigurationCollectionItemProperties - Software update configuration properties.
	*SoftwareUpdateConfigurationCollectionItemProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationCollectionItem.
func (succi SoftwareUpdateConfigurationCollectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if succi.SoftwareUpdateConfigurationCollectionItemProperties != nil {
		objectMap["properties"] = succi.SoftwareUpdateConfigurationCollectionItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SoftwareUpdateConfigurationCollectionItem struct.
func (succi *SoftwareUpdateConfigurationCollectionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				succi.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				succi.ID = &ID
			}
		case "properties":
			if v != nil {
				var softwareUpdateConfigurationCollectionItemProperties SoftwareUpdateConfigurationCollectionItemProperties
				err = json.Unmarshal(*v, &softwareUpdateConfigurationCollectionItemProperties)
				if err != nil {
					return err
				}
				succi.SoftwareUpdateConfigurationCollectionItemProperties = &softwareUpdateConfigurationCollectionItemProperties
			}
		}
	}

	return nil
}

// SoftwareUpdateConfigurationCollectionItemProperties software update configuration collection item
// properties.
type SoftwareUpdateConfigurationCollectionItemProperties struct {
	// UpdateConfiguration - Update specific properties of the software update configuration.
	UpdateConfiguration *CollectionItemUpdateConfiguration `json:"updateConfiguration,omitempty"`
	// Frequency - execution frequency of the schedule associated with the software update configuration. Possible values include: 'OneTime', 'Day', 'Hour', 'Week', 'Month', 'Minute'
	Frequency ScheduleFrequency `json:"frequency,omitempty"`
	// StartTime - the start time of the update.
	StartTime *date.Time `json:"startTime,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the software update configuration, which only appears in the response.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Last time software update configuration was modified, which only appears in the response.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// NextRun - ext run time of the update.
	NextRun *date.Time `json:"nextRun,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationCollectionItemProperties.
func (succip SoftwareUpdateConfigurationCollectionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if succip.UpdateConfiguration != nil {
		objectMap["updateConfiguration"] = succip.UpdateConfiguration
	}
	if succip.Frequency != "" {
		objectMap["frequency"] = succip.Frequency
	}
	if succip.StartTime != nil {
		objectMap["startTime"] = succip.StartTime
	}
	if succip.NextRun != nil {
		objectMap["nextRun"] = succip.NextRun
	}
	return json.Marshal(objectMap)
}

// SoftwareUpdateConfigurationListResult result of listing all software update configuration
type SoftwareUpdateConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - outer object returned when listing all software update configurations
	Value *[]SoftwareUpdateConfigurationCollectionItem `json:"value,omitempty"`
}

// SoftwareUpdateConfigurationMachineRun software update configuration machine run model.
type SoftwareUpdateConfigurationMachineRun struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the software update configuration machine run
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Resource Id of the software update configuration machine run
	ID *string `json:"id,omitempty"`
	// UpdateConfigurationMachineRunProperties - Software update configuration machine run properties.
	*UpdateConfigurationMachineRunProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationMachineRun.
func (sucmr SoftwareUpdateConfigurationMachineRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sucmr.UpdateConfigurationMachineRunProperties != nil {
		objectMap["properties"] = sucmr.UpdateConfigurationMachineRunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SoftwareUpdateConfigurationMachineRun struct.
func (sucmr *SoftwareUpdateConfigurationMachineRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sucmr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sucmr.ID = &ID
			}
		case "properties":
			if v != nil {
				var updateConfigurationMachineRunProperties UpdateConfigurationMachineRunProperties
				err = json.Unmarshal(*v, &updateConfigurationMachineRunProperties)
				if err != nil {
					return err
				}
				sucmr.UpdateConfigurationMachineRunProperties = &updateConfigurationMachineRunProperties
			}
		}
	}

	return nil
}

// SoftwareUpdateConfigurationMachineRunListResult result of listing all software update configuration
// machine runs
type SoftwareUpdateConfigurationMachineRunListResult struct {
	autorest.Response `json:"-"`
	// Value - outer object returned when listing all software update configuration machine runs
	Value *[]SoftwareUpdateConfigurationMachineRun `json:"value,omitempty"`
	// NextLink - link to next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SoftwareUpdateConfigurationProperties software update configuration properties.
type SoftwareUpdateConfigurationProperties struct {
	// UpdateConfiguration - update specific properties for the Software update configuration
	UpdateConfiguration *UpdateConfiguration `json:"updateConfiguration,omitempty"`
	// ScheduleInfo - Schedule information for the Software update configuration
	ScheduleInfo *ScheduleProperties `json:"scheduleInfo,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Error - Details of provisioning error
	Error *ErrorResponse `json:"error,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CreatedBy - READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty"`
	// LastModifiedTime - READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastModifiedBy - READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Tasks - Tasks information for the Software update configuration.
	Tasks *SoftwareUpdateConfigurationTasks `json:"tasks,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationProperties.
func (sucp SoftwareUpdateConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sucp.UpdateConfiguration != nil {
		objectMap["updateConfiguration"] = sucp.UpdateConfiguration
	}
	if sucp.ScheduleInfo != nil {
		objectMap["scheduleInfo"] = sucp.ScheduleInfo
	}
	if sucp.Error != nil {
		objectMap["error"] = sucp.Error
	}
	if sucp.Tasks != nil {
		objectMap["tasks"] = sucp.Tasks
	}
	return json.Marshal(objectMap)
}

// SoftwareUpdateConfigurationRun software update configuration Run properties.
type SoftwareUpdateConfigurationRun struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the software update configuration run.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Resource Id of the software update configuration run
	ID *string `json:"id,omitempty"`
	// SoftwareUpdateConfigurationRunProperties - Software update configuration Run properties.
	*SoftwareUpdateConfigurationRunProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationRun.
func (sucr SoftwareUpdateConfigurationRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sucr.SoftwareUpdateConfigurationRunProperties != nil {
		objectMap["properties"] = sucr.SoftwareUpdateConfigurationRunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SoftwareUpdateConfigurationRun struct.
func (sucr *SoftwareUpdateConfigurationRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sucr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sucr.ID = &ID
			}
		case "properties":
			if v != nil {
				var softwareUpdateConfigurationRunProperties SoftwareUpdateConfigurationRunProperties
				err = json.Unmarshal(*v, &softwareUpdateConfigurationRunProperties)
				if err != nil {
					return err
				}
				sucr.SoftwareUpdateConfigurationRunProperties = &softwareUpdateConfigurationRunProperties
			}
		}
	}

	return nil
}

// SoftwareUpdateConfigurationRunListResult result of listing all software update configuration runs
type SoftwareUpdateConfigurationRunListResult struct {
	autorest.Response `json:"-"`
	// Value - outer object returned when listing all software update configuration runs
	Value *[]SoftwareUpdateConfigurationRun `json:"value,omitempty"`
	// NextLink - link to next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SoftwareUpdateConfigurationRunProperties software update configuration properties.
type SoftwareUpdateConfigurationRunProperties struct {
	// SoftwareUpdateConfiguration - software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation `json:"softwareUpdateConfiguration,omitempty"`
	// Status - READ-ONLY; Status of the software update configuration run.
	Status *string `json:"status,omitempty"`
	// ConfiguredDuration - READ-ONLY; Configured duration for the software update configuration run.
	ConfiguredDuration *string `json:"configuredDuration,omitempty"`
	// OsType - READ-ONLY; Operating system target of the software update configuration triggered this run
	OsType *string `json:"osType,omitempty"`
	// StartTime - READ-ONLY; Start time of the software update configuration run.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time of the software update configuration run.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ComputerCount - READ-ONLY; Number of computers in the software update configuration run.
	ComputerCount *int32 `json:"computerCount,omitempty"`
	// FailedCount - READ-ONLY; Number of computers with failed status.
	FailedCount *int32 `json:"failedCount,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CreatedBy - READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty"`
	// LastModifiedTime - READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastModifiedBy - READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Tasks - Software update configuration tasks triggered in this run
	Tasks *SoftareUpdateConfigurationRunTasks `json:"tasks,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwareUpdateConfigurationRunProperties.
func (sucrp SoftwareUpdateConfigurationRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sucrp.SoftwareUpdateConfiguration != nil {
		objectMap["softwareUpdateConfiguration"] = sucrp.SoftwareUpdateConfiguration
	}
	if sucrp.Tasks != nil {
		objectMap["tasks"] = sucrp.Tasks
	}
	return json.Marshal(objectMap)
}

// SoftwareUpdateConfigurationTasks task properties of the software update configuration.
type SoftwareUpdateConfigurationTasks struct {
	// PreTask - Pre task properties.
	PreTask *TaskProperties `json:"preTask,omitempty"`
	// PostTask - Post task properties.
	PostTask *TaskProperties `json:"postTask,omitempty"`
}

// SourceControl definition of the source control.
type SourceControl struct {
	autorest.Response `json:"-"`
	// SourceControlProperties - The properties of the source control.
	*SourceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControl.
func (sc SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SourceControlProperties != nil {
		objectMap["properties"] = sc.SourceControlProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControl struct.
func (sc *SourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlProperties SourceControlProperties
				err = json.Unmarshal(*v, &sourceControlProperties)
				if err != nil {
					return err
				}
				sc.SourceControlProperties = &sourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// SourceControlCreateOrUpdateParameters the parameters supplied to the create or update source control
// operation.
type SourceControlCreateOrUpdateParameters struct {
	// SourceControlCreateOrUpdateProperties - The properties of the source control.
	*SourceControlCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlCreateOrUpdateParameters.
func (sccoup SourceControlCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccoup.SourceControlCreateOrUpdateProperties != nil {
		objectMap["properties"] = sccoup.SourceControlCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlCreateOrUpdateParameters struct.
func (sccoup *SourceControlCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlCreateOrUpdateProperties SourceControlCreateOrUpdateProperties
				err = json.Unmarshal(*v, &sourceControlCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				sccoup.SourceControlCreateOrUpdateProperties = &sourceControlCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// SourceControlCreateOrUpdateProperties the properties of the create source control operation.
type SourceControlCreateOrUpdateProperties struct {
	// RepoURL - The repo url of the source control.
	RepoURL *string `json:"repoUrl,omitempty"`
	// Branch - The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string `json:"branch,omitempty"`
	// FolderPath - The folder path of the source control. Path must be relative.
	FolderPath *string `json:"folderPath,omitempty"`
	// AutoSync - The auto async of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`
	// PublishRunbook - The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`
	// SourceType - The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive. Possible values include: 'VsoGit', 'VsoTfvc', 'GitHub'
	SourceType SourceType `json:"sourceType,omitempty"`
	// SecurityToken - The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties `json:"securityToken,omitempty"`
	// Description - The user description of the source control.
	Description *string `json:"description,omitempty"`
}

// SourceControlListResult the response model for the list source controls operation.
type SourceControlListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of source controls.
	Value *[]SourceControl `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SourceControlListResultIterator provides access to a complete listing of SourceControl values.
type SourceControlListResultIterator struct {
	i    int
	page SourceControlListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlListResultIterator) Response() SourceControlListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlListResultIterator) Value() SourceControl {
	if !iter.page.NotDone() {
		return SourceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlListResultIterator type.
func NewSourceControlListResultIterator(page SourceControlListResultPage) SourceControlListResultIterator {
	return SourceControlListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sclr SourceControlListResult) IsEmpty() bool {
	return sclr.Value == nil || len(*sclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sclr SourceControlListResult) hasNextLink() bool {
	return sclr.NextLink != nil && len(*sclr.NextLink) != 0
}

// sourceControlListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sclr SourceControlListResult) sourceControlListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sclr.NextLink)))
}

// SourceControlListResultPage contains a page of SourceControl values.
type SourceControlListResultPage struct {
	fn   func(context.Context, SourceControlListResult) (SourceControlListResult, error)
	sclr SourceControlListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sclr)
		if err != nil {
			return err
		}
		page.sclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlListResultPage) NotDone() bool {
	return !page.sclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlListResultPage) Response() SourceControlListResult {
	return page.sclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlListResultPage) Values() []SourceControl {
	if page.sclr.IsEmpty() {
		return nil
	}
	return *page.sclr.Value
}

// Creates a new instance of the SourceControlListResultPage type.
func NewSourceControlListResultPage(cur SourceControlListResult, getNextPage func(context.Context, SourceControlListResult) (SourceControlListResult, error)) SourceControlListResultPage {
	return SourceControlListResultPage{
		fn:   getNextPage,
		sclr: cur,
	}
}

// SourceControlProperties definition of the source control properties
type SourceControlProperties struct {
	// RepoURL - The repo url of the source control.
	RepoURL *string `json:"repoUrl,omitempty"`
	// Branch - The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string `json:"branch,omitempty"`
	// FolderPath - The folder path of the source control.
	FolderPath *string `json:"folderPath,omitempty"`
	// AutoSync - The auto sync of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`
	// PublishRunbook - The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`
	// SourceType - The source type. Must be one of VsoGit, VsoTfvc, GitHub. Possible values include: 'VsoGit', 'VsoTfvc', 'GitHub'
	SourceType SourceType `json:"sourceType,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
	// CreationTime - The creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - The last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
}

// SourceControlSecurityTokenProperties ...
type SourceControlSecurityTokenProperties struct {
	// AccessToken - The access token.
	AccessToken *string `json:"accessToken,omitempty"`
	// RefreshToken - The refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// TokenType - The token type. Must be either PersonalAccessToken or Oauth. Possible values include: 'PersonalAccessToken', 'Oauth'
	TokenType TokenType `json:"tokenType,omitempty"`
}

// SourceControlSyncJob definition of the source control sync job.
type SourceControlSyncJob struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; Resource id.
	ID *string `json:"id,omitempty"`
	// SourceControlSyncJobProperties - The properties of the source control sync job.
	*SourceControlSyncJobProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJob.
func (scsj SourceControlSyncJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsj.SourceControlSyncJobProperties != nil {
		objectMap["properties"] = scsj.SourceControlSyncJobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlSyncJob struct.
func (scsj *SourceControlSyncJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scsj.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scsj.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsj.ID = &ID
			}
		case "properties":
			if v != nil {
				var sourceControlSyncJobProperties SourceControlSyncJobProperties
				err = json.Unmarshal(*v, &sourceControlSyncJobProperties)
				if err != nil {
					return err
				}
				scsj.SourceControlSyncJobProperties = &sourceControlSyncJobProperties
			}
		}
	}

	return nil
}

// SourceControlSyncJobByID definition of the source control sync job.
type SourceControlSyncJobByID struct {
	autorest.Response `json:"-"`
	// ID - The id of the job.
	ID *string `json:"id,omitempty"`
	// SourceControlSyncJobByIDProperties - The properties of the source control sync job.
	*SourceControlSyncJobByIDProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobByID.
func (scsjbi SourceControlSyncJobByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjbi.ID != nil {
		objectMap["id"] = scsjbi.ID
	}
	if scsjbi.SourceControlSyncJobByIDProperties != nil {
		objectMap["properties"] = scsjbi.SourceControlSyncJobByIDProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlSyncJobByID struct.
func (scsjbi *SourceControlSyncJobByID) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsjbi.ID = &ID
			}
		case "properties":
			if v != nil {
				var sourceControlSyncJobByIDProperties SourceControlSyncJobByIDProperties
				err = json.Unmarshal(*v, &sourceControlSyncJobByIDProperties)
				if err != nil {
					return err
				}
				scsjbi.SourceControlSyncJobByIDProperties = &sourceControlSyncJobByIDProperties
			}
		}
	}

	return nil
}

// SourceControlSyncJobByIDProperties definition of source control sync job properties.
type SourceControlSyncJobByIDProperties struct {
	// SourceControlSyncJobID - The source control sync job id.
	SourceControlSyncJobID *string `json:"sourceControlSyncJobId,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The provisioning state of the job. Possible values include: 'Completed', 'Failed', 'Running'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - READ-ONLY; The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// SyncType - The sync type. Possible values include: 'PartialSync', 'FullSync'
	SyncType SyncType `json:"syncType,omitempty"`
	// Exception - The exceptions that occurred while running the sync job.
	Exception *string `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobByIDProperties.
func (scsjbip SourceControlSyncJobByIDProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjbip.SourceControlSyncJobID != nil {
		objectMap["sourceControlSyncJobId"] = scsjbip.SourceControlSyncJobID
	}
	if scsjbip.ProvisioningState != "" {
		objectMap["provisioningState"] = scsjbip.ProvisioningState
	}
	if scsjbip.SyncType != "" {
		objectMap["syncType"] = scsjbip.SyncType
	}
	if scsjbip.Exception != nil {
		objectMap["exception"] = scsjbip.Exception
	}
	return json.Marshal(objectMap)
}

// SourceControlSyncJobCreateParameters the parameters supplied to the create source control sync job
// operation.
type SourceControlSyncJobCreateParameters struct {
	// SourceControlSyncJobCreateProperties - The properties of the source control sync job.
	*SourceControlSyncJobCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobCreateParameters.
func (scsjcp SourceControlSyncJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjcp.SourceControlSyncJobCreateProperties != nil {
		objectMap["properties"] = scsjcp.SourceControlSyncJobCreateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlSyncJobCreateParameters struct.
func (scsjcp *SourceControlSyncJobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlSyncJobCreateProperties SourceControlSyncJobCreateProperties
				err = json.Unmarshal(*v, &sourceControlSyncJobCreateProperties)
				if err != nil {
					return err
				}
				scsjcp.SourceControlSyncJobCreateProperties = &sourceControlSyncJobCreateProperties
			}
		}
	}

	return nil
}

// SourceControlSyncJobCreateProperties definition of create source control sync job properties.
type SourceControlSyncJobCreateProperties struct {
	// CommitID - The commit id of the source control sync job. If not syncing to a commitId, enter an empty string.
	CommitID *string `json:"commitId,omitempty"`
}

// SourceControlSyncJobListResult the response model for the list source control sync jobs operation.
type SourceControlSyncJobListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of source control sync jobs.
	Value *[]SourceControlSyncJob `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SourceControlSyncJobListResultIterator provides access to a complete listing of SourceControlSyncJob
// values.
type SourceControlSyncJobListResultIterator struct {
	i    int
	page SourceControlSyncJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlSyncJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlSyncJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlSyncJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlSyncJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlSyncJobListResultIterator) Response() SourceControlSyncJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlSyncJobListResultIterator) Value() SourceControlSyncJob {
	if !iter.page.NotDone() {
		return SourceControlSyncJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlSyncJobListResultIterator type.
func NewSourceControlSyncJobListResultIterator(page SourceControlSyncJobListResultPage) SourceControlSyncJobListResultIterator {
	return SourceControlSyncJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scsjlr SourceControlSyncJobListResult) IsEmpty() bool {
	return scsjlr.Value == nil || len(*scsjlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scsjlr SourceControlSyncJobListResult) hasNextLink() bool {
	return scsjlr.NextLink != nil && len(*scsjlr.NextLink) != 0
}

// sourceControlSyncJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scsjlr SourceControlSyncJobListResult) sourceControlSyncJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !scsjlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scsjlr.NextLink)))
}

// SourceControlSyncJobListResultPage contains a page of SourceControlSyncJob values.
type SourceControlSyncJobListResultPage struct {
	fn     func(context.Context, SourceControlSyncJobListResult) (SourceControlSyncJobListResult, error)
	scsjlr SourceControlSyncJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlSyncJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlSyncJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scsjlr)
		if err != nil {
			return err
		}
		page.scsjlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlSyncJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlSyncJobListResultPage) NotDone() bool {
	return !page.scsjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlSyncJobListResultPage) Response() SourceControlSyncJobListResult {
	return page.scsjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlSyncJobListResultPage) Values() []SourceControlSyncJob {
	if page.scsjlr.IsEmpty() {
		return nil
	}
	return *page.scsjlr.Value
}

// Creates a new instance of the SourceControlSyncJobListResultPage type.
func NewSourceControlSyncJobListResultPage(cur SourceControlSyncJobListResult, getNextPage func(context.Context, SourceControlSyncJobListResult) (SourceControlSyncJobListResult, error)) SourceControlSyncJobListResultPage {
	return SourceControlSyncJobListResultPage{
		fn:     getNextPage,
		scsjlr: cur,
	}
}

// SourceControlSyncJobProperties definition of source control sync job properties.
type SourceControlSyncJobProperties struct {
	// SourceControlSyncJobID - The source control sync job id.
	SourceControlSyncJobID *string `json:"sourceControlSyncJobId,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The provisioning state of the job. Possible values include: 'Completed', 'Failed', 'Running'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - READ-ONLY; The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// SyncType - The sync type. Possible values include: 'PartialSync', 'FullSync'
	SyncType SyncType `json:"syncType,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobProperties.
func (scsjp SourceControlSyncJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjp.SourceControlSyncJobID != nil {
		objectMap["sourceControlSyncJobId"] = scsjp.SourceControlSyncJobID
	}
	if scsjp.ProvisioningState != "" {
		objectMap["provisioningState"] = scsjp.ProvisioningState
	}
	if scsjp.SyncType != "" {
		objectMap["syncType"] = scsjp.SyncType
	}
	return json.Marshal(objectMap)
}

// SourceControlSyncJobStream definition of the source control sync job stream.
type SourceControlSyncJobStream struct {
	// ID - READ-ONLY; Resource id.
	ID *string `json:"id,omitempty"`
	// SourceControlSyncJobStreamProperties - The properties of the source control sync job stream.
	*SourceControlSyncJobStreamProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobStream.
func (scsjs SourceControlSyncJobStream) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjs.SourceControlSyncJobStreamProperties != nil {
		objectMap["properties"] = scsjs.SourceControlSyncJobStreamProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlSyncJobStream struct.
func (scsjs *SourceControlSyncJobStream) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsjs.ID = &ID
			}
		case "properties":
			if v != nil {
				var sourceControlSyncJobStreamProperties SourceControlSyncJobStreamProperties
				err = json.Unmarshal(*v, &sourceControlSyncJobStreamProperties)
				if err != nil {
					return err
				}
				scsjs.SourceControlSyncJobStreamProperties = &sourceControlSyncJobStreamProperties
			}
		}
	}

	return nil
}

// SourceControlSyncJobStreamByID definition of the source control sync job stream by id.
type SourceControlSyncJobStreamByID struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource id.
	ID *string `json:"id,omitempty"`
	// SourceControlSyncJobStreamByIDProperties - The properties of the source control sync job stream.
	*SourceControlSyncJobStreamByIDProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobStreamByID.
func (scsjsbi SourceControlSyncJobStreamByID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjsbi.SourceControlSyncJobStreamByIDProperties != nil {
		objectMap["properties"] = scsjsbi.SourceControlSyncJobStreamByIDProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlSyncJobStreamByID struct.
func (scsjsbi *SourceControlSyncJobStreamByID) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsjsbi.ID = &ID
			}
		case "properties":
			if v != nil {
				var sourceControlSyncJobStreamByIDProperties SourceControlSyncJobStreamByIDProperties
				err = json.Unmarshal(*v, &sourceControlSyncJobStreamByIDProperties)
				if err != nil {
					return err
				}
				scsjsbi.SourceControlSyncJobStreamByIDProperties = &sourceControlSyncJobStreamByIDProperties
			}
		}
	}

	return nil
}

// SourceControlSyncJobStreamByIDProperties definition of source control sync job stream by id properties.
type SourceControlSyncJobStreamByIDProperties struct {
	// SourceControlSyncJobStreamID - The sync job stream id.
	SourceControlSyncJobStreamID *string `json:"sourceControlSyncJobStreamId,omitempty"`
	// Summary - The summary of the sync job stream.
	Summary *string `json:"summary,omitempty"`
	// Time - READ-ONLY; The time of the sync job stream.
	Time *date.Time `json:"time,omitempty"`
	// StreamType - The type of the sync job stream. Possible values include: 'StreamTypeError', 'StreamTypeOutput'
	StreamType StreamType `json:"streamType,omitempty"`
	// StreamText - The text of the sync job stream.
	StreamText *string `json:"streamText,omitempty"`
	// Value - The values of the job stream.
	Value map[string]interface{} `json:"value"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobStreamByIDProperties.
func (scsjsbip SourceControlSyncJobStreamByIDProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjsbip.SourceControlSyncJobStreamID != nil {
		objectMap["sourceControlSyncJobStreamId"] = scsjsbip.SourceControlSyncJobStreamID
	}
	if scsjsbip.Summary != nil {
		objectMap["summary"] = scsjsbip.Summary
	}
	if scsjsbip.StreamType != "" {
		objectMap["streamType"] = scsjsbip.StreamType
	}
	if scsjsbip.StreamText != nil {
		objectMap["streamText"] = scsjsbip.StreamText
	}
	if scsjsbip.Value != nil {
		objectMap["value"] = scsjsbip.Value
	}
	return json.Marshal(objectMap)
}

// SourceControlSyncJobStreamProperties definition of source control sync job stream properties.
type SourceControlSyncJobStreamProperties struct {
	// SourceControlSyncJobStreamID - The sync job stream id.
	SourceControlSyncJobStreamID *string `json:"sourceControlSyncJobStreamId,omitempty"`
	// Summary - The summary of the sync job stream.
	Summary *string `json:"summary,omitempty"`
	// Time - READ-ONLY; The time of the sync job stream.
	Time *date.Time `json:"time,omitempty"`
	// StreamType - The type of the sync job stream. Possible values include: 'StreamTypeError', 'StreamTypeOutput'
	StreamType StreamType `json:"streamType,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobStreamProperties.
func (scsjsp SourceControlSyncJobStreamProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjsp.SourceControlSyncJobStreamID != nil {
		objectMap["sourceControlSyncJobStreamId"] = scsjsp.SourceControlSyncJobStreamID
	}
	if scsjsp.Summary != nil {
		objectMap["summary"] = scsjsp.Summary
	}
	if scsjsp.StreamType != "" {
		objectMap["streamType"] = scsjsp.StreamType
	}
	return json.Marshal(objectMap)
}

// SourceControlSyncJobStreamsListBySyncJob the response model for the list source control sync job streams
// operation.
type SourceControlSyncJobStreamsListBySyncJob struct {
	autorest.Response `json:"-"`
	// Value - The list of source control sync job streams.
	Value *[]SourceControlSyncJobStream `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlSyncJobStreamsListBySyncJob.
func (scsjslbsj SourceControlSyncJobStreamsListBySyncJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsjslbsj.Value != nil {
		objectMap["value"] = scsjslbsj.Value
	}
	return json.Marshal(objectMap)
}

// SourceControlSyncJobStreamsListBySyncJobIterator provides access to a complete listing of
// SourceControlSyncJobStream values.
type SourceControlSyncJobStreamsListBySyncJobIterator struct {
	i    int
	page SourceControlSyncJobStreamsListBySyncJobPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlSyncJobStreamsListBySyncJobIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlSyncJobStreamsListBySyncJobIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlSyncJobStreamsListBySyncJobIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlSyncJobStreamsListBySyncJobIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlSyncJobStreamsListBySyncJobIterator) Response() SourceControlSyncJobStreamsListBySyncJob {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlSyncJobStreamsListBySyncJobIterator) Value() SourceControlSyncJobStream {
	if !iter.page.NotDone() {
		return SourceControlSyncJobStream{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlSyncJobStreamsListBySyncJobIterator type.
func NewSourceControlSyncJobStreamsListBySyncJobIterator(page SourceControlSyncJobStreamsListBySyncJobPage) SourceControlSyncJobStreamsListBySyncJobIterator {
	return SourceControlSyncJobStreamsListBySyncJobIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scsjslbsj SourceControlSyncJobStreamsListBySyncJob) IsEmpty() bool {
	return scsjslbsj.Value == nil || len(*scsjslbsj.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scsjslbsj SourceControlSyncJobStreamsListBySyncJob) hasNextLink() bool {
	return scsjslbsj.NextLink != nil && len(*scsjslbsj.NextLink) != 0
}

// sourceControlSyncJobStreamsListBySyncJobPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scsjslbsj SourceControlSyncJobStreamsListBySyncJob) sourceControlSyncJobStreamsListBySyncJobPreparer(ctx context.Context) (*http.Request, error) {
	if !scsjslbsj.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scsjslbsj.NextLink)))
}

// SourceControlSyncJobStreamsListBySyncJobPage contains a page of SourceControlSyncJobStream values.
type SourceControlSyncJobStreamsListBySyncJobPage struct {
	fn        func(context.Context, SourceControlSyncJobStreamsListBySyncJob) (SourceControlSyncJobStreamsListBySyncJob, error)
	scsjslbsj SourceControlSyncJobStreamsListBySyncJob
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlSyncJobStreamsListBySyncJobPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlSyncJobStreamsListBySyncJobPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scsjslbsj)
		if err != nil {
			return err
		}
		page.scsjslbsj = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlSyncJobStreamsListBySyncJobPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlSyncJobStreamsListBySyncJobPage) NotDone() bool {
	return !page.scsjslbsj.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlSyncJobStreamsListBySyncJobPage) Response() SourceControlSyncJobStreamsListBySyncJob {
	return page.scsjslbsj
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlSyncJobStreamsListBySyncJobPage) Values() []SourceControlSyncJobStream {
	if page.scsjslbsj.IsEmpty() {
		return nil
	}
	return *page.scsjslbsj.Value
}

// Creates a new instance of the SourceControlSyncJobStreamsListBySyncJobPage type.
func NewSourceControlSyncJobStreamsListBySyncJobPage(cur SourceControlSyncJobStreamsListBySyncJob, getNextPage func(context.Context, SourceControlSyncJobStreamsListBySyncJob) (SourceControlSyncJobStreamsListBySyncJob, error)) SourceControlSyncJobStreamsListBySyncJobPage {
	return SourceControlSyncJobStreamsListBySyncJobPage{
		fn:        getNextPage,
		scsjslbsj: cur,
	}
}

// SourceControlUpdateParameters the parameters supplied to the update source control operation.
type SourceControlUpdateParameters struct {
	// SourceControlUpdateProperties - The value of the source control.
	*SourceControlUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlUpdateParameters.
func (scup SourceControlUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scup.SourceControlUpdateProperties != nil {
		objectMap["properties"] = scup.SourceControlUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControlUpdateParameters struct.
func (scup *SourceControlUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlUpdateProperties SourceControlUpdateProperties
				err = json.Unmarshal(*v, &sourceControlUpdateProperties)
				if err != nil {
					return err
				}
				scup.SourceControlUpdateProperties = &sourceControlUpdateProperties
			}
		}
	}

	return nil
}

// SourceControlUpdateProperties the properties of the update source control
type SourceControlUpdateProperties struct {
	// Branch - The repo branch of the source control.
	Branch *string `json:"branch,omitempty"`
	// FolderPath - The folder path of the source control. Path must be relative.
	FolderPath *string `json:"folderPath,omitempty"`
	// AutoSync - The auto sync of the source control. Default is false.
	AutoSync *bool `json:"autoSync,omitempty"`
	// PublishRunbook - The auto publish of the source control. Default is true.
	PublishRunbook *bool `json:"publishRunbook,omitempty"`
	// SecurityToken - The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties `json:"securityToken,omitempty"`
	// Description - The user description of the source control.
	Description *string `json:"description,omitempty"`
}

// Statistics definition of the statistic.
type Statistics struct {
	// CounterProperty - READ-ONLY; Gets the property value of the statistic.
	CounterProperty *string `json:"counterProperty,omitempty"`
	// CounterValue - READ-ONLY; Gets the value of the statistic.
	CounterValue *int64 `json:"counterValue,omitempty"`
	// StartTime - READ-ONLY; Gets the startTime of the statistic.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the endTime of the statistic.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ID - READ-ONLY; Gets the id.
	ID *string `json:"id,omitempty"`
}

// StatisticsListResult the response model for the list statistics operation.
type StatisticsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of statistics.
	Value *[]Statistics `json:"value,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// TagSettingsProperties tag filter information for the VM.
type TagSettingsProperties struct {
	// Tags - Dictionary of tags with its list of values.
	Tags map[string][]string `json:"tags"`
	// FilterOperator - Filter VMs by Any or All specified tags. Possible values include: 'TagOperatorsAll', 'TagOperatorsAny'
	FilterOperator TagOperators `json:"filterOperator,omitempty"`
}

// MarshalJSON is the custom marshaler for TagSettingsProperties.
func (tsp TagSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsp.Tags != nil {
		objectMap["tags"] = tsp.Tags
	}
	if tsp.FilterOperator != "" {
		objectMap["filterOperator"] = tsp.FilterOperator
	}
	return json.Marshal(objectMap)
}

// TargetProperties group specific to the update configuration.
type TargetProperties struct {
	// AzureQueries - List of Azure queries in the software update configuration.
	AzureQueries *[]AzureQueryProperties `json:"azureQueries,omitempty"`
	// NonAzureQueries - List of non Azure queries in the software update configuration.
	NonAzureQueries *[]NonAzureQueryProperties `json:"nonAzureQueries,omitempty"`
}

// TaskProperties task properties of the software update configuration.
type TaskProperties struct {
	// Parameters - Gets or sets the parameters of the task.
	Parameters map[string]*string `json:"parameters"`
	// Source - Gets or sets the name of the runbook.
	Source *string `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Parameters != nil {
		objectMap["parameters"] = tp.Parameters
	}
	if tp.Source != nil {
		objectMap["source"] = tp.Source
	}
	return json.Marshal(objectMap)
}

// TestJob definition of the test job.
type TestJob struct {
	autorest.Response `json:"-"`
	// CreationTime - Gets or sets the creation time of the test job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Status - Gets or sets the status of the test job.
	Status *string `json:"status,omitempty"`
	// StatusDetails - Gets or sets the status details of the test job.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
	// StartTime - Gets or sets the start time of the test job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets or sets the end time of the test job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Exception - Gets or sets the exception of the test job.
	Exception *string `json:"exception,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time of the test job.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastStatusModifiedTime - Gets or sets the last status modified time of the test job.
	LastStatusModifiedTime *date.Time `json:"lastStatusModifiedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters"`
	// LogActivityTrace - The activity-level tracing options of the runbook.
	LogActivityTrace *int32 `json:"logActivityTrace,omitempty"`
}

// MarshalJSON is the custom marshaler for TestJob.
func (tj TestJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tj.CreationTime != nil {
		objectMap["creationTime"] = tj.CreationTime
	}
	if tj.Status != nil {
		objectMap["status"] = tj.Status
	}
	if tj.StatusDetails != nil {
		objectMap["statusDetails"] = tj.StatusDetails
	}
	if tj.RunOn != nil {
		objectMap["runOn"] = tj.RunOn
	}
	if tj.StartTime != nil {
		objectMap["startTime"] = tj.StartTime
	}
	if tj.EndTime != nil {
		objectMap["endTime"] = tj.EndTime
	}
	if tj.Exception != nil {
		objectMap["exception"] = tj.Exception
	}
	if tj.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = tj.LastModifiedTime
	}
	if tj.LastStatusModifiedTime != nil {
		objectMap["lastStatusModifiedTime"] = tj.LastStatusModifiedTime
	}
	if tj.Parameters != nil {
		objectMap["parameters"] = tj.Parameters
	}
	if tj.LogActivityTrace != nil {
		objectMap["logActivityTrace"] = tj.LogActivityTrace
	}
	return json.Marshal(objectMap)
}

// TestJobCreateParameters the parameters supplied to the create test job operation.
type TestJobCreateParameters struct {
	// Parameters - Gets or sets the parameters of the test job.
	Parameters map[string]*string `json:"parameters"`
	// RunOn - Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for TestJobCreateParameters.
func (tjcp TestJobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjcp.Parameters != nil {
		objectMap["parameters"] = tjcp.Parameters
	}
	if tjcp.RunOn != nil {
		objectMap["runOn"] = tjcp.RunOn
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TypeField information about a field of a type.
type TypeField struct {
	// Name - Gets or sets the name of the field.
	Name *string `json:"name,omitempty"`
	// Type - Gets or sets the type of the field.
	Type *string `json:"type,omitempty"`
}

// TypeFieldListResult the response model for the list fields operation.
type TypeFieldListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of fields.
	Value *[]TypeField `json:"value,omitempty"`
}

// UpdateConfiguration update specific properties of the software update configuration.
type UpdateConfiguration struct {
	// OperatingSystem - operating system of target machines. Possible values include: 'Windows', 'Linux'
	OperatingSystem OperatingSystemType `json:"operatingSystem,omitempty"`
	// Windows - Windows specific update configuration.
	Windows *WindowsProperties `json:"windows,omitempty"`
	// Linux - Linux specific update configuration.
	Linux *LinuxProperties `json:"linux,omitempty"`
	// Duration - Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S as per ISO8601
	Duration *string `json:"duration,omitempty"`
	// AzureVirtualMachines - List of azure resource Ids for azure virtual machines targeted by the software update configuration.
	AzureVirtualMachines *[]string `json:"azureVirtualMachines,omitempty"`
	// NonAzureComputerNames - List of names of non-azure machines targeted by the software update configuration.
	NonAzureComputerNames *[]string `json:"nonAzureComputerNames,omitempty"`
	// Targets - Group targets for the software update configuration.
	Targets *TargetProperties `json:"targets,omitempty"`
}

// UpdateConfigurationMachineRunProperties software update configuration machine run properties.
type UpdateConfigurationMachineRunProperties struct {
	// TargetComputer - READ-ONLY; name of the updated computer
	TargetComputer *string `json:"targetComputer,omitempty"`
	// TargetComputerType - READ-ONLY; type of the updated computer.
	TargetComputerType *string `json:"targetComputerType,omitempty"`
	// SoftwareUpdateConfiguration - software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation `json:"softwareUpdateConfiguration,omitempty"`
	// Status - READ-ONLY; Status of the software update configuration machine run.
	Status *string `json:"status,omitempty"`
	// OsType - READ-ONLY; Operating system target of the software update configuration triggered this run
	OsType *string `json:"osType,omitempty"`
	// CorrelationID - READ-ONLY; correlation id of the software update configuration machine run
	CorrelationID *uuid.UUID `json:"correlationId,omitempty"`
	// SourceComputerID - READ-ONLY; source computer id of the software update configuration machine run
	SourceComputerID *uuid.UUID `json:"sourceComputerId,omitempty"`
	// StartTime - READ-ONLY; Start time of the software update configuration machine run.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time of the software update configuration machine run.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ConfiguredDuration - READ-ONLY; configured duration for the software update configuration run.
	ConfiguredDuration *string `json:"configuredDuration,omitempty"`
	// Job - Job associated with the software update configuration machine run
	Job *JobNavigation `json:"job,omitempty"`
	// CreationTime - READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CreatedBy - READ-ONLY; createdBy property, which only appears in the response.
	CreatedBy *string `json:"createdBy,omitempty"`
	// LastModifiedTime - READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastModifiedBy - READ-ONLY; lastModifiedBy property, which only appears in the response.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Error - Details of provisioning error
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateConfigurationMachineRunProperties.
func (ucmrp UpdateConfigurationMachineRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucmrp.SoftwareUpdateConfiguration != nil {
		objectMap["softwareUpdateConfiguration"] = ucmrp.SoftwareUpdateConfiguration
	}
	if ucmrp.Job != nil {
		objectMap["job"] = ucmrp.Job
	}
	if ucmrp.Error != nil {
		objectMap["error"] = ucmrp.Error
	}
	return json.Marshal(objectMap)
}

// UpdateConfigurationNavigation software update configuration Run Navigation model.
type UpdateConfigurationNavigation struct {
	// Name - READ-ONLY; Name of the software update configuration triggered the software update configuration run
	Name *string `json:"name,omitempty"`
}

// Usage definition of Usage.
type Usage struct {
	// ID - Gets or sets the id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the usage counter name.
	Name *UsageCounterName `json:"name,omitempty"`
	// Unit - Gets or sets the usage unit name.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Gets or sets the current usage value.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - Gets or sets max limit. -1 for unlimited
	Limit *int64 `json:"limit,omitempty"`
	// ThrottleStatus - Gets or sets the throttle status.
	ThrottleStatus *string `json:"throttleStatus,omitempty"`
}

// UsageCounterName definition of usage counter name.
type UsageCounterName struct {
	// Value - Gets or sets the usage counter name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Gets or sets the localized usage counter name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsageListResult the response model for the get usage operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets usage.
	Value *[]Usage `json:"value,omitempty"`
}

// Variable definition of the variable.
type Variable struct {
	autorest.Response `json:"-"`
	// VariableProperties - Gets or sets the properties of the variable.
	*VariableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Variable.
func (vVar Variable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.VariableProperties != nil {
		objectMap["properties"] = vVar.VariableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Variable struct.
func (vVar *Variable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var variableProperties VariableProperties
				err = json.Unmarshal(*v, &variableProperties)
				if err != nil {
					return err
				}
				vVar.VariableProperties = &variableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		}
	}

	return nil
}

// VariableCreateOrUpdateParameters the parameters supplied to the create or update variable operation.
type VariableCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`
	// VariableCreateOrUpdateProperties - Gets or sets the properties of the variable.
	*VariableCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VariableCreateOrUpdateParameters.
func (vcoup VariableCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcoup.Name != nil {
		objectMap["name"] = vcoup.Name
	}
	if vcoup.VariableCreateOrUpdateProperties != nil {
		objectMap["properties"] = vcoup.VariableCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VariableCreateOrUpdateParameters struct.
func (vcoup *VariableCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var variableCreateOrUpdateProperties VariableCreateOrUpdateProperties
				err = json.Unmarshal(*v, &variableCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				vcoup.VariableCreateOrUpdateProperties = &variableCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// VariableCreateOrUpdateProperties the properties of the create variable operation.
type VariableCreateOrUpdateProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// Description - Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`
	// IsEncrypted - Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
}

// VariableListResult the response model for the list variables operation.
type VariableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of variables.
	Value *[]Variable `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VariableListResultIterator provides access to a complete listing of Variable values.
type VariableListResultIterator struct {
	i    int
	page VariableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VariableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VariableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VariableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VariableListResultIterator) Response() VariableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VariableListResultIterator) Value() Variable {
	if !iter.page.NotDone() {
		return Variable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VariableListResultIterator type.
func NewVariableListResultIterator(page VariableListResultPage) VariableListResultIterator {
	return VariableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VariableListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr VariableListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// variableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VariableListResult) variableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VariableListResultPage contains a page of Variable values.
type VariableListResultPage struct {
	fn  func(context.Context, VariableListResult) (VariableListResult, error)
	vlr VariableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VariableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VariableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VariableListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VariableListResultPage) Response() VariableListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VariableListResultPage) Values() []Variable {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the VariableListResultPage type.
func NewVariableListResultPage(cur VariableListResult, getNextPage func(context.Context, VariableListResult) (VariableListResult, error)) VariableListResultPage {
	return VariableListResultPage{
		fn:  getNextPage,
		vlr: cur,
	}
}

// VariableProperties definition of the variable properties
type VariableProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// IsEncrypted - Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// VariableUpdateParameters the parameters supplied to the update variable operation.
type VariableUpdateParameters struct {
	// Name - Gets or sets the name of the variable.
	Name *string `json:"name,omitempty"`
	// VariableUpdateProperties - Gets or sets the value of the variable.
	*VariableUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VariableUpdateParameters.
func (vup VariableUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vup.Name != nil {
		objectMap["name"] = vup.Name
	}
	if vup.VariableUpdateProperties != nil {
		objectMap["properties"] = vup.VariableUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VariableUpdateParameters struct.
func (vup *VariableUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vup.Name = &name
			}
		case "properties":
			if v != nil {
				var variableUpdateProperties VariableUpdateProperties
				err = json.Unmarshal(*v, &variableUpdateProperties)
				if err != nil {
					return err
				}
				vup.VariableUpdateProperties = &variableUpdateProperties
			}
		}
	}

	return nil
}

// VariableUpdateProperties the properties of the update variable
type VariableUpdateProperties struct {
	// Value - Gets or sets the value of the variable.
	Value *string `json:"value,omitempty"`
	// Description - Gets or sets the description of the variable.
	Description *string `json:"description,omitempty"`
}

// Webhook definition of the webhook type.
type Webhook struct {
	autorest.Response `json:"-"`
	// WebhookProperties - Gets or sets the webhook properties.
	*WebhookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WebhookProperties != nil {
		objectMap["properties"] = w.WebhookProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WebhookCreateOrUpdateParameters the parameters supplied to the create or update webhook operation.
type WebhookCreateOrUpdateParameters struct {
	// Name - Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`
	// WebhookCreateOrUpdateProperties - Gets or sets the properties of the webhook.
	*WebhookCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateOrUpdateParameters.
func (wcoup WebhookCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcoup.Name != nil {
		objectMap["name"] = wcoup.Name
	}
	if wcoup.WebhookCreateOrUpdateProperties != nil {
		objectMap["properties"] = wcoup.WebhookCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateOrUpdateParameters struct.
func (wcoup *WebhookCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var webhookCreateOrUpdateProperties WebhookCreateOrUpdateProperties
				err = json.Unmarshal(*v, &webhookCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				wcoup.WebhookCreateOrUpdateProperties = &webhookCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// WebhookCreateOrUpdateProperties the properties of the create webhook operation.
type WebhookCreateOrUpdateProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// URI - Gets or sets the uri.
	URI *string `json:"uri,omitempty"`
	// ExpiryTime - Gets or sets the expiry time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// Runbook - Gets or sets the runbook.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateOrUpdateProperties.
func (wcoup WebhookCreateOrUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcoup.IsEnabled != nil {
		objectMap["isEnabled"] = wcoup.IsEnabled
	}
	if wcoup.URI != nil {
		objectMap["uri"] = wcoup.URI
	}
	if wcoup.ExpiryTime != nil {
		objectMap["expiryTime"] = wcoup.ExpiryTime
	}
	if wcoup.Parameters != nil {
		objectMap["parameters"] = wcoup.Parameters
	}
	if wcoup.Runbook != nil {
		objectMap["runbook"] = wcoup.Runbook
	}
	if wcoup.RunOn != nil {
		objectMap["runOn"] = wcoup.RunOn
	}
	return json.Marshal(objectMap)
}

// WebhookListResult the response model for the list webhook operation.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - Gets or sets the next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebhookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebhookListResultIterator type.
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return WebhookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WebhookListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(context.Context, WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebhookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WebhookListResultPage type.
func NewWebhookListResultPage(cur WebhookListResult, getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return WebhookListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WebhookProperties definition of the webhook properties
type WebhookProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of the webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// URI - Gets or sets the webhook uri.
	URI *string `json:"uri,omitempty"`
	// ExpiryTime - Gets or sets the expiry time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// LastInvokedTime - Gets or sets the last invoked time.
	LastInvokedTime *date.Time `json:"lastInvokedTime,omitempty"`
	// Parameters - Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
	Parameters map[string]*string `json:"parameters"`
	// Runbook - Gets or sets the runbook the webhook is associated with.
	Runbook *RunbookAssociationProperty `json:"runbook,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
	// CreationTime - Gets or sets the creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - Gets or sets the last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LastModifiedBy - Details of the user who last modified the Webhook
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Description - Gets or sets the description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.IsEnabled != nil {
		objectMap["isEnabled"] = wp.IsEnabled
	}
	if wp.URI != nil {
		objectMap["uri"] = wp.URI
	}
	if wp.ExpiryTime != nil {
		objectMap["expiryTime"] = wp.ExpiryTime
	}
	if wp.LastInvokedTime != nil {
		objectMap["lastInvokedTime"] = wp.LastInvokedTime
	}
	if wp.Parameters != nil {
		objectMap["parameters"] = wp.Parameters
	}
	if wp.Runbook != nil {
		objectMap["runbook"] = wp.Runbook
	}
	if wp.RunOn != nil {
		objectMap["runOn"] = wp.RunOn
	}
	if wp.CreationTime != nil {
		objectMap["creationTime"] = wp.CreationTime
	}
	if wp.LastModifiedTime != nil {
		objectMap["lastModifiedTime"] = wp.LastModifiedTime
	}
	if wp.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = wp.LastModifiedBy
	}
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	return json.Marshal(objectMap)
}

// WebhookUpdateParameters the parameters supplied to the update webhook operation.
type WebhookUpdateParameters struct {
	// Name - Gets or sets the name of the webhook.
	Name *string `json:"name,omitempty"`
	// WebhookUpdateProperties - Gets or sets the value of the webhook.
	*WebhookUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateParameters.
func (wup WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Name != nil {
		objectMap["name"] = wup.Name
	}
	if wup.WebhookUpdateProperties != nil {
		objectMap["properties"] = wup.WebhookUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wup.Name = &name
			}
		case "properties":
			if v != nil {
				var webhookUpdateProperties WebhookUpdateProperties
				err = json.Unmarshal(*v, &webhookUpdateProperties)
				if err != nil {
					return err
				}
				wup.WebhookUpdateProperties = &webhookUpdateProperties
			}
		}
	}

	return nil
}

// WebhookUpdateProperties the properties of the update webhook.
type WebhookUpdateProperties struct {
	// IsEnabled - Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RunOn - Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string `json:"runOn,omitempty"`
	// Parameters - Gets or sets the parameters of the job.
	Parameters map[string]*string `json:"parameters"`
	// Description - Gets or sets the description of the webhook.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateProperties.
func (wup WebhookUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.IsEnabled != nil {
		objectMap["isEnabled"] = wup.IsEnabled
	}
	if wup.RunOn != nil {
		objectMap["runOn"] = wup.RunOn
	}
	if wup.Parameters != nil {
		objectMap["parameters"] = wup.Parameters
	}
	if wup.Description != nil {
		objectMap["description"] = wup.Description
	}
	return json.Marshal(objectMap)
}

// WindowsProperties windows specific update configuration.
type WindowsProperties struct {
	// IncludedUpdateClassifications - Update classification included in the software update configuration. A comma separated string with required values. Possible values include: 'WindowsUpdateClassesUnclassified', 'WindowsUpdateClassesCritical', 'WindowsUpdateClassesSecurity', 'WindowsUpdateClassesUpdateRollup', 'WindowsUpdateClassesFeaturePack', 'WindowsUpdateClassesServicePack', 'WindowsUpdateClassesDefinition', 'WindowsUpdateClassesTools', 'WindowsUpdateClassesUpdates'
	IncludedUpdateClassifications WindowsUpdateClasses `json:"includedUpdateClassifications,omitempty"`
	// ExcludedKbNumbers - KB numbers excluded from the software update configuration.
	ExcludedKbNumbers *[]string `json:"excludedKbNumbers,omitempty"`
	// IncludedKbNumbers - KB numbers included from the software update configuration.
	IncludedKbNumbers *[]string `json:"includedKbNumbers,omitempty"`
	// RebootSetting - Reboot setting for the software update configuration.
	RebootSetting *string `json:"rebootSetting,omitempty"`
}
