package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/cosmos-db/mgmt/2020-06-01-preview/documentdb"

// APIProperties ...
type APIProperties struct {
	// ServerVersion - Describes the ServerVersion of an a MongoDB account. Possible values include: 'ThreeFullStopTwo', 'ThreeFullStopSix'
	ServerVersion ServerVersion `json:"serverVersion,omitempty"`
}

// ARMProxyResource the resource model definition for a ARM proxy resource. It will have everything other
// than required location and tags
type ARMProxyResource struct {
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// ARMResourceProperties the core properties of ARM resources.
type ARMResourceProperties struct {
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ARMResourceProperties.
func (arp ARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Location != nil {
		objectMap["location"] = arp.Location
	}
	if arp.Tags != nil {
		objectMap["tags"] = arp.Tags
	}
	if arp.Identity != nil {
		objectMap["identity"] = arp.Identity
	}
	return json.Marshal(objectMap)
}

// AutoscaleSettings ...
type AutoscaleSettings struct {
	// MaxThroughput - Represents maximum throughput, the resource can scale up to.
	MaxThroughput *int32 `json:"maxThroughput,omitempty"`
}

// AutoscaleSettingsResource cosmos DB provisioned throughput settings object
type AutoscaleSettingsResource struct {
	// MaxThroughput - Represents maximum throughput container can scale up to.
	MaxThroughput *int32 `json:"maxThroughput,omitempty"`
	// AutoUpgradePolicy - Cosmos DB resource auto-upgrade policy
	AutoUpgradePolicy *AutoUpgradePolicyResource `json:"autoUpgradePolicy,omitempty"`
	// TargetMaxThroughput - READ-ONLY; Represents target maximum throughput container can scale up to once offer is no longer in pending state.
	TargetMaxThroughput *int32 `json:"targetMaxThroughput,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingsResource.
func (asr AutoscaleSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.MaxThroughput != nil {
		objectMap["maxThroughput"] = asr.MaxThroughput
	}
	if asr.AutoUpgradePolicy != nil {
		objectMap["autoUpgradePolicy"] = asr.AutoUpgradePolicy
	}
	return json.Marshal(objectMap)
}

// AutoUpgradePolicyResource cosmos DB resource auto-upgrade policy
type AutoUpgradePolicyResource struct {
	// ThroughputPolicy - Represents throughput policy which service must adhere to for auto-upgrade
	ThroughputPolicy *ThroughputPolicyResource `json:"throughputPolicy,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// BasicBackupPolicy the object representing the policy for taking backups on an account.
type BasicBackupPolicy interface {
	AsPeriodicModeBackupPolicy() (*PeriodicModeBackupPolicy, bool)
	AsContinuousModeBackupPolicy() (*ContinuousModeBackupPolicy, bool)
	AsBackupPolicy() (*BackupPolicy, bool)
}

// BackupPolicy the object representing the policy for taking backups on an account.
type BackupPolicy struct {
	// Type - Possible values include: 'TypeBackupPolicy', 'TypePeriodic', 'TypeContinuous'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicBackupPolicy(body []byte) (BasicBackupPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypePeriodic):
		var pmbp PeriodicModeBackupPolicy
		err := json.Unmarshal(body, &pmbp)
		return pmbp, err
	case string(TypeContinuous):
		var cmbp ContinuousModeBackupPolicy
		err := json.Unmarshal(body, &cmbp)
		return cmbp, err
	default:
		var bp BackupPolicy
		err := json.Unmarshal(body, &bp)
		return bp, err
	}
}
func unmarshalBasicBackupPolicyArray(body []byte) ([]BasicBackupPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bpArray := make([]BasicBackupPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bp, err := unmarshalBasicBackupPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		bpArray[index] = bp
	}
	return bpArray, nil
}

// MarshalJSON is the custom marshaler for BackupPolicy.
func (bp BackupPolicy) MarshalJSON() ([]byte, error) {
	bp.Type = TypeBackupPolicy
	objectMap := make(map[string]interface{})
	if bp.Type != "" {
		objectMap["type"] = bp.Type
	}
	return json.Marshal(objectMap)
}

// AsPeriodicModeBackupPolicy is the BasicBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsPeriodicModeBackupPolicy() (*PeriodicModeBackupPolicy, bool) {
	return nil, false
}

// AsContinuousModeBackupPolicy is the BasicBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsContinuousModeBackupPolicy() (*ContinuousModeBackupPolicy, bool) {
	return nil, false
}

// AsBackupPolicy is the BasicBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsBackupPolicy() (*BackupPolicy, bool) {
	return &bp, true
}

// AsBasicBackupPolicy is the BasicBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsBasicBackupPolicy() (BasicBackupPolicy, bool) {
	return &bp, true
}

// Capability cosmos DB capability object
type Capability struct {
	// Name - Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
	Name *string `json:"name,omitempty"`
}

// CassandraKeyspaceCreateUpdateParameters parameters to create and update Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateParameters struct {
	// CassandraKeyspaceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra keyspace.
	*CassandraKeyspaceCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceCreateUpdateParameters.
func (ckcup CassandraKeyspaceCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckcup.CassandraKeyspaceCreateUpdateProperties != nil {
		objectMap["properties"] = ckcup.CassandraKeyspaceCreateUpdateProperties
	}
	if ckcup.Location != nil {
		objectMap["location"] = ckcup.Location
	}
	if ckcup.Tags != nil {
		objectMap["tags"] = ckcup.Tags
	}
	if ckcup.Identity != nil {
		objectMap["identity"] = ckcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspaceCreateUpdateParameters struct.
func (ckcup *CassandraKeyspaceCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceCreateUpdateProperties CassandraKeyspaceCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceCreateUpdateProperties)
				if err != nil {
					return err
				}
				ckcup.CassandraKeyspaceCreateUpdateProperties = &cassandraKeyspaceCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ckcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ckcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ckcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ckcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ckcup.Identity = &identity
			}
		}
	}

	return nil
}

// CassandraKeyspaceCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra
// keyspace.
type CassandraKeyspaceCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra keyspace
	Resource *CassandraKeyspaceResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// CassandraKeyspaceGetProperties the properties of an Azure Cosmos DB Cassandra keyspace
type CassandraKeyspaceGetProperties struct {
	Resource *CassandraKeyspaceGetPropertiesResource `json:"resource,omitempty"`
	Options  *CassandraKeyspaceGetPropertiesOptions  `json:"options,omitempty"`
}

// CassandraKeyspaceGetPropertiesOptions ...
type CassandraKeyspaceGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// CassandraKeyspaceGetPropertiesResource ...
type CassandraKeyspaceGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceGetPropertiesResource.
func (ckgp CassandraKeyspaceGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckgp.ID != nil {
		objectMap["id"] = ckgp.ID
	}
	return json.Marshal(objectMap)
}

// CassandraKeyspaceGetResults an Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceGetResults struct {
	autorest.Response `json:"-"`
	// CassandraKeyspaceGetProperties - The properties of an Azure Cosmos DB Cassandra keyspace
	*CassandraKeyspaceGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceGetResults.
func (ckgr CassandraKeyspaceGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckgr.CassandraKeyspaceGetProperties != nil {
		objectMap["properties"] = ckgr.CassandraKeyspaceGetProperties
	}
	if ckgr.Location != nil {
		objectMap["location"] = ckgr.Location
	}
	if ckgr.Tags != nil {
		objectMap["tags"] = ckgr.Tags
	}
	if ckgr.Identity != nil {
		objectMap["identity"] = ckgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspaceGetResults struct.
func (ckgr *CassandraKeyspaceGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceGetProperties CassandraKeyspaceGetProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceGetProperties)
				if err != nil {
					return err
				}
				ckgr.CassandraKeyspaceGetProperties = &cassandraKeyspaceGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ckgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ckgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ckgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ckgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ckgr.Identity = &identity
			}
		}
	}

	return nil
}

// CassandraKeyspaceListResult the List operation response, that contains the Cassandra keyspaces and their
// properties.
type CassandraKeyspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra keyspaces and their properties.
	Value *[]CassandraKeyspaceGetResults `json:"value,omitempty"`
}

// CassandraKeyspaceResource cosmos DB Cassandra keyspace resource object
type CassandraKeyspaceResource struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
}

// CassandraPartitionKey cosmos DB Cassandra table partition key
type CassandraPartitionKey struct {
	// Name - Name of the Cosmos DB Cassandra table partition key
	Name *string `json:"name,omitempty"`
}

// CassandraResourcesCreateUpdateCassandraKeyspaceFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesCreateUpdateCassandraKeyspaceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (CassandraKeyspaceGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesCreateUpdateCassandraKeyspaceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesCreateUpdateCassandraKeyspaceFuture.Result.
func (future *CassandraResourcesCreateUpdateCassandraKeyspaceFuture) result(client CassandraResourcesClient) (ckgr CassandraKeyspaceGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ckgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ckgr.Response.Response, err = future.GetResult(sender); err == nil && ckgr.Response.Response.StatusCode != http.StatusNoContent {
		ckgr, err = client.CreateUpdateCassandraKeyspaceResponder(ckgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture", "Result", ckgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesCreateUpdateCassandraTableFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesCreateUpdateCassandraTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (CassandraTableGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesCreateUpdateCassandraTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesCreateUpdateCassandraTableFuture.Result.
func (future *CassandraResourcesCreateUpdateCassandraTableFuture) result(client CassandraResourcesClient) (ctgr CassandraTableGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ctgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesCreateUpdateCassandraTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ctgr.Response.Response, err = future.GetResult(sender); err == nil && ctgr.Response.Response.StatusCode != http.StatusNoContent {
		ctgr, err = client.CreateUpdateCassandraTableResponder(ctgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraTableFuture", "Result", ctgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesDeleteCassandraKeyspaceFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type CassandraResourcesDeleteCassandraKeyspaceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesDeleteCassandraKeyspaceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesDeleteCassandraKeyspaceFuture.Result.
func (future *CassandraResourcesDeleteCassandraKeyspaceFuture) result(client CassandraResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesDeleteCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesDeleteCassandraKeyspaceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CassandraResourcesDeleteCassandraTableFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type CassandraResourcesDeleteCassandraTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesDeleteCassandraTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesDeleteCassandraTableFuture.Result.
func (future *CassandraResourcesDeleteCassandraTableFuture) result(client CassandraResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesDeleteCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesDeleteCassandraTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CassandraResourcesUpdateCassandraKeyspaceThroughputFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type CassandraResourcesUpdateCassandraKeyspaceThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesUpdateCassandraKeyspaceThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesUpdateCassandraKeyspaceThroughputFuture.Result.
func (future *CassandraResourcesUpdateCassandraKeyspaceThroughputFuture) result(client CassandraResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateCassandraKeyspaceThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesUpdateCassandraTableThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesUpdateCassandraTableThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesUpdateCassandraTableThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesUpdateCassandraTableThroughputFuture.Result.
func (future *CassandraResourcesUpdateCassandraTableThroughputFuture) result(client CassandraResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateCassandraTableThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraSchema cosmos DB Cassandra table schema
type CassandraSchema struct {
	// Columns - List of Cassandra table columns.
	Columns *[]Column `json:"columns,omitempty"`
	// PartitionKeys - List of partition key.
	PartitionKeys *[]CassandraPartitionKey `json:"partitionKeys,omitempty"`
	// ClusterKeys - List of cluster key.
	ClusterKeys *[]ClusterKey `json:"clusterKeys,omitempty"`
}

// CassandraTableCreateUpdateParameters parameters to create and update Cosmos DB Cassandra table.
type CassandraTableCreateUpdateParameters struct {
	// CassandraTableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra table.
	*CassandraTableCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableCreateUpdateParameters.
func (ctcup CassandraTableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcup.CassandraTableCreateUpdateProperties != nil {
		objectMap["properties"] = ctcup.CassandraTableCreateUpdateProperties
	}
	if ctcup.Location != nil {
		objectMap["location"] = ctcup.Location
	}
	if ctcup.Tags != nil {
		objectMap["tags"] = ctcup.Tags
	}
	if ctcup.Identity != nil {
		objectMap["identity"] = ctcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableCreateUpdateParameters struct.
func (ctcup *CassandraTableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableCreateUpdateProperties CassandraTableCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraTableCreateUpdateProperties)
				if err != nil {
					return err
				}
				ctcup.CassandraTableCreateUpdateProperties = &cassandraTableCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ctcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ctcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ctcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ctcup.Identity = &identity
			}
		}
	}

	return nil
}

// CassandraTableCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra table.
type CassandraTableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra table
	Resource *CassandraTableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// CassandraTableGetProperties the properties of an Azure Cosmos DB Cassandra table
type CassandraTableGetProperties struct {
	Resource *CassandraTableGetPropertiesResource `json:"resource,omitempty"`
	Options  *CassandraTableGetPropertiesOptions  `json:"options,omitempty"`
}

// CassandraTableGetPropertiesOptions ...
type CassandraTableGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// CassandraTableGetPropertiesResource ...
type CassandraTableGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
	// AnalyticalStorageTTL - Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableGetPropertiesResource.
func (ctgp CassandraTableGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctgp.ID != nil {
		objectMap["id"] = ctgp.ID
	}
	if ctgp.DefaultTTL != nil {
		objectMap["defaultTtl"] = ctgp.DefaultTTL
	}
	if ctgp.Schema != nil {
		objectMap["schema"] = ctgp.Schema
	}
	if ctgp.AnalyticalStorageTTL != nil {
		objectMap["analyticalStorageTtl"] = ctgp.AnalyticalStorageTTL
	}
	return json.Marshal(objectMap)
}

// CassandraTableGetResults an Azure Cosmos DB Cassandra table.
type CassandraTableGetResults struct {
	autorest.Response `json:"-"`
	// CassandraTableGetProperties - The properties of an Azure Cosmos DB Cassandra table
	*CassandraTableGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableGetResults.
func (ctgr CassandraTableGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctgr.CassandraTableGetProperties != nil {
		objectMap["properties"] = ctgr.CassandraTableGetProperties
	}
	if ctgr.Location != nil {
		objectMap["location"] = ctgr.Location
	}
	if ctgr.Tags != nil {
		objectMap["tags"] = ctgr.Tags
	}
	if ctgr.Identity != nil {
		objectMap["identity"] = ctgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableGetResults struct.
func (ctgr *CassandraTableGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableGetProperties CassandraTableGetProperties
				err = json.Unmarshal(*v, &cassandraTableGetProperties)
				if err != nil {
					return err
				}
				ctgr.CassandraTableGetProperties = &cassandraTableGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ctgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ctgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ctgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ctgr.Identity = &identity
			}
		}
	}

	return nil
}

// CassandraTableListResult the List operation response, that contains the Cassandra tables and their
// properties.
type CassandraTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra tables and their properties.
	Value *[]CassandraTableGetResults `json:"value,omitempty"`
}

// CassandraTableResource cosmos DB Cassandra table resource object
type CassandraTableResource struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
	// AnalyticalStorageTTL - Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`
}

// ClusterKey cosmos DB Cassandra table cluster key
type ClusterKey struct {
	// Name - Name of the Cosmos DB Cassandra table cluster key
	Name *string `json:"name,omitempty"`
	// OrderBy - Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
	OrderBy *string `json:"orderBy,omitempty"`
}

// Column cosmos DB Cassandra table column
type Column struct {
	// Name - Name of the Cosmos DB Cassandra table column
	Name *string `json:"name,omitempty"`
	// Type - Type of the Cosmos DB Cassandra table column
	Type *string `json:"type,omitempty"`
}

// CompositePath ...
type CompositePath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Order - Sort order for composite paths. Possible values include: 'Ascending', 'Descending'
	Order CompositePathSortOrder `json:"order,omitempty"`
}

// ConflictResolutionPolicy the conflict resolution policy for the container.
type ConflictResolutionPolicy struct {
	// Mode - Indicates the conflict resolution mode. Possible values include: 'LastWriterWins', 'Custom'
	Mode ConflictResolutionMode `json:"mode,omitempty"`
	// ConflictResolutionPath - The conflict resolution path in the case of LastWriterWins mode.
	ConflictResolutionPath *string `json:"conflictResolutionPath,omitempty"`
	// ConflictResolutionProcedure - The procedure to resolve conflicts in the case of custom mode.
	ConflictResolutionProcedure *string `json:"conflictResolutionProcedure,omitempty"`
}

// ConsistencyPolicy the consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// DefaultConsistencyLevel - The default consistency level and configuration settings of the Cosmos DB account. Possible values include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong', 'ConsistentPrefix'
	DefaultConsistencyLevel DefaultConsistencyLevel `json:"defaultConsistencyLevel,omitempty"`
	// MaxStalenessPrefix - When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64 `json:"maxStalenessPrefix,omitempty"`
	// MaxIntervalInSeconds - When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32 `json:"maxIntervalInSeconds,omitempty"`
}

// ContainerPartitionKey the configuration of the partition key to be used for partitioning data into
// multiple partitions
type ContainerPartitionKey struct {
	// Paths - List of paths using which data within the container can be partitioned
	Paths *[]string `json:"paths,omitempty"`
	// Kind - Indicates the kind of algorithm used for partitioning. Possible values include: 'PartitionKindHash', 'PartitionKindRange'
	Kind PartitionKind `json:"kind,omitempty"`
	// Version - Indicates the version of the partition key definition
	Version *int32 `json:"version,omitempty"`
}

// ContinuousModeBackupPolicy the object representing continuous mode backup policy.
type ContinuousModeBackupPolicy struct {
	// Type - Possible values include: 'TypeBackupPolicy', 'TypePeriodic', 'TypeContinuous'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContinuousModeBackupPolicy.
func (cmbp ContinuousModeBackupPolicy) MarshalJSON() ([]byte, error) {
	cmbp.Type = TypeContinuous
	objectMap := make(map[string]interface{})
	if cmbp.Type != "" {
		objectMap["type"] = cmbp.Type
	}
	return json.Marshal(objectMap)
}

// AsPeriodicModeBackupPolicy is the BasicBackupPolicy implementation for ContinuousModeBackupPolicy.
func (cmbp ContinuousModeBackupPolicy) AsPeriodicModeBackupPolicy() (*PeriodicModeBackupPolicy, bool) {
	return nil, false
}

// AsContinuousModeBackupPolicy is the BasicBackupPolicy implementation for ContinuousModeBackupPolicy.
func (cmbp ContinuousModeBackupPolicy) AsContinuousModeBackupPolicy() (*ContinuousModeBackupPolicy, bool) {
	return &cmbp, true
}

// AsBackupPolicy is the BasicBackupPolicy implementation for ContinuousModeBackupPolicy.
func (cmbp ContinuousModeBackupPolicy) AsBackupPolicy() (*BackupPolicy, bool) {
	return nil, false
}

// AsBasicBackupPolicy is the BasicBackupPolicy implementation for ContinuousModeBackupPolicy.
func (cmbp ContinuousModeBackupPolicy) AsBasicBackupPolicy() (BasicBackupPolicy, bool) {
	return &cmbp, true
}

// CorsPolicy the CORS policy for the Cosmos DB database account.
type CorsPolicy struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the service via CORS.
	AllowedOrigins *string `json:"allowedOrigins,omitempty"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request.
	AllowedMethods *string `json:"allowedMethods,omitempty"`
	// AllowedHeaders - The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `json:"allowedHeaders,omitempty"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
	ExposedHeaders *string `json:"exposedHeaders,omitempty"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int64 `json:"maxAgeInSeconds,omitempty"`
}

// CreateUpdateOptions createUpdateOptions are a list of key-value pairs that describe the resource.
// Supported keys are "If-Match", "If-None-Match", "Session-Token" and "Throughput"
type CreateUpdateOptions struct {
	// Throughput - Request Units per second. For example, "throughput": 10000.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// DatabaseAccountConnectionString connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// ConnectionString - READ-ONLY; Value of the connection string
	ConnectionString *string `json:"connectionString,omitempty"`
	// Description - READ-ONLY; Description of the connection string
	Description *string `json:"description,omitempty"`
}

// DatabaseAccountCreateUpdateParameters parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'DatabaseAccountKindGlobalDocumentDB', 'DatabaseAccountKindMongoDB', 'DatabaseAccountKindParse'
	Kind       DatabaseAccountKind                        `json:"kind,omitempty"`
	Properties BasicDatabaseAccountCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountCreateUpdateParameters.
func (dacup DatabaseAccountCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dacup.Kind != "" {
		objectMap["kind"] = dacup.Kind
	}
	objectMap["properties"] = dacup.Properties
	if dacup.Location != nil {
		objectMap["location"] = dacup.Location
	}
	if dacup.Tags != nil {
		objectMap["tags"] = dacup.Tags
	}
	if dacup.Identity != nil {
		objectMap["identity"] = dacup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountCreateUpdateParameters struct.
func (dacup *DatabaseAccountCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dacup.Kind = kind
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicDatabaseAccountCreateUpdateProperties(*v)
				if err != nil {
					return err
				}
				dacup.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dacup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dacup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dacup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dacup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dacup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dacup.Identity = &identity
			}
		}
	}

	return nil
}

// BasicDatabaseAccountCreateUpdateProperties properties to create and update Azure Cosmos DB database accounts.
type BasicDatabaseAccountCreateUpdateProperties interface {
	AsDefaultRequestDatabaseAccountCreateUpdateProperties() (*DefaultRequestDatabaseAccountCreateUpdateProperties, bool)
	AsRestoreReqeustDatabaseAccountCreateUpdateProperties() (*RestoreReqeustDatabaseAccountCreateUpdateProperties, bool)
	AsDatabaseAccountCreateUpdateProperties() (*DatabaseAccountCreateUpdateProperties, bool)
}

// DatabaseAccountCreateUpdateProperties properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// DatabaseAccountOfferType - The offer type for the database
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`
	// IPRules - List of IpRules.
	IPRules *[]IPAddressOrRange `json:"ipRules,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
	// KeyVaultKeyURI - The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EnableFreeTier - Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`
	// APIProperties - API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// EnableAnalyticalStorage - Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`
	// BackupPolicy - The object representing the policy for taking backups on an account.
	BackupPolicy BasicBackupPolicy `json:"backupPolicy,omitempty"`
	// Cors - The CORS policy for the Cosmos DB database account.
	Cors *[]CorsPolicy `json:"cors,omitempty"`
	// CreateMode - Possible values include: 'CreateModeDatabaseAccountCreateUpdateProperties', 'CreateModeDefault', 'CreateModeRestore'
	CreateMode CreateModeBasicDatabaseAccountCreateUpdateProperties `json:"createMode,omitempty"`
}

func unmarshalBasicDatabaseAccountCreateUpdateProperties(body []byte) (BasicDatabaseAccountCreateUpdateProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["createMode"] {
	case string(CreateModeDefault):
		var drdacup DefaultRequestDatabaseAccountCreateUpdateProperties
		err := json.Unmarshal(body, &drdacup)
		return drdacup, err
	case string(CreateModeRestore):
		var rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties
		err := json.Unmarshal(body, &rrdacup)
		return rrdacup, err
	default:
		var dacup DatabaseAccountCreateUpdateProperties
		err := json.Unmarshal(body, &dacup)
		return dacup, err
	}
}
func unmarshalBasicDatabaseAccountCreateUpdatePropertiesArray(body []byte) ([]BasicDatabaseAccountCreateUpdateProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dacupArray := make([]BasicDatabaseAccountCreateUpdateProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dacup, err := unmarshalBasicDatabaseAccountCreateUpdateProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		dacupArray[index] = dacup
	}
	return dacupArray, nil
}

// MarshalJSON is the custom marshaler for DatabaseAccountCreateUpdateProperties.
func (dacup DatabaseAccountCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	dacup.CreateMode = CreateModeDatabaseAccountCreateUpdateProperties
	objectMap := make(map[string]interface{})
	if dacup.ConsistencyPolicy != nil {
		objectMap["consistencyPolicy"] = dacup.ConsistencyPolicy
	}
	if dacup.Locations != nil {
		objectMap["locations"] = dacup.Locations
	}
	if dacup.DatabaseAccountOfferType != nil {
		objectMap["databaseAccountOfferType"] = dacup.DatabaseAccountOfferType
	}
	if dacup.IPRules != nil {
		objectMap["ipRules"] = dacup.IPRules
	}
	if dacup.IsVirtualNetworkFilterEnabled != nil {
		objectMap["isVirtualNetworkFilterEnabled"] = dacup.IsVirtualNetworkFilterEnabled
	}
	if dacup.EnableAutomaticFailover != nil {
		objectMap["enableAutomaticFailover"] = dacup.EnableAutomaticFailover
	}
	if dacup.Capabilities != nil {
		objectMap["capabilities"] = dacup.Capabilities
	}
	if dacup.VirtualNetworkRules != nil {
		objectMap["virtualNetworkRules"] = dacup.VirtualNetworkRules
	}
	if dacup.EnableMultipleWriteLocations != nil {
		objectMap["enableMultipleWriteLocations"] = dacup.EnableMultipleWriteLocations
	}
	if dacup.EnableCassandraConnector != nil {
		objectMap["enableCassandraConnector"] = dacup.EnableCassandraConnector
	}
	if dacup.ConnectorOffer != "" {
		objectMap["connectorOffer"] = dacup.ConnectorOffer
	}
	if dacup.DisableKeyBasedMetadataWriteAccess != nil {
		objectMap["disableKeyBasedMetadataWriteAccess"] = dacup.DisableKeyBasedMetadataWriteAccess
	}
	if dacup.KeyVaultKeyURI != nil {
		objectMap["keyVaultKeyUri"] = dacup.KeyVaultKeyURI
	}
	if dacup.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dacup.PublicNetworkAccess
	}
	if dacup.EnableFreeTier != nil {
		objectMap["enableFreeTier"] = dacup.EnableFreeTier
	}
	if dacup.APIProperties != nil {
		objectMap["apiProperties"] = dacup.APIProperties
	}
	if dacup.EnableAnalyticalStorage != nil {
		objectMap["enableAnalyticalStorage"] = dacup.EnableAnalyticalStorage
	}
	objectMap["backupPolicy"] = dacup.BackupPolicy
	if dacup.Cors != nil {
		objectMap["cors"] = dacup.Cors
	}
	if dacup.CreateMode != "" {
		objectMap["createMode"] = dacup.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsDefaultRequestDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DatabaseAccountCreateUpdateProperties.
func (dacup DatabaseAccountCreateUpdateProperties) AsDefaultRequestDatabaseAccountCreateUpdateProperties() (*DefaultRequestDatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsRestoreReqeustDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DatabaseAccountCreateUpdateProperties.
func (dacup DatabaseAccountCreateUpdateProperties) AsRestoreReqeustDatabaseAccountCreateUpdateProperties() (*RestoreReqeustDatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DatabaseAccountCreateUpdateProperties.
func (dacup DatabaseAccountCreateUpdateProperties) AsDatabaseAccountCreateUpdateProperties() (*DatabaseAccountCreateUpdateProperties, bool) {
	return &dacup, true
}

// AsBasicDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DatabaseAccountCreateUpdateProperties.
func (dacup DatabaseAccountCreateUpdateProperties) AsBasicDatabaseAccountCreateUpdateProperties() (BasicDatabaseAccountCreateUpdateProperties, bool) {
	return &dacup, true
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountCreateUpdateProperties struct.
func (dacup *DatabaseAccountCreateUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "consistencyPolicy":
			if v != nil {
				var consistencyPolicy ConsistencyPolicy
				err = json.Unmarshal(*v, &consistencyPolicy)
				if err != nil {
					return err
				}
				dacup.ConsistencyPolicy = &consistencyPolicy
			}
		case "locations":
			if v != nil {
				var locations []Location
				err = json.Unmarshal(*v, &locations)
				if err != nil {
					return err
				}
				dacup.Locations = &locations
			}
		case "databaseAccountOfferType":
			if v != nil {
				var databaseAccountOfferType string
				err = json.Unmarshal(*v, &databaseAccountOfferType)
				if err != nil {
					return err
				}
				dacup.DatabaseAccountOfferType = &databaseAccountOfferType
			}
		case "ipRules":
			if v != nil {
				var IPRules []IPAddressOrRange
				err = json.Unmarshal(*v, &IPRules)
				if err != nil {
					return err
				}
				dacup.IPRules = &IPRules
			}
		case "isVirtualNetworkFilterEnabled":
			if v != nil {
				var isVirtualNetworkFilterEnabled bool
				err = json.Unmarshal(*v, &isVirtualNetworkFilterEnabled)
				if err != nil {
					return err
				}
				dacup.IsVirtualNetworkFilterEnabled = &isVirtualNetworkFilterEnabled
			}
		case "enableAutomaticFailover":
			if v != nil {
				var enableAutomaticFailover bool
				err = json.Unmarshal(*v, &enableAutomaticFailover)
				if err != nil {
					return err
				}
				dacup.EnableAutomaticFailover = &enableAutomaticFailover
			}
		case "capabilities":
			if v != nil {
				var capabilities []Capability
				err = json.Unmarshal(*v, &capabilities)
				if err != nil {
					return err
				}
				dacup.Capabilities = &capabilities
			}
		case "virtualNetworkRules":
			if v != nil {
				var virtualNetworkRules []VirtualNetworkRule
				err = json.Unmarshal(*v, &virtualNetworkRules)
				if err != nil {
					return err
				}
				dacup.VirtualNetworkRules = &virtualNetworkRules
			}
		case "enableMultipleWriteLocations":
			if v != nil {
				var enableMultipleWriteLocations bool
				err = json.Unmarshal(*v, &enableMultipleWriteLocations)
				if err != nil {
					return err
				}
				dacup.EnableMultipleWriteLocations = &enableMultipleWriteLocations
			}
		case "enableCassandraConnector":
			if v != nil {
				var enableCassandraConnector bool
				err = json.Unmarshal(*v, &enableCassandraConnector)
				if err != nil {
					return err
				}
				dacup.EnableCassandraConnector = &enableCassandraConnector
			}
		case "connectorOffer":
			if v != nil {
				var connectorOffer ConnectorOffer
				err = json.Unmarshal(*v, &connectorOffer)
				if err != nil {
					return err
				}
				dacup.ConnectorOffer = connectorOffer
			}
		case "disableKeyBasedMetadataWriteAccess":
			if v != nil {
				var disableKeyBasedMetadataWriteAccess bool
				err = json.Unmarshal(*v, &disableKeyBasedMetadataWriteAccess)
				if err != nil {
					return err
				}
				dacup.DisableKeyBasedMetadataWriteAccess = &disableKeyBasedMetadataWriteAccess
			}
		case "keyVaultKeyUri":
			if v != nil {
				var keyVaultKeyURI string
				err = json.Unmarshal(*v, &keyVaultKeyURI)
				if err != nil {
					return err
				}
				dacup.KeyVaultKeyURI = &keyVaultKeyURI
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				dacup.PublicNetworkAccess = publicNetworkAccess
			}
		case "enableFreeTier":
			if v != nil {
				var enableFreeTier bool
				err = json.Unmarshal(*v, &enableFreeTier)
				if err != nil {
					return err
				}
				dacup.EnableFreeTier = &enableFreeTier
			}
		case "apiProperties":
			if v != nil {
				var APIProperties APIProperties
				err = json.Unmarshal(*v, &APIProperties)
				if err != nil {
					return err
				}
				dacup.APIProperties = &APIProperties
			}
		case "enableAnalyticalStorage":
			if v != nil {
				var enableAnalyticalStorage bool
				err = json.Unmarshal(*v, &enableAnalyticalStorage)
				if err != nil {
					return err
				}
				dacup.EnableAnalyticalStorage = &enableAnalyticalStorage
			}
		case "backupPolicy":
			if v != nil {
				backupPolicy, err := unmarshalBasicBackupPolicy(*v)
				if err != nil {
					return err
				}
				dacup.BackupPolicy = backupPolicy
			}
		case "cors":
			if v != nil {
				var cors []CorsPolicy
				err = json.Unmarshal(*v, &cors)
				if err != nil {
					return err
				}
				dacup.Cors = &cors
			}
		case "createMode":
			if v != nil {
				var createMode CreateModeBasicDatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &createMode)
				if err != nil {
					return err
				}
				dacup.CreateMode = createMode
			}
		}
	}

	return nil
}

// DatabaseAccountGetProperties properties for the database account.
type DatabaseAccountGetProperties struct {
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string `json:"documentEndpoint,omitempty"`
	// DatabaseAccountOfferType - READ-ONLY; The offer type for the Cosmos DB database account. Default value: Standard. Possible values include: 'Standard'
	DatabaseAccountOfferType DatabaseAccountOfferType `json:"databaseAccountOfferType,omitempty"`
	// IPRules - List of IpRules.
	IPRules *[]IPAddressOrRange `json:"ipRules,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// WriteLocations - READ-ONLY; An array that contains the write location for the Cosmos DB account.
	WriteLocations *[]Location `json:"writeLocations,omitempty"`
	// ReadLocations - READ-ONLY; An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations *[]Location `json:"readLocations,omitempty"`
	// Locations - READ-ONLY; An array that contains all of the locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// FailoverPolicies - READ-ONLY; An array that contains the regions ordered by their failover priorities.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of Private Endpoint Connections configured for the Cosmos DB account.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
	// KeyVaultKeyURI - The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EnableFreeTier - Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`
	// APIProperties - API specific properties.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// EnableAnalyticalStorage - Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`
	// InstanceID - READ-ONLY; A unique identifier assigned to the database account
	InstanceID *string `json:"instanceId,omitempty"`
	// CreateMode - Enum to indicate the mode of account creation. Possible values include: 'Default', 'Restore'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// RestoreParameters - Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters `json:"restoreParameters,omitempty"`
	// BackupPolicy - The object representing the policy for taking backups on an account.
	BackupPolicy BasicBackupPolicy `json:"backupPolicy,omitempty"`
	// Cors - The CORS policy for the Cosmos DB database account.
	Cors *[]CorsPolicy `json:"cors,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountGetProperties.
func (dagp DatabaseAccountGetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dagp.ProvisioningState != nil {
		objectMap["provisioningState"] = dagp.ProvisioningState
	}
	if dagp.IPRules != nil {
		objectMap["ipRules"] = dagp.IPRules
	}
	if dagp.IsVirtualNetworkFilterEnabled != nil {
		objectMap["isVirtualNetworkFilterEnabled"] = dagp.IsVirtualNetworkFilterEnabled
	}
	if dagp.EnableAutomaticFailover != nil {
		objectMap["enableAutomaticFailover"] = dagp.EnableAutomaticFailover
	}
	if dagp.ConsistencyPolicy != nil {
		objectMap["consistencyPolicy"] = dagp.ConsistencyPolicy
	}
	if dagp.Capabilities != nil {
		objectMap["capabilities"] = dagp.Capabilities
	}
	if dagp.VirtualNetworkRules != nil {
		objectMap["virtualNetworkRules"] = dagp.VirtualNetworkRules
	}
	if dagp.EnableMultipleWriteLocations != nil {
		objectMap["enableMultipleWriteLocations"] = dagp.EnableMultipleWriteLocations
	}
	if dagp.EnableCassandraConnector != nil {
		objectMap["enableCassandraConnector"] = dagp.EnableCassandraConnector
	}
	if dagp.ConnectorOffer != "" {
		objectMap["connectorOffer"] = dagp.ConnectorOffer
	}
	if dagp.DisableKeyBasedMetadataWriteAccess != nil {
		objectMap["disableKeyBasedMetadataWriteAccess"] = dagp.DisableKeyBasedMetadataWriteAccess
	}
	if dagp.KeyVaultKeyURI != nil {
		objectMap["keyVaultKeyUri"] = dagp.KeyVaultKeyURI
	}
	if dagp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = dagp.PublicNetworkAccess
	}
	if dagp.EnableFreeTier != nil {
		objectMap["enableFreeTier"] = dagp.EnableFreeTier
	}
	if dagp.APIProperties != nil {
		objectMap["apiProperties"] = dagp.APIProperties
	}
	if dagp.EnableAnalyticalStorage != nil {
		objectMap["enableAnalyticalStorage"] = dagp.EnableAnalyticalStorage
	}
	if dagp.CreateMode != "" {
		objectMap["createMode"] = dagp.CreateMode
	}
	if dagp.RestoreParameters != nil {
		objectMap["restoreParameters"] = dagp.RestoreParameters
	}
	objectMap["backupPolicy"] = dagp.BackupPolicy
	if dagp.Cors != nil {
		objectMap["cors"] = dagp.Cors
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountGetProperties struct.
func (dagp *DatabaseAccountGetProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				dagp.ProvisioningState = &provisioningState
			}
		case "documentEndpoint":
			if v != nil {
				var documentEndpoint string
				err = json.Unmarshal(*v, &documentEndpoint)
				if err != nil {
					return err
				}
				dagp.DocumentEndpoint = &documentEndpoint
			}
		case "databaseAccountOfferType":
			if v != nil {
				var databaseAccountOfferType DatabaseAccountOfferType
				err = json.Unmarshal(*v, &databaseAccountOfferType)
				if err != nil {
					return err
				}
				dagp.DatabaseAccountOfferType = databaseAccountOfferType
			}
		case "ipRules":
			if v != nil {
				var IPRules []IPAddressOrRange
				err = json.Unmarshal(*v, &IPRules)
				if err != nil {
					return err
				}
				dagp.IPRules = &IPRules
			}
		case "isVirtualNetworkFilterEnabled":
			if v != nil {
				var isVirtualNetworkFilterEnabled bool
				err = json.Unmarshal(*v, &isVirtualNetworkFilterEnabled)
				if err != nil {
					return err
				}
				dagp.IsVirtualNetworkFilterEnabled = &isVirtualNetworkFilterEnabled
			}
		case "enableAutomaticFailover":
			if v != nil {
				var enableAutomaticFailover bool
				err = json.Unmarshal(*v, &enableAutomaticFailover)
				if err != nil {
					return err
				}
				dagp.EnableAutomaticFailover = &enableAutomaticFailover
			}
		case "consistencyPolicy":
			if v != nil {
				var consistencyPolicy ConsistencyPolicy
				err = json.Unmarshal(*v, &consistencyPolicy)
				if err != nil {
					return err
				}
				dagp.ConsistencyPolicy = &consistencyPolicy
			}
		case "capabilities":
			if v != nil {
				var capabilities []Capability
				err = json.Unmarshal(*v, &capabilities)
				if err != nil {
					return err
				}
				dagp.Capabilities = &capabilities
			}
		case "writeLocations":
			if v != nil {
				var writeLocations []Location
				err = json.Unmarshal(*v, &writeLocations)
				if err != nil {
					return err
				}
				dagp.WriteLocations = &writeLocations
			}
		case "readLocations":
			if v != nil {
				var readLocations []Location
				err = json.Unmarshal(*v, &readLocations)
				if err != nil {
					return err
				}
				dagp.ReadLocations = &readLocations
			}
		case "locations":
			if v != nil {
				var locations []Location
				err = json.Unmarshal(*v, &locations)
				if err != nil {
					return err
				}
				dagp.Locations = &locations
			}
		case "failoverPolicies":
			if v != nil {
				var failoverPolicies []FailoverPolicy
				err = json.Unmarshal(*v, &failoverPolicies)
				if err != nil {
					return err
				}
				dagp.FailoverPolicies = &failoverPolicies
			}
		case "virtualNetworkRules":
			if v != nil {
				var virtualNetworkRules []VirtualNetworkRule
				err = json.Unmarshal(*v, &virtualNetworkRules)
				if err != nil {
					return err
				}
				dagp.VirtualNetworkRules = &virtualNetworkRules
			}
		case "privateEndpointConnections":
			if v != nil {
				var privateEndpointConnections []PrivateEndpointConnection
				err = json.Unmarshal(*v, &privateEndpointConnections)
				if err != nil {
					return err
				}
				dagp.PrivateEndpointConnections = &privateEndpointConnections
			}
		case "enableMultipleWriteLocations":
			if v != nil {
				var enableMultipleWriteLocations bool
				err = json.Unmarshal(*v, &enableMultipleWriteLocations)
				if err != nil {
					return err
				}
				dagp.EnableMultipleWriteLocations = &enableMultipleWriteLocations
			}
		case "enableCassandraConnector":
			if v != nil {
				var enableCassandraConnector bool
				err = json.Unmarshal(*v, &enableCassandraConnector)
				if err != nil {
					return err
				}
				dagp.EnableCassandraConnector = &enableCassandraConnector
			}
		case "connectorOffer":
			if v != nil {
				var connectorOffer ConnectorOffer
				err = json.Unmarshal(*v, &connectorOffer)
				if err != nil {
					return err
				}
				dagp.ConnectorOffer = connectorOffer
			}
		case "disableKeyBasedMetadataWriteAccess":
			if v != nil {
				var disableKeyBasedMetadataWriteAccess bool
				err = json.Unmarshal(*v, &disableKeyBasedMetadataWriteAccess)
				if err != nil {
					return err
				}
				dagp.DisableKeyBasedMetadataWriteAccess = &disableKeyBasedMetadataWriteAccess
			}
		case "keyVaultKeyUri":
			if v != nil {
				var keyVaultKeyURI string
				err = json.Unmarshal(*v, &keyVaultKeyURI)
				if err != nil {
					return err
				}
				dagp.KeyVaultKeyURI = &keyVaultKeyURI
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				dagp.PublicNetworkAccess = publicNetworkAccess
			}
		case "enableFreeTier":
			if v != nil {
				var enableFreeTier bool
				err = json.Unmarshal(*v, &enableFreeTier)
				if err != nil {
					return err
				}
				dagp.EnableFreeTier = &enableFreeTier
			}
		case "apiProperties":
			if v != nil {
				var APIProperties APIProperties
				err = json.Unmarshal(*v, &APIProperties)
				if err != nil {
					return err
				}
				dagp.APIProperties = &APIProperties
			}
		case "enableAnalyticalStorage":
			if v != nil {
				var enableAnalyticalStorage bool
				err = json.Unmarshal(*v, &enableAnalyticalStorage)
				if err != nil {
					return err
				}
				dagp.EnableAnalyticalStorage = &enableAnalyticalStorage
			}
		case "instanceId":
			if v != nil {
				var instanceID string
				err = json.Unmarshal(*v, &instanceID)
				if err != nil {
					return err
				}
				dagp.InstanceID = &instanceID
			}
		case "createMode":
			if v != nil {
				var createMode CreateMode
				err = json.Unmarshal(*v, &createMode)
				if err != nil {
					return err
				}
				dagp.CreateMode = createMode
			}
		case "restoreParameters":
			if v != nil {
				var restoreParameters RestoreParameters
				err = json.Unmarshal(*v, &restoreParameters)
				if err != nil {
					return err
				}
				dagp.RestoreParameters = &restoreParameters
			}
		case "backupPolicy":
			if v != nil {
				backupPolicy, err := unmarshalBasicBackupPolicy(*v)
				if err != nil {
					return err
				}
				dagp.BackupPolicy = backupPolicy
			}
		case "cors":
			if v != nil {
				var cors []CorsPolicy
				err = json.Unmarshal(*v, &cors)
				if err != nil {
					return err
				}
				dagp.Cors = &cors
			}
		}
	}

	return nil
}

// DatabaseAccountGetResults an Azure Cosmos DB database account.
type DatabaseAccountGetResults struct {
	autorest.Response `json:"-"`
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'DatabaseAccountKindGlobalDocumentDB', 'DatabaseAccountKindMongoDB', 'DatabaseAccountKindParse'
	Kind                          DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountGetProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountGetResults.
func (dagr DatabaseAccountGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dagr.Kind != "" {
		objectMap["kind"] = dagr.Kind
	}
	if dagr.DatabaseAccountGetProperties != nil {
		objectMap["properties"] = dagr.DatabaseAccountGetProperties
	}
	if dagr.Location != nil {
		objectMap["location"] = dagr.Location
	}
	if dagr.Tags != nil {
		objectMap["tags"] = dagr.Tags
	}
	if dagr.Identity != nil {
		objectMap["identity"] = dagr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountGetResults struct.
func (dagr *DatabaseAccountGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dagr.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountGetProperties DatabaseAccountGetProperties
				err = json.Unmarshal(*v, &databaseAccountGetProperties)
				if err != nil {
					return err
				}
				dagr.DatabaseAccountGetProperties = &databaseAccountGetProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dagr.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dagr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dagr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dagr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dagr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dagr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dagr.Identity = &identity
			}
		}
	}

	return nil
}

// DatabaseAccountListConnectionStringsResult the connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	autorest.Response `json:"-"`
	// ConnectionStrings - An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings *[]DatabaseAccountConnectionString `json:"connectionStrings,omitempty"`
}

// DatabaseAccountListKeysResult the access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryMasterKey - READ-ONLY; Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string `json:"primaryMasterKey,omitempty"`
	// SecondaryMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey *string `json:"secondaryMasterKey,omitempty"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountListReadOnlyKeysResult the read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountRegenerateKeyParameters parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// KeyKind - The access key to regenerate. Possible values include: 'Primary', 'Secondary', 'PrimaryReadonly', 'SecondaryReadonly'
	KeyKind KeyKind `json:"keyKind,omitempty"`
}

// DatabaseAccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (DatabaseAccountGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsCreateOrUpdateFuture.Result.
func (future *DatabaseAccountsCreateOrUpdateFuture) result(client DatabaseAccountsClient) (dagr DatabaseAccountGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dagr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dagr.Response.Response, err = future.GetResult(sender); err == nil && dagr.Response.Response.StatusCode != http.StatusNoContent {
		dagr, err = client.CreateOrUpdateResponder(dagr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", dagr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsDeleteFuture.Result.
func (future *DatabaseAccountsDeleteFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsFailoverPriorityChangeFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsFailoverPriorityChangeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsFailoverPriorityChangeFuture.Result.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsFailoverPriorityChangeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsFailoverPriorityChangeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsListResult the List operation response, that contains the database accounts and their
// properties.
type DatabaseAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of database account and their properties.
	Value *[]DatabaseAccountGetResults `json:"value,omitempty"`
}

// DatabaseAccountsOfflineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOfflineRegionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsOfflineRegionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsOfflineRegionFuture.Result.
func (future *DatabaseAccountsOfflineRegionFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOfflineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOfflineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsOnlineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOnlineRegionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsOnlineRegionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsOnlineRegionFuture.Result.
func (future *DatabaseAccountsOnlineRegionFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOnlineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOnlineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsRegenerateKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsRegenerateKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsRegenerateKeyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsRegenerateKeyFuture.Result.
func (future *DatabaseAccountsRegenerateKeyFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsRegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsRegenerateKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (DatabaseAccountGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsUpdateFuture.Result.
func (future *DatabaseAccountsUpdateFuture) result(client DatabaseAccountsClient) (dagr DatabaseAccountGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dagr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dagr.Response.Response, err = future.GetResult(sender); err == nil && dagr.Response.Response.StatusCode != http.StatusNoContent {
		dagr, err = client.UpdateResponder(dagr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateFuture", "Result", dagr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountUpdateParameters parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountUpdateParameters struct {
	Tags map[string]*string `json:"tags"`
	// Location - The location of the resource group to which the resource belongs.
	Location                         *string `json:"location,omitempty"`
	*DatabaseAccountUpdateProperties `json:"properties,omitempty"`
	Identity                         *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountUpdateParameters.
func (daup DatabaseAccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if daup.Tags != nil {
		objectMap["tags"] = daup.Tags
	}
	if daup.Location != nil {
		objectMap["location"] = daup.Location
	}
	if daup.DatabaseAccountUpdateProperties != nil {
		objectMap["properties"] = daup.DatabaseAccountUpdateProperties
	}
	if daup.Identity != nil {
		objectMap["identity"] = daup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountUpdateParameters struct.
func (daup *DatabaseAccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				daup.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				daup.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseAccountUpdateProperties DatabaseAccountUpdateProperties
				err = json.Unmarshal(*v, &databaseAccountUpdateProperties)
				if err != nil {
					return err
				}
				daup.DatabaseAccountUpdateProperties = &databaseAccountUpdateProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				daup.Identity = &identity
			}
		}
	}

	return nil
}

// DatabaseAccountUpdateProperties properties to update Azure Cosmos DB database accounts.
type DatabaseAccountUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// IPRules - List of IpRules.
	IPRules *[]IPAddressOrRange `json:"ipRules,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
	// KeyVaultKeyURI - The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EnableFreeTier - Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`
	// APIProperties - API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// EnableAnalyticalStorage - Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`
	// BackupPolicy - The object representing the policy for taking backups on an account.
	BackupPolicy BasicBackupPolicy `json:"backupPolicy,omitempty"`
	// Cors - The CORS policy for the Cosmos DB database account.
	Cors *[]CorsPolicy `json:"cors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountUpdateProperties struct.
func (daup *DatabaseAccountUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "consistencyPolicy":
			if v != nil {
				var consistencyPolicy ConsistencyPolicy
				err = json.Unmarshal(*v, &consistencyPolicy)
				if err != nil {
					return err
				}
				daup.ConsistencyPolicy = &consistencyPolicy
			}
		case "locations":
			if v != nil {
				var locations []Location
				err = json.Unmarshal(*v, &locations)
				if err != nil {
					return err
				}
				daup.Locations = &locations
			}
		case "ipRules":
			if v != nil {
				var IPRules []IPAddressOrRange
				err = json.Unmarshal(*v, &IPRules)
				if err != nil {
					return err
				}
				daup.IPRules = &IPRules
			}
		case "isVirtualNetworkFilterEnabled":
			if v != nil {
				var isVirtualNetworkFilterEnabled bool
				err = json.Unmarshal(*v, &isVirtualNetworkFilterEnabled)
				if err != nil {
					return err
				}
				daup.IsVirtualNetworkFilterEnabled = &isVirtualNetworkFilterEnabled
			}
		case "enableAutomaticFailover":
			if v != nil {
				var enableAutomaticFailover bool
				err = json.Unmarshal(*v, &enableAutomaticFailover)
				if err != nil {
					return err
				}
				daup.EnableAutomaticFailover = &enableAutomaticFailover
			}
		case "capabilities":
			if v != nil {
				var capabilities []Capability
				err = json.Unmarshal(*v, &capabilities)
				if err != nil {
					return err
				}
				daup.Capabilities = &capabilities
			}
		case "virtualNetworkRules":
			if v != nil {
				var virtualNetworkRules []VirtualNetworkRule
				err = json.Unmarshal(*v, &virtualNetworkRules)
				if err != nil {
					return err
				}
				daup.VirtualNetworkRules = &virtualNetworkRules
			}
		case "enableMultipleWriteLocations":
			if v != nil {
				var enableMultipleWriteLocations bool
				err = json.Unmarshal(*v, &enableMultipleWriteLocations)
				if err != nil {
					return err
				}
				daup.EnableMultipleWriteLocations = &enableMultipleWriteLocations
			}
		case "enableCassandraConnector":
			if v != nil {
				var enableCassandraConnector bool
				err = json.Unmarshal(*v, &enableCassandraConnector)
				if err != nil {
					return err
				}
				daup.EnableCassandraConnector = &enableCassandraConnector
			}
		case "connectorOffer":
			if v != nil {
				var connectorOffer ConnectorOffer
				err = json.Unmarshal(*v, &connectorOffer)
				if err != nil {
					return err
				}
				daup.ConnectorOffer = connectorOffer
			}
		case "disableKeyBasedMetadataWriteAccess":
			if v != nil {
				var disableKeyBasedMetadataWriteAccess bool
				err = json.Unmarshal(*v, &disableKeyBasedMetadataWriteAccess)
				if err != nil {
					return err
				}
				daup.DisableKeyBasedMetadataWriteAccess = &disableKeyBasedMetadataWriteAccess
			}
		case "keyVaultKeyUri":
			if v != nil {
				var keyVaultKeyURI string
				err = json.Unmarshal(*v, &keyVaultKeyURI)
				if err != nil {
					return err
				}
				daup.KeyVaultKeyURI = &keyVaultKeyURI
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				daup.PublicNetworkAccess = publicNetworkAccess
			}
		case "enableFreeTier":
			if v != nil {
				var enableFreeTier bool
				err = json.Unmarshal(*v, &enableFreeTier)
				if err != nil {
					return err
				}
				daup.EnableFreeTier = &enableFreeTier
			}
		case "apiProperties":
			if v != nil {
				var APIProperties APIProperties
				err = json.Unmarshal(*v, &APIProperties)
				if err != nil {
					return err
				}
				daup.APIProperties = &APIProperties
			}
		case "enableAnalyticalStorage":
			if v != nil {
				var enableAnalyticalStorage bool
				err = json.Unmarshal(*v, &enableAnalyticalStorage)
				if err != nil {
					return err
				}
				daup.EnableAnalyticalStorage = &enableAnalyticalStorage
			}
		case "backupPolicy":
			if v != nil {
				backupPolicy, err := unmarshalBasicBackupPolicy(*v)
				if err != nil {
					return err
				}
				daup.BackupPolicy = backupPolicy
			}
		case "cors":
			if v != nil {
				var cors []CorsPolicy
				err = json.Unmarshal(*v, &cors)
				if err != nil {
					return err
				}
				daup.Cors = &cors
			}
		}
	}

	return nil
}

// DatabaseRestoreResource specific Databases to restore.
type DatabaseRestoreResource struct {
	// DatabaseName - The name of the database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`
	// CollectionNames - The names of the collections available for restore.
	CollectionNames *[]string `json:"collectionNames,omitempty"`
}

// DefaultErrorResponse an error response from the service.
type DefaultErrorResponse struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// DefaultRequestDatabaseAccountCreateUpdateProperties properties for non-restore Azure Cosmos DB database
// account requests.
type DefaultRequestDatabaseAccountCreateUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// DatabaseAccountOfferType - The offer type for the database
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`
	// IPRules - List of IpRules.
	IPRules *[]IPAddressOrRange `json:"ipRules,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
	// KeyVaultKeyURI - The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EnableFreeTier - Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`
	// APIProperties - API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// EnableAnalyticalStorage - Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`
	// BackupPolicy - The object representing the policy for taking backups on an account.
	BackupPolicy BasicBackupPolicy `json:"backupPolicy,omitempty"`
	// Cors - The CORS policy for the Cosmos DB database account.
	Cors *[]CorsPolicy `json:"cors,omitempty"`
	// CreateMode - Possible values include: 'CreateModeDatabaseAccountCreateUpdateProperties', 'CreateModeDefault', 'CreateModeRestore'
	CreateMode CreateModeBasicDatabaseAccountCreateUpdateProperties `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for DefaultRequestDatabaseAccountCreateUpdateProperties.
func (drdacup DefaultRequestDatabaseAccountCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	drdacup.CreateMode = CreateModeDefault
	objectMap := make(map[string]interface{})
	if drdacup.ConsistencyPolicy != nil {
		objectMap["consistencyPolicy"] = drdacup.ConsistencyPolicy
	}
	if drdacup.Locations != nil {
		objectMap["locations"] = drdacup.Locations
	}
	if drdacup.DatabaseAccountOfferType != nil {
		objectMap["databaseAccountOfferType"] = drdacup.DatabaseAccountOfferType
	}
	if drdacup.IPRules != nil {
		objectMap["ipRules"] = drdacup.IPRules
	}
	if drdacup.IsVirtualNetworkFilterEnabled != nil {
		objectMap["isVirtualNetworkFilterEnabled"] = drdacup.IsVirtualNetworkFilterEnabled
	}
	if drdacup.EnableAutomaticFailover != nil {
		objectMap["enableAutomaticFailover"] = drdacup.EnableAutomaticFailover
	}
	if drdacup.Capabilities != nil {
		objectMap["capabilities"] = drdacup.Capabilities
	}
	if drdacup.VirtualNetworkRules != nil {
		objectMap["virtualNetworkRules"] = drdacup.VirtualNetworkRules
	}
	if drdacup.EnableMultipleWriteLocations != nil {
		objectMap["enableMultipleWriteLocations"] = drdacup.EnableMultipleWriteLocations
	}
	if drdacup.EnableCassandraConnector != nil {
		objectMap["enableCassandraConnector"] = drdacup.EnableCassandraConnector
	}
	if drdacup.ConnectorOffer != "" {
		objectMap["connectorOffer"] = drdacup.ConnectorOffer
	}
	if drdacup.DisableKeyBasedMetadataWriteAccess != nil {
		objectMap["disableKeyBasedMetadataWriteAccess"] = drdacup.DisableKeyBasedMetadataWriteAccess
	}
	if drdacup.KeyVaultKeyURI != nil {
		objectMap["keyVaultKeyUri"] = drdacup.KeyVaultKeyURI
	}
	if drdacup.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = drdacup.PublicNetworkAccess
	}
	if drdacup.EnableFreeTier != nil {
		objectMap["enableFreeTier"] = drdacup.EnableFreeTier
	}
	if drdacup.APIProperties != nil {
		objectMap["apiProperties"] = drdacup.APIProperties
	}
	if drdacup.EnableAnalyticalStorage != nil {
		objectMap["enableAnalyticalStorage"] = drdacup.EnableAnalyticalStorage
	}
	objectMap["backupPolicy"] = drdacup.BackupPolicy
	if drdacup.Cors != nil {
		objectMap["cors"] = drdacup.Cors
	}
	if drdacup.CreateMode != "" {
		objectMap["createMode"] = drdacup.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsDefaultRequestDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DefaultRequestDatabaseAccountCreateUpdateProperties.
func (drdacup DefaultRequestDatabaseAccountCreateUpdateProperties) AsDefaultRequestDatabaseAccountCreateUpdateProperties() (*DefaultRequestDatabaseAccountCreateUpdateProperties, bool) {
	return &drdacup, true
}

// AsRestoreReqeustDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DefaultRequestDatabaseAccountCreateUpdateProperties.
func (drdacup DefaultRequestDatabaseAccountCreateUpdateProperties) AsRestoreReqeustDatabaseAccountCreateUpdateProperties() (*RestoreReqeustDatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DefaultRequestDatabaseAccountCreateUpdateProperties.
func (drdacup DefaultRequestDatabaseAccountCreateUpdateProperties) AsDatabaseAccountCreateUpdateProperties() (*DatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsBasicDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for DefaultRequestDatabaseAccountCreateUpdateProperties.
func (drdacup DefaultRequestDatabaseAccountCreateUpdateProperties) AsBasicDatabaseAccountCreateUpdateProperties() (BasicDatabaseAccountCreateUpdateProperties, bool) {
	return &drdacup, true
}

// UnmarshalJSON is the custom unmarshaler for DefaultRequestDatabaseAccountCreateUpdateProperties struct.
func (drdacup *DefaultRequestDatabaseAccountCreateUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "consistencyPolicy":
			if v != nil {
				var consistencyPolicy ConsistencyPolicy
				err = json.Unmarshal(*v, &consistencyPolicy)
				if err != nil {
					return err
				}
				drdacup.ConsistencyPolicy = &consistencyPolicy
			}
		case "locations":
			if v != nil {
				var locations []Location
				err = json.Unmarshal(*v, &locations)
				if err != nil {
					return err
				}
				drdacup.Locations = &locations
			}
		case "databaseAccountOfferType":
			if v != nil {
				var databaseAccountOfferType string
				err = json.Unmarshal(*v, &databaseAccountOfferType)
				if err != nil {
					return err
				}
				drdacup.DatabaseAccountOfferType = &databaseAccountOfferType
			}
		case "ipRules":
			if v != nil {
				var IPRules []IPAddressOrRange
				err = json.Unmarshal(*v, &IPRules)
				if err != nil {
					return err
				}
				drdacup.IPRules = &IPRules
			}
		case "isVirtualNetworkFilterEnabled":
			if v != nil {
				var isVirtualNetworkFilterEnabled bool
				err = json.Unmarshal(*v, &isVirtualNetworkFilterEnabled)
				if err != nil {
					return err
				}
				drdacup.IsVirtualNetworkFilterEnabled = &isVirtualNetworkFilterEnabled
			}
		case "enableAutomaticFailover":
			if v != nil {
				var enableAutomaticFailover bool
				err = json.Unmarshal(*v, &enableAutomaticFailover)
				if err != nil {
					return err
				}
				drdacup.EnableAutomaticFailover = &enableAutomaticFailover
			}
		case "capabilities":
			if v != nil {
				var capabilities []Capability
				err = json.Unmarshal(*v, &capabilities)
				if err != nil {
					return err
				}
				drdacup.Capabilities = &capabilities
			}
		case "virtualNetworkRules":
			if v != nil {
				var virtualNetworkRules []VirtualNetworkRule
				err = json.Unmarshal(*v, &virtualNetworkRules)
				if err != nil {
					return err
				}
				drdacup.VirtualNetworkRules = &virtualNetworkRules
			}
		case "enableMultipleWriteLocations":
			if v != nil {
				var enableMultipleWriteLocations bool
				err = json.Unmarshal(*v, &enableMultipleWriteLocations)
				if err != nil {
					return err
				}
				drdacup.EnableMultipleWriteLocations = &enableMultipleWriteLocations
			}
		case "enableCassandraConnector":
			if v != nil {
				var enableCassandraConnector bool
				err = json.Unmarshal(*v, &enableCassandraConnector)
				if err != nil {
					return err
				}
				drdacup.EnableCassandraConnector = &enableCassandraConnector
			}
		case "connectorOffer":
			if v != nil {
				var connectorOffer ConnectorOffer
				err = json.Unmarshal(*v, &connectorOffer)
				if err != nil {
					return err
				}
				drdacup.ConnectorOffer = connectorOffer
			}
		case "disableKeyBasedMetadataWriteAccess":
			if v != nil {
				var disableKeyBasedMetadataWriteAccess bool
				err = json.Unmarshal(*v, &disableKeyBasedMetadataWriteAccess)
				if err != nil {
					return err
				}
				drdacup.DisableKeyBasedMetadataWriteAccess = &disableKeyBasedMetadataWriteAccess
			}
		case "keyVaultKeyUri":
			if v != nil {
				var keyVaultKeyURI string
				err = json.Unmarshal(*v, &keyVaultKeyURI)
				if err != nil {
					return err
				}
				drdacup.KeyVaultKeyURI = &keyVaultKeyURI
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				drdacup.PublicNetworkAccess = publicNetworkAccess
			}
		case "enableFreeTier":
			if v != nil {
				var enableFreeTier bool
				err = json.Unmarshal(*v, &enableFreeTier)
				if err != nil {
					return err
				}
				drdacup.EnableFreeTier = &enableFreeTier
			}
		case "apiProperties":
			if v != nil {
				var APIProperties APIProperties
				err = json.Unmarshal(*v, &APIProperties)
				if err != nil {
					return err
				}
				drdacup.APIProperties = &APIProperties
			}
		case "enableAnalyticalStorage":
			if v != nil {
				var enableAnalyticalStorage bool
				err = json.Unmarshal(*v, &enableAnalyticalStorage)
				if err != nil {
					return err
				}
				drdacup.EnableAnalyticalStorage = &enableAnalyticalStorage
			}
		case "backupPolicy":
			if v != nil {
				backupPolicy, err := unmarshalBasicBackupPolicy(*v)
				if err != nil {
					return err
				}
				drdacup.BackupPolicy = backupPolicy
			}
		case "cors":
			if v != nil {
				var cors []CorsPolicy
				err = json.Unmarshal(*v, &cors)
				if err != nil {
					return err
				}
				drdacup.Cors = &cors
			}
		case "createMode":
			if v != nil {
				var createMode CreateModeBasicDatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &createMode)
				if err != nil {
					return err
				}
				drdacup.CreateMode = createMode
			}
		}
	}

	return nil
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ExcludedPath ...
type ExcludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// ExtendedResourceProperties the system generated resource properties associated with SQL databases, SQL
// containers, Gremlin databases and Gremlin graphs.
type ExtendedResourceProperties struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// FailoverPolicies the list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// FailoverPolicies - List of failover policies.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
}

// FailoverPolicy the failover policy for a given region of a database account.
type FailoverPolicy struct {
	// ID - READ-ONLY; The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region in which the database account exists.
	LocationName *string `json:"locationName,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverPolicy.
func (fp FailoverPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.LocationName != nil {
		objectMap["locationName"] = fp.LocationName
	}
	if fp.FailoverPriority != nil {
		objectMap["failoverPriority"] = fp.FailoverPriority
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseCreateUpdateParameters parameters to create and update Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateParameters struct {
	// GremlinDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin database.
	*GremlinDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseCreateUpdateParameters.
func (gdcup GremlinDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdcup.GremlinDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = gdcup.GremlinDatabaseCreateUpdateProperties
	}
	if gdcup.Location != nil {
		objectMap["location"] = gdcup.Location
	}
	if gdcup.Tags != nil {
		objectMap["tags"] = gdcup.Tags
	}
	if gdcup.Identity != nil {
		objectMap["identity"] = gdcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabaseCreateUpdateParameters struct.
func (gdcup *GremlinDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseCreateUpdateProperties GremlinDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				gdcup.GremlinDatabaseCreateUpdateProperties = &gremlinDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gdcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gdcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gdcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gdcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gdcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				gdcup.Identity = &identity
			}
		}
	}

	return nil
}

// GremlinDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin database
	Resource *GremlinDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// GremlinDatabaseGetProperties the properties of an Azure Cosmos DB SQL database
type GremlinDatabaseGetProperties struct {
	Resource *GremlinDatabaseGetPropertiesResource `json:"resource,omitempty"`
	Options  *GremlinDatabaseGetPropertiesOptions  `json:"options,omitempty"`
}

// GremlinDatabaseGetPropertiesOptions ...
type GremlinDatabaseGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// GremlinDatabaseGetPropertiesResource ...
type GremlinDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseGetPropertiesResource.
func (gdgp GremlinDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdgp.ID != nil {
		objectMap["id"] = gdgp.ID
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseGetResults an Azure Cosmos DB Gremlin database.
type GremlinDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// GremlinDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
	*GremlinDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseGetResults.
func (gdgr GremlinDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdgr.GremlinDatabaseGetProperties != nil {
		objectMap["properties"] = gdgr.GremlinDatabaseGetProperties
	}
	if gdgr.Location != nil {
		objectMap["location"] = gdgr.Location
	}
	if gdgr.Tags != nil {
		objectMap["tags"] = gdgr.Tags
	}
	if gdgr.Identity != nil {
		objectMap["identity"] = gdgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabaseGetResults struct.
func (gdgr *GremlinDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseGetProperties GremlinDatabaseGetProperties
				err = json.Unmarshal(*v, &gremlinDatabaseGetProperties)
				if err != nil {
					return err
				}
				gdgr.GremlinDatabaseGetProperties = &gremlinDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gdgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				gdgr.Identity = &identity
			}
		}
	}

	return nil
}

// GremlinDatabaseListResult the List operation response, that contains the Gremlin databases and their
// properties.
type GremlinDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Gremlin databases and their properties.
	Value *[]GremlinDatabaseGetResults `json:"value,omitempty"`
}

// GremlinDatabaseResource cosmos DB Gremlin database resource object
type GremlinDatabaseResource struct {
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
}

// GremlinGraphCreateUpdateParameters parameters to create and update Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateParameters struct {
	// GremlinGraphCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin graph.
	*GremlinGraphCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinGraphCreateUpdateParameters.
func (ggcup GremlinGraphCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggcup.GremlinGraphCreateUpdateProperties != nil {
		objectMap["properties"] = ggcup.GremlinGraphCreateUpdateProperties
	}
	if ggcup.Location != nil {
		objectMap["location"] = ggcup.Location
	}
	if ggcup.Tags != nil {
		objectMap["tags"] = ggcup.Tags
	}
	if ggcup.Identity != nil {
		objectMap["identity"] = ggcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraphCreateUpdateParameters struct.
func (ggcup *GremlinGraphCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphCreateUpdateProperties GremlinGraphCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinGraphCreateUpdateProperties)
				if err != nil {
					return err
				}
				ggcup.GremlinGraphCreateUpdateProperties = &gremlinGraphCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ggcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ggcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ggcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ggcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ggcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ggcup.Identity = &identity
			}
		}
	}

	return nil
}

// GremlinGraphCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin graph
	Resource *GremlinGraphResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// GremlinGraphGetProperties the properties of an Azure Cosmos DB Gremlin graph
type GremlinGraphGetProperties struct {
	Resource *GremlinGraphGetPropertiesResource `json:"resource,omitempty"`
	Options  *GremlinGraphGetPropertiesOptions  `json:"options,omitempty"`
}

// GremlinGraphGetPropertiesOptions ...
type GremlinGraphGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// GremlinGraphGetPropertiesResource ...
type GremlinGraphGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinGraphGetPropertiesResource.
func (gggp GremlinGraphGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gggp.ID != nil {
		objectMap["id"] = gggp.ID
	}
	if gggp.IndexingPolicy != nil {
		objectMap["indexingPolicy"] = gggp.IndexingPolicy
	}
	if gggp.PartitionKey != nil {
		objectMap["partitionKey"] = gggp.PartitionKey
	}
	if gggp.DefaultTTL != nil {
		objectMap["defaultTtl"] = gggp.DefaultTTL
	}
	if gggp.UniqueKeyPolicy != nil {
		objectMap["uniqueKeyPolicy"] = gggp.UniqueKeyPolicy
	}
	if gggp.ConflictResolutionPolicy != nil {
		objectMap["conflictResolutionPolicy"] = gggp.ConflictResolutionPolicy
	}
	return json.Marshal(objectMap)
}

// GremlinGraphGetResults an Azure Cosmos DB Gremlin graph.
type GremlinGraphGetResults struct {
	autorest.Response `json:"-"`
	// GremlinGraphGetProperties - The properties of an Azure Cosmos DB Gremlin graph
	*GremlinGraphGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinGraphGetResults.
func (gggr GremlinGraphGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gggr.GremlinGraphGetProperties != nil {
		objectMap["properties"] = gggr.GremlinGraphGetProperties
	}
	if gggr.Location != nil {
		objectMap["location"] = gggr.Location
	}
	if gggr.Tags != nil {
		objectMap["tags"] = gggr.Tags
	}
	if gggr.Identity != nil {
		objectMap["identity"] = gggr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraphGetResults struct.
func (gggr *GremlinGraphGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphGetProperties GremlinGraphGetProperties
				err = json.Unmarshal(*v, &gremlinGraphGetProperties)
				if err != nil {
					return err
				}
				gggr.GremlinGraphGetProperties = &gremlinGraphGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gggr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gggr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gggr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gggr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gggr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				gggr.Identity = &identity
			}
		}
	}

	return nil
}

// GremlinGraphListResult the List operation response, that contains the graphs and their properties.
type GremlinGraphListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of graphs and their properties.
	Value *[]GremlinGraphGetResults `json:"value,omitempty"`
}

// GremlinGraphResource cosmos DB Gremlin graph resource object
type GremlinGraphResource struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// GremlinResourcesCreateUpdateGremlinDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesCreateUpdateGremlinDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (GremlinDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesCreateUpdateGremlinDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesCreateUpdateGremlinDatabaseFuture.Result.
func (future *GremlinResourcesCreateUpdateGremlinDatabaseFuture) result(client GremlinResourcesClient) (gdgr GremlinDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gdgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gdgr.Response.Response, err = future.GetResult(sender); err == nil && gdgr.Response.Response.StatusCode != http.StatusNoContent {
		gdgr, err = client.CreateUpdateGremlinDatabaseResponder(gdgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture", "Result", gdgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesCreateUpdateGremlinGraphFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type GremlinResourcesCreateUpdateGremlinGraphFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (GremlinGraphGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesCreateUpdateGremlinGraphFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesCreateUpdateGremlinGraphFuture.Result.
func (future *GremlinResourcesCreateUpdateGremlinGraphFuture) result(client GremlinResourcesClient) (gggr GremlinGraphGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gggr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gggr.Response.Response, err = future.GetResult(sender); err == nil && gggr.Response.Response.StatusCode != http.StatusNoContent {
		gggr, err = client.CreateUpdateGremlinGraphResponder(gggr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture", "Result", gggr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesDeleteGremlinDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type GremlinResourcesDeleteGremlinDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesDeleteGremlinDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesDeleteGremlinDatabaseFuture.Result.
func (future *GremlinResourcesDeleteGremlinDatabaseFuture) result(client GremlinResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesDeleteGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesDeleteGremlinDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GremlinResourcesDeleteGremlinGraphFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GremlinResourcesDeleteGremlinGraphFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesDeleteGremlinGraphFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesDeleteGremlinGraphFuture.Result.
func (future *GremlinResourcesDeleteGremlinGraphFuture) result(client GremlinResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesDeleteGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesDeleteGremlinGraphFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GremlinResourcesUpdateGremlinDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesUpdateGremlinDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesUpdateGremlinDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesUpdateGremlinDatabaseThroughputFuture.Result.
func (future *GremlinResourcesUpdateGremlinDatabaseThroughputFuture) result(client GremlinResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateGremlinDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesUpdateGremlinGraphThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesUpdateGremlinGraphThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesUpdateGremlinGraphThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesUpdateGremlinGraphThroughputFuture.Result.
func (future *GremlinResourcesUpdateGremlinGraphThroughputFuture) result(client GremlinResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateGremlinGraphThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IncludedPath the paths that are included in indexing
type IncludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Indexes - List of indexes for this path
	Indexes *[]Indexes `json:"indexes,omitempty"`
}

// Indexes the indexes for the path.
type Indexes struct {
	// DataType - The datatype for which the indexing behavior is applied to. Possible values include: 'String', 'Number', 'Point', 'Polygon', 'LineString', 'MultiPolygon'
	DataType DataType `json:"dataType,omitempty"`
	// Precision - The precision of the index. -1 is maximum precision.
	Precision *int32 `json:"precision,omitempty"`
	// Kind - Indicates the type of index. Possible values include: 'Hash', 'Range', 'Spatial'
	Kind IndexKind `json:"kind,omitempty"`
}

// IndexingPolicy cosmos DB indexing policy
type IndexingPolicy struct {
	// Automatic - Indicates if the indexing policy is automatic
	Automatic *bool `json:"automatic,omitempty"`
	// IndexingMode - Indicates the indexing mode. Possible values include: 'Consistent', 'Lazy', 'None'
	IndexingMode IndexingMode `json:"indexingMode,omitempty"`
	// IncludedPaths - List of paths to include in the indexing
	IncludedPaths *[]IncludedPath `json:"includedPaths,omitempty"`
	// ExcludedPaths - List of paths to exclude from indexing
	ExcludedPaths *[]ExcludedPath `json:"excludedPaths,omitempty"`
	// CompositeIndexes - List of composite path list
	CompositeIndexes *[][]CompositePath `json:"compositeIndexes,omitempty"`
	// SpatialIndexes - List of spatial specifics
	SpatialIndexes *[]SpatialSpec `json:"spatialIndexes,omitempty"`
}

// IPAddressOrRange ipAddressOrRange object
type IPAddressOrRange struct {
	// IPAddressOrRange - A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
	IPAddressOrRange *string `json:"ipAddressOrRange,omitempty"`
}

// Location a region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// ID - READ-ONLY; The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region.
	LocationName *string `json:"locationName,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
	DocumentEndpoint  *string `json:"documentEndpoint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
	// IsZoneRedundant - Flag to indicate whether or not this region is an AvailabilityZone region
	IsZoneRedundant *bool `json:"isZoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LocationName != nil {
		objectMap["locationName"] = l.LocationName
	}
	if l.ProvisioningState != nil {
		objectMap["provisioningState"] = l.ProvisioningState
	}
	if l.FailoverPriority != nil {
		objectMap["failoverPriority"] = l.FailoverPriority
	}
	if l.IsZoneRedundant != nil {
		objectMap["isZoneRedundant"] = l.IsZoneRedundant
	}
	return json.Marshal(objectMap)
}

// ManagedServiceIdentity identity for the resource.
type ManagedServiceIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedServiceIdentityUserAssignedIdentitiesValue ...
type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// Metric metric data
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for Metric.
func (mVar Metric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Unit != "" {
		objectMap["unit"] = mVar.Unit
	}
	return json.Marshal(objectMap)
}

// MetricAvailability the availability of the metric.
type MetricAvailability struct {
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - READ-ONLY; The retention for the metric values.
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition the definition of a metric.
type MetricDefinition struct {
	// MetricAvailabilities - READ-ONLY; The list of metric availabilities for the account.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type of the metric. Possible values include: 'PrimaryAggregationTypeNone', 'PrimaryAggregationTypeAverage', 'PrimaryAggregationTypeTotal', 'PrimaryAggregationTypeMinimum', 'PrimaryAggregationTypeMaximum', 'PrimaryAggregationTypeLast'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.Unit != "" {
		objectMap["unit"] = md.Unit
	}
	return json.Marshal(objectMap)
}

// MetricDefinitionsListResult the response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metric definitions for the account.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metrics for the account.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents metrics values.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MongoDBCollectionCreateUpdateParameters parameters to create and update Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateParameters struct {
	// MongoDBCollectionCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB collection.
	*MongoDBCollectionCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionCreateUpdateParameters.
func (mdccup MongoDBCollectionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdccup.MongoDBCollectionCreateUpdateProperties != nil {
		objectMap["properties"] = mdccup.MongoDBCollectionCreateUpdateProperties
	}
	if mdccup.Location != nil {
		objectMap["location"] = mdccup.Location
	}
	if mdccup.Tags != nil {
		objectMap["tags"] = mdccup.Tags
	}
	if mdccup.Identity != nil {
		objectMap["identity"] = mdccup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollectionCreateUpdateParameters struct.
func (mdccup *MongoDBCollectionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionCreateUpdateProperties MongoDBCollectionCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBCollectionCreateUpdateProperties)
				if err != nil {
					return err
				}
				mdccup.MongoDBCollectionCreateUpdateProperties = &mongoDBCollectionCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdccup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdccup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdccup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdccup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdccup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mdccup.Identity = &identity
			}
		}
	}

	return nil
}

// MongoDBCollectionCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB
// collection.
type MongoDBCollectionCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB collection
	Resource *MongoDBCollectionResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// MongoDBCollectionGetProperties the properties of an Azure Cosmos DB MongoDB collection
type MongoDBCollectionGetProperties struct {
	Resource *MongoDBCollectionGetPropertiesResource `json:"resource,omitempty"`
	Options  *MongoDBCollectionGetPropertiesOptions  `json:"options,omitempty"`
}

// MongoDBCollectionGetPropertiesOptions ...
type MongoDBCollectionGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// MongoDBCollectionGetPropertiesResource ...
type MongoDBCollectionGetPropertiesResource struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
	// AnalyticalStorageTTL - Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionGetPropertiesResource.
func (mdcgp MongoDBCollectionGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcgp.ID != nil {
		objectMap["id"] = mdcgp.ID
	}
	if mdcgp.ShardKey != nil {
		objectMap["shardKey"] = mdcgp.ShardKey
	}
	if mdcgp.Indexes != nil {
		objectMap["indexes"] = mdcgp.Indexes
	}
	if mdcgp.AnalyticalStorageTTL != nil {
		objectMap["analyticalStorageTtl"] = mdcgp.AnalyticalStorageTTL
	}
	return json.Marshal(objectMap)
}

// MongoDBCollectionGetResults an Azure Cosmos DB MongoDB collection.
type MongoDBCollectionGetResults struct {
	autorest.Response `json:"-"`
	// MongoDBCollectionGetProperties - The properties of an Azure Cosmos DB MongoDB collection
	*MongoDBCollectionGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionGetResults.
func (mdcgr MongoDBCollectionGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcgr.MongoDBCollectionGetProperties != nil {
		objectMap["properties"] = mdcgr.MongoDBCollectionGetProperties
	}
	if mdcgr.Location != nil {
		objectMap["location"] = mdcgr.Location
	}
	if mdcgr.Tags != nil {
		objectMap["tags"] = mdcgr.Tags
	}
	if mdcgr.Identity != nil {
		objectMap["identity"] = mdcgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollectionGetResults struct.
func (mdcgr *MongoDBCollectionGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionGetProperties MongoDBCollectionGetProperties
				err = json.Unmarshal(*v, &mongoDBCollectionGetProperties)
				if err != nil {
					return err
				}
				mdcgr.MongoDBCollectionGetProperties = &mongoDBCollectionGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdcgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdcgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdcgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdcgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdcgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mdcgr.Identity = &identity
			}
		}
	}

	return nil
}

// MongoDBCollectionListResult the List operation response, that contains the MongoDB collections and their
// properties.
type MongoDBCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB collections and their properties.
	Value *[]MongoDBCollectionGetResults `json:"value,omitempty"`
}

// MongoDBCollectionResource cosmos DB MongoDB collection resource object
type MongoDBCollectionResource struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
	// AnalyticalStorageTTL - Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionResource.
func (mdcr MongoDBCollectionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcr.ID != nil {
		objectMap["id"] = mdcr.ID
	}
	if mdcr.ShardKey != nil {
		objectMap["shardKey"] = mdcr.ShardKey
	}
	if mdcr.Indexes != nil {
		objectMap["indexes"] = mdcr.Indexes
	}
	if mdcr.AnalyticalStorageTTL != nil {
		objectMap["analyticalStorageTtl"] = mdcr.AnalyticalStorageTTL
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseCreateUpdateParameters parameters to create and update Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateParameters struct {
	// MongoDBDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB database.
	*MongoDBDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseCreateUpdateParameters.
func (mddcup MongoDBDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddcup.MongoDBDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = mddcup.MongoDBDatabaseCreateUpdateProperties
	}
	if mddcup.Location != nil {
		objectMap["location"] = mddcup.Location
	}
	if mddcup.Tags != nil {
		objectMap["tags"] = mddcup.Tags
	}
	if mddcup.Identity != nil {
		objectMap["identity"] = mddcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabaseCreateUpdateParameters struct.
func (mddcup *MongoDBDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseCreateUpdateProperties MongoDBDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				mddcup.MongoDBDatabaseCreateUpdateProperties = &mongoDBDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mddcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mddcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mddcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mddcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mddcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mddcup.Identity = &identity
			}
		}
	}

	return nil
}

// MongoDBDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB database
	Resource *MongoDBDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// MongoDBDatabaseGetProperties the properties of an Azure Cosmos DB MongoDB database
type MongoDBDatabaseGetProperties struct {
	Resource *MongoDBDatabaseGetPropertiesResource `json:"resource,omitempty"`
	Options  *MongoDBDatabaseGetPropertiesOptions  `json:"options,omitempty"`
}

// MongoDBDatabaseGetPropertiesOptions ...
type MongoDBDatabaseGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// MongoDBDatabaseGetPropertiesResource ...
type MongoDBDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseGetPropertiesResource.
func (mddgp MongoDBDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddgp.ID != nil {
		objectMap["id"] = mddgp.ID
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseGetResults an Azure Cosmos DB MongoDB database.
type MongoDBDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// MongoDBDatabaseGetProperties - The properties of an Azure Cosmos DB MongoDB database
	*MongoDBDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseGetResults.
func (mddgr MongoDBDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddgr.MongoDBDatabaseGetProperties != nil {
		objectMap["properties"] = mddgr.MongoDBDatabaseGetProperties
	}
	if mddgr.Location != nil {
		objectMap["location"] = mddgr.Location
	}
	if mddgr.Tags != nil {
		objectMap["tags"] = mddgr.Tags
	}
	if mddgr.Identity != nil {
		objectMap["identity"] = mddgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabaseGetResults struct.
func (mddgr *MongoDBDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseGetProperties MongoDBDatabaseGetProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseGetProperties)
				if err != nil {
					return err
				}
				mddgr.MongoDBDatabaseGetProperties = &mongoDBDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mddgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mddgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mddgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mddgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mddgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mddgr.Identity = &identity
			}
		}
	}

	return nil
}

// MongoDBDatabaseListResult the List operation response, that contains the MongoDB databases and their
// properties.
type MongoDBDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB databases and their properties.
	Value *[]MongoDBDatabaseGetResults `json:"value,omitempty"`
}

// MongoDBDatabaseResource cosmos DB MongoDB database resource object
type MongoDBDatabaseResource struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
}

// MongoDBResourcesCreateUpdateMongoDBCollectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesCreateUpdateMongoDBCollectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (MongoDBCollectionGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesCreateUpdateMongoDBCollectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesCreateUpdateMongoDBCollectionFuture.Result.
func (future *MongoDBResourcesCreateUpdateMongoDBCollectionFuture) result(client MongoDBResourcesClient) (mdcgr MongoDBCollectionGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mdcgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mdcgr.Response.Response, err = future.GetResult(sender); err == nil && mdcgr.Response.Response.StatusCode != http.StatusNoContent {
		mdcgr, err = client.CreateUpdateMongoDBCollectionResponder(mdcgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture", "Result", mdcgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesCreateUpdateMongoDBDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesCreateUpdateMongoDBDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (MongoDBDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesCreateUpdateMongoDBDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesCreateUpdateMongoDBDatabaseFuture.Result.
func (future *MongoDBResourcesCreateUpdateMongoDBDatabaseFuture) result(client MongoDBResourcesClient) (mddgr MongoDBDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mddgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mddgr.Response.Response, err = future.GetResult(sender); err == nil && mddgr.Response.Response.StatusCode != http.StatusNoContent {
		mddgr, err = client.CreateUpdateMongoDBDatabaseResponder(mddgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture", "Result", mddgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesDeleteMongoDBCollectionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type MongoDBResourcesDeleteMongoDBCollectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesDeleteMongoDBCollectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesDeleteMongoDBCollectionFuture.Result.
func (future *MongoDBResourcesDeleteMongoDBCollectionFuture) result(client MongoDBResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesDeleteMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesDeleteMongoDBCollectionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MongoDBResourcesDeleteMongoDBDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type MongoDBResourcesDeleteMongoDBDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesDeleteMongoDBDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesDeleteMongoDBDatabaseFuture.Result.
func (future *MongoDBResourcesDeleteMongoDBDatabaseFuture) result(client MongoDBResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesDeleteMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesDeleteMongoDBDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MongoDBResourcesUpdateMongoDBCollectionThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesUpdateMongoDBCollectionThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesUpdateMongoDBCollectionThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesUpdateMongoDBCollectionThroughputFuture.Result.
func (future *MongoDBResourcesUpdateMongoDBCollectionThroughputFuture) result(client MongoDBResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateMongoDBCollectionThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture.Result.
func (future *MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture) result(client MongoDBResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateMongoDBDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoIndex cosmos DB MongoDB collection index key
type MongoIndex struct {
	// Key - Cosmos DB MongoDB collection index keys
	Key *MongoIndexKeys `json:"key,omitempty"`
	// Options - Cosmos DB MongoDB collection index key options
	Options *MongoIndexOptions `json:"options,omitempty"`
}

// MongoIndexKeys cosmos DB MongoDB collection resource object
type MongoIndexKeys struct {
	// Keys - List of keys for each MongoDB collection in the Azure Cosmos DB service
	Keys *[]string `json:"keys,omitempty"`
}

// MongoIndexOptions cosmos DB MongoDB collection index options
type MongoIndexOptions struct {
	// ExpireAfterSeconds - Expire after seconds
	ExpireAfterSeconds *int32 `json:"expireAfterSeconds,omitempty"`
	// Unique - Is unique or not
	Unique *bool `json:"unique,omitempty"`
}

// NotebookWorkspace a notebook workspace resource
type NotebookWorkspace struct {
	autorest.Response `json:"-"`
	// NotebookWorkspaceProperties - Resource properties.
	*NotebookWorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NotebookWorkspace.
func (nw NotebookWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nw.NotebookWorkspaceProperties != nil {
		objectMap["properties"] = nw.NotebookWorkspaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotebookWorkspace struct.
func (nw *NotebookWorkspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notebookWorkspaceProperties NotebookWorkspaceProperties
				err = json.Unmarshal(*v, &notebookWorkspaceProperties)
				if err != nil {
					return err
				}
				nw.NotebookWorkspaceProperties = &notebookWorkspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nw.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nw.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nw.Type = &typeVar
			}
		}
	}

	return nil
}

// NotebookWorkspaceConnectionInfoResult the connection info for the given notebook workspace
type NotebookWorkspaceConnectionInfoResult struct {
	autorest.Response `json:"-"`
	// AuthToken - READ-ONLY; Specifies auth token used for connecting to Notebook server (uses token-based auth).
	AuthToken *string `json:"authToken,omitempty"`
	// NotebookServerEndpoint - READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty"`
}

// NotebookWorkspaceCreateUpdateParameters parameters to create a notebook workspace resource
type NotebookWorkspaceCreateUpdateParameters struct {
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// NotebookWorkspaceListResult a list of notebook workspace resources
type NotebookWorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of notebook workspace resources
	Value *[]NotebookWorkspace `json:"value,omitempty"`
}

// NotebookWorkspaceProperties properties of a notebook workspace resource.
type NotebookWorkspaceProperties struct {
	// NotebookServerEndpoint - READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty"`
	// Status - READ-ONLY; Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
	Status *string `json:"status,omitempty"`
}

// NotebookWorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NotebookWorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (NotebookWorkspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesCreateOrUpdateFuture.Result.
func (future *NotebookWorkspacesCreateOrUpdateFuture) result(client NotebookWorkspacesClient) (nw NotebookWorkspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		nw.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nw.Response.Response, err = future.GetResult(sender); err == nil && nw.Response.Response.StatusCode != http.StatusNoContent {
		nw, err = client.CreateOrUpdateResponder(nw.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesCreateOrUpdateFuture", "Result", nw.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NotebookWorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NotebookWorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesDeleteFuture.Result.
func (future *NotebookWorkspacesDeleteFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NotebookWorkspacesRegenerateAuthTokenFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type NotebookWorkspacesRegenerateAuthTokenFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesRegenerateAuthTokenFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesRegenerateAuthTokenFuture.Result.
func (future *NotebookWorkspacesRegenerateAuthTokenFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesRegenerateAuthTokenFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesRegenerateAuthTokenFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NotebookWorkspacesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NotebookWorkspacesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesStartFuture.Result.
func (future *NotebookWorkspacesStartFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ResourceProvider
	Provider *string `json:"Provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"Resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"Operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"Description,omitempty"`
}

// OperationListResult result of the request to list Resource Provider operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Resource Provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OptionsResource cosmos DB options resource object
type OptionsResource struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// PartitionMetric the metric values for a single partition.
type PartitionMetric struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the metric values.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for PartitionMetric.
func (pm PartitionMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.Unit != "" {
		objectMap["unit"] = pm.Unit
	}
	return json.Marshal(objectMap)
}

// PartitionMetricListResult the response to a list partition metrics request.
type PartitionMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level metrics for the account.
	Value *[]PartitionMetric `json:"value,omitempty"`
}

// PartitionUsage the partition level usage data for a usage request.
type PartitionUsage struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the usages.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// MarshalJSON is the custom marshaler for PartitionUsage.
func (pu PartitionUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pu.Unit != "" {
		objectMap["unit"] = pu.Unit
	}
	return json.Marshal(objectMap)
}

// PartitionUsagesResult the response to a list partition level usage request.
type PartitionUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level usages for the database. A usage is a point in time metric
	Value *[]PartitionUsage `json:"value,omitempty"`
}

// PercentileMetric percentile Metric data
type PercentileMetric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The percentile metric values for the specified time window and timestep.
	MetricValues *[]PercentileMetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for PercentileMetric.
func (pm PercentileMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.Unit != "" {
		objectMap["unit"] = pm.Unit
	}
	return json.Marshal(objectMap)
}

// PercentileMetricListResult the response to a list percentile metrics request.
type PercentileMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of percentile metrics for the account.
	Value *[]PercentileMetric `json:"value,omitempty"`
}

// PercentileMetricValue represents percentile metrics values.
type PercentileMetricValue struct {
	// P10 - READ-ONLY; The 10th percentile value for the metric.
	P10 *float64 `json:"P10,omitempty"`
	// P25 - READ-ONLY; The 25th percentile value for the metric.
	P25 *float64 `json:"P25,omitempty"`
	// P50 - READ-ONLY; The 50th percentile value for the metric.
	P50 *float64 `json:"P50,omitempty"`
	// P75 - READ-ONLY; The 75th percentile value for the metric.
	P75 *float64 `json:"P75,omitempty"`
	// P90 - READ-ONLY; The 90th percentile value for the metric.
	P90 *float64 `json:"P90,omitempty"`
	// P95 - READ-ONLY; The 95th percentile value for the metric.
	P95 *float64 `json:"P95,omitempty"`
	// P99 - READ-ONLY; The 99th percentile value for the metric.
	P99 *float64 `json:"P99,omitempty"`
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// PeriodicModeBackupPolicy the object representing periodic mode backup policy.
type PeriodicModeBackupPolicy struct {
	// PeriodicModeProperties - Configuration values for periodic mode backup
	PeriodicModeProperties *PeriodicModeProperties `json:"periodicModeProperties,omitempty"`
	// Type - Possible values include: 'TypeBackupPolicy', 'TypePeriodic', 'TypeContinuous'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodicModeBackupPolicy.
func (pmbp PeriodicModeBackupPolicy) MarshalJSON() ([]byte, error) {
	pmbp.Type = TypePeriodic
	objectMap := make(map[string]interface{})
	if pmbp.PeriodicModeProperties != nil {
		objectMap["periodicModeProperties"] = pmbp.PeriodicModeProperties
	}
	if pmbp.Type != "" {
		objectMap["type"] = pmbp.Type
	}
	return json.Marshal(objectMap)
}

// AsPeriodicModeBackupPolicy is the BasicBackupPolicy implementation for PeriodicModeBackupPolicy.
func (pmbp PeriodicModeBackupPolicy) AsPeriodicModeBackupPolicy() (*PeriodicModeBackupPolicy, bool) {
	return &pmbp, true
}

// AsContinuousModeBackupPolicy is the BasicBackupPolicy implementation for PeriodicModeBackupPolicy.
func (pmbp PeriodicModeBackupPolicy) AsContinuousModeBackupPolicy() (*ContinuousModeBackupPolicy, bool) {
	return nil, false
}

// AsBackupPolicy is the BasicBackupPolicy implementation for PeriodicModeBackupPolicy.
func (pmbp PeriodicModeBackupPolicy) AsBackupPolicy() (*BackupPolicy, bool) {
	return nil, false
}

// AsBasicBackupPolicy is the BasicBackupPolicy implementation for PeriodicModeBackupPolicy.
func (pmbp PeriodicModeBackupPolicy) AsBasicBackupPolicy() (BasicBackupPolicy, bool) {
	return &pmbp, true
}

// PeriodicModeProperties configuration values for periodic mode backup
type PeriodicModeProperties struct {
	// BackupIntervalInMinutes - An integer representing the interval in minutes between two backups
	BackupIntervalInMinutes *int32 `json:"backupIntervalInMinutes,omitempty"`
	// BackupRetentionIntervalInHours - An integer representing the time (in hours) that each backup is retained
	BackupRetentionIntervalInHours *int32 `json:"backupRetentionIntervalInHours,omitempty"`
}

// Permission the set of data plane operations permitted through this Role Definition.
type Permission struct {
	// DataActions - An array of data actions that are allowed.
	DataActions *[]string `json:"dataActions,omitempty"`
	// NotDataActions - An array of data actions that are denied.
	NotDataActions *[]string `json:"notDataActions,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// GroupID - Group id of the private endpoint.
	GroupID *string `json:"groupId,omitempty"`
	// ProvisioningState - Provisioning state of the private endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointProperty private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; The private link resource required zone names.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkServiceConnectionStateProperty connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// ActionsRequired - READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string `json:"actionsRequired,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionStateProperty.
func (plscsp PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscsp.Status != nil {
		objectMap["status"] = plscsp.Status
	}
	if plscsp.Description != nil {
		objectMap["description"] = plscsp.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// RegionForOnlineOffline cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// Region - Cosmos DB region, with spaces between words and each word capitalized.
	Region *string `json:"region,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// RestorableDatabaseAccountGetResult a Azure Cosmos DB restorable database account.
type RestorableDatabaseAccountGetResult struct {
	autorest.Response `json:"-"`
	// RestorableDatabaseAccountProperties - The properties of a restorable database account.
	*RestorableDatabaseAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDatabaseAccountGetResult.
func (rdagr RestorableDatabaseAccountGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdagr.RestorableDatabaseAccountProperties != nil {
		objectMap["properties"] = rdagr.RestorableDatabaseAccountProperties
	}
	if rdagr.Location != nil {
		objectMap["location"] = rdagr.Location
	}
	if rdagr.Tags != nil {
		objectMap["tags"] = rdagr.Tags
	}
	if rdagr.Identity != nil {
		objectMap["identity"] = rdagr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDatabaseAccountGetResult struct.
func (rdagr *RestorableDatabaseAccountGetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableDatabaseAccountProperties RestorableDatabaseAccountProperties
				err = json.Unmarshal(*v, &restorableDatabaseAccountProperties)
				if err != nil {
					return err
				}
				rdagr.RestorableDatabaseAccountProperties = &restorableDatabaseAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdagr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdagr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdagr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdagr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdagr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rdagr.Identity = &identity
			}
		}
	}

	return nil
}

// RestorableDatabaseAccountProperties the properties of a restorable database account.
type RestorableDatabaseAccountProperties struct {
	// AccountName - The name of the global database account
	AccountName *string `json:"accountName,omitempty"`
	// CreationTime - The creation time of the restorable database account (ISO-8601 format).
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// DeletionTime - The time at which the restorable database account has been deleted (ISO-8601 format).
	DeletionTime *date.Time `json:"deletionTime,omitempty"`
	// APIType - READ-ONLY; The API type of the restorable database account. Possible values include: 'MongoDB', 'Gremlin', 'Cassandra', 'Table', 'SQL', 'GremlinV2'
	APIType APIType `json:"apiType,omitempty"`
	// RestorableLocations - READ-ONLY; List of regions where the of the database account can be restored from.
	RestorableLocations *[]RestorableLocationResource `json:"restorableLocations,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDatabaseAccountProperties.
func (rdap RestorableDatabaseAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdap.AccountName != nil {
		objectMap["accountName"] = rdap.AccountName
	}
	if rdap.CreationTime != nil {
		objectMap["creationTime"] = rdap.CreationTime
	}
	if rdap.DeletionTime != nil {
		objectMap["deletionTime"] = rdap.DeletionTime
	}
	return json.Marshal(objectMap)
}

// RestorableDatabaseAccountsListResult the List operation response, that contains the restorable database
// accounts and their properties.
type RestorableDatabaseAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable database accounts and their properties.
	Value *[]RestorableDatabaseAccountGetResult `json:"value,omitempty"`
}

// RestorableLocationResource properties of the regional restorable account.
type RestorableLocationResource struct {
	// LocationName - READ-ONLY; The location of the regional restorable account.
	LocationName *string `json:"locationName,omitempty"`
	// RegionalDatabaseAccountInstanceID - READ-ONLY; The instance id of the regional restorable account.
	RegionalDatabaseAccountInstanceID *string `json:"regionalDatabaseAccountInstanceId,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the regional restorable database account (ISO-8601 format).
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// DeletionTime - READ-ONLY; The time at which the regional restorable database account has been deleted (ISO-8601 format).
	DeletionTime *date.Time `json:"deletionTime,omitempty"`
}

// RestorableMongodbCollectionGetResult an Azure Cosmos DB restorable MongoDB collection
type RestorableMongodbCollectionGetResult struct {
	// RestorableMongodbCollectionProperties - The properties of a restorable MongoDB collection.
	*RestorableMongodbCollectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableMongodbCollectionGetResult.
func (rmcgr RestorableMongodbCollectionGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmcgr.RestorableMongodbCollectionProperties != nil {
		objectMap["properties"] = rmcgr.RestorableMongodbCollectionProperties
	}
	if rmcgr.Location != nil {
		objectMap["location"] = rmcgr.Location
	}
	if rmcgr.Tags != nil {
		objectMap["tags"] = rmcgr.Tags
	}
	if rmcgr.Identity != nil {
		objectMap["identity"] = rmcgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableMongodbCollectionGetResult struct.
func (rmcgr *RestorableMongodbCollectionGetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableMongodbCollectionProperties RestorableMongodbCollectionProperties
				err = json.Unmarshal(*v, &restorableMongodbCollectionProperties)
				if err != nil {
					return err
				}
				rmcgr.RestorableMongodbCollectionProperties = &restorableMongodbCollectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmcgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmcgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmcgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rmcgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rmcgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rmcgr.Identity = &identity
			}
		}
	}

	return nil
}

// RestorableMongodbCollectionProperties the properties of an Azure Cosmos DB restorable MongoDB collection
type RestorableMongodbCollectionProperties struct {
	Resource *RestorableMongodbCollectionPropertiesResource `json:"resource,omitempty"`
}

// RestorableMongodbCollectionPropertiesResource ...
type RestorableMongodbCollectionPropertiesResource struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// OperationType - READ-ONLY; The operation type of this collection event. Possible values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
	OperationType OperationType `json:"operationType,omitempty"`
	// EventTimestamp - READ-ONLY; The timestamp of this collection event.
	EventTimestamp *string `json:"eventTimestamp,omitempty"`
	// OwnerID - READ-ONLY; The name of this restorable MongoDB collection.
	OwnerID *string `json:"ownerId,omitempty"`
	// OwnerResourceID - READ-ONLY; The resource Id of this restorable MongoDB collection.
	OwnerResourceID *string `json:"ownerResourceId,omitempty"`
}

// RestorableMongodbCollectionsListResult the List operation response, that contains the restorable MongoDB
// collections and their properties.
type RestorableMongodbCollectionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable MongoDB collections and their properties.
	Value *[]RestorableMongodbCollectionGetResult `json:"value,omitempty"`
}

// RestorableMongodbDatabaseGetResult an Azure Cosmos DB restorable MongoDB database
type RestorableMongodbDatabaseGetResult struct {
	// RestorableMongodbDatabaseProperties - The properties of a restorable MongoDB database.
	*RestorableMongodbDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableMongodbDatabaseGetResult.
func (rmdgr RestorableMongodbDatabaseGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmdgr.RestorableMongodbDatabaseProperties != nil {
		objectMap["properties"] = rmdgr.RestorableMongodbDatabaseProperties
	}
	if rmdgr.Location != nil {
		objectMap["location"] = rmdgr.Location
	}
	if rmdgr.Tags != nil {
		objectMap["tags"] = rmdgr.Tags
	}
	if rmdgr.Identity != nil {
		objectMap["identity"] = rmdgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableMongodbDatabaseGetResult struct.
func (rmdgr *RestorableMongodbDatabaseGetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableMongodbDatabaseProperties RestorableMongodbDatabaseProperties
				err = json.Unmarshal(*v, &restorableMongodbDatabaseProperties)
				if err != nil {
					return err
				}
				rmdgr.RestorableMongodbDatabaseProperties = &restorableMongodbDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rmdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rmdgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rmdgr.Identity = &identity
			}
		}
	}

	return nil
}

// RestorableMongodbDatabaseProperties the properties of an Azure Cosmos DB restorable MongoDB database
type RestorableMongodbDatabaseProperties struct {
	Resource *RestorableMongodbDatabasePropertiesResource `json:"resource,omitempty"`
}

// RestorableMongodbDatabasePropertiesResource ...
type RestorableMongodbDatabasePropertiesResource struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// OperationType - READ-ONLY; The operation type of this database event. Possible values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
	OperationType OperationType `json:"operationType,omitempty"`
	// EventTimestamp - READ-ONLY; The timestamp of this database event.
	EventTimestamp *string `json:"eventTimestamp,omitempty"`
	// OwnerID - READ-ONLY; The name of this restorable MongoDB database.
	OwnerID *string `json:"ownerId,omitempty"`
	// OwnerResourceID - READ-ONLY; The resource Id of this restorable MongoDB database.
	OwnerResourceID *string `json:"ownerResourceId,omitempty"`
}

// RestorableMongodbDatabasesListResult the List operation response, that contains the restorable MongoDB
// databases and their properties.
type RestorableMongodbDatabasesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable MongoDB databases and their properties.
	Value *[]RestorableMongodbDatabaseGetResult `json:"value,omitempty"`
}

// RestorableMongodbResourcesListResult the List operation response, that contains the restorable MongoDB
// resources.
type RestorableMongodbResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable MongoDB resources, including the database and collection names.
	Value *[]DatabaseRestoreResource `json:"value,omitempty"`
}

// RestorableSQLContainerGetResult an Azure Cosmos DB restorable SQL container
type RestorableSQLContainerGetResult struct {
	// RestorableSQLContainerProperties - The properties of a restorable SQL container.
	*RestorableSQLContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLContainerGetResult.
func (rscgr RestorableSQLContainerGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rscgr.RestorableSQLContainerProperties != nil {
		objectMap["properties"] = rscgr.RestorableSQLContainerProperties
	}
	if rscgr.Location != nil {
		objectMap["location"] = rscgr.Location
	}
	if rscgr.Tags != nil {
		objectMap["tags"] = rscgr.Tags
	}
	if rscgr.Identity != nil {
		objectMap["identity"] = rscgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableSQLContainerGetResult struct.
func (rscgr *RestorableSQLContainerGetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableSQLContainerProperties RestorableSQLContainerProperties
				err = json.Unmarshal(*v, &restorableSQLContainerProperties)
				if err != nil {
					return err
				}
				rscgr.RestorableSQLContainerProperties = &restorableSQLContainerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rscgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rscgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rscgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rscgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rscgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rscgr.Identity = &identity
			}
		}
	}

	return nil
}

// RestorableSQLContainerProperties the properties of an Azure Cosmos DB restorable SQL container
type RestorableSQLContainerProperties struct {
	Resource *RestorableSQLContainerPropertiesResource `json:"resource,omitempty"`
}

// RestorableSQLContainerPropertiesResource ...
type RestorableSQLContainerPropertiesResource struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// OperationType - READ-ONLY; The operation type of this container event. Possible values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
	OperationType OperationType `json:"operationType,omitempty"`
	// EventTimestamp - READ-ONLY; The timestamp of this container event.
	EventTimestamp *string `json:"eventTimestamp,omitempty"`
	// OwnerID - READ-ONLY; The name of this restorable SQL container.
	OwnerID *string `json:"ownerId,omitempty"`
	// OwnerResourceID - READ-ONLY; The resource Id of this restorable SQL container.
	OwnerResourceID *string                                            `json:"ownerResourceId,omitempty"`
	Container       *RestorableSQLContainerPropertiesResourceContainer `json:"container,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLContainerPropertiesResource.
func (rscp RestorableSQLContainerPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rscp.Container != nil {
		objectMap["container"] = rscp.Container
	}
	return json.Marshal(objectMap)
}

// RestorableSQLContainerPropertiesResourceContainer ...
type RestorableSQLContainerPropertiesResourceContainer struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// Self - READ-ONLY; A system generated property that specifies the addressable path of the container resource.
	Self *string `json:"_self,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLContainerPropertiesResourceContainer.
func (rscp RestorableSQLContainerPropertiesResourceContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rscp.ID != nil {
		objectMap["id"] = rscp.ID
	}
	if rscp.IndexingPolicy != nil {
		objectMap["indexingPolicy"] = rscp.IndexingPolicy
	}
	if rscp.PartitionKey != nil {
		objectMap["partitionKey"] = rscp.PartitionKey
	}
	if rscp.DefaultTTL != nil {
		objectMap["defaultTtl"] = rscp.DefaultTTL
	}
	if rscp.UniqueKeyPolicy != nil {
		objectMap["uniqueKeyPolicy"] = rscp.UniqueKeyPolicy
	}
	if rscp.ConflictResolutionPolicy != nil {
		objectMap["conflictResolutionPolicy"] = rscp.ConflictResolutionPolicy
	}
	return json.Marshal(objectMap)
}

// RestorableSQLContainersListResult the List operation response, that contains the restorable SQL
// containers and their properties.
type RestorableSQLContainersListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable SQL containers and their properties.
	Value *[]RestorableSQLContainerGetResult `json:"value,omitempty"`
}

// RestorableSQLDatabaseGetResult an Azure Cosmos DB restorable SQL database
type RestorableSQLDatabaseGetResult struct {
	// RestorableSQLDatabaseProperties - The properties of a restorable SQL database.
	*RestorableSQLDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLDatabaseGetResult.
func (rsdgr RestorableSQLDatabaseGetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsdgr.RestorableSQLDatabaseProperties != nil {
		objectMap["properties"] = rsdgr.RestorableSQLDatabaseProperties
	}
	if rsdgr.Location != nil {
		objectMap["location"] = rsdgr.Location
	}
	if rsdgr.Tags != nil {
		objectMap["tags"] = rsdgr.Tags
	}
	if rsdgr.Identity != nil {
		objectMap["identity"] = rsdgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableSQLDatabaseGetResult struct.
func (rsdgr *RestorableSQLDatabaseGetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableSQLDatabaseProperties RestorableSQLDatabaseProperties
				err = json.Unmarshal(*v, &restorableSQLDatabaseProperties)
				if err != nil {
					return err
				}
				rsdgr.RestorableSQLDatabaseProperties = &restorableSQLDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rsdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rsdgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rsdgr.Identity = &identity
			}
		}
	}

	return nil
}

// RestorableSQLDatabaseProperties the properties of an Azure Cosmos DB restorable SQL database
type RestorableSQLDatabaseProperties struct {
	Resource *RestorableSQLDatabasePropertiesResource `json:"resource,omitempty"`
}

// RestorableSQLDatabasePropertiesResource ...
type RestorableSQLDatabasePropertiesResource struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// OperationType - READ-ONLY; The operation type of this database event. Possible values include: 'Create', 'Replace', 'Delete', 'SystemOperation'
	OperationType OperationType `json:"operationType,omitempty"`
	// EventTimestamp - READ-ONLY; The timestamp of this database event.
	EventTimestamp *string `json:"eventTimestamp,omitempty"`
	// OwnerID - READ-ONLY; The name of this restorable SQL database.
	OwnerID *string `json:"ownerId,omitempty"`
	// OwnerResourceID - READ-ONLY; The resource Id of this restorable SQL database.
	OwnerResourceID *string                                          `json:"ownerResourceId,omitempty"`
	Database        *RestorableSQLDatabasePropertiesResourceDatabase `json:"database,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLDatabasePropertiesResource.
func (rsdp RestorableSQLDatabasePropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsdp.Database != nil {
		objectMap["database"] = rsdp.Database
	}
	return json.Marshal(objectMap)
}

// RestorableSQLDatabasePropertiesResourceDatabase ...
type RestorableSQLDatabasePropertiesResourceDatabase struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// Colls - READ-ONLY; A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty"`
	// Users - READ-ONLY; A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty"`
	// Self - READ-ONLY; A system generated property that specifies the addressable path of the database resource.
	Self *string `json:"_self,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableSQLDatabasePropertiesResourceDatabase.
func (rsdp RestorableSQLDatabasePropertiesResourceDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsdp.ID != nil {
		objectMap["id"] = rsdp.ID
	}
	return json.Marshal(objectMap)
}

// RestorableSQLDatabasesListResult the List operation response, that contains the restorable SQL databases
// and their properties.
type RestorableSQLDatabasesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable SQL databases and their properties.
	Value *[]RestorableSQLDatabaseGetResult `json:"value,omitempty"`
}

// RestorableSQLResourcesListResult the List operation response, that contains the restorable SQL
// resources.
type RestorableSQLResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of restorable SQL resources, including the database and collection names.
	Value *[]DatabaseRestoreResource `json:"value,omitempty"`
}

// RestoreParameters parameters to indicate the information about the restore.
type RestoreParameters struct {
	// RestoreMode - Describes the mode of the restore. Possible values include: 'PointInTime'
	RestoreMode RestoreMode `json:"restoreMode,omitempty"`
	// RestoreSource - The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string `json:"restoreSource,omitempty"`
	// RestoreTimestampInUtc - Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUtc *date.Time `json:"restoreTimestampInUtc,omitempty"`
	// DatabasesToRestore - List of specific databases available for restore.
	DatabasesToRestore *[]DatabaseRestoreResource `json:"databasesToRestore,omitempty"`
}

// RestoreReqeustDatabaseAccountCreateUpdateProperties properties to restore Azure Cosmos DB database
// account.
type RestoreReqeustDatabaseAccountCreateUpdateProperties struct {
	// RestoreParameters - Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters `json:"restoreParameters,omitempty"`
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// DatabaseAccountOfferType - The offer type for the database
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`
	// IPRules - List of IpRules.
	IPRules *[]IPAddressOrRange `json:"ipRules,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
	// KeyVaultKeyURI - The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`
	// PublicNetworkAccess - Whether requests from Public Network are allowed. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// EnableFreeTier - Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`
	// APIProperties - API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// EnableAnalyticalStorage - Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`
	// BackupPolicy - The object representing the policy for taking backups on an account.
	BackupPolicy BasicBackupPolicy `json:"backupPolicy,omitempty"`
	// Cors - The CORS policy for the Cosmos DB database account.
	Cors *[]CorsPolicy `json:"cors,omitempty"`
	// CreateMode - Possible values include: 'CreateModeDatabaseAccountCreateUpdateProperties', 'CreateModeDefault', 'CreateModeRestore'
	CreateMode CreateModeBasicDatabaseAccountCreateUpdateProperties `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreReqeustDatabaseAccountCreateUpdateProperties.
func (rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	rrdacup.CreateMode = CreateModeRestore
	objectMap := make(map[string]interface{})
	if rrdacup.RestoreParameters != nil {
		objectMap["restoreParameters"] = rrdacup.RestoreParameters
	}
	if rrdacup.ConsistencyPolicy != nil {
		objectMap["consistencyPolicy"] = rrdacup.ConsistencyPolicy
	}
	if rrdacup.Locations != nil {
		objectMap["locations"] = rrdacup.Locations
	}
	if rrdacup.DatabaseAccountOfferType != nil {
		objectMap["databaseAccountOfferType"] = rrdacup.DatabaseAccountOfferType
	}
	if rrdacup.IPRules != nil {
		objectMap["ipRules"] = rrdacup.IPRules
	}
	if rrdacup.IsVirtualNetworkFilterEnabled != nil {
		objectMap["isVirtualNetworkFilterEnabled"] = rrdacup.IsVirtualNetworkFilterEnabled
	}
	if rrdacup.EnableAutomaticFailover != nil {
		objectMap["enableAutomaticFailover"] = rrdacup.EnableAutomaticFailover
	}
	if rrdacup.Capabilities != nil {
		objectMap["capabilities"] = rrdacup.Capabilities
	}
	if rrdacup.VirtualNetworkRules != nil {
		objectMap["virtualNetworkRules"] = rrdacup.VirtualNetworkRules
	}
	if rrdacup.EnableMultipleWriteLocations != nil {
		objectMap["enableMultipleWriteLocations"] = rrdacup.EnableMultipleWriteLocations
	}
	if rrdacup.EnableCassandraConnector != nil {
		objectMap["enableCassandraConnector"] = rrdacup.EnableCassandraConnector
	}
	if rrdacup.ConnectorOffer != "" {
		objectMap["connectorOffer"] = rrdacup.ConnectorOffer
	}
	if rrdacup.DisableKeyBasedMetadataWriteAccess != nil {
		objectMap["disableKeyBasedMetadataWriteAccess"] = rrdacup.DisableKeyBasedMetadataWriteAccess
	}
	if rrdacup.KeyVaultKeyURI != nil {
		objectMap["keyVaultKeyUri"] = rrdacup.KeyVaultKeyURI
	}
	if rrdacup.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = rrdacup.PublicNetworkAccess
	}
	if rrdacup.EnableFreeTier != nil {
		objectMap["enableFreeTier"] = rrdacup.EnableFreeTier
	}
	if rrdacup.APIProperties != nil {
		objectMap["apiProperties"] = rrdacup.APIProperties
	}
	if rrdacup.EnableAnalyticalStorage != nil {
		objectMap["enableAnalyticalStorage"] = rrdacup.EnableAnalyticalStorage
	}
	objectMap["backupPolicy"] = rrdacup.BackupPolicy
	if rrdacup.Cors != nil {
		objectMap["cors"] = rrdacup.Cors
	}
	if rrdacup.CreateMode != "" {
		objectMap["createMode"] = rrdacup.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsDefaultRequestDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for RestoreReqeustDatabaseAccountCreateUpdateProperties.
func (rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties) AsDefaultRequestDatabaseAccountCreateUpdateProperties() (*DefaultRequestDatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsRestoreReqeustDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for RestoreReqeustDatabaseAccountCreateUpdateProperties.
func (rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties) AsRestoreReqeustDatabaseAccountCreateUpdateProperties() (*RestoreReqeustDatabaseAccountCreateUpdateProperties, bool) {
	return &rrdacup, true
}

// AsDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for RestoreReqeustDatabaseAccountCreateUpdateProperties.
func (rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties) AsDatabaseAccountCreateUpdateProperties() (*DatabaseAccountCreateUpdateProperties, bool) {
	return nil, false
}

// AsBasicDatabaseAccountCreateUpdateProperties is the BasicDatabaseAccountCreateUpdateProperties implementation for RestoreReqeustDatabaseAccountCreateUpdateProperties.
func (rrdacup RestoreReqeustDatabaseAccountCreateUpdateProperties) AsBasicDatabaseAccountCreateUpdateProperties() (BasicDatabaseAccountCreateUpdateProperties, bool) {
	return &rrdacup, true
}

// UnmarshalJSON is the custom unmarshaler for RestoreReqeustDatabaseAccountCreateUpdateProperties struct.
func (rrdacup *RestoreReqeustDatabaseAccountCreateUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreParameters":
			if v != nil {
				var restoreParameters RestoreParameters
				err = json.Unmarshal(*v, &restoreParameters)
				if err != nil {
					return err
				}
				rrdacup.RestoreParameters = &restoreParameters
			}
		case "consistencyPolicy":
			if v != nil {
				var consistencyPolicy ConsistencyPolicy
				err = json.Unmarshal(*v, &consistencyPolicy)
				if err != nil {
					return err
				}
				rrdacup.ConsistencyPolicy = &consistencyPolicy
			}
		case "locations":
			if v != nil {
				var locations []Location
				err = json.Unmarshal(*v, &locations)
				if err != nil {
					return err
				}
				rrdacup.Locations = &locations
			}
		case "databaseAccountOfferType":
			if v != nil {
				var databaseAccountOfferType string
				err = json.Unmarshal(*v, &databaseAccountOfferType)
				if err != nil {
					return err
				}
				rrdacup.DatabaseAccountOfferType = &databaseAccountOfferType
			}
		case "ipRules":
			if v != nil {
				var IPRules []IPAddressOrRange
				err = json.Unmarshal(*v, &IPRules)
				if err != nil {
					return err
				}
				rrdacup.IPRules = &IPRules
			}
		case "isVirtualNetworkFilterEnabled":
			if v != nil {
				var isVirtualNetworkFilterEnabled bool
				err = json.Unmarshal(*v, &isVirtualNetworkFilterEnabled)
				if err != nil {
					return err
				}
				rrdacup.IsVirtualNetworkFilterEnabled = &isVirtualNetworkFilterEnabled
			}
		case "enableAutomaticFailover":
			if v != nil {
				var enableAutomaticFailover bool
				err = json.Unmarshal(*v, &enableAutomaticFailover)
				if err != nil {
					return err
				}
				rrdacup.EnableAutomaticFailover = &enableAutomaticFailover
			}
		case "capabilities":
			if v != nil {
				var capabilities []Capability
				err = json.Unmarshal(*v, &capabilities)
				if err != nil {
					return err
				}
				rrdacup.Capabilities = &capabilities
			}
		case "virtualNetworkRules":
			if v != nil {
				var virtualNetworkRules []VirtualNetworkRule
				err = json.Unmarshal(*v, &virtualNetworkRules)
				if err != nil {
					return err
				}
				rrdacup.VirtualNetworkRules = &virtualNetworkRules
			}
		case "enableMultipleWriteLocations":
			if v != nil {
				var enableMultipleWriteLocations bool
				err = json.Unmarshal(*v, &enableMultipleWriteLocations)
				if err != nil {
					return err
				}
				rrdacup.EnableMultipleWriteLocations = &enableMultipleWriteLocations
			}
		case "enableCassandraConnector":
			if v != nil {
				var enableCassandraConnector bool
				err = json.Unmarshal(*v, &enableCassandraConnector)
				if err != nil {
					return err
				}
				rrdacup.EnableCassandraConnector = &enableCassandraConnector
			}
		case "connectorOffer":
			if v != nil {
				var connectorOffer ConnectorOffer
				err = json.Unmarshal(*v, &connectorOffer)
				if err != nil {
					return err
				}
				rrdacup.ConnectorOffer = connectorOffer
			}
		case "disableKeyBasedMetadataWriteAccess":
			if v != nil {
				var disableKeyBasedMetadataWriteAccess bool
				err = json.Unmarshal(*v, &disableKeyBasedMetadataWriteAccess)
				if err != nil {
					return err
				}
				rrdacup.DisableKeyBasedMetadataWriteAccess = &disableKeyBasedMetadataWriteAccess
			}
		case "keyVaultKeyUri":
			if v != nil {
				var keyVaultKeyURI string
				err = json.Unmarshal(*v, &keyVaultKeyURI)
				if err != nil {
					return err
				}
				rrdacup.KeyVaultKeyURI = &keyVaultKeyURI
			}
		case "publicNetworkAccess":
			if v != nil {
				var publicNetworkAccess PublicNetworkAccess
				err = json.Unmarshal(*v, &publicNetworkAccess)
				if err != nil {
					return err
				}
				rrdacup.PublicNetworkAccess = publicNetworkAccess
			}
		case "enableFreeTier":
			if v != nil {
				var enableFreeTier bool
				err = json.Unmarshal(*v, &enableFreeTier)
				if err != nil {
					return err
				}
				rrdacup.EnableFreeTier = &enableFreeTier
			}
		case "apiProperties":
			if v != nil {
				var APIProperties APIProperties
				err = json.Unmarshal(*v, &APIProperties)
				if err != nil {
					return err
				}
				rrdacup.APIProperties = &APIProperties
			}
		case "enableAnalyticalStorage":
			if v != nil {
				var enableAnalyticalStorage bool
				err = json.Unmarshal(*v, &enableAnalyticalStorage)
				if err != nil {
					return err
				}
				rrdacup.EnableAnalyticalStorage = &enableAnalyticalStorage
			}
		case "backupPolicy":
			if v != nil {
				backupPolicy, err := unmarshalBasicBackupPolicy(*v)
				if err != nil {
					return err
				}
				rrdacup.BackupPolicy = backupPolicy
			}
		case "cors":
			if v != nil {
				var cors []CorsPolicy
				err = json.Unmarshal(*v, &cors)
				if err != nil {
					return err
				}
				rrdacup.Cors = &cors
			}
		case "createMode":
			if v != nil {
				var createMode CreateModeBasicDatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &createMode)
				if err != nil {
					return err
				}
				rrdacup.CreateMode = createMode
			}
		}
	}

	return nil
}

// SpatialSpec ...
type SpatialSpec struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Types - List of path's spatial type
	Types *[]SpatialType `json:"types,omitempty"`
}

// SQLContainerCreateUpdateParameters parameters to create and update Cosmos DB container.
type SQLContainerCreateUpdateParameters struct {
	// SQLContainerCreateUpdateProperties - Properties to create and update Azure Cosmos DB container.
	*SQLContainerCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLContainerCreateUpdateParameters.
func (sccup SQLContainerCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccup.SQLContainerCreateUpdateProperties != nil {
		objectMap["properties"] = sccup.SQLContainerCreateUpdateProperties
	}
	if sccup.Location != nil {
		objectMap["location"] = sccup.Location
	}
	if sccup.Tags != nil {
		objectMap["tags"] = sccup.Tags
	}
	if sccup.Identity != nil {
		objectMap["identity"] = sccup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainerCreateUpdateParameters struct.
func (sccup *SQLContainerCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerCreateUpdateProperties SQLContainerCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLContainerCreateUpdateProperties)
				if err != nil {
					return err
				}
				sccup.SQLContainerCreateUpdateProperties = &SQLContainerCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sccup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sccup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sccup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sccup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sccup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sccup.Identity = &identity
			}
		}
	}

	return nil
}

// SQLContainerCreateUpdateProperties properties to create and update Azure Cosmos DB container.
type SQLContainerCreateUpdateProperties struct {
	// Resource - The standard JSON format of a container
	Resource *SQLContainerResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLContainerGetProperties the properties of an Azure Cosmos DB container
type SQLContainerGetProperties struct {
	Resource *SQLContainerGetPropertiesResource `json:"resource,omitempty"`
	Options  *SQLContainerGetPropertiesOptions  `json:"options,omitempty"`
}

// SQLContainerGetPropertiesOptions ...
type SQLContainerGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// SQLContainerGetPropertiesResource ...
type SQLContainerGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLContainerGetPropertiesResource.
func (scgp SQLContainerGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scgp.ID != nil {
		objectMap["id"] = scgp.ID
	}
	if scgp.IndexingPolicy != nil {
		objectMap["indexingPolicy"] = scgp.IndexingPolicy
	}
	if scgp.PartitionKey != nil {
		objectMap["partitionKey"] = scgp.PartitionKey
	}
	if scgp.DefaultTTL != nil {
		objectMap["defaultTtl"] = scgp.DefaultTTL
	}
	if scgp.UniqueKeyPolicy != nil {
		objectMap["uniqueKeyPolicy"] = scgp.UniqueKeyPolicy
	}
	if scgp.ConflictResolutionPolicy != nil {
		objectMap["conflictResolutionPolicy"] = scgp.ConflictResolutionPolicy
	}
	return json.Marshal(objectMap)
}

// SQLContainerGetResults an Azure Cosmos DB container.
type SQLContainerGetResults struct {
	autorest.Response `json:"-"`
	// SQLContainerGetProperties - The properties of an Azure Cosmos DB container
	*SQLContainerGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLContainerGetResults.
func (scgr SQLContainerGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scgr.SQLContainerGetProperties != nil {
		objectMap["properties"] = scgr.SQLContainerGetProperties
	}
	if scgr.Location != nil {
		objectMap["location"] = scgr.Location
	}
	if scgr.Tags != nil {
		objectMap["tags"] = scgr.Tags
	}
	if scgr.Identity != nil {
		objectMap["identity"] = scgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainerGetResults struct.
func (scgr *SQLContainerGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerGetProperties SQLContainerGetProperties
				err = json.Unmarshal(*v, &SQLContainerGetProperties)
				if err != nil {
					return err
				}
				scgr.SQLContainerGetProperties = &SQLContainerGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				scgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				scgr.Identity = &identity
			}
		}
	}

	return nil
}

// SQLContainerListResult the List operation response, that contains the containers and their properties.
type SQLContainerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of containers and their properties.
	Value *[]SQLContainerGetResults `json:"value,omitempty"`
}

// SQLContainerResource cosmos DB SQL container resource object
type SQLContainerResource struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// SQLDatabaseCreateUpdateParameters parameters to create and update Cosmos DB SQL database.
type SQLDatabaseCreateUpdateParameters struct {
	// SQLDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB SQL database.
	*SQLDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseCreateUpdateParameters.
func (sdcup SQLDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcup.SQLDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = sdcup.SQLDatabaseCreateUpdateProperties
	}
	if sdcup.Location != nil {
		objectMap["location"] = sdcup.Location
	}
	if sdcup.Tags != nil {
		objectMap["tags"] = sdcup.Tags
	}
	if sdcup.Identity != nil {
		objectMap["identity"] = sdcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabaseCreateUpdateParameters struct.
func (sdcup *SQLDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseCreateUpdateProperties SQLDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				sdcup.SQLDatabaseCreateUpdateProperties = &SQLDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sdcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sdcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sdcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sdcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sdcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sdcup.Identity = &identity
			}
		}
	}

	return nil
}

// SQLDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB SQL database.
type SQLDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a SQL database
	Resource *SQLDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLDatabaseGetProperties the properties of an Azure Cosmos DB SQL database
type SQLDatabaseGetProperties struct {
	Resource *SQLDatabaseGetPropertiesResource `json:"resource,omitempty"`
	Options  *SQLDatabaseGetPropertiesOptions  `json:"options,omitempty"`
}

// SQLDatabaseGetPropertiesOptions ...
type SQLDatabaseGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// SQLDatabaseGetPropertiesResource ...
type SQLDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// Colls - A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty"`
	// Users - A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseGetPropertiesResource.
func (sdgp SQLDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdgp.ID != nil {
		objectMap["id"] = sdgp.ID
	}
	if sdgp.Colls != nil {
		objectMap["_colls"] = sdgp.Colls
	}
	if sdgp.Users != nil {
		objectMap["_users"] = sdgp.Users
	}
	return json.Marshal(objectMap)
}

// SQLDatabaseGetResults an Azure Cosmos DB SQL database.
type SQLDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// SQLDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
	*SQLDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseGetResults.
func (sdgr SQLDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdgr.SQLDatabaseGetProperties != nil {
		objectMap["properties"] = sdgr.SQLDatabaseGetProperties
	}
	if sdgr.Location != nil {
		objectMap["location"] = sdgr.Location
	}
	if sdgr.Tags != nil {
		objectMap["tags"] = sdgr.Tags
	}
	if sdgr.Identity != nil {
		objectMap["identity"] = sdgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabaseGetResults struct.
func (sdgr *SQLDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseGetProperties SQLDatabaseGetProperties
				err = json.Unmarshal(*v, &SQLDatabaseGetProperties)
				if err != nil {
					return err
				}
				sdgr.SQLDatabaseGetProperties = &SQLDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sdgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sdgr.Identity = &identity
			}
		}
	}

	return nil
}

// SQLDatabaseListResult the List operation response, that contains the SQL databases and their properties.
type SQLDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of SQL databases and their properties.
	Value *[]SQLDatabaseGetResults `json:"value,omitempty"`
}

// SQLDatabaseResource cosmos DB SQL database resource object
type SQLDatabaseResource struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
}

// SQLResourcesCreateUpdateSQLContainerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLContainerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLContainerGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLContainerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLContainerFuture.Result.
func (future *SQLResourcesCreateUpdateSQLContainerFuture) result(client SQLResourcesClient) (scgr SQLContainerGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLContainerFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scgr.Response.Response, err = future.GetResult(sender); err == nil && scgr.Response.Response.StatusCode != http.StatusNoContent {
		scgr, err = client.CreateUpdateSQLContainerResponder(scgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLContainerFuture", "Result", scgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLDatabaseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLDatabaseFuture.Result.
func (future *SQLResourcesCreateUpdateSQLDatabaseFuture) result(client SQLResourcesClient) (sdgr SQLDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sdgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sdgr.Response.Response, err = future.GetResult(sender); err == nil && sdgr.Response.Response.StatusCode != http.StatusNoContent {
		sdgr, err = client.CreateUpdateSQLDatabaseResponder(sdgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture", "Result", sdgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLRoleAssignmentFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesCreateUpdateSQLRoleAssignmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLRoleAssignmentGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLRoleAssignmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLRoleAssignmentFuture.Result.
func (future *SQLResourcesCreateUpdateSQLRoleAssignmentFuture) result(client SQLResourcesClient) (sragr SQLRoleAssignmentGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLRoleAssignmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sragr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLRoleAssignmentFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sragr.Response.Response, err = future.GetResult(sender); err == nil && sragr.Response.Response.StatusCode != http.StatusNoContent {
		sragr, err = client.CreateUpdateSQLRoleAssignmentResponder(sragr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLRoleAssignmentFuture", "Result", sragr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLRoleDefinitionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesCreateUpdateSQLRoleDefinitionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLRoleDefinitionGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLRoleDefinitionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLRoleDefinitionFuture.Result.
func (future *SQLResourcesCreateUpdateSQLRoleDefinitionFuture) result(client SQLResourcesClient) (srdgr SQLRoleDefinitionGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLRoleDefinitionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		srdgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLRoleDefinitionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if srdgr.Response.Response, err = future.GetResult(sender); err == nil && srdgr.Response.Response.StatusCode != http.StatusNoContent {
		srdgr, err = client.CreateUpdateSQLRoleDefinitionResponder(srdgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLRoleDefinitionFuture", "Result", srdgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLStoredProcedureFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLResourcesCreateUpdateSQLStoredProcedureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLStoredProcedureGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLStoredProcedureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLStoredProcedureFuture.Result.
func (future *SQLResourcesCreateUpdateSQLStoredProcedureFuture) result(client SQLResourcesClient) (sspgr SQLStoredProcedureGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sspgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sspgr.Response.Response, err = future.GetResult(sender); err == nil && sspgr.Response.Response.StatusCode != http.StatusNoContent {
		sspgr, err = client.CreateUpdateSQLStoredProcedureResponder(sspgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture", "Result", sspgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLTriggerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLTriggerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLTriggerGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLTriggerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLTriggerFuture.Result.
func (future *SQLResourcesCreateUpdateSQLTriggerFuture) result(client SQLResourcesClient) (stgr SQLTriggerGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLTriggerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		stgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLTriggerFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if stgr.Response.Response, err = future.GetResult(sender); err == nil && stgr.Response.Response.StatusCode != http.StatusNoContent {
		stgr, err = client.CreateUpdateSQLTriggerResponder(stgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLTriggerFuture", "Result", stgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLUserDefinedFunctionGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture.Result.
func (future *SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture) result(client SQLResourcesClient) (sudfgr SQLUserDefinedFunctionGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sudfgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sudfgr.Response.Response, err = future.GetResult(sender); err == nil && sudfgr.Response.Response.StatusCode != http.StatusNoContent {
		sudfgr, err = client.CreateUpdateSQLUserDefinedFunctionResponder(sudfgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture", "Result", sudfgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesDeleteSQLContainerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLContainerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLContainerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLContainerFuture.Result.
func (future *SQLResourcesDeleteSQLContainerFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLContainerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLDatabaseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLDatabaseFuture.Result.
func (future *SQLResourcesDeleteSQLDatabaseFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLRoleAssignmentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLRoleAssignmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLRoleAssignmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLRoleAssignmentFuture.Result.
func (future *SQLResourcesDeleteSQLRoleAssignmentFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLRoleAssignmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLRoleAssignmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLRoleDefinitionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLRoleDefinitionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLRoleDefinitionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLRoleDefinitionFuture.Result.
func (future *SQLResourcesDeleteSQLRoleDefinitionFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLRoleDefinitionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLRoleDefinitionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLStoredProcedureFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLStoredProcedureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLStoredProcedureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLStoredProcedureFuture.Result.
func (future *SQLResourcesDeleteSQLStoredProcedureFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLStoredProcedureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLStoredProcedureFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLTriggerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLTriggerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLTriggerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLTriggerFuture.Result.
func (future *SQLResourcesDeleteSQLTriggerFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLTriggerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLTriggerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLUserDefinedFunctionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesDeleteSQLUserDefinedFunctionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLUserDefinedFunctionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLUserDefinedFunctionFuture.Result.
func (future *SQLResourcesDeleteSQLUserDefinedFunctionFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLUserDefinedFunctionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLUserDefinedFunctionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesUpdateSQLContainerThroughputFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesUpdateSQLContainerThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesUpdateSQLContainerThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesUpdateSQLContainerThroughputFuture.Result.
func (future *SQLResourcesUpdateSQLContainerThroughputFuture) result(client SQLResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLContainerThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesUpdateSQLContainerThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateSQLContainerThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLContainerThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesUpdateSQLDatabaseThroughputFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesUpdateSQLDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesUpdateSQLDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesUpdateSQLDatabaseThroughputFuture.Result.
func (future *SQLResourcesUpdateSQLDatabaseThroughputFuture) result(client SQLResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateSQLDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLRoleAssignmentCreateUpdateParameters parameters to create and update an Azure Cosmos DB SQL Role
// Assignment.
type SQLRoleAssignmentCreateUpdateParameters struct {
	// SQLRoleAssignmentResource - Properties to create and update an Azure Cosmos DB SQL Role Assignment.
	*SQLRoleAssignmentResource `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLRoleAssignmentCreateUpdateParameters.
func (sracup SQLRoleAssignmentCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sracup.SQLRoleAssignmentResource != nil {
		objectMap["properties"] = sracup.SQLRoleAssignmentResource
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLRoleAssignmentCreateUpdateParameters struct.
func (sracup *SQLRoleAssignmentCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLRoleAssignmentResource SQLRoleAssignmentResource
				err = json.Unmarshal(*v, &SQLRoleAssignmentResource)
				if err != nil {
					return err
				}
				sracup.SQLRoleAssignmentResource = &SQLRoleAssignmentResource
			}
		}
	}

	return nil
}

// SQLRoleAssignmentGetResults an Azure Cosmos DB Role Assignment
type SQLRoleAssignmentGetResults struct {
	autorest.Response `json:"-"`
	// SQLRoleAssignmentResource - Properties related to the Role Assignment.
	*SQLRoleAssignmentResource `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLRoleAssignmentGetResults.
func (sragr SQLRoleAssignmentGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sragr.SQLRoleAssignmentResource != nil {
		objectMap["properties"] = sragr.SQLRoleAssignmentResource
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLRoleAssignmentGetResults struct.
func (sragr *SQLRoleAssignmentGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLRoleAssignmentResource SQLRoleAssignmentResource
				err = json.Unmarshal(*v, &SQLRoleAssignmentResource)
				if err != nil {
					return err
				}
				sragr.SQLRoleAssignmentResource = &SQLRoleAssignmentResource
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sragr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sragr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sragr.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLRoleAssignmentListResult the relevant Role Assignments.
type SQLRoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Role Assignments and their properties
	Value *[]SQLRoleAssignmentGetResults `json:"value,omitempty"`
}

// SQLRoleAssignmentResource azure Cosmos DB SQL Role Assignment resource object.
type SQLRoleAssignmentResource struct {
	// RoleDefinitionID - The unique identifier for the associated Role Definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Scope - The data plane resource path for which access is being granted through this Role Assignment.
	Scope *string `json:"scope,omitempty"`
	// PrincipalID - The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
	PrincipalID *string `json:"principalId,omitempty"`
}

// SQLRoleDefinitionCreateUpdateParameters parameters to create and update an Azure Cosmos DB SQL Role
// Definition.
type SQLRoleDefinitionCreateUpdateParameters struct {
	// SQLRoleDefinitionResource - Properties to create and update an Azure Cosmos DB SQL Role Definition.
	*SQLRoleDefinitionResource `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLRoleDefinitionCreateUpdateParameters.
func (srdcup SQLRoleDefinitionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srdcup.SQLRoleDefinitionResource != nil {
		objectMap["properties"] = srdcup.SQLRoleDefinitionResource
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLRoleDefinitionCreateUpdateParameters struct.
func (srdcup *SQLRoleDefinitionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLRoleDefinitionResource SQLRoleDefinitionResource
				err = json.Unmarshal(*v, &SQLRoleDefinitionResource)
				if err != nil {
					return err
				}
				srdcup.SQLRoleDefinitionResource = &SQLRoleDefinitionResource
			}
		}
	}

	return nil
}

// SQLRoleDefinitionGetResults an Azure Cosmos DB SQL Role Definition.
type SQLRoleDefinitionGetResults struct {
	autorest.Response `json:"-"`
	// SQLRoleDefinitionResource - Properties related to the Role Definition.
	*SQLRoleDefinitionResource `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLRoleDefinitionGetResults.
func (srdgr SQLRoleDefinitionGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srdgr.SQLRoleDefinitionResource != nil {
		objectMap["properties"] = srdgr.SQLRoleDefinitionResource
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLRoleDefinitionGetResults struct.
func (srdgr *SQLRoleDefinitionGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLRoleDefinitionResource SQLRoleDefinitionResource
				err = json.Unmarshal(*v, &SQLRoleDefinitionResource)
				if err != nil {
					return err
				}
				srdgr.SQLRoleDefinitionResource = &SQLRoleDefinitionResource
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srdgr.Type = &typeVar
			}
		}
	}

	return nil
}

// SQLRoleDefinitionListResult the relevant Role Definitions.
type SQLRoleDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Role Definitions and their properties.
	Value *[]SQLRoleDefinitionGetResults `json:"value,omitempty"`
}

// SQLRoleDefinitionResource azure Cosmos DB SQL Role Definition resource object.
type SQLRoleDefinitionResource struct {
	// RoleName - A user-friendly name for the Role Definition. Must be unique for the database account.
	RoleName *string `json:"roleName,omitempty"`
	// Type - Indicates whether the Role Definition was built-in or user created. Possible values include: 'BuiltInRole', 'CustomRole'
	Type RoleDefinitionType `json:"type,omitempty"`
	// AssignableScopes - A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
	AssignableScopes *[]string `json:"assignableScopes,omitempty"`
	// Permissions - The set of operations allowed through this Role Definition.
	Permissions *[]Permission `json:"permissions,omitempty"`
}

// SQLStoredProcedureCreateUpdateParameters parameters to create and update Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateParameters struct {
	// SQLStoredProcedureCreateUpdateProperties - Properties to create and update Azure Cosmos DB storedProcedure.
	*SQLStoredProcedureCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureCreateUpdateParameters.
func (sspcup SQLStoredProcedureCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspcup.SQLStoredProcedureCreateUpdateProperties != nil {
		objectMap["properties"] = sspcup.SQLStoredProcedureCreateUpdateProperties
	}
	if sspcup.Location != nil {
		objectMap["location"] = sspcup.Location
	}
	if sspcup.Tags != nil {
		objectMap["tags"] = sspcup.Tags
	}
	if sspcup.Identity != nil {
		objectMap["identity"] = sspcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLStoredProcedureCreateUpdateParameters struct.
func (sspcup *SQLStoredProcedureCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLStoredProcedureCreateUpdateProperties SQLStoredProcedureCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLStoredProcedureCreateUpdateProperties)
				if err != nil {
					return err
				}
				sspcup.SQLStoredProcedureCreateUpdateProperties = &SQLStoredProcedureCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sspcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sspcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sspcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sspcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sspcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sspcup.Identity = &identity
			}
		}
	}

	return nil
}

// SQLStoredProcedureCreateUpdateProperties properties to create and update Azure Cosmos DB
// storedProcedure.
type SQLStoredProcedureCreateUpdateProperties struct {
	// Resource - The standard JSON format of a storedProcedure
	Resource *SQLStoredProcedureResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLStoredProcedureGetProperties the properties of an Azure Cosmos DB StoredProcedure
type SQLStoredProcedureGetProperties struct {
	Resource *SQLStoredProcedureGetPropertiesResource `json:"resource,omitempty"`
}

// SQLStoredProcedureGetPropertiesResource ...
type SQLStoredProcedureGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`
	// Body - Body of the Stored Procedure
	Body *string `json:"body,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureGetPropertiesResource.
func (sspgp SQLStoredProcedureGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspgp.ID != nil {
		objectMap["id"] = sspgp.ID
	}
	if sspgp.Body != nil {
		objectMap["body"] = sspgp.Body
	}
	return json.Marshal(objectMap)
}

// SQLStoredProcedureGetResults an Azure Cosmos DB storedProcedure.
type SQLStoredProcedureGetResults struct {
	autorest.Response `json:"-"`
	// SQLStoredProcedureGetProperties - The properties of an Azure Cosmos DB storedProcedure
	*SQLStoredProcedureGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureGetResults.
func (sspgr SQLStoredProcedureGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspgr.SQLStoredProcedureGetProperties != nil {
		objectMap["properties"] = sspgr.SQLStoredProcedureGetProperties
	}
	if sspgr.Location != nil {
		objectMap["location"] = sspgr.Location
	}
	if sspgr.Tags != nil {
		objectMap["tags"] = sspgr.Tags
	}
	if sspgr.Identity != nil {
		objectMap["identity"] = sspgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLStoredProcedureGetResults struct.
func (sspgr *SQLStoredProcedureGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLStoredProcedureGetProperties SQLStoredProcedureGetProperties
				err = json.Unmarshal(*v, &SQLStoredProcedureGetProperties)
				if err != nil {
					return err
				}
				sspgr.SQLStoredProcedureGetProperties = &SQLStoredProcedureGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sspgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sspgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sspgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sspgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sspgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sspgr.Identity = &identity
			}
		}
	}

	return nil
}

// SQLStoredProcedureListResult the List operation response, that contains the storedProcedures and their
// properties.
type SQLStoredProcedureListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of storedProcedures and their properties.
	Value *[]SQLStoredProcedureGetResults `json:"value,omitempty"`
}

// SQLStoredProcedureResource cosmos DB SQL storedProcedure resource object
type SQLStoredProcedureResource struct {
	// ID - Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`
	// Body - Body of the Stored Procedure
	Body *string `json:"body,omitempty"`
}

// SQLTriggerCreateUpdateParameters parameters to create and update Cosmos DB trigger.
type SQLTriggerCreateUpdateParameters struct {
	// SQLTriggerCreateUpdateProperties - Properties to create and update Azure Cosmos DB trigger.
	*SQLTriggerCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLTriggerCreateUpdateParameters.
func (stcup SQLTriggerCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stcup.SQLTriggerCreateUpdateProperties != nil {
		objectMap["properties"] = stcup.SQLTriggerCreateUpdateProperties
	}
	if stcup.Location != nil {
		objectMap["location"] = stcup.Location
	}
	if stcup.Tags != nil {
		objectMap["tags"] = stcup.Tags
	}
	if stcup.Identity != nil {
		objectMap["identity"] = stcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLTriggerCreateUpdateParameters struct.
func (stcup *SQLTriggerCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLTriggerCreateUpdateProperties SQLTriggerCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLTriggerCreateUpdateProperties)
				if err != nil {
					return err
				}
				stcup.SQLTriggerCreateUpdateProperties = &SQLTriggerCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				stcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				stcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				stcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				stcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				stcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				stcup.Identity = &identity
			}
		}
	}

	return nil
}

// SQLTriggerCreateUpdateProperties properties to create and update Azure Cosmos DB trigger.
type SQLTriggerCreateUpdateProperties struct {
	// Resource - The standard JSON format of a trigger
	Resource *SQLTriggerResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLTriggerGetProperties the properties of an Azure Cosmos DB trigger
type SQLTriggerGetProperties struct {
	Resource *SQLTriggerGetPropertiesResource `json:"resource,omitempty"`
}

// SQLTriggerGetPropertiesResource ...
type SQLTriggerGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`
	// Body - Body of the Trigger
	Body *string `json:"body,omitempty"`
	// TriggerType - Type of the Trigger. Possible values include: 'Pre', 'Post'
	TriggerType TriggerType `json:"triggerType,omitempty"`
	// TriggerOperation - The operation the trigger is associated with. Possible values include: 'TriggerOperationAll', 'TriggerOperationCreate', 'TriggerOperationUpdate', 'TriggerOperationDelete', 'TriggerOperationReplace'
	TriggerOperation TriggerOperation `json:"triggerOperation,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLTriggerGetPropertiesResource.
func (stgp SQLTriggerGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stgp.ID != nil {
		objectMap["id"] = stgp.ID
	}
	if stgp.Body != nil {
		objectMap["body"] = stgp.Body
	}
	if stgp.TriggerType != "" {
		objectMap["triggerType"] = stgp.TriggerType
	}
	if stgp.TriggerOperation != "" {
		objectMap["triggerOperation"] = stgp.TriggerOperation
	}
	return json.Marshal(objectMap)
}

// SQLTriggerGetResults an Azure Cosmos DB trigger.
type SQLTriggerGetResults struct {
	autorest.Response `json:"-"`
	// SQLTriggerGetProperties - The properties of an Azure Cosmos DB trigger
	*SQLTriggerGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLTriggerGetResults.
func (stgr SQLTriggerGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stgr.SQLTriggerGetProperties != nil {
		objectMap["properties"] = stgr.SQLTriggerGetProperties
	}
	if stgr.Location != nil {
		objectMap["location"] = stgr.Location
	}
	if stgr.Tags != nil {
		objectMap["tags"] = stgr.Tags
	}
	if stgr.Identity != nil {
		objectMap["identity"] = stgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLTriggerGetResults struct.
func (stgr *SQLTriggerGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLTriggerGetProperties SQLTriggerGetProperties
				err = json.Unmarshal(*v, &SQLTriggerGetProperties)
				if err != nil {
					return err
				}
				stgr.SQLTriggerGetProperties = &SQLTriggerGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				stgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				stgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				stgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				stgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				stgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				stgr.Identity = &identity
			}
		}
	}

	return nil
}

// SQLTriggerListResult the List operation response, that contains the triggers and their properties.
type SQLTriggerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of triggers and their properties.
	Value *[]SQLTriggerGetResults `json:"value,omitempty"`
}

// SQLTriggerResource cosmos DB SQL trigger resource object
type SQLTriggerResource struct {
	// ID - Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`
	// Body - Body of the Trigger
	Body *string `json:"body,omitempty"`
	// TriggerType - Type of the Trigger. Possible values include: 'Pre', 'Post'
	TriggerType TriggerType `json:"triggerType,omitempty"`
	// TriggerOperation - The operation the trigger is associated with. Possible values include: 'TriggerOperationAll', 'TriggerOperationCreate', 'TriggerOperationUpdate', 'TriggerOperationDelete', 'TriggerOperationReplace'
	TriggerOperation TriggerOperation `json:"triggerOperation,omitempty"`
}

// SQLUserDefinedFunctionCreateUpdateParameters parameters to create and update Cosmos DB
// userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateParameters struct {
	// SQLUserDefinedFunctionCreateUpdateProperties - Properties to create and update Azure Cosmos DB userDefinedFunction.
	*SQLUserDefinedFunctionCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionCreateUpdateParameters.
func (sudfcup SQLUserDefinedFunctionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfcup.SQLUserDefinedFunctionCreateUpdateProperties != nil {
		objectMap["properties"] = sudfcup.SQLUserDefinedFunctionCreateUpdateProperties
	}
	if sudfcup.Location != nil {
		objectMap["location"] = sudfcup.Location
	}
	if sudfcup.Tags != nil {
		objectMap["tags"] = sudfcup.Tags
	}
	if sudfcup.Identity != nil {
		objectMap["identity"] = sudfcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLUserDefinedFunctionCreateUpdateParameters struct.
func (sudfcup *SQLUserDefinedFunctionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLUserDefinedFunctionCreateUpdateProperties SQLUserDefinedFunctionCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLUserDefinedFunctionCreateUpdateProperties)
				if err != nil {
					return err
				}
				sudfcup.SQLUserDefinedFunctionCreateUpdateProperties = &SQLUserDefinedFunctionCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sudfcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sudfcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sudfcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sudfcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sudfcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sudfcup.Identity = &identity
			}
		}
	}

	return nil
}

// SQLUserDefinedFunctionCreateUpdateProperties properties to create and update Azure Cosmos DB
// userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateProperties struct {
	// Resource - The standard JSON format of a userDefinedFunction
	Resource *SQLUserDefinedFunctionResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLUserDefinedFunctionGetProperties the properties of an Azure Cosmos DB userDefinedFunction
type SQLUserDefinedFunctionGetProperties struct {
	Resource *SQLUserDefinedFunctionGetPropertiesResource `json:"resource,omitempty"`
}

// SQLUserDefinedFunctionGetPropertiesResource ...
type SQLUserDefinedFunctionGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`
	// Body - Body of the User Defined Function
	Body *string `json:"body,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionGetPropertiesResource.
func (sudfgp SQLUserDefinedFunctionGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfgp.ID != nil {
		objectMap["id"] = sudfgp.ID
	}
	if sudfgp.Body != nil {
		objectMap["body"] = sudfgp.Body
	}
	return json.Marshal(objectMap)
}

// SQLUserDefinedFunctionGetResults an Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionGetResults struct {
	autorest.Response `json:"-"`
	// SQLUserDefinedFunctionGetProperties - The properties of an Azure Cosmos DB userDefinedFunction
	*SQLUserDefinedFunctionGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionGetResults.
func (sudfgr SQLUserDefinedFunctionGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfgr.SQLUserDefinedFunctionGetProperties != nil {
		objectMap["properties"] = sudfgr.SQLUserDefinedFunctionGetProperties
	}
	if sudfgr.Location != nil {
		objectMap["location"] = sudfgr.Location
	}
	if sudfgr.Tags != nil {
		objectMap["tags"] = sudfgr.Tags
	}
	if sudfgr.Identity != nil {
		objectMap["identity"] = sudfgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLUserDefinedFunctionGetResults struct.
func (sudfgr *SQLUserDefinedFunctionGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLUserDefinedFunctionGetProperties SQLUserDefinedFunctionGetProperties
				err = json.Unmarshal(*v, &SQLUserDefinedFunctionGetProperties)
				if err != nil {
					return err
				}
				sudfgr.SQLUserDefinedFunctionGetProperties = &SQLUserDefinedFunctionGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sudfgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sudfgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sudfgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sudfgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sudfgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sudfgr.Identity = &identity
			}
		}
	}

	return nil
}

// SQLUserDefinedFunctionListResult the List operation response, that contains the userDefinedFunctions and
// their properties.
type SQLUserDefinedFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of userDefinedFunctions and their properties.
	Value *[]SQLUserDefinedFunctionGetResults `json:"value,omitempty"`
}

// SQLUserDefinedFunctionResource cosmos DB SQL userDefinedFunction resource object
type SQLUserDefinedFunctionResource struct {
	// ID - Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`
	// Body - Body of the User Defined Function
	Body *string `json:"body,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The type of identity that last modified the resource.
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TableCreateUpdateParameters parameters to create and update Cosmos DB Table.
type TableCreateUpdateParameters struct {
	// TableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Table.
	*TableCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for TableCreateUpdateParameters.
func (tcup TableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.TableCreateUpdateProperties != nil {
		objectMap["properties"] = tcup.TableCreateUpdateProperties
	}
	if tcup.Location != nil {
		objectMap["location"] = tcup.Location
	}
	if tcup.Tags != nil {
		objectMap["tags"] = tcup.Tags
	}
	if tcup.Identity != nil {
		objectMap["identity"] = tcup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableCreateUpdateParameters struct.
func (tcup *TableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableCreateUpdateProperties TableCreateUpdateProperties
				err = json.Unmarshal(*v, &tableCreateUpdateProperties)
				if err != nil {
					return err
				}
				tcup.TableCreateUpdateProperties = &tableCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tcup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tcup.Identity = &identity
			}
		}
	}

	return nil
}

// TableCreateUpdateProperties properties to create and update Azure Cosmos DB Table.
type TableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Table
	Resource *TableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// TableGetProperties the properties of an Azure Cosmos Table
type TableGetProperties struct {
	Resource *TableGetPropertiesResource `json:"resource,omitempty"`
	Options  *TableGetPropertiesOptions  `json:"options,omitempty"`
}

// TableGetPropertiesOptions ...
type TableGetPropertiesOptions struct {
	// Throughput - Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`
}

// TableGetPropertiesResource ...
type TableGetPropertiesResource struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for TableGetPropertiesResource.
func (tgp TableGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tgp.ID != nil {
		objectMap["id"] = tgp.ID
	}
	return json.Marshal(objectMap)
}

// TableGetResults an Azure Cosmos DB Table.
type TableGetResults struct {
	autorest.Response `json:"-"`
	// TableGetProperties - The properties of an Azure Cosmos DB Table
	*TableGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for TableGetResults.
func (tgr TableGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tgr.TableGetProperties != nil {
		objectMap["properties"] = tgr.TableGetProperties
	}
	if tgr.Location != nil {
		objectMap["location"] = tgr.Location
	}
	if tgr.Tags != nil {
		objectMap["tags"] = tgr.Tags
	}
	if tgr.Identity != nil {
		objectMap["identity"] = tgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableGetResults struct.
func (tgr *TableGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableGetProperties TableGetProperties
				err = json.Unmarshal(*v, &tableGetProperties)
				if err != nil {
					return err
				}
				tgr.TableGetProperties = &tableGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tgr.Identity = &identity
			}
		}
	}

	return nil
}

// TableListResult the List operation response, that contains the Table and their properties.
type TableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Table and their properties.
	Value *[]TableGetResults `json:"value,omitempty"`
}

// TableResource cosmos DB table resource object
type TableResource struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
}

// TableResourcesCreateUpdateTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesCreateUpdateTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (TableGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesCreateUpdateTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesCreateUpdateTableFuture.Result.
func (future *TableResourcesCreateUpdateTableFuture) result(client TableResourcesClient) (tgr TableGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesCreateUpdateTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesCreateUpdateTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tgr.Response.Response, err = future.GetResult(sender); err == nil && tgr.Response.Response.StatusCode != http.StatusNoContent {
		tgr, err = client.CreateUpdateTableResponder(tgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.TableResourcesCreateUpdateTableFuture", "Result", tgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TableResourcesDeleteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesDeleteTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesDeleteTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesDeleteTableFuture.Result.
func (future *TableResourcesDeleteTableFuture) result(client TableResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesDeleteTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesDeleteTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TableResourcesUpdateTableThroughputFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesUpdateTableThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesUpdateTableThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesUpdateTableThroughputFuture.Result.
func (future *TableResourcesUpdateTableThroughputFuture) result(client TableResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesUpdateTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tsgr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesUpdateTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateTableThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.TableResourcesUpdateTableThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ThroughputPolicyResource cosmos DB resource throughput policy
type ThroughputPolicyResource struct {
	// IsEnabled - Determines whether the ThroughputPolicy is active or not
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// IncrementPercent - Represents the percentage by which throughput can increase every time throughput policy kicks in.
	IncrementPercent *int32 `json:"incrementPercent,omitempty"`
}

// ThroughputSettingsGetProperties the properties of an Azure Cosmos DB resource throughput
type ThroughputSettingsGetProperties struct {
	Resource *ThroughputSettingsGetPropertiesResource `json:"resource,omitempty"`
}

// ThroughputSettingsGetPropertiesResource ...
type ThroughputSettingsGetPropertiesResource struct {
	// Throughput - Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource `json:"autoscaleSettings,omitempty"`
	// MinimumThroughput - READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty"`
	// OfferReplacePending - READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsGetPropertiesResource.
func (tsgp ThroughputSettingsGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsgp.Throughput != nil {
		objectMap["throughput"] = tsgp.Throughput
	}
	if tsgp.AutoscaleSettings != nil {
		objectMap["autoscaleSettings"] = tsgp.AutoscaleSettings
	}
	return json.Marshal(objectMap)
}

// ThroughputSettingsGetResults an Azure Cosmos DB resource throughput.
type ThroughputSettingsGetResults struct {
	autorest.Response `json:"-"`
	// ThroughputSettingsGetProperties - The properties of an Azure Cosmos DB resource throughput
	*ThroughputSettingsGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsGetResults.
func (tsgr ThroughputSettingsGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsgr.ThroughputSettingsGetProperties != nil {
		objectMap["properties"] = tsgr.ThroughputSettingsGetProperties
	}
	if tsgr.Location != nil {
		objectMap["location"] = tsgr.Location
	}
	if tsgr.Tags != nil {
		objectMap["tags"] = tsgr.Tags
	}
	if tsgr.Identity != nil {
		objectMap["identity"] = tsgr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThroughputSettingsGetResults struct.
func (tsgr *ThroughputSettingsGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputSettingsGetProperties ThroughputSettingsGetProperties
				err = json.Unmarshal(*v, &throughputSettingsGetProperties)
				if err != nil {
					return err
				}
				tsgr.ThroughputSettingsGetProperties = &throughputSettingsGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tsgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tsgr.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tsgr.Identity = &identity
			}
		}
	}

	return nil
}

// ThroughputSettingsResource cosmos DB resource throughput object. Either throughput is required or
// autoscaleSettings is required, but not both.
type ThroughputSettingsResource struct {
	// Throughput - Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32 `json:"throughput,omitempty"`
	// AutoscaleSettings - Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource `json:"autoscaleSettings,omitempty"`
	// MinimumThroughput - READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty"`
	// OfferReplacePending - READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsResource.
func (tsr ThroughputSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsr.Throughput != nil {
		objectMap["throughput"] = tsr.Throughput
	}
	if tsr.AutoscaleSettings != nil {
		objectMap["autoscaleSettings"] = tsr.AutoscaleSettings
	}
	return json.Marshal(objectMap)
}

// ThroughputSettingsUpdateParameters parameters to update Cosmos DB resource throughput.
type ThroughputSettingsUpdateParameters struct {
	// ThroughputSettingsUpdateProperties - Properties to update Azure Cosmos DB resource throughput.
	*ThroughputSettingsUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string                 `json:"location,omitempty"`
	Tags     map[string]*string      `json:"tags"`
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsUpdateParameters.
func (tsup ThroughputSettingsUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsup.ThroughputSettingsUpdateProperties != nil {
		objectMap["properties"] = tsup.ThroughputSettingsUpdateProperties
	}
	if tsup.Location != nil {
		objectMap["location"] = tsup.Location
	}
	if tsup.Tags != nil {
		objectMap["tags"] = tsup.Tags
	}
	if tsup.Identity != nil {
		objectMap["identity"] = tsup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThroughputSettingsUpdateParameters struct.
func (tsup *ThroughputSettingsUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputSettingsUpdateProperties ThroughputSettingsUpdateProperties
				err = json.Unmarshal(*v, &throughputSettingsUpdateProperties)
				if err != nil {
					return err
				}
				tsup.ThroughputSettingsUpdateProperties = &throughputSettingsUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tsup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tsup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tsup.Identity = &identity
			}
		}
	}

	return nil
}

// ThroughputSettingsUpdateProperties properties to update Azure Cosmos DB resource throughput.
type ThroughputSettingsUpdateProperties struct {
	// Resource - The standard JSON format of a resource throughput
	Resource *ThroughputSettingsResource `json:"resource,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UniqueKey the unique key on that enforces uniqueness constraint on documents in the collection in the
// Azure Cosmos DB service.
type UniqueKey struct {
	// Paths - List of paths must be unique for each document in the Azure Cosmos DB service
	Paths *[]string `json:"paths,omitempty"`
}

// UniqueKeyPolicy the unique key policy configuration for specifying uniqueness constraints on documents
// in the collection in the Azure Cosmos DB service.
type UniqueKeyPolicy struct {
	// UniqueKeys - List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
	UniqueKeys *[]UniqueKey `json:"uniqueKeys,omitempty"`
}

// Usage the usage data for a usage request.
type Usage struct {
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Unit != "" {
		objectMap["unit"] = u.Unit
	}
	return json.Marshal(objectMap)
}

// UsagesResult the response to a list usage request.
type UsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usages for the database. A usage is a point in time metric
	Value *[]Usage `json:"value,omitempty"`
}

// VirtualNetworkRule virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// ID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string `json:"id,omitempty"`
	// IgnoreMissingVNetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVNetServiceEndpoint *bool `json:"ignoreMissingVNetServiceEndpoint,omitempty"`
}
