package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveNumberFromSkillGroup invokes the ccc.RemoveNumberFromSkillGroup API synchronously
// api document: https://help.aliyun.com/api/ccc/removenumberfromskillgroup.html
func (client *Client) RemoveNumberFromSkillGroup(request *RemoveNumberFromSkillGroupRequest) (response *RemoveNumberFromSkillGroupResponse, err error) {
	response = CreateRemoveNumberFromSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveNumberFromSkillGroupWithChan invokes the ccc.RemoveNumberFromSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/removenumberfromskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveNumberFromSkillGroupWithChan(request *RemoveNumberFromSkillGroupRequest) (<-chan *RemoveNumberFromSkillGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveNumberFromSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveNumberFromSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveNumberFromSkillGroupWithCallback invokes the ccc.RemoveNumberFromSkillGroup API asynchronously
// api document: https://help.aliyun.com/api/ccc/removenumberfromskillgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveNumberFromSkillGroupWithCallback(request *RemoveNumberFromSkillGroupRequest, callback func(response *RemoveNumberFromSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveNumberFromSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveNumberFromSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveNumberFromSkillGroupRequest is the request struct for api RemoveNumberFromSkillGroup
type RemoveNumberFromSkillGroupRequest struct {
	*requests.RpcRequest
	Number       string `position:"Query" name:"Number"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
}

// RemoveNumberFromSkillGroupResponse is the response struct for api RemoveNumberFromSkillGroup
type RemoveNumberFromSkillGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveNumberFromSkillGroupRequest creates a request to invoke RemoveNumberFromSkillGroup API
func CreateRemoveNumberFromSkillGroupRequest() (request *RemoveNumberFromSkillGroupRequest) {
	request = &RemoveNumberFromSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "RemoveNumberFromSkillGroup", "", "")
	return
}

// CreateRemoveNumberFromSkillGroupResponse creates a response to parse from RemoveNumberFromSkillGroup response
func CreateRemoveNumberFromSkillGroupResponse() (response *RemoveNumberFromSkillGroupResponse) {
	response = &RemoveNumberFromSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
