package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobsProgress invokes the ccc.GetJobsProgress API synchronously
// api document: https://help.aliyun.com/api/ccc/getjobsprogress.html
func (client *Client) GetJobsProgress(request *GetJobsProgressRequest) (response *GetJobsProgressResponse, err error) {
	response = CreateGetJobsProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobsProgressWithChan invokes the ccc.GetJobsProgress API asynchronously
// api document: https://help.aliyun.com/api/ccc/getjobsprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobsProgressWithChan(request *GetJobsProgressRequest) (<-chan *GetJobsProgressResponse, <-chan error) {
	responseChan := make(chan *GetJobsProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobsProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobsProgressWithCallback invokes the ccc.GetJobsProgress API asynchronously
// api document: https://help.aliyun.com/api/ccc/getjobsprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobsProgressWithCallback(request *GetJobsProgressRequest, callback func(response *GetJobsProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobsProgressResponse
		var err error
		defer close(result)
		response, err = client.GetJobsProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobsProgressRequest is the request struct for api GetJobsProgress
type GetJobsProgressRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
	JobGroupId   string `position:"Query" name:"JobGroupId"`
}

// GetJobsProgressResponse is the response struct for api GetJobsProgress
type GetJobsProgressResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Code           string       `json:"Code" xml:"Code"`
	Message        string       `json:"Message" xml:"Message"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	JobsProgress   JobsProgress `json:"JobsProgress" xml:"JobsProgress"`
}

// CreateGetJobsProgressRequest creates a request to invoke GetJobsProgress API
func CreateGetJobsProgressRequest() (request *GetJobsProgressRequest) {
	request = &GetJobsProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetJobsProgress", "", "")
	return
}

// CreateGetJobsProgressResponse creates a response to parse from GetJobsProgress response
func CreateGetJobsProgressResponse() (response *GetJobsProgressResponse) {
	response = &GetJobsProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
