package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitMCJob invokes the mts.SubmitMCJob API synchronously
// api document: https://help.aliyun.com/api/mts/submitmcjob.html
func (client *Client) SubmitMCJob(request *SubmitMCJobRequest) (response *SubmitMCJobResponse, err error) {
	response = CreateSubmitMCJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitMCJobWithChan invokes the mts.SubmitMCJob API asynchronously
// api document: https://help.aliyun.com/api/mts/submitmcjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitMCJobWithChan(request *SubmitMCJobRequest) (<-chan *SubmitMCJobResponse, <-chan error) {
	responseChan := make(chan *SubmitMCJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitMCJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitMCJobWithCallback invokes the mts.SubmitMCJob API asynchronously
// api document: https://help.aliyun.com/api/mts/submitmcjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitMCJobWithCallback(request *SubmitMCJobRequest, callback func(response *SubmitMCJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitMCJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitMCJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitMCJobRequest is the request struct for api SubmitMCJob
type SubmitMCJobRequest struct {
	*requests.RpcRequest
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Images               string           `position:"Query" name:"Images"`
	Texts                string           `position:"Query" name:"Texts"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Video                string           `position:"Query" name:"Video"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CensorConfig         string           `position:"Query" name:"CensorConfig"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
}

// SubmitMCJobResponse is the response struct for api SubmitMCJob
type SubmitMCJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitMCJobRequest creates a request to invoke SubmitMCJob API
func CreateSubmitMCJobRequest() (request *SubmitMCJobRequest) {
	request = &SubmitMCJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitMCJob", "mts", "openAPI")
	return
}

// CreateSubmitMCJobResponse creates a response to parse from SubmitMCJob response
func CreateSubmitMCJobResponse() (response *SubmitMCJobResponse) {
	response = &SubmitMCJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
