package containerservice

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/containerservice/mgmt/2021-03-01/containerservice"

// AccessProfile profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// KubeConfig - Base64-encoded Kubernetes configuration file.
	KubeConfig *[]byte `json:"kubeConfig,omitempty"`
}

// AgentPool agent Pool.
type AgentPool struct {
	autorest.Response `json:"-"`
	// ManagedClusterAgentPoolProfileProperties - Properties of an agent pool.
	*ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPool.
func (ap AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ManagedClusterAgentPoolProfileProperties != nil {
		objectMap["properties"] = ap.ManagedClusterAgentPoolProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPool struct.
func (ap *AgentPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedClusterAgentPoolProfileProperties ManagedClusterAgentPoolProfileProperties
				err = json.Unmarshal(*v, &managedClusterAgentPoolProfileProperties)
				if err != nil {
					return err
				}
				ap.ManagedClusterAgentPoolProfileProperties = &managedClusterAgentPoolProfileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		}
	}

	return nil
}

// AgentPoolAvailableVersions the list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Id of the agent pool available versions.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the agent pool available versions.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the agent pool  available versions.
	Type *string `json:"type,omitempty"`
	// AgentPoolAvailableVersionsProperties - Properties of agent pool available versions.
	*AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolAvailableVersions.
func (apav AgentPoolAvailableVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apav.AgentPoolAvailableVersionsProperties != nil {
		objectMap["properties"] = apav.AgentPoolAvailableVersionsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPoolAvailableVersions struct.
func (apav *AgentPoolAvailableVersions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				apav.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				apav.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apav.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var agentPoolAvailableVersionsProperties AgentPoolAvailableVersionsProperties
				err = json.Unmarshal(*v, &agentPoolAvailableVersionsProperties)
				if err != nil {
					return err
				}
				apav.AgentPoolAvailableVersionsProperties = &agentPoolAvailableVersionsProperties
			}
		}
	}

	return nil
}

// AgentPoolAvailableVersionsProperties the list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// AgentPoolVersions - List of versions available for agent pool.
	AgentPoolVersions *[]AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

// AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem ...
type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Default - Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// AgentPoolListResult the response from the List Agent Pools operation.
type AgentPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of agent pools.
	Value *[]AgentPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolListResult.
func (aplr AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aplr.Value != nil {
		objectMap["value"] = aplr.Value
	}
	return json.Marshal(objectMap)
}

// AgentPoolListResultIterator provides access to a complete listing of AgentPool values.
type AgentPoolListResultIterator struct {
	i    int
	page AgentPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgentPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgentPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgentPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgentPoolListResultIterator) Response() AgentPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgentPoolListResultIterator) Value() AgentPool {
	if !iter.page.NotDone() {
		return AgentPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgentPoolListResultIterator type.
func NewAgentPoolListResultIterator(page AgentPoolListResultPage) AgentPoolListResultIterator {
	return AgentPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aplr AgentPoolListResult) IsEmpty() bool {
	return aplr.Value == nil || len(*aplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aplr AgentPoolListResult) hasNextLink() bool {
	return aplr.NextLink != nil && len(*aplr.NextLink) != 0
}

// agentPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aplr AgentPoolListResult) agentPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aplr.NextLink)))
}

// AgentPoolListResultPage contains a page of AgentPool values.
type AgentPoolListResultPage struct {
	fn   func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)
	aplr AgentPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgentPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aplr)
		if err != nil {
			return err
		}
		page.aplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgentPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgentPoolListResultPage) NotDone() bool {
	return !page.aplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgentPoolListResultPage) Response() AgentPoolListResult {
	return page.aplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgentPoolListResultPage) Values() []AgentPool {
	if page.aplr.IsEmpty() {
		return nil
	}
	return *page.aplr.Value
}

// Creates a new instance of the AgentPoolListResultPage type.
func NewAgentPoolListResultPage(cur AgentPoolListResult, getNextPage func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)) AgentPoolListResultPage {
	return AgentPoolListResultPage{
		fn:   getNextPage,
		aplr: cur,
	}
}

// AgentPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AgentPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsCreateOrUpdateFuture.Result.
func (future *AgentPoolsCreateOrUpdateFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.CreateOrUpdateResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsCreateOrUpdateFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AgentPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsDeleteFuture.Result.
func (future *AgentPoolsDeleteFuture) result(client AgentPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AgentPoolsUpgradeNodeImageVersionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AgentPoolsUpgradeNodeImageVersionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsUpgradeNodeImageVersionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsUpgradeNodeImageVersionFuture.Result.
func (future *AgentPoolsUpgradeNodeImageVersionFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsUpgradeNodeImageVersionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsUpgradeNodeImageVersionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.UpgradeNodeImageVersionResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsUpgradeNodeImageVersionFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolUpgradeProfile the list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Id of the agent pool upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty"`
	// AgentPoolUpgradeProfileProperties - Properties of agent pool upgrade profile.
	*AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolUpgradeProfile.
func (apup AgentPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apup.AgentPoolUpgradeProfileProperties != nil {
		objectMap["properties"] = apup.AgentPoolUpgradeProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPoolUpgradeProfile struct.
func (apup *AgentPoolUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				apup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				apup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var agentPoolUpgradeProfileProperties AgentPoolUpgradeProfileProperties
				err = json.Unmarshal(*v, &agentPoolUpgradeProfileProperties)
				if err != nil {
					return err
				}
				apup.AgentPoolUpgradeProfileProperties = &agentPoolUpgradeProfileProperties
			}
		}
	}

	return nil
}

// AgentPoolUpgradeProfileProperties the list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
	// LatestNodeImageVersion - LatestNodeImageVersion is the latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`
}

// AgentPoolUpgradeProfilePropertiesUpgradesItem ...
type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// AgentPoolUpgradeSettings settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// MaxSurge - Count or percentage of additional nodes to be added during upgrade. If empty uses AKS default
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// CloudError an error response from the Container service.
type CloudError struct {
	// Error - Details about the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Container service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CommandResultProperties ...
type CommandResultProperties struct {
	// ProvisioningState - READ-ONLY; provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ExitCode - READ-ONLY; exit code of the command
	ExitCode *int32 `json:"exitCode,omitempty"`
	// StartedAt - READ-ONLY; time when the command started.
	StartedAt *date.Time `json:"startedAt,omitempty"`
	// FinishedAt - READ-ONLY; time when the command finished.
	FinishedAt *date.Time `json:"finishedAt,omitempty"`
	// Logs - READ-ONLY; command output.
	Logs *string `json:"logs,omitempty"`
	// Reason - READ-ONLY; explain why provisioningState is set to failed (if so).
	Reason *string `json:"reason,omitempty"`
}

// CredentialResult the credential result response.
type CredentialResult struct {
	// Name - READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value *[]byte `json:"value,omitempty"`
}

// CredentialResults the list of credential result response.
type CredentialResults struct {
	autorest.Response `json:"-"`
	// Kubeconfigs - READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs *[]CredentialResult `json:"kubeconfigs,omitempty"`
}

// DiagnosticsProfile profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// VMDiagnostics - Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// ExtendedLocation the complex type of the extended location.
type ExtendedLocation struct {
	// Name - The name of the extended location.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extended location. Possible values include: 'EdgeZone'
	Type ExtendedLocationTypes `json:"type,omitempty"`
}

// KubeletConfig kubelet configurations of agent nodes.
type KubeletConfig struct {
	// CPUManagerPolicy - CPU Manager policy to use.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`
	// CPUCfsQuota - Enable CPU CFS quota enforcement for containers that specify CPU limits.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`
	// CPUCfsQuotaPeriod - Sets CPU CFS quota period value.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`
	// ImageGcHighThreshold - The percent of disk usage after which image garbage collection is always run.
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`
	// ImageGcLowThreshold - The percent of disk usage before which image garbage collection is never run.
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`
	// TopologyManagerPolicy - Topology Manager policy to use.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
	// AllowedUnsafeSysctls - Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
	AllowedUnsafeSysctls *[]string `json:"allowedUnsafeSysctls,omitempty"`
	// FailSwapOn - If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`
	// ContainerLogMaxSizeMB - The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32 `json:"containerLogMaxSizeMB,omitempty"`
	// ContainerLogMaxFiles - The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32 `json:"containerLogMaxFiles,omitempty"`
	// PodMaxPids - The maximum number of processes per pod.
	PodMaxPids *int32 `json:"podMaxPids,omitempty"`
}

// LinuxOSConfig OS configurations of Linux agent nodes.
type LinuxOSConfig struct {
	// Sysctls - Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`
	// TransparentHugePageEnabled - Transparent Huge Page enabled configuration.
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
	// TransparentHugePageDefrag - Transparent Huge Page defrag configuration.
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`
	// SwapFileSizeMB - SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`
}

// LinuxProfile profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// AdminUsername - The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// SSH - SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// MaintenanceConfiguration maintenance configuration.
type MaintenanceConfiguration struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// MaintenanceConfigurationProperties - Properties of a default maintenance configuration.
	*MaintenanceConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceConfiguration.
func (mc MaintenanceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.MaintenanceConfigurationProperties != nil {
		objectMap["properties"] = mc.MaintenanceConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MaintenanceConfiguration struct.
func (mc *MaintenanceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mc.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var maintenanceConfigurationProperties MaintenanceConfigurationProperties
				err = json.Unmarshal(*v, &maintenanceConfigurationProperties)
				if err != nil {
					return err
				}
				mc.MaintenanceConfigurationProperties = &maintenanceConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mc.Type = &typeVar
			}
		}
	}

	return nil
}

// MaintenanceConfigurationListResult the response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of maintenance configurations.
	Value *[]MaintenanceConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceConfigurationListResult.
func (mclr MaintenanceConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mclr.Value != nil {
		objectMap["value"] = mclr.Value
	}
	return json.Marshal(objectMap)
}

// MaintenanceConfigurationListResultIterator provides access to a complete listing of
// MaintenanceConfiguration values.
type MaintenanceConfigurationListResultIterator struct {
	i    int
	page MaintenanceConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MaintenanceConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MaintenanceConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MaintenanceConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MaintenanceConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MaintenanceConfigurationListResultIterator) Response() MaintenanceConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MaintenanceConfigurationListResultIterator) Value() MaintenanceConfiguration {
	if !iter.page.NotDone() {
		return MaintenanceConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MaintenanceConfigurationListResultIterator type.
func NewMaintenanceConfigurationListResultIterator(page MaintenanceConfigurationListResultPage) MaintenanceConfigurationListResultIterator {
	return MaintenanceConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr MaintenanceConfigurationListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mclr MaintenanceConfigurationListResult) hasNextLink() bool {
	return mclr.NextLink != nil && len(*mclr.NextLink) != 0
}

// maintenanceConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr MaintenanceConfigurationListResult) maintenanceConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// MaintenanceConfigurationListResultPage contains a page of MaintenanceConfiguration values.
type MaintenanceConfigurationListResultPage struct {
	fn   func(context.Context, MaintenanceConfigurationListResult) (MaintenanceConfigurationListResult, error)
	mclr MaintenanceConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MaintenanceConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MaintenanceConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mclr)
		if err != nil {
			return err
		}
		page.mclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MaintenanceConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MaintenanceConfigurationListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MaintenanceConfigurationListResultPage) Response() MaintenanceConfigurationListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MaintenanceConfigurationListResultPage) Values() []MaintenanceConfiguration {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the MaintenanceConfigurationListResultPage type.
func NewMaintenanceConfigurationListResultPage(cur MaintenanceConfigurationListResult, getNextPage func(context.Context, MaintenanceConfigurationListResult) (MaintenanceConfigurationListResult, error)) MaintenanceConfigurationListResultPage {
	return MaintenanceConfigurationListResultPage{
		fn:   getNextPage,
		mclr: cur,
	}
}

// MaintenanceConfigurationProperties default maintenance configuration properties.
type MaintenanceConfigurationProperties struct {
	// TimeInWeek - Weekday time slots allowed to upgrade.
	TimeInWeek *[]TimeInWeek `json:"timeInWeek,omitempty"`
	// NotAllowedTime - Time slots on which upgrade is not allowed.
	NotAllowedTime *[]TimeSpan `json:"notAllowedTime,omitempty"`
}

// ManagedCluster managed cluster.
type ManagedCluster struct {
	autorest.Response `json:"-"`
	// ManagedClusterProperties - Properties of a managed cluster.
	*ManagedClusterProperties `json:"properties,omitempty"`
	// Identity - The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`
	// Sku - The managed cluster SKU.
	Sku *ManagedClusterSKU `json:"sku,omitempty"`
	// ExtendedLocation - The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedCluster.
func (mc ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.ManagedClusterProperties != nil {
		objectMap["properties"] = mc.ManagedClusterProperties
	}
	if mc.Identity != nil {
		objectMap["identity"] = mc.Identity
	}
	if mc.Sku != nil {
		objectMap["sku"] = mc.Sku
	}
	if mc.ExtendedLocation != nil {
		objectMap["extendedLocation"] = mc.ExtendedLocation
	}
	if mc.Location != nil {
		objectMap["location"] = mc.Location
	}
	if mc.Tags != nil {
		objectMap["tags"] = mc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedCluster struct.
func (mc *ManagedCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedClusterProperties ManagedClusterProperties
				err = json.Unmarshal(*v, &managedClusterProperties)
				if err != nil {
					return err
				}
				mc.ManagedClusterProperties = &managedClusterProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedClusterIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mc.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ManagedClusterSKU
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mc.Sku = &sku
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				mc.ExtendedLocation = &extendedLocation
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mc.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAADProfile aADProfile specifies attributes for Azure Active Directory integration.
type ManagedClusterAADProfile struct {
	// Managed - Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`
	// EnableAzureRBAC - Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`
	// AdminGroupObjectIDs - AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs *[]string `json:"adminGroupObjectIDs,omitempty"`
	// ClientAppID - The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`
	// ServerAppID - The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`
	// ServerAppSecret - The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`
	// TenantID - The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAccessProfile managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	autorest.Response `json:"-"`
	// AccessProfile - AccessProfile of a managed cluster.
	*AccessProfile `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAccessProfile.
func (mcap ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.AccessProfile != nil {
		objectMap["properties"] = mcap.AccessProfile
	}
	if mcap.Location != nil {
		objectMap["location"] = mcap.Location
	}
	if mcap.Tags != nil {
		objectMap["tags"] = mcap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterAccessProfile struct.
func (mcap *ManagedClusterAccessProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessProfile AccessProfile
				err = json.Unmarshal(*v, &accessProfile)
				if err != nil {
					return err
				}
				mcap.AccessProfile = &accessProfile
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mcap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcap.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAddonProfile a Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// Enabled - Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Config - Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config"`
	// Identity - READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAddonProfile.
func (mcap ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.Enabled != nil {
		objectMap["enabled"] = mcap.Enabled
	}
	if mcap.Config != nil {
		objectMap["config"] = mcap.Config
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAddonProfileIdentity information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// ResourceID - The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
	// ClientID - The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`
}

// ManagedClusterAgentPoolProfile profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// Name - Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for system pools. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs.
	VMSize *string `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// OsDiskType - OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. Possible values include: 'Managed', 'Ephemeral'
	OsDiskType OSDiskType `json:"osDiskType,omitempty"`
	// KubeletDiskType - KubeletDiskType determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS, resulting in Kubelet using the OS disk for data. Possible values include: 'OS', 'Temporary'
	KubeletDiskType KubeletDiskType `json:"kubeletDiskType,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// PodSubnetID - Pod SubnetID specifies the VNet's subnet identifier for pods.
	PodSubnetID *string `json:"podSubnetID,omitempty"`
	// MaxPods - Maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// OsSKU - OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner for Linux OSType. Not applicable to Windows OSType. Possible values include: 'Ubuntu', 'CBLMariner'
	OsSKU OSSKU `json:"osSKU,omitempty"`
	// MaxCount - Maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`
	// MinCount - Minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`
	// EnableAutoScaling - Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`
	// Type - AgentPoolType represents types of an agent pool. Possible values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
	Type AgentPoolType `json:"type,omitempty"`
	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'User'
	Mode AgentPoolMode `json:"mode,omitempty"`
	// OrchestratorVersion - Version of orchestrator specified when creating the managed cluster.
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
	// NodeImageVersion - READ-ONLY; Version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`
	// UpgradeSettings - Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - READ-ONLY; Describes whether the Agent Pool is Running or Stopped
	PowerState *PowerState `json:"powerState,omitempty"`
	// AvailabilityZones - Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// EnableNodePublicIP - Enable public IP for nodes
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`
	// NodePublicIPPrefixID - Public IP Prefix ID. VM nodes use IPs assigned from this Public IP Prefix.
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`
	// ScaleSetPriority - ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular. Possible values include: 'Spot', 'Regular'
	ScaleSetPriority ScaleSetPriority `json:"scaleSetPriority,omitempty"`
	// ScaleSetEvictionPolicy - ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete. Possible values include: 'Delete', 'Deallocate'
	ScaleSetEvictionPolicy ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`
	// SpotMaxPrice - SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
	SpotMaxPrice *float64 `json:"spotMaxPrice,omitempty"`
	// Tags - Agent pool tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags"`
	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels"`
	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints *[]string `json:"nodeTaints,omitempty"`
	// ProximityPlacementGroupID - The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`
	// KubeletConfig - KubeletConfig specifies the configuration of kubelet on agent nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`
	// LinuxOSConfig - LinuxOSConfig specifies the OS configuration of linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`
	// EnableEncryptionAtHost - Whether to enable EncryptionAtHost
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`
	// EnableFIPS - Whether to use FIPS enabled OS
	EnableFIPS *bool `json:"enableFIPS,omitempty"`
	// GpuInstanceProfile - GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g. Possible values include: 'MIG1g', 'MIG2g', 'MIG3g', 'MIG4g', 'MIG7g'
	GpuInstanceProfile GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAgentPoolProfile.
func (mcapp ManagedClusterAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcapp.Name != nil {
		objectMap["name"] = mcapp.Name
	}
	if mcapp.Count != nil {
		objectMap["count"] = mcapp.Count
	}
	if mcapp.VMSize != nil {
		objectMap["vmSize"] = mcapp.VMSize
	}
	if mcapp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mcapp.OsDiskSizeGB
	}
	if mcapp.OsDiskType != "" {
		objectMap["osDiskType"] = mcapp.OsDiskType
	}
	if mcapp.KubeletDiskType != "" {
		objectMap["kubeletDiskType"] = mcapp.KubeletDiskType
	}
	if mcapp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mcapp.VnetSubnetID
	}
	if mcapp.PodSubnetID != nil {
		objectMap["podSubnetID"] = mcapp.PodSubnetID
	}
	if mcapp.MaxPods != nil {
		objectMap["maxPods"] = mcapp.MaxPods
	}
	if mcapp.OsType != "" {
		objectMap["osType"] = mcapp.OsType
	}
	if mcapp.OsSKU != "" {
		objectMap["osSKU"] = mcapp.OsSKU
	}
	if mcapp.MaxCount != nil {
		objectMap["maxCount"] = mcapp.MaxCount
	}
	if mcapp.MinCount != nil {
		objectMap["minCount"] = mcapp.MinCount
	}
	if mcapp.EnableAutoScaling != nil {
		objectMap["enableAutoScaling"] = mcapp.EnableAutoScaling
	}
	if mcapp.Type != "" {
		objectMap["type"] = mcapp.Type
	}
	if mcapp.Mode != "" {
		objectMap["mode"] = mcapp.Mode
	}
	if mcapp.OrchestratorVersion != nil {
		objectMap["orchestratorVersion"] = mcapp.OrchestratorVersion
	}
	if mcapp.UpgradeSettings != nil {
		objectMap["upgradeSettings"] = mcapp.UpgradeSettings
	}
	if mcapp.AvailabilityZones != nil {
		objectMap["availabilityZones"] = mcapp.AvailabilityZones
	}
	if mcapp.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIP"] = mcapp.EnableNodePublicIP
	}
	if mcapp.NodePublicIPPrefixID != nil {
		objectMap["nodePublicIPPrefixID"] = mcapp.NodePublicIPPrefixID
	}
	if mcapp.ScaleSetPriority != "" {
		objectMap["scaleSetPriority"] = mcapp.ScaleSetPriority
	}
	if mcapp.ScaleSetEvictionPolicy != "" {
		objectMap["scaleSetEvictionPolicy"] = mcapp.ScaleSetEvictionPolicy
	}
	if mcapp.SpotMaxPrice != nil {
		objectMap["spotMaxPrice"] = mcapp.SpotMaxPrice
	}
	if mcapp.Tags != nil {
		objectMap["tags"] = mcapp.Tags
	}
	if mcapp.NodeLabels != nil {
		objectMap["nodeLabels"] = mcapp.NodeLabels
	}
	if mcapp.NodeTaints != nil {
		objectMap["nodeTaints"] = mcapp.NodeTaints
	}
	if mcapp.ProximityPlacementGroupID != nil {
		objectMap["proximityPlacementGroupID"] = mcapp.ProximityPlacementGroupID
	}
	if mcapp.KubeletConfig != nil {
		objectMap["kubeletConfig"] = mcapp.KubeletConfig
	}
	if mcapp.LinuxOSConfig != nil {
		objectMap["linuxOSConfig"] = mcapp.LinuxOSConfig
	}
	if mcapp.EnableEncryptionAtHost != nil {
		objectMap["enableEncryptionAtHost"] = mcapp.EnableEncryptionAtHost
	}
	if mcapp.EnableFIPS != nil {
		objectMap["enableFIPS"] = mcapp.EnableFIPS
	}
	if mcapp.GpuInstanceProfile != "" {
		objectMap["gpuInstanceProfile"] = mcapp.GpuInstanceProfile
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAgentPoolProfileProperties properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for system pools. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs.
	VMSize *string `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// OsDiskType - OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. Possible values include: 'Managed', 'Ephemeral'
	OsDiskType OSDiskType `json:"osDiskType,omitempty"`
	// KubeletDiskType - KubeletDiskType determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS, resulting in Kubelet using the OS disk for data. Possible values include: 'OS', 'Temporary'
	KubeletDiskType KubeletDiskType `json:"kubeletDiskType,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// PodSubnetID - Pod SubnetID specifies the VNet's subnet identifier for pods.
	PodSubnetID *string `json:"podSubnetID,omitempty"`
	// MaxPods - Maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// OsSKU - OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner for Linux OSType. Not applicable to Windows OSType. Possible values include: 'Ubuntu', 'CBLMariner'
	OsSKU OSSKU `json:"osSKU,omitempty"`
	// MaxCount - Maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`
	// MinCount - Minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`
	// EnableAutoScaling - Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`
	// Type - AgentPoolType represents types of an agent pool. Possible values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
	Type AgentPoolType `json:"type,omitempty"`
	// Mode - AgentPoolMode represents mode of an agent pool. Possible values include: 'System', 'User'
	Mode AgentPoolMode `json:"mode,omitempty"`
	// OrchestratorVersion - Version of orchestrator specified when creating the managed cluster.
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
	// NodeImageVersion - READ-ONLY; Version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`
	// UpgradeSettings - Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - READ-ONLY; Describes whether the Agent Pool is Running or Stopped
	PowerState *PowerState `json:"powerState,omitempty"`
	// AvailabilityZones - Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// EnableNodePublicIP - Enable public IP for nodes
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`
	// NodePublicIPPrefixID - Public IP Prefix ID. VM nodes use IPs assigned from this Public IP Prefix.
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`
	// ScaleSetPriority - ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular. Possible values include: 'Spot', 'Regular'
	ScaleSetPriority ScaleSetPriority `json:"scaleSetPriority,omitempty"`
	// ScaleSetEvictionPolicy - ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete. Possible values include: 'Delete', 'Deallocate'
	ScaleSetEvictionPolicy ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`
	// SpotMaxPrice - SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
	SpotMaxPrice *float64 `json:"spotMaxPrice,omitempty"`
	// Tags - Agent pool tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags"`
	// NodeLabels - Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels"`
	// NodeTaints - Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints *[]string `json:"nodeTaints,omitempty"`
	// ProximityPlacementGroupID - The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`
	// KubeletConfig - KubeletConfig specifies the configuration of kubelet on agent nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`
	// LinuxOSConfig - LinuxOSConfig specifies the OS configuration of linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`
	// EnableEncryptionAtHost - Whether to enable EncryptionAtHost
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`
	// EnableFIPS - Whether to use FIPS enabled OS
	EnableFIPS *bool `json:"enableFIPS,omitempty"`
	// GpuInstanceProfile - GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g. Possible values include: 'MIG1g', 'MIG2g', 'MIG3g', 'MIG4g', 'MIG7g'
	GpuInstanceProfile GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAgentPoolProfileProperties.
func (mcappp ManagedClusterAgentPoolProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcappp.Count != nil {
		objectMap["count"] = mcappp.Count
	}
	if mcappp.VMSize != nil {
		objectMap["vmSize"] = mcappp.VMSize
	}
	if mcappp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mcappp.OsDiskSizeGB
	}
	if mcappp.OsDiskType != "" {
		objectMap["osDiskType"] = mcappp.OsDiskType
	}
	if mcappp.KubeletDiskType != "" {
		objectMap["kubeletDiskType"] = mcappp.KubeletDiskType
	}
	if mcappp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mcappp.VnetSubnetID
	}
	if mcappp.PodSubnetID != nil {
		objectMap["podSubnetID"] = mcappp.PodSubnetID
	}
	if mcappp.MaxPods != nil {
		objectMap["maxPods"] = mcappp.MaxPods
	}
	if mcappp.OsType != "" {
		objectMap["osType"] = mcappp.OsType
	}
	if mcappp.OsSKU != "" {
		objectMap["osSKU"] = mcappp.OsSKU
	}
	if mcappp.MaxCount != nil {
		objectMap["maxCount"] = mcappp.MaxCount
	}
	if mcappp.MinCount != nil {
		objectMap["minCount"] = mcappp.MinCount
	}
	if mcappp.EnableAutoScaling != nil {
		objectMap["enableAutoScaling"] = mcappp.EnableAutoScaling
	}
	if mcappp.Type != "" {
		objectMap["type"] = mcappp.Type
	}
	if mcappp.Mode != "" {
		objectMap["mode"] = mcappp.Mode
	}
	if mcappp.OrchestratorVersion != nil {
		objectMap["orchestratorVersion"] = mcappp.OrchestratorVersion
	}
	if mcappp.UpgradeSettings != nil {
		objectMap["upgradeSettings"] = mcappp.UpgradeSettings
	}
	if mcappp.AvailabilityZones != nil {
		objectMap["availabilityZones"] = mcappp.AvailabilityZones
	}
	if mcappp.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIP"] = mcappp.EnableNodePublicIP
	}
	if mcappp.NodePublicIPPrefixID != nil {
		objectMap["nodePublicIPPrefixID"] = mcappp.NodePublicIPPrefixID
	}
	if mcappp.ScaleSetPriority != "" {
		objectMap["scaleSetPriority"] = mcappp.ScaleSetPriority
	}
	if mcappp.ScaleSetEvictionPolicy != "" {
		objectMap["scaleSetEvictionPolicy"] = mcappp.ScaleSetEvictionPolicy
	}
	if mcappp.SpotMaxPrice != nil {
		objectMap["spotMaxPrice"] = mcappp.SpotMaxPrice
	}
	if mcappp.Tags != nil {
		objectMap["tags"] = mcappp.Tags
	}
	if mcappp.NodeLabels != nil {
		objectMap["nodeLabels"] = mcappp.NodeLabels
	}
	if mcappp.NodeTaints != nil {
		objectMap["nodeTaints"] = mcappp.NodeTaints
	}
	if mcappp.ProximityPlacementGroupID != nil {
		objectMap["proximityPlacementGroupID"] = mcappp.ProximityPlacementGroupID
	}
	if mcappp.KubeletConfig != nil {
		objectMap["kubeletConfig"] = mcappp.KubeletConfig
	}
	if mcappp.LinuxOSConfig != nil {
		objectMap["linuxOSConfig"] = mcappp.LinuxOSConfig
	}
	if mcappp.EnableEncryptionAtHost != nil {
		objectMap["enableEncryptionAtHost"] = mcappp.EnableEncryptionAtHost
	}
	if mcappp.EnableFIPS != nil {
		objectMap["enableFIPS"] = mcappp.EnableFIPS
	}
	if mcappp.GpuInstanceProfile != "" {
		objectMap["gpuInstanceProfile"] = mcappp.GpuInstanceProfile
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAPIServerAccessProfile access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// AuthorizedIPRanges - Authorized IP Ranges to kubernetes API server.
	AuthorizedIPRanges *[]string `json:"authorizedIPRanges,omitempty"`
	// EnablePrivateCluster - Whether to create the cluster as a private cluster or not.
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`
	// PrivateDNSZone - Private dns zone mode for private cluster.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`
}

// ManagedClusterAutoUpgradeProfile auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// UpgradeChannel - upgrade channel for auto upgrade. Possible values include: 'UpgradeChannelRapid', 'UpgradeChannelStable', 'UpgradeChannelPatch', 'UpgradeChannelNodeImage', 'UpgradeChannelNone'
	UpgradeChannel UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterHTTPProxyConfig configurations for provisioning the cluster with HTTP proxy servers.
type ManagedClusterHTTPProxyConfig struct {
	// HTTPProxy - HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`
	// HTTPSProxy - HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`
	// NoProxy - Endpoints that should not go through proxy.
	NoProxy *[]string `json:"noProxy,omitempty"`
	// TrustedCa - Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`
}

// ManagedClusterIdentity identity for the managed cluster.
type ManagedClusterIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the managed cluster. Type 'SystemAssigned' will use an implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The user identity associated with the managed cluster. This identity will be used in control plane and only one user assigned identity is allowed. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedClusterIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedClusterIdentity.
func (mci ManagedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mci.Type != "" {
		objectMap["type"] = mci.Type
	}
	if mci.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = mci.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedClusterIdentityUserAssignedIdentitiesValue ...
type ManagedClusterIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// ManagedClusterListResult the response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed clusters.
	Value *[]ManagedCluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterListResult.
func (mclr ManagedClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mclr.Value != nil {
		objectMap["value"] = mclr.Value
	}
	return json.Marshal(objectMap)
}

// ManagedClusterListResultIterator provides access to a complete listing of ManagedCluster values.
type ManagedClusterListResultIterator struct {
	i    int
	page ManagedClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedClusterListResultIterator) Response() ManagedClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedClusterListResultIterator) Value() ManagedCluster {
	if !iter.page.NotDone() {
		return ManagedCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedClusterListResultIterator type.
func NewManagedClusterListResultIterator(page ManagedClusterListResultPage) ManagedClusterListResultIterator {
	return ManagedClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr ManagedClusterListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mclr ManagedClusterListResult) hasNextLink() bool {
	return mclr.NextLink != nil && len(*mclr.NextLink) != 0
}

// managedClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr ManagedClusterListResult) managedClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// ManagedClusterListResultPage contains a page of ManagedCluster values.
type ManagedClusterListResultPage struct {
	fn   func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)
	mclr ManagedClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mclr)
		if err != nil {
			return err
		}
		page.mclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedClusterListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedClusterListResultPage) Response() ManagedClusterListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedClusterListResultPage) Values() []ManagedCluster {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the ManagedClusterListResultPage type.
func NewManagedClusterListResultPage(cur ManagedClusterListResult, getNextPage func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)) ManagedClusterListResultPage {
	return ManagedClusterListResultPage{
		fn:   getNextPage,
		mclr: cur,
	}
}

// ManagedClusterLoadBalancerProfile profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// ManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`
	// OutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`
	// OutboundIPs - Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
	// EffectiveOutboundIPs - The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs *[]ResourceReference `json:"effectiveOutboundIPs,omitempty"`
	// AllocatedOutboundPorts - Desired number of allocated SNAT ports per VM. Allowed values must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// IdleTimeoutInMinutes - Desired outbound flow idle timeout in minutes. Allowed values must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs desired managed outbound IPs for the cluster load
// balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// Count - Desired number of outbound IP created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes desired outbound IP Prefix resources for the cluster
// load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// PublicIPPrefixes - A list of public IP prefix resources.
	PublicIPPrefixes *[]ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPs desired outbound IP resources for the cluster load
// balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// PublicIPs - A list of public IP resources.
	PublicIPs *[]ResourceReference `json:"publicIPs,omitempty"`
}

// ManagedClusterPodIdentity ...
type ManagedClusterPodIdentity struct {
	// Name - Name of the pod identity.
	Name *string `json:"name,omitempty"`
	// Namespace - Namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`
	// BindingSelector - Binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string `json:"bindingSelector,omitempty"`
	// Identity - Information of the user assigned identity.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`
	// ProvisioningState - READ-ONLY; The current provisioning state of the pod identity. Possible values include: 'Assigned', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningInfo - READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterPodIdentity.
func (mcpi ManagedClusterPodIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcpi.Name != nil {
		objectMap["name"] = mcpi.Name
	}
	if mcpi.Namespace != nil {
		objectMap["namespace"] = mcpi.Namespace
	}
	if mcpi.BindingSelector != nil {
		objectMap["bindingSelector"] = mcpi.BindingSelector
	}
	if mcpi.Identity != nil {
		objectMap["identity"] = mcpi.Identity
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityException ...
type ManagedClusterPodIdentityException struct {
	// Name - Name of the pod identity exception.
	Name *string `json:"name,omitempty"`
	// Namespace - Namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`
	// PodLabels - Pod labels to match.
	PodLabels map[string]*string `json:"podLabels"`
}

// MarshalJSON is the custom marshaler for ManagedClusterPodIdentityException.
func (mcpie ManagedClusterPodIdentityException) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcpie.Name != nil {
		objectMap["name"] = mcpie.Name
	}
	if mcpie.Namespace != nil {
		objectMap["namespace"] = mcpie.Namespace
	}
	if mcpie.PodLabels != nil {
		objectMap["podLabels"] = mcpie.PodLabels
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityProfile ...
type ManagedClusterPodIdentityProfile struct {
	// Enabled - Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// AllowNetworkPluginKubenet - Customer consent for enabling AAD pod identity addon in cluster using Kubenet network plugin.
	AllowNetworkPluginKubenet *bool `json:"allowNetworkPluginKubenet,omitempty"`
	// UserAssignedIdentities - User assigned pod identity settings.
	UserAssignedIdentities *[]ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`
	// UserAssignedIdentityExceptions - User assigned pod identity exception settings.
	UserAssignedIdentityExceptions *[]ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

// ManagedClusterPodIdentityProvisioningInfo ...
type ManagedClusterPodIdentityProvisioningInfo struct {
	// Error - Pod identity assignment error (if any).
	Error *CloudError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile the list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// Name - Pool name.
	Name *string `json:"name,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

// ManagedClusterPoolUpgradeProfileUpgradesItem ...
type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// ManagedClusterProperties properties of the managed cluster.
type ManagedClusterProperties struct {
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - READ-ONLY; Represents the Power State of the cluster
	PowerState *PowerState `json:"powerState,omitempty"`
	// MaxAgentPools - READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty"`
	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// DNSPrefix - DNS prefix specified when creating the managed cluster.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// FqdnSubdomain - FQDN subdomain specified when creating private cluster with custom private dns zone.
	FqdnSubdomain *string `json:"fqdnSubdomain,omitempty"`
	// Fqdn - READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// PrivateFQDN - READ-ONLY; FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty"`
	// AzurePortalFQDN - READ-ONLY; FQDN for the master pool which used by proxy config.
	AzurePortalFQDN *string `json:"azurePortalFQDN,omitempty"`
	// AgentPoolProfiles - Properties of the agent pool.
	AgentPoolProfiles *[]ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// LinuxProfile - Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// WindowsProfile - Profile for Windows VMs in the container service cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	// AddonProfiles - Profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles"`
	// PodIdentityProfile - Profile of managed cluster pod identity.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`
	// NodeResourceGroup - Name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`
	// EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`
	// EnablePodSecurityPolicy - (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`
	// NetworkProfile - Profile of network configuration.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// AadProfile - Profile of Azure Active Directory configuration.
	AadProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`
	// AutoUpgradeProfile - Profile of auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`
	// AutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`
	// APIServerAccessProfile - Access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`
	// DiskEncryptionSetID - ResourceId of the disk encryption set to use for enabling encryption at rest.
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`
	// IdentityProfile - Identities associated with the cluster.
	IdentityProfile map[string]*ManagedClusterPropertiesIdentityProfileValue `json:"identityProfile"`
	// PrivateLinkResources - Private link resources associated with the cluster.
	PrivateLinkResources *[]PrivateLinkResource `json:"privateLinkResources,omitempty"`
	// DisableLocalAccounts - If set to true, getting static credential will be disabled for this cluster. Expected to only be used for AAD clusters.
	DisableLocalAccounts *bool `json:"disableLocalAccounts,omitempty"`
	// HTTPProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig `json:"httpProxyConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterProperties.
func (mcp ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcp.KubernetesVersion != nil {
		objectMap["kubernetesVersion"] = mcp.KubernetesVersion
	}
	if mcp.DNSPrefix != nil {
		objectMap["dnsPrefix"] = mcp.DNSPrefix
	}
	if mcp.FqdnSubdomain != nil {
		objectMap["fqdnSubdomain"] = mcp.FqdnSubdomain
	}
	if mcp.AgentPoolProfiles != nil {
		objectMap["agentPoolProfiles"] = mcp.AgentPoolProfiles
	}
	if mcp.LinuxProfile != nil {
		objectMap["linuxProfile"] = mcp.LinuxProfile
	}
	if mcp.WindowsProfile != nil {
		objectMap["windowsProfile"] = mcp.WindowsProfile
	}
	if mcp.ServicePrincipalProfile != nil {
		objectMap["servicePrincipalProfile"] = mcp.ServicePrincipalProfile
	}
	if mcp.AddonProfiles != nil {
		objectMap["addonProfiles"] = mcp.AddonProfiles
	}
	if mcp.PodIdentityProfile != nil {
		objectMap["podIdentityProfile"] = mcp.PodIdentityProfile
	}
	if mcp.NodeResourceGroup != nil {
		objectMap["nodeResourceGroup"] = mcp.NodeResourceGroup
	}
	if mcp.EnableRBAC != nil {
		objectMap["enableRBAC"] = mcp.EnableRBAC
	}
	if mcp.EnablePodSecurityPolicy != nil {
		objectMap["enablePodSecurityPolicy"] = mcp.EnablePodSecurityPolicy
	}
	if mcp.NetworkProfile != nil {
		objectMap["networkProfile"] = mcp.NetworkProfile
	}
	if mcp.AadProfile != nil {
		objectMap["aadProfile"] = mcp.AadProfile
	}
	if mcp.AutoUpgradeProfile != nil {
		objectMap["autoUpgradeProfile"] = mcp.AutoUpgradeProfile
	}
	if mcp.AutoScalerProfile != nil {
		objectMap["autoScalerProfile"] = mcp.AutoScalerProfile
	}
	if mcp.APIServerAccessProfile != nil {
		objectMap["apiServerAccessProfile"] = mcp.APIServerAccessProfile
	}
	if mcp.DiskEncryptionSetID != nil {
		objectMap["diskEncryptionSetID"] = mcp.DiskEncryptionSetID
	}
	if mcp.IdentityProfile != nil {
		objectMap["identityProfile"] = mcp.IdentityProfile
	}
	if mcp.PrivateLinkResources != nil {
		objectMap["privateLinkResources"] = mcp.PrivateLinkResources
	}
	if mcp.DisableLocalAccounts != nil {
		objectMap["disableLocalAccounts"] = mcp.DisableLocalAccounts
	}
	if mcp.HTTPProxyConfig != nil {
		objectMap["httpProxyConfig"] = mcp.HTTPProxyConfig
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPropertiesAutoScalerProfile parameters to be applied to the cluster-autoscaler when
// enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	BalanceSimilarNodeGroups *string `json:"balance-similar-node-groups,omitempty"`
	// Expander - Possible values include: 'LeastWaste', 'MostPods', 'Priority', 'Random'
	Expander                      Expander `json:"expander,omitempty"`
	MaxEmptyBulkDelete            *string  `json:"max-empty-bulk-delete,omitempty"`
	MaxGracefulTerminationSec     *string  `json:"max-graceful-termination-sec,omitempty"`
	MaxNodeProvisionTime          *string  `json:"max-node-provision-time,omitempty"`
	MaxTotalUnreadyPercentage     *string  `json:"max-total-unready-percentage,omitempty"`
	NewPodScaleUpDelay            *string  `json:"new-pod-scale-up-delay,omitempty"`
	OkTotalUnreadyCount           *string  `json:"ok-total-unready-count,omitempty"`
	ScanInterval                  *string  `json:"scan-interval,omitempty"`
	ScaleDownDelayAfterAdd        *string  `json:"scale-down-delay-after-add,omitempty"`
	ScaleDownDelayAfterDelete     *string  `json:"scale-down-delay-after-delete,omitempty"`
	ScaleDownDelayAfterFailure    *string  `json:"scale-down-delay-after-failure,omitempty"`
	ScaleDownUnneededTime         *string  `json:"scale-down-unneeded-time,omitempty"`
	ScaleDownUnreadyTime          *string  `json:"scale-down-unready-time,omitempty"`
	ScaleDownUtilizationThreshold *string  `json:"scale-down-utilization-threshold,omitempty"`
	SkipNodesWithLocalStorage     *string  `json:"skip-nodes-with-local-storage,omitempty"`
	SkipNodesWithSystemPods       *string  `json:"skip-nodes-with-system-pods,omitempty"`
}

// ManagedClusterPropertiesIdentityProfileValue ...
type ManagedClusterPropertiesIdentityProfileValue struct {
	// ResourceID - The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
	// ClientID - The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`
}

// ManagedClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (ManagedCluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersCreateOrUpdateFuture.Result.
func (future *ManagedClustersCreateOrUpdateFuture) result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.CreateOrUpdateResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersDeleteFuture.Result.
func (future *ManagedClustersDeleteFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClusterServicePrincipalProfile information about a service principal identity for the cluster to
// use for manipulating Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// ClientID - The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterSKU ...
type ManagedClusterSKU struct {
	// Name - Name of a managed cluster SKU. Possible values include: 'ManagedClusterSKUNameBasic'
	Name ManagedClusterSKUName `json:"name,omitempty"`
	// Tier - Tier of a managed cluster SKU. Possible values include: 'Paid', 'Free'
	Tier ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClustersResetAADProfileFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersResetAADProfileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersResetAADProfileFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersResetAADProfileFuture.Result.
func (future *ManagedClustersResetAADProfileFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersResetAADProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersResetAADProfileFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersResetServicePrincipalProfileFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedClustersResetServicePrincipalProfileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersResetServicePrincipalProfileFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersResetServicePrincipalProfileFuture.Result.
func (future *ManagedClustersResetServicePrincipalProfileFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersResetServicePrincipalProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersResetServicePrincipalProfileFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersRotateClusterCertificatesFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ManagedClustersRotateClusterCertificatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersRotateClusterCertificatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersRotateClusterCertificatesFuture.Result.
func (future *ManagedClustersRotateClusterCertificatesFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRotateClusterCertificatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersRotateClusterCertificatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersRunCommandFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersRunCommandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (RunCommandResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersRunCommandFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersRunCommandFuture.Result.
func (future *ManagedClustersRunCommandFuture) result(client ManagedClustersClient) (rcr RunCommandResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRunCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersRunCommandFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rcr.Response.Response, err = future.GetResult(sender); err == nil && rcr.Response.Response.StatusCode != http.StatusNoContent {
		rcr, err = client.RunCommandResponder(rcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRunCommandFuture", "Result", rcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClustersStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersStartFuture.Result.
func (future *ManagedClustersStartFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersStopFuture.Result.
func (future *ManagedClustersStopFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (ManagedCluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersUpdateTagsFuture.Result.
func (future *ManagedClustersUpdateTagsFuture) result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.UpdateTagsResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClusterUpgradeProfile the list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Id of upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of upgrade profile.
	Type *string `json:"type,omitempty"`
	// ManagedClusterUpgradeProfileProperties - Properties of upgrade profile.
	*ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterUpgradeProfile.
func (mcup ManagedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcup.ManagedClusterUpgradeProfileProperties != nil {
		objectMap["properties"] = mcup.ManagedClusterUpgradeProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterUpgradeProfile struct.
func (mcup *ManagedClusterUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var managedClusterUpgradeProfileProperties ManagedClusterUpgradeProfileProperties
				err = json.Unmarshal(*v, &managedClusterUpgradeProfileProperties)
				if err != nil {
					return err
				}
				mcup.ManagedClusterUpgradeProfileProperties = &managedClusterUpgradeProfileProperties
			}
		}
	}

	return nil
}

// ManagedClusterUpgradeProfileProperties control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// ControlPlaneProfile - The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
	// AgentPoolProfiles - The list of available upgrade versions for agent pools.
	AgentPoolProfiles *[]ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`
}

// ManagedClusterWindowsProfile profile for Windows VMs in the container service cluster.
type ManagedClusterWindowsProfile struct {
	// AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`
	// LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'WindowsServer'
	LicenseType LicenseType `json:"licenseType,omitempty"`
	// EnableCSIProxy - Whether to enable CSI proxy.
	EnableCSIProxy *bool `json:"enableCSIProxy,omitempty"`
}

// MasterProfile profile for the container service master.
type MasterProfile struct {
	// Count - Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'StandardA1', 'StandardA10', 'StandardA11', 'StandardA1V2', 'StandardA2', 'StandardA2V2', 'StandardA2mV2', 'StandardA3', 'StandardA4', 'StandardA4V2', 'StandardA4mV2', 'StandardA5', 'StandardA6', 'StandardA7', 'StandardA8', 'StandardA8V2', 'StandardA8mV2', 'StandardA9', 'StandardB2ms', 'StandardB2s', 'StandardB4ms', 'StandardB8ms', 'StandardD1', 'StandardD11', 'StandardD11V2', 'StandardD11V2Promo', 'StandardD12', 'StandardD12V2', 'StandardD12V2Promo', 'StandardD13', 'StandardD13V2', 'StandardD13V2Promo', 'StandardD14', 'StandardD14V2', 'StandardD14V2Promo', 'StandardD15V2', 'StandardD16V3', 'StandardD16sV3', 'StandardD1V2', 'StandardD2', 'StandardD2V2', 'StandardD2V2Promo', 'StandardD2V3', 'StandardD2sV3', 'StandardD3', 'StandardD32V3', 'StandardD32sV3', 'StandardD3V2', 'StandardD3V2Promo', 'StandardD4', 'StandardD4V2', 'StandardD4V2Promo', 'StandardD4V3', 'StandardD4sV3', 'StandardD5V2', 'StandardD5V2Promo', 'StandardD64V3', 'StandardD64sV3', 'StandardD8V3', 'StandardD8sV3', 'StandardDS1', 'StandardDS11', 'StandardDS11V2', 'StandardDS11V2Promo', 'StandardDS12', 'StandardDS12V2', 'StandardDS12V2Promo', 'StandardDS13', 'StandardDS132V2', 'StandardDS134V2', 'StandardDS13V2', 'StandardDS13V2Promo', 'StandardDS14', 'StandardDS144V2', 'StandardDS148V2', 'StandardDS14V2', 'StandardDS14V2Promo', 'StandardDS15V2', 'StandardDS1V2', 'StandardDS2', 'StandardDS2V2', 'StandardDS2V2Promo', 'StandardDS3', 'StandardDS3V2', 'StandardDS3V2Promo', 'StandardDS4', 'StandardDS4V2', 'StandardDS4V2Promo', 'StandardDS5V2', 'StandardDS5V2Promo', 'StandardE16V3', 'StandardE16sV3', 'StandardE2V3', 'StandardE2sV3', 'StandardE3216sV3', 'StandardE328sV3', 'StandardE32V3', 'StandardE32sV3', 'StandardE4V3', 'StandardE4sV3', 'StandardE6416sV3', 'StandardE6432sV3', 'StandardE64V3', 'StandardE64sV3', 'StandardE8V3', 'StandardE8sV3', 'StandardF1', 'StandardF16', 'StandardF16s', 'StandardF16sV2', 'StandardF1s', 'StandardF2', 'StandardF2s', 'StandardF2sV2', 'StandardF32sV2', 'StandardF4', 'StandardF4s', 'StandardF4sV2', 'StandardF64sV2', 'StandardF72sV2', 'StandardF8', 'StandardF8s', 'StandardF8sV2', 'StandardG1', 'StandardG2', 'StandardG3', 'StandardG4', 'StandardG5', 'StandardGS1', 'StandardGS2', 'StandardGS3', 'StandardGS4', 'StandardGS44', 'StandardGS48', 'StandardGS5', 'StandardGS516', 'StandardGS58', 'StandardH16', 'StandardH16m', 'StandardH16mr', 'StandardH16r', 'StandardH8', 'StandardH8m', 'StandardL16s', 'StandardL32s', 'StandardL4s', 'StandardL8s', 'StandardM12832ms', 'StandardM12864ms', 'StandardM128ms', 'StandardM128s', 'StandardM6416ms', 'StandardM6432ms', 'StandardM64ms', 'StandardM64s', 'StandardNC12', 'StandardNC12sV2', 'StandardNC12sV3', 'StandardNC24', 'StandardNC24r', 'StandardNC24rsV2', 'StandardNC24rsV3', 'StandardNC24sV2', 'StandardNC24sV3', 'StandardNC6', 'StandardNC6sV2', 'StandardNC6sV3', 'StandardND12s', 'StandardND24rs', 'StandardND24s', 'StandardND6s', 'StandardNV12', 'StandardNV24', 'StandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// FirstConsecutiveStaticIP - FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageAccount', 'ManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// Fqdn - READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for MasterProfile.
func (mp MasterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.Count != nil {
		objectMap["count"] = mp.Count
	}
	if mp.DNSPrefix != nil {
		objectMap["dnsPrefix"] = mp.DNSPrefix
	}
	if mp.VMSize != "" {
		objectMap["vmSize"] = mp.VMSize
	}
	if mp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mp.OsDiskSizeGB
	}
	if mp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mp.VnetSubnetID
	}
	if mp.FirstConsecutiveStaticIP != nil {
		objectMap["firstConsecutiveStaticIP"] = mp.FirstConsecutiveStaticIP
	}
	if mp.StorageProfile != "" {
		objectMap["storageProfile"] = mp.StorageProfile
	}
	return json.Marshal(objectMap)
}

// NetworkProfile profile of network configuration.
type NetworkProfile struct {
	// NetworkPlugin - Network plugin used for building Kubernetes network. Possible values include: 'Azure', 'Kubenet'
	NetworkPlugin NetworkPlugin `json:"networkPlugin,omitempty"`
	// NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'NetworkPolicyCalico', 'NetworkPolicyAzure'
	NetworkPolicy NetworkPolicy `json:"networkPolicy,omitempty"`
	// NetworkMode - Network mode used for building Kubernetes network. Possible values include: 'Transparent', 'Bridge'
	NetworkMode NetworkMode `json:"networkMode,omitempty"`
	// PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
	// OutboundType - The outbound (egress) routing method. Possible values include: 'LoadBalancer', 'UserDefinedRouting'
	OutboundType OutboundType `json:"outboundType,omitempty"`
	// LoadBalancerSku - The load balancer sku for the managed cluster. Possible values include: 'Standard', 'Basic'
	LoadBalancerSku LoadBalancerSku `json:"loadBalancerSku,omitempty"`
	// LoadBalancerProfile - Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`
}

// OperationListResult the List Compute Operation operation response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of compute operations
	Value *[]OperationValue `json:"value,omitempty"`
}

// OperationValue describes the properties of a Compute Operation value.
type OperationValue struct {
	// Origin - READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty"`
	// Name - READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty"`
	// OperationValueDisplay - Describes the properties of a Compute Operation Value Display.
	*OperationValueDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValue.
func (ov OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.OperationValueDisplay != nil {
		objectMap["display"] = ov.OperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationValue struct.
func (ov *OperationValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ov.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ov.Name = &name
			}
		case "display":
			if v != nil {
				var operationValueDisplay OperationValueDisplay
				err = json.Unmarshal(*v, &operationValueDisplay)
				if err != nil {
					return err
				}
				ov.OperationValueDisplay = &operationValueDisplay
			}
		}
	}

	return nil
}

// OperationValueDisplay describes the properties of a Compute Operation Value Display.
type OperationValueDisplay struct {
	// Operation - READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// OSOptionProfile the OS option profile.
type OSOptionProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Id of the OS option profile.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the OS option profile.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the OS option profile.
	Type *string `json:"type,omitempty"`
	// OSOptionPropertyList - The list of an OS option properties.
	*OSOptionPropertyList `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OSOptionProfile.
func (oop OSOptionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oop.OSOptionPropertyList != nil {
		objectMap["properties"] = oop.OSOptionPropertyList
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OSOptionProfile struct.
func (oop *OSOptionProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oop.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oop.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oop.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var oSOptionPropertyList OSOptionPropertyList
				err = json.Unmarshal(*v, &oSOptionPropertyList)
				if err != nil {
					return err
				}
				oop.OSOptionPropertyList = &oSOptionPropertyList
			}
		}
	}

	return nil
}

// OSOptionProperty OS option property.
type OSOptionProperty struct {
	// OsType - OS type.
	OsType *string `json:"os-type,omitempty"`
	// EnableFipsImage - Whether FIPS image is enabled.
	EnableFipsImage *bool `json:"enable-fips-image,omitempty"`
}

// OSOptionPropertyList the list of OS option properties.
type OSOptionPropertyList struct {
	// OsOptionPropertyList - The list of OS option properties.
	OsOptionPropertyList *[]OSOptionProperty `json:"osOptionPropertyList,omitempty"`
}

// PowerState describes the Power State of the cluster
type PowerState struct {
	// Code - Tells whether the cluster is Running or Stopped. Possible values include: 'Running', 'Stopped'
	Code Code `json:"code,omitempty"`
}

// PrivateEndpoint private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// ID - The resource Id for private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// PrivateEndpointConnectionProperties - The properties of a private endpoint connection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The current provisioning state. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpoint - The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// ID - The ID of the private link resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the private link resource.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// GroupID - The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - RequiredMembers of the resource
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// PrivateLinkServiceID - READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.ID != nil {
		objectMap["id"] = plr.ID
	}
	if plr.Name != nil {
		objectMap["name"] = plr.Name
	}
	if plr.Type != nil {
		objectMap["type"] = plr.Type
	}
	if plr.GroupID != nil {
		objectMap["groupId"] = plr.GroupID
	}
	if plr.RequiredMembers != nil {
		objectMap["requiredMembers"] = plr.RequiredMembers
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResourcesListResult a list of private link resources
type PrivateLinkResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState the state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// Status - The private link service connection status. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	Status ConnectionStatus `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceReference a reference to an Azure resource.
type ResourceReference struct {
	// ID - The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// RunCommandRequest run command request
type RunCommandRequest struct {
	// Command - command to run.
	Command *string `json:"command,omitempty"`
	// Context - base64 encoded zip file, contains files required by the command
	Context *string `json:"context,omitempty"`
	// ClusterToken - AuthToken issued for AKS AAD Server App.
	ClusterToken *string `json:"clusterToken,omitempty"`
}

// RunCommandResult run command result.
type RunCommandResult struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; command id.
	ID *string `json:"id,omitempty"`
	// CommandResultProperties - Properties of command result.
	*CommandResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RunCommandResult.
func (rcr RunCommandResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcr.CommandResultProperties != nil {
		objectMap["properties"] = rcr.CommandResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunCommandResult struct.
func (rcr *RunCommandResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcr.ID = &ID
			}
		case "properties":
			if v != nil {
				var commandResultProperties CommandResultProperties
				err = json.Unmarshal(*v, &commandResultProperties)
				if err != nil {
					return err
				}
				rcr.CommandResultProperties = &commandResultProperties
			}
		}
	}

	return nil
}

// SSHConfiguration SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// SubResource reference to another subresource.
type SubResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// SysctlConfig sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// NetCoreSomaxconn - Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`
	// NetCoreNetdevMaxBacklog - Sysctl setting net.core.netdev_max_backlog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`
	// NetCoreRmemDefault - Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32 `json:"netCoreRmemDefault,omitempty"`
	// NetCoreRmemMax - Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`
	// NetCoreWmemDefault - Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32 `json:"netCoreWmemDefault,omitempty"`
	// NetCoreWmemMax - Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`
	// NetCoreOptmemMax - Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`
	// NetIpv4TCPMaxSynBacklog - Sysctl setting net.ipv4.tcp_max_syn_backlog.
	NetIpv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`
	// NetIpv4TCPMaxTwBuckets - Sysctl setting net.ipv4.tcp_max_tw_buckets.
	NetIpv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`
	// NetIpv4TCPFinTimeout - Sysctl setting net.ipv4.tcp_fin_timeout.
	NetIpv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`
	// NetIpv4TCPKeepaliveTime - Sysctl setting net.ipv4.tcp_keepalive_time.
	NetIpv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`
	// NetIpv4TCPKeepaliveProbes - Sysctl setting net.ipv4.tcp_keepalive_probes.
	NetIpv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`
	// NetIpv4TcpkeepaliveIntvl - Sysctl setting net.ipv4.tcp_keepalive_intvl.
	NetIpv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`
	// NetIpv4TCPTwReuse - Sysctl setting net.ipv4.tcp_tw_reuse.
	NetIpv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`
	// NetIpv4IPLocalPortRange - Sysctl setting net.ipv4.ip_local_port_range.
	NetIpv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`
	// NetIpv4NeighDefaultGcThresh1 - Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIpv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`
	// NetIpv4NeighDefaultGcThresh2 - Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIpv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`
	// NetIpv4NeighDefaultGcThresh3 - Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIpv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`
	// NetNetfilterNfConntrackMax - Sysctl setting net.netfilter.nf_conntrack_max.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`
	// NetNetfilterNfConntrackBuckets - Sysctl setting net.netfilter.nf_conntrack_buckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`
	// FsInotifyMaxUserWatches - Sysctl setting fs.inotify.max_user_watches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`
	// FsFileMax - Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`
	// FsAioMaxNr - Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`
	// FsNrOpen - Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`
	// KernelThreadsMax - Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`
	// VMMaxMapCount - Sysctl setting vm.max_map_count.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`
	// VMSwappiness - Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`
	// VMVfsCachePressure - Sysctl setting vm.vfs_cache_pressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The type of identity that last modified the resource.
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// TimeInWeek time in a week.
type TimeInWeek struct {
	// Day - A day in a week. Possible values include: 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'
	Day WeekDay `json:"day,omitempty"`
	// HourSlots - hour slots in a day.
	HourSlots *[]int32 `json:"hourSlots,omitempty"`
}

// TimeSpan the time span with start and end properties.
type TimeSpan struct {
	// Start - The start of a time span
	Start *date.Time `json:"start,omitempty"`
	// End - The end of a time span
	End *date.Time `json:"end,omitempty"`
}

// UserAssignedIdentity ...
type UserAssignedIdentity struct {
	// ResourceID - The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
	// ClientID - The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`
}

// VMDiagnostics profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// Enabled - Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageURI - READ-ONLY; The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty"`
}

// MarshalJSON is the custom marshaler for VMDiagnostics.
func (vd VMDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vd.Enabled != nil {
		objectMap["enabled"] = vd.Enabled
	}
	return json.Marshal(objectMap)
}
