// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisableVpcClassicLinkDnsSupportInput struct {
	_ struct{} `type:"structure"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DisableVpcClassicLinkDnsSupportInput) String() string {
	return awsutil.Prettify(s)
}

type DisableVpcClassicLinkDnsSupportOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DisableVpcClassicLinkDnsSupportOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableVpcClassicLinkDnsSupport = "DisableVpcClassicLinkDnsSupport"

// DisableVpcClassicLinkDnsSupportRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve
// to public IP addresses when addressed between a linked EC2-Classic instance
// and instances in the VPC to which it's linked. For more information, see
// ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using DisableVpcClassicLinkDnsSupportRequest.
//    req := client.DisableVpcClassicLinkDnsSupportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupport
func (c *Client) DisableVpcClassicLinkDnsSupportRequest(input *DisableVpcClassicLinkDnsSupportInput) DisableVpcClassicLinkDnsSupportRequest {
	op := &aws.Operation{
		Name:       opDisableVpcClassicLinkDnsSupport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVpcClassicLinkDnsSupportInput{}
	}

	req := c.newRequest(op, input, &DisableVpcClassicLinkDnsSupportOutput{})
	return DisableVpcClassicLinkDnsSupportRequest{Request: req, Input: input, Copy: c.DisableVpcClassicLinkDnsSupportRequest}
}

// DisableVpcClassicLinkDnsSupportRequest is the request type for the
// DisableVpcClassicLinkDnsSupport API operation.
type DisableVpcClassicLinkDnsSupportRequest struct {
	*aws.Request
	Input *DisableVpcClassicLinkDnsSupportInput
	Copy  func(*DisableVpcClassicLinkDnsSupportInput) DisableVpcClassicLinkDnsSupportRequest
}

// Send marshals and sends the DisableVpcClassicLinkDnsSupport API request.
func (r DisableVpcClassicLinkDnsSupportRequest) Send(ctx context.Context) (*DisableVpcClassicLinkDnsSupportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableVpcClassicLinkDnsSupportResponse{
		DisableVpcClassicLinkDnsSupportOutput: r.Request.Data.(*DisableVpcClassicLinkDnsSupportOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableVpcClassicLinkDnsSupportResponse is the response type for the
// DisableVpcClassicLinkDnsSupport API operation.
type DisableVpcClassicLinkDnsSupportResponse struct {
	*DisableVpcClassicLinkDnsSupportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableVpcClassicLinkDnsSupport request.
func (r *DisableVpcClassicLinkDnsSupportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
