// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job to delete.
	//
	// ForecastExportJobArn is a required field
	ForecastExportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteForecastExportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteForecastExportJobInput"}

	if s.ForecastExportJobArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastExportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteForecastExportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteForecastExportJob = "DeleteForecastExportJob"

// DeleteForecastExportJobRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Deletes a forecast export job created using the CreateForecastExportJob operation.
// You can delete only export jobs that have a status of ACTIVE or CREATE_FAILED.
// To get the status, use the DescribeForecastExportJob operation.
//
//    // Example sending a request using DeleteForecastExportJobRequest.
//    req := client.DeleteForecastExportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecastExportJob
func (c *Client) DeleteForecastExportJobRequest(input *DeleteForecastExportJobInput) DeleteForecastExportJobRequest {
	op := &aws.Operation{
		Name:       opDeleteForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteForecastExportJobInput{}
	}

	req := c.newRequest(op, input, &DeleteForecastExportJobOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteForecastExportJobRequest{Request: req, Input: input, Copy: c.DeleteForecastExportJobRequest}
}

// DeleteForecastExportJobRequest is the request type for the
// DeleteForecastExportJob API operation.
type DeleteForecastExportJobRequest struct {
	*aws.Request
	Input *DeleteForecastExportJobInput
	Copy  func(*DeleteForecastExportJobInput) DeleteForecastExportJobRequest
}

// Send marshals and sends the DeleteForecastExportJob API request.
func (r DeleteForecastExportJobRequest) Send(ctx context.Context) (*DeleteForecastExportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteForecastExportJobResponse{
		DeleteForecastExportJobOutput: r.Request.Data.(*DeleteForecastExportJobOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteForecastExportJobResponse is the response type for the
// DeleteForecastExportJob API operation.
type DeleteForecastExportJobResponse struct {
	*DeleteForecastExportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteForecastExportJob request.
func (r *DeleteForecastExportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
