// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateGlobalNetworkInput struct {
	_ struct{} `type:"structure"`

	// A description of the global network.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The tags to apply to the resource during creation.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateGlobalNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGlobalNetworkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type CreateGlobalNetworkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the global network object.
	GlobalNetwork *GlobalNetwork `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGlobalNetworkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GlobalNetwork != nil {
		v := s.GlobalNetwork

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GlobalNetwork", v, metadata)
	}
	return nil
}

const opCreateGlobalNetwork = "CreateGlobalNetwork"

// CreateGlobalNetworkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Creates a new, empty global network.
//
//    // Example sending a request using CreateGlobalNetworkRequest.
//    req := client.CreateGlobalNetworkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateGlobalNetwork
func (c *Client) CreateGlobalNetworkRequest(input *CreateGlobalNetworkInput) CreateGlobalNetworkRequest {
	op := &aws.Operation{
		Name:       opCreateGlobalNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks",
	}

	if input == nil {
		input = &CreateGlobalNetworkInput{}
	}

	req := c.newRequest(op, input, &CreateGlobalNetworkOutput{})
	return CreateGlobalNetworkRequest{Request: req, Input: input, Copy: c.CreateGlobalNetworkRequest}
}

// CreateGlobalNetworkRequest is the request type for the
// CreateGlobalNetwork API operation.
type CreateGlobalNetworkRequest struct {
	*aws.Request
	Input *CreateGlobalNetworkInput
	Copy  func(*CreateGlobalNetworkInput) CreateGlobalNetworkRequest
}

// Send marshals and sends the CreateGlobalNetwork API request.
func (r CreateGlobalNetworkRequest) Send(ctx context.Context) (*CreateGlobalNetworkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGlobalNetworkResponse{
		CreateGlobalNetworkOutput: r.Request.Data.(*CreateGlobalNetworkOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGlobalNetworkResponse is the response type for the
// CreateGlobalNetwork API operation.
type CreateGlobalNetworkResponse struct {
	*CreateGlobalNetworkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGlobalNetwork request.
func (r *CreateGlobalNetworkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
